/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.filters.FilterBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.http.Parameters;

public class FailedRequestFilter
extends FilterBase {
    private static final Log log = LogFactory.getLog(FailedRequestFilter.class);

    @Override
    protected Log getLogger() {
        return log;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.isGoodRequest(request)) {
            int status;
            Parameters.FailReason reason = (Parameters.FailReason)((Object)request.getAttribute("org.apache.catalina.parameter_parse_failed_reason"));
            switch (reason) {
                case IO_ERROR: {
                    status = 500;
                    break;
                }
                case POST_TOO_LARGE: {
                    status = 413;
                    break;
                }
                default: {
                    status = 400;
                }
            }
            ((HttpServletResponse)response).sendError(status);
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean isGoodRequest(ServletRequest request) {
        request.getParameter("none");
        return request.getAttribute("org.apache.catalina.parameter_parse_failed") == null;
    }

    @Override
    protected boolean isConfigProblemFatal() {
        return true;
    }
}

