/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.onionperf;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.impl.TorperfResultImpl;
import org.torproject.descriptor.onionperf.ParsedOnionPerfAnalysis;
import org.torproject.descriptor.onionperf.TorperfResultsBuilder;

public class OnionPerfAnalysisConverter {
    private final byte[] rawDescriptorBytes;
    private final File descriptorFile;
    private List<Descriptor> convertedTorperfResults;

    public OnionPerfAnalysisConverter(byte[] rawDescriptorBytes, File descriptorFile) {
        this.rawDescriptorBytes = rawDescriptorBytes;
        this.descriptorFile = descriptorFile;
    }

    public List<Descriptor> asTorperfResults() throws DescriptorParseException {
        ParsedOnionPerfAnalysis parsedOnionPerfAnalysis = this.parseOnionPerfAnalysis();
        this.verifyDocumentTypeAndVersion(parsedOnionPerfAnalysis);
        StringBuilder formattedTorperfResults = this.formatTorperfResults(parsedOnionPerfAnalysis);
        this.parseFormattedTorperfResults(formattedTorperfResults);
        return this.convertedTorperfResults;
    }

    private ParsedOnionPerfAnalysis parseOnionPerfAnalysis() throws DescriptorParseException {
        try {
            ByteArrayInputStream compressedInputStream = new ByteArrayInputStream(this.rawDescriptorBytes);
            XZCompressorInputStream decompressedInputStream = new XZCompressorInputStream(compressedInputStream);
            byte[] decompressedBytes = IOUtils.toByteArray(decompressedInputStream);
            return ParsedOnionPerfAnalysis.fromBytes(decompressedBytes);
        }
        catch (IOException ioException) {
            throw new DescriptorParseException("Ran into an I/O error while attempting to parse an OnionPerf analysis document.", ioException);
        }
    }

    private void verifyDocumentTypeAndVersion(ParsedOnionPerfAnalysis parsedOnionPerfAnalysis) throws DescriptorParseException {
        if (!"onionperf".equals(parsedOnionPerfAnalysis.type)) {
            throw new DescriptorParseException("Parsed OnionPerf analysis file does not contain type information.");
        }
        if (null == parsedOnionPerfAnalysis.version) {
            throw new DescriptorParseException("Parsed OnionPerf analysis file does not contain version information.");
        }
        if (parsedOnionPerfAnalysis.version instanceof Double && (Double)parsedOnionPerfAnalysis.version > 3.999 || parsedOnionPerfAnalysis.version instanceof String && ((String)parsedOnionPerfAnalysis.version).compareTo("4.") >= 0) {
            throw new DescriptorParseException("Parsed OnionPerf analysis file contains unsupported version " + parsedOnionPerfAnalysis.version + ".");
        }
    }

    private StringBuilder formatTorperfResults(ParsedOnionPerfAnalysis parsedOnionPerfAnalysis) {
        StringBuilder formattedTorperfResults = new StringBuilder();
        for (Map.Entry<String, ParsedOnionPerfAnalysis.MeasurementData> data : parsedOnionPerfAnalysis.data.entrySet()) {
            ParsedOnionPerfAnalysis.Circuit circuit;
            String sourcePort;
            String[] endpointLocalParts;
            TorperfResultsBuilder torperfResultsBuilder;
            String nickname = data.getKey();
            ParsedOnionPerfAnalysis.MeasurementData measurements = data.getValue();
            if (null == measurements.tgen) continue;
            String measurementIp = measurements.measurementIp;
            HashMap streamsBySourcePort = new HashMap();
            Map<Object, Object> circuitsByCircuitId = new HashMap();
            if (null != measurements.tor) {
                circuitsByCircuitId = measurements.tor.circuits;
                if (null != measurements.tor.streams) {
                    for (ParsedOnionPerfAnalysis.Stream stream : measurements.tor.streams.values()) {
                        if (null == stream.source || !stream.source.contains(":")) continue;
                        String sourcePort2 = stream.source.split(":")[1];
                        streamsBySourcePort.putIfAbsent(sourcePort2, new ArrayList());
                        ((List)streamsBySourcePort.get(sourcePort2)).add(stream);
                    }
                }
            }
            if (null != measurements.tgen.transfers) {
                for (ParsedOnionPerfAnalysis.Transfer transfer : measurements.tgen.transfers.values()) {
                    torperfResultsBuilder = new TorperfResultsBuilder();
                    torperfResultsBuilder.addString("SOURCE", nickname);
                    torperfResultsBuilder.addString("SOURCEADDRESS", measurementIp);
                    this.formatTransferParts(torperfResultsBuilder, transfer);
                    if (null != transfer.endpointLocal && (endpointLocalParts = transfer.endpointLocal.split(":")).length >= 3 && streamsBySourcePort.containsKey(sourcePort = endpointLocalParts[2])) {
                        for (ParsedOnionPerfAnalysis.Stream stream : (List)streamsBySourcePort.get(sourcePort)) {
                            if (!(Math.abs(transfer.unixTsEnd - stream.unixTsEnd) < 150.0)) continue;
                            this.formatStreamParts(torperfResultsBuilder, stream);
                            if (null == stream.circuitId || !circuitsByCircuitId.containsKey(stream.circuitId)) continue;
                            circuit = (ParsedOnionPerfAnalysis.Circuit)circuitsByCircuitId.get(stream.circuitId);
                            this.formatCircuitParts(torperfResultsBuilder, circuit);
                        }
                    }
                    formattedTorperfResults.append(torperfResultsBuilder.build());
                }
            }
            if (null == measurements.tgen.streams) continue;
            for (ParsedOnionPerfAnalysis.TgenStream tgenStream : measurements.tgen.streams.values()) {
                torperfResultsBuilder = new TorperfResultsBuilder();
                torperfResultsBuilder.addString("SOURCE", nickname);
                torperfResultsBuilder.addString("SOURCEADDRESS", measurementIp);
                this.formatTgenStreamParts(torperfResultsBuilder, tgenStream);
                if (null != tgenStream.transportInfo && null != tgenStream.transportInfo.local && (endpointLocalParts = tgenStream.transportInfo.local.split(":")).length >= 3 && streamsBySourcePort.containsKey(sourcePort = endpointLocalParts[2])) {
                    for (ParsedOnionPerfAnalysis.Stream torStream : (List)streamsBySourcePort.get(sourcePort)) {
                        if (!(Math.abs(tgenStream.unixTsEnd - torStream.unixTsEnd) < 150.0)) continue;
                        this.formatStreamParts(torperfResultsBuilder, torStream);
                        if (null == torStream.circuitId || !circuitsByCircuitId.containsKey(torStream.circuitId)) continue;
                        circuit = (ParsedOnionPerfAnalysis.Circuit)circuitsByCircuitId.get(torStream.circuitId);
                        this.formatCircuitParts(torperfResultsBuilder, circuit);
                    }
                }
                formattedTorperfResults.append(torperfResultsBuilder.build());
            }
        }
        return formattedTorperfResults;
    }

    private void parseFormattedTorperfResults(StringBuilder formattedTorperfResults) throws DescriptorParseException {
        this.convertedTorperfResults = TorperfResultImpl.parseTorperfResults(formattedTorperfResults.toString().getBytes(), this.descriptorFile);
    }

    private void formatTransferParts(TorperfResultsBuilder torperfResultsBuilder, ParsedOnionPerfAnalysis.Transfer transfer) {
        torperfResultsBuilder.addString("ENDPOINTLOCAL", transfer.endpointLocal);
        torperfResultsBuilder.addString("ENDPOINTPROXY", transfer.endpointProxy);
        torperfResultsBuilder.addString("ENDPOINTREMOTE", transfer.endpointRemote);
        torperfResultsBuilder.addString("HOSTNAMELOCAL", transfer.hostnameLocal);
        torperfResultsBuilder.addString("HOSTNAMEREMOTE", transfer.hostnameRemote);
        torperfResultsBuilder.addInteger("FILESIZE", transfer.filesizeBytes);
        torperfResultsBuilder.addInteger("READBYTES", transfer.totalBytesRead);
        torperfResultsBuilder.addInteger("WRITEBYTES", transfer.totalBytesWrite);
        torperfResultsBuilder.addInteger("DIDTIMEOUT", 0);
        for (String key : new String[]{"START", "SOCKET", "CONNECT", "NEGOTIATE", "REQUEST", "RESPONSE", "DATAREQUEST", "DATARESPONSE", "DATACOMPLETE", "LAUNCH", "DATAPERC10", "DATAPERC20", "DATAPERC30", "DATAPERC40", "DATAPERC50", "DATAPERC60", "DATAPERC70", "DATAPERC80", "DATAPERC90", "DATAPERC100"}) {
            torperfResultsBuilder.addString(key, "0.0");
        }
        torperfResultsBuilder.addTimestamp("START", transfer.unixTsStart, 0.0);
        if (null != transfer.unixTsStart && null != transfer.elapsedSeconds) {
            Double elapsedSeconds;
            torperfResultsBuilder.addTimestamp("SOCKET", transfer.unixTsStart, transfer.elapsedSeconds.socketCreate);
            torperfResultsBuilder.addTimestamp("CONNECT", transfer.unixTsStart, transfer.elapsedSeconds.socketConnect);
            torperfResultsBuilder.addTimestamp("NEGOTIATE", transfer.unixTsStart, transfer.elapsedSeconds.proxyChoice);
            torperfResultsBuilder.addTimestamp("REQUEST", transfer.unixTsStart, transfer.elapsedSeconds.proxyRequest);
            torperfResultsBuilder.addTimestamp("RESPONSE", transfer.unixTsStart, transfer.elapsedSeconds.proxyResponse);
            torperfResultsBuilder.addTimestamp("DATAREQUEST", transfer.unixTsStart, transfer.elapsedSeconds.command);
            torperfResultsBuilder.addTimestamp("DATARESPONSE", transfer.unixTsStart, transfer.elapsedSeconds.response);
            if (null != transfer.elapsedSeconds.payloadBytes) {
                for (Map.Entry entry : transfer.elapsedSeconds.payloadBytes.entrySet()) {
                    String key = String.format("PARTIAL%s", entry.getKey());
                    elapsedSeconds = (Double)entry.getValue();
                    torperfResultsBuilder.addTimestamp(key, transfer.unixTsStart, elapsedSeconds);
                }
            }
            if (null != transfer.elapsedSeconds.payloadProgress) {
                for (Map.Entry entry : transfer.elapsedSeconds.payloadProgress.entrySet()) {
                    String key = String.format("DATAPERC%.0f", Double.parseDouble((String)entry.getKey()) * 100.0);
                    elapsedSeconds = (Double)entry.getValue();
                    torperfResultsBuilder.addTimestamp(key, transfer.unixTsStart, elapsedSeconds);
                }
            }
            torperfResultsBuilder.addTimestamp("DATACOMPLETE", transfer.unixTsStart, transfer.elapsedSeconds.lastByte);
            if (transfer.isError.booleanValue()) {
                torperfResultsBuilder.addInteger("DIDTIMEOUT", 1);
                if ("PROXY".equals(transfer.errorCode)) {
                    torperfResultsBuilder.addErrorCodePart("TOR");
                } else {
                    torperfResultsBuilder.addErrorCodePart("TGEN");
                    torperfResultsBuilder.addErrorCodePart(transfer.errorCode);
                }
            }
        }
    }

    private void formatTgenStreamParts(TorperfResultsBuilder torperfResultsBuilder, ParsedOnionPerfAnalysis.TgenStream stream) {
        torperfResultsBuilder.addString("READBYTES", "0");
        torperfResultsBuilder.addString("WRITEBYTES", "0");
        if (null != stream.byteInfo) {
            torperfResultsBuilder.addString("READBYTES", stream.byteInfo.totalBytesRecv);
            torperfResultsBuilder.addString("WRITEBYTES", stream.byteInfo.totalBytesSend);
        }
        if (null != stream.streamInfo) {
            torperfResultsBuilder.addString("FILESIZE", stream.streamInfo.recvsize);
            torperfResultsBuilder.addString("HOSTNAMELOCAL", stream.streamInfo.name);
            torperfResultsBuilder.addString("HOSTNAMEREMOTE", stream.streamInfo.peername);
        }
        if (null != stream.transportInfo) {
            torperfResultsBuilder.addString("ENDPOINTLOCAL", stream.transportInfo.local);
            torperfResultsBuilder.addString("ENDPOINTPROXY", stream.transportInfo.proxy);
            torperfResultsBuilder.addString("ENDPOINTREMOTE", stream.transportInfo.remote);
        }
        torperfResultsBuilder.addInteger("DIDTIMEOUT", 0);
        for (String key : new String[]{"START", "SOCKET", "CONNECT", "NEGOTIATE", "REQUEST", "RESPONSE", "DATAREQUEST", "DATARESPONSE", "DATACOMPLETE"}) {
            torperfResultsBuilder.addString(key, "0.0");
        }
        torperfResultsBuilder.addTimestamp("START", stream.unixTsStart, 0.0);
        if (null != stream.unixTsStart) {
            if (null != stream.timeInfo) {
                torperfResultsBuilder.addTimestamp("SOCKET", stream.unixTsStart, stream.timeInfo.usecsToSocketCreate);
                torperfResultsBuilder.addTimestamp("CONNECT", stream.unixTsStart, stream.timeInfo.usecsToSocketConnect);
                torperfResultsBuilder.addTimestamp("NEGOTIATE", stream.unixTsStart, stream.timeInfo.usecsToProxyChoice);
                torperfResultsBuilder.addTimestamp("REQUEST", stream.unixTsStart, stream.timeInfo.usecsToProxyRequest);
                torperfResultsBuilder.addTimestamp("RESPONSE", stream.unixTsStart, stream.timeInfo.usecsToProxyResponse);
                torperfResultsBuilder.addTimestamp("DATAREQUEST", stream.unixTsStart, stream.timeInfo.usecsToCommand);
                torperfResultsBuilder.addTimestamp("DATARESPONSE", stream.unixTsStart, stream.timeInfo.usecsToResponse);
                torperfResultsBuilder.addTimestamp("DATACOMPLETE", stream.unixTsStart, stream.timeInfo.usecsToLastByteRecv);
            }
            if (null != stream.elapsedSeconds) {
                Double elapsedSeconds;
                if (null != stream.elapsedSeconds.payloadBytesRecv) {
                    for (Map.Entry entry : stream.elapsedSeconds.payloadBytesRecv.entrySet()) {
                        String key = String.format("PARTIAL%s", entry.getKey());
                        elapsedSeconds = (Double)entry.getValue();
                        torperfResultsBuilder.addTimestamp(key, stream.unixTsStart, elapsedSeconds);
                    }
                }
                if (null != stream.elapsedSeconds.payloadProgressRecv) {
                    for (Map.Entry entry : stream.elapsedSeconds.payloadProgressRecv.entrySet()) {
                        String key = String.format("DATAPERC%.0f", Double.parseDouble((String)entry.getKey()) * 100.0);
                        elapsedSeconds = (Double)entry.getValue();
                        torperfResultsBuilder.addTimestamp(key, stream.unixTsStart, elapsedSeconds);
                    }
                }
            }
            if (null != stream.isError && stream.isError.booleanValue()) {
                torperfResultsBuilder.addInteger("DIDTIMEOUT", 1);
                if ("PROXY".equals(stream.streamInfo.error)) {
                    torperfResultsBuilder.addErrorCodePart("TOR");
                } else {
                    torperfResultsBuilder.addErrorCodePart("TGEN");
                    torperfResultsBuilder.addErrorCodePart(stream.streamInfo.error);
                }
            }
        }
    }

    private void formatStreamParts(TorperfResultsBuilder torperfResultsBuilder, ParsedOnionPerfAnalysis.Stream stream) {
        if (null != stream.failureReasonLocal) {
            torperfResultsBuilder.addErrorCodePart(stream.failureReasonLocal);
            if (null != stream.failureReasonRemote) {
                torperfResultsBuilder.addErrorCodePart(stream.failureReasonRemote);
            }
        }
        torperfResultsBuilder.addTimestamp("USED_AT", stream.unixTsEnd, 0.0);
        torperfResultsBuilder.addInteger("USED_BY", stream.streamId);
    }

    private void formatCircuitParts(TorperfResultsBuilder torperfResultsBuilder, ParsedOnionPerfAnalysis.Circuit circuit) {
        torperfResultsBuilder.addTimestamp("LAUNCH", circuit.unixTsStart, 0.0);
        if (null != circuit.path) {
            ArrayList<String> path = new ArrayList<String>();
            ArrayList<String> buildTimes = new ArrayList<String>();
            for (Object[] pathElement : circuit.path) {
                String fingerprintAndNickname = (String)pathElement[0];
                String fingerprint = fingerprintAndNickname.split("~")[0];
                path.add(fingerprint);
                buildTimes.add(String.format("%.2f", (Double)pathElement[1]));
            }
            torperfResultsBuilder.addString("PATH", String.join((CharSequence)",", path));
            torperfResultsBuilder.addString("BUILDTIMES", String.join((CharSequence)",", buildTimes));
            torperfResultsBuilder.addInteger("TIMEOUT", circuit.buildTimeout);
            torperfResultsBuilder.addDouble("QUANTILE", circuit.buildQuantile);
            torperfResultsBuilder.addInteger("CIRC_ID", circuit.circuitId);
        }
    }
}

