/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.onionperf;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.util.Map;

public class ParsedOnionPerfAnalysis {
    private static final ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE).setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    Map<String, MeasurementData> data;
    String type;
    Object version;

    static ParsedOnionPerfAnalysis fromBytes(byte[] bytes) throws IOException {
        return objectMapper.readValue(bytes, ParsedOnionPerfAnalysis.class);
    }

    static class Stream {
        String circuitId;
        String failureReasonLocal;
        String failureReasonRemote;
        String source;
        Integer streamId;
        Double unixTsEnd;

        Stream() {
        }
    }

    static class Circuit {
        Double buildQuantile;
        Integer buildTimeout;
        Integer circuitId;
        Object[][] path;
        Double unixTsStart;

        Circuit() {
        }
    }

    static class TorData {
        Map<String, Circuit> circuits;
        Map<String, Stream> streams;

        TorData() {
        }
    }

    static class TransportInfo {
        String local;
        String proxy;
        String remote;

        TransportInfo() {
        }
    }

    static class TimeInfo {
        @JsonProperty(value="usecs-to-command")
        String usecsToCommand;
        @JsonProperty(value="usecs-to-last-byte-recv")
        String usecsToLastByteRecv;
        @JsonProperty(value="usecs-to-proxy-choice")
        String usecsToProxyChoice;
        @JsonProperty(value="usecs-to-proxy-request")
        String usecsToProxyRequest;
        @JsonProperty(value="usecs-to-proxy-response")
        String usecsToProxyResponse;
        @JsonProperty(value="usecs-to-response")
        String usecsToResponse;
        @JsonProperty(value="usecs-to-socket-connect")
        String usecsToSocketConnect;
        @JsonProperty(value="usecs-to-socket-create")
        String usecsToSocketCreate;

        TimeInfo() {
        }
    }

    static class StreamInfo {
        String error;
        String name;
        String peername;
        String recvsize;

        StreamInfo() {
        }
    }

    static class ElapsedSecondsPayload {
        Map<String, Double> payloadBytesRecv;
        Map<String, Double> payloadProgressRecv;

        ElapsedSecondsPayload() {
        }
    }

    static class ByteInfo {
        @JsonProperty(value="total-bytes-recv")
        String totalBytesRecv;
        @JsonProperty(value="total-bytes-send")
        String totalBytesSend;

        ByteInfo() {
        }
    }

    static class TgenStream {
        ByteInfo byteInfo;
        ElapsedSecondsPayload elapsedSeconds;
        Boolean isError;
        StreamInfo streamInfo;
        TimeInfo timeInfo;
        TransportInfo transportInfo;
        Double unixTsStart;
        Double unixTsEnd;

        TgenStream() {
        }
    }

    static class ElapsedSeconds {
        Double command;
        Double lastByte;
        Map<String, Double> payloadBytes;
        Map<String, Double> payloadProgress;
        Double proxyChoice;
        Double proxyRequest;
        Double proxyResponse;
        Double response;
        Double socketConnect;
        Double socketCreate;

        ElapsedSeconds() {
        }
    }

    static class Transfer {
        ElapsedSeconds elapsedSeconds;
        String endpointLocal;
        String endpointProxy;
        String endpointRemote;
        String errorCode;
        Integer filesizeBytes;
        String hostnameLocal;
        String hostnameRemote;
        Boolean isError;
        Integer totalBytesRead;
        Integer totalBytesWrite;
        Double unixTsStart;
        Double unixTsEnd;

        Transfer() {
        }
    }

    static class TgenData {
        Map<String, Transfer> transfers;
        Map<String, TgenStream> streams;

        TgenData() {
        }
    }

    static class MeasurementData {
        String measurementIp;
        TgenData tgen;
        TorData tor;

        MeasurementData() {
        }
    }
}

