/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.GeoipFile;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.GeoipEntryImpl;

public class GeoipFileImpl
extends DescriptorImpl
implements GeoipFile {
    private final List<GeoipFile.GeoipEntry> entries = new ArrayList<GeoipFile.GeoipEntry>();

    protected GeoipFileImpl(byte[] rawDescriptorBytes, int[] offsetAndLength, File descriptorFile) throws DescriptorParseException {
        super(rawDescriptorBytes, offsetAndLength, descriptorFile);
        this.splitAndParseEntries();
    }

    private void splitAndParseEntries() throws DescriptorParseException {
        Scanner scanner = this.newScanner().useDelimiter("\n");
        while (scanner.hasNext()) {
            String line = scanner.next();
            if (line.startsWith("@") || line.startsWith("#")) {
                if (scanner.hasNext()) continue;
                throw new DescriptorParseException("Descriptor is empty.");
            }
            String[] parts = line.split(",");
            if (parts.length < 3) {
                if (this.unrecognizedLines == null) {
                    this.unrecognizedLines = new ArrayList();
                }
                this.unrecognizedLines.add(line);
            }
            String start = parts[0];
            String end = parts[1];
            String countryCode = parts[2];
            String autonomousSystemNumber = parts.length >= 4 ? parts[3] : null;
            try {
                this.entries.add(new GeoipEntryImpl(start, end, countryCode, autonomousSystemNumber));
            }
            catch (UnknownHostException e) {
                if (this.unrecognizedLines == null) {
                    this.unrecognizedLines = new ArrayList();
                }
                this.unrecognizedLines.add(line);
            }
        }
    }

    @Override
    public List<GeoipFile.GeoipEntry> getEntries() {
        return this.entries;
    }

    private int compareAddresses(InetAddress a1, InetAddress a2) {
        byte[] b2;
        byte[] b1 = a1.getAddress();
        if (b1.length != (b2 = a2.getAddress()).length) {
            throw new RuntimeException("Comparing two addresses of different lengths.");
        }
        for (int i = 0; i < b1.length; ++i) {
            int i1 = b1[i] & 0xFF;
            int i2 = b2[i] & 0xFF;
            if (i1 < i2) {
                return -1;
            }
            if (i1 <= i2) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public Optional<GeoipFile.GeoipEntry> getEntry(InetAddress forAddress) {
        int low = 0;
        int high = this.entries.size();
        while (low <= high) {
            int mid = (low + high) / 2;
            GeoipFile.GeoipEntry entry = this.entries.get(mid);
            int startComparisonResult = this.compareAddresses(entry.getStart(), forAddress);
            if (startComparisonResult == -1) {
                int endComparisonResult = this.compareAddresses(entry.getEnd(), forAddress);
                if (endComparisonResult >= 0) {
                    return Optional.of(entry);
                }
                low = mid + 1;
                continue;
            }
            if (startComparisonResult == 1) {
                high = mid - 1;
                continue;
            }
            if (startComparisonResult != 0) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }
}

