/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.GeoipNamesFile;
import org.torproject.descriptor.impl.DescriptorImpl;

public class GeoipNamesFileImpl
extends DescriptorImpl
implements GeoipNamesFile {
    private final Map<String, String> names = new HashMap<String, String>();

    protected GeoipNamesFileImpl(byte[] rawDescriptorBytes, int[] offsetAndLength, File descriptorFile) throws DescriptorParseException {
        super(rawDescriptorBytes, offsetAndLength, descriptorFile);
        this.splitAndParseEntries();
    }

    private void splitAndParseEntries() throws DescriptorParseException {
        Scanner scanner = this.newScanner().useDelimiter("\n");
        while (scanner.hasNext()) {
            String line = scanner.next();
            if (line.startsWith("@")) {
                if (scanner.hasNext()) continue;
                throw new DescriptorParseException("Descriptor is empty.");
            }
            String[] parts = line.split(",", 2);
            if (parts.length < 2) {
                if (this.unrecognizedLines == null) {
                    this.unrecognizedLines = new ArrayList();
                }
                this.unrecognizedLines.add(line);
            }
            this.names.put(parts[0], parts[1]);
            String string = parts[1];
        }
    }

    @Override
    public int size() {
        return this.names.size();
    }

    @Override
    public boolean isEmpty() {
        return this.names.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.names.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.names.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.names.get(key);
    }

    @Override
    public String put(String key, String value) {
        throw new UnsupportedOperationException("Names map is read-only.");
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException("Names map is read-only.");
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        throw new UnsupportedOperationException("Names map is read-only.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Names map is read-only.");
    }

    @Override
    public Set<String> keySet() {
        return this.names.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.names.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.names.entrySet();
    }
}

