/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.log;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.WebServerAccessLog;
import org.torproject.descriptor.internal.FileType;
import org.torproject.descriptor.log.InternalWebServerAccessLog;
import org.torproject.descriptor.log.LogDescriptorImpl;
import org.torproject.descriptor.log.WebServerAccessLogLine;

public class WebServerAccessLogImpl
extends LogDescriptorImpl
implements InternalWebServerAccessLog,
WebServerAccessLog {
    private static final Logger log = LoggerFactory.getLogger(WebServerAccessLogImpl.class);
    public static final String MARKER = "access.log";
    public static final Pattern filenamePattern = Pattern.compile("(\\S*)_(\\S*)_access.log_(\\d*)(?:\\.?)([a-zA-Z]*)");
    private final String physicalHost;
    private final String virtualHost;
    private final LocalDate logDate;
    private boolean validate = true;
    private static final int LISTLIMIT = 0x3FFFFFFF;

    protected WebServerAccessLogImpl(byte[] logBytes, File file) throws DescriptorParseException {
        this(logBytes, file, FileType.XZ);
    }

    public WebServerAccessLogImpl(byte[] bytes, String filename, boolean validate) throws DescriptorParseException {
        this(bytes, new File(filename), FileType.XZ, validate);
    }

    private WebServerAccessLogImpl(byte[] logBytes, File file, FileType defaultCompression) throws DescriptorParseException {
        this(logBytes, file, defaultCompression, true);
    }

    private WebServerAccessLogImpl(byte[] logBytes, File file, FileType defaultCompression, boolean validate) throws DescriptorParseException {
        super(logBytes, file, defaultCompression);
        try {
            String fn = file.toPath().getFileName().toString();
            Matcher mat = filenamePattern.matcher(fn);
            if (!mat.find()) {
                throw new DescriptorParseException("WebServerAccessLog file name doesn't comply to standard: " + fn);
            }
            this.virtualHost = mat.group(1);
            this.physicalHost = mat.group(2);
            if (null == this.virtualHost || null == this.physicalHost || this.virtualHost.isEmpty() || this.physicalHost.isEmpty()) {
                throw new DescriptorParseException("WebServerAccessLog file name doesn't comply to standard: " + fn);
            }
            String ymd = mat.group(3);
            this.logDate = LocalDate.parse(ymd, DateTimeFormatter.BASIC_ISO_DATE);
            this.setValidator(line -> WebServerAccessLogLine.makeLine(line).isValid());
            if (validate) {
                this.validate();
            }
        }
        catch (DescriptorParseException dpe) {
            throw dpe;
        }
        catch (Exception pe) {
            throw new DescriptorParseException("Cannot parse WebServerAccessLog file: " + file, pe);
        }
    }

    @Override
    public String getPhysicalHost() {
        return this.physicalHost;
    }

    @Override
    public String getVirtualHost() {
        return this.virtualHost;
    }

    @Override
    public LocalDate getLogDate() {
        return this.logDate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Stream<WebServerAccessLog.Line> logLines() throws DescriptorParseException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.decompressedByteStream()));){
            ArrayList lists = new ArrayList();
            ArrayList<WebServerAccessLogLine> currentList = new ArrayList<WebServerAccessLogLine>();
            lists.add(currentList);
            String lineStr = br.readLine();
            int count = 0;
            while (null != lineStr) {
                WebServerAccessLogLine wsal = WebServerAccessLogLine.makeLine(lineStr);
                if (wsal.isValid()) {
                    currentList.add(wsal);
                    ++count;
                }
                if (count >= 0x3FFFFFFF) {
                    currentList = new ArrayList();
                    lists.add(currentList);
                    count = 0;
                }
                lineStr = br.readLine();
            }
            br.close();
            Stream<WebServerAccessLog.Line> stream = lists.stream().flatMap(list -> list.stream());
            return stream;
        }
        catch (Exception ex) {
            throw new DescriptorParseException("Cannot retrieve log lines.", ex);
        }
    }
}

