/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

public final class Preconditions {
    public static final String ARGUMENT_EMPTY = "Argument expected not to be empty!";

    public static String checkNotNullOrEmpty(String s) {
        return Preconditions.checkNotNullOrEmpty(s, ARGUMENT_EMPTY);
    }

    public static String checkNotNullOrEmpty(String s, String message) {
        Preconditions.checkNotNull(s, message);
        if (s.isEmpty()) {
            Preconditions.throwExceptionForBeingEmpty(message);
        }
        return s;
    }

    public static <T> T[] checkNotNullOrEmpty(T[] array) {
        T[] checked = Preconditions.checkNotNull(array);
        if (checked.length == 0) {
            Preconditions.throwExceptionForBeingEmpty();
        }
        return checked;
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, String message) {
        if (reference == null) {
            throw new NullPointerException(message);
        }
        return reference;
    }

    private Preconditions() {
    }

    private static void throwExceptionForBeingEmpty() {
        Preconditions.throwExceptionForBeingEmpty(ARGUMENT_EMPTY);
    }

    private static void throwExceptionForBeingEmpty(String message) {
        throw new IllegalArgumentException(message);
    }
}

