/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import org.easymock.internal.RuntimeExceptionWrapper;

public class Range
implements Serializable {
    private static final long serialVersionUID = -6743402320315331536L;
    private final int minimum;
    private final int maximum;

    public Range(int count) {
        this(count, count);
    }

    public Range(int minimum, int maximum) {
        if (minimum > maximum) {
            throw new RuntimeExceptionWrapper(new IllegalArgumentException("minimum must be <= maximum"));
        }
        if (minimum < 0) {
            throw new RuntimeExceptionWrapper(new IllegalArgumentException("minimum must be >= 0"));
        }
        if (maximum < 1) {
            throw new RuntimeExceptionWrapper(new IllegalArgumentException("maximum must be >= 1"));
        }
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public boolean hasFixedCount() {
        return this.minimum == this.maximum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public String toString() {
        if (this.hasFixedCount()) {
            return "" + this.minimum;
        }
        if (this.hasOpenCount()) {
            return "at least " + this.minimum;
        }
        return "between " + this.minimum + " and " + this.maximum;
    }

    public String expectedCount() {
        return "expected: " + this.toString();
    }

    public boolean contains(int count) {
        return this.minimum <= count && count <= this.maximum;
    }

    public boolean hasOpenCount() {
        return this.maximum == Integer.MAX_VALUE;
    }
}

