/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.file;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.Resource;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.file.FileReader;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.slf4j.event.Level;

public class FilePath {
    public static String absolutePathFromClassPathOrPath(String filename) {
        URL resource = FileReader.class.getClassLoader().getResource(filename);
        if (resource != null) {
            return resource.getPath();
        }
        return new File(filename).getAbsolutePath();
    }

    public static URL getURL(String filepath) {
        File file = new File(filepath);
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException murle) {
                new MockServerLogger(FileReader.class).logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while build file URL " + murle.getMessage()).setThrowable(murle));
            }
        }
        return FileReader.class.getClassLoader().getResource(filepath);
    }

    public static List<String> expandFilePathGlobs(String filePath) {
        if (StringUtils.isNotBlank((CharSequence)filePath) && filePath.contains(".")) {
            if (filePath.contains("*") || filePath.contains("?")) {
                ArrayList<String> expandedFilePaths = new ArrayList<String>();
                PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + filePath);
                Finder finder = new Finder(filePath, pathMatcher);
                try {
                    String startingDir;
                    String string = startingDir = filePath.contains("/") ? StringUtils.substringBeforeLast((String)StringUtils.substringBefore((String)filePath, (String)"*"), (String)"/") : ".";
                    if (new File(startingDir).exists()) {
                        Files.walkFileTree(new File(startingDir).toPath(), EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, finder);
                        expandedFilePaths.addAll(finder.getMatchingPaths());
                    } else {
                        new MockServerLogger(FileReader.class).logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("can't find directory:{}for file path:{}").setArguments(startingDir, filePath));
                    }
                }
                catch (Throwable throwable) {
                    new MockServerLogger(FileReader.class).logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception finding files for file path:{}").setArguments(filePath).setThrowable(throwable));
                    throw new RuntimeException(throwable);
                }
                try (ScanResult result = new ClassGraph().scan();){
                    ResourceList resources = result.getResourcesWithExtension(StringUtils.substringAfterLast((String)filePath, (String)"."));
                    expandedFilePaths.addAll(resources.stream().map(Resource::getPath).filter(path -> pathMatcher.matches(new File((String)path).toPath())).collect(Collectors.toList()));
                }
                return expandedFilePaths.stream().sorted().collect(Collectors.toList());
            }
            return Collections.singletonList(filePath);
        }
        return Collections.emptyList();
    }

    public static class Finder
    extends SimpleFileVisitor<Path> {
        private final PathMatcher matcher;
        private final String pattern;
        private final List<String> matchingPaths = new ArrayList<String>();

        public List<String> getMatchingPaths() {
            return this.matchingPaths;
        }

        Finder(String pattern, PathMatcher matcher) {
            this.pattern = pattern;
            this.matcher = matcher;
        }

        void find(Path file) {
            if (file != null && this.matcher.matches(file)) {
                this.matchingPaths.add(file.toFile().getAbsolutePath());
            }
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            this.find(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            this.find(dir);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exception) {
            new MockServerLogger(FileReader.class).logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while findings file matching for pattern " + this.pattern + " for file " + file + " - " + exception.getMessage()).setThrowable(exception));
            return FileVisitResult.CONTINUE;
        }
    }
}

