/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.regex.Pattern;
import org.mockserver.model.NottableString;
import org.mockserver.model.ObjectWithJsonToString;

public class PathModifier
extends ObjectWithJsonToString {
    private int hashCode;
    private String regex;
    @JsonIgnore
    private Pattern pattern;
    private String substitution;

    public String getRegex() {
        return this.regex;
    }

    public PathModifier withRegex(String regex) {
        this.regex = regex;
        this.hashCode = 0;
        return this;
    }

    public String getSubstitution() {
        return this.substitution;
    }

    public PathModifier withSubstitution(String substitution) {
        this.substitution = substitution;
        this.hashCode = 0;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PathModifier that = (PathModifier)o;
        return Objects.equals(this.regex, that.regex) && Objects.equals(this.substitution, that.substitution);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(super.hashCode(), this.regex, this.substitution);
        }
        return this.hashCode;
    }

    @JsonIgnore
    private Pattern getPattern() {
        if (this.pattern == null && this.regex != null) {
            this.pattern = Pattern.compile(this.regex);
        }
        return this.pattern;
    }

    public NottableString update(NottableString path) {
        return NottableString.string(this.update(path.getValue()), path.isNot());
    }

    public String update(String path) {
        Pattern pattern = this.getPattern();
        if (pattern != null) {
            if (this.substitution != null) {
                return pattern.matcher(path).replaceAll(this.substitution);
            }
            return pattern.matcher(path).replaceAll("");
        }
        return path;
    }
}

