/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import java.util.Map;
import java.util.Objects;
import org.mockserver.model.Body;

public class XPathBody
extends Body<String> {
    private int hashCode;
    private final String xpath;
    private final Map<String, String> namespacePrefixes;

    public XPathBody(String xpath) {
        this(xpath, null);
    }

    public XPathBody(String xpath, Map<String, String> namespacePrefixes) {
        super(Body.Type.XPATH);
        this.xpath = xpath;
        this.namespacePrefixes = namespacePrefixes;
    }

    @Override
    public String getValue() {
        return this.xpath;
    }

    public Map<String, String> getNamespacePrefixes() {
        return this.namespacePrefixes;
    }

    public static XPathBody xpath(String xpath) {
        return new XPathBody(xpath);
    }

    public static XPathBody xpath(String xpath, Map<String, String> namespacePrefixes) {
        return new XPathBody(xpath, namespacePrefixes);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        XPathBody xPathBody = (XPathBody)o;
        return Objects.equals(this.xpath, xPathBody.xpath) && Objects.equals(this.namespacePrefixes, xPathBody.namespacePrefixes);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(super.hashCode(), this.xpath, this.namespacePrefixes);
        }
        return this.hashCode;
    }
}

