/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.subethamail.smtp.AuthenticationHandler;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.MessageListener;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.TooMuchDataException;
import org.subethamail.smtp.server.AbstractMessageHandler;

public class DefaultMessageHandler
extends AbstractMessageHandler {
    private List<Delivery> deliveries = new ArrayList<Delivery>();
    private String from;

    public DefaultMessageHandler(MessageContext ctx, AuthenticationHandler authHandler) {
        super(ctx, authHandler);
    }

    public void from(String from) throws RejectException {
        this.from = from;
    }

    public void recipient(String recipient) throws RejectException {
        boolean addedListener = false;
        for (MessageListener listener : this.getListeners()) {
            if (!listener.accept(this.from, recipient)) continue;
            this.deliveries.add(new Delivery(listener, recipient));
            addedListener = true;
        }
        if (!addedListener) {
            throw new RejectException(553, "<" + recipient + "> address unknown.");
        }
    }

    public void resetMessageState() {
        this.deliveries.clear();
    }

    public void data(InputStream data) throws TooMuchDataException, IOException {
        boolean notFirstLoop = false;
        for (Delivery delivery : this.deliveries) {
            delivery.getListener().deliver(this.from, delivery.getRecipient(), this.getPrivateInputStream(notFirstLoop, data));
            if (notFirstLoop) continue;
            notFirstLoop = true;
        }
    }

    public static class Delivery {
        MessageListener listener;
        String recipient;

        public MessageListener getListener() {
            return this.listener;
        }

        public String getRecipient() {
            return this.recipient;
        }

        public Delivery(MessageListener listener, String recipient) {
            this.listener = listener;
            this.recipient = recipient;
        }
    }
}

