/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.AssertionErrorFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.error.MessageFormatter;
import org.assertj.core.util.Strings;
import org.assertj.core.util.Throwables;
import org.assertj.core.util.VisibleForTesting;

public class Failures {
    private static final Failures INSTANCE = new Failures();
    private boolean removeAssertJRelatedElementsFromStackTrace = true;

    public static Failures instance() {
        return INSTANCE;
    }

    public void setRemoveAssertJRelatedElementsFromStackTrace(boolean removeAssertJRelatedElementsFromStackTrace) {
        this.removeAssertJRelatedElementsFromStackTrace = removeAssertJRelatedElementsFromStackTrace;
    }

    @VisibleForTesting
    Failures() {
    }

    public AssertionError failure(AssertionInfo info, AssertionErrorFactory factory) {
        AssertionError error = this.failureIfErrorMessageIsOverriden(info);
        if (error != null) {
            return error;
        }
        return factory.newAssertionError(info.description(), info.representation());
    }

    public AssertionError failure(AssertionInfo info, ErrorMessageFactory message) {
        AssertionError error = this.failureIfErrorMessageIsOverriden(info);
        if (error != null) {
            return error;
        }
        AssertionError assertionError = new AssertionError((Object)message.create(info.description(), info.representation()));
        this.removeAssertJRelatedElementsFromStackTraceIfNeeded(assertionError);
        return assertionError;
    }

    private AssertionError failureIfErrorMessageIsOverriden(AssertionInfo info) {
        String overridingErrorMessage = info.overridingErrorMessage();
        return Strings.isNullOrEmpty(overridingErrorMessage) ? null : this.failure(MessageFormatter.instance().format(info.description(), info.representation(), overridingErrorMessage, new Object[0]));
    }

    public AssertionError failure(String message) {
        AssertionError assertionError = new AssertionError((Object)message);
        this.removeAssertJRelatedElementsFromStackTraceIfNeeded(assertionError);
        return assertionError;
    }

    public void removeAssertJRelatedElementsFromStackTraceIfNeeded(AssertionError assertionError) {
        if (this.removeAssertJRelatedElementsFromStackTrace) {
            Throwables.removeAssertJRelatedElementsFromStackTrace((Throwable)((Object)assertionError));
        }
    }
}

