/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.assign.primitive;

import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.assign.Assigner;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveBoxingDelegate;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveUnboxingDelegate;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveWideningDelegate;

public class PrimitiveTypeAwareAssigner
implements Assigner {
    private final Assigner referenceTypeAwareAssigner;

    public PrimitiveTypeAwareAssigner(Assigner referenceTypeAwareAssigner) {
        this.referenceTypeAwareAssigner = referenceTypeAwareAssigner;
    }

    @Override
    public StackManipulation assign(TypeDescription.Generic source, TypeDescription.Generic target, Assigner.Typing typing) {
        if (source.isPrimitive() && target.isPrimitive()) {
            return PrimitiveWideningDelegate.forPrimitive(source).widenTo(target);
        }
        if (source.isPrimitive()) {
            return PrimitiveBoxingDelegate.forPrimitive(source).assignBoxedTo(target, this.referenceTypeAwareAssigner, typing);
        }
        if (target.isPrimitive()) {
            return PrimitiveUnboxingDelegate.forReferenceType(source).assignUnboxedTo(target, this.referenceTypeAwareAssigner, typing);
        }
        return this.referenceTypeAwareAssigner.assign(source, target, typing);
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.referenceTypeAwareAssigner.equals(((PrimitiveTypeAwareAssigner)other).referenceTypeAwareAssigner);
    }

    public int hashCode() {
        return this.referenceTypeAwareAssigner.hashCode();
    }

    public String toString() {
        return "PrimitiveTypeAwareAssigner{referenceTypeAwareAssigner=" + this.referenceTypeAwareAssigner + '}';
    }
}

