/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.DescriptorParser;
import org.torproject.descriptor.impl.BandwidthFileImpl;
import org.torproject.descriptor.impl.BridgeExtraInfoDescriptorImpl;
import org.torproject.descriptor.impl.BridgeNetworkStatusImpl;
import org.torproject.descriptor.impl.BridgePoolAssignmentImpl;
import org.torproject.descriptor.impl.BridgeServerDescriptorImpl;
import org.torproject.descriptor.impl.BridgedbMetricsImpl;
import org.torproject.descriptor.impl.BridgestrapStatsImpl;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.DirectoryKeyCertificateImpl;
import org.torproject.descriptor.impl.ExitListImpl;
import org.torproject.descriptor.impl.GeoipFileImpl;
import org.torproject.descriptor.impl.GeoipNamesFileImpl;
import org.torproject.descriptor.impl.Key;
import org.torproject.descriptor.impl.MicrodescriptorImpl;
import org.torproject.descriptor.impl.RelayDirectoryImpl;
import org.torproject.descriptor.impl.RelayExtraInfoDescriptorImpl;
import org.torproject.descriptor.impl.RelayNetworkStatusConsensusImpl;
import org.torproject.descriptor.impl.RelayNetworkStatusImpl;
import org.torproject.descriptor.impl.RelayNetworkStatusVoteImpl;
import org.torproject.descriptor.impl.RelayServerDescriptorImpl;
import org.torproject.descriptor.impl.SnowflakeStatsImpl;
import org.torproject.descriptor.impl.TorperfResultImpl;
import org.torproject.descriptor.impl.UnparseableDescriptorImpl;
import org.torproject.descriptor.log.LogDescriptorImpl;
import org.torproject.descriptor.onionperf.OnionPerfAnalysisConverter;

public class DescriptorParserImpl
implements DescriptorParser {
    private static final Logger logger = LoggerFactory.getLogger(DescriptorParserImpl.class);

    @Override
    public Iterable<Descriptor> parseDescriptors(byte[] rawDescriptorBytes, File sourceFile, String fileName) {
        try {
            return this.detectTypeAndParseDescriptors(rawDescriptorBytes, sourceFile, fileName);
        }
        catch (DescriptorParseException e) {
            logger.debug("Cannot parse descriptor file '{}'.", (Object)sourceFile, (Object)e);
            ArrayList<Descriptor> parsedDescriptors = new ArrayList<Descriptor>();
            parsedDescriptors.add(new UnparseableDescriptorImpl(rawDescriptorBytes, new int[]{0, rawDescriptorBytes.length}, sourceFile, e));
            return parsedDescriptors;
        }
    }

    private List<Descriptor> detectTypeAndParseDescriptors(byte[] rawDescriptorBytes, File sourceFile, String fileName) throws DescriptorParseException {
        byte[] first100Chars = new byte[Math.min(100, rawDescriptorBytes.length)];
        System.arraycopy(rawDescriptorBytes, 0, first100Chars, 0, first100Chars.length);
        String firstLines = new String(first100Chars);
        if (firstLines.startsWith("@type network-status-consensus-3 1.") || firstLines.startsWith("@type network-status-microdesc-consensus-3 1.") || (firstLines.startsWith(Key.NETWORK_STATUS_VERSION.keyword + " " + "3") || firstLines.contains("\n" + Key.NETWORK_STATUS_VERSION.keyword + " " + "3")) && firstLines.contains("\n" + Key.VOTE_STATUS.keyword + " " + "consensus" + "\n")) {
            return this.parseOneOrMoreDescriptors(rawDescriptorBytes, sourceFile, Key.NETWORK_STATUS_VERSION, RelayNetworkStatusConsensusImpl.class);
        }
        if (firstLines.startsWith("@type network-status-vote-3 1.") || (firstLines.startsWith(Key.NETWORK_STATUS_VERSION.keyword + " " + "3" + "\n") || firstLines.contains("\n" + Key.NETWORK_STATUS_VERSION.keyword + " " + "3" + "\n")) && firstLines.contains("\n" + Key.VOTE_STATUS.keyword + " " + "vote" + "\n")) {
            return this.parseOneOrMoreDescriptors(rawDescriptorBytes, sourceFile, Key.NETWORK_STATUS_VERSION, RelayNetworkStatusVoteImpl.class);
        }
        if (firstLines.startsWith("@type bridge-network-status 1.") || firstLines.startsWith(Key.R.keyword + " ")) {
            ArrayList<Descriptor> parsedDescriptors = new ArrayList<Descriptor>();
            parsedDescriptors.add(new BridgeNetworkStatusImpl(rawDescriptorBytes, new int[]{0, rawDescriptorBytes.length}, sourceFile, fileName));
            return parsedDescriptors;
        }
        if (firstLines.startsWith("@type bridge-server-descriptor 1.")) {
            return this.parseOneOrMoreDescriptors(rawDescriptorBytes, sourceFile, Key.ROUTER, BridgeServerDescriptorImpl.class);
        }
        if (firstLines.startsWith("@type server-descriptor 1.") || firstLines.startsWith(Key.ROUTER.keyword + " ") || firstLines.contains("\n" + Key.ROUTER.keyword + " ")) {
            return this.parseOneOrMoreDescriptors(rawDescriptorBytes, sourceFile, Key.ROUTER, RelayServerDescriptorImpl.class);
        }
        if (firstLines.startsWith("@type bridge-extra-info 1.")) {
            return this.parseOneOrMoreDescriptors(rawDescriptorBytes, sourceFile, Key.EXTRA_INFO, BridgeExtraInfoDescriptorImpl.class);
        }
        if (firstLines.startsWith("@type extra-info 1.") || firstLines.startsWith(Key.EXTRA_INFO.keyword + " ") || firstLines.contains("\n" + Key.EXTRA_INFO.keyword + " ")) {
            return this.parseOneOrMoreDescriptors(rawDescriptorBytes, sourceFile, Key.EXTRA_INFO, RelayExtraInfoDescriptorImpl.class);
        }
        if (firstLines.startsWith("@type microdescriptor 1.") || firstLines.startsWith(Key.ONION_KEY.keyword + "\n") || firstLines.contains("\n" + Key.ONION_KEY.keyword + "\n")) {
            return this.parseOneOrMoreDescriptors(rawDescriptorBytes, sourceFile, Key.ONION_KEY, MicrodescriptorImpl.class);
        }
        if (firstLines.startsWith("@type bridge-pool-assignment 1.") || firstLines.startsWith(Key.BRIDGE_POOL_ASSIGNMENT.keyword + " ") || firstLines.contains("\n" + Key.BRIDGE_POOL_ASSIGNMENT.keyword + " ")) {
            return this.parseOneOrMoreDescriptors(rawDescriptorBytes, sourceFile, Key.BRIDGE_POOL_ASSIGNMENT, BridgePoolAssignmentImpl.class);
        }
        if (firstLines.startsWith("@type dir-key-certificate-3 1.") || firstLines.startsWith(Key.DIR_KEY_CERTIFICATE_VERSION.keyword + " ") || firstLines.contains("\n" + Key.DIR_KEY_CERTIFICATE_VERSION.keyword + " ")) {
            return this.parseOneOrMoreDescriptors(rawDescriptorBytes, sourceFile, Key.DIR_KEY_CERTIFICATE_VERSION, DirectoryKeyCertificateImpl.class);
        }
        if (firstLines.startsWith("@type tordnsel 1.") || firstLines.startsWith("ExitNode ") || firstLines.contains("\nExitNode ")) {
            ArrayList<Descriptor> parsedDescriptors = new ArrayList<Descriptor>();
            parsedDescriptors.add(new ExitListImpl(rawDescriptorBytes, sourceFile, fileName));
            return parsedDescriptors;
        }
        if (firstLines.startsWith("@type network-status-2 1.") || firstLines.startsWith(Key.NETWORK_STATUS_VERSION.keyword + " " + "2" + "\n") || firstLines.contains("\n" + Key.NETWORK_STATUS_VERSION.keyword + " " + "2" + "\n")) {
            return this.parseOneOrMoreDescriptors(rawDescriptorBytes, sourceFile, Key.NETWORK_STATUS_VERSION, RelayNetworkStatusImpl.class);
        }
        if (firstLines.startsWith("@type directory 1.") || firstLines.startsWith(Key.SIGNED_DIRECTORY.keyword + "\n") || firstLines.contains("\n" + Key.SIGNED_DIRECTORY.keyword + "\n")) {
            return this.parseOneOrMoreDescriptors(rawDescriptorBytes, sourceFile, Key.SIGNED_DIRECTORY, RelayDirectoryImpl.class);
        }
        if (firstLines.startsWith("@type torperf 1.")) {
            return TorperfResultImpl.parseTorperfResults(rawDescriptorBytes, sourceFile);
        }
        if (firstLines.startsWith("@type snowflake-stats 1.") || firstLines.startsWith(Key.SNOWFLAKE_STATS_END.keyword + " ") || firstLines.contains("\n" + Key.SNOWFLAKE_STATS_END.keyword + " ")) {
            return this.parseOneOrMoreDescriptors(rawDescriptorBytes, sourceFile, Key.SNOWFLAKE_STATS_END, SnowflakeStatsImpl.class);
        }
        if (firstLines.startsWith("@type bridgedb-metrics 1.") || firstLines.startsWith(Key.BRIDGEDB_METRICS_END.keyword + " ") || firstLines.contains("\n" + Key.BRIDGEDB_METRICS_END.keyword + " ")) {
            return this.parseOneOrMoreDescriptors(rawDescriptorBytes, sourceFile, Key.BRIDGEDB_METRICS_END, BridgedbMetricsImpl.class);
        }
        if (firstLines.startsWith("@type bridgestrap-stats 1.") || firstLines.startsWith(Key.BRIDGESTRAP_STATS_END.keyword + " ") || firstLines.contains("\n" + Key.BRIDGESTRAP_STATS_END.keyword + " ")) {
            return this.parseOneOrMoreDescriptors(rawDescriptorBytes, sourceFile, Key.BRIDGESTRAP_STATS_END, BridgestrapStatsImpl.class);
        }
        if (firstLines.startsWith("@type bandwidth-file 1.") || firstLines.matches("(?s)[0-9]{10}\\n.*")) {
            ArrayList<Descriptor> parsedDescriptors = new ArrayList<Descriptor>();
            parsedDescriptors.add(new BandwidthFileImpl(rawDescriptorBytes, sourceFile));
            return parsedDescriptors;
        }
        if (null != fileName && fileName.contains(".log")) {
            return LogDescriptorImpl.parse(rawDescriptorBytes, sourceFile, fileName);
        }
        if (null != fileName && fileName.endsWith(".onionperf.analysis.json.xz")) {
            return new OnionPerfAnalysisConverter(rawDescriptorBytes, sourceFile).asTorperfResults();
        }
        if (null != fileName && (fileName.equals("geoip") || fileName.equals("geoip6"))) {
            return GeoipFileImpl.parse(rawDescriptorBytes, sourceFile);
        }
        if (null != fileName && (fileName.equals("countries.txt") || fileName.equals("asn.txt"))) {
            return GeoipNamesFileImpl.parse(rawDescriptorBytes, sourceFile);
        }
        throw new DescriptorParseException("Could not detect descriptor type in descriptor starting with '" + firstLines + "'.");
    }

    private List<Descriptor> parseOneOrMoreDescriptors(byte[] rawDescriptorBytes, File sourceFile, Key key, Class<? extends DescriptorImpl> descriptorClass) {
        boolean containsKeywordNewline;
        Constructor<? extends DescriptorImpl> constructor;
        ArrayList<Descriptor> parsedDescriptors = new ArrayList<Descriptor>();
        try {
            constructor = descriptorClass.getDeclaredConstructor(byte[].class, int[].class, File.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        int startAnnotations = 0;
        int endAllDescriptors = rawDescriptorBytes.length;
        String ascii = new String(rawDescriptorBytes, StandardCharsets.US_ASCII);
        boolean containsAnnotations = ascii.startsWith("@") || ascii.contains("\n@");
        boolean containsKeywordSpace = ascii.startsWith(key.keyword + " ") || ascii.contains("\n" + key.keyword + " ");
        boolean bl = containsKeywordNewline = ascii.startsWith(key.keyword + "\n") || ascii.contains("\n" + key.keyword + "\n");
        while (startAnnotations < endAllDescriptors) {
            int startDescriptor = -1;
            if (containsKeywordSpace && startAnnotations == ascii.indexOf(key.keyword + " ", startAnnotations) || containsKeywordNewline && startAnnotations == ascii.indexOf(key.keyword + "\n", startAnnotations)) {
                startDescriptor = startAnnotations;
            } else {
                if (containsKeywordSpace) {
                    startDescriptor = ascii.indexOf("\n" + key.keyword + " ", startAnnotations - 1);
                }
                if (startDescriptor < 0 && containsKeywordNewline) {
                    startDescriptor = ascii.indexOf("\n" + key.keyword + "\n", startAnnotations - 1);
                }
                if (startDescriptor < 0) break;
                ++startDescriptor;
            }
            int endDescriptor = -1;
            if (containsAnnotations) {
                endDescriptor = ascii.indexOf("\n@", startDescriptor);
            }
            if (endDescriptor < 0 && containsKeywordSpace) {
                endDescriptor = ascii.indexOf("\n" + key.keyword + " ", startDescriptor);
            }
            if (endDescriptor < 0 && containsKeywordNewline) {
                endDescriptor = ascii.indexOf("\n" + key.keyword + "\n", startDescriptor);
            }
            if (endDescriptor < 0) {
                endDescriptor = endAllDescriptors - 1;
            }
            int[] offsetAndLength = new int[]{startAnnotations, ++endDescriptor - startAnnotations};
            try {
                parsedDescriptors.add(this.parseOneDescriptor(rawDescriptorBytes, offsetAndLength, sourceFile, constructor));
            }
            catch (DescriptorParseException e) {
                parsedDescriptors.add(new UnparseableDescriptorImpl(rawDescriptorBytes, offsetAndLength, sourceFile, e));
            }
            startAnnotations = endDescriptor;
        }
        return parsedDescriptors;
    }

    Descriptor parseOneDescriptor(byte[] rawDescriptorBytes, int[] offsetAndLength, File sourceFile, Constructor<? extends DescriptorImpl> constructor) throws DescriptorParseException {
        try {
            return constructor.newInstance(rawDescriptorBytes, offsetAndLength, sourceFile);
        }
        catch (InvocationTargetException e) {
            if (null != e.getCause() && e.getCause() instanceof DescriptorParseException) {
                throw (DescriptorParseException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

