/*
 * Decompiled with CFR 0.152.
 */
package org.h2.java;

import org.h2.java.Expr;
import org.h2.java.JavaParser;
import org.h2.java.Type;

class OpExpr
implements Expr {
    Expr left;
    String op;
    Expr right;
    private final JavaParser context;

    OpExpr(JavaParser javaParser) {
        this.context = javaParser;
    }

    public String toString() {
        if (this.left == null) {
            return this.op + this.right;
        }
        if (this.right == null) {
            return this.left + this.op;
        }
        if (this.op.equals(">>>")) {
            return "(((u" + this.left.getType() + ") " + this.left + ") >> " + this.right + ")";
        }
        if (this.op.equals("+") && (this.left.getType().isObject() || this.right.getType().isObject())) {
            return "STRING_CONCAT(" + this.left + ", " + this.right + ")";
        }
        return "(" + this.left + " " + this.op + " " + this.right + ")";
    }

    public Type getType() {
        if (this.left == null) {
            return this.right.getType();
        }
        if (this.right == null) {
            return this.left.getType();
        }
        if (this.op.equals("+") && (this.left.getType().isObject() || this.right.getType().isObject())) {
            Type type = new Type();
            type.classObj = this.context.getClassObj("java.lang.String");
            return type;
        }
        Type type = this.left.getType();
        Type type2 = this.right.getType();
        if (type.classObj.primitiveType < type2.classObj.primitiveType) {
            return type2;
        }
        return type;
    }
}

