/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import org.mockserver.model.HttpOverrideForwardedRequest;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpRequestModifier;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpResponseModifier;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.serialization.model.DTO;
import org.mockserver.serialization.model.DelayDTO;
import org.mockserver.serialization.model.HttpRequestDTO;
import org.mockserver.serialization.model.HttpRequestModifierDTO;
import org.mockserver.serialization.model.HttpResponseDTO;
import org.mockserver.serialization.model.HttpResponseModifierDTO;

public class HttpOverrideForwardedRequestDTO
extends ObjectWithReflectiveEqualsHashCodeToString
implements DTO<HttpOverrideForwardedRequest> {
    @JsonAlias(value={"httpRequest"})
    private HttpRequestDTO requestOverride;
    private HttpRequestModifierDTO requestModifier;
    @JsonAlias(value={"httpResponse"})
    private HttpResponseDTO responseOverride;
    private HttpResponseModifierDTO responseModifier;
    private DelayDTO delay;

    public HttpOverrideForwardedRequestDTO(HttpOverrideForwardedRequest httpOverrideForwardedRequest) {
        if (httpOverrideForwardedRequest != null) {
            HttpResponseModifier modifyHttpResponse;
            HttpResponse overrideHttpResponse;
            HttpRequestModifier modifyHttpRequest;
            HttpRequest overrideHttpRequest = httpOverrideForwardedRequest.getRequestOverride();
            if (overrideHttpRequest != null) {
                this.requestOverride = new HttpRequestDTO(overrideHttpRequest);
            }
            if ((modifyHttpRequest = httpOverrideForwardedRequest.getRequestModifier()) != null) {
                this.requestModifier = new HttpRequestModifierDTO(modifyHttpRequest);
            }
            if ((overrideHttpResponse = httpOverrideForwardedRequest.getResponseOverride()) != null) {
                this.responseOverride = new HttpResponseDTO(overrideHttpResponse);
            }
            if ((modifyHttpResponse = httpOverrideForwardedRequest.getResponseModifier()) != null) {
                this.responseModifier = new HttpResponseModifierDTO(modifyHttpResponse);
            }
            this.delay = httpOverrideForwardedRequest.getDelay() != null ? new DelayDTO(httpOverrideForwardedRequest.getDelay()) : null;
        }
    }

    public HttpOverrideForwardedRequestDTO() {
    }

    @Override
    public HttpOverrideForwardedRequest buildObject() {
        HttpRequest overrideHttpRequest = null;
        if (this.requestOverride != null) {
            overrideHttpRequest = this.requestOverride.buildObject();
        }
        HttpRequestModifier modifyHttpRequest = null;
        if (this.requestModifier != null) {
            modifyHttpRequest = this.requestModifier.buildObject();
        }
        HttpResponse overrideHttpResponse = null;
        if (this.responseOverride != null) {
            overrideHttpResponse = this.responseOverride.buildObject();
        }
        HttpResponseModifier modifyHttpResponse = null;
        if (this.responseModifier != null) {
            modifyHttpResponse = this.responseModifier.buildObject();
        }
        return (HttpOverrideForwardedRequest)new HttpOverrideForwardedRequest().withRequestOverride(overrideHttpRequest).withRequestModifier(modifyHttpRequest).withResponseOverride(overrideHttpResponse).withResponseModifier(modifyHttpResponse).withDelay(this.delay != null ? this.delay.buildObject() : null);
    }

    public HttpRequestDTO getRequestOverride() {
        return this.requestOverride;
    }

    public HttpOverrideForwardedRequestDTO setRequestOverride(HttpRequestDTO requestOverride) {
        this.requestOverride = requestOverride;
        return this;
    }

    public HttpRequestModifierDTO getRequestModifier() {
        return this.requestModifier;
    }

    public HttpOverrideForwardedRequestDTO setRequestModifier(HttpRequestModifierDTO requestModifier) {
        this.requestModifier = requestModifier;
        return this;
    }

    public HttpResponseDTO getResponseOverride() {
        return this.responseOverride;
    }

    public HttpOverrideForwardedRequestDTO setResponseOverride(HttpResponseDTO responseOverride) {
        this.responseOverride = responseOverride;
        return this;
    }

    public HttpResponseModifierDTO getResponseModifier() {
        return this.responseModifier;
    }

    public HttpOverrideForwardedRequestDTO setResponseModifier(HttpResponseModifierDTO responseModifier) {
        this.responseModifier = responseModifier;
        return this;
    }

    public DelayDTO getDelay() {
        return this.delay;
    }

    public HttpOverrideForwardedRequestDTO setDelay(DelayDTO delay) {
        this.delay = delay;
        return this;
    }
}

