/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.templates.engine.javascript;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.model.DTO;
import org.mockserver.templates.engine.TemplateEngine;
import org.mockserver.templates.engine.TemplateFunctions;
import org.mockserver.templates.engine.javascript.bindings.ScriptBindings;
import org.mockserver.templates.engine.model.HttpRequestTemplateObject;
import org.mockserver.templates.engine.serializer.HttpTemplateOutputDeserializer;
import org.slf4j.event.Level;

public class JavaScriptTemplateEngine
implements TemplateEngine {
    private static ScriptEngine engine;
    private static ObjectMapper objectMapper;
    private final MockServerLogger mockServerLogger;
    private HttpTemplateOutputDeserializer httpTemplateOutputDeserializer;

    public JavaScriptTemplateEngine(MockServerLogger mockServerLogger) {
        System.setProperty("nashorn.args", "--language=es6");
        if (engine == null) {
            engine = new ScriptEngineManager().getEngineByName("nashorn");
        }
        this.mockServerLogger = mockServerLogger;
        this.httpTemplateOutputDeserializer = new HttpTemplateOutputDeserializer(mockServerLogger);
        if (objectMapper == null) {
            objectMapper = ObjectMapperFactory.createObjectMapper();
        }
    }

    @Override
    public <T> T executeTemplate(String template, HttpRequest request, Class<? extends DTO<T>> dtoClass) {
        T result;
        block7: {
            result = null;
            String script = JavaScriptTemplateEngine.wrapTemplate(template);
            try {
                if (engine != null) {
                    JsonNode generatedObject;
                    Object stringifiedResponse;
                    block6: {
                        Compilable compilable = (Compilable)((Object)engine);
                        CompiledScript compiledScript = compilable.compile(script + " function serialise(request) { return JSON.stringify(handle(JSON.parse(request)), null, 2); }");
                        Bindings serialiseBindings = engine.createBindings();
                        engine.setBindings(new ScriptBindings(TemplateFunctions.BUILT_IN_FUNCTIONS), 100);
                        compiledScript.eval(serialiseBindings);
                        ScriptObjectMirror scriptObjectMirror = (ScriptObjectMirror)serialiseBindings.get("serialise");
                        stringifiedResponse = scriptObjectMirror.call(null, new Object[]{new HttpRequestTemplateObject(request)});
                        generatedObject = null;
                        try {
                            generatedObject = objectMapper.readTree(String.valueOf(stringifiedResponse));
                        }
                        catch (Throwable throwable) {
                            if (!MockServerLogger.isEnabled(Level.INFO)) break block6;
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setHttpRequest(request).setMessageFormat("exception deserialising generated content:{}into json node for request:{}").setArguments(stringifiedResponse, request));
                        }
                    }
                    if (MockServerLogger.isEnabled(Level.INFO)) {
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TEMPLATE_GENERATED).setLogLevel(Level.INFO).setHttpRequest(request).setMessageFormat("generated output:{}from template:{}for request:{}").setArguments(generatedObject != null ? generatedObject : stringifiedResponse, script, request));
                    }
                    result = this.httpTemplateOutputDeserializer.deserializer(request, (String)stringifiedResponse, dtoClass);
                    break block7;
                }
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setHttpRequest(request).setMessageFormat("JavaScript based templating is only available in a JVM with the \"nashorn\" JavaScript engine, please use a JVM with the \"nashorn\" JavaScript engine, such as Oracle Java 8+").setArguments(new RuntimeException("\"nashorn\" JavaScript engine not available")));
            }
            catch (Exception e) {
                throw new RuntimeException(StringFormatter.formatLogMessage("Exception:{}transforming template:{}for request:{}", StringUtils.isNotBlank((CharSequence)e.getMessage()) ? e.getMessage() : e.getClass().getSimpleName(), template, request), e);
            }
        }
        return result;
    }

    static String wrapTemplate(String template) {
        return "function handle(request) {" + StringFormatter.indentAndToString(template)[0] + "}";
    }
}

