/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.torproject.descriptor.GeoipFile;

public class GeoipEntryImpl
implements GeoipFile.GeoipEntry {
    private final InetAddress start;
    private final InetAddress end;
    private final String countryCode;
    private final String autonomousSystemNumber;

    public GeoipEntryImpl(String start, String end, String countryCode, String autonomousSystemNumber) throws UnknownHostException {
        InetAddress parsedEnd;
        InetAddress parsedStart;
        int addr;
        try {
            addr = Integer.parseInt(start);
            parsedStart = InetAddress.getByAddress(new byte[]{(byte)(addr >>> 24), (byte)(addr >>> 16), (byte)(addr >>> 8), (byte)addr});
        }
        catch (NumberFormatException nfe) {
            parsedStart = InetAddress.getByName(start);
        }
        try {
            addr = Integer.parseInt(end);
            parsedEnd = InetAddress.getByAddress(new byte[]{(byte)(addr >>> 24), (byte)(addr >>> 16), (byte)(addr >>> 8), (byte)addr});
        }
        catch (NumberFormatException nfe) {
            parsedEnd = InetAddress.getByName(end);
        }
        this.start = parsedStart;
        this.end = parsedEnd;
        this.countryCode = countryCode;
        this.autonomousSystemNumber = autonomousSystemNumber;
    }

    @Override
    public InetAddress getStart() {
        return this.start;
    }

    @Override
    public InetAddress getEnd() {
        return this.end;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public String getAutonomousSystemNumber() {
        return this.autonomousSystemNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GeoipFile.GeoipEntry that = (GeoipFile.GeoipEntry)obj;
        return this.getStart().equals(that.getStart()) && this.getEnd().equals(that.getEnd()) && this.getCountryCode().equals(that.getCountryCode()) && Objects.equals(this.autonomousSystemNumber, that.getAutonomousSystemNumber());
    }

    public int hashCode() {
        return Objects.hash(this.getStart(), this.getEnd(), this.getCountryCode(), this.autonomousSystemNumber);
    }
}

