/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.PageDataIndex;
import org.h2.index.PageIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.PageStore;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;

public class PageDelegateIndex
extends PageIndex {
    private final PageDataIndex mainIndex;

    public PageDelegateIndex(RegularTable regularTable, int n, String string, IndexType indexType, PageDataIndex pageDataIndex, boolean bl, Session session) {
        IndexColumn[] indexColumnArray = IndexColumn.wrap(new Column[]{regularTable.getColumn(pageDataIndex.getMainIndexColumn())});
        this.initBaseIndex(regularTable, n, string, indexColumnArray, indexType);
        this.mainIndex = pageDataIndex;
        if (!this.database.isPersistent() || n < 0) {
            throw DbException.throwInternalError("" + string);
        }
        PageStore pageStore = this.database.getPageStore();
        pageStore.addIndex(this);
        if (bl) {
            pageStore.addMeta(this, session);
        }
    }

    public void add(Session session, Row row) {
    }

    public boolean canFindNext() {
        return false;
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    public void close(Session session) {
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        long l = this.mainIndex.getLong(searchRow, Long.MIN_VALUE);
        long l2 = this.mainIndex.getLong(searchRow2, Long.MAX_VALUE);
        return this.mainIndex.find(session, l, l2, false);
    }

    public Cursor findFirstOrLast(Session session, boolean bl) {
        Cursor cursor;
        if (bl) {
            cursor = this.mainIndex.find(session, Long.MIN_VALUE, Long.MAX_VALUE, false);
        } else {
            long l = this.mainIndex.getLastKey();
            cursor = this.mainIndex.find(session, l, l, false);
        }
        cursor.next();
        return cursor;
    }

    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) {
        throw DbException.throwInternalError();
    }

    public int getColumnIndex(Column column) {
        if (column.getColumnId() == this.mainIndex.getMainIndexColumn()) {
            return 0;
        }
        return -1;
    }

    public double getCost(Session session, int[] nArray) {
        return 10L * this.getCostRangeIndex(nArray, this.mainIndex.getRowCount(session));
    }

    public boolean needRebuild() {
        return false;
    }

    public void remove(Session session, Row row) {
    }

    public void remove(Session session) {
        this.mainIndex.setMainIndexColumn(-1);
        session.getDatabase().getPageStore().removeMeta(this, session);
    }

    public void truncate(Session session) {
    }

    public void checkRename() {
    }

    public long getRowCount(Session session) {
        return this.mainIndex.getRowCount(session);
    }

    public long getRowCountApproximation() {
        return this.mainIndex.getRowCountApproximation();
    }

    public void writeRowCount() {
    }
}

