/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import nl.jqno.equalsverifier.Checker;
import nl.jqno.equalsverifier.Configuration;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.Assert;
import nl.jqno.equalsverifier.internal.ClassAccessor;
import nl.jqno.equalsverifier.internal.Formatter;

class SignatureChecker<T>
implements Checker {
    private final Class<T> type;
    private final ClassAccessor<T> classAccessor;
    private final Set<Warning> warningsToSuppress;

    public SignatureChecker(Configuration<T> config) {
        this.type = config.getType();
        this.classAccessor = config.createClassAccessor();
        this.warningsToSuppress = config.getWarningsToSuppress();
    }

    @Override
    public void check() {
        List<Method> equalsMethods = this.getEqualsMethods();
        if (equalsMethods.size() > 1) {
            this.failOverloaded("More than one equals method found");
        }
        if (equalsMethods.size() == 1) {
            this.checkEquals(equalsMethods.get(0));
        }
        this.checkEqualsIsDefined();
    }

    private void checkEqualsIsDefined() {
        boolean fail;
        boolean bl = fail = !this.warningsToSuppress.contains((Object)Warning.INHERITED_DIRECTLY_FROM_OBJECT) && this.classAccessor.isEqualsInheritedFromObject();
        if (fail) {
            Assert.fail(Formatter.of("Equals is inherited directly from Object.\nSuppress Warning." + Warning.INHERITED_DIRECTLY_FROM_OBJECT.name() + " to skip this check.", new Object[0]));
        }
    }

    private List<Method> getEqualsMethods() {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : this.type.getDeclaredMethods()) {
            if (!method.getName().equals("equals")) continue;
            result.add(method);
        }
        return result;
    }

    private void checkEquals(Method equals) {
        Class<?> parameterType;
        Class<?>[] parameterTypes = equals.getParameterTypes();
        if (parameterTypes.length > 1) {
            this.failOverloaded("Too many parameters");
        }
        if (parameterTypes.length == 0) {
            this.failOverloaded("No parameter");
        }
        if ((parameterType = parameterTypes[0]) == this.type) {
            this.failOverloaded("Parameter should be an Object, not " + this.type.getSimpleName());
        }
        if (parameterType != Object.class) {
            this.failOverloaded("Parameter should be an Object");
        }
    }

    private void failOverloaded(String message) {
        Assert.fail(Formatter.of("Overloaded: %%.\nSignature should be: public boolean equals(Object obj)", message));
    }
}

