/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

public class JDK {
    public static final boolean IS_5 = JDK.isJavaVersionAtLeast(1, 5);
    public static final boolean IS_6 = JDK.isJavaVersionAtLeast(1, 6);
    public static final boolean IS_7 = JDK.isJavaVersionAtLeast(1, 7);
    public static final boolean IS_8 = JDK.isJavaVersionAtLeast(1, 8);
    public static final boolean IS_9 = JDK.isJavaVersionAtLeast(1, 9);

    private static boolean isJavaVersionAtLeast(int maj, int min) {
        String jver = System.getProperty("java.version");
        if (jver == null) {
            System.err.println("## ERROR: System.getProperty('java.version') == null !?");
            return false;
        }
        String[] vparts = jver.split("\\.");
        if (vparts.length < 2) {
            System.err.println("## ERROR: Invalid java version format '" + jver + "'");
            return false;
        }
        return JDK.toInt(vparts[0]) >= maj && JDK.toInt(vparts[1]) >= min;
    }

    private static int toInt(String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

