/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.mockserver.model.Action;

public class HttpTemplate
extends Action<HttpTemplate> {
    private int hashCode;
    private final TemplateType templateType;
    private String template;
    private Action.Type actionType;

    public HttpTemplate(TemplateType type) {
        this.templateType = type;
    }

    public static HttpTemplate template(TemplateType type) {
        return new HttpTemplate(type);
    }

    public static HttpTemplate template(TemplateType type, String template) {
        return new HttpTemplate(type).withTemplate(template);
    }

    public TemplateType getTemplateType() {
        return this.templateType;
    }

    public HttpTemplate withTemplate(String template) {
        this.template = template;
        this.hashCode = 0;
        return this;
    }

    public String getTemplate() {
        return this.template;
    }

    public void withActionType(Action.Type actionType) {
        this.actionType = actionType;
        this.hashCode = 0;
    }

    @Override
    @JsonIgnore
    public Action.Type getType() {
        return this.actionType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpTemplate that = (HttpTemplate)o;
        return this.templateType == that.templateType && Objects.equals(this.template, that.template) && this.actionType == that.actionType;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(new Object[]{super.hashCode(), this.templateType, this.template, this.actionType});
        }
        return this.hashCode;
    }

    public static enum TemplateType {
        JAVASCRIPT,
        VELOCITY,
        MUSTACHE;

    }
}

