/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.MediaType;

public class StringBody
extends BodyWithContentType<String> {
    private int hashCode;
    public static final MediaType DEFAULT_CONTENT_TYPE = MediaType.create("text", "plain");
    private final boolean subString;
    private final String value;
    private final byte[] rawBytes;

    public StringBody(String value) {
        this(value, null, false, null);
    }

    public StringBody(String value, Charset charset) {
        this(value, null, false, charset != null ? DEFAULT_CONTENT_TYPE.withCharset(charset) : null);
    }

    public StringBody(String value, MediaType contentType) {
        this(value, null, false, contentType);
    }

    public StringBody(String value, byte[] rawBytes, boolean subString, MediaType contentType) {
        super(Body.Type.STRING, contentType);
        this.value = StringUtils.isNotBlank((CharSequence)value) ? value : "";
        this.subString = subString;
        this.rawBytes = rawBytes == null && value != null ? value.getBytes(this.determineCharacterSet(contentType, MediaType.DEFAULT_TEXT_HTTP_CHARACTER_SET)) : rawBytes;
    }

    public static StringBody exact(String body) {
        return new StringBody(body);
    }

    public static StringBody exact(String body, Charset charset) {
        return new StringBody(body, charset);
    }

    public static StringBody exact(String body, MediaType contentType) {
        return new StringBody(body, contentType);
    }

    public static StringBody subString(String body) {
        return new StringBody(body, null, true, null);
    }

    public static StringBody subString(String body, Charset charset) {
        return new StringBody(body, null, true, charset != null ? DEFAULT_CONTENT_TYPE.withCharset(charset) : null);
    }

    public static StringBody subString(String body, MediaType contentType) {
        return new StringBody(body, null, true, contentType);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    @JsonIgnore
    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public boolean isSubString() {
        return this.subString;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StringBody that = (StringBody)o;
        return this.subString == that.subString && Objects.equals(this.value, that.value) && Arrays.equals(this.rawBytes, that.rawBytes);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            int result = Objects.hash(super.hashCode(), this.subString, this.value);
            this.hashCode = 31 * result + Arrays.hashCode(this.rawBytes);
        }
        return this.hashCode;
    }
}

