/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.mockserver.codec.ExpandedParameterDecoder;
import org.mockserver.configuration.Configuration;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.MultiValueMapMatcher;
import org.mockserver.model.Parameters;

public class ParameterStringMatcher
extends BodyMatcher<String> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger"};
    private final MultiValueMapMatcher matcher;
    private final ExpandedParameterDecoder formParameterParser;
    private final Parameters matcherParameters;
    private final ExpandedParameterDecoder expandedParameterDecoder;

    ParameterStringMatcher(Configuration configuration, MockServerLogger mockServerLogger, Parameters matcherParameters, boolean controlPlaneMatcher) {
        this.matcherParameters = matcherParameters;
        this.matcher = new MultiValueMapMatcher(mockServerLogger, matcherParameters, controlPlaneMatcher);
        this.formParameterParser = new ExpandedParameterDecoder(configuration, mockServerLogger);
        this.expandedParameterDecoder = new ExpandedParameterDecoder(configuration, mockServerLogger);
    }

    @Override
    public boolean matches(MatchDifference context, String matched) {
        boolean result = false;
        Parameters matchedParameters = this.formParameterParser.retrieveFormParameters(matched, matched != null && matched.contains("?"));
        this.expandedParameterDecoder.splitParameters(this.matcherParameters, matchedParameters);
        if (this.matcher.matches(context, matchedParameters)) {
            result = true;
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return this.matcher.isBlank();
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

