/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket.tls;

import com.google.common.base.Joiner;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.Configuration;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.KeyAndCertificateFactory;
import org.mockserver.socket.tls.KeyAndCertificateFactoryFactory;
import org.mockserver.socket.tls.PEMToFile;
import org.slf4j.event.Level;

public class NettySslContextFactory {
    private static final String[] TLS_PROTOCOLS = "TLSv1,TLSv1.1,TLSv1.2".split(",");
    public static Function<SslContextBuilder, SslContext> clientSslContextBuilderFunction = sslContextBuilder -> {
        try {
            return sslContextBuilder.build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    };
    private final Configuration configuration;
    private final MockServerLogger mockServerLogger;
    private final KeyAndCertificateFactory keyAndCertificateFactory;
    private SslContext clientSslContext = null;
    private SslContext serverSslContext = null;
    private Function<SslContextBuilder, SslContext> instanceClientSslContextBuilderFunction = clientSslContextBuilderFunction;

    @Deprecated
    public NettySslContextFactory(MockServerLogger mockServerLogger) {
        this.configuration = Configuration.configuration();
        this.mockServerLogger = mockServerLogger;
        this.keyAndCertificateFactory = KeyAndCertificateFactoryFactory.createKeyAndCertificateFactory(this.configuration, mockServerLogger);
        System.setProperty("https.protocols", Joiner.on((String)",").join((Object[])TLS_PROTOCOLS));
        if (this.configuration.proactivelyInitialiseTLS().booleanValue()) {
            this.createServerSslContext();
        }
    }

    public NettySslContextFactory(Configuration configuration, MockServerLogger mockServerLogger) {
        this.configuration = configuration;
        this.mockServerLogger = mockServerLogger;
        this.keyAndCertificateFactory = KeyAndCertificateFactoryFactory.createKeyAndCertificateFactory(configuration, mockServerLogger);
        System.setProperty("https.protocols", Joiner.on((String)",").join((Object[])TLS_PROTOCOLS));
        if (configuration.proactivelyInitialiseTLS().booleanValue()) {
            this.createServerSslContext();
        }
    }

    public NettySslContextFactory withClientSslContextBuilderFunction(Function<SslContextBuilder, SslContext> clientSslContextBuilderFunction) {
        this.instanceClientSslContextBuilderFunction = clientSslContextBuilderFunction;
        return this;
    }

    public synchronized SslContext createClientSslContext(boolean forwardProxyClient) {
        if (this.clientSslContext == null || this.configuration.rebuildTLSContext()) {
            try {
                if (this.keyAndCertificateFactory.certificateNotYetCreated()) {
                    this.keyAndCertificateFactory.buildAndSavePrivateKeyAndX509Certificate();
                }
                SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().protocols(TLS_PROTOCOLS).keyManager(this.forwardProxyPrivateKey(), this.forwardProxyCertificateChain());
                if (forwardProxyClient) {
                    switch (this.configuration.forwardProxyTLSX509CertificatesTrustManagerType()) {
                        case ANY: {
                            sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                            break;
                        }
                        case JVM: {
                            ArrayList<X509Certificate> mockServerX509Certificates = new ArrayList<X509Certificate>();
                            mockServerX509Certificates.add(this.keyAndCertificateFactory.x509Certificate());
                            mockServerX509Certificates.add(this.keyAndCertificateFactory.certificateAuthorityX509Certificate());
                            sslContextBuilder.trustManager(this.jvmCAX509TrustCertificates(mockServerX509Certificates));
                            break;
                        }
                        case CUSTOM: {
                            sslContextBuilder.trustManager(this.customCAX509TrustCertificates());
                        }
                    }
                } else {
                    ArrayList<X509Certificate> mockServerX509Certificates = new ArrayList<X509Certificate>();
                    if (StringUtils.isNotBlank((CharSequence)this.configuration.tlsMutualAuthenticationCertificateChain())) {
                        mockServerX509Certificates.addAll(PEMToFile.x509ChainFromPEMFile(this.configuration.tlsMutualAuthenticationCertificateChain()));
                        mockServerX509Certificates.add(this.keyAndCertificateFactory.certificateAuthorityX509Certificate());
                    } else {
                        mockServerX509Certificates.add(this.keyAndCertificateFactory.certificateAuthorityX509Certificate());
                    }
                    sslContextBuilder.trustManager(this.jvmCAX509TrustCertificates(mockServerX509Certificates));
                }
                this.clientSslContext = this.instanceClientSslContextBuilderFunction.apply(sslContextBuilder);
                this.configuration.rebuildTLSContext(false);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Exception creating SSL context for client", throwable);
            }
        }
        return this.clientSslContext;
    }

    private PrivateKey forwardProxyPrivateKey() {
        if (StringUtils.isNotBlank((CharSequence)this.configuration.forwardProxyPrivateKey())) {
            return PEMToFile.privateKeyFromPEMFile(this.configuration.forwardProxyPrivateKey());
        }
        return this.keyAndCertificateFactory.privateKey();
    }

    private X509Certificate[] forwardProxyCertificateChain() {
        if (StringUtils.isNotBlank((CharSequence)this.configuration.forwardProxyCertificateChain())) {
            return PEMToFile.x509ChainFromPEMFile(this.configuration.forwardProxyCertificateChain()).toArray(new X509Certificate[0]);
        }
        return new X509Certificate[]{this.keyAndCertificateFactory.x509Certificate(), this.keyAndCertificateFactory.certificateAuthorityX509Certificate()};
    }

    private X509Certificate[] jvmCAX509TrustCertificates(List<X509Certificate> additionalX509Certificates) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        return Arrays.stream(trustManagerFactory.getTrustManagers()).filter(trustManager -> trustManager instanceof X509TrustManager).flatMap(trustManager -> Arrays.stream(((X509TrustManager)trustManager).getAcceptedIssuers())).collect(() -> additionalX509Certificates, List::add, List::addAll).toArray(new X509Certificate[0]);
    }

    private X509Certificate[] customCAX509TrustCertificates() {
        ArrayList<X509Certificate> x509Certificates = new ArrayList<X509Certificate>();
        x509Certificates.add(this.keyAndCertificateFactory.x509Certificate());
        x509Certificates.add(this.keyAndCertificateFactory.certificateAuthorityX509Certificate());
        x509Certificates.addAll(PEMToFile.x509ChainFromPEMFile(this.configuration.forwardProxyTLSCustomTrustX509Certificates()));
        return x509Certificates.toArray(new X509Certificate[0]);
    }

    public synchronized SslContext createServerSslContext() {
        if (this.serverSslContext == null || this.keyAndCertificateFactory.certificateNotYetCreated() || this.configuration.rebuildServerTLSContext() && !this.configuration.preventCertificateDynamicUpdate().booleanValue()) {
            try {
                this.keyAndCertificateFactory.buildAndSavePrivateKeyAndX509Certificate();
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("using certificate authority serial:{}issuer:{}subject:{}and certificate serial:{}issuer:{}subject:{}").setArguments(this.keyAndCertificateFactory.certificateAuthorityX509Certificate().getSerialNumber(), this.keyAndCertificateFactory.certificateAuthorityX509Certificate().getIssuerDN(), this.keyAndCertificateFactory.certificateAuthorityX509Certificate().getSubjectDN(), this.keyAndCertificateFactory.x509Certificate().getSerialNumber(), this.keyAndCertificateFactory.x509Certificate().getIssuerDN(), this.keyAndCertificateFactory.x509Certificate().getSubjectDN()));
                SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((PrivateKey)this.keyAndCertificateFactory.privateKey(), (X509Certificate[])new X509Certificate[]{this.keyAndCertificateFactory.x509Certificate(), this.keyAndCertificateFactory.certificateAuthorityX509Certificate()}).protocols(TLS_PROTOCOLS).clientAuth(this.configuration.tlsMutualAuthenticationRequired() != false ? ClientAuth.REQUIRE : ClientAuth.OPTIONAL);
                if (this.configuration.tlsMutualAuthenticationRequired().booleanValue()) {
                    sslContextBuilder.trustManager(this.trustCertificateChain());
                } else {
                    sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                }
                this.serverSslContext = sslContextBuilder.build();
                this.configuration.rebuildServerTLSContext(false);
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception creating SSL context for server" + throwable.getMessage()).setThrowable(throwable));
            }
        }
        return this.serverSslContext;
    }

    private X509Certificate[] trustCertificateChain() {
        return this.trustCertificateChain(this.configuration.tlsMutualAuthenticationCertificateChain());
    }

    public X509Certificate[] trustCertificateChain(String tlsMutualAuthenticationCertificateChain) {
        if (StringUtils.isNotBlank((CharSequence)tlsMutualAuthenticationCertificateChain)) {
            List<X509Certificate> x509Certificates = PEMToFile.x509ChainFromPEMFile(tlsMutualAuthenticationCertificateChain);
            x509Certificates.add(this.keyAndCertificateFactory.certificateAuthorityX509Certificate());
            return x509Certificates.toArray(new X509Certificate[0]);
        }
        return Collections.singletonList(this.keyAndCertificateFactory.certificateAuthorityX509Certificate()).toArray(new X509Certificate[0]);
    }
}

