/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Scanner;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.DirectoryKeyCertificate;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.Key;
import org.torproject.descriptor.impl.ParseHelper;

public class DirectoryKeyCertificateImpl
extends DescriptorImpl
implements DirectoryKeyCertificate {
    private int dirKeyCertificateVersion;
    private String address;
    private int port = -1;
    private String fingerprint;
    private String dirIdentityKey;
    private long dirKeyPublishedMillis;
    private long dirKeyExpiresMillis;
    private String dirSigningKey;
    private String dirKeyCrosscert;
    private String dirKeyCertification;

    protected DirectoryKeyCertificateImpl(byte[] rawDescriptorBytes, int[] offsetAndLength, File descriptorFile) throws DescriptorParseException {
        super(rawDescriptorBytes, offsetAndLength, descriptorFile, false);
        this.parseDescriptorBytes();
        this.calculateDigestSha1Hex(Key.DIR_KEY_CERTIFICATE_VERSION.keyword + " ", "\n" + Key.DIR_KEY_CERTIFICATION.keyword + "\n");
        EnumSet<Key[]> exactlyOnceKeys = EnumSet.of(Key.DIR_KEY_CERTIFICATE_VERSION, new Key[]{Key.FINGERPRINT, Key.DIR_IDENTITY_KEY, Key.DIR_KEY_PUBLISHED, Key.DIR_KEY_EXPIRES, Key.DIR_SIGNING_KEY, Key.DIR_KEY_CERTIFICATION});
        this.checkExactlyOnceKeys(exactlyOnceKeys);
        EnumSet<Key> atMostOnceKeys = EnumSet.of(Key.DIR_ADDRESS, Key.DIR_KEY_CROSSCERT);
        this.checkAtMostOnceKeys(atMostOnceKeys);
        this.checkFirstKey(Key.DIR_KEY_CERTIFICATE_VERSION);
        this.checkLastKey(Key.DIR_KEY_CERTIFICATION);
        this.clearParsedKeys();
    }

    private void parseDescriptorBytes() throws DescriptorParseException {
        Scanner scanner = this.newScanner().useDelimiter("\n");
        Key nextCrypto = Key.EMPTY;
        StringBuilder crypto = null;
        block19: while (scanner.hasNext()) {
            String line = scanner.next();
            String[] parts = line.split("[ \t]+");
            Key key = Key.get(parts[0]);
            switch (key) {
                case DIR_KEY_CERTIFICATE_VERSION: {
                    this.parseDirKeyCertificateVersionLine(line);
                    continue block19;
                }
                case DIR_ADDRESS: {
                    this.parseDirAddressLine(line, parts);
                    continue block19;
                }
                case FINGERPRINT: {
                    this.parseFingerprintLine(line, parts);
                    continue block19;
                }
                case DIR_IDENTITY_KEY: {
                    this.parseDirIdentityKeyLine(line);
                    nextCrypto = key;
                    continue block19;
                }
                case DIR_KEY_PUBLISHED: {
                    this.parseDirKeyPublishedLine(line, parts);
                    continue block19;
                }
                case DIR_KEY_EXPIRES: {
                    this.parseDirKeyExpiresLine(line, parts);
                    continue block19;
                }
                case DIR_SIGNING_KEY: {
                    this.parseDirSigningKeyLine(line);
                    nextCrypto = key;
                    continue block19;
                }
                case DIR_KEY_CROSSCERT: {
                    this.parseDirKeyCrosscertLine(line);
                    nextCrypto = key;
                    continue block19;
                }
                case DIR_KEY_CERTIFICATION: {
                    this.parseDirKeyCertificationLine(line);
                    nextCrypto = key;
                    continue block19;
                }
                case CRYPTO_BEGIN: {
                    crypto = new StringBuilder();
                    crypto.append(line).append("\n");
                    continue block19;
                }
                case CRYPTO_END: {
                    crypto.append(line).append("\n");
                    String cryptoString = crypto.toString();
                    crypto = null;
                    switch (nextCrypto) {
                        case DIR_IDENTITY_KEY: {
                            this.dirIdentityKey = cryptoString;
                            break;
                        }
                        case DIR_SIGNING_KEY: {
                            this.dirSigningKey = cryptoString;
                            break;
                        }
                        case DIR_KEY_CROSSCERT: {
                            this.dirKeyCrosscert = cryptoString;
                            break;
                        }
                        case DIR_KEY_CERTIFICATION: {
                            this.dirKeyCertification = cryptoString;
                            break;
                        }
                        default: {
                            throw new DescriptorParseException("Unrecognized crypto block in directory key certificate.");
                        }
                    }
                    nextCrypto = Key.EMPTY;
                    continue block19;
                }
            }
            if (crypto != null) {
                crypto.append(line).append("\n");
                continue;
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    private void parseDirKeyCertificateVersionLine(String line) throws DescriptorParseException {
        if (!line.equals(Key.DIR_KEY_CERTIFICATE_VERSION.keyword + " " + "3")) {
            throw new DescriptorParseException("Illegal directory key certificate version number in line '" + line + "'.");
        }
        this.dirKeyCertificateVersion = 3;
    }

    private void parseDirAddressLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2 || parts[1].split(":").length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "' in directory key certificate.");
        }
        this.address = ParseHelper.parseIpv4Address(line, parts[1].split(":")[0]);
        this.port = ParseHelper.parsePort(line, parts[1].split(":")[1]);
    }

    private void parseFingerprintLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "' in directory key certificate.");
        }
        this.fingerprint = ParseHelper.parseTwentyByteHexString(line, parts[1]);
    }

    private void parseDirIdentityKeyLine(String line) throws DescriptorParseException {
        if (!line.equals(Key.DIR_IDENTITY_KEY.keyword)) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseDirKeyPublishedLine(String line, String[] parts) throws DescriptorParseException {
        this.dirKeyPublishedMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseDirKeyExpiresLine(String line, String[] parts) throws DescriptorParseException {
        this.dirKeyExpiresMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseDirSigningKeyLine(String line) throws DescriptorParseException {
        if (!line.equals(Key.DIR_SIGNING_KEY.keyword)) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseDirKeyCrosscertLine(String line) throws DescriptorParseException {
        if (!line.equals(Key.DIR_KEY_CROSSCERT.keyword)) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseDirKeyCertificationLine(String line) throws DescriptorParseException {
        if (!line.equals(Key.DIR_KEY_CERTIFICATION.keyword)) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    @Override
    public int getDirKeyCertificateVersion() {
        return this.dirKeyCertificateVersion;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public String getDirIdentityKey() {
        return this.dirIdentityKey;
    }

    @Override
    public long getDirKeyPublishedMillis() {
        return this.dirKeyPublishedMillis;
    }

    @Override
    public long getDirKeyExpiresMillis() {
        return this.dirKeyExpiresMillis;
    }

    @Override
    public String getDirSigningKey() {
        return this.dirSigningKey;
    }

    @Override
    public String getDirKeyCrosscert() {
        return this.dirKeyCrosscert;
    }

    @Override
    public String getDirKeyCertification() {
        return this.dirKeyCertification;
    }
}

