/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.DirSourceEntry;
import org.torproject.descriptor.DirectorySignature;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.DirSourceEntryImpl;
import org.torproject.descriptor.impl.DirectorySignatureImpl;
import org.torproject.descriptor.impl.Key;
import org.torproject.descriptor.impl.NetworkStatusEntryImpl;

public abstract class NetworkStatusImpl
extends DescriptorImpl {
    protected Map<String, Integer> flagIndexes = new HashMap<String, Integer>();
    protected Map<Integer, String> flagStrings = new HashMap<Integer, String>();
    protected SortedMap<String, DirSourceEntry> dirSourceEntries = new TreeMap<String, DirSourceEntry>();
    protected SortedMap<String, NetworkStatusEntry> statusEntries = new TreeMap<String, NetworkStatusEntry>();
    protected List<DirectorySignature> signatures;

    protected NetworkStatusImpl(byte[] rawDescriptorBytes, int[] offsetAndLength, File descriptorFile, boolean containsDirSourceEntries, boolean blankLinesAllowed) throws DescriptorParseException {
        super(rawDescriptorBytes, offsetAndLength, descriptorFile, blankLinesAllowed);
        this.splitAndParseParts(containsDirSourceEntries);
    }

    private void splitAndParseParts(boolean containsDirSourceEntries) throws DescriptorParseException {
        int firstDirSourceIndex;
        int directoryFooterIndex;
        int firstRIndex = this.findFirstIndexOfKey(Key.R);
        int firstDirectorySignatureIndex = this.findFirstIndexOfKey(Key.DIRECTORY_SIGNATURE);
        int endIndex = this.offset + this.length;
        if (firstDirectorySignatureIndex < 0) {
            firstDirectorySignatureIndex = endIndex;
        }
        if ((directoryFooterIndex = this.findFirstIndexOfKey(Key.DIRECTORY_FOOTER)) < 0) {
            directoryFooterIndex = firstDirectorySignatureIndex;
        }
        if (firstRIndex < 0) {
            firstRIndex = directoryFooterIndex;
        }
        int n = firstDirSourceIndex = !containsDirSourceEntries ? -1 : this.findFirstIndexOfKey(Key.DIR_SOURCE);
        if (firstDirSourceIndex < 0) {
            firstDirSourceIndex = firstRIndex;
        }
        if (firstDirSourceIndex > this.offset) {
            this.parseHeader(this.offset, firstDirSourceIndex - this.offset);
        }
        if (firstRIndex > firstDirSourceIndex) {
            this.parseDirSources(firstDirSourceIndex, firstRIndex - firstDirSourceIndex);
        }
        if (directoryFooterIndex > firstRIndex) {
            this.parseStatusEntries(firstRIndex, directoryFooterIndex - firstRIndex);
        }
        if (firstDirectorySignatureIndex > directoryFooterIndex) {
            this.parseFooter(directoryFooterIndex, firstDirectorySignatureIndex - directoryFooterIndex);
        }
        if (endIndex > firstDirectorySignatureIndex) {
            this.parseDirectorySignatures(firstDirectorySignatureIndex, endIndex - firstDirectorySignatureIndex);
        }
    }

    private void parseDirSources(int offset, int length) throws DescriptorParseException {
        List<int[]> offsetsAndLengths = this.splitByKey(Key.DIR_SOURCE, offset, length, false);
        for (int[] offsetAndLength : offsetsAndLengths) {
            this.parseDirSource(offsetAndLength[0], offsetAndLength[1]);
        }
    }

    private void parseStatusEntries(int offset, int length) throws DescriptorParseException {
        List<int[]> offsetsAndLengths = this.splitByKey(Key.R, offset, length, false);
        for (int[] offsetAndLength : offsetsAndLengths) {
            this.parseStatusEntry(offsetAndLength[0], offsetAndLength[1]);
        }
    }

    private void parseDirectorySignatures(int offset, int length) throws DescriptorParseException {
        List<int[]> offsetsAndLengths = this.splitByKey(Key.DIRECTORY_SIGNATURE, offset, length, false);
        for (int[] offsetAndLength : offsetsAndLengths) {
            this.parseDirectorySignature(offsetAndLength[0], offsetAndLength[1]);
        }
    }

    protected abstract void parseHeader(int var1, int var2) throws DescriptorParseException;

    protected void parseDirSource(int offset, int length) throws DescriptorParseException {
        DirSourceEntryImpl dirSourceEntry = new DirSourceEntryImpl(this, offset, length);
        this.dirSourceEntries.put(dirSourceEntry.getIdentity(), dirSourceEntry);
        List<String> unrecognizedDirSourceLines = dirSourceEntry.getAndClearUnrecognizedLines();
        if (unrecognizedDirSourceLines != null) {
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.addAll(unrecognizedDirSourceLines);
        }
    }

    protected String[] parseClientOrServerVersions(String line, String[] parts) throws DescriptorParseException {
        String[] result;
        switch (parts.length) {
            case 1: {
                result = new String[]{};
                break;
            }
            case 2: {
                for (String version : result = parts[1].split(",", -1)) {
                    if (version.length() >= 1) continue;
                    throw new DescriptorParseException("Illegal versions line '" + line + "'.");
                }
                break;
            }
            default: {
                throw new DescriptorParseException("Illegal versions line '" + line + "'.");
            }
        }
        return result;
    }

    protected void parseStatusEntry(int offset, int length) throws DescriptorParseException {
        NetworkStatusEntryImpl statusEntry = new NetworkStatusEntryImpl(this, offset, length, false, this.flagIndexes, this.flagStrings);
        this.statusEntries.put(statusEntry.getFingerprint(), statusEntry);
        List<String> unrecognizedStatusEntryLines = statusEntry.getAndClearUnrecognizedLines();
        if (unrecognizedStatusEntryLines != null) {
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.addAll(unrecognizedStatusEntryLines);
        }
    }

    protected abstract void parseFooter(int var1, int var2) throws DescriptorParseException;

    protected void parseDirectorySignature(int offset, int length) throws DescriptorParseException {
        if (this.signatures == null) {
            this.signatures = new ArrayList<DirectorySignature>();
        }
        DirectorySignatureImpl signature = new DirectorySignatureImpl(this, offset, length);
        this.signatures.add(signature);
        List<String> unrecognizedStatusEntryLines = signature.getAndClearUnrecognizedLines();
        if (unrecognizedStatusEntryLines != null) {
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.addAll(unrecognizedStatusEntryLines);
        }
    }

    public SortedMap<String, DirSourceEntry> getDirSourceEntries() {
        return new TreeMap<String, DirSourceEntry>(this.dirSourceEntries);
    }

    public SortedMap<String, NetworkStatusEntry> getStatusEntries() {
        return new TreeMap<String, NetworkStatusEntry>(this.statusEntries);
    }

    public boolean containsStatusEntry(String fingerprint) {
        return this.statusEntries.containsKey(fingerprint);
    }

    public NetworkStatusEntry getStatusEntry(String fingerprint) {
        return (NetworkStatusEntry)this.statusEntries.get(fingerprint);
    }

    public List<DirectorySignature> getSignatures() {
        return this.signatures == null ? null : new ArrayList<DirectorySignature>(this.signatures);
    }

    public SortedMap<String, DirectorySignature> getDirectorySignatures() {
        TreeMap<String, DirectorySignature> directorySignatures = null;
        if (this.signatures != null) {
            directorySignatures = new TreeMap<String, DirectorySignature>();
            for (DirectorySignature signature : this.signatures) {
                directorySignatures.put(signature.getIdentity(), signature);
            }
        }
        return directorySignatures;
    }
}

