/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.SortedSet;
import java.util.TreeSet;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.ExitList;
import org.torproject.descriptor.impl.ParseHelper;

public class ExitListEntryImpl
implements ExitList.Entry {
    private String exitListEntryString;
    private List<String> unrecognizedLines;
    private SortedSet<String> keywordCountingSet;
    private String fingerprint;
    private long publishedMillis;
    private long lastStatusMillis;
    private Map<String, Long> exitAddresses = new HashMap<String, Long>();

    protected List<String> getAndClearUnrecognizedLines() {
        List<String> lines = this.unrecognizedLines;
        this.unrecognizedLines = null;
        return lines;
    }

    protected ExitListEntryImpl(String exitListEntryString) throws DescriptorParseException {
        this.exitListEntryString = exitListEntryString;
        this.initializeKeywords();
        this.parseExitListEntry();
        this.checkAndClearKeywords();
    }

    private void initializeKeywords() {
        this.keywordCountingSet = new TreeSet<String>();
        this.keywordCountingSet.add("ExitNode");
        this.keywordCountingSet.add("Published");
        this.keywordCountingSet.add("LastStatus");
        this.keywordCountingSet.add("ExitAddress");
    }

    private void parsedExactlyOnceKeyword(String keyword) throws DescriptorParseException {
        if (!this.keywordCountingSet.contains(keyword)) {
            throw new DescriptorParseException("Duplicate '" + keyword + "' line in exit list entry.");
        }
        this.keywordCountingSet.remove(keyword);
    }

    private void checkAndClearKeywords() throws DescriptorParseException {
        Iterator iterator = this.keywordCountingSet.iterator();
        if (iterator.hasNext()) {
            String missingKeyword = (String)iterator.next();
            throw new DescriptorParseException("Missing '" + missingKeyword + "' line in exit list entry.");
        }
        this.keywordCountingSet = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseExitListEntry() throws DescriptorParseException {
        try (Scanner scanner = new Scanner(this.exitListEntryString).useDelimiter("\n");){
            block17: while (scanner.hasNext()) {
                String keyword;
                String line = scanner.next();
                String[] parts = line.split(" ");
                switch (keyword = parts[0]) {
                    case "ExitNode": {
                        this.parseExitNodeLine(line, parts);
                        continue block17;
                    }
                    case "Published": {
                        this.parsePublishedLine(line, parts);
                        continue block17;
                    }
                    case "LastStatus": {
                        this.parseLastStatusLine(line, parts);
                        continue block17;
                    }
                    case "ExitAddress": {
                        this.parseExitAddressLine(line, parts);
                        continue block17;
                    }
                }
                if (this.unrecognizedLines == null) {
                    this.unrecognizedLines = new ArrayList<String>();
                }
                this.unrecognizedLines.add(line);
            }
            return;
        }
    }

    private void parseExitNodeLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2) {
            throw new DescriptorParseException("Invalid line '" + line + "' in exit list entry.");
        }
        this.parsedExactlyOnceKeyword(parts[0]);
        this.fingerprint = ParseHelper.parseTwentyByteHexString(line, parts[1]);
    }

    private void parsePublishedLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 3) {
            throw new DescriptorParseException("Invalid line '" + line + "' in exit list entry.");
        }
        this.parsedExactlyOnceKeyword(parts[0]);
        this.publishedMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseLastStatusLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 3) {
            throw new DescriptorParseException("Invalid line '" + line + "' in exit list entry.");
        }
        this.parsedExactlyOnceKeyword(parts[0]);
        this.lastStatusMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseExitAddressLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 4) {
            throw new DescriptorParseException("Invalid line '" + line + "' in exit list entry.");
        }
        this.keywordCountingSet.remove(parts[0]);
        this.exitAddresses.put(ParseHelper.parseIpv4Address(line, parts[1]), ParseHelper.parseTimestampAtIndex(line, parts, 2, 3));
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public long getPublishedMillis() {
        return this.publishedMillis;
    }

    @Override
    public long getLastStatusMillis() {
        return this.lastStatusMillis;
    }

    @Override
    public Map<String, Long> getExitAddresses() {
        return new HashMap<String, Long>(this.exitAddresses);
    }
}

