/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.updater;

import java.util.HashMap;
import java.util.Map;

public enum TorVersionStatus {
    RECOMMENDED("recommended", "r"),
    EXPERIMENTAL("experimental", "e"),
    OBSOLETE("obsolete", "o"),
    NEW_IN_SERIES("new in series", "n"),
    UNRECOMMENDED("unrecommended", "u");

    private final String statusString;
    private final String abbreviation;
    private static Map<String, TorVersionStatus> byAbbreviation;

    private TorVersionStatus(String statusString, String abbreviation) {
        this.statusString = statusString;
        this.abbreviation = abbreviation;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public static TorVersionStatus ofAbbreviation(String abbrevation) {
        return byAbbreviation.get(abbrevation);
    }

    public String toString() {
        return this.statusString;
    }

    static {
        byAbbreviation = new HashMap<String, TorVersionStatus>();
        for (TorVersionStatus status : TorVersionStatus.values()) {
            byAbbreviation.put(status.abbreviation, status);
        }
    }
}

