/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.docs;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeHelper {
    public static final long NO_TIME_AVAILABLE = -1L;
    private static final Logger log = LoggerFactory.getLogger(DateTimeHelper.class);
    public static final long ONE_SECOND = 1000L;
    public static final long TEN_SECONDS = 10000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long FIVE_MINUTES = 300000L;
    public static final long FIFTEEN_MINUTES = 900000L;
    public static final long FOURTY_FIVE_MINUTES = 2700000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long FOUR_HOURS = 14400000L;
    public static final long SIX_HOURS = 21600000L;
    public static final long TWELVE_HOURS = 43200000L;
    public static final long ONE_DAY = 86400000L;
    public static final long TWO_DAYS = 172800000L;
    public static final long THREE_DAYS = 259200000L;
    public static final long ONE_WEEK = 604800000L;
    public static final long TEN_DAYS = 864000000L;
    public static final long ROUGHLY_ONE_MONTH = 2678400000L;
    public static final long ROUGHLY_THREE_MONTHS = 7948800000L;
    public static final long ROUGHLY_SIX_MONTHS = 15811200000L;
    public static final long ROUGHLY_ONE_YEAR = 31622400000L;
    public static final long ROUGHLY_FIVE_YEARS = 158112000000L;
    public static final String ISO_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String ISO_DATETIME_TAB_FORMAT = "yyyy-MM-dd\tHH:mm:ss";
    public static final String ISO_YEARMONTH_FORMAT = "yyyy-MM";
    public static final String DATEHOUR_NOSPACE_FORMAT = "yyyy-MM-dd-HH";
    private static ThreadLocal<Map<String, DateFormat>> dateFormats = ThreadLocal.withInitial(HashMap::new);

    private DateTimeHelper() {
    }

    private static DateFormat getDateFormat(String format) {
        Map<String, DateFormat> threadDateFormats = dateFormats.get();
        if (!threadDateFormats.containsKey(format)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            dateFormat.setLenient(false);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            threadDateFormats.put(format, dateFormat);
        }
        return threadDateFormats.get(format);
    }

    public static String format(long millis, String format) {
        return DateTimeHelper.getDateFormat(format).format(millis);
    }

    public static String format(long millis) {
        return DateTimeHelper.format(millis, ISO_DATETIME_FORMAT);
    }

    public static long parse(String string, String format) {
        if (null == string) {
            log.warn("Date String was null.");
            return -1L;
        }
        try {
            return DateTimeHelper.getDateFormat(format).parse(string).getTime();
        }
        catch (ParseException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return -1L;
        }
    }

    public static long parse(String string) {
        return DateTimeHelper.parse(string, ISO_DATETIME_FORMAT);
    }
}

