/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.docs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.onionoo.docs.BandwidthDocument;
import org.torproject.metrics.onionoo.docs.BandwidthStatus;
import org.torproject.metrics.onionoo.docs.ClientsDocument;
import org.torproject.metrics.onionoo.docs.ClientsStatus;
import org.torproject.metrics.onionoo.docs.DetailsDocument;
import org.torproject.metrics.onionoo.docs.DetailsStatus;
import org.torproject.metrics.onionoo.docs.Document;
import org.torproject.metrics.onionoo.docs.NodeStatus;
import org.torproject.metrics.onionoo.docs.SummaryDocument;
import org.torproject.metrics.onionoo.docs.UpdateStatus;
import org.torproject.metrics.onionoo.docs.UptimeDocument;
import org.torproject.metrics.onionoo.docs.UptimeStatus;
import org.torproject.metrics.onionoo.docs.WeightsDocument;
import org.torproject.metrics.onionoo.docs.WeightsStatus;
import org.torproject.metrics.onionoo.util.FormattingUtils;

public class DocumentStore {
    private static Logger log = LoggerFactory.getLogger(DocumentStore.class);
    private static ObjectMapper objectMapper = new ObjectMapper();
    private final File statusDir = new File("status");
    private File outDir = null;
    private long listOperations = 0L;
    private long listedFiles = 0L;
    private long storedFiles = 0L;
    private long storedBytes = 0L;
    private long unchangedFiles = 0L;
    private long unchangedBytes = 0L;
    private long retrievedFiles = 0L;
    private long retrievedBytes = 0L;
    private long removedFiles = 0L;
    private SortedMap<String, NodeStatus> cachedNodeStatuses;
    private SortedMap<String, SummaryDocument> cachedSummaryDocuments;
    private long lastModifiedNodeStatuses = 0L;
    private long lastModifiedSummaryDocuments = 0L;
    private SortedSet<String> updatedNodeStatuses;
    private SortedSet<String> updatedSummaryDocuments;
    private static final long ONE_BYTE = 1L;
    private static final long ONE_KIBIBYTE = 1024L;
    private static final long ONE_MIBIBYTE = 0x100000L;

    public void setOutDir(File outDir) {
        this.outDir = outDir;
    }

    public <T extends Document> SortedSet<String> list(Class<T> documentType) {
        return this.list(documentType, 0L);
    }

    public <T extends Document> SortedSet<String> list(Class<T> documentType, long updatedAfter) {
        if (documentType.equals(NodeStatus.class)) {
            return this.listNodeStatuses(updatedAfter);
        }
        if (documentType.equals(SummaryDocument.class)) {
            return this.listSummaryDocuments(updatedAfter);
        }
        return this.listDocumentFiles(documentType, updatedAfter);
    }

    private SortedSet<String> listNodeStatuses(long updatedAfter) {
        if (this.cachedNodeStatuses == null) {
            this.cacheNodeStatuses();
        }
        if (updatedAfter >= this.lastModifiedNodeStatuses) {
            return new TreeSet<String>(this.updatedNodeStatuses);
        }
        return new TreeSet<String>(this.cachedNodeStatuses.keySet());
    }

    private void cacheNodeStatuses() {
        File summaryFile;
        TreeMap<String, NodeStatus> parsedNodeStatuses = new TreeMap<String, NodeStatus>();
        File directory = this.statusDir;
        if (directory != null && (summaryFile = new File(directory, "summary")).exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(summaryFile));){
                String line;
                while ((line = br.readLine()) != null) {
                    NodeStatus node;
                    if (line.length() == 0 || (node = NodeStatus.fromString(line)) == null) continue;
                    parsedNodeStatuses.put(node.getFingerprint(), node);
                }
                this.lastModifiedNodeStatuses = summaryFile.lastModified();
                this.listedFiles += (long)parsedNodeStatuses.size();
                ++this.listOperations;
            }
            catch (IOException e) {
                log.error("Could not read file '{}'.", (Object)summaryFile.getAbsolutePath(), (Object)e);
            }
        }
        this.cachedNodeStatuses = parsedNodeStatuses;
        this.updatedNodeStatuses = new TreeSet<String>();
    }

    private SortedSet<String> listSummaryDocuments(long updatedAfter) {
        if (this.cachedSummaryDocuments == null) {
            this.cacheSummaryDocuments();
        }
        if (updatedAfter >= this.lastModifiedSummaryDocuments) {
            return new TreeSet<String>(this.updatedSummaryDocuments);
        }
        return new TreeSet<String>(this.cachedSummaryDocuments.keySet());
    }

    private void cacheSummaryDocuments() {
        File summaryFile;
        TreeMap<String, SummaryDocument> parsedSummaryDocuments = new TreeMap<String, SummaryDocument>();
        if (this.outDir != null && (summaryFile = new File(this.outDir, "summary")).exists()) {
            String line = null;
            try (BufferedReader br = new BufferedReader(new FileReader(summaryFile));){
                while ((line = br.readLine()) != null) {
                    SummaryDocument summaryDocument;
                    if (line.length() == 0 || (summaryDocument = (SummaryDocument)objectMapper.readValue(line, SummaryDocument.class)) == null) continue;
                    parsedSummaryDocuments.put(summaryDocument.getFingerprint(), summaryDocument);
                }
                this.lastModifiedSummaryDocuments = summaryFile.lastModified();
                this.listedFiles += (long)parsedSummaryDocuments.size();
                ++this.listOperations;
            }
            catch (IOException e) {
                log.error("Could not parse summary document '{}' from file '{}'.", new Object[]{line, summaryFile.getAbsolutePath(), e});
            }
        }
        this.cachedSummaryDocuments = parsedSummaryDocuments;
        this.updatedSummaryDocuments = new TreeSet<String>();
    }

    private <T extends Document> SortedSet<String> listDocumentFiles(Class<T> documentType, long updatedAfter) {
        TreeSet<String> fingerprints = new TreeSet<String>();
        File directory = null;
        String subdirectory = null;
        if (documentType.equals(DetailsStatus.class)) {
            directory = this.statusDir;
            subdirectory = "details";
        } else if (documentType.equals(BandwidthStatus.class)) {
            directory = this.statusDir;
            subdirectory = "bandwidth";
        } else if (documentType.equals(WeightsStatus.class)) {
            directory = this.statusDir;
            subdirectory = "weights";
        } else if (documentType.equals(ClientsStatus.class)) {
            directory = this.statusDir;
            subdirectory = "clients";
        } else if (documentType.equals(UptimeStatus.class)) {
            directory = this.statusDir;
            subdirectory = "uptimes";
        } else if (documentType.equals(DetailsDocument.class)) {
            directory = this.outDir;
            subdirectory = "details";
        } else if (documentType.equals(BandwidthDocument.class)) {
            directory = this.outDir;
            subdirectory = "bandwidth";
        } else if (documentType.equals(WeightsDocument.class)) {
            directory = this.outDir;
            subdirectory = "weights";
        } else if (documentType.equals(ClientsDocument.class)) {
            directory = this.outDir;
            subdirectory = "clients";
        } else if (documentType.equals(UptimeDocument.class)) {
            directory = this.outDir;
            subdirectory = "uptimes";
        }
        if (directory != null && subdirectory != null) {
            Stack<File> files = new Stack<File>();
            files.add(new File(directory, subdirectory));
            while (!files.isEmpty()) {
                File file = (File)files.pop();
                if (file.isDirectory()) {
                    files.addAll(Arrays.asList(file.listFiles()));
                    continue;
                }
                if (file.getName().length() != 40 || updatedAfter != 0L && file.lastModified() <= updatedAfter) continue;
                fingerprints.add(file.getName());
            }
        }
        ++this.listOperations;
        this.listedFiles += (long)fingerprints.size();
        return fingerprints;
    }

    public <T extends Document> boolean store(T document) {
        return this.store(document, null);
    }

    public <T extends Document> boolean store(T document, String fingerprint) {
        if (document instanceof NodeStatus) {
            return this.storeNodeStatus((NodeStatus)document, fingerprint);
        }
        if (document instanceof SummaryDocument) {
            return this.storeSummaryDocument((SummaryDocument)document, fingerprint);
        }
        return this.storeDocumentFile(document, fingerprint);
    }

    private <T extends Document> boolean storeNodeStatus(NodeStatus nodeStatus, String fingerprint) {
        if (this.cachedNodeStatuses == null) {
            this.cacheNodeStatuses();
        }
        this.updatedNodeStatuses.add(fingerprint);
        this.cachedNodeStatuses.put(fingerprint, nodeStatus);
        return true;
    }

    private <T extends Document> boolean storeSummaryDocument(SummaryDocument summaryDocument, String fingerprint) {
        if (this.cachedSummaryDocuments == null) {
            this.cacheSummaryDocuments();
        }
        this.updatedSummaryDocuments.add(fingerprint);
        this.cachedSummaryDocuments.put(fingerprint, summaryDocument);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends Document> boolean storeDocumentFile(T document, String fingerprint) {
        String documentString;
        File documentFile = this.getDocumentFile(document.getClass(), fingerprint);
        if (documentFile == null) {
            return false;
        }
        if (document.getDocumentString() != null) {
            documentString = document.getDocumentString();
        } else {
            if (document instanceof BandwidthDocument || document instanceof WeightsDocument || document instanceof ClientsDocument || document instanceof UptimeDocument) {
                try {
                    documentString = objectMapper.writeValueAsString(document);
                }
                catch (JsonProcessingException e) {
                    log.error("Serializing failed for type {}.", (Object)document.getClass().getName(), (Object)e);
                    return false;
                }
            }
            if (document instanceof DetailsStatus || document instanceof DetailsDocument) {
                try {
                    documentString = FormattingUtils.replaceValidUtf(objectMapper.writeValueAsString(document));
                }
                catch (JsonProcessingException e) {
                    log.error("Serializing failed for type {}.", (Object)document.getClass().getName(), (Object)e);
                    return false;
                }
                if (document instanceof DetailsStatus) {
                    documentString = documentString.substring(documentString.indexOf("{") + 1, documentString.lastIndexOf("}"));
                }
            } else {
                if (!(document instanceof BandwidthStatus || document instanceof WeightsStatus || document instanceof ClientsStatus || document instanceof UptimeStatus || document instanceof UpdateStatus)) {
                    log.error("Serializing is not supported for type {}.", (Object)document.getClass().getName());
                    return false;
                }
                documentString = document.toDocumentString();
            }
        }
        try {
            if ((long)documentString.length() > 0x100000L) {
                log.warn("Attempting to store very large document file: path='{}', bytes={}", (Object)documentFile.getAbsolutePath(), (Object)documentString.length());
            }
            documentFile.getParentFile().mkdirs();
            if (documentFile.exists()) {
                try (InputStream stream = Files.newInputStream(documentFile.toPath(), new OpenOption[0]);){
                    String existingFileDigest = DigestUtils.sha256Hex((InputStream)stream);
                    String newFileDigest = DigestUtils.sha256Hex((String)documentString);
                    if (existingFileDigest.equals(newFileDigest)) {
                        ++this.unchangedFiles;
                        this.unchangedBytes += (long)documentString.length();
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            File documentTempFile = new File(documentFile.getAbsolutePath() + ".tmp");
            DocumentStore.writeToFile(documentTempFile, documentString);
            documentFile.delete();
            documentTempFile.renameTo(documentFile);
            ++this.storedFiles;
            this.storedBytes += (long)documentString.length();
            return true;
        }
        catch (IOException e) {
            log.error("Could not write file '{}'.", (Object)documentFile.getAbsolutePath(), (Object)e);
            return false;
        }
    }

    public <T extends Document> T retrieve(Class<T> documentType, boolean parse) {
        return this.retrieve(documentType, parse, null);
    }

    public <T extends Document> T retrieve(Class<T> documentType, boolean parse, String fingerprint) {
        if (documentType.equals(NodeStatus.class)) {
            return (T)((Document)documentType.cast(this.retrieveNodeStatus(fingerprint)));
        }
        if (documentType.equals(SummaryDocument.class)) {
            return (T)((Document)documentType.cast(this.retrieveSummaryDocument(fingerprint)));
        }
        return this.retrieveDocumentFile(documentType, parse, fingerprint);
    }

    private NodeStatus retrieveNodeStatus(String fingerprint) {
        if (this.cachedNodeStatuses == null) {
            this.cacheNodeStatuses();
        }
        return (NodeStatus)this.cachedNodeStatuses.get(fingerprint);
    }

    private SummaryDocument retrieveSummaryDocument(String fingerprint) {
        if (this.cachedSummaryDocuments == null) {
            this.cacheSummaryDocuments();
        }
        if (this.cachedSummaryDocuments.containsKey(fingerprint)) {
            return (SummaryDocument)this.cachedSummaryDocuments.get(fingerprint);
        }
        DetailsDocument detailsDocument = this.retrieveDocumentFile(DetailsDocument.class, true, fingerprint);
        if (detailsDocument == null) {
            return null;
        }
        boolean isRelay = detailsDocument.getHashedFingerprint() == null;
        boolean running = false;
        String nickname = detailsDocument.getNickname();
        ArrayList<String> addresses = new ArrayList<String>();
        String countryCode = null;
        String asNumber = null;
        String asName = null;
        String contact = null;
        for (String orAddressAndPort : detailsDocument.getOrAddresses()) {
            if (!orAddressAndPort.contains(":")) {
                log.warn("Attempt to create summary document from details document for fingerprint {} failed because of invalid OR address/port: '{}'. Not returning a summary document in this case.", (Object)fingerprint, (Object)orAddressAndPort);
                return null;
            }
            String orAddress = orAddressAndPort.substring(0, orAddressAndPort.lastIndexOf(":"));
            if (addresses.contains(orAddress)) continue;
            addresses.add(orAddress);
        }
        if (detailsDocument.getExitAddresses() != null) {
            for (String exitAddress : detailsDocument.getExitAddresses()) {
                if (addresses.contains(exitAddress)) continue;
                addresses.add(exitAddress);
            }
        }
        TreeSet<String> relayFlags = new TreeSet<String>();
        SortedSet<String> family = null;
        String version = null;
        String operatingSystem = null;
        long lastSeenMillis = -1L;
        long consensusWeight = -1L;
        long firstSeenMillis = -1L;
        SortedSet<String> verifiedHostNames = null;
        SortedSet<String> unverifiedHostNames = null;
        Boolean recommendedVersion = null;
        return new SummaryDocument(isRelay, nickname, fingerprint, addresses, lastSeenMillis, running, relayFlags, consensusWeight, countryCode, firstSeenMillis, asNumber, asName, contact, family, family, version, operatingSystem, verifiedHostNames, unverifiedHostNames, recommendedVersion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends Document> T retrieveDocumentFile(Class<T> documentType, boolean parse, String fingerprint) {
        String documentString;
        File documentFile = this.getDocumentFile(documentType, fingerprint);
        if (documentFile == null) return null;
        if (!documentFile.exists()) {
            return null;
        }
        if (documentFile.isDirectory()) {
            log.error("Could not read file '{}', because it is a directory.", (Object)documentFile.getAbsolutePath());
            return null;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             BufferedInputStream bis = new BufferedInputStream(new FileInputStream(documentFile));){
            int len;
            byte[] data = new byte[1024];
            while ((len = bis.read(data, 0, 1024)) >= 0) {
                baos.write(data, 0, len);
            }
            byte[] allData = baos.toByteArray();
            if (allData.length == 0) {
                T t = null;
                return t;
            }
            documentString = new String(allData, StandardCharsets.US_ASCII);
            ++this.retrievedFiles;
            this.retrievedBytes += (long)documentString.length();
        }
        catch (IOException e) {
            log.error("Could not read file '{}'.", (Object)documentFile.getAbsolutePath(), (Object)e);
            return null;
        }
        if ((long)documentString.length() > 0x100000L) {
            log.warn("Retrieved very large document file: path='{}', bytes={}", (Object)documentFile.getAbsolutePath(), (Object)documentString.length());
        }
        T result = null;
        if (!parse) {
            return this.retrieveUnparsedDocumentFile(documentType, documentString);
        }
        if (documentType.equals(DetailsDocument.class)) return this.retrieveParsedDocumentFile(documentType, documentString);
        if (documentType.equals(BandwidthDocument.class)) return this.retrieveParsedDocumentFile(documentType, documentString);
        if (documentType.equals(WeightsDocument.class)) return this.retrieveParsedDocumentFile(documentType, documentString);
        if (documentType.equals(ClientsDocument.class)) return this.retrieveParsedDocumentFile(documentType, documentString);
        if (documentType.equals(UptimeDocument.class)) {
            return this.retrieveParsedDocumentFile(documentType, documentString);
        }
        if (documentType.equals(BandwidthStatus.class)) return this.retrieveParsedStatusFile(documentType, documentString);
        if (documentType.equals(WeightsStatus.class)) return this.retrieveParsedStatusFile(documentType, documentString);
        if (documentType.equals(ClientsStatus.class)) return this.retrieveParsedStatusFile(documentType, documentString);
        if (documentType.equals(UptimeStatus.class)) return this.retrieveParsedStatusFile(documentType, documentString);
        if (documentType.equals(UpdateStatus.class)) {
            return this.retrieveParsedStatusFile(documentType, documentString);
        }
        if (documentType.equals(DetailsStatus.class)) {
            return this.retrieveParsedDocumentFile(documentType, "{" + documentString + "}");
        }
        log.error("Parsing is not supported for type {}.", (Object)documentType.getName());
        return result;
    }

    private <T extends Document> T retrieveParsedStatusFile(Class<T> documentType, String documentString) {
        Document result = null;
        try {
            result = (Document)documentType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            result.setFromDocumentString(documentString);
        }
        catch (ReflectiveOperationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (result == null) {
            log.error("Could not initialize parsed status file of type {}.", (Object)documentType.getName());
        }
        return (T)result;
    }

    private <T extends Document> T retrieveParsedDocumentFile(Class<T> documentType, String documentString) {
        Document result = null;
        try {
            result = (Document)objectMapper.readValue(documentString, documentType);
        }
        catch (Throwable e) {
            log.error(documentString);
            log.error(e.getMessage(), e);
        }
        if (result == null) {
            log.error("Could not initialize parsed document of type {}.", (Object)documentType.getName());
        }
        return (T)result;
    }

    private <T extends Document> T retrieveUnparsedDocumentFile(Class<T> documentType, String documentString) {
        Document result = null;
        try {
            result = (Document)documentType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            result.setDocumentString(documentString);
        }
        catch (ReflectiveOperationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (result == null) {
            log.error("Could not initialize unparsed document of type {}.", (Object)documentType.getName());
        }
        return (T)result;
    }

    public <T extends Document> boolean remove(Class<T> documentType) {
        return this.remove(documentType, null);
    }

    public <T extends Document> boolean remove(Class<T> documentType, String fingerprint) {
        if (documentType.equals(NodeStatus.class)) {
            return this.removeNodeStatus(fingerprint);
        }
        if (documentType.equals(SummaryDocument.class)) {
            return this.removeSummaryDocument(fingerprint);
        }
        return this.removeDocumentFile(documentType, fingerprint);
    }

    private boolean removeNodeStatus(String fingerprint) {
        if (this.cachedNodeStatuses == null) {
            this.cacheNodeStatuses();
        }
        this.updatedNodeStatuses.remove(fingerprint);
        return this.cachedNodeStatuses.remove(fingerprint) != null;
    }

    private boolean removeSummaryDocument(String fingerprint) {
        if (this.cachedSummaryDocuments == null) {
            this.cacheSummaryDocuments();
        }
        this.updatedSummaryDocuments.remove(fingerprint);
        return this.cachedSummaryDocuments.remove(fingerprint) != null;
    }

    private <T extends Document> boolean removeDocumentFile(Class<T> documentType, String fingerprint) {
        File documentFile = this.getDocumentFile(documentType, fingerprint);
        if (documentFile == null || !documentFile.delete()) {
            log.error("Could not delete file '{}'.", (Object)documentFile.getAbsolutePath());
            return false;
        }
        ++this.removedFiles;
        return true;
    }

    private <T extends Document> File getDocumentFile(Class<T> documentType, String fingerprint) {
        File documentFile = null;
        if (fingerprint == null && !documentType.equals(UpdateStatus.class) && !documentType.equals(UptimeStatus.class)) {
            log.warn("Attempted to locate a document file of type {} without providing a fingerprint.  Such a file does not exist.", (Object)documentType.getName());
            return null;
        }
        File directory = null;
        String fileName = null;
        if (documentType.equals(DetailsStatus.class)) {
            directory = this.statusDir;
            fileName = String.format("details/%s/%s/%s", fingerprint.substring(0, 1), fingerprint.substring(1, 2), fingerprint);
        } else if (documentType.equals(BandwidthStatus.class)) {
            directory = this.statusDir;
            fileName = String.format("bandwidth/%s/%s/%s", fingerprint.substring(0, 1), fingerprint.substring(1, 2), fingerprint);
        } else if (documentType.equals(WeightsStatus.class)) {
            directory = this.statusDir;
            fileName = String.format("weights/%s/%s/%s", fingerprint.substring(0, 1), fingerprint.substring(1, 2), fingerprint);
        } else if (documentType.equals(ClientsStatus.class)) {
            directory = this.statusDir;
            fileName = String.format("clients/%s/%s/%s", fingerprint.substring(0, 1), fingerprint.substring(1, 2), fingerprint);
        } else if (documentType.equals(UptimeStatus.class)) {
            directory = this.statusDir;
            fileName = fingerprint == null ? "uptime" : String.format("uptimes/%s/%s/%s", fingerprint.substring(0, 1), fingerprint.substring(1, 2), fingerprint);
        } else if (documentType.equals(UpdateStatus.class)) {
            directory = this.outDir;
            fileName = "update";
        } else if (documentType.equals(DetailsDocument.class)) {
            directory = this.outDir;
            fileName = String.format("details/%s", fingerprint);
        } else if (documentType.equals(BandwidthDocument.class)) {
            directory = this.outDir;
            fileName = String.format("bandwidth/%s", fingerprint);
        } else if (documentType.equals(WeightsDocument.class)) {
            directory = this.outDir;
            fileName = String.format("weights/%s", fingerprint);
        } else if (documentType.equals(ClientsDocument.class)) {
            directory = this.outDir;
            fileName = String.format("clients/%s", fingerprint);
        } else if (documentType.equals(UptimeDocument.class)) {
            directory = this.outDir;
            fileName = String.format("uptimes/%s", fingerprint);
        }
        if (directory != null && fileName != null) {
            documentFile = new File(directory, fileName);
        }
        return documentFile;
    }

    public void flushDocumentCache() {
        if (this.cachedNodeStatuses != null || this.cachedSummaryDocuments != null) {
            if (this.cachedNodeStatuses != null) {
                this.writeNodeStatuses();
            }
            if (this.cachedSummaryDocuments != null) {
                this.writeSummaryDocuments();
            }
            this.writeUpdateStatus();
        }
    }

    public void invalidateDocumentCache() {
        this.cachedNodeStatuses = null;
        this.cachedSummaryDocuments = null;
        this.lastModifiedNodeStatuses = 0L;
        this.lastModifiedSummaryDocuments = 0L;
        this.updatedNodeStatuses = null;
        this.updatedSummaryDocuments = null;
    }

    private void writeNodeStatuses() {
        String line;
        File directory = this.statusDir;
        if (directory == null) {
            log.error("Unable to write node statuses without knowing the 'status' directory to write to!");
            return;
        }
        File summaryFile = new File(directory, "summary");
        TreeMap<String, NodeStatus> cachedRelays = new TreeMap<String, NodeStatus>();
        TreeMap<String, NodeStatus> cachedBridges = new TreeMap<String, NodeStatus>();
        for (Map.Entry<String, NodeStatus> entry : this.cachedNodeStatuses.entrySet()) {
            if (entry.getValue().isRelay()) {
                cachedRelays.put(entry.getKey(), entry.getValue());
                continue;
            }
            cachedBridges.put(entry.getKey(), entry.getValue());
        }
        StringBuilder sb = new StringBuilder();
        for (NodeStatus relay : cachedRelays.values()) {
            line = relay.toString();
            if (line != null) {
                sb.append(line).append("\n");
                continue;
            }
            log.error("Could not serialize relay node status '{}'", (Object)relay.getFingerprint());
        }
        for (NodeStatus bridge : cachedBridges.values()) {
            line = bridge.toString();
            if (line != null) {
                sb.append(line).append("\n");
                continue;
            }
            log.error("Could not serialize bridge node status '{}'", (Object)bridge.getFingerprint());
        }
        String string = sb.toString();
        try {
            summaryFile.getParentFile().mkdirs();
            DocumentStore.writeToFile(summaryFile, string);
            this.lastModifiedNodeStatuses = summaryFile.lastModified();
            this.updatedNodeStatuses.clear();
            ++this.storedFiles;
            this.storedBytes += (long)string.length();
        }
        catch (IOException e) {
            log.error("Could not write file '{}'.", (Object)summaryFile.getAbsolutePath(), (Object)e);
        }
    }

    private static void writeToFile(File file, String content) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));){
            bos.write(content.getBytes(StandardCharsets.US_ASCII));
        }
    }

    private void writeSummaryDocuments() {
        if (this.outDir == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (SummaryDocument summaryDocument : this.cachedSummaryDocuments.values()) {
            String line;
            try {
                line = objectMapper.writeValueAsString((Object)summaryDocument);
            }
            catch (JsonProcessingException e) {
                line = null;
            }
            if (line != null) {
                sb.append(line).append("\n");
                continue;
            }
            log.error("Could not serialize relay summary document '{}'", (Object)summaryDocument.getFingerprint());
        }
        String documentString = sb.toString();
        File summaryFile = new File(this.outDir, "summary");
        try {
            summaryFile.getParentFile().mkdirs();
            DocumentStore.writeToFile(summaryFile, documentString);
            this.lastModifiedSummaryDocuments = summaryFile.lastModified();
            this.updatedSummaryDocuments.clear();
            ++this.storedFiles;
            this.storedBytes += (long)documentString.length();
        }
        catch (IOException e) {
            log.error("Could not write file '{}'.", (Object)summaryFile.getAbsolutePath(), (Object)e);
        }
    }

    private void writeUpdateStatus() {
        if (this.outDir == null) {
            return;
        }
        UpdateStatus updateStatus = new UpdateStatus();
        updateStatus.setUpdatedMillis(System.currentTimeMillis());
        this.store(updateStatus);
    }

    public String getStatsString() {
        return String.format("    %s list operations performed\n    %s files listed\n    %s files stored\n    %s stored\n    %s files not rewritten\n    %s not rewritten\n    %s files retrieved\n    %s retrieved\n    %s files removed\n", FormattingUtils.formatDecimalNumber(this.listOperations), FormattingUtils.formatDecimalNumber(this.listedFiles), FormattingUtils.formatDecimalNumber(this.storedFiles), FormattingUtils.formatBytes(this.storedBytes), FormattingUtils.formatDecimalNumber(this.unchangedFiles), FormattingUtils.formatBytes(this.unchangedBytes), FormattingUtils.formatDecimalNumber(this.retrievedFiles), FormattingUtils.formatBytes(this.retrievedBytes), FormattingUtils.formatDecimalNumber(this.removedFiles));
    }
}

