/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.onionoo.docs.BandwidthDocument;
import org.torproject.metrics.onionoo.docs.ClientsDocument;
import org.torproject.metrics.onionoo.docs.DetailsDocument;
import org.torproject.metrics.onionoo.docs.DocumentStore;
import org.torproject.metrics.onionoo.docs.DocumentStoreFactory;
import org.torproject.metrics.onionoo.docs.SummaryDocument;
import org.torproject.metrics.onionoo.docs.UptimeDocument;
import org.torproject.metrics.onionoo.docs.WeightsDocument;
import org.torproject.metrics.onionoo.util.FormattingUtils;

public class ResponseBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ResponseBuilder.class);
    private static ObjectMapper objectMapper = new ObjectMapper();
    private DocumentStore documentStore;
    private String buildRevision;
    private String resourceType;
    private String relaysPublishedString;
    private String bridgesPublishedString;
    private List<SummaryDocument> orderedRelays = new ArrayList<SummaryDocument>();
    private List<SummaryDocument> orderedBridges = new ArrayList<SummaryDocument>();
    private int relaysSkipped;
    private int bridgesSkipped;
    private int relaysTruncated;
    private int bridgesTruncated;
    private String[] fields;
    private int charsWritten = 0;
    private static final String PROTOCOL_VERSION = "8.0";
    private static final String NEXT_MAJOR_VERSION_SCHEDULED = null;

    public ResponseBuilder() {
        this.documentStore = DocumentStoreFactory.getDocumentStore();
        Properties buildProperties = new Properties();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("onionoo.buildrevision.properties");){
            buildProperties.load(is);
            this.buildRevision = buildProperties.getProperty("onionoo.build.revision", null);
        }
        catch (Exception ex) {
            logger.warn("No build revision available.", (Throwable)ex);
            this.buildRevision = null;
        }
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void setRelaysPublishedString(String relaysPublishedString) {
        this.relaysPublishedString = relaysPublishedString;
    }

    public void setBridgesPublishedString(String bridgesPublishedString) {
        this.bridgesPublishedString = bridgesPublishedString;
    }

    public void setOrderedRelays(List<SummaryDocument> orderedRelays) {
        this.orderedRelays = orderedRelays;
    }

    public void setOrderedBridges(List<SummaryDocument> orderedBridges) {
        this.orderedBridges = orderedBridges;
    }

    public void setRelaysSkipped(int relaysSkipped) {
        this.relaysSkipped = relaysSkipped;
    }

    public void setBridgesSkipped(int bridgesSkipped) {
        this.bridgesSkipped = bridgesSkipped;
    }

    public void setRelaysTruncated(int relaysTruncated) {
        this.relaysTruncated = relaysTruncated;
    }

    public void setBridgesTruncated(int bridgesTruncated) {
        this.bridgesTruncated = bridgesTruncated;
    }

    public void setFields(String[] fields) {
        this.fields = new String[fields.length];
        System.arraycopy(fields, 0, this.fields, 0, fields.length);
    }

    public void buildResponse(PrintWriter pw) {
        this.writeRelays(this.orderedRelays, pw);
        this.writeBridges(this.orderedBridges, pw);
    }

    public int getCharsWritten() {
        return this.charsWritten;
    }

    private void writeRelays(List<SummaryDocument> relays, PrintWriter pw) {
        this.write(pw, "{\"version\":\"%s\",\n", PROTOCOL_VERSION);
        if (null != NEXT_MAJOR_VERSION_SCHEDULED) {
            this.write(pw, "\"next_major_version_scheduled\":\"%s\",\n", NEXT_MAJOR_VERSION_SCHEDULED);
        }
        if (null != this.buildRevision) {
            this.write(pw, "\"build_revision\":\"%s\",\n", this.buildRevision);
        }
        this.write(pw, "\"relays_published\":\"%s\",\n", this.relaysPublishedString);
        if (this.relaysSkipped > 0) {
            this.write(pw, "\"relays_skipped\":%d,\n", this.relaysSkipped);
        }
        this.write(pw, "\"relays\":[", new Object[0]);
        int written = 0;
        for (SummaryDocument entry : relays) {
            String lines = this.formatNodeStatus(entry);
            if (lines.length() <= 0) continue;
            this.write(pw, "%s%s", written++ > 0 ? ",\n" : "\n", lines);
        }
        this.write(pw, "\n],\n", new Object[0]);
        if (this.relaysTruncated > 0) {
            this.write(pw, "\"relays_truncated\":%d,\n", this.relaysTruncated);
        }
    }

    private void writeBridges(List<SummaryDocument> bridges, PrintWriter pw) {
        this.write(pw, "\"bridges_published\":\"" + this.bridgesPublishedString + "\",\n", new Object[0]);
        if (this.bridgesSkipped > 0) {
            this.write(pw, "\"bridges_skipped\":%d,\n", this.bridgesSkipped);
        }
        this.write(pw, "\"bridges\":[", new Object[0]);
        int written = 0;
        for (SummaryDocument entry : bridges) {
            String lines = this.formatNodeStatus(entry);
            if (lines.length() <= 0) continue;
            this.write(pw, (written++ > 0 ? ",\n" : "\n") + lines, new Object[0]);
        }
        this.write(pw, "\n]", new Object[0]);
        if (this.bridgesTruncated > 0) {
            this.write(pw, ",\n\"bridges_truncated\":%d", this.bridgesTruncated);
        }
        this.write(pw, "}\n", new Object[0]);
    }

    private void write(PrintWriter pw, String format, Object ... args) {
        String stringToWrite = String.format(format, args);
        this.charsWritten += stringToWrite.length();
        pw.write(stringToWrite);
    }

    private String formatNodeStatus(SummaryDocument entry) {
        if (this.resourceType == null) {
            return "";
        }
        if (this.resourceType.equals("summary")) {
            return this.writeSummaryLine(entry);
        }
        if (this.resourceType.equals("details")) {
            return this.writeDetailsLines(entry);
        }
        if (this.resourceType.equals("bandwidth")) {
            return this.writeBandwidthLines(entry);
        }
        if (this.resourceType.equals("weights")) {
            return this.writeWeightsLines(entry);
        }
        if (this.resourceType.equals("clients")) {
            return this.writeClientsLines(entry);
        }
        if (this.resourceType.equals("uptime")) {
            return this.writeUptimeLines(entry);
        }
        return "";
    }

    private String writeSummaryLine(SummaryDocument entry) {
        return entry.isRelay() ? this.writeRelaySummaryLine(entry) : this.writeBridgeSummaryLine(entry);
    }

    private String writeRelaySummaryLine(SummaryDocument entry) {
        String nickname = entry.getNickname();
        String fingerprint = entry.getFingerprint();
        String running = entry.isRunning() ? "true" : "false";
        List<String> addresses = entry.getAddresses();
        StringBuilder addressesBuilder = new StringBuilder();
        int written = 0;
        for (String address : addresses) {
            addressesBuilder.append(written++ > 0 ? "," : "").append("\"").append(address.toLowerCase()).append("\"");
        }
        return String.format("{\"n\":\"%s\",\"f\":\"%s\",\"a\":[%s],\"r\":%s}", nickname, fingerprint, addressesBuilder.toString(), running);
    }

    private String writeBridgeSummaryLine(SummaryDocument entry) {
        String nickname = entry.getNickname();
        String hashedFingerprint = entry.getFingerprint();
        String running = entry.isRunning() ? "true" : "false";
        return String.format("{\"n\":\"%s\",\"h\":\"%s\",\"r\":%s}", nickname, hashedFingerprint, running);
    }

    private String writeDetailsLines(SummaryDocument entry) {
        String fingerprint = entry.getFingerprint();
        if (this.fields != null) {
            DetailsDocument detailsDocument = this.documentStore.retrieve(DetailsDocument.class, true, fingerprint);
            if (detailsDocument != null) {
                DetailsDocument dd = new DetailsDocument();
                String[] stringArray = this.fields;
                int n = stringArray.length;
                block100: for (int i = 0; i < n; ++i) {
                    String field;
                    switch (field = stringArray[i]) {
                        case "nickname": {
                            dd.setNickname(detailsDocument.getNickname());
                            continue block100;
                        }
                        case "fingerprint": {
                            dd.setFingerprint(detailsDocument.getFingerprint());
                            continue block100;
                        }
                        case "hashed_fingerprint": {
                            dd.setHashedFingerprint(detailsDocument.getHashedFingerprint());
                            continue block100;
                        }
                        case "or_addresses": {
                            dd.setOrAddresses(detailsDocument.getOrAddresses());
                            continue block100;
                        }
                        case "exit_addresses": {
                            dd.setExitAddresses(detailsDocument.getExitAddresses());
                            continue block100;
                        }
                        case "dir_address": {
                            dd.setDirAddress(detailsDocument.getDirAddress());
                            continue block100;
                        }
                        case "last_seen": {
                            dd.setLastSeen(detailsDocument.getLastSeen());
                            continue block100;
                        }
                        case "last_changed_address_or_port": {
                            dd.setLastChangedAddressOrPort(detailsDocument.getLastChangedAddressOrPort());
                            continue block100;
                        }
                        case "first_seen": {
                            dd.setFirstSeen(detailsDocument.getFirstSeen());
                            continue block100;
                        }
                        case "running": {
                            dd.setRunning(detailsDocument.isRunning());
                            continue block100;
                        }
                        case "flags": {
                            dd.setFlags(detailsDocument.getFlags());
                            continue block100;
                        }
                        case "country": {
                            dd.setCountry(detailsDocument.getCountry());
                            continue block100;
                        }
                        case "country_name": {
                            dd.setCountryName(detailsDocument.getCountryName());
                            continue block100;
                        }
                        case "region_name": {
                            dd.setRegionName(detailsDocument.getRegionName());
                            continue block100;
                        }
                        case "city_name": {
                            dd.setCityName(detailsDocument.getCityName());
                            continue block100;
                        }
                        case "latitude": {
                            dd.setLatitude(detailsDocument.getLatitude());
                            continue block100;
                        }
                        case "longitude": {
                            dd.setLongitude(detailsDocument.getLongitude());
                            continue block100;
                        }
                        case "as": {
                            dd.setAs(detailsDocument.getAs());
                            continue block100;
                        }
                        case "as_name": {
                            dd.setAsName(detailsDocument.getAsName());
                            continue block100;
                        }
                        case "consensus_weight": {
                            dd.setConsensusWeight(detailsDocument.getConsensusWeight());
                            continue block100;
                        }
                        case "verified_host_names": {
                            dd.setVerifiedHostNames(detailsDocument.getVerifiedHostNames());
                            continue block100;
                        }
                        case "unverified_host_names": {
                            dd.setUnverifiedHostNames(detailsDocument.getUnverifiedHostNames());
                            continue block100;
                        }
                        case "last_restarted": {
                            dd.setLastRestarted(detailsDocument.getLastRestarted());
                            continue block100;
                        }
                        case "bandwidth_rate": {
                            dd.setBandwidthRate(detailsDocument.getBandwidthRate());
                            continue block100;
                        }
                        case "bandwidth_burst": {
                            dd.setBandwidthBurst(detailsDocument.getBandwidthBurst());
                            continue block100;
                        }
                        case "observed_bandwidth": {
                            dd.setObservedBandwidth(detailsDocument.getObservedBandwidth());
                            continue block100;
                        }
                        case "advertised_bandwidth": {
                            dd.setAdvertisedBandwidth(detailsDocument.getAdvertisedBandwidth());
                            continue block100;
                        }
                        case "exit_policy": {
                            dd.setExitPolicy(detailsDocument.getExitPolicy());
                            continue block100;
                        }
                        case "exit_policy_summary": {
                            dd.setExitPolicySummary(detailsDocument.getExitPolicySummary());
                            continue block100;
                        }
                        case "exit_policy_v6_summary": {
                            dd.setExitPolicyV6Summary(detailsDocument.getExitPolicyV6Summary());
                            continue block100;
                        }
                        case "contact": {
                            dd.setContact(detailsDocument.getContact());
                            continue block100;
                        }
                        case "platform": {
                            dd.setPlatform(detailsDocument.getPlatform());
                            continue block100;
                        }
                        case "consensus_weight_fraction": {
                            dd.setConsensusWeightFraction(detailsDocument.getConsensusWeightFraction());
                            continue block100;
                        }
                        case "guard_probability": {
                            dd.setGuardProbability(detailsDocument.getGuardProbability());
                            continue block100;
                        }
                        case "middle_probability": {
                            dd.setMiddleProbability(detailsDocument.getMiddleProbability());
                            continue block100;
                        }
                        case "exit_probability": {
                            dd.setExitProbability(detailsDocument.getExitProbability());
                            continue block100;
                        }
                        case "recommended_version": {
                            dd.setRecommendedVersion(detailsDocument.isRecommendedVersion());
                            continue block100;
                        }
                        case "hibernating": {
                            dd.setHibernating(detailsDocument.isHibernating());
                            continue block100;
                        }
                        case "transports": {
                            dd.setTransports(detailsDocument.getTransports());
                            continue block100;
                        }
                        case "effective_family": {
                            dd.setEffectiveFamily(detailsDocument.getEffectiveFamily());
                            continue block100;
                        }
                        case "measured": {
                            dd.setMeasured(detailsDocument.isMeasured());
                            continue block100;
                        }
                        case "alleged_family": {
                            dd.setAllegedFamily(detailsDocument.getAllegedFamily());
                            continue block100;
                        }
                        case "indirect_family": {
                            dd.setIndirectFamily(detailsDocument.getIndirectFamily());
                            continue block100;
                        }
                        case "unreachable_or_addresses": {
                            dd.setUnreachableOrAddresses(detailsDocument.getUnreachableOrAddresses());
                            continue block100;
                        }
                        case "version": {
                            dd.setVersion(detailsDocument.getVersion());
                            continue block100;
                        }
                        case "version_status": {
                            dd.setVersionStatus(detailsDocument.getVersionStatus());
                            continue block100;
                        }
                        case "bridgedb_distributor": {
                            dd.setBridgedbDistributor(detailsDocument.getBridgedbDistributor());
                            continue block100;
                        }
                    }
                }
                try {
                    return FormattingUtils.replaceValidUtf(objectMapper.writeValueAsString((Object)dd));
                }
                catch (JsonProcessingException e) {
                    return "";
                }
            }
            return "";
        }
        DetailsDocument detailsDocument = this.documentStore.retrieve(DetailsDocument.class, false, fingerprint);
        if (detailsDocument != null) {
            return detailsDocument.getDocumentString();
        }
        return "";
    }

    private String writeBandwidthLines(SummaryDocument entry) {
        String fingerprint = entry.getFingerprint();
        BandwidthDocument bandwidthDocument = this.documentStore.retrieve(BandwidthDocument.class, false, fingerprint);
        if (bandwidthDocument != null && bandwidthDocument.getDocumentString() != null) {
            return bandwidthDocument.getDocumentString();
        }
        return "{\"fingerprint\":\"" + fingerprint.toUpperCase() + "\"}";
    }

    private String writeWeightsLines(SummaryDocument entry) {
        String fingerprint = entry.getFingerprint();
        WeightsDocument weightsDocument = this.documentStore.retrieve(WeightsDocument.class, false, fingerprint);
        if (weightsDocument != null && weightsDocument.getDocumentString() != null) {
            return weightsDocument.getDocumentString();
        }
        return "{\"fingerprint\":\"" + fingerprint.toUpperCase() + "\"}";
    }

    private String writeClientsLines(SummaryDocument entry) {
        String fingerprint = entry.getFingerprint();
        ClientsDocument clientsDocument = this.documentStore.retrieve(ClientsDocument.class, false, fingerprint);
        if (clientsDocument != null && clientsDocument.getDocumentString() != null) {
            return clientsDocument.getDocumentString();
        }
        return "{\"fingerprint\":\"" + fingerprint.toUpperCase() + "\"}";
    }

    private String writeUptimeLines(SummaryDocument entry) {
        String fingerprint = entry.getFingerprint();
        UptimeDocument uptimeDocument = this.documentStore.retrieve(UptimeDocument.class, false, fingerprint);
        if (uptimeDocument != null && uptimeDocument.getDocumentString() != null) {
            return uptimeDocument.getDocumentString();
        }
        return "{\"fingerprint\":\"" + fingerprint.toUpperCase() + "\"}";
    }
}

