/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.updater;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.onionoo.updater.LookupResult;
import org.torproject.metrics.onionoo.util.FormattingUtils;

public class LookupService {
    private static final Logger log = LoggerFactory.getLogger(LookupService.class);
    private File geoipDir;
    private File geoLite2CityBlocksIPv4CsvFile;
    private File geoLite2CityLocationsEnCsvFile;
    private File geoLite2AsnBlocksIpv4CsvFile;
    private boolean hasAllFiles = false;
    private Pattern ipv4Pattern = Pattern.compile("^[0-9.]{7,15}$");
    private int addressesLookedUp = 0;
    private int addressesResolved = 0;

    public LookupService(File geoipDir) {
        this.geoipDir = geoipDir;
        this.findRequiredCsvFiles();
    }

    private void findRequiredCsvFiles() {
        this.geoLite2CityBlocksIPv4CsvFile = new File(this.geoipDir, "GeoLite2-City-Blocks-IPv4.csv");
        if (!this.geoLite2CityBlocksIPv4CsvFile.exists()) {
            log.error("No GeoLite2-City-Blocks-IPv4.csv file in geoip/.");
            return;
        }
        this.geoLite2CityLocationsEnCsvFile = new File(this.geoipDir, "GeoLite2-City-Locations-en.csv");
        if (!this.geoLite2CityLocationsEnCsvFile.exists()) {
            log.error("No GeoLite2-City-Locations-en.csv file in geoip/.");
            return;
        }
        this.geoLite2AsnBlocksIpv4CsvFile = new File(this.geoipDir, "GeoLite2-ASN-Blocks-IPv4.csv");
        if (!this.geoLite2AsnBlocksIpv4CsvFile.exists()) {
            log.error("No GeoLite2-ASN-Blocks-IPv4.csv file in geoip/.");
            return;
        }
        this.hasAllFiles = true;
    }

    private long parseAddressString(String addressString) {
        String[] parts;
        long addressNumber = -1L;
        if (this.ipv4Pattern.matcher(addressString).matches() && (parts = addressString.split("\\.", 4)).length == 4) {
            addressNumber = 0L;
            for (int i = 0; i < 4; ++i) {
                addressNumber *= 256L;
                int octetValue = -1;
                try {
                    octetValue = Integer.parseInt(parts[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (octetValue < 0 || octetValue > 255) {
                    addressNumber = -1L;
                    break;
                }
                addressNumber += (long)octetValue;
            }
        }
        return addressNumber;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SortedMap<String, LookupResult> lookup(SortedSet<String> addressStrings) {
        TreeMap<String, LookupResult> lookupResults = new TreeMap<String, LookupResult>();
        if (!this.hasAllFiles) {
            return lookupResults;
        }
        HashMap<String, Long> addressStringNumbers = new HashMap<String, Long>();
        for (String addressString : addressStrings) {
            long addressNumber = this.parseAddressString(addressString);
            if (addressNumber < 0L) continue;
            addressStringNumbers.put(addressString, addressNumber);
        }
        if (addressStringNumbers.isEmpty()) {
            return lookupResults;
        }
        HashMap<Long, Long> addressNumberBlocks = new HashMap<Long, Long>();
        HashMap<Long, Float[]> addressNumberLatLong = new HashMap<Long, Float[]>();
        try (BufferedReader br = this.createBufferedReaderFromUtf8File(this.geoLite2CityBlocksIPv4CsvFile);){
            String line;
            TreeSet sortedAddressNumbers = new TreeSet(addressStringNumbers.values());
            br.readLine();
            while ((line = br.readLine()) != null) {
                int networkMaskLength2;
                String[] parts = line.split(",", -1);
                if (parts.length < 9) {
                    log.error("Illegal line '{}' in {}.", (Object)line, (Object)this.geoLite2CityBlocksIPv4CsvFile.getAbsolutePath());
                    TreeMap<String, LookupResult> treeMap = lookupResults;
                    return treeMap;
                }
                String[] networkAddressAndMask = parts[0].split("/");
                Object startAddressString = networkAddressAndMask[0];
                long startIpNum = this.parseAddressString((String)startAddressString);
                if (startIpNum < 0L) {
                    log.error("Illegal IP address in '{}' in {}.", (Object)line, (Object)this.geoLite2CityBlocksIPv4CsvFile.getAbsolutePath());
                    TreeMap<String, LookupResult> treeMap = lookupResults;
                    return treeMap;
                }
                int n = networkMaskLength2 = networkAddressAndMask.length < 2 ? 0 : Integer.parseInt(networkAddressAndMask[1]);
                if (networkMaskLength2 < 8 || networkMaskLength2 > 32) {
                    log.error("Missing or illegal network mask in '{}' in {}.", (Object)line, (Object)this.geoLite2CityBlocksIPv4CsvFile.getAbsolutePath());
                    TreeMap<String, LookupResult> treeMap = lookupResults;
                    return treeMap;
                }
                try {
                    if (parts[1].length() == 0 && parts[2].length() == 0) continue;
                    long endIpNum = startIpNum + (long)(1 << 32 - networkMaskLength2) - 1L;
                    Iterator iterator = sortedAddressNumbers.tailSet(startIpNum).headSet(endIpNum + 1L).iterator();
                    while (iterator.hasNext()) {
                        long addressNumber = (Long)iterator.next();
                        String blockString = parts[1].length() > 0 ? parts[1] : parts[2];
                        long blockNumber = Long.parseLong(blockString);
                        addressNumberBlocks.put(addressNumber, blockNumber);
                        if (parts[7].length() <= 0 || parts[8].length() <= 0) continue;
                        addressNumberLatLong.put(addressNumber, new Float[]{Float.valueOf(Float.parseFloat(parts[7])), Float.valueOf(Float.parseFloat(parts[8]))});
                    }
                }
                catch (NumberFormatException e) {
                    log.error("Number format exception while parsing line '{}' in {}.", new Object[]{line, this.geoLite2CityBlocksIPv4CsvFile.getAbsolutePath(), e});
                    startAddressString = lookupResults;
                    return startAddressString;
                }
            }
        }
        catch (IOException e) {
            log.error("I/O exception while reading {}: {}", (Object)this.geoLite2CityBlocksIPv4CsvFile.getAbsolutePath(), (Object)e);
            return lookupResults;
        }
        HashMap<Long, String> blockLocations = new HashMap<Long, String>();
        try (BufferedReader br = this.createBufferedReaderFromUtf8File(this.geoLite2CityLocationsEnCsvFile);){
            String line;
            HashSet blockNumbers = new HashSet(addressNumberBlocks.values());
            br.readLine();
            while ((line = br.readLine()) != null) {
                String[] parts = line.replaceAll("\"", "").split(",", 13);
                if (parts.length != 13) {
                    log.error("Illegal line '{}' in {}.", (Object)line, (Object)this.geoLite2CityLocationsEnCsvFile.getAbsolutePath());
                    TreeMap<String, LookupResult> startAddressString = lookupResults;
                    return startAddressString;
                }
                try {
                    long locId = Long.parseLong(parts[0]);
                    if (!blockNumbers.contains(locId)) continue;
                    blockLocations.put(locId, line);
                }
                catch (NumberFormatException e) {
                    log.error("Number format exception while parsing line '{}' in {}.", (Object)line, (Object)this.geoLite2CityLocationsEnCsvFile.getAbsolutePath());
                    TreeMap<String, LookupResult> startIpNum = lookupResults;
                    if (br == null) return startIpNum;
                    br.close();
                    return startIpNum;
                }
            }
        }
        catch (IOException e) {
            log.error("I/O exception while reading {}: {}", (Object)this.geoLite2CityLocationsEnCsvFile.getAbsolutePath(), (Object)e);
            return lookupResults;
        }
        HashMap<Long, String[]> addressNumberAsn = new HashMap<Long, String[]>();
        try (BufferedReader br = this.createBufferedReaderFromUtf8File(this.geoLite2AsnBlocksIpv4CsvFile);){
            String line;
            TreeSet sortedAddressNumbers = new TreeSet(addressStringNumbers.values());
            long firstAddressNumber = (Long)sortedAddressNumbers.first();
            br.readLine();
            while ((line = br.readLine()) != null) {
                int networkMaskLength;
                String[] parts = line.replaceAll("\"", "").split(",", 3);
                if (parts.length != 3) {
                    log.error("Illegal line '{}' in {}.", (Object)line, (Object)this.geoLite2AsnBlocksIpv4CsvFile.getAbsolutePath());
                    TreeMap<String, LookupResult> networkMaskLength2 = lookupResults;
                    return networkMaskLength2;
                }
                String[] networkAddressAndMask = parts[0].split("/");
                String startAddressString2 = networkAddressAndMask[0];
                long startIpNum = this.parseAddressString(startAddressString2);
                if (startIpNum < 0L) {
                    log.error("Illegal IP address in '{}' in {}.", (Object)line, (Object)this.geoLite2AsnBlocksIpv4CsvFile.getAbsolutePath());
                    TreeMap<String, LookupResult> addressNumber = lookupResults;
                    return addressNumber;
                }
                int n = networkMaskLength = networkAddressAndMask.length < 2 ? 0 : Integer.parseInt(networkAddressAndMask[1]);
                if (networkMaskLength < 8 || networkMaskLength > 32) {
                    log.error("Missing or illegal network mask in '{}' in {}.", (Object)line, (Object)this.geoLite2AsnBlocksIpv4CsvFile.getAbsolutePath());
                    TreeMap<String, LookupResult> treeMap = lookupResults;
                    return treeMap;
                }
                try {
                    String asNumber = "AS" + Integer.parseInt(parts[1]);
                    String asName = parts[2];
                    while (firstAddressNumber < startIpNum && firstAddressNumber != -1L) {
                        sortedAddressNumbers.remove(firstAddressNumber);
                        if (sortedAddressNumbers.isEmpty()) {
                            firstAddressNumber = -1L;
                            continue;
                        }
                        firstAddressNumber = (Long)sortedAddressNumbers.first();
                    }
                    long endIpNum = startIpNum + (long)(1 << 32 - networkMaskLength) - 1L;
                    while (firstAddressNumber <= endIpNum && firstAddressNumber != -1L) {
                        addressNumberAsn.put(firstAddressNumber, new String[]{asNumber, asName});
                        sortedAddressNumbers.remove(firstAddressNumber);
                        if (sortedAddressNumbers.isEmpty()) {
                            firstAddressNumber = -1L;
                            continue;
                        }
                        firstAddressNumber = (Long)sortedAddressNumbers.first();
                    }
                    if (firstAddressNumber != -1L) continue;
                    break;
                }
                catch (NumberFormatException e) {
                    log.error("Number format exception while parsing line '{}' in {}.", (Object)line, (Object)this.geoLite2AsnBlocksIpv4CsvFile.getAbsolutePath());
                    TreeMap<String, LookupResult> startAddressString2 = lookupResults;
                    return startAddressString2;
                }
            }
        }
        catch (IOException e) {
            log.error("I/O exception while reading {}: {}", (Object)this.geoLite2AsnBlocksIpv4CsvFile.getAbsolutePath(), (Object)e);
            return lookupResults;
        }
        Iterator iterator = addressStrings.iterator();
        while (true) {
            long blockNumber;
            long addressNumber;
            if (!iterator.hasNext()) {
                this.addressesLookedUp += addressStrings.size();
                this.addressesResolved += lookupResults.size();
                return lookupResults;
            }
            String addressString = (String)iterator.next();
            if (!addressStringNumbers.containsKey(addressString) || !addressNumberBlocks.containsKey(addressNumber = ((Long)addressStringNumbers.get(addressString)).longValue()) && !addressNumberLatLong.containsKey(addressNumber) && !addressNumberAsn.containsKey(addressNumber)) continue;
            LookupResult lookupResult = new LookupResult();
            if (addressNumberBlocks.containsKey(addressNumber) && blockLocations.containsKey(blockNumber = ((Long)addressNumberBlocks.get(addressNumber)).longValue())) {
                String[] parts = ((String)blockLocations.get(blockNumber)).replaceAll("\"", "").split(",", -1);
                if (parts[4].length() > 0) {
                    lookupResult.setCountryCode(parts[4].toLowerCase());
                }
                if (parts[5].length() > 0) {
                    lookupResult.setCountryName(parts[5]);
                }
                if (parts[7].length() > 0) {
                    lookupResult.setRegionName(parts[7]);
                }
                if (parts[10].length() > 0) {
                    lookupResult.setCityName(parts[10]);
                }
            }
            if (addressNumberLatLong.containsKey(addressNumber)) {
                Float[] latLong = (Float[])addressNumberLatLong.get(addressNumber);
                lookupResult.setLatitude(latLong[0]);
                lookupResult.setLongitude(latLong[1]);
            }
            if (addressNumberAsn.containsKey(addressNumber)) {
                String[] parts = (String[])addressNumberAsn.get(addressNumber);
                lookupResult.setAsNumber(parts[0]);
                lookupResult.setAsName(parts[1]);
            }
            lookupResults.put(addressString, lookupResult);
        }
    }

    private BufferedReader createBufferedReaderFromUtf8File(File utf8File) throws FileNotFoundException {
        return this.createBufferedReaderFromFile(utf8File, StandardCharsets.UTF_8.newDecoder());
    }

    private BufferedReader createBufferedReaderFromFile(File file, CharsetDecoder dec) throws FileNotFoundException {
        dec.onMalformedInput(CodingErrorAction.REPORT);
        dec.onUnmappableCharacter(CodingErrorAction.REPORT);
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), dec));
    }

    public String getStatsString() {
        return String.format("    %s addresses looked up\n    %s addresses resolved\n", FormattingUtils.formatDecimalNumber(this.addressesLookedUp), FormattingUtils.formatDecimalNumber(this.addressesResolved));
    }
}

