/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketAddress;
import org.apache.mina.common.BufferDataException;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.TransportType;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.auth.Credential;
import org.subethamail.smtp.command.AuthCommand;
import org.subethamail.smtp.command.DataEndCommand;
import org.subethamail.smtp.command.EhloCommand;
import org.subethamail.smtp.command.HelloCommand;
import org.subethamail.smtp.command.NoopCommand;
import org.subethamail.smtp.command.QuitCommand;
import org.subethamail.smtp.command.ResetCommand;
import org.subethamail.smtp.server.Command;
import org.subethamail.smtp.server.ConnectionContext;
import org.subethamail.smtp.server.SMTPServer;
import org.subethamail.smtp.server.Session;

public class ConnectionHandler
extends IoHandlerAdapter {
    protected static final String CONTEXT_ATTRIBUTE = ConnectionHandler.class.getName() + ".ctx";
    private static Logger log = LoggerFactory.getLogger(ConnectionHandler.class);
    private SMTPServer server;
    private int numberOfConnections;
    private int receiveBufferSize = 128;

    public ConnectionHandler(SMTPServer server) {
        this.server = server;
    }

    private synchronized void updateNumberOfConnections(int newValue) {
        this.numberOfConnections = newValue;
        if (log.isDebugEnabled()) {
            log.debug("Active connections = " + this.numberOfConnections);
        }
    }

    public int getNumberOfConnections() {
        return this.numberOfConnections;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public void sessionCreated(IoSession session) {
        this.updateNumberOfConnections(this.numberOfConnections + 1);
        if (session.getTransportType() == TransportType.SOCKET) {
            ((SocketSessionConfig)session.getConfig()).setReceiveBufferSize(this.receiveBufferSize);
            ((SocketSessionConfig)session.getConfig()).setSendBufferSize(64);
        }
        session.setIdleTime(IdleStatus.READER_IDLE, this.server.getConnectionTimeout() / 1000);
        session.setAttribute(SSLFilter.USE_NOTIFICATION);
        if (log.isDebugEnabled()) {
            log.debug("SMTP connection count: " + this.server.getNumberOfConnections());
        }
        Context minaCtx = new Context(this.server, session);
        session.setAttribute(CONTEXT_ATTRIBUTE, (Object)minaCtx);
        try {
            if (this.server.hasTooManyConnections()) {
                log.debug("SMTP Too many connections!");
                ConnectionHandler.sendResponse(session, "554 Transaction failed. Too many connections.");
            }
            ConnectionHandler.sendResponse(session, "220 " + this.server.getHostName() + " ESMTP " + this.server.getName());
        }
        catch (IOException e1) {
            try {
                ConnectionHandler.sendResponse(session, "450 Problem when connecting. Please try again later.");
            }
            catch (IOException e) {
                // empty catch block
            }
            if (log.isDebugEnabled()) {
                log.debug("Error on session creation", (Throwable)e1);
            }
            session.close();
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        this.updateNumberOfConnections(this.numberOfConnections - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionIdle(IoSession session, IdleStatus status) {
        try {
            ConnectionHandler.sendResponse(session, "421 Timeout waiting for data from client.");
        }
        catch (IOException iOException) {
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(IoSession session, Throwable cause) {
        if (log.isDebugEnabled()) {
            log.debug("Exception occured :", cause);
        }
        try {
            if (cause instanceof BufferDataException) {
                ConnectionHandler.sendResponse(session, "501 " + cause.getMessage());
            } else {
                ConnectionHandler.sendResponse(session, "450 Problem attempting to execute commands. Please try again later.");
            }
        }
        catch (IOException iOException) {
        }
        finally {
            session.close();
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        if (message == null) {
            if (log.isDebugEnabled()) {
                log.debug("no more lines from client");
            }
            return;
        }
        if (message instanceof SSLFilter.SSLFilterMessage) {
            if (log.isDebugEnabled()) {
                log.debug("SSL FILTER message -> " + message);
            }
            return;
        }
        Context minaCtx = (Context)session.getAttribute(CONTEXT_ATTRIBUTE);
        if (message instanceof InputStream) {
            minaCtx.setInputStream((InputStream)message);
            new DataEndCommand().execute(null, minaCtx);
        } else {
            String line = (String)message;
            if (log.isDebugEnabled()) {
                log.debug("C: " + line);
            }
            if (minaCtx.getSession().isAuthenticating()) {
                this.server.getCommandHandler().handleAuthChallenge(minaCtx, line);
            } else if (!minaCtx.getSession().isAuthenticated() && !minaCtx.getSession().getMessageHandler().getAuthenticationMechanisms().isEmpty()) {
                Command cmd = this.server.getCommandHandler().getCommandFromString(line);
                if (cmd != null && (cmd instanceof AuthCommand || cmd instanceof EhloCommand || cmd instanceof HelloCommand || cmd instanceof NoopCommand || cmd instanceof ResetCommand || cmd instanceof QuitCommand)) {
                    this.server.getCommandHandler().handleCommand(minaCtx, line);
                } else {
                    ConnectionHandler.sendResponse(session, "530 Authentication required");
                }
            } else {
                this.server.getCommandHandler().handleCommand(minaCtx, line);
            }
        }
    }

    public static void sendResponse(IoSession session, String response) throws IOException {
        Context minaCtx;
        if (log.isDebugEnabled()) {
            log.debug("S: " + response);
        }
        if (response != null) {
            session.write((Object)response);
        }
        if (!(minaCtx = (Context)session.getAttribute(CONTEXT_ATTRIBUTE)).getSession().isActive()) {
            session.close();
        }
    }

    public class Context
    implements ConnectionContext,
    MessageContext {
        private SMTPServer server;
        private Session sessionCtx;
        private IoSession ioSession;
        private Credential credential;
        private InputStream inputStream;

        public Context(SMTPServer server, IoSession ioSession) {
            this.server = server;
            this.ioSession = ioSession;
            this.sessionCtx = new Session(this.server.getMessageHandlerFactory().create(this));
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public Session getSession() {
            return this.sessionCtx;
        }

        public void sendResponse(String response) throws IOException {
            ConnectionHandler.sendResponse(this.ioSession, response);
        }

        public SocketAddress getRemoteAddress() {
            return this.ioSession.getRemoteAddress();
        }

        public SMTPServer getSMTPServer() {
            return this.server;
        }

        public IoSession getIOSession() {
            return this.ioSession;
        }

        public Credential getCredential() {
            return this.credential;
        }

        public void setCredential(Credential credential) {
            this.credential = credential;
        }
    }
}

