/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.updater;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.onionoo.updater.BandwidthStatusUpdater;
import org.torproject.metrics.onionoo.updater.ClientsStatusUpdater;
import org.torproject.metrics.onionoo.updater.LookupService;
import org.torproject.metrics.onionoo.updater.NodeDetailsStatusUpdater;
import org.torproject.metrics.onionoo.updater.ReverseDomainNameResolver;
import org.torproject.metrics.onionoo.updater.StatusUpdater;
import org.torproject.metrics.onionoo.updater.UptimeStatusUpdater;
import org.torproject.metrics.onionoo.updater.WeightsStatusUpdater;

public class StatusUpdateRunner {
    private static final Logger logger = LoggerFactory.getLogger(StatusUpdateRunner.class);
    private LookupService ls = new LookupService(new File("geoip"));
    private ReverseDomainNameResolver rdnr = new ReverseDomainNameResolver();
    private StatusUpdater[] statusUpdaters;

    public StatusUpdateRunner() {
        NodeDetailsStatusUpdater ndsu = new NodeDetailsStatusUpdater(this.rdnr, this.ls);
        BandwidthStatusUpdater bsu = new BandwidthStatusUpdater();
        WeightsStatusUpdater wsu = new WeightsStatusUpdater();
        ClientsStatusUpdater csu = new ClientsStatusUpdater();
        UptimeStatusUpdater usu = new UptimeStatusUpdater();
        this.statusUpdaters = new StatusUpdater[]{ndsu, bsu, wsu, csu, usu};
    }

    public void updateStatuses() {
        for (StatusUpdater su : this.statusUpdaters) {
            logger.debug("Begin update of {}", (Object)su.getClass().getSimpleName());
            su.updateStatuses();
            logger.info("{} updated status files", (Object)su.getClass().getSimpleName());
        }
    }

    public void logStatistics() {
        for (StatusUpdater su : this.statusUpdaters) {
            String statsString = su.getStatsString();
            if (statsString == null) continue;
            logger.info("{}\n{}", (Object)su.getClass().getSimpleName(), (Object)statsString);
        }
        logger.info("GeoIP lookup service\n{}", (Object)this.ls.getStatsString());
        logger.info("Reverse domain name resolver\n{}", (Object)this.rdnr.getStatsString());
    }
}

