/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.writer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.onionoo.docs.DocumentStore;
import org.torproject.metrics.onionoo.docs.DocumentStoreFactory;
import org.torproject.metrics.onionoo.docs.NodeStatus;
import org.torproject.metrics.onionoo.writer.BandwidthDocumentWriter;
import org.torproject.metrics.onionoo.writer.ClientsDocumentWriter;
import org.torproject.metrics.onionoo.writer.DetailsDocumentWriter;
import org.torproject.metrics.onionoo.writer.DocumentWriter;
import org.torproject.metrics.onionoo.writer.SummaryDocumentWriter;
import org.torproject.metrics.onionoo.writer.UptimeDocumentWriter;
import org.torproject.metrics.onionoo.writer.WeightsDocumentWriter;

public class DocumentWriterRunner {
    private static final Logger logger = LoggerFactory.getLogger(DocumentWriterRunner.class);
    private DocumentWriter[] documentWriters;

    public DocumentWriterRunner() {
        SummaryDocumentWriter sdw = new SummaryDocumentWriter();
        DetailsDocumentWriter ddw = new DetailsDocumentWriter();
        BandwidthDocumentWriter bdw = new BandwidthDocumentWriter();
        WeightsDocumentWriter wdw = new WeightsDocumentWriter();
        ClientsDocumentWriter cdw = new ClientsDocumentWriter();
        UptimeDocumentWriter udw = new UptimeDocumentWriter();
        this.documentWriters = new DocumentWriter[]{sdw, ddw, bdw, wdw, cdw, udw};
    }

    public void writeDocuments() {
        long mostRecentStatusMillis = this.retrieveMostRecentStatusMillis();
        for (DocumentWriter dw : this.documentWriters) {
            logger.debug("Writing {}", (Object)dw.getClass().getSimpleName());
            dw.writeDocuments(mostRecentStatusMillis);
        }
    }

    private long retrieveMostRecentStatusMillis() {
        DocumentStore documentStore = DocumentStoreFactory.getDocumentStore();
        long mostRecentStatusMillis = -1L;
        for (String fingerprint : documentStore.list(NodeStatus.class)) {
            NodeStatus nodeStatus = documentStore.retrieve(NodeStatus.class, true, fingerprint);
            mostRecentStatusMillis = Math.max(mostRecentStatusMillis, nodeStatus.getLastSeenMillis());
        }
        return mostRecentStatusMillis;
    }

    public void logStatistics() {
        for (DocumentWriter dw : this.documentWriters) {
            String statsString = dw.getStatsString();
            if (statsString == null) continue;
            logger.info("{}\n{}", (Object)dw.getClass().getSimpleName(), (Object)statsString);
        }
    }
}

