/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.writer;

import java.time.Period;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.onionoo.docs.DocumentStore;
import org.torproject.metrics.onionoo.docs.DocumentStoreFactory;
import org.torproject.metrics.onionoo.docs.GraphHistory;
import org.torproject.metrics.onionoo.docs.UpdateStatus;
import org.torproject.metrics.onionoo.docs.UptimeDocument;
import org.torproject.metrics.onionoo.docs.UptimeHistory;
import org.torproject.metrics.onionoo.docs.UptimeStatus;
import org.torproject.metrics.onionoo.util.FormattingUtils;
import org.torproject.metrics.onionoo.writer.DocumentWriter;
import org.torproject.metrics.onionoo.writer.GraphHistoryCompiler;

public class UptimeDocumentWriter
implements DocumentWriter {
    private static final Logger logger = LoggerFactory.getLogger(UptimeDocumentWriter.class);
    private DocumentStore documentStore;
    private int writtenDocuments = 0;
    private String[] graphNames = new String[]{"1_month", "6_months", "1_year", "5_years"};
    private Period[] graphIntervals = new Period[]{Period.ofMonths(1), Period.ofMonths(6), Period.ofYears(1), Period.ofYears(5)};
    private long[] dataPointIntervals = new long[]{14400000L, 43200000L, 172800000L, 864000000L};

    public UptimeDocumentWriter() {
        this.documentStore = DocumentStoreFactory.getDocumentStore();
    }

    @Override
    public void writeDocuments(long mostRecentStatusMillis) {
        UptimeStatus uptimeStatus = this.documentStore.retrieve(UptimeStatus.class, true);
        if (uptimeStatus == null) {
            return;
        }
        UpdateStatus updateStatus = this.documentStore.retrieve(UpdateStatus.class, true);
        long updatedMillis = updateStatus != null ? updateStatus.getUpdatedMillis() : 0L;
        SortedSet<String> updatedUptimeStatuses = this.documentStore.list(UptimeStatus.class, updatedMillis);
        for (String fingerprint : updatedUptimeStatuses) {
            this.updateDocument(fingerprint, mostRecentStatusMillis, uptimeStatus);
        }
        logger.info("Wrote uptime document files");
    }

    private void updateDocument(String fingerprint, long mostRecentStatusMillis, UptimeStatus knownStatuses) {
        UptimeStatus uptimeStatus = this.documentStore.retrieve(UptimeStatus.class, true, fingerprint);
        if (null != uptimeStatus) {
            boolean relay = uptimeStatus.getBridgeHistory().isEmpty();
            SortedSet<UptimeHistory> history = relay ? uptimeStatus.getRelayHistory() : uptimeStatus.getBridgeHistory();
            SortedSet<UptimeHistory> knownStatusesHistory = relay ? knownStatuses.getRelayHistory() : knownStatuses.getBridgeHistory();
            UptimeDocument uptimeDocument = this.compileUptimeDocument(relay, fingerprint, history, knownStatusesHistory, mostRecentStatusMillis);
            this.documentStore.store(uptimeDocument, fingerprint);
            ++this.writtenDocuments;
        }
    }

    private UptimeDocument compileUptimeDocument(boolean relay, String fingerprint, SortedSet<UptimeHistory> history, SortedSet<UptimeHistory> knownStatuses, long mostRecentStatusMillis) {
        UptimeDocument uptimeDocument = new UptimeDocument();
        uptimeDocument.setFingerprint(fingerprint);
        uptimeDocument.setUptime(this.compileUptimeHistory(relay, history, knownStatuses, mostRecentStatusMillis, null));
        TreeMap<String, Map<String, GraphHistory>> flags = new TreeMap<String, Map<String, GraphHistory>>();
        TreeSet<String> allFlags = new TreeSet<String>();
        for (UptimeHistory hist : history) {
            if (hist.getFlags() == null) continue;
            allFlags.addAll(hist.getFlags());
        }
        for (String flag : allFlags) {
            Map<String, GraphHistory> graphsForFlags = this.compileUptimeHistory(relay, history, knownStatuses, mostRecentStatusMillis, flag);
            if (graphsForFlags.isEmpty()) continue;
            flags.put(flag, graphsForFlags);
        }
        if (!flags.isEmpty()) {
            uptimeDocument.setFlags(flags);
        }
        return uptimeDocument;
    }

    private Map<String, GraphHistory> compileUptimeHistory(boolean relay, SortedSet<UptimeHistory> history, SortedSet<UptimeHistory> knownStatuses, long mostRecentStatusMillis, String flag) {
        UptimeHistory hist;
        if (history.isEmpty() || knownStatuses.isEmpty()) {
            return null;
        }
        GraphHistoryCompiler ghc = new GraphHistoryCompiler(mostRecentStatusMillis + 3600000L);
        for (int i = 0; i < this.graphIntervals.length; ++i) {
            ghc.addGraphType(this.graphNames[i], this.graphIntervals[i], this.dataPointIntervals[i]);
        }
        ghc.setDivisible(true);
        Iterator historyIterator = history.iterator();
        do {
            UptimeHistory uptimeHistory = hist = historyIterator.hasNext() ? (UptimeHistory)historyIterator.next() : null;
        } while (null != hist && (hist.isRelay() != relay || null != flag && (null == hist.getFlags() || !hist.getFlags().contains(flag))));
        if (null == hist) {
            return null;
        }
        for (UptimeHistory statuses : knownStatuses) {
            if (statuses.isRelay() != relay || null != flag && (null == statuses.getFlags() || !statuses.getFlags().contains(flag))) continue;
            long currentTimeMillis = statuses.getStartMillis();
            do {
                if (null == hist) {
                    ghc.addHistoryEntry(currentTimeMillis, statuses.getEndMillis(), 0.0);
                    currentTimeMillis = statuses.getEndMillis();
                    continue;
                }
                if (statuses.getEndMillis() <= hist.getStartMillis()) {
                    if (history.first().getStartMillis() <= currentTimeMillis) {
                        ghc.addHistoryEntry(currentTimeMillis, statuses.getEndMillis(), 0.0);
                    }
                    currentTimeMillis = statuses.getEndMillis();
                    continue;
                }
                if (currentTimeMillis < hist.getStartMillis()) {
                    if (history.first().getStartMillis() <= currentTimeMillis) {
                        ghc.addHistoryEntry(currentTimeMillis, hist.getStartMillis(), 0.0);
                    }
                    currentTimeMillis = hist.getStartMillis();
                }
                long overlapEndMillis = Math.min(statuses.getEndMillis(), hist.getEndMillis());
                ghc.addHistoryEntry(currentTimeMillis, overlapEndMillis, overlapEndMillis - currentTimeMillis);
                currentTimeMillis = overlapEndMillis;
                if (statuses.getEndMillis() < hist.getEndMillis()) continue;
                do {
                    UptimeHistory uptimeHistory = hist = historyIterator.hasNext() ? (UptimeHistory)historyIterator.next() : null;
                } while (null != hist && (hist.isRelay() != relay || null != flag && (null == hist.getFlags() || !hist.getFlags().contains(flag))));
            } while (currentTimeMillis < statuses.getEndMillis());
        }
        return ghc.compileGraphHistories();
    }

    @Override
    public String getStatsString() {
        return String.format("    %s uptime document files written\n", FormattingUtils.formatDecimalNumber(this.writtenDocuments));
    }
}

