/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.docs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringEscapeUtils;
import org.torproject.metrics.onionoo.docs.DateTimeHelper;
import org.torproject.metrics.onionoo.docs.Document;

public class DetailsDocument
extends Document {
    private String nickname;
    private String fingerprint;
    private String hashedFingerprint;
    private List<String> orAddresses;
    private List<String> exitAddresses;
    private String dirAddress;
    private String lastSeen;
    private String lastChangedAddressOrPort;
    private String firstSeen;
    private Boolean running;
    private SortedSet<String> flags;
    private String country;
    private String countryName;
    private String regionName;
    private String cityName;
    private Float latitude;
    private Float longitude;
    private String as;
    private String asName;
    private Long consensusWeight;
    private String hostName;
    private SortedSet<String> verifiedHostNames;
    private SortedSet<String> unverifiedHostNames;
    private String lastRestarted;
    private Integer bandwidthRate;
    private Integer bandwidthBurst;
    private Integer observedBandwidth;
    private Integer advertisedBandwidth;
    private Long overloadGeneralTimestamp;
    private List<String> exitPolicy;
    private Map<String, List<String>> exitPolicySummary;
    private Map<String, List<String>> exitPolicyV6Summary;
    private String contact;
    private String platform;
    private String version;
    private String versionStatus;
    private SortedSet<String> allegedFamily;
    private SortedSet<String> effectiveFamily;
    private SortedSet<String> indirectFamily;
    private Float consensusWeightFraction;
    private Float guardProbability;
    private Float middleProbability;
    private Float exitProbability;
    private Boolean recommendedVersion;
    private Boolean hibernating;
    private List<String> transports;
    private Boolean measured;
    private List<String> unreachableOrAddresses;
    private String bridgedbDistributor;
    private List<String> blocklist;

    private static String escapeJson(String stringToEscape) {
        return StringEscapeUtils.escapeJava(stringToEscape);
    }

    private static String unescapeJson(String stringToUnescape) {
        return StringEscapeUtils.unescapeJava(stringToUnescape);
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setHashedFingerprint(String hashedFingerprint) {
        this.hashedFingerprint = hashedFingerprint;
    }

    public String getHashedFingerprint() {
        return this.hashedFingerprint;
    }

    public void setOrAddresses(List<String> orAddresses) {
        this.orAddresses = orAddresses;
    }

    public List<String> getOrAddresses() {
        return this.orAddresses;
    }

    public void setExitAddresses(List<String> exitAddresses) {
        this.exitAddresses = !exitAddresses.isEmpty() ? exitAddresses : null;
    }

    public List<String> getExitAddresses() {
        return this.exitAddresses == null ? new ArrayList() : this.exitAddresses;
    }

    public void setDirAddress(String dirAddress) {
        this.dirAddress = dirAddress;
    }

    public String getDirAddress() {
        return this.dirAddress;
    }

    public void setLastSeen(long lastSeen) {
        this.lastSeen = DateTimeHelper.format(lastSeen);
    }

    public long getLastSeen() {
        return DateTimeHelper.parse(this.lastSeen);
    }

    public void setLastChangedAddressOrPort(long lastChangedAddressOrPort) {
        this.lastChangedAddressOrPort = DateTimeHelper.format(lastChangedAddressOrPort);
    }

    public long getLastChangedAddressOrPort() {
        return DateTimeHelper.parse(this.lastChangedAddressOrPort);
    }

    public void setFirstSeen(long firstSeen) {
        this.firstSeen = DateTimeHelper.format(firstSeen);
    }

    public long getFirstSeen() {
        return DateTimeHelper.parse(this.firstSeen);
    }

    public void setRunning(Boolean running) {
        this.running = running;
    }

    public Boolean isRunning() {
        return this.running;
    }

    public void setFlags(SortedSet<String> flags) {
        this.flags = flags;
    }

    public SortedSet<String> getFlags() {
        return this.flags;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountryName(String countryName) {
        this.countryName = DetailsDocument.escapeJson(countryName);
    }

    public String getCountryName() {
        return DetailsDocument.unescapeJson(this.countryName);
    }

    public void setRegionName(String regionName) {
        this.regionName = DetailsDocument.escapeJson(regionName);
    }

    public String getRegionName() {
        return DetailsDocument.unescapeJson(this.regionName);
    }

    public void setCityName(String cityName) {
        this.cityName = DetailsDocument.escapeJson(cityName);
    }

    public String getCityName() {
        return DetailsDocument.unescapeJson(this.cityName);
    }

    public void setLatitude(Float latitude) {
        this.latitude = latitude;
    }

    public Float getLatitude() {
        return this.latitude;
    }

    public void setLongitude(Float longitude) {
        this.longitude = longitude;
    }

    public Float getLongitude() {
        return this.longitude;
    }

    public void setAs(String as) {
        this.as = DetailsDocument.escapeJson(as);
    }

    public String getAs() {
        return DetailsDocument.unescapeJson(this.as);
    }

    public void setAsName(String asName) {
        this.asName = DetailsDocument.escapeJson(asName);
    }

    public String getAsName() {
        return DetailsDocument.unescapeJson(this.asName);
    }

    public void setConsensusWeight(Long consensusWeight) {
        this.consensusWeight = consensusWeight;
    }

    public Long getConsensusWeight() {
        return this.consensusWeight;
    }

    public void setHostName(String hostName) {
        this.hostName = DetailsDocument.escapeJson(hostName);
    }

    public String getHostName() {
        return DetailsDocument.unescapeJson(this.hostName);
    }

    public void setVerifiedHostNames(SortedSet<String> verifiedHostNames) {
        if (null == verifiedHostNames) {
            this.verifiedHostNames = null;
            return;
        }
        this.verifiedHostNames = new TreeSet<String>();
        for (String hostName : verifiedHostNames) {
            this.verifiedHostNames.add(DetailsDocument.escapeJson(hostName));
        }
    }

    public SortedSet<String> getVerifiedHostNames() {
        if (null == this.verifiedHostNames) {
            return null;
        }
        TreeSet<String> verifiedHostNames = new TreeSet<String>();
        for (String escapedHostName : this.verifiedHostNames) {
            verifiedHostNames.add(DetailsDocument.unescapeJson(escapedHostName));
        }
        return verifiedHostNames;
    }

    public void setUnverifiedHostNames(SortedSet<String> unverifiedHostNames) {
        if (null == unverifiedHostNames) {
            this.unverifiedHostNames = null;
            return;
        }
        this.unverifiedHostNames = new TreeSet<String>();
        for (String hostName : unverifiedHostNames) {
            this.unverifiedHostNames.add(DetailsDocument.escapeJson(hostName));
        }
    }

    public SortedSet<String> getUnverifiedHostNames() {
        if (null == this.unverifiedHostNames) {
            return null;
        }
        TreeSet<String> unverifiedHostNames = new TreeSet<String>();
        for (String escapedHostName : this.unverifiedHostNames) {
            unverifiedHostNames.add(DetailsDocument.unescapeJson(escapedHostName));
        }
        return unverifiedHostNames;
    }

    public void setLastRestarted(Long lastRestarted) {
        this.lastRestarted = lastRestarted == null ? null : DateTimeHelper.format(lastRestarted);
    }

    public Long getLastRestarted() {
        return this.lastRestarted == null ? null : Long.valueOf(DateTimeHelper.parse(this.lastRestarted));
    }

    public void setBandwidthRate(Integer bandwidthRate) {
        this.bandwidthRate = bandwidthRate;
    }

    public Integer getBandwidthRate() {
        return this.bandwidthRate;
    }

    public void setBandwidthBurst(Integer bandwidthBurst) {
        this.bandwidthBurst = bandwidthBurst;
    }

    public Integer getBandwidthBurst() {
        return this.bandwidthBurst;
    }

    public void setObservedBandwidth(Integer observedBandwidth) {
        this.observedBandwidth = observedBandwidth;
    }

    public Integer getObservedBandwidth() {
        return this.observedBandwidth;
    }

    public void setAdvertisedBandwidth(Integer advertisedBandwidth) {
        this.advertisedBandwidth = advertisedBandwidth;
    }

    public Integer getAdvertisedBandwidth() {
        return this.advertisedBandwidth;
    }

    public void setOverloadGeneralTimestamp(Long overloadGeneralTimestamp) {
        this.overloadGeneralTimestamp = overloadGeneralTimestamp;
    }

    public Long getOverloadGeneralTimestamp() {
        return this.overloadGeneralTimestamp;
    }

    public void setExitPolicy(List<String> exitPolicy) {
        this.exitPolicy = exitPolicy;
    }

    public List<String> getExitPolicy() {
        return this.exitPolicy;
    }

    public void setExitPolicySummary(Map<String, List<String>> exitPolicySummary) {
        this.exitPolicySummary = exitPolicySummary;
    }

    public Map<String, List<String>> getExitPolicySummary() {
        return this.exitPolicySummary;
    }

    public void setExitPolicyV6Summary(Map<String, List<String>> exitPolicyV6Summary) {
        this.exitPolicyV6Summary = exitPolicyV6Summary;
    }

    public Map<String, List<String>> getExitPolicyV6Summary() {
        return this.exitPolicyV6Summary;
    }

    public void setContact(String contact) {
        this.contact = DetailsDocument.escapeJson(contact);
    }

    public String getContact() {
        return DetailsDocument.unescapeJson(this.contact);
    }

    public void setPlatform(String platform) {
        this.platform = DetailsDocument.escapeJson(platform);
    }

    public String getPlatform() {
        return DetailsDocument.unescapeJson(this.platform);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersionStatus(String versionStatus) {
        this.versionStatus = versionStatus;
    }

    public String getVersionStatus() {
        return this.versionStatus;
    }

    public void setAllegedFamily(SortedSet<String> allegedFamily) {
        this.allegedFamily = allegedFamily;
    }

    public SortedSet<String> getAllegedFamily() {
        return this.allegedFamily;
    }

    public void setEffectiveFamily(SortedSet<String> effectiveFamily) {
        this.effectiveFamily = effectiveFamily;
    }

    public SortedSet<String> getEffectiveFamily() {
        return this.effectiveFamily;
    }

    public void setIndirectFamily(SortedSet<String> indirectFamily) {
        this.indirectFamily = indirectFamily;
    }

    public SortedSet<String> getIndirectFamily() {
        return this.indirectFamily;
    }

    public void setConsensusWeightFraction(Float consensusWeightFraction) {
        if (consensusWeightFraction == null || (double)consensusWeightFraction.floatValue() >= 0.0) {
            this.consensusWeightFraction = consensusWeightFraction;
        }
    }

    public Float getConsensusWeightFraction() {
        return this.consensusWeightFraction;
    }

    public void setGuardProbability(Float guardProbability) {
        if (guardProbability == null || (double)guardProbability.floatValue() >= 0.0) {
            this.guardProbability = guardProbability;
        }
    }

    public Float getGuardProbability() {
        return this.guardProbability;
    }

    public void setMiddleProbability(Float middleProbability) {
        if (middleProbability == null || (double)middleProbability.floatValue() >= 0.0) {
            this.middleProbability = middleProbability;
        }
    }

    public Float getMiddleProbability() {
        return this.middleProbability;
    }

    public void setExitProbability(Float exitProbability) {
        if (exitProbability == null || (double)exitProbability.floatValue() >= 0.0) {
            this.exitProbability = exitProbability;
        }
    }

    public Float getExitProbability() {
        return this.exitProbability;
    }

    public void setRecommendedVersion(Boolean recommendedVersion) {
        this.recommendedVersion = recommendedVersion;
    }

    public Boolean isRecommendedVersion() {
        return this.recommendedVersion;
    }

    public void setHibernating(Boolean hibernating) {
        this.hibernating = hibernating;
    }

    public Boolean isHibernating() {
        return this.hibernating;
    }

    public void setTransports(List<String> transports) {
        this.transports = transports != null && !transports.isEmpty() ? transports : null;
    }

    public List<String> getTransports() {
        return this.transports;
    }

    public void setMeasured(Boolean measured) {
        this.measured = measured;
    }

    public Boolean isMeasured() {
        return this.measured;
    }

    public void setUnreachableOrAddresses(List<String> unreachableOrAddresses) {
        this.unreachableOrAddresses = unreachableOrAddresses;
    }

    public List<String> getUnreachableOrAddresses() {
        return this.unreachableOrAddresses;
    }

    public void setBridgedbDistributor(String bridgedbDistributor) {
        this.bridgedbDistributor = bridgedbDistributor;
    }

    public String getBridgedbDistributor() {
        return this.bridgedbDistributor;
    }

    public void setBlocklist(List<String> blocklist) {
        this.blocklist = blocklist != null && !blocklist.isEmpty() ? blocklist : null;
    }

    public List<String> getBlocklist() {
        return this.blocklist;
    }
}

