/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.docs;

import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.onionoo.docs.DateTimeHelper;

public class UptimeHistory
implements Comparable<UptimeHistory> {
    private static final Logger logger = LoggerFactory.getLogger(UptimeHistory.class);
    private boolean relay;
    private long startMillis;
    private int uptimeHours;
    private SortedSet<String> flags;

    public boolean isRelay() {
        return this.relay;
    }

    public long getStartMillis() {
        return this.startMillis;
    }

    public int getUptimeHours() {
        return this.uptimeHours;
    }

    public long getEndMillis() {
        return this.startMillis + 3600000L * (long)this.uptimeHours;
    }

    public SortedSet<String> getFlags() {
        return this.flags;
    }

    UptimeHistory(boolean relay, long startMillis, int uptimeHours, SortedSet<String> flags) {
        this.relay = relay;
        this.startMillis = startMillis;
        this.uptimeHours = uptimeHours;
        this.flags = flags;
    }

    public static UptimeHistory fromString(String uptimeHistoryString) {
        int uptimeHours;
        String[] parts = uptimeHistoryString.split(" ", -1);
        if (parts.length < 3) {
            logger.warn("Invalid number of space-separated strings in uptime history: '{}'. Skipping", (Object)uptimeHistoryString);
            return null;
        }
        boolean relay = false;
        if (parts[0].equalsIgnoreCase("r")) {
            relay = true;
        } else if (!parts[0].equals("b")) {
            logger.warn("Invalid node type in uptime history: '{}'. Supported types are 'r', 'R', and 'b'. Skipping.", (Object)uptimeHistoryString);
            return null;
        }
        long startMillis = DateTimeHelper.parse(parts[1], "yyyy-MM-dd-HH");
        if (-1L == startMillis) {
            logger.warn("Invalid start timestamp in uptime history: '{}'. Skipping.", (Object)uptimeHistoryString);
            return null;
        }
        try {
            uptimeHours = Integer.parseInt(parts[2]);
        }
        catch (NumberFormatException e) {
            logger.warn("Invalid number format in uptime history: '{}'. Skipping.", (Object)uptimeHistoryString);
            return null;
        }
        TreeSet<String> flags = null;
        if (parts[0].equals("R")) {
            flags = new TreeSet<String>(Arrays.asList(parts).subList(3, parts.length));
        }
        return new UptimeHistory(relay, startMillis, uptimeHours, flags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.relay ? (this.flags == null ? "r" : "R") : "b");
        sb.append(" ").append(DateTimeHelper.format(this.startMillis, "yyyy-MM-dd-HH"));
        sb.append(" ").append(String.format("%d", this.uptimeHours));
        if (this.flags != null) {
            for (String flag : this.flags) {
                sb.append(" ").append(flag);
            }
        }
        return sb.toString();
    }

    public void addUptime(UptimeHistory other) {
        this.uptimeHours += other.uptimeHours;
        if (this.startMillis > other.startMillis) {
            this.startMillis = other.startMillis;
        }
    }

    @Override
    public int compareTo(UptimeHistory other) {
        if (this.relay && !other.relay) {
            return -1;
        }
        if (!this.relay && other.relay) {
            return 1;
        }
        return Long.compare(this.startMillis, other.startMillis);
    }

    public boolean equals(Object other) {
        return other instanceof UptimeHistory && this.relay == ((UptimeHistory)other).relay && this.startMillis == ((UptimeHistory)other).startMillis;
    }

    public int hashCode() {
        return (int)this.startMillis + (this.relay ? 1 : 0);
    }
}

