/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.server;

import java.text.SimpleDateFormat;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.onionoo.server.Counter;
import org.torproject.metrics.onionoo.server.IntegerDistribution;
import org.torproject.metrics.onionoo.server.MostFrequentString;

public class PerformanceMetrics {
    private static final Logger logger = LoggerFactory.getLogger(PerformanceMetrics.class);
    private static final Object lock = new Object();
    private static long lastLoggedMillis = -1L;
    private static final long LOG_INTERVAL_SECONDS = 3600L;
    private static final long LOG_INTERVAL_MILLIS = 3600000L;
    private static Counter totalProcessedRequests = new Counter();
    private static MostFrequentString requestsByResourceType = new MostFrequentString();
    private static MostFrequentString requestsByParameters = new MostFrequentString();
    private static IntegerDistribution matchingRelayDocuments = new IntegerDistribution();
    private static IntegerDistribution matchingBridgeDocuments = new IntegerDistribution();
    private static IntegerDistribution writtenChars = new IntegerDistribution();
    private static IntegerDistribution handleRequestMillis = new IntegerDistribution();
    private static IntegerDistribution buildResponseMillis = new IntegerDistribution();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logStatistics(long receivedRequestMillis, String resourceType, Collection<String> parameterKeys, long parsedRequestMillis, int relayDocumentsWritten, int bridgeDocumentsWritten, int charsWritten, long writtenResponseMillis) {
        Object object = lock;
        synchronized (object) {
            if (lastLoggedMillis < 0L) {
                lastLoggedMillis = System.currentTimeMillis();
            } else if (receivedRequestMillis - lastLoggedMillis > 3600000L) {
                SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                logger.info("Request statistics ({}, {} s):", (Object)dateTimeFormat.format(lastLoggedMillis + 3600000L), (Object)3600L);
                logger.info("  Total processed requests: {}", (Object)totalProcessedRequests);
                logger.info("  Most frequently requested resource: {}", (Object)requestsByResourceType);
                logger.info("  Most frequently requested parameter combinations: {}", (Object)requestsByParameters);
                logger.info("  Matching relays per request: {}", (Object)matchingRelayDocuments);
                logger.info("  Matching bridges per request: {}", (Object)matchingBridgeDocuments);
                logger.info("  Written characters per response: {}", (Object)writtenChars);
                logger.info("  Milliseconds to handle request: {}", (Object)handleRequestMillis);
                logger.info("  Milliseconds to build response: {}", (Object)buildResponseMillis);
                totalProcessedRequests.clear();
                requestsByResourceType.clear();
                requestsByParameters.clear();
                matchingRelayDocuments.clear();
                matchingBridgeDocuments.clear();
                writtenChars.clear();
                handleRequestMillis.clear();
                buildResponseMillis.clear();
                while (receivedRequestMillis - (lastLoggedMillis += 3600000L) > 3600000L) {
                }
            }
            totalProcessedRequests.increment();
            long handlingTime = parsedRequestMillis - receivedRequestMillis;
            if (handlingTime > 1000L) {
                logger.warn("longer request handling: {} ms for {} params: {} and {} chars.", handlingTime, resourceType, parameterKeys, charsWritten);
            }
            handleRequestMillis.addLong(handlingTime);
            requestsByResourceType.addString(resourceType);
            requestsByParameters.addString(parameterKeys.toString());
            matchingRelayDocuments.addLong(relayDocumentsWritten);
            matchingBridgeDocuments.addLong(bridgeDocumentsWritten);
            writtenChars.addLong(charsWritten);
            long responseTime = writtenResponseMillis - parsedRequestMillis;
            if (responseTime > 1000L) {
                logger.warn("longer response building: {} ms for {} params: {} and {} chars.", responseTime, resourceType, parameterKeys, charsWritten);
            }
            buildResponseMillis.addLong(responseTime);
        }
    }
}

