/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.updater;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.UnparseableDescriptor;
import org.torproject.metrics.onionoo.updater.DescriptorHistory;
import org.torproject.metrics.onionoo.updater.DescriptorType;

class DescriptorQueue {
    private static final Logger logger = LoggerFactory.getLogger(DescriptorQueue.class);
    private File statusDir;
    private DescriptorReader descriptorReader;
    private File historyFile;
    private File directory;
    private Iterator<Descriptor> descriptors;
    private int historySizeBefore;
    private int historySizeAfter;
    private long returnedDescriptors = 0L;
    private long returnedBytes = 0L;

    public int getHistorySizeBefore() {
        return this.historySizeBefore;
    }

    public int getHistorySizeAfter() {
        return this.historySizeAfter;
    }

    public long getReturnedDescriptors() {
        return this.returnedDescriptors;
    }

    public long getReturnedBytes() {
        return this.returnedBytes;
    }

    public DescriptorQueue(File inDir, DescriptorType descriptorType, File statusDir) {
        this.directory = inDir;
        if (descriptorType != null) {
            this.directory = new File(inDir, descriptorType.getDir());
        }
        this.statusDir = statusDir;
        this.descriptorReader = DescriptorSourceFactory.createDescriptorReader();
        this.descriptorReader.setMaxDescriptorsInQueue(20);
    }

    public void readHistoryFile(DescriptorHistory descriptorHistory) {
        if (this.statusDir == null) {
            return;
        }
        this.historyFile = new File(this.statusDir, descriptorHistory.getFileName());
        if (this.historyFile.exists() && this.historyFile.isFile()) {
            TreeMap<String, Long> excludedFiles = new TreeMap<String, Long>();
            try (BufferedReader br = new BufferedReader(new FileReader(this.historyFile));){
                String line;
                while ((line = br.readLine()) != null) {
                    try {
                        String[] parts = line.split(" ", 2);
                        excludedFiles.put(parts[1], Long.parseLong(parts[0]));
                    }
                    catch (NumberFormatException e) {
                        logger.error("Illegal line '{}' in parse history. Skipping line.", (Object)line);
                    }
                }
            }
            catch (IOException e) {
                logger.error("Could not read history file '{}'. Not excluding descriptors in this execution.", (Object)this.historyFile.getAbsolutePath(), (Object)e);
                return;
            }
            this.historySizeBefore = excludedFiles.size();
            this.descriptorReader.setExcludedFiles(excludedFiles);
        }
    }

    public void writeHistoryFile() {
        if (this.historyFile == null) {
            return;
        }
        if (null == this.descriptors) {
            logger.debug("Not writing history file {}, because we did not read a single descriptor from {}.", (Object)this.historyFile, (Object)this.directory);
            return;
        }
        TreeMap<String, Long> excludedAndParsedFiles = new TreeMap<String, Long>();
        excludedAndParsedFiles.putAll(this.descriptorReader.getExcludedFiles());
        excludedAndParsedFiles.putAll(this.descriptorReader.getParsedFiles());
        this.historySizeAfter = excludedAndParsedFiles.size();
        this.historyFile.getParentFile().mkdirs();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.historyFile));){
            for (Map.Entry e : excludedAndParsedFiles.entrySet()) {
                String absolutePath = (String)e.getKey();
                long lastModifiedMillis = (Long)e.getValue();
                bw.write(lastModifiedMillis + " " + absolutePath + "\n");
            }
        }
        catch (IOException e) {
            logger.error("Could not write history file '{}'. Not excluding descriptors in next execution.", (Object)this.historyFile.getAbsolutePath());
        }
    }

    public Descriptor nextDescriptor() {
        Descriptor nextDescriptor = null;
        if (null == this.descriptors) {
            if (this.directory.exists() && this.directory.isDirectory()) {
                this.descriptors = this.descriptorReader.readDescriptors(this.directory).iterator();
            } else {
                logger.error("Directory {} either does not exist or is not a directory. Not adding to descriptor reader.", (Object)this.directory.getAbsolutePath());
                return null;
            }
        }
        while (this.descriptors.hasNext()) {
            nextDescriptor = this.descriptors.next();
            if (nextDescriptor instanceof UnparseableDescriptor) continue;
            ++this.returnedDescriptors;
            this.returnedBytes += (long)nextDescriptor.getRawDescriptorLength();
            break;
        }
        return nextDescriptor;
    }
}

