/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.updater;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.torproject.descriptor.BridgeNetworkStatus;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.metrics.onionoo.docs.DocumentStore;
import org.torproject.metrics.onionoo.docs.DocumentStoreFactory;
import org.torproject.metrics.onionoo.docs.UptimeStatus;
import org.torproject.metrics.onionoo.updater.DescriptorListener;
import org.torproject.metrics.onionoo.updater.DescriptorSource;
import org.torproject.metrics.onionoo.updater.DescriptorSourceFactory;
import org.torproject.metrics.onionoo.updater.DescriptorType;
import org.torproject.metrics.onionoo.updater.StatusUpdater;
import org.torproject.metrics.onionoo.util.FormattingUtils;

public class UptimeStatusUpdater
implements DescriptorListener,
StatusUpdater {
    private DescriptorSource descriptorSource;
    private DocumentStore documentStore;
    private SortedMap<Long, Flags> newRelayStatuses = new TreeMap<Long, Flags>();
    private SortedMap<String, SortedMap<Long, Flags>> newRunningRelays = new TreeMap<String, SortedMap<Long, Flags>>();
    private SortedSet<Long> newBridgeStatuses = new TreeSet<Long>();
    private SortedMap<String, SortedSet<Long>> newRunningBridges = new TreeMap<String, SortedSet<Long>>();

    public UptimeStatusUpdater() {
        this.descriptorSource = DescriptorSourceFactory.getDescriptorSource();
        this.documentStore = DocumentStoreFactory.getDocumentStore();
        this.registerDescriptorListeners();
    }

    private void registerDescriptorListeners() {
        this.descriptorSource.registerDescriptorListener(this, DescriptorType.RELAY_CONSENSUSES);
        this.descriptorSource.registerDescriptorListener(this, DescriptorType.BRIDGE_STATUSES);
    }

    @Override
    public void processDescriptor(Descriptor descriptor, boolean relay) {
        if (descriptor instanceof RelayNetworkStatusConsensus) {
            this.processRelayNetworkStatusConsensus((RelayNetworkStatusConsensus)descriptor);
        } else if (descriptor instanceof BridgeNetworkStatus) {
            this.processBridgeNetworkStatus((BridgeNetworkStatus)descriptor);
        }
    }

    private void processRelayNetworkStatusConsensus(RelayNetworkStatusConsensus consensus) {
        long dateHourMillis = consensus.getValidAfterMillis() / 3600000L * 3600000L;
        for (NetworkStatusEntry entry : consensus.getStatusEntries().values()) {
            String fingerprint = entry.getFingerprint();
            this.newRunningRelays.putIfAbsent(fingerprint, new TreeMap());
            ((SortedMap)this.newRunningRelays.get(fingerprint)).put(dateHourMillis, new Flags(entry.getFlags()));
        }
        this.newRelayStatuses.put(dateHourMillis, new Flags(consensus.getKnownFlags()));
    }

    private void processBridgeNetworkStatus(BridgeNetworkStatus status) {
        TreeSet<String> fingerprints = new TreeSet<String>();
        for (NetworkStatusEntry entry : status.getStatusEntries().values()) {
            fingerprints.add(entry.getFingerprint());
        }
        if (!fingerprints.isEmpty()) {
            long dateHourMillis = status.getPublishedMillis() / 3600000L * 3600000L;
            for (String fingerprint : fingerprints) {
                this.newRunningBridges.putIfAbsent(fingerprint, new TreeSet());
                ((SortedSet)this.newRunningBridges.get(fingerprint)).add(dateHourMillis);
            }
            this.newBridgeStatuses.add(dateHourMillis);
        }
    }

    @Override
    public void updateStatuses() {
        for (Map.Entry<String, SortedMap<Long, Flags>> iterator : this.newRunningRelays.entrySet()) {
            this.updateStatus(true, iterator.getKey(), iterator.getValue());
        }
        this.updateStatus(true, null, this.newRelayStatuses);
        for (Map.Entry<String, Object> entry : this.newRunningBridges.entrySet()) {
            TreeMap<Long, Flags> dateHourMillisNoFlags = new TreeMap<Long, Flags>();
            Iterator iterator = ((SortedSet)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                long dateHourMillis = (Long)iterator.next();
                dateHourMillisNoFlags.put(dateHourMillis, null);
            }
            this.updateStatus(false, entry.getKey(), dateHourMillisNoFlags);
        }
        TreeMap<Long, Flags> dateHourMillisNoFlags = new TreeMap<Long, Flags>();
        Iterator iterator = this.newBridgeStatuses.iterator();
        while (iterator.hasNext()) {
            long dateHourMillis = (Long)iterator.next();
            dateHourMillisNoFlags.put(dateHourMillis, null);
        }
        this.updateStatus(false, null, dateHourMillisNoFlags);
    }

    private void updateStatus(boolean relay, String fingerprint, SortedMap<Long, Flags> dateHourMillisFlags) {
        UptimeStatus uptimeStatus;
        UptimeStatus uptimeStatus2 = uptimeStatus = fingerprint == null ? this.documentStore.retrieve(UptimeStatus.class, true) : this.documentStore.retrieve(UptimeStatus.class, true, fingerprint);
        if (uptimeStatus == null) {
            uptimeStatus = new UptimeStatus();
        }
        for (Map.Entry<Long, Flags> e : dateHourMillisFlags.entrySet()) {
            uptimeStatus.addToHistory(relay, e.getKey(), e.getValue() == null ? null : e.getValue().getFlags());
        }
        if (uptimeStatus.isDirty()) {
            uptimeStatus.compressHistory();
            if (fingerprint == null) {
                this.documentStore.store(uptimeStatus);
            } else {
                this.documentStore.store(uptimeStatus, fingerprint);
            }
            uptimeStatus.clearDirty();
        }
    }

    @Override
    public String getStatsString() {
        return String.format("    %s hours of relay uptimes processed\n    %s hours of bridge uptimes processed\n    %s uptime status files updated\n", FormattingUtils.formatDecimalNumber(this.newRelayStatuses.size()), FormattingUtils.formatDecimalNumber(this.newBridgeStatuses.size()), FormattingUtils.formatDecimalNumber(this.newRunningRelays.size() + this.newRunningBridges.size()));
    }

    private static class Flags {
        private static Map<String, Integer> flagIndexes = new HashMap<String, Integer>();
        private static Map<Integer, String> flagStrings = new HashMap<Integer, String>();
        private BitSet flags = new BitSet(flagIndexes.size());

        private Flags(SortedSet<String> flags) {
            for (String flag : flags) {
                if (!flagIndexes.containsKey(flag)) {
                    flagStrings.put(flagIndexes.size(), flag);
                    flagIndexes.put(flag, flagIndexes.size());
                }
                this.flags.set(flagIndexes.get(flag));
            }
        }

        public SortedSet<String> getFlags() {
            TreeSet<String> result = new TreeSet<String>();
            if (this.flags != null) {
                int i = this.flags.nextSetBit(0);
                while (i >= 0) {
                    result.add(flagStrings.get(i));
                    i = this.flags.nextSetBit(i + 1);
                }
            }
            return result;
        }
    }
}

