/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormattingUtils {
    private static final Logger logger = LoggerFactory.getLogger(FormattingUtils.class);
    private static final long ONE_SECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private static Pattern escapePattern = Pattern.compile("(\\\\{4}u[0-9a-fA-F]{4})");

    private FormattingUtils() {
    }

    public static String formatMillis(long millis) {
        return String.format("%02d:%02d.%03d minutes", millis / 60000L, millis % 60000L / 1000L, millis % 1000L);
    }

    public static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        return String.format("%.1f %siB", (double)bytes / Math.pow(1024.0, exp), Character.valueOf("KMGTPE".charAt(exp - 1)));
    }

    public static String formatDecimalNumber(long decimalNumber) {
        return String.format("%,d", decimalNumber);
    }

    public static String replaceValidUtf(String text) {
        if (null == text || text.isEmpty()) {
            return text;
        }
        try {
            StringBuffer sb = new StringBuffer();
            Matcher mat = escapePattern.matcher(text);
            while (mat.find()) {
                String unescaped = mat.group(1).substring(1);
                mat.appendReplacement(sb, StringEscapeUtils.unescapeJava(unescaped));
            }
            mat.appendTail(sb);
            return sb.toString();
        }
        catch (Throwable ex) {
            logger.debug("Couldn't process input '{}'.", (Object)text, (Object)ex);
            return text;
        }
    }
}

