!function(e) {
    function t(a) {
        if (n[a]) return n[a].exports;
        var r = n[a] = {
            exports: {},
            id: a,
            loaded: !1
        };
        return e[a].call(r.exports, r, r.exports, t), r.loaded = !0, r.exports;
    }
    var n = {};
    return t.m = e, t.c = n, t.p = "", t(0);
}([ function(e, t, n) {
    "use strict";
    function a(e) {
        function t(e, t, r, s) {
            i.test(e, function() {
                a.expect(t), n([ "kubeLoader", function(e) {
                    e.reset(!0), r && e.handle(r);
                } ]), n(s);
            });
        }
        var n, a = i, s = r.module("registry.images.tests", [ "kubeClient", "registry.images" ]);
        t("filter containsTagImage", 7, e, [ "kubeSelect", "imageData", function(e, t) {
            var n = e().containsTagImage("sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719");
            a.equal(n.length, 2, "number ofstreams"), a.ok("/oapi/v1/namespaces/marmalade/imagestreams/busybee" in n, "matched busybee"), 
            a.ok("/oapi/v1/namespaces/marmalade/imagestreams/juggs" in n, "matched juggs"), 
            n = e().containsTagImage("sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"), 
            a.equal(n.length, 1, "one stream matched"), a.ok("/oapi/v1/namespaces/marmalade/imagestreams/juggs" in n, "other stream matched juggs"), 
            a.ok(!("/oapi/v1/namespaces/marmalade/imagestreams/busybee" in n), "other stream not busybee"), 
            n = e().containsTagImage("sha256:2077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1"), 
            a.equal(n.length, 0, "no streams selected");
        } ]), t("filter taggedBy", 4, e, [ "kubeSelect", "imageData", function(e, t) {
            var n = {
                tag: "2.5",
                items: [ {
                    image: "sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb"
                }, {
                    image: "sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"
                } ]
            }, r = e().kind("Image").taggedBy(n);
            a.equal(r.length, 2, "number of images"), a.ok("/oapi/v1/images/sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb" in r, "matched busybee"), 
            a.ok("/oapi/v1/images/sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450" in r, "matched juggs"), 
            n = {
                tag: "2.5",
                items: [ {
                    image: "sha256:00329beccad118aa937e839d536d753ee612b67f8feb6adb519e7f5aa6e75fbe"
                }, {
                    image: "sha256:0085eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"
                } ]
            }, r = e().kind("Image").taggedBy(n), a.equal(r.length, 0, "no images matched");
        } ]), t("filter taggedFirst", 4, e, [ "kubeSelect", "imageData", function(e, t) {
            var n = {
                tag: "2.5",
                items: [ {
                    image: "sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb"
                }, {
                    image: "sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"
                } ]
            }, r = e().kind("Image").taggedFirst(n);
            a.equal(r.length, 1, "number of images"), a.ok("/oapi/v1/images/sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb" in r, "matched busybee"), 
            a.ok(!("/oapi/v1/images/sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450" in r), "didn't match juggs"), 
            n = {
                tag: "2.5",
                items: [ {
                    image: "sha256:00329beccad118aa937e839d536d753ee612b67f8feb6adb519e7f5aa6e75fbe"
                }, {
                    image: "sha256:0085eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"
                } ]
            }, r = e().kind("Image").taggedFirst(n), a.equal(r.length, 0, "no images matched");
        } ]), t("filter listTagNames", 3, e, [ "kubeSelect", "imageData", function(e, t) {
            var n = e().listTagNames("sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719");
            a.deepEqual(n, [ "marmalade/busybee:latest", "marmalade/juggs:extratag" ], "got right names"), 
            n = e().listTagNames("sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"), 
            a.deepEqual(n, [ "marmalade/juggs:latest" ], "got another image tag name"), n = e().listTagNames("sha256:2077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1"), 
            a.deepEqual(n, [], "no names returned");
        } ]), t("split dockerImageManifest", 3, e, [ "kubeSelect", "imageData", function(e, t) {
            var n = e().kind("DockerImageManifest").name("sha256:63da16dc866fa7bfca4dd9d45b70feda28aa383c9ca1f1766c127ccc715a8cb7");
            a.equal(n.length, 1, "only manifest returned");
            var r = n["/internal/manifests/sha256:63da16dc866fa7bfca4dd9d45b70feda28aa383c9ca1f1766c127ccc715a8cb7"];
            a.ok(!!r, "got right manifest"), a.equal(r.manifest.history[0].v1Compatibility.config.Hostname, "13709f13afe1", "parsed manifest and compat");
        } ]), t("filter dockerConfigLabels", 3, e, [ "kubeSelect", "imageData", function(e, t) {
            var n = e().kind("Image").dockerImageConfig().dockerConfigLabels();
            a.equal(n.length, 1, "got one set of labels");
            var r = e().kind("Image").dockerImageConfig().dockerConfigLabels();
            a.strictEqual(n, r, "cached results");
            var i = n["/oapi/v1/images/sha256:63da16dc866fa7bfca4dd9d45b70feda28aa383c9ca1f1766c127ccc715a8cb7"];
            a.deepEqual(i, {
                Test: "Value",
                version: "1.0"
            }, "got right labels");
        } ]), r.module("exceptionOverride", []).factory("$exceptionHandler", function() {
            return function(e, t) {
                throw e.message += ' (caused by "' + t + '")', e;
            };
        }), s.run([ "$injector", function(e) {
            n = function(t) {
                return e.invoke(t);
            }, i.start();
        } ]), r.bootstrap(document, [ "registry.images.tests" ]);
    }
    var r = n(32), i = n(245);
    n(34), n(234), a([ {
        kind: "ImageStream",
        apiVersion: "v1",
        metadata: {
            name: "busybee",
            namespace: "marmalade",
            selfLink: "/oapi/v1/namespaces/marmalade/imagestreams/busybee",
            uid: "4612c052-b44e-11e5-a4da-5254009e00f1"
        },
        spec: {},
        status: {
            dockerImageRepository: "172.30.87.3:5000/marmalade/busybee",
            tags: [ {
                tag: "0.x",
                items: [ {
                    created: "2016-01-06T08:19:58Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/busybee@sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb",
                    image: "sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb"
                } ]
            }, {
                tag: "latest",
                items: [ {
                    created: "2016-01-06T08:19:58Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/busybee@sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719",
                    image: "sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719"
                } ]
            } ]
        }
    }, {
        kind: "ImageStream",
        apiVersion: "v1",
        metadata: {
            name: "juggs",
            namespace: "marmalade",
            selfLink: "/oapi/v1/namespaces/marmalade/imagestreams/juggs",
            uid: "84e3a672-b44e-11e5-a4da-5254009e00f1"
        },
        spec: {},
        status: {
            dockerImageRepository: "172.30.87.3:5000/marmalade/juggs",
            tags: [ {
                tag: "2.11",
                items: [ {
                    created: "2016-01-06T08:21:43Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/juggs@sha256:b074b7b7905895741f7425ab4e78b9df384aaa518258d2e81d9e904ecf6c9f0f",
                    image: "sha256:b074b7b7905895741f7425ab4e78b9df384aaa518258d2e81d9e904ecf6c9f0f"
                } ]
            }, {
                tag: "2.5",
                items: [ {
                    created: "2016-01-06T08:21:46Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/juggs@sha256:d0329beccad118aa937e839d536d753ee612b67f8feb6adb519e7f5aa6e75fbe",
                    image: "sha256:d0329beccad118aa937e839d536d753ee612b67f8feb6adb519e7f5aa6e75fbe"
                } ]
            }, {
                tag: "latest",
                items: [ {
                    created: "2016-01-06T08:21:43Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/juggs@sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450",
                    image: "sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"
                } ]
            }, {
                tag: "extratag",
                items: [ {
                    created: "2016-01-06T08:19:58Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/busybee@sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719",
                    image: "sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719"
                } ]
            } ]
        }
    }, {
        kind: "ImageStream",
        apiVersion: "v1",
        metadata: {
            name: "origin",
            namespace: "marmalade",
            selfLink: "/oapi/v1/namespaces/marmalade/imagestreams/origin",
            uid: "94813e0a-b44e-11e5-a4da-5254009e00f1"
        },
        spec: {},
        status: {
            dockerImageRepository: "172.30.87.3:5000/marmalade/origin",
            tags: [ {
                tag: "latest",
                items: [ {
                    created: "2016-01-06T08:22:10Z",
                    dockerImageReference: "172.30.87.3:5000/marmalade/origin@sha256:6077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1",
                    image: "sha256:6077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1"
                } ]
            } ]
        }
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450",
            selfLink: "/oapi/v1/images/sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450"
        },
        dockerImageReference: "172.30.87.3:5000/marmalade/juggs@sha256:0885eeaec4514820b2c879100425e9ea10beaf4412db7f67acfe53b4df2b9450",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:6077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1",
            selfLink: "/oapi/v1/images/sha256:6077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1"
        },
        dockerImageReference: "172.30.87.3:5000/marmalade/origin@sha256:6077956b196342f92271663ec85124aef44ee486f141b7d48e6ce5be410d78f1",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:98842019ab49391fe6b419eb131211ceb1aa17a89f655b05e7305366fecea5f2",
            selfLink: "/oapi/v1/images/sha256:98842019ab49391fe6b419eb131211ceb1aa17a89f655b05e7305366fecea5f2"
        },
        dockerImageReference: "172.30.87.3:5000/zerog/test@sha256:98842019ab49391fe6b419eb131211ceb1aa17a89f655b05e7305366fecea5f2",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:a7ca0c3e270a994cfdef0a1d77d8bd41d401135f2f9e02e0a3661cd026e81a77",
            selfLink: "/oapi/v1/images/sha256:a7ca0c3e270a994cfdef0a1d77d8bd41d401135f2f9e02e0a3661cd026e81a77"
        },
        dockerImageReference: "172.30.87.3:5000/zerog/test@sha256:a7ca0c3e270a994cfdef0a1d77d8bd41d401135f2f9e02e0a3661cd026e81a77",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:b074b7b7905895741f7425ab4e78b9df384aaa518258d2e81d9e904ecf6c9f0f",
            selfLink: "/oapi/v1/images/sha256:b074b7b7905895741f7425ab4e78b9df384aaa518258d2e81d9e904ecf6c9f0f"
        },
        dockerImageReference: "172.30.87.3:5000/marmalade/juggs@sha256:b074b7b7905895741f7425ab4e78b9df384aaa518258d2e81d9e904ecf6c9f0f",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb",
            selfLink: "/oapi/v1/images/sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb"
        },
        dockerImageReference: "172.30.87.3:5000/marmalade/busybee@sha256:beadfbc3da8d183c245ab5bad4dd185dacde72dbe81b270926e60e705e534afb",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719",
            selfLink: "/oapi/v1/images/sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719"
        },
        dockerImageReference: "172.30.87.3:5000/marmalade/busybee@sha256:c1ee91e9f0f96ea280d17befdd968ce4e37653939fc9e5e36429cd9674a28719",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "",
            Created: null,
            ContainerConfig: {}
        },
        dockerImageMetadataVersion: "1.0"
    }, {
        kind: "Image",
        apiVersion: "v1",
        metadata: {
            name: "sha256:63da16dc866fa7bfca4dd9d45b70feda28aa383c9ca1f1766c127ccc715a8cb7",
            selfLink: "/oapi/v1/images/sha256:63da16dc866fa7bfca4dd9d45b70feda28aa383c9ca1f1766c127ccc715a8cb7",
            annotations: {
                "openshift.io/image.managed": "true"
            }
        },
        dockerImageReference: "172.30.198.253:5000/marmalade/juggs@sha256:63da16dc866fa7bfca4dd9d45b70feda28aa383c9ca1f1766c127ccc715a8cb7",
        dockerImageMetadata: {
            kind: "DockerImage",
            apiVersion: "1.0",
            Id: "fc5cd5d8ca78a17843aba9b1b66e9d0e17200d86b0aad9a4f70d893a10c26b6d",
            Parent: "9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807",
            Created: "2016-03-04T16:50:11Z",
            Container: "7a453b461abfb9410f73e4449ed50d5840a44afb25b0144715b4266ee6d48f2d",
            ContainerConfig: {
                Hostname: "13709f13afe1",
                User: "nobody:wheel",
                ExposedPorts: {
                    "8888/tcp": {}
                },
                Env: [ "PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin" ],
                Cmd: [ "/bin/sh", "-c", "#(nop) LABEL version=1.0" ],
                Image: "9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807",
                Entrypoint: [ "top", "-b" ],
                OnBuild: [ "ADD . /app/src" ],
                Labels: {
                    Test: "Value",
                    version: "1.0"
                }
            },
            DockerVersion: "1.9.1",
            Config: {
                Hostname: "13709f13afe1",
                User: "nobody:wheel",
                ExposedPorts: {
                    "8888/tcp": {}
                },
                Env: [ "PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin" ],
                Cmd: [ "-c" ],
                Image: "9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807",
                Entrypoint: [ "top", "-b" ],
                OnBuild: [ "ADD . /app/src" ],
                Labels: {
                    Test: "Value",
                    version: "1.0"
                }
            },
            Architecture: "amd64",
            Size: 126388696
        },
        dockerImageMetadataVersion: "1.0",
        dockerImageManifest: '{\n   "schemaVersion": 1,\n   "name": "marmalade/juggs",\n   "tag": "2.8",\n   "architecture": "amd64",\n   "fsLayers": [\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:74fc2669b7664c1705ea18d946fb92111a2904fdc69c24dc25db546923663c4b"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:8cbbdaf3178f15e3e23f5eb59c754d16511edf100ba0e57557e47c8a5924d422"\n      },\n      {\n         "blobSum": "sha256:bc66c3b5709234727e260b55c5553c2bf9608084419271b08bca484914624d84"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:a3ed95caeb02ffe68cdd9fd84406680ae93d633cb16422d00e8a7c22955b46d4"\n      },\n      {\n         "blobSum": "sha256:f810322bba2c5f0a6dd58ba31eba0543baabb4533e479ab2db376aaa8064be55"\n      }\n   ],\n   "history": [\n      {\n         "v1Compatibility": "{\\"id\\":\\"fc5cd5d8ca78a17843aba9b1b66e9d0e17200d86b0aad9a4f70d893a10c26b6d\\",\\"parent\\":\\"9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807\\",\\"created\\":\\"2016-03-04T16:50:11.993242911Z\\",\\"container\\":\\"7a453b461abfb9410f73e4449ed50d5840a44afb25b0144715b4266ee6d48f2d\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) LABEL version=1.0\\"],\\"Image\\":\\"9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{\\"Test\\":\\"Value\\",\\"version\\":\\"1.0\\"},\\"StopSignal\\":\\"SIGKILL\\"},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{\\"Test\\":\\"Value\\",\\"version\\":\\"1.0\\"},\\"StopSignal\\":\\"SIGKILL\\"},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"9192c6aa777087e5c06e1d5f1771295f7cd79d9473d71dba2241e68aa2d36807\\",\\"parent\\":\\"425d372ab4256cc54cbbd1bd6ea9e00ce11fb8685175b72e5193f5a067bb6a31\\",\\"created\\":\\"2016-03-04T16:50:06.235447946Z\\",\\"container\\":\\"a13a641996f5d0425de27a7fd80d30174e165acd7bf913432f899ab2f57e0154\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) LABEL Test=Value\\"],\\"Image\\":\\"425d372ab4256cc54cbbd1bd6ea9e00ce11fb8685175b72e5193f5a067bb6a31\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{\\"Test\\":\\"Value\\"},\\"StopSignal\\":\\"SIGKILL\\"},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"425d372ab4256cc54cbbd1bd6ea9e00ce11fb8685175b72e5193f5a067bb6a31\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{\\"Test\\":\\"Value\\"},\\"StopSignal\\":\\"SIGKILL\\"},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"425d372ab4256cc54cbbd1bd6ea9e00ce11fb8685175b72e5193f5a067bb6a31\\",\\"parent\\":\\"9a7e5193513a4e07bcdcffacb9f1996ef7162a4d2c196d2eaa5b2b959d641dac\\",\\"created\\":\\"2016-03-04T16:50:00.89289203Z\\",\\"container\\":\\"2a9474018a32f776c8470897e6600b6a62503a734ae2775a5fbedd9ba9b28307\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ARG simple\\"],\\"Image\\":\\"9a7e5193513a4e07bcdcffacb9f1996ef7162a4d2c196d2eaa5b2b959d641dac\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"9a7e5193513a4e07bcdcffacb9f1996ef7162a4d2c196d2eaa5b2b959d641dac\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"9a7e5193513a4e07bcdcffacb9f1996ef7162a4d2c196d2eaa5b2b959d641dac\\",\\"parent\\":\\"dce61bf7ed98793fcfc6c09b6e096a0b74c58648397454660d4a896289f8adc9\\",\\"created\\":\\"2016-03-04T16:49:55.64958347Z\\",\\"container\\":\\"6fc564cbd8a2f53f81e1be0cf8b2752448c9b51d69787706bd1a40efc4b53870\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ARG hello=test\\"],\\"Image\\":\\"dce61bf7ed98793fcfc6c09b6e096a0b74c58648397454660d4a896289f8adc9\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"dce61bf7ed98793fcfc6c09b6e096a0b74c58648397454660d4a896289f8adc9\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"dce61bf7ed98793fcfc6c09b6e096a0b74c58648397454660d4a896289f8adc9\\",\\"parent\\":\\"a6853913f7a2789d8e91b4be6db0f3ca1fa635942981e6289d4cb067289be53f\\",\\"created\\":\\"2016-03-04T16:49:50.274796262Z\\",\\"container\\":\\"90360222ef8c7a4978c0a27542d78175b16cf1b559ea3a0c344c21d6596f8878\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ONBUILD ADD . /app/src\\"],\\"Image\\":\\"a6853913f7a2789d8e91b4be6db0f3ca1fa635942981e6289d4cb067289be53f\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"a6853913f7a2789d8e91b4be6db0f3ca1fa635942981e6289d4cb067289be53f\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[\\"ADD . /app/src\\"],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"a6853913f7a2789d8e91b4be6db0f3ca1fa635942981e6289d4cb067289be53f\\",\\"parent\\":\\"e4c263ade6bb3cc552dbcd46c38ecdacb871e3e18b4db92451cf89823fb1140d\\",\\"created\\":\\"2016-03-04T16:49:43.316816134Z\\",\\"container\\":\\"ada3ba6c28f4d40ad447384f990d4a2075abf86b821cbd5b1f3b339aae2bda7b\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) STOPSIGNAL [SIGKILL]\\"],\\"Image\\":\\"e4c263ade6bb3cc552dbcd46c38ecdacb871e3e18b4db92451cf89823fb1140d\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"e4c263ade6bb3cc552dbcd46c38ecdacb871e3e18b4db92451cf89823fb1140d\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[],\\"Labels\\":{},\\"StopSignal\\":\\"SIGKILL\\"},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"e4c263ade6bb3cc552dbcd46c38ecdacb871e3e18b4db92451cf89823fb1140d\\",\\"parent\\":\\"b3dd495a125e98acf8497462f7e59ddc59230f6e49a1e0c0a56a28007475af2e\\",\\"created\\":\\"2016-03-04T16:49:36.966840962Z\\",\\"container\\":\\"75a79bb684c3ff1a8b9bccd1f046e87f84b9da4722b8b45853602f0a69f4cb27\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) CMD [\\\\\\"-c\\\\\\"]\\"],\\"Image\\":\\"b3dd495a125e98acf8497462f7e59ddc59230f6e49a1e0c0a56a28007475af2e\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"-c\\"],\\"Image\\":\\"b3dd495a125e98acf8497462f7e59ddc59230f6e49a1e0c0a56a28007475af2e\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"b3dd495a125e98acf8497462f7e59ddc59230f6e49a1e0c0a56a28007475af2e\\",\\"parent\\":\\"2fef6101c97c5ca0a234e41eea1cdd577d6d9b1a21897147f8b662889f1e1890\\",\\"created\\":\\"2016-03-04T16:49:32.056781057Z\\",\\"container\\":\\"076b707ed7bf04602d56b714deb3270998c5b145520b925fc9d8029b28e1484e\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ENTRYPOINT \\\\u0026{[\\\\\\"top\\\\\\" \\\\\\"-b\\\\\\"]}\\"],\\"Image\\":\\"2fef6101c97c5ca0a234e41eea1cdd577d6d9b1a21897147f8b662889f1e1890\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":null,\\"Image\\":\\"2fef6101c97c5ca0a234e41eea1cdd577d6d9b1a21897147f8b662889f1e1890\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":[\\"top\\",\\"-b\\"],\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"2fef6101c97c5ca0a234e41eea1cdd577d6d9b1a21897147f8b662889f1e1890\\",\\"parent\\":\\"6559b720edfb44ed193826e8a98181ecd0f8412d36ae141891a6be8ac33f13fe\\",\\"created\\":\\"2016-03-04T16:49:27.230310779Z\\",\\"container\\":\\"b1fff8a998363845efbbc77e64e58a2ef8cd422896a40816fe5016a0d66c8804\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) USER [nobody:wheel]\\"],\\"Image\\":\\"6559b720edfb44ed193826e8a98181ecd0f8412d36ae141891a6be8ac33f13fe\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"nobody:wheel\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"\\\\\\"/echo-script\\\\\\"\\"],\\"Image\\":\\"6559b720edfb44ed193826e8a98181ecd0f8412d36ae141891a6be8ac33f13fe\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"6559b720edfb44ed193826e8a98181ecd0f8412d36ae141891a6be8ac33f13fe\\",\\"parent\\":\\"21356dd5eb576b1af9a101f0acb3729b3fe5c6a4a935a0efbe52d328603c6538\\",\\"created\\":\\"2016-03-04T16:49:19.278707045Z\\",\\"container\\":\\"a9ec15a2ac6c962d3f7141f789e0a703f68b1b35386b226485a470fdc297c921\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ADD file:32d397773a81df8feb5d5baf04619f65e2a1e4fddf24bbceb85157ff7f0db752 in /usr/bin\\"],\\"Image\\":\\"21356dd5eb576b1af9a101f0acb3729b3fe5c6a4a935a0efbe52d328603c6538\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"\\\\\\"/echo-script\\\\\\"\\"],\\"Image\\":\\"21356dd5eb576b1af9a101f0acb3729b3fe5c6a4a935a0efbe52d328603c6538\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\",\\"Size\\":125275044}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"21356dd5eb576b1af9a101f0acb3729b3fe5c6a4a935a0efbe52d328603c6538\\",\\"parent\\":\\"7fd39f4f39c71d76250adac15d7385fd6d68274e8a7ddd032b0b0bb6b3280a39\\",\\"created\\":\\"2016-03-04T16:48:53.085321054Z\\",\\"container\\":\\"7749a20ab52bd8714b5cc2823d3c09767f574b8f2d4bd4393b37f0a4964f3376\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) CMD [\\\\\\"/bin/sh\\\\\\" \\\\\\"-c\\\\\\" \\\\\\"\\\\\\\\\\\\\\"/echo-script\\\\\\\\\\\\\\"\\\\\\"]\\"],\\"Image\\":\\"7fd39f4f39c71d76250adac15d7385fd6d68274e8a7ddd032b0b0bb6b3280a39\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"author\\":\\"cockpit@example.com\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"\\\\\\"/echo-script\\\\\\"\\"],\\"Image\\":\\"7fd39f4f39c71d76250adac15d7385fd6d68274e8a7ddd032b0b0bb6b3280a39\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"7fd39f4f39c71d76250adac15d7385fd6d68274e8a7ddd032b0b0bb6b3280a39\\",\\"parent\\":\\"b6962728b43855b1c803aec38e67e70bd137040543def671e415834cdfc01552\\",\\"created\\":\\"2016-03-04T16:48:47.790555865Z\\",\\"container\\":\\"ab835892b5519c2d0ffd84e22fe3d971a4a80d9d3e31757c7dce5379b947887e\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"chmod +x /echo-script\\"],\\"Image\\":\\"b6962728b43855b1c803aec38e67e70bd137040543def671e415834cdfc01552\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"author\\":\\"cockpit@example.com\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"sh\\"],\\"Image\\":\\"b6962728b43855b1c803aec38e67e70bd137040543def671e415834cdfc01552\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\",\\"Size\\":49}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"b6962728b43855b1c803aec38e67e70bd137040543def671e415834cdfc01552\\",\\"parent\\":\\"b70fe9098263c3c82a67bc22caf523ced24185975088fd1043a799a6b4273882\\",\\"created\\":\\"2016-03-04T16:48:42.037533681Z\\",\\"container\\":\\"e16228a90ccf6d29c214833ba202b94b467979f5db03797d0a27da8430509966\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ADD file:b35fc316562d0e29fa7ae1e767f3597811f4349e30aa74122b67965a103f817a in /\\"],\\"Image\\":\\"b70fe9098263c3c82a67bc22caf523ced24185975088fd1043a799a6b4273882\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"author\\":\\"cockpit@example.com\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"sh\\"],\\"Image\\":\\"b70fe9098263c3c82a67bc22caf523ced24185975088fd1043a799a6b4273882\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\",\\"Size\\":49}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"b70fe9098263c3c82a67bc22caf523ced24185975088fd1043a799a6b4273882\\",\\"parent\\":\\"6e45971d34d5ecfc0b946014369c8dacab8f2177bbd3751dd5289b9a5ba59df2\\",\\"created\\":\\"2016-03-04T16:48:36.879318282Z\\",\\"container\\":\\"a759048c873ac86cef61a9aec0ac72734cfe53feb7acd81a2b4975473675ed20\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) EXPOSE 8888/tcp\\"],\\"Image\\":\\"6e45971d34d5ecfc0b946014369c8dacab8f2177bbd3751dd5289b9a5ba59df2\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"author\\":\\"cockpit@example.com\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"ExposedPorts\\":{\\"8888/tcp\\":{}},\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"sh\\"],\\"Image\\":\\"6e45971d34d5ecfc0b946014369c8dacab8f2177bbd3751dd5289b9a5ba59df2\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"6e45971d34d5ecfc0b946014369c8dacab8f2177bbd3751dd5289b9a5ba59df2\\",\\"parent\\":\\"fef924a0204a00b3ec67318e2ed337b189c99ea19e2bf10ed30a13b87c5e17ab\\",\\"created\\":\\"2016-03-04T16:48:31.254943299Z\\",\\"container\\":\\"0484d0202032d11f48613463684f344ddc4f238635dcb640774e00828251f57d\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) MAINTAINER cockpit@example.com\\"],\\"Image\\":\\"65e4158d96256e032299e07ac28308d644c0e81d52b18dcb08847a5027b4f107\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"author\\":\\"cockpit@example.com\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":[\\"PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin\\"],\\"Cmd\\":[\\"sh\\"],\\"Image\\":\\"65e4158d96256e032299e07ac28308d644c0e81d52b18dcb08847a5027b4f107\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":[],\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"fef924a0204a00b3ec67318e2ed337b189c99ea19e2bf10ed30a13b87c5e17ab\\",\\"parent\\":\\"9a163e0b8d138ec700b5a5f7e62509012f7eb34b9f86cd3bbeb3d183958114a9\\",\\"created\\":\\"2016-02-16T22:59:37.407805421Z\\",\\"container\\":\\"d23509cd0189de02bef382544ebfab515f29094f3c0e2f161fa7ce09afa8974e\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":null,\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) CMD [\\\\\\"sh\\\\\\"]\\"],\\"Image\\":\\"9a163e0b8d138ec700b5a5f7e62509012f7eb34b9f86cd3bbeb3d183958114a9\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":null,\\"Labels\\":{}},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":null,\\"Cmd\\":[\\"sh\\"],\\"Image\\":\\"9a163e0b8d138ec700b5a5f7e62509012f7eb34b9f86cd3bbeb3d183958114a9\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":null,\\"Labels\\":{}},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\"}"\n      },\n      {\n         "v1Compatibility": "{\\"id\\":\\"9a163e0b8d138ec700b5a5f7e62509012f7eb34b9f86cd3bbeb3d183958114a9\\",\\"created\\":\\"2016-02-16T22:59:36.792440427Z\\",\\"container\\":\\"13709f13afe11b7d4a007d2866afd20c5b783f0a89f4e6792a28102a4c12c473\\",\\"container_config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":null,\\"Cmd\\":[\\"/bin/sh\\",\\"-c\\",\\"#(nop) ADD file:7cdf7a89f6a004b2e9501317bd72bd863d93a51255d8f83b2ed3058d385a4938 in /\\"],\\"Image\\":\\"\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":null,\\"Labels\\":null},\\"docker_version\\":\\"1.9.1\\",\\"config\\":{\\"Hostname\\":\\"13709f13afe1\\",\\"Domainname\\":\\"\\",\\"User\\":\\"\\",\\"AttachStdin\\":false,\\"AttachStdout\\":false,\\"AttachStderr\\":false,\\"Tty\\":false,\\"OpenStdin\\":false,\\"StdinOnce\\":false,\\"Env\\":null,\\"Cmd\\":null,\\"Image\\":\\"\\",\\"Volumes\\":null,\\"WorkingDir\\":\\"\\",\\"Entrypoint\\":null,\\"OnBuild\\":null,\\"Labels\\":null},\\"architecture\\":\\"amd64\\",\\"os\\":\\"linux\\",\\"Size\\":1113554}"\n      }\n   ],\n   "signatures": [\n      {\n         "header": {\n            "jwk": {\n               "crv": "P-256",\n               "kid": "VQO7:TVYU:FARI:VIFC:P2YU:W23P:AC7V:7ZXR:I5RO:DTY4:NRES:MGXE",\n               "kty": "EC",\n               "x": "EsCEZHIfgzZDBsbCzgCng884FdTcwyQ8dZbhap2cpgo",\n               "y": "9Hlp74n2G2aMwzyvvM9G-8BbrXDp2dl9rt2RGbidQ8I"\n            },\n            "alg": "ES256"\n         },\n         "signature": "MFqsTUp-ci7Th-1r02bHj8eDh5xRg_WtjpN7WD4dI2Tuvg96fyGH6rf5bYKIjEVKz1_3Z42Ma06DDw8hSsMOGw",\n         "protected": "eyJmb3JtYXRMZW5ndGgiOjI3NjU1LCJmb3JtYXRUYWlsIjoiQ24wIiwidGltZSI6IjIwMTYtMDMtMDRUMTY6NTA6MzJaIn0"\n      }\n   ]\n}'
    } ]);
}, , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , , function(e, t, n) {
    /**
	 * @license AngularJS v1.3.20
	 * (c) 2010-2014 Google, Inc. http://angularjs.org
	 * License: MIT
	 */
    !function(e, t, n) {
        "use strict";
        function a(e, t) {
            return t = t || Error, function() {
                var n, a, r = arguments[0], i = "[" + (e ? e + ":" : "") + r + "] ", s = arguments[1], o = arguments;
                for (n = i + s.replace(/\{\d+\}/g, function(e) {
                    var t = +e.slice(1, -1);
                    return t + 2 < o.length ? me(o[t + 2]) : e;
                }), n = n + "\nhttp://errors.angularjs.org/1.3.20/" + (e ? e + "/" : "") + r, a = 2; a < arguments.length; a++) n = n + (2 == a ? "?" : "&") + "p" + (a - 2) + "=" + encodeURIComponent(me(arguments[a]));
                return new t(n);
            };
        }
        function r(e) {
            if (null == e || L(e)) return !1;
            var t = "length" in Object(e) && e.length;
            return !(e.nodeType !== ya || !t) || (y(e) || fa(e) || 0 === t || "number" == typeof t && t > 0 && t - 1 in e);
        }
        function i(e, t, n) {
            var a, s;
            if (e) if (k(e)) for (a in e) "prototype" == a || "length" == a || "name" == a || e.hasOwnProperty && !e.hasOwnProperty(a) || t.call(n, e[a], a, e); else if (fa(e) || r(e)) {
                var o = "object" != typeof e;
                for (a = 0, s = e.length; a < s; a++) (o || a in e) && t.call(n, e[a], a, e);
            } else if (e.forEach && e.forEach !== i) e.forEach(t, n, e); else for (a in e) e.hasOwnProperty(a) && t.call(n, e[a], a, e);
            return e;
        }
        function s(e) {
            return Object.keys(e).sort();
        }
        function o(e, t, n) {
            for (var a = s(e), r = 0; r < a.length; r++) t.call(n, e[a[r]], a[r]);
            return a;
        }
        function l(e) {
            return function(t, n) {
                e(n, t);
            };
        }
        function u() {
            return ++da;
        }
        function c(e, t) {
            t ? e.$$hashKey = t : delete e.$$hashKey;
        }
        function d(e) {
            for (var t = e.$$hashKey, n = 1, a = arguments.length; n < a; n++) {
                var r = arguments[n];
                if (r) for (var i = Object.keys(r), s = 0, o = i.length; s < o; s++) {
                    var l = i[s];
                    e[l] = r[l];
                }
            }
            return c(e, t), e;
        }
        function m(e) {
            return parseInt(e, 10);
        }
        function f(e, t) {
            return d(Object.create(e), t);
        }
        function p() {}
        function h(e) {
            return e;
        }
        function g(e) {
            return function() {
                return e;
            };
        }
        function _(e) {
            return "undefined" == typeof e;
        }
        function v(e) {
            return "undefined" != typeof e;
        }
        function b(e) {
            return null !== e && "object" == typeof e;
        }
        function y(e) {
            return "string" == typeof e;
        }
        function M(e) {
            return "number" == typeof e;
        }
        function $(e) {
            return "[object Date]" === la.call(e);
        }
        function k(e) {
            return "function" == typeof e;
        }
        function w(e) {
            return "[object RegExp]" === la.call(e);
        }
        function L(e) {
            return e && e.window === e;
        }
        function D(e) {
            return e && e.$evalAsync && e.$watch;
        }
        function Y(e) {
            return "[object File]" === la.call(e);
        }
        function T(e) {
            return "[object FormData]" === la.call(e);
        }
        function S(e) {
            return "[object Blob]" === la.call(e);
        }
        function x(e) {
            return "boolean" == typeof e;
        }
        function C(e) {
            return e && k(e.then);
        }
        function E(e) {
            return !(!e || !(e.nodeName || e.prop && e.attr && e.find));
        }
        function H(e) {
            var t, n = {}, a = e.split(",");
            for (t = 0; t < a.length; t++) n[a[t]] = !0;
            return n;
        }
        function A(e) {
            return Kn(e.nodeName || e[0] && e[0].nodeName);
        }
        function j(e, t) {
            var n = e.indexOf(t);
            return n >= 0 && e.splice(n, 1), t;
        }
        function O(e, t, n, a) {
            if (L(e) || D(e)) throw ua("cpws", "Can't copy! Making copies of Window or Scope instances is not supported.");
            if (t) {
                if (e === t) throw ua("cpi", "Can't copy! Source and destination are identical.");
                if (n = n || [], a = a || [], b(e)) {
                    var r = n.indexOf(e);
                    if (r !== -1) return a[r];
                    n.push(e), a.push(t);
                }
                var s;
                if (fa(e)) {
                    t.length = 0;
                    for (var o = 0; o < e.length; o++) s = O(e[o], null, n, a), b(e[o]) && (n.push(e[o]), 
                    a.push(s)), t.push(s);
                } else {
                    var l = t.$$hashKey;
                    fa(t) ? t.length = 0 : i(t, function(e, n) {
                        delete t[n];
                    });
                    for (var u in e) e.hasOwnProperty(u) && (s = O(e[u], null, n, a), b(e[u]) && (n.push(e[u]), 
                    a.push(s)), t[u] = s);
                    c(t, l);
                }
            } else if (t = e, e) if (fa(e)) t = O(e, [], n, a); else if ($(e)) t = new Date(e.getTime()); else if (w(e)) t = new RegExp(e.source, e.toString().match(/[^\/]*$/)[0]), 
            t.lastIndex = e.lastIndex; else if (b(e)) {
                var d = Object.create(Object.getPrototypeOf(e));
                t = O(e, d, n, a);
            }
            return t;
        }
        function I(e, t) {
            if (fa(e)) {
                t = t || [];
                for (var n = 0, a = e.length; n < a; n++) t[n] = e[n];
            } else if (b(e)) {
                t = t || {};
                for (var r in e) "$" === r.charAt(0) && "$" === r.charAt(1) || (t[r] = e[r]);
            }
            return t || e;
        }
        function P(e, t) {
            if (e === t) return !0;
            if (null === e || null === t) return !1;
            if (e !== e && t !== t) return !0;
            var a, r, i, s = typeof e, o = typeof t;
            if (s == o && "object" == s) {
                if (!fa(e)) {
                    if ($(e)) return !!$(t) && P(e.getTime(), t.getTime());
                    if (w(e)) return !!w(t) && e.toString() == t.toString();
                    if (D(e) || D(t) || L(e) || L(t) || fa(t) || $(t) || w(t)) return !1;
                    i = {};
                    for (r in e) if ("$" !== r.charAt(0) && !k(e[r])) {
                        if (!P(e[r], t[r])) return !1;
                        i[r] = !0;
                    }
                    for (r in t) if (!i.hasOwnProperty(r) && "$" !== r.charAt(0) && t[r] !== n && !k(t[r])) return !1;
                    return !0;
                }
                if (!fa(t)) return !1;
                if ((a = e.length) == t.length) {
                    for (r = 0; r < a; r++) if (!P(e[r], t[r])) return !1;
                    return !0;
                }
            }
            return !1;
        }
        function F(e, t, n) {
            return e.concat(ia.call(t, n));
        }
        function U(e, t) {
            return ia.call(e, t || 0);
        }
        function N(e, t) {
            var n = arguments.length > 2 ? U(arguments, 2) : [];
            return !k(t) || t instanceof RegExp ? t : n.length ? function() {
                return arguments.length ? t.apply(e, F(n, arguments, 0)) : t.apply(e, n);
            } : function() {
                return arguments.length ? t.apply(e, arguments) : t.call(e);
            };
        }
        function V(e, a) {
            var r = a;
            return "string" == typeof e && "$" === e.charAt(0) && "$" === e.charAt(1) ? r = n : L(a) ? r = "$WINDOW" : a && t === a ? r = "$DOCUMENT" : D(a) && (r = "$SCOPE"), 
            r;
        }
        function W(e, t) {
            return "undefined" == typeof e ? n : (M(t) || (t = t ? 2 : null), JSON.stringify(e, V, t));
        }
        function q(e) {
            return y(e) ? JSON.parse(e) : e;
        }
        function R(e) {
            e = na(e).clone();
            try {
                e.empty();
            } catch (e) {}
            var t = na("<div>").append(e).html();
            try {
                return e[0].nodeType === $a ? Kn(t) : t.match(/^(<[^>]+>)/)[1].replace(/^<([\w\-]+)/, function(e, t) {
                    return "<" + Kn(t);
                });
            } catch (e) {
                return Kn(t);
            }
        }
        function z(e) {
            try {
                return decodeURIComponent(e);
            } catch (e) {}
        }
        function B(e) {
            var t, n, a = {};
            return i((e || "").split("&"), function(e) {
                if (e && (t = e.replace(/\+/g, "%20").split("="), n = z(t[0]), v(n))) {
                    var r = !v(t[1]) || z(t[1]);
                    Qn.call(a, n) ? fa(a[n]) ? a[n].push(r) : a[n] = [ a[n], r ] : a[n] = r;
                }
            }), a;
        }
        function G(e) {
            var t = [];
            return i(e, function(e, n) {
                fa(e) ? i(e, function(e) {
                    t.push(K(n, !0) + (e === !0 ? "" : "=" + K(e, !0)));
                }) : t.push(K(n, !0) + (e === !0 ? "" : "=" + K(e, !0)));
            }), t.length ? t.join("&") : "";
        }
        function J(e) {
            return K(e, !0).replace(/%26/gi, "&").replace(/%3D/gi, "=").replace(/%2B/gi, "+");
        }
        function K(e, t) {
            return encodeURIComponent(e).replace(/%40/gi, "@").replace(/%3A/gi, ":").replace(/%24/g, "$").replace(/%2C/gi, ",").replace(/%3B/gi, ";").replace(/%20/g, t ? "%20" : "+");
        }
        function Q(e, t) {
            var n, a, r = _a.length;
            for (e = na(e), a = 0; a < r; ++a) if (n = _a[a] + t, y(n = e.attr(n))) return n;
            return null;
        }
        function Z(e, t) {
            var n, a, r = {};
            i(_a, function(t) {
                var r = t + "app";
                !n && e.hasAttribute && e.hasAttribute(r) && (n = e, a = e.getAttribute(r));
            }), i(_a, function(t) {
                var r, i = t + "app";
                !n && (r = e.querySelector("[" + i.replace(":", "\\:") + "]")) && (n = r, a = r.getAttribute(i));
            }), n && (r.strictDi = null !== Q(n, "strict-di"), t(n, a ? [ a ] : [], r));
        }
        function X(n, a, r) {
            b(r) || (r = {});
            var s = {
                strictDi: !1
            };
            r = d(s, r);
            var o = function() {
                if (n = na(n), n.injector()) {
                    var e = n[0] === t ? "document" : R(n);
                    throw ua("btstrpd", "App Already Bootstrapped with this Element '{0}'", e.replace(/</, "&lt;").replace(/>/, "&gt;"));
                }
                a = a || [], a.unshift([ "$provide", function(e) {
                    e.value("$rootElement", n);
                } ]), r.debugInfoEnabled && a.push([ "$compileProvider", function(e) {
                    e.debugInfoEnabled(!0);
                } ]), a.unshift("ng");
                var i = qe(a, r.strictDi);
                return i.invoke([ "$rootScope", "$rootElement", "$compile", "$injector", function(e, t, n, a) {
                    e.$apply(function() {
                        t.data("$injector", a), n(t)(e);
                    });
                } ]), i;
            }, l = /^NG_ENABLE_DEBUG_INFO!/, u = /^NG_DEFER_BOOTSTRAP!/;
            return e && l.test(e.name) && (r.debugInfoEnabled = !0, e.name = e.name.replace(l, "")), 
            e && !u.test(e.name) ? o() : (e.name = e.name.replace(u, ""), ca.resumeBootstrap = function(e) {
                return i(e, function(e) {
                    a.push(e);
                }), o();
            }, void (k(ca.resumeDeferredBootstrap) && ca.resumeDeferredBootstrap()));
        }
        function ee() {
            e.name = "NG_ENABLE_DEBUG_INFO!" + e.name, e.location.reload();
        }
        function te(e) {
            var t = ca.element(e).injector();
            if (!t) throw ua("test", "no injector found for element argument to getTestability");
            return t.get("$$testability");
        }
        function ne(e, t) {
            return t = t || "_", e.replace(va, function(e, n) {
                return (n ? t : "") + e.toLowerCase();
            });
        }
        function ae() {
            var t;
            ba || (aa = e.jQuery, aa && aa.fn.on ? (na = aa, d(aa.fn, {
                scope: Ua.scope,
                isolateScope: Ua.isolateScope,
                controller: Ua.controller,
                injector: Ua.injector,
                inheritedData: Ua.inheritedData
            }), t = aa.cleanData, aa.cleanData = function(e) {
                var n;
                if (ma) ma = !1; else for (var a, r = 0; null != (a = e[r]); r++) n = aa._data(a, "events"), 
                n && n.$destroy && aa(a).triggerHandler("$destroy");
                t(e);
            }) : na = ye, ca.element = na, ba = !0);
        }
        function re(e, t, n) {
            if (!e) throw ua("areq", "Argument '{0}' is {1}", t || "?", n || "required");
            return e;
        }
        function ie(e, t, n) {
            return n && fa(e) && (e = e[e.length - 1]), re(k(e), t, "not a function, got " + (e && "object" == typeof e ? e.constructor.name || "Object" : typeof e)), 
            e;
        }
        function se(e, t) {
            if ("hasOwnProperty" === e) throw ua("badname", "hasOwnProperty is not a valid {0} name", t);
        }
        function oe(e, t, n) {
            if (!t) return e;
            for (var a, r = t.split("."), i = e, s = r.length, o = 0; o < s; o++) a = r[o], 
            e && (e = (i = e)[a]);
            return !n && k(e) ? N(i, e) : e;
        }
        function le(e) {
            var t = e[0], n = e[e.length - 1], a = [ t ];
            do {
                if (t = t.nextSibling, !t) break;
                a.push(t);
            } while (t !== n);
            return na(a);
        }
        function ue() {
            return Object.create(null);
        }
        function ce(e) {
            function t(e, t, n) {
                return e[t] || (e[t] = n());
            }
            var n = a("$injector"), r = a("ng"), i = t(e, "angular", Object);
            return i.$$minErr = i.$$minErr || a, t(i, "module", function() {
                var e = {};
                return function(a, i, s) {
                    var o = function(e, t) {
                        if ("hasOwnProperty" === e) throw r("badname", "hasOwnProperty is not a valid {0} name", t);
                    };
                    return o(a, "module"), i && e.hasOwnProperty(a) && (e[a] = null), t(e, a, function() {
                        function e(e, n, a, r) {
                            return r || (r = t), function() {
                                return r[a || "push"]([ e, n, arguments ]), u;
                            };
                        }
                        if (!i) throw n("nomod", "Module '{0}' is not available! You either misspelled the module name or forgot to load it. If registering a module ensure that you specify the dependencies as the second argument.", a);
                        var t = [], r = [], o = [], l = e("$injector", "invoke", "push", r), u = {
                            _invokeQueue: t,
                            _configBlocks: r,
                            _runBlocks: o,
                            requires: i,
                            name: a,
                            provider: e("$provide", "provider"),
                            factory: e("$provide", "factory"),
                            service: e("$provide", "service"),
                            value: e("$provide", "value"),
                            constant: e("$provide", "constant", "unshift"),
                            animation: e("$animateProvider", "register"),
                            filter: e("$filterProvider", "register"),
                            controller: e("$controllerProvider", "register"),
                            directive: e("$compileProvider", "directive"),
                            config: l,
                            run: function(e) {
                                return o.push(e), this;
                            }
                        };
                        return s && l(s), u;
                    });
                };
            });
        }
        function de(e) {
            var t = [];
            return JSON.stringify(e, function(e, n) {
                if (n = V(e, n), b(n)) {
                    if (t.indexOf(n) >= 0) return "<<already seen>>";
                    t.push(n);
                }
                return n;
            });
        }
        function me(e) {
            return "function" == typeof e ? e.toString().replace(/ \{[\s\S]*$/, "") : "undefined" == typeof e ? "undefined" : "string" != typeof e ? de(e) : e;
        }
        function fe(t) {
            d(t, {
                bootstrap: X,
                copy: O,
                extend: d,
                equals: P,
                element: na,
                forEach: i,
                injector: qe,
                noop: p,
                bind: N,
                toJson: W,
                fromJson: q,
                identity: h,
                isUndefined: _,
                isDefined: v,
                isString: y,
                isFunction: k,
                isObject: b,
                isNumber: M,
                isElement: E,
                isArray: fa,
                version: Da,
                isDate: $,
                lowercase: Kn,
                uppercase: Zn,
                callbacks: {
                    counter: 0
                },
                getTestability: te,
                $$minErr: a,
                $$csp: ga,
                reloadWithDebugInfo: ee
            }), ra = ce(e);
            try {
                ra("ngLocale");
            } catch (e) {
                ra("ngLocale", []).provider("$locale", gt);
            }
            ra("ng", [ "ngLocale" ], [ "$provide", function(e) {
                e.provider({
                    $$sanitizeUri: Jt
                }), e.provider("$compile", Qe).directive({
                    a: Er,
                    input: Jr,
                    textarea: Jr,
                    form: Ir,
                    script: Pi,
                    select: Ni,
                    style: Wi,
                    option: Vi,
                    ngBind: Zr,
                    ngBindHtml: ei,
                    ngBindTemplate: Xr,
                    ngClass: ni,
                    ngClassEven: ri,
                    ngClassOdd: ai,
                    ngCloak: ii,
                    ngController: si,
                    ngForm: Pr,
                    ngHide: Ei,
                    ngIf: ui,
                    ngInclude: ci,
                    ngInit: mi,
                    ngNonBindable: Di,
                    ngPluralize: Yi,
                    ngRepeat: Ti,
                    ngShow: Ci,
                    ngStyle: Hi,
                    ngSwitch: Ai,
                    ngSwitchWhen: ji,
                    ngSwitchDefault: Oi,
                    ngOptions: Ui,
                    ngTransclude: Ii,
                    ngModel: ki,
                    ngList: fi,
                    ngChange: ti,
                    pattern: Ri,
                    ngPattern: Ri,
                    required: qi,
                    ngRequired: qi,
                    minlength: Bi,
                    ngMinlength: Bi,
                    maxlength: zi,
                    ngMaxlength: zi,
                    ngValue: Qr,
                    ngModelOptions: Li
                }).directive({
                    ngInclude: di
                }).directive(Hr).directive(oi), e.provider({
                    $anchorScroll: Re,
                    $animate: Ka,
                    $browser: Ge,
                    $cacheFactory: Je,
                    $controller: tt,
                    $document: nt,
                    $exceptionHandler: at,
                    $filter: ln,
                    $interpolate: pt,
                    $interval: ht,
                    $http: ct,
                    $httpBackend: mt,
                    $location: xt,
                    $log: Ct,
                    $parse: Wt,
                    $rootScope: Gt,
                    $q: qt,
                    $$q: Rt,
                    $sce: Xt,
                    $sceDelegate: Zt,
                    $sniffer: en,
                    $templateCache: Ke,
                    $templateRequest: tn,
                    $$testability: nn,
                    $timeout: an,
                    $window: on,
                    $$rAF: Bt,
                    $$asyncCallback: ze,
                    $$jqLite: Fe
                });
            } ]);
        }
        function pe() {
            return ++Ta;
        }
        function he(e) {
            return e.replace(Ca, function(e, t, n, a) {
                return a ? n.toUpperCase() : n;
            }).replace(Ea, "Moz$1");
        }
        function ge(e) {
            return !Oa.test(e);
        }
        function _e(e) {
            var t = e.nodeType;
            return t === ya || !t || t === wa;
        }
        function ve(e, t) {
            var n, a, r, s, o = t.createDocumentFragment(), l = [];
            if (ge(e)) l.push(t.createTextNode(e)); else {
                for (n = n || o.appendChild(t.createElement("div")), a = (Ia.exec(e) || [ "", "" ])[1].toLowerCase(), 
                r = Fa[a] || Fa._default, n.innerHTML = r[1] + e.replace(Pa, "<$1></$2>") + r[2], 
                s = r[0]; s--; ) n = n.lastChild;
                l = F(l, n.childNodes), n = o.firstChild, n.textContent = "";
            }
            return o.textContent = "", o.innerHTML = "", i(l, function(e) {
                o.appendChild(e);
            }), o;
        }
        function be(e, n) {
            n = n || t;
            var a;
            return (a = ja.exec(e)) ? [ n.createElement(a[1]) ] : (a = ve(e, n)) ? a.childNodes : [];
        }
        function ye(e) {
            if (e instanceof ye) return e;
            var t;
            if (y(e) && (e = pa(e), t = !0), !(this instanceof ye)) {
                if (t && "<" != e.charAt(0)) throw Aa("nosel", "Looking up elements via selectors is not supported by jqLite! See: http://docs.angularjs.org/api/angular.element");
                return new ye(e);
            }
            t ? xe(this, be(e)) : xe(this, e);
        }
        function Me(e) {
            return e.cloneNode(!0);
        }
        function $e(e, t) {
            if (t || we(e), e.querySelectorAll) for (var n = e.querySelectorAll("*"), a = 0, r = n.length; a < r; a++) we(n[a]);
        }
        function ke(e, t, n, a) {
            if (v(a)) throw Aa("offargs", "jqLite#off() does not support the `selector` argument");
            var r = Le(e), s = r && r.events, o = r && r.handle;
            if (o) if (t) i(t.split(" "), function(t) {
                if (v(n)) {
                    var a = s[t];
                    if (j(a || [], n), a && a.length > 0) return;
                }
                xa(e, t, o), delete s[t];
            }); else for (t in s) "$destroy" !== t && xa(e, t, o), delete s[t];
        }
        function we(e, t) {
            var a = e.ng339, r = a && Ya[a];
            if (r) {
                if (t) return void delete r.data[t];
                r.handle && (r.events.$destroy && r.handle({}, "$destroy"), ke(e)), delete Ya[a], 
                e.ng339 = n;
            }
        }
        function Le(e, t) {
            var a = e.ng339, r = a && Ya[a];
            return t && !r && (e.ng339 = a = pe(), r = Ya[a] = {
                events: {},
                data: {},
                handle: n
            }), r;
        }
        function De(e, t, n) {
            if (_e(e)) {
                var a = v(n), r = !a && t && !b(t), i = !t, s = Le(e, !r), o = s && s.data;
                if (a) o[t] = n; else {
                    if (i) return o;
                    if (r) return o && o[t];
                    d(o, t);
                }
            }
        }
        function Ye(e, t) {
            return !!e.getAttribute && (" " + (e.getAttribute("class") || "") + " ").replace(/[\n\t]/g, " ").indexOf(" " + t + " ") > -1;
        }
        function Te(e, t) {
            t && e.setAttribute && i(t.split(" "), function(t) {
                e.setAttribute("class", pa((" " + (e.getAttribute("class") || "") + " ").replace(/[\n\t]/g, " ").replace(" " + pa(t) + " ", " ")));
            });
        }
        function Se(e, t) {
            if (t && e.setAttribute) {
                var n = (" " + (e.getAttribute("class") || "") + " ").replace(/[\n\t]/g, " ");
                i(t.split(" "), function(e) {
                    e = pa(e), n.indexOf(" " + e + " ") === -1 && (n += e + " ");
                }), e.setAttribute("class", pa(n));
            }
        }
        function xe(e, t) {
            if (t) if (t.nodeType) e[e.length++] = t; else {
                var n = t.length;
                if ("number" == typeof n && t.window !== t) {
                    if (n) for (var a = 0; a < n; a++) e[e.length++] = t[a];
                } else e[e.length++] = t;
            }
        }
        function Ce(e, t) {
            return Ee(e, "$" + (t || "ngController") + "Controller");
        }
        function Ee(e, t, a) {
            e.nodeType == wa && (e = e.documentElement);
            for (var r = fa(t) ? t : [ t ]; e; ) {
                for (var i = 0, s = r.length; i < s; i++) if ((a = na.data(e, r[i])) !== n) return a;
                e = e.parentNode || e.nodeType === La && e.host;
            }
        }
        function He(e) {
            for ($e(e, !0); e.firstChild; ) e.removeChild(e.firstChild);
        }
        function Ae(e, t) {
            t || $e(e);
            var n = e.parentNode;
            n && n.removeChild(e);
        }
        function je(t, n) {
            n = n || e, "complete" === n.document.readyState ? n.setTimeout(t) : na(n).on("load", t);
        }
        function Oe(e, t) {
            var n = Na[t.toLowerCase()];
            return n && Va[A(e)] && n;
        }
        function Ie(e, t) {
            var n = e.nodeName;
            return ("INPUT" === n || "TEXTAREA" === n) && Wa[t];
        }
        function Pe(e, t) {
            var n = function(n, a) {
                n.isDefaultPrevented = function() {
                    return n.defaultPrevented;
                };
                var r = t[a || n.type], i = r ? r.length : 0;
                if (i) {
                    if (_(n.immediatePropagationStopped)) {
                        var s = n.stopImmediatePropagation;
                        n.stopImmediatePropagation = function() {
                            n.immediatePropagationStopped = !0, n.stopPropagation && n.stopPropagation(), s && s.call(n);
                        };
                    }
                    n.isImmediatePropagationStopped = function() {
                        return n.immediatePropagationStopped === !0;
                    }, i > 1 && (r = I(r));
                    for (var o = 0; o < i; o++) n.isImmediatePropagationStopped() || r[o].call(e, n);
                }
            };
            return n.elem = e, n;
        }
        function Fe() {
            this.$get = function() {
                return d(ye, {
                    hasClass: function(e, t) {
                        return e.attr && (e = e[0]), Ye(e, t);
                    },
                    addClass: function(e, t) {
                        return e.attr && (e = e[0]), Se(e, t);
                    },
                    removeClass: function(e, t) {
                        return e.attr && (e = e[0]), Te(e, t);
                    }
                });
            };
        }
        function Ue(e, t) {
            var n = e && e.$$hashKey;
            if (n) return "function" == typeof n && (n = e.$$hashKey()), n;
            var a = typeof e;
            return n = "function" == a || "object" == a && null !== e ? e.$$hashKey = a + ":" + (t || u)() : a + ":" + e;
        }
        function Ne(e, t) {
            if (t) {
                var n = 0;
                this.nextUid = function() {
                    return ++n;
                };
            }
            i(e, this.put, this);
        }
        function Ve(e) {
            var t = e.toString().replace(Ba, ""), n = t.match(qa);
            return n ? "function(" + (n[1] || "").replace(/[\s\r\n]+/, " ") + ")" : "fn";
        }
        function We(e, t, n) {
            var a, r, s, o;
            if ("function" == typeof e) {
                if (!(a = e.$inject)) {
                    if (a = [], e.length) {
                        if (t) throw y(n) && n || (n = e.name || Ve(e)), Ga("strictdi", "{0} is not using explicit annotation and cannot be invoked in strict mode", n);
                        r = e.toString().replace(Ba, ""), s = r.match(qa), i(s[1].split(Ra), function(e) {
                            e.replace(za, function(e, t, n) {
                                a.push(n);
                            });
                        });
                    }
                    e.$inject = a;
                }
            } else fa(e) ? (o = e.length - 1, ie(e[o], "fn"), a = e.slice(0, o)) : ie(e, "fn", !0);
            return a;
        }
        function qe(e, t) {
            function a(e) {
                return function(t, n) {
                    return b(t) ? void i(t, l(e)) : e(t, n);
                };
            }
            function r(e, t) {
                if (se(e, "service"), (k(t) || fa(t)) && (t = D.instantiate(t)), !t.$get) throw Ga("pget", "Provider '{0}' must define $get factory method.", e);
                return L[e + M] = t;
            }
            function s(e, t) {
                return function() {
                    var n = T.invoke(t, this);
                    if (_(n)) throw Ga("undef", "Provider '{0}' must return a value from $get factory method.", e);
                    return n;
                };
            }
            function o(e, t, n) {
                return r(e, {
                    $get: n !== !1 ? s(e, t) : t
                });
            }
            function u(e, t) {
                return o(e, [ "$injector", function(e) {
                    return e.instantiate(t);
                } ]);
            }
            function c(e, t) {
                return o(e, g(t), !1);
            }
            function d(e, t) {
                se(e, "constant"), L[e] = t, Y[e] = t;
            }
            function m(e, t) {
                var n = D.get(e + M), a = n.$get;
                n.$get = function() {
                    var e = T.invoke(a, n);
                    return T.invoke(t, null, {
                        $delegate: e
                    });
                };
            }
            function f(e) {
                var t, n = [];
                return i(e, function(e) {
                    function a(e) {
                        var t, n;
                        for (t = 0, n = e.length; t < n; t++) {
                            var a = e[t], r = D.get(a[0]);
                            r[a[1]].apply(r, a[2]);
                        }
                    }
                    if (!w.get(e)) {
                        w.put(e, !0);
                        try {
                            y(e) ? (t = ra(e), n = n.concat(f(t.requires)).concat(t._runBlocks), a(t._invokeQueue), 
                            a(t._configBlocks)) : k(e) ? n.push(D.invoke(e)) : fa(e) ? n.push(D.invoke(e)) : ie(e, "module");
                        } catch (t) {
                            throw fa(e) && (e = e[e.length - 1]), t.message && t.stack && t.stack.indexOf(t.message) == -1 && (t = t.message + "\n" + t.stack), 
                            Ga("modulerr", "Failed to instantiate module {0} due to:\n{1}", e, t.stack || t.message || t);
                        }
                    }
                }), n;
            }
            function h(e, n) {
                function a(t, a) {
                    if (e.hasOwnProperty(t)) {
                        if (e[t] === v) throw Ga("cdep", "Circular dependency found: {0}", t + " <- " + $.join(" <- "));
                        return e[t];
                    }
                    try {
                        return $.unshift(t), e[t] = v, e[t] = n(t, a);
                    } catch (n) {
                        throw e[t] === v && delete e[t], n;
                    } finally {
                        $.shift();
                    }
                }
                function r(e, n, r, i) {
                    "string" == typeof r && (i = r, r = null);
                    var s, o, l, u = [], c = qe.$$annotate(e, t, i);
                    for (o = 0, s = c.length; o < s; o++) {
                        if (l = c[o], "string" != typeof l) throw Ga("itkn", "Incorrect injection token! Expected service name as string, got {0}", l);
                        u.push(r && r.hasOwnProperty(l) ? r[l] : a(l, i));
                    }
                    return fa(e) && (e = e[s]), e.apply(n, u);
                }
                function i(e, t, n) {
                    var a = Object.create((fa(e) ? e[e.length - 1] : e).prototype || null), i = r(e, a, t, n);
                    return b(i) || k(i) ? i : a;
                }
                return {
                    invoke: r,
                    instantiate: i,
                    get: a,
                    annotate: qe.$$annotate,
                    has: function(t) {
                        return L.hasOwnProperty(t + M) || e.hasOwnProperty(t);
                    }
                };
            }
            t = t === !0;
            var v = {}, M = "Provider", $ = [], w = new Ne([], !0), L = {
                $provide: {
                    provider: a(r),
                    factory: a(o),
                    service: a(u),
                    value: a(c),
                    constant: a(d),
                    decorator: m
                }
            }, D = L.$injector = h(L, function(e, t) {
                throw ca.isString(t) && $.push(t), Ga("unpr", "Unknown provider: {0}", $.join(" <- "));
            }), Y = {}, T = Y.$injector = h(Y, function(e, t) {
                var a = D.get(e + M, t);
                return T.invoke(a.$get, a, n, e);
            });
            return i(f(e), function(e) {
                T.invoke(e || p);
            }), T;
        }
        function Re() {
            var e = !0;
            this.disableAutoScrolling = function() {
                e = !1;
            }, this.$get = [ "$window", "$location", "$rootScope", function(t, n, a) {
                function r(e) {
                    var t = null;
                    return Array.prototype.some.call(e, function(e) {
                        if ("a" === A(e)) return t = e, !0;
                    }), t;
                }
                function i() {
                    var e = o.yOffset;
                    if (k(e)) e = e(); else if (E(e)) {
                        var n = e[0], a = t.getComputedStyle(n);
                        e = "fixed" !== a.position ? 0 : n.getBoundingClientRect().bottom;
                    } else M(e) || (e = 0);
                    return e;
                }
                function s(e) {
                    if (e) {
                        e.scrollIntoView();
                        var n = i();
                        if (n) {
                            var a = e.getBoundingClientRect().top;
                            t.scrollBy(0, a - n);
                        }
                    } else t.scrollTo(0, 0);
                }
                function o() {
                    var e, t = n.hash();
                    t ? (e = l.getElementById(t)) ? s(e) : (e = r(l.getElementsByName(t))) ? s(e) : "top" === t && s(null) : s(null);
                }
                var l = t.document;
                return e && a.$watch(function() {
                    return n.hash();
                }, function(e, t) {
                    e === t && "" === e || je(function() {
                        a.$evalAsync(o);
                    });
                }), o;
            } ];
        }
        function ze() {
            this.$get = [ "$$rAF", "$timeout", function(e, t) {
                return e.supported ? function(t) {
                    return e(t);
                } : function(e) {
                    return t(e, 0, !1);
                };
            } ];
        }
        function Be(e, t, a, r) {
            function s(e) {
                try {
                    e.apply(null, U(arguments, 1));
                } finally {
                    if (w--, 0 === w) for (;L.length; ) try {
                        L.pop()();
                    } catch (e) {
                        a.error(e);
                    }
                }
            }
            function o(e) {
                var t = e.indexOf("#");
                return t === -1 ? "" : e.substr(t);
            }
            function l(e, t) {
                !function n() {
                    i(Y, function(e) {
                        e();
                    }), D = t(n, e);
                }();
            }
            function u() {
                d(), m();
            }
            function c() {
                try {
                    return b.state;
                } catch (e) {}
            }
            function d() {
                T = c(), T = _(T) ? null : T, P(T, j) && (T = j), j = T;
            }
            function m() {
                x === h.url() && S === T || (x = h.url(), S = T, i(H, function(e) {
                    e(h.url(), T);
                }));
            }
            function f(e) {
                try {
                    return decodeURIComponent(e);
                } catch (t) {
                    return e;
                }
            }
            var h = this, g = t[0], v = e.location, b = e.history, M = e.setTimeout, $ = e.clearTimeout, k = {};
            h.isMock = !1;
            var w = 0, L = [];
            h.$$completeOutstandingRequest = s, h.$$incOutstandingRequestCount = function() {
                w++;
            }, h.notifyWhenNoOutstandingRequests = function(e) {
                i(Y, function(e) {
                    e();
                }), 0 === w ? e() : L.push(e);
            };
            var D, Y = [];
            h.addPollFn = function(e) {
                return _(D) && l(100, M), Y.push(e), e;
            };
            var T, S, x = v.href, C = t.find("base"), E = null;
            d(), S = T, h.url = function(t, n, a) {
                if (_(a) && (a = null), v !== e.location && (v = e.location), b !== e.history && (b = e.history), 
                t) {
                    var i = S === a;
                    if (x === t && (!r.history || i)) return h;
                    var s = x && Mt(x) === Mt(t);
                    return x = t, S = a, !r.history || s && i ? (s && !E || (E = t), n ? v.replace(t) : s ? v.hash = o(t) : v.href = t) : (b[n ? "replaceState" : "pushState"](a, "", t), 
                    d(), S = T), h;
                }
                return E || v.href.replace(/%27/g, "'");
            }, h.state = function() {
                return T;
            };
            var H = [], A = !1, j = null;
            h.onUrlChange = function(t) {
                return A || (r.history && na(e).on("popstate", u), na(e).on("hashchange", u), A = !0), 
                H.push(t), t;
            }, h.$$checkUrlChange = m, h.baseHref = function() {
                var e = C.attr("href");
                return e ? e.replace(/^(https?\:)?\/\/[^\/]*/, "") : "";
            };
            var O = {}, I = "", F = h.baseHref();
            h.cookies = function(e, t) {
                var r, i, s, o, l;
                if (!e) {
                    if (g.cookie !== I) for (I = g.cookie, i = I.split("; "), O = {}, o = 0; o < i.length; o++) s = i[o], 
                    l = s.indexOf("="), l > 0 && (e = f(s.substring(0, l)), O[e] === n && (O[e] = f(s.substring(l + 1))));
                    return O;
                }
                t === n ? g.cookie = encodeURIComponent(e) + "=;path=" + F + ";expires=Thu, 01 Jan 1970 00:00:00 GMT" : y(t) && (r = (g.cookie = encodeURIComponent(e) + "=" + encodeURIComponent(t) + ";path=" + F).length + 1, 
                r > 4096 && a.warn("Cookie '" + e + "' possibly not set or overflowed because it was too large (" + r + " > 4096 bytes)!"));
            }, h.defer = function(e, t) {
                var n;
                return w++, n = M(function() {
                    delete k[n], s(e);
                }, t || 0), k[n] = !0, n;
            }, h.defer.cancel = function(e) {
                return !!k[e] && (delete k[e], $(e), s(p), !0);
            };
        }
        function Ge() {
            this.$get = [ "$window", "$log", "$sniffer", "$document", function(e, t, n, a) {
                return new Be(e, a, t, n);
            } ];
        }
        function Je() {
            this.$get = function() {
                function e(e, n) {
                    function r(e) {
                        e != m && (f ? f == e && (f = e.n) : f = e, i(e.n, e.p), i(e, m), m = e, m.n = null);
                    }
                    function i(e, t) {
                        e != t && (e && (e.p = t), t && (t.n = e));
                    }
                    if (e in t) throw a("$cacheFactory")("iid", "CacheId '{0}' is already taken!", e);
                    var s = 0, o = d({}, n, {
                        id: e
                    }), l = {}, u = n && n.capacity || Number.MAX_VALUE, c = {}, m = null, f = null;
                    return t[e] = {
                        put: function(e, t) {
                            if (u < Number.MAX_VALUE) {
                                var n = c[e] || (c[e] = {
                                    key: e
                                });
                                r(n);
                            }
                            if (!_(t)) return e in l || s++, l[e] = t, s > u && this.remove(f.key), t;
                        },
                        get: function(e) {
                            if (u < Number.MAX_VALUE) {
                                var t = c[e];
                                if (!t) return;
                                r(t);
                            }
                            return l[e];
                        },
                        remove: function(e) {
                            if (u < Number.MAX_VALUE) {
                                var t = c[e];
                                if (!t) return;
                                t == m && (m = t.p), t == f && (f = t.n), i(t.n, t.p), delete c[e];
                            }
                            delete l[e], s--;
                        },
                        removeAll: function() {
                            l = {}, s = 0, c = {}, m = f = null;
                        },
                        destroy: function() {
                            l = null, o = null, c = null, delete t[e];
                        },
                        info: function() {
                            return d({}, o, {
                                size: s
                            });
                        }
                    };
                }
                var t = {};
                return e.info = function() {
                    var e = {};
                    return i(t, function(t, n) {
                        e[n] = t.info();
                    }), e;
                }, e.get = function(e) {
                    return t[e];
                }, e;
            };
        }
        function Ke() {
            this.$get = [ "$cacheFactory", function(e) {
                return e("templates");
            } ];
        }
        function Qe(e, a) {
            function r(e, t) {
                var n = /^\s*([@&]|=(\*?))(\??)\s*(\w*)\s*$/, a = {};
                return i(e, function(e, r) {
                    var i = e.match(n);
                    if (!i) throw Qa("iscp", "Invalid isolate scope definition for directive '{0}'. Definition: {... {1}: '{2}' ...}", t, r, e);
                    a[r] = {
                        mode: i[1][0],
                        collection: "*" === i[2],
                        optional: "?" === i[3],
                        attrName: i[4] || r
                    };
                }), a;
            }
            var s = {}, o = "Directive", u = /^\s*directive\:\s*([\w\-]+)\s+(.*)$/, c = /(([\w\-]+)(?:\:([^;]+))?;?)/, m = H("ngSrc,ngSrcset,src,srcset"), _ = /^(?:(\^\^?)?(\?)?(\^\^?)?)?/, M = /^(on[a-z]+|formaction)$/;
            this.directive = function t(n, a) {
                return se(n, "directive"), y(n) ? (re(a, "directiveFactory"), s.hasOwnProperty(n) || (s[n] = [], 
                e.factory(n + o, [ "$injector", "$exceptionHandler", function(e, t) {
                    var a = [];
                    return i(s[n], function(i, s) {
                        try {
                            var o = e.invoke(i);
                            k(o) ? o = {
                                compile: g(o)
                            } : !o.compile && o.link && (o.compile = g(o.link)), o.priority = o.priority || 0, 
                            o.index = s, o.name = o.name || n, o.require = o.require || o.controller && o.name, 
                            o.restrict = o.restrict || "EA", b(o.scope) && (o.$$isolateBindings = r(o.scope, o.name)), 
                            a.push(o);
                        } catch (e) {
                            t(e);
                        }
                    }), a;
                } ])), s[n].push(a)) : i(n, l(t)), this;
            }, this.aHrefSanitizationWhitelist = function(e) {
                return v(e) ? (a.aHrefSanitizationWhitelist(e), this) : a.aHrefSanitizationWhitelist();
            }, this.imgSrcSanitizationWhitelist = function(e) {
                return v(e) ? (a.imgSrcSanitizationWhitelist(e), this) : a.imgSrcSanitizationWhitelist();
            };
            var $ = !0;
            this.debugInfoEnabled = function(e) {
                return v(e) ? ($ = e, this) : $;
            }, this.$get = [ "$injector", "$interpolate", "$exceptionHandler", "$templateRequest", "$parse", "$controller", "$rootScope", "$document", "$sce", "$animate", "$$sanitizeUri", function(e, a, r, l, g, v, w, L, Y, T, S) {
                function x(e, t) {
                    try {
                        e.addClass(t);
                    } catch (e) {}
                }
                function C(e, t, n, a, r) {
                    e instanceof na || (e = na(e)), i(e, function(t, n) {
                        t.nodeType == $a && t.nodeValue.match(/\S+/) && (e[n] = na(t).wrap("<span></span>").parent()[0]);
                    });
                    var s = H(e, t, e, n, a, r);
                    C.$$addScopeClass(e);
                    var o = null;
                    return function(t, n, a) {
                        re(t, "scope"), a = a || {};
                        var r = a.parentBoundTranscludeFn, i = a.transcludeControllers, l = a.futureParentElement;
                        r && r.$$boundTransclude && (r = r.$$boundTransclude), o || (o = E(l));
                        var u;
                        if (u = "html" !== o ? na(Z(o, na("<div>").append(e).html())) : n ? Ua.clone.call(e) : e, 
                        i) for (var c in i) u.data("$" + c + "Controller", i[c].instance);
                        return C.$$addScopeInfo(u, t), n && n(u, t), s && s(t, u, u, r), u;
                    };
                }
                function E(e) {
                    var t = e && e[0];
                    return t && "foreignobject" !== A(t) && t.toString().match(/SVG/) ? "svg" : "html";
                }
                function H(e, t, a, r, i, s) {
                    function o(e, a, r, i) {
                        var s, o, l, u, c, d, m, f, g;
                        if (p) {
                            var _ = a.length;
                            for (g = new Array(_), c = 0; c < h.length; c += 3) m = h[c], g[m] = a[m];
                        } else g = a;
                        for (c = 0, d = h.length; c < d; ) l = g[h[c++]], s = h[c++], o = h[c++], s ? (s.scope ? (u = e.$new(), 
                        C.$$addScopeInfo(na(l), u)) : u = e, f = s.transcludeOnThisElement ? O(e, s.transclude, i, s.elementTranscludeOnThisElement) : !s.templateOnThisElement && i ? i : !i && t ? O(e, t) : null, 
                        s(o, u, l, r, f)) : o && o(e, l.childNodes, n, i);
                    }
                    for (var l, u, c, d, m, f, p, h = [], g = 0; g < e.length; g++) l = new se(), u = I(e[g], [], l, 0 === g ? r : n, i), 
                    c = u.length ? V(u, e[g], l, t, a, null, [], [], s) : null, c && c.scope && C.$$addScopeClass(l.$$element), 
                    m = c && c.terminal || !(d = e[g].childNodes) || !d.length ? null : H(d, c ? (c.transcludeOnThisElement || !c.templateOnThisElement) && c.transclude : t), 
                    (c || m) && (h.push(g, c, m), f = !0, p = p || c), s = null;
                    return f ? o : null;
                }
                function O(e, t, n, a) {
                    var r = function(a, r, i, s, o) {
                        return a || (a = e.$new(!1, o), a.$$transcluded = !0), t(a, r, {
                            parentBoundTranscludeFn: n,
                            transcludeControllers: i,
                            futureParentElement: s
                        });
                    };
                    return r;
                }
                function I(e, t, n, a, r) {
                    var i, s, o = e.nodeType, l = n.$attr;
                    switch (o) {
                      case ya:
                        q(t, Ze(A(e)), "E", a, r);
                        for (var d, m, f, p, h, g, _ = e.attributes, v = 0, M = _ && _.length; v < M; v++) {
                            var $ = !1, k = !1;
                            d = _[v], m = d.name, h = pa(d.value), p = Ze(m), (g = de.test(p)) && (m = m.replace(Za, "").substr(8).replace(/_(.)/g, function(e, t) {
                                return t.toUpperCase();
                            }));
                            var w = p.replace(/(Start|End)$/, "");
                            z(w) && p === w + "Start" && ($ = m, k = m.substr(0, m.length - 5) + "end", m = m.substr(0, m.length - 6)), 
                            f = Ze(m.toLowerCase()), l[f] = m, !g && n.hasOwnProperty(f) || (n[f] = h, Oe(e, f) && (n[f] = !0)), 
                            ee(e, t, h, f, g), q(t, f, "A", a, r, $, k);
                        }
                        if (s = e.className, b(s) && (s = s.animVal), y(s) && "" !== s) for (;i = c.exec(s); ) f = Ze(i[2]), 
                        q(t, f, "C", a, r) && (n[f] = pa(i[3])), s = s.substr(i.index + i[0].length);
                        break;

                      case $a:
                        Q(t, e.nodeValue);
                        break;

                      case ka:
                        try {
                            i = u.exec(e.nodeValue), i && (f = Ze(i[1]), q(t, f, "M", a, r) && (n[f] = pa(i[2])));
                        } catch (e) {}
                    }
                    return t.sort(J), t;
                }
                function F(e, t, n) {
                    var a = [], r = 0;
                    if (t && e.hasAttribute && e.hasAttribute(t)) {
                        do {
                            if (!e) throw Qa("uterdir", "Unterminated attribute, found '{0}' but no matching '{1}' found.", t, n);
                            e.nodeType == ya && (e.hasAttribute(t) && r++, e.hasAttribute(n) && r--), a.push(e), 
                            e = e.nextSibling;
                        } while (r > 0);
                    } else a.push(e);
                    return na(a);
                }
                function N(e, t, n) {
                    return function(a, r, i, s, o) {
                        return r = F(r[0], t, n), e(a, r, i, s, o);
                    };
                }
                function V(e, s, o, l, u, c, d, m, f) {
                    function p(e, t, n, a) {
                        e && (n && (e = N(e, n, a)), e.require = L.require, e.directiveName = Y, (A === L || L.$$isolateScope) && (e = ae(e, {
                            isolateScope: !0
                        })), d.push(e)), t && (n && (t = N(t, n, a)), t.require = L.require, t.directiveName = Y, 
                        (A === L || L.$$isolateScope) && (t = ae(t, {
                            isolateScope: !0
                        })), m.push(t));
                    }
                    function h(e, t, n, a) {
                        var r, s, o = "data", l = !1, u = n;
                        if (y(t)) {
                            if (s = t.match(_), t = t.substring(s[0].length), s[3] && (s[1] ? s[3] = null : s[1] = s[3]), 
                            "^" === s[1] ? o = "inheritedData" : "^^" === s[1] && (o = "inheritedData", u = n.parent()), 
                            "?" === s[2] && (l = !0), r = null, a && "data" === o && (r = a[t]) && (r = r.instance), 
                            r = r || u[o]("$" + t + "Controller"), !r && !l) throw Qa("ctreq", "Controller '{0}', required by directive '{1}', can't be found!", t, e);
                            return r || null;
                        }
                        return fa(t) && (r = [], i(t, function(t) {
                            r.push(h(e, t, n, a));
                        })), r;
                    }
                    function M(e, t, r, l, u) {
                        function c(e, t, a) {
                            var r;
                            return D(e) || (a = t, t = e, e = n), z && (r = M), a || (a = z ? k.parent() : k), 
                            u(e, t, r, a, S);
                        }
                        var f, p, _, b, y, M, $, k, L;
                        if (s === r ? (L = o, k = o.$$element) : (k = na(r), L = new se(k, o)), A && (y = t.$new(!0)), 
                        u && ($ = c, $.$$boundTransclude = u), H && (w = {}, M = {}, i(H, function(e) {
                            var n, a = {
                                $scope: e === A || e.$$isolateScope ? y : t,
                                $element: k,
                                $attrs: L,
                                $transclude: $
                            };
                            b = e.controller, "@" == b && (b = L[e.name]), n = v(b, a, !0, e.controllerAs), 
                            M[e.name] = n, z || k.data("$" + e.name + "Controller", n.instance), w[e.name] = n;
                        })), A) {
                            C.$$addScopeInfo(k, y, !0, !(j && (j === A || j === A.$$originalDirective))), C.$$addScopeClass(k, !0);
                            var Y = w && w[A.name], T = y;
                            Y && Y.identifier && A.bindToController === !0 && (T = Y.instance), i(y.$$isolateBindings = A.$$isolateBindings, function(e, n) {
                                var r, i, s, o, l = e.attrName, u = e.optional, c = e.mode;
                                switch (c) {
                                  case "@":
                                    L.$observe(l, function(e) {
                                        T[n] = e;
                                    }), L.$$observers[l].$$scope = t, L[l] && (T[n] = a(L[l])(t));
                                    break;

                                  case "=":
                                    if (u && !L[l]) return;
                                    i = g(L[l]), o = i.literal ? P : function(e, t) {
                                        return e === t || e !== e && t !== t;
                                    }, s = i.assign || function() {
                                        throw r = T[n] = i(t), Qa("nonassign", "Expression '{0}' used with directive '{1}' is non-assignable!", L[l], A.name);
                                    }, r = T[n] = i(t);
                                    var d = function(e) {
                                        return o(e, T[n]) || (o(e, r) ? s(t, e = T[n]) : T[n] = e), r = e;
                                    };
                                    d.$stateful = !0;
                                    var m;
                                    m = e.collection ? t.$watchCollection(L[l], d) : t.$watch(g(L[l], d), null, i.literal), 
                                    y.$on("$destroy", m);
                                    break;

                                  case "&":
                                    i = g(L[l]), T[n] = function(e) {
                                        return i(t, e);
                                    };
                                }
                            });
                        }
                        for (w && (i(w, function(e) {
                            e();
                        }), w = null), f = 0, p = d.length; f < p; f++) _ = d[f], ie(_, _.isolateScope ? y : t, k, L, _.require && h(_.directiveName, _.require, k, M), $);
                        var S = t;
                        for (A && (A.template || null === A.templateUrl) && (S = y), e && e(S, r.childNodes, n, u), 
                        f = m.length - 1; f >= 0; f--) _ = m[f], ie(_, _.isolateScope ? y : t, k, L, _.require && h(_.directiveName, _.require, k, M), $);
                    }
                    f = f || {};
                    for (var $, w, L, Y, T, S, x, E = -Number.MAX_VALUE, H = f.controllerDirectives, A = f.newIsolateScopeDirective, j = f.templateDirective, O = f.nonTlbTranscludeDirective, V = !1, q = !1, z = f.hasElementTranscludeDirective, J = o.$$element = na(s), Q = c, X = l, ee = 0, ne = e.length; ee < ne; ee++) {
                        L = e[ee];
                        var re = L.$$start, oe = L.$$end;
                        if (re && (J = F(s, re, oe)), T = n, E > L.priority) break;
                        if ((x = L.scope) && (L.templateUrl || (b(x) ? (K("new/isolated scope", A || $, L, J), 
                        A = L) : K("new/isolated scope", A, L, J)), $ = $ || L), Y = L.name, !L.templateUrl && L.controller && (x = L.controller, 
                        H = H || {}, K("'" + Y + "' controller", H[Y], L, J), H[Y] = L), (x = L.transclude) && (V = !0, 
                        L.$$tlb || (K("transclusion", O, L, J), O = L), "element" == x ? (z = !0, E = L.priority, 
                        T = J, J = o.$$element = na(t.createComment(" " + Y + ": " + o[Y] + " ")), s = J[0], 
                        te(u, U(T), s), X = C(T, l, E, Q && Q.name, {
                            nonTlbTranscludeDirective: O
                        })) : (T = na(Me(s)).contents(), J.empty(), X = C(T, l))), L.template) if (q = !0, 
                        K("template", j, L, J), j = L, x = k(L.template) ? L.template(J, o) : L.template, 
                        x = ce(x), L.replace) {
                            if (Q = L, T = ge(x) ? [] : et(Z(L.templateNamespace, pa(x))), s = T[0], 1 != T.length || s.nodeType !== ya) throw Qa("tplrt", "Template for directive '{0}' must have exactly one root element. {1}", Y, "");
                            te(u, J, s);
                            var le = {
                                $attr: {}
                            }, ue = I(s, [], le), de = e.splice(ee + 1, e.length - (ee + 1));
                            A && W(ue), e = e.concat(ue).concat(de), B(o, le), ne = e.length;
                        } else J.html(x);
                        if (L.templateUrl) q = !0, K("template", j, L, J), j = L, L.replace && (Q = L), 
                        M = G(e.splice(ee, e.length - ee), J, o, u, V && X, d, m, {
                            controllerDirectives: H,
                            newIsolateScopeDirective: A,
                            templateDirective: j,
                            nonTlbTranscludeDirective: O
                        }), ne = e.length; else if (L.compile) try {
                            S = L.compile(J, o, X), k(S) ? p(null, S, re, oe) : S && p(S.pre, S.post, re, oe);
                        } catch (e) {
                            r(e, R(J));
                        }
                        L.terminal && (M.terminal = !0, E = Math.max(E, L.priority));
                    }
                    return M.scope = $ && $.scope === !0, M.transcludeOnThisElement = V, M.elementTranscludeOnThisElement = z, 
                    M.templateOnThisElement = q, M.transclude = X, f.hasElementTranscludeDirective = z, 
                    M;
                }
                function W(e) {
                    for (var t = 0, n = e.length; t < n; t++) e[t] = f(e[t], {
                        $$isolateScope: !0
                    });
                }
                function q(t, a, i, l, u, c, d) {
                    if (a === u) return null;
                    var m = null;
                    if (s.hasOwnProperty(a)) for (var p, h = e.get(a + o), g = 0, _ = h.length; g < _; g++) try {
                        p = h[g], (l === n || l > p.priority) && p.restrict.indexOf(i) != -1 && (c && (p = f(p, {
                            $$start: c,
                            $$end: d
                        })), t.push(p), m = p);
                    } catch (e) {
                        r(e);
                    }
                    return m;
                }
                function z(t) {
                    if (s.hasOwnProperty(t)) for (var n, a = e.get(t + o), r = 0, i = a.length; r < i; r++) if (n = a[r], 
                    n.multiElement) return !0;
                    return !1;
                }
                function B(e, t) {
                    var n = t.$attr, a = e.$attr, r = e.$$element;
                    i(e, function(a, r) {
                        "$" != r.charAt(0) && (t[r] && t[r] !== a && (a += ("style" === r ? ";" : " ") + t[r]), 
                        e.$set(r, a, !0, n[r]));
                    }), i(t, function(t, i) {
                        "class" == i ? (x(r, t), e.class = (e.class ? e.class + " " : "") + t) : "style" == i ? (r.attr("style", r.attr("style") + ";" + t), 
                        e.style = (e.style ? e.style + ";" : "") + t) : "$" == i.charAt(0) || e.hasOwnProperty(i) || (e[i] = t, 
                        a[i] = n[i]);
                    });
                }
                function G(e, t, n, a, r, s, o, u) {
                    var c, d, m = [], p = t[0], h = e.shift(), g = f(h, {
                        templateUrl: null,
                        transclude: null,
                        replace: null,
                        $$originalDirective: h
                    }), _ = k(h.templateUrl) ? h.templateUrl(t, n) : h.templateUrl, v = h.templateNamespace;
                    return t.empty(), l(_).then(function(l) {
                        var f, y, M, $;
                        if (l = ce(l), h.replace) {
                            if (M = ge(l) ? [] : et(Z(v, pa(l))), f = M[0], 1 != M.length || f.nodeType !== ya) throw Qa("tplrt", "Template for directive '{0}' must have exactly one root element. {1}", h.name, _);
                            y = {
                                $attr: {}
                            }, te(a, t, f);
                            var k = I(f, [], y);
                            b(h.scope) && W(k), e = k.concat(e), B(n, y);
                        } else f = p, t.html(l);
                        for (e.unshift(g), c = V(e, f, n, r, t, h, s, o, u), i(a, function(e, n) {
                            e == f && (a[n] = t[0]);
                        }), d = H(t[0].childNodes, r); m.length; ) {
                            var w = m.shift(), L = m.shift(), D = m.shift(), Y = m.shift(), T = t[0];
                            if (!w.$$destroyed) {
                                if (L !== p) {
                                    var S = L.className;
                                    u.hasElementTranscludeDirective && h.replace || (T = Me(f)), te(D, na(L), T), x(na(T), S);
                                }
                                $ = c.transcludeOnThisElement ? O(w, c.transclude, Y) : Y, c(d, w, T, a, $);
                            }
                        }
                        m = null;
                    }), function(e, t, n, a, r) {
                        var i = r;
                        t.$$destroyed || (m ? m.push(t, n, a, i) : (c.transcludeOnThisElement && (i = O(t, c.transclude, r)), 
                        c(d, t, n, a, i)));
                    };
                }
                function J(e, t) {
                    var n = t.priority - e.priority;
                    return 0 !== n ? n : e.name !== t.name ? e.name < t.name ? -1 : 1 : e.index - t.index;
                }
                function K(e, t, n, a) {
                    if (t) throw Qa("multidir", "Multiple directives [{0}, {1}] asking for {2} on: {3}", t.name, n.name, e, R(a));
                }
                function Q(e, t) {
                    var n = a(t, !0);
                    n && e.push({
                        priority: 0,
                        compile: function(e) {
                            var t = e.parent(), a = !!t.length;
                            return a && C.$$addBindingClass(t), function(e, t) {
                                var r = t.parent();
                                a || C.$$addBindingClass(r), C.$$addBindingInfo(r, n.expressions), e.$watch(n, function(e) {
                                    t[0].nodeValue = e;
                                });
                            };
                        }
                    });
                }
                function Z(e, n) {
                    switch (e = Kn(e || "html")) {
                      case "svg":
                      case "math":
                        var a = t.createElement("div");
                        return a.innerHTML = "<" + e + ">" + n + "</" + e + ">", a.childNodes[0].childNodes;

                      default:
                        return n;
                    }
                }
                function X(e, t) {
                    if ("srcdoc" == t) return Y.HTML;
                    var n = A(e);
                    return "xlinkHref" == t || "form" == n && "action" == t || "img" != n && ("src" == t || "ngSrc" == t) ? Y.RESOURCE_URL : void 0;
                }
                function ee(e, t, n, r, i) {
                    var s = X(e, r);
                    i = m[r] || i;
                    var o = a(n, !0, s, i);
                    if (o) {
                        if ("multiple" === r && "select" === A(e)) throw Qa("selmulti", "Binding to the 'multiple' attribute is not supported. Element: {0}", R(e));
                        t.push({
                            priority: 100,
                            compile: function() {
                                return {
                                    pre: function(e, t, l) {
                                        var u = l.$$observers || (l.$$observers = {});
                                        if (M.test(r)) throw Qa("nodomevents", "Interpolations for HTML DOM event attributes are disallowed.  Please use the ng- versions (such as ng-click instead of onclick) instead.");
                                        var c = l[r];
                                        c !== n && (o = c && a(c, !0, s, i), n = c), o && (l[r] = o(e), (u[r] || (u[r] = [])).$$inter = !0, 
                                        (l.$$observers && l.$$observers[r].$$scope || e).$watch(o, function(e, t) {
                                            "class" === r && e != t ? l.$updateClass(e, t) : l.$set(r, e);
                                        }));
                                    }
                                };
                            }
                        });
                    }
                }
                function te(e, n, a) {
                    var r, i, s = n[0], o = n.length, l = s.parentNode;
                    if (e) for (r = 0, i = e.length; r < i; r++) if (e[r] == s) {
                        e[r++] = a;
                        for (var u = r, c = u + o - 1, d = e.length; u < d; u++, c++) c < d ? e[u] = e[c] : delete e[u];
                        e.length -= o - 1, e.context === s && (e.context = a);
                        break;
                    }
                    l && l.replaceChild(a, s);
                    var m = t.createDocumentFragment();
                    m.appendChild(s), na(a).data(na(s).data()), aa ? (ma = !0, aa.cleanData([ s ])) : delete na.cache[s[na.expando]];
                    for (var f = 1, p = n.length; f < p; f++) {
                        var h = n[f];
                        na(h).remove(), m.appendChild(h), delete n[f];
                    }
                    n[0] = a, n.length = 1;
                }
                function ae(e, t) {
                    return d(function() {
                        return e.apply(null, arguments);
                    }, e, t);
                }
                function ie(e, t, n, a, i, s) {
                    try {
                        e(t, n, a, i, s);
                    } catch (e) {
                        r(e, R(n));
                    }
                }
                var se = function(e, t) {
                    if (t) {
                        var n, a, r, i = Object.keys(t);
                        for (n = 0, a = i.length; n < a; n++) r = i[n], this[r] = t[r];
                    } else this.$attr = {};
                    this.$$element = e;
                };
                se.prototype = {
                    $normalize: Ze,
                    $addClass: function(e) {
                        e && e.length > 0 && T.addClass(this.$$element, e);
                    },
                    $removeClass: function(e) {
                        e && e.length > 0 && T.removeClass(this.$$element, e);
                    },
                    $updateClass: function(e, t) {
                        var n = Xe(e, t);
                        n && n.length && T.addClass(this.$$element, n);
                        var a = Xe(t, e);
                        a && a.length && T.removeClass(this.$$element, a);
                    },
                    $set: function(e, t, a, s) {
                        var o, l = this.$$element[0], u = Oe(l, e), c = Ie(l, e), d = e;
                        if (u ? (this.$$element.prop(e, t), s = u) : c && (this[c] = t, d = c), this[e] = t, 
                        s ? this.$attr[e] = s : (s = this.$attr[e], s || (this.$attr[e] = s = ne(e, "-"))), 
                        o = A(this.$$element), "a" === o && "href" === e || "img" === o && "src" === e) this[e] = t = S(t, "src" === e); else if ("img" === o && "srcset" === e) {
                            for (var m = "", f = pa(t), p = /(\s+\d+x\s*,|\s+\d+w\s*,|\s+,|,\s+)/, h = /\s/.test(f) ? p : /(,)/, g = f.split(h), _ = Math.floor(g.length / 2), v = 0; v < _; v++) {
                                var b = 2 * v;
                                m += S(pa(g[b]), !0), m += " " + pa(g[b + 1]);
                            }
                            var y = pa(g[2 * v]).split(/\s/);
                            m += S(pa(y[0]), !0), 2 === y.length && (m += " " + pa(y[1])), this[e] = t = m;
                        }
                        a !== !1 && (null === t || t === n ? this.$$element.removeAttr(s) : this.$$element.attr(s, t));
                        var M = this.$$observers;
                        M && i(M[d], function(e) {
                            try {
                                e(t);
                            } catch (e) {
                                r(e);
                            }
                        });
                    },
                    $observe: function(e, t) {
                        var n = this, a = n.$$observers || (n.$$observers = ue()), r = a[e] || (a[e] = []);
                        return r.push(t), w.$evalAsync(function() {
                            !r.$$inter && n.hasOwnProperty(e) && t(n[e]);
                        }), function() {
                            j(r, t);
                        };
                    }
                };
                var oe = a.startSymbol(), le = a.endSymbol(), ce = "{{" == oe || "}}" == le ? h : function(e) {
                    return e.replace(/\{\{/g, oe).replace(/}}/g, le);
                }, de = /^ngAttr[A-Z]/;
                return C.$$addBindingInfo = $ ? function(e, t) {
                    var n = e.data("$binding") || [];
                    fa(t) ? n = n.concat(t) : n.push(t), e.data("$binding", n);
                } : p, C.$$addBindingClass = $ ? function(e) {
                    x(e, "ng-binding");
                } : p, C.$$addScopeInfo = $ ? function(e, t, n, a) {
                    var r = n ? a ? "$isolateScopeNoTemplate" : "$isolateScope" : "$scope";
                    e.data(r, t);
                } : p, C.$$addScopeClass = $ ? function(e, t) {
                    x(e, t ? "ng-isolate-scope" : "ng-scope");
                } : p, C;
            } ];
        }
        function Ze(e) {
            return he(e.replace(Za, ""));
        }
        function Xe(e, t) {
            var n = "", a = e.split(/\s+/), r = t.split(/\s+/);
            e: for (var i = 0; i < a.length; i++) {
                for (var s = a[i], o = 0; o < r.length; o++) if (s == r[o]) continue e;
                n += (n.length > 0 ? " " : "") + s;
            }
            return n;
        }
        function et(e) {
            e = na(e);
            var t = e.length;
            if (t <= 1) return e;
            for (;t--; ) {
                var n = e[t];
                n.nodeType === ka && sa.call(e, t, 1);
            }
            return e;
        }
        function tt() {
            var e = {}, t = !1, r = /^(\S+)(\s+as\s+(\w+))?$/;
            this.register = function(t, n) {
                se(t, "controller"), b(t) ? d(e, t) : e[t] = n;
            }, this.allowGlobals = function() {
                t = !0;
            }, this.$get = [ "$injector", "$window", function(i, s) {
                function o(e, t, n, r) {
                    if (!e || !b(e.$scope)) throw a("$controller")("noscp", "Cannot export controller '{0}' as '{1}'! No $scope object provided via `locals`.", r, t);
                    e.$scope[t] = n;
                }
                return function(a, l, u, c) {
                    var m, f, p, h;
                    if (u = u === !0, c && y(c) && (h = c), y(a)) {
                        if (f = a.match(r), !f) throw Xa("ctrlfmt", "Badly formed controller string '{0}'. Must match `__name__ as __id__` or `__name__`.", a);
                        p = f[1], h = h || f[3], a = e.hasOwnProperty(p) ? e[p] : oe(l.$scope, p, !0) || (t ? oe(s, p, !0) : n), 
                        ie(a, p, !0);
                    }
                    if (u) {
                        var g = (fa(a) ? a[a.length - 1] : a).prototype;
                        return m = Object.create(g || null), h && o(l, h, m, p || a.name), d(function() {
                            return i.invoke(a, m, l, p), m;
                        }, {
                            instance: m,
                            identifier: h
                        });
                    }
                    return m = i.instantiate(a, l, p), h && o(l, h, m, p || a.name), m;
                };
            } ];
        }
        function nt() {
            this.$get = [ "$window", function(e) {
                return na(e.document);
            } ];
        }
        function at() {
            this.$get = [ "$log", function(e) {
                return function(t, n) {
                    e.error.apply(e, arguments);
                };
            } ];
        }
        function rt(e, t) {
            if (y(e)) {
                var n = e.replace(rr, "").trim();
                if (n) {
                    var a = t("Content-Type");
                    (a && 0 === a.indexOf(er) || it(n)) && (e = q(n));
                }
            }
            return e;
        }
        function it(e) {
            var t = e.match(nr);
            return t && ar[t[0]].test(e);
        }
        function st(e) {
            var t, n, a, r = ue();
            return e ? (i(e.split("\n"), function(e) {
                a = e.indexOf(":"), t = Kn(pa(e.substr(0, a))), n = pa(e.substr(a + 1)), t && (r[t] = r[t] ? r[t] + ", " + n : n);
            }), r) : r;
        }
        function ot(e) {
            var t = b(e) ? e : n;
            return function(n) {
                if (t || (t = st(e)), n) {
                    var a = t[Kn(n)];
                    return void 0 === a && (a = null), a;
                }
                return t;
            };
        }
        function lt(e, t, n, a) {
            return k(a) ? a(e, t, n) : (i(a, function(a) {
                e = a(e, t, n);
            }), e);
        }
        function ut(e) {
            return 200 <= e && e < 300;
        }
        function ct() {
            var e = this.defaults = {
                transformResponse: [ rt ],
                transformRequest: [ function(e) {
                    return !b(e) || Y(e) || S(e) || T(e) ? e : W(e);
                } ],
                headers: {
                    common: {
                        Accept: "application/json, text/plain, */*"
                    },
                    post: I(tr),
                    put: I(tr),
                    patch: I(tr)
                },
                xsrfCookieName: "XSRF-TOKEN",
                xsrfHeaderName: "X-XSRF-TOKEN"
            }, t = !1;
            this.useApplyAsync = function(e) {
                return v(e) ? (t = !!e, this) : t;
            };
            var r = this.interceptors = [];
            this.$get = [ "$httpBackend", "$browser", "$cacheFactory", "$rootScope", "$q", "$injector", function(s, l, u, c, m, f) {
                function p(t) {
                    function r(e) {
                        var t = d({}, e);
                        return e.data ? t.data = lt(e.data, e.headers, e.status, l.transformResponse) : t.data = e.data, 
                        ut(e.status) ? t : m.reject(t);
                    }
                    function s(e) {
                        var t, n = {};
                        return i(e, function(e, a) {
                            k(e) ? (t = e(), null != t && (n[a] = t)) : n[a] = e;
                        }), n;
                    }
                    function o(t) {
                        var n, a, r, i = e.headers, o = d({}, t.headers);
                        i = d({}, i.common, i[Kn(t.method)]);
                        e: for (n in i) {
                            a = Kn(n);
                            for (r in o) if (Kn(r) === a) continue e;
                            o[n] = i[n];
                        }
                        return s(o);
                    }
                    if (!ca.isObject(t)) throw a("$http")("badreq", "Http request configuration must be an object.  Received: {0}", t);
                    var l = d({
                        method: "get",
                        transformRequest: e.transformRequest,
                        transformResponse: e.transformResponse
                    }, t);
                    l.headers = o(t), l.method = Zn(l.method);
                    var u = function(t) {
                        var a = t.headers, s = lt(t.data, ot(a), n, t.transformRequest);
                        return _(s) && i(a, function(e, t) {
                            "content-type" === Kn(t) && delete a[t];
                        }), _(t.withCredentials) && !_(e.withCredentials) && (t.withCredentials = e.withCredentials), 
                        M(t, s).then(r, r);
                    }, c = [ u, n ], f = m.when(l);
                    for (i(D, function(e) {
                        (e.request || e.requestError) && c.unshift(e.request, e.requestError), (e.response || e.responseError) && c.push(e.response, e.responseError);
                    }); c.length; ) {
                        var p = c.shift(), h = c.shift();
                        f = f.then(p, h);
                    }
                    return f.success = function(e) {
                        return ie(e, "fn"), f.then(function(t) {
                            e(t.data, t.status, t.headers, l);
                        }), f;
                    }, f.error = function(e) {
                        return ie(e, "fn"), f.then(null, function(t) {
                            e(t.data, t.status, t.headers, l);
                        }), f;
                    }, f;
                }
                function h(e) {
                    i(arguments, function(e) {
                        p[e] = function(t, n) {
                            return p(d(n || {}, {
                                method: e,
                                url: t
                            }));
                        };
                    });
                }
                function g(e) {
                    i(arguments, function(e) {
                        p[e] = function(t, n, a) {
                            return p(d(a || {}, {
                                method: e,
                                url: t,
                                data: n
                            }));
                        };
                    });
                }
                function M(a, r) {
                    function i(e, n, a, r) {
                        function i() {
                            o(n, e, a, r);
                        }
                        f && (ut(e) ? f.put($, [ e, n, st(a), r ]) : f.remove($)), t ? c.$applyAsync(i) : (i(), 
                        c.$$phase || c.$apply());
                    }
                    function o(e, t, n, r) {
                        t = t >= -1 ? t : 0, (ut(t) ? g.resolve : g.reject)({
                            data: e,
                            status: t,
                            headers: ot(n),
                            config: a,
                            statusText: r
                        });
                    }
                    function u(e) {
                        o(e.data, e.status, I(e.headers()), e.statusText);
                    }
                    function d() {
                        var e = p.pendingRequests.indexOf(a);
                        e !== -1 && p.pendingRequests.splice(e, 1);
                    }
                    var f, h, g = m.defer(), y = g.promise, M = a.headers, $ = w(a.url, a.params);
                    if (p.pendingRequests.push(a), y.then(d, d), !a.cache && !e.cache || a.cache === !1 || "GET" !== a.method && "JSONP" !== a.method || (f = b(a.cache) ? a.cache : b(e.cache) ? e.cache : L), 
                    f && (h = f.get($), v(h) ? C(h) ? h.then(u, u) : fa(h) ? o(h[1], h[0], I(h[2]), h[3]) : o(h, 200, {}, "OK") : f.put($, y)), 
                    _(h)) {
                        var k = sn(a.url) ? l.cookies()[a.xsrfCookieName || e.xsrfCookieName] : n;
                        k && (M[a.xsrfHeaderName || e.xsrfHeaderName] = k), s(a.method, $, r, i, M, a.timeout, a.withCredentials, a.responseType);
                    }
                    return y;
                }
                function w(e, t) {
                    if (!t) return e;
                    var n = [];
                    return o(t, function(e, t) {
                        null === e || _(e) || (fa(e) || (e = [ e ]), i(e, function(e) {
                            b(e) && (e = $(e) ? e.toISOString() : W(e)), n.push(K(t) + "=" + K(e));
                        }));
                    }), n.length > 0 && (e += (e.indexOf("?") == -1 ? "?" : "&") + n.join("&")), e;
                }
                var L = u("$http"), D = [];
                return i(r, function(e) {
                    D.unshift(y(e) ? f.get(e) : f.invoke(e));
                }), p.pendingRequests = [], h("get", "delete", "head", "jsonp"), g("post", "put", "patch"), 
                p.defaults = e, p;
            } ];
        }
        function dt() {
            return new e.XMLHttpRequest();
        }
        function mt() {
            this.$get = [ "$browser", "$window", "$document", function(e, t, n) {
                return ft(e, dt, e.defer, t.angular.callbacks, n[0]);
            } ];
        }
        function ft(e, t, a, r, s) {
            function o(e, t, n) {
                var a = s.createElement("script"), i = null;
                return a.type = "text/javascript", a.src = e, a.async = !0, i = function(e) {
                    xa(a, "load", i), xa(a, "error", i), s.body.removeChild(a), a = null;
                    var o = -1, l = "unknown";
                    e && ("load" !== e.type || r[t].called || (e = {
                        type: "error"
                    }), l = e.type, o = "error" === e.type ? 404 : 200), n && n(o, l);
                }, Sa(a, "load", i), Sa(a, "error", i), s.body.appendChild(a), i;
            }
            return function(s, l, u, c, d, m, f, h) {
                function g() {
                    y && y(), M && M.abort();
                }
                function _(t, r, i, s, o) {
                    k !== n && a.cancel(k), y = M = null, t(r, i, s, o), e.$$completeOutstandingRequest(p);
                }
                if (e.$$incOutstandingRequestCount(), l = l || e.url(), "jsonp" == Kn(s)) {
                    var b = "_" + (r.counter++).toString(36);
                    r[b] = function(e) {
                        r[b].data = e, r[b].called = !0;
                    };
                    var y = o(l.replace("JSON_CALLBACK", "angular.callbacks." + b), b, function(e, t) {
                        _(c, e, r[b].data, "", t), r[b] = p;
                    });
                } else {
                    var M = t();
                    M.open(s, l, !0), i(d, function(e, t) {
                        v(e) && M.setRequestHeader(t, e);
                    }), M.onload = function() {
                        var e = M.statusText || "", t = "response" in M ? M.response : M.responseText, n = 1223 === M.status ? 204 : M.status;
                        0 === n && (n = t ? 200 : "file" == rn(l).protocol ? 404 : 0), _(c, n, t, M.getAllResponseHeaders(), e);
                    };
                    var $ = function() {
                        _(c, -1, null, null, "");
                    };
                    if (M.onerror = $, M.onabort = $, f && (M.withCredentials = !0), h) try {
                        M.responseType = h;
                    } catch (e) {
                        if ("json" !== h) throw e;
                    }
                    M.send(u || null);
                }
                if (m > 0) var k = a(g, m); else C(m) && m.then(g);
            };
        }
        function pt() {
            var e = "{{", t = "}}";
            this.startSymbol = function(t) {
                return t ? (e = t, this) : e;
            }, this.endSymbol = function(e) {
                return e ? (t = e, this) : t;
            }, this.$get = [ "$parse", "$exceptionHandler", "$sce", function(n, a, r) {
                function i(e) {
                    return "\\\\\\" + e;
                }
                function s(i, s, m, f) {
                    function p(n) {
                        return n.replace(u, e).replace(c, t);
                    }
                    function h(e) {
                        try {
                            return e = S(e), f && !v(e) ? e : x(e);
                        } catch (e) {
                            var t = ir("interr", "Can't interpolate: {0}\n{1}", i, e.toString());
                            a(t);
                        }
                    }
                    f = !!f;
                    for (var g, b, y, M = 0, $ = [], w = [], L = i.length, D = [], Y = []; M < L; ) {
                        if ((g = i.indexOf(e, M)) == -1 || (b = i.indexOf(t, g + o)) == -1) {
                            M !== L && D.push(p(i.substring(M)));
                            break;
                        }
                        M !== g && D.push(p(i.substring(M, g))), y = i.substring(g + o, b), $.push(y), w.push(n(y, h)), 
                        M = b + l, Y.push(D.length), D.push("");
                    }
                    if (m && D.length > 1) throw ir("noconcat", "Error while interpolating: {0}\nStrict Contextual Escaping disallows interpolations that concatenate multiple expressions when a trusted value is required.  See http://docs.angularjs.org/api/ng.$sce", i);
                    if (!s || $.length) {
                        var T = function(e) {
                            for (var t = 0, n = $.length; t < n; t++) {
                                if (f && _(e[t])) return;
                                D[Y[t]] = e[t];
                            }
                            return D.join("");
                        }, S = function(e) {
                            return m ? r.getTrusted(m, e) : r.valueOf(e);
                        }, x = function(e) {
                            if (null == e) return "";
                            switch (typeof e) {
                              case "string":
                                break;

                              case "number":
                                e = "" + e;
                                break;

                              default:
                                e = W(e);
                            }
                            return e;
                        };
                        return d(function(e) {
                            var t = 0, n = $.length, r = new Array(n);
                            try {
                                for (;t < n; t++) r[t] = w[t](e);
                                return T(r);
                            } catch (e) {
                                var s = ir("interr", "Can't interpolate: {0}\n{1}", i, e.toString());
                                a(s);
                            }
                        }, {
                            exp: i,
                            expressions: $,
                            $$watchDelegate: function(e, t, n) {
                                var a;
                                return e.$watchGroup(w, function(n, r) {
                                    var i = T(n);
                                    k(t) && t.call(this, i, n !== r ? a : i, e), a = i;
                                }, n);
                            }
                        });
                    }
                }
                var o = e.length, l = t.length, u = new RegExp(e.replace(/./g, i), "g"), c = new RegExp(t.replace(/./g, i), "g");
                return s.startSymbol = function() {
                    return e;
                }, s.endSymbol = function() {
                    return t;
                }, s;
            } ];
        }
        function ht() {
            this.$get = [ "$rootScope", "$window", "$q", "$$q", function(e, t, n, a) {
                function r(r, s, o, l) {
                    var u = t.setInterval, c = t.clearInterval, d = 0, m = v(l) && !l, f = (m ? a : n).defer(), p = f.promise;
                    return o = v(o) ? o : 0, p.then(null, null, r), p.$$intervalId = u(function() {
                        f.notify(d++), o > 0 && d >= o && (f.resolve(d), c(p.$$intervalId), delete i[p.$$intervalId]), 
                        m || e.$apply();
                    }, s), i[p.$$intervalId] = f, p;
                }
                var i = {};
                return r.cancel = function(e) {
                    return !!(e && e.$$intervalId in i) && (i[e.$$intervalId].reject("canceled"), t.clearInterval(e.$$intervalId), 
                    delete i[e.$$intervalId], !0);
                }, r;
            } ];
        }
        function gt() {
            this.$get = function() {
                return {
                    id: "en-us",
                    NUMBER_FORMATS: {
                        DECIMAL_SEP: ".",
                        GROUP_SEP: ",",
                        PATTERNS: [ {
                            minInt: 1,
                            minFrac: 0,
                            maxFrac: 3,
                            posPre: "",
                            posSuf: "",
                            negPre: "-",
                            negSuf: "",
                            gSize: 3,
                            lgSize: 3
                        }, {
                            minInt: 1,
                            minFrac: 2,
                            maxFrac: 2,
                            posPre: "¤",
                            posSuf: "",
                            negPre: "(¤",
                            negSuf: ")",
                            gSize: 3,
                            lgSize: 3
                        } ],
                        CURRENCY_SYM: "$"
                    },
                    DATETIME_FORMATS: {
                        MONTH: "January,February,March,April,May,June,July,August,September,October,November,December".split(","),
                        SHORTMONTH: "Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec".split(","),
                        DAY: "Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday".split(","),
                        SHORTDAY: "Sun,Mon,Tue,Wed,Thu,Fri,Sat".split(","),
                        AMPMS: [ "AM", "PM" ],
                        medium: "MMM d, y h:mm:ss a",
                        short: "M/d/yy h:mm a",
                        fullDate: "EEEE, MMMM d, y",
                        longDate: "MMMM d, y",
                        mediumDate: "MMM d, y",
                        shortDate: "M/d/yy",
                        mediumTime: "h:mm:ss a",
                        shortTime: "h:mm a",
                        ERANAMES: [ "Before Christ", "Anno Domini" ],
                        ERAS: [ "BC", "AD" ]
                    },
                    pluralCat: function(e) {
                        return 1 === e ? "one" : "other";
                    }
                };
            };
        }
        function _t(e) {
            for (var t = e.split("/"), n = t.length; n--; ) t[n] = J(t[n]);
            return t.join("/");
        }
        function vt(e, t) {
            var n = rn(e);
            t.$$protocol = n.protocol, t.$$host = n.hostname, t.$$port = m(n.port) || or[n.protocol] || null;
        }
        function bt(e, t) {
            var n = "/" !== e.charAt(0);
            n && (e = "/" + e);
            var a = rn(e);
            t.$$path = decodeURIComponent(n && "/" === a.pathname.charAt(0) ? a.pathname.substring(1) : a.pathname), 
            t.$$search = B(a.search), t.$$hash = decodeURIComponent(a.hash), t.$$path && "/" != t.$$path.charAt(0) && (t.$$path = "/" + t.$$path);
        }
        function yt(e, t) {
            if (0 === t.indexOf(e)) return t.substr(e.length);
        }
        function Mt(e) {
            var t = e.indexOf("#");
            return t == -1 ? e : e.substr(0, t);
        }
        function $t(e) {
            return e.replace(/(#.+)|#$/, "$1");
        }
        function kt(e) {
            return e.substr(0, Mt(e).lastIndexOf("/") + 1);
        }
        function wt(e) {
            return e.substring(0, e.indexOf("/", e.indexOf("//") + 2));
        }
        function Lt(e, t, a) {
            this.$$html5 = !0, a = a || "", vt(e, this), this.$$parse = function(e) {
                var n = yt(t, e);
                if (!y(n)) throw lr("ipthprfx", 'Invalid url "{0}", missing path prefix "{1}".', e, t);
                bt(n, this), this.$$path || (this.$$path = "/"), this.$$compose();
            }, this.$$compose = function() {
                var e = G(this.$$search), n = this.$$hash ? "#" + J(this.$$hash) : "";
                this.$$url = _t(this.$$path) + (e ? "?" + e : "") + n, this.$$absUrl = t + this.$$url.substr(1);
            }, this.$$parseLinkUrl = function(r, i) {
                if (i && "#" === i[0]) return this.hash(i.slice(1)), !0;
                var s, o, l;
                return (s = yt(e, r)) !== n ? (o = s, l = (s = yt(a, s)) !== n ? t + (yt("/", s) || s) : e + o) : (s = yt(t, r)) !== n ? l = t + s : t == r + "/" && (l = t), 
                l && this.$$parse(l), !!l;
            };
        }
        function Dt(e, t, n) {
            vt(e, this), this.$$parse = function(a) {
                function r(e, t, n) {
                    var a, r = /^\/[A-Z]:(\/.*)/;
                    return 0 === t.indexOf(n) && (t = t.replace(n, "")), r.exec(t) ? e : (a = r.exec(e), 
                    a ? a[1] : e);
                }
                var i, s = yt(e, a) || yt(t, a);
                _(s) || "#" !== s.charAt(0) ? this.$$html5 ? i = s : (i = "", _(s) && (e = a, this.replace())) : (i = yt(n, s), 
                _(i) && (i = s)), bt(i, this), this.$$path = r(this.$$path, i, e), this.$$compose();
            }, this.$$compose = function() {
                var t = G(this.$$search), a = this.$$hash ? "#" + J(this.$$hash) : "";
                this.$$url = _t(this.$$path) + (t ? "?" + t : "") + a, this.$$absUrl = e + (this.$$url ? n + this.$$url : "");
            }, this.$$parseLinkUrl = function(t, n) {
                return Mt(e) == Mt(t) && (this.$$parse(t), !0);
            };
        }
        function Yt(e, t, n) {
            this.$$html5 = !0, Dt.apply(this, arguments), this.$$parseLinkUrl = function(a, r) {
                if (r && "#" === r[0]) return this.hash(r.slice(1)), !0;
                var i, s;
                return e == Mt(a) ? i = a : (s = yt(t, a)) ? i = e + n + s : t === a + "/" && (i = t), 
                i && this.$$parse(i), !!i;
            }, this.$$compose = function() {
                var t = G(this.$$search), a = this.$$hash ? "#" + J(this.$$hash) : "";
                this.$$url = _t(this.$$path) + (t ? "?" + t : "") + a, this.$$absUrl = e + n + this.$$url;
            };
        }
        function Tt(e) {
            return function() {
                return this[e];
            };
        }
        function St(e, t) {
            return function(n) {
                return _(n) ? this[e] : (this[e] = t(n), this.$$compose(), this);
            };
        }
        function xt() {
            var e = "", t = {
                enabled: !1,
                requireBase: !0,
                rewriteLinks: !0
            };
            this.hashPrefix = function(t) {
                return v(t) ? (e = t, this) : e;
            }, this.html5Mode = function(e) {
                return x(e) ? (t.enabled = e, this) : b(e) ? (x(e.enabled) && (t.enabled = e.enabled), 
                x(e.requireBase) && (t.requireBase = e.requireBase), x(e.rewriteLinks) && (t.rewriteLinks = e.rewriteLinks), 
                this) : t;
            }, this.$get = [ "$rootScope", "$browser", "$sniffer", "$rootElement", "$window", function(n, a, r, i, s) {
                function o(e, t, n) {
                    var r = u.url(), i = u.$$state;
                    try {
                        a.url(e, t, n), u.$$state = a.state();
                    } catch (e) {
                        throw u.url(r), u.$$state = i, e;
                    }
                }
                function l(e, t) {
                    n.$broadcast("$locationChangeSuccess", u.absUrl(), e, u.$$state, t);
                }
                var u, c, d, m = a.baseHref(), f = a.url();
                if (t.enabled) {
                    if (!m && t.requireBase) throw lr("nobase", "$location in HTML5 mode requires a <base> tag to be present!");
                    d = wt(f) + (m || "/"), c = r.history ? Lt : Yt;
                } else d = Mt(f), c = Dt;
                var p = kt(d);
                u = new c(d, p, "#" + e), u.$$parseLinkUrl(f, f), u.$$state = a.state();
                var h = /^\s*(javascript|mailto):/i;
                i.on("click", function(e) {
                    if (t.rewriteLinks && !e.ctrlKey && !e.metaKey && !e.shiftKey && 2 != e.which && 2 != e.button) {
                        for (var r = na(e.target); "a" !== A(r[0]); ) if (r[0] === i[0] || !(r = r.parent())[0]) return;
                        var o = r.prop("href"), l = r.attr("href") || r.attr("xlink:href");
                        b(o) && "[object SVGAnimatedString]" === o.toString() && (o = rn(o.animVal).href), 
                        h.test(o) || !o || r.attr("target") || e.isDefaultPrevented() || u.$$parseLinkUrl(o, l) && (e.preventDefault(), 
                        u.absUrl() != a.url() && (n.$apply(), s.angular["ff-684208-preventDefault"] = !0));
                    }
                }), $t(u.absUrl()) != $t(f) && a.url(u.absUrl(), !0);
                var g = !0;
                return a.onUrlChange(function(e, t) {
                    return _(yt(p, e)) ? void (s.location.href = e) : (n.$evalAsync(function() {
                        var a, r = u.absUrl(), i = u.$$state;
                        u.$$parse(e), u.$$state = t, a = n.$broadcast("$locationChangeStart", e, r, t, i).defaultPrevented, 
                        u.absUrl() === e && (a ? (u.$$parse(r), u.$$state = i, o(r, !1, i)) : (g = !1, l(r, i)));
                    }), void (n.$$phase || n.$digest()));
                }), n.$watch(function() {
                    var e = $t(a.url()), t = $t(u.absUrl()), i = a.state(), s = u.$$replace, c = e !== t || u.$$html5 && r.history && i !== u.$$state;
                    (g || c) && (g = !1, n.$evalAsync(function() {
                        var t = u.absUrl(), a = n.$broadcast("$locationChangeStart", t, e, u.$$state, i).defaultPrevented;
                        u.absUrl() === t && (a ? (u.$$parse(e), u.$$state = i) : (c && o(t, s, i === u.$$state ? null : u.$$state), 
                        l(e, i)));
                    })), u.$$replace = !1;
                }), u;
            } ];
        }
        function Ct() {
            var e = !0, t = this;
            this.debugEnabled = function(t) {
                return v(t) ? (e = t, this) : e;
            }, this.$get = [ "$window", function(n) {
                function a(e) {
                    return e instanceof Error && (e.stack ? e = e.message && e.stack.indexOf(e.message) === -1 ? "Error: " + e.message + "\n" + e.stack : e.stack : e.sourceURL && (e = e.message + "\n" + e.sourceURL + ":" + e.line)), 
                    e;
                }
                function r(e) {
                    var t = n.console || {}, r = t[e] || t.log || p, s = !1;
                    try {
                        s = !!r.apply;
                    } catch (e) {}
                    return s ? function() {
                        var e = [];
                        return i(arguments, function(t) {
                            e.push(a(t));
                        }), r.apply(t, e);
                    } : function(e, t) {
                        r(e, null == t ? "" : t);
                    };
                }
                return {
                    log: r("log"),
                    info: r("info"),
                    warn: r("warn"),
                    error: r("error"),
                    debug: function() {
                        var n = r("debug");
                        return function() {
                            e && n.apply(t, arguments);
                        };
                    }()
                };
            } ];
        }
        function Et(e, t) {
            if ("__defineGetter__" === e || "__defineSetter__" === e || "__lookupGetter__" === e || "__lookupSetter__" === e || "__proto__" === e) throw cr("isecfld", "Attempting to access a disallowed field in Angular expressions! Expression: {0}", t);
            return e;
        }
        function Ht(e, t) {
            if (e += "", !y(e)) throw cr("iseccst", "Cannot convert object to primitive value! Expression: {0}", t);
            return e;
        }
        function At(e, t) {
            if (e) {
                if (e.constructor === e) throw cr("isecfn", "Referencing Function in Angular expressions is disallowed! Expression: {0}", t);
                if (e.window === e) throw cr("isecwindow", "Referencing the Window in Angular expressions is disallowed! Expression: {0}", t);
                if (e.children && (e.nodeName || e.prop && e.attr && e.find)) throw cr("isecdom", "Referencing DOM nodes in Angular expressions is disallowed! Expression: {0}", t);
                if (e === Object) throw cr("isecobj", "Referencing Object in Angular expressions is disallowed! Expression: {0}", t);
            }
            return e;
        }
        function jt(e, t) {
            if (e) {
                if (e.constructor === e) throw cr("isecfn", "Referencing Function in Angular expressions is disallowed! Expression: {0}", t);
                if (e === dr || e === mr || e === fr) throw cr("isecff", "Referencing call, apply or bind in Angular expressions is disallowed! Expression: {0}", t);
            }
        }
        function Ot(e) {
            return e.constant;
        }
        function It(e, t, n, a, r) {
            At(e, r), At(t, r);
            for (var i, s = n.split("."), o = 0; s.length > 1; o++) {
                i = Et(s.shift(), r);
                var l = 0 === o && t && t[i] || e[i];
                l || (l = {}, e[i] = l), e = At(l, r);
            }
            return i = Et(s.shift(), r), At(e[i], r), e[i] = a, a;
        }
        function Pt(e) {
            return "constructor" == e;
        }
        function Ft(e, t, a, r, i, s, o) {
            Et(e, s), Et(t, s), Et(a, s), Et(r, s), Et(i, s);
            var l = function(e) {
                return At(e, s);
            }, u = o || Pt(e) ? l : h, c = o || Pt(t) ? l : h, d = o || Pt(a) ? l : h, m = o || Pt(r) ? l : h, f = o || Pt(i) ? l : h;
            return function(s, o) {
                var l = o && o.hasOwnProperty(e) ? o : s;
                return null == l ? l : (l = u(l[e]), t ? null == l ? n : (l = c(l[t]), a ? null == l ? n : (l = d(l[a]), 
                r ? null == l ? n : (l = m(l[r]), i ? null == l ? n : l = f(l[i]) : l) : l) : l) : l);
            };
        }
        function Ut(e, t) {
            return function(n, a) {
                return e(n, a, At, t);
            };
        }
        function Nt(e, t, a) {
            var r = t.expensiveChecks, s = r ? yr : br, o = s[e];
            if (o) return o;
            var l = e.split("."), u = l.length;
            if (t.csp) o = u < 6 ? Ft(l[0], l[1], l[2], l[3], l[4], a, r) : function(e, t) {
                var i, s = 0;
                do i = Ft(l[s++], l[s++], l[s++], l[s++], l[s++], a, r)(e, t), t = n, e = i; while (s < u);
                return i;
            }; else {
                var c = "";
                r && (c += "s = eso(s, fe);\nl = eso(l, fe);\n");
                var d = r;
                i(l, function(e, t) {
                    Et(e, a);
                    var n = (t ? "s" : '((l&&l.hasOwnProperty("' + e + '"))?l:s)') + "." + e;
                    (r || Pt(e)) && (n = "eso(" + n + ", fe)", d = !0), c += "if(s == null) return undefined;\ns=" + n + ";\n";
                }), c += "return s;";
                var m = new Function("s", "l", "eso", "fe", c);
                m.toString = g(c), d && (m = Ut(m, a)), o = m;
            }
            return o.sharedGetter = !0, o.assign = function(t, n, a) {
                return It(t, a, e, n, e);
            }, s[e] = o, o;
        }
        function Vt(e) {
            return k(e.valueOf) ? e.valueOf() : Mr.call(e);
        }
        function Wt() {
            var e = ue(), t = ue();
            this.$get = [ "$filter", "$sniffer", function(n, a) {
                function r(e) {
                    var t = e;
                    return e.sharedGetter && (t = function(t, n) {
                        return e(t, n);
                    }, t.literal = e.literal, t.constant = e.constant, t.assign = e.assign), t;
                }
                function s(e, t) {
                    for (var n = 0, a = e.length; n < a; n++) {
                        var r = e[n];
                        r.constant || (r.inputs ? s(r.inputs, t) : t.indexOf(r) === -1 && t.push(r));
                    }
                    return t;
                }
                function o(e, t) {
                    return null == e || null == t ? e === t : ("object" != typeof e || (e = Vt(e), "object" != typeof e)) && (e === t || e !== e && t !== t);
                }
                function l(e, t, n, a) {
                    var r, i = a.$$inputs || (a.$$inputs = s(a.inputs, []));
                    if (1 === i.length) {
                        var l = o;
                        return i = i[0], e.$watch(function(e) {
                            var t = i(e);
                            return o(t, l) || (r = a(e), l = t && Vt(t)), r;
                        }, t, n);
                    }
                    for (var u = [], c = 0, d = i.length; c < d; c++) u[c] = o;
                    return e.$watch(function(e) {
                        for (var t = !1, n = 0, s = i.length; n < s; n++) {
                            var l = i[n](e);
                            (t || (t = !o(l, u[n]))) && (u[n] = l && Vt(l));
                        }
                        return t && (r = a(e)), r;
                    }, t, n);
                }
                function u(e, t, n, a) {
                    var r, i;
                    return r = e.$watch(function(e) {
                        return a(e);
                    }, function(e, n, a) {
                        i = e, k(t) && t.apply(this, arguments), v(e) && a.$$postDigest(function() {
                            v(i) && r();
                        });
                    }, n);
                }
                function c(e, t, n, a) {
                    function r(e) {
                        var t = !0;
                        return i(e, function(e) {
                            v(e) || (t = !1);
                        }), t;
                    }
                    var s, o;
                    return s = e.$watch(function(e) {
                        return a(e);
                    }, function(e, n, a) {
                        o = e, k(t) && t.call(this, e, n, a), r(e) && a.$$postDigest(function() {
                            r(o) && s();
                        });
                    }, n);
                }
                function d(e, t, n, a) {
                    var r;
                    return r = e.$watch(function(e) {
                        return a(e);
                    }, function(e, n, a) {
                        k(t) && t.apply(this, arguments), r();
                    }, n);
                }
                function m(e, t) {
                    if (!t) return e;
                    var n = e.$$watchDelegate, a = n !== c && n !== u, r = a ? function(n, a) {
                        var r = e(n, a);
                        return t(r, n, a);
                    } : function(n, a) {
                        var r = e(n, a), i = t(r, n, a);
                        return v(r) ? i : r;
                    };
                    return e.$$watchDelegate && e.$$watchDelegate !== l ? r.$$watchDelegate = e.$$watchDelegate : t.$stateful || (r.$$watchDelegate = l, 
                    r.inputs = [ e ]), r;
                }
                var f = {
                    csp: a.csp,
                    expensiveChecks: !1
                }, h = {
                    csp: a.csp,
                    expensiveChecks: !0
                };
                return function(a, i, s) {
                    var o, g, _;
                    switch (typeof a) {
                      case "string":
                        _ = a = a.trim();
                        var v = s ? t : e;
                        if (o = v[_], !o) {
                            ":" === a.charAt(0) && ":" === a.charAt(1) && (g = !0, a = a.substring(2));
                            var b = s ? h : f, y = new _r(b), M = new vr(y, n, b);
                            o = M.parse(a), o.constant ? o.$$watchDelegate = d : g ? (o = r(o), o.$$watchDelegate = o.literal ? c : u) : o.inputs && (o.$$watchDelegate = l), 
                            v[_] = o;
                        }
                        return m(o, i);

                      case "function":
                        return m(a, i);

                      default:
                        return m(p, i);
                    }
                };
            } ];
        }
        function qt() {
            this.$get = [ "$rootScope", "$exceptionHandler", function(e, t) {
                return zt(function(t) {
                    e.$evalAsync(t);
                }, t);
            } ];
        }
        function Rt() {
            this.$get = [ "$browser", "$exceptionHandler", function(e, t) {
                return zt(function(t) {
                    e.defer(t);
                }, t);
            } ];
        }
        function zt(e, t) {
            function r(e, t, n) {
                function a(t) {
                    return function(n) {
                        r || (r = !0, t.call(e, n));
                    };
                }
                var r = !1;
                return [ a(t), a(n) ];
            }
            function s() {
                this.$$state = {
                    status: 0
                };
            }
            function o(e, t) {
                return function(n) {
                    t.call(e, n);
                };
            }
            function l(e) {
                var a, r, i;
                i = e.pending, e.processScheduled = !1, e.pending = n;
                for (var s = 0, o = i.length; s < o; ++s) {
                    r = i[s][0], a = i[s][e.status];
                    try {
                        k(a) ? r.resolve(a(e.value)) : 1 === e.status ? r.resolve(e.value) : r.reject(e.value);
                    } catch (e) {
                        r.reject(e), t(e);
                    }
                }
            }
            function u(t) {
                !t.processScheduled && t.pending && (t.processScheduled = !0, e(function() {
                    l(t);
                }));
            }
            function c() {
                this.promise = new s(), this.resolve = o(this, this.resolve), this.reject = o(this, this.reject), 
                this.notify = o(this, this.notify);
            }
            function d(e) {
                var t = new c(), n = 0, a = fa(e) ? [] : {};
                return i(e, function(e, r) {
                    n++, _(e).then(function(e) {
                        a.hasOwnProperty(r) || (a[r] = e, --n || t.resolve(a));
                    }, function(e) {
                        a.hasOwnProperty(r) || t.reject(e);
                    });
                }), 0 === n && t.resolve(a), t.promise;
            }
            var m = a("$q", TypeError), f = function() {
                return new c();
            };
            s.prototype = {
                then: function(e, t, n) {
                    var a = new c();
                    return this.$$state.pending = this.$$state.pending || [], this.$$state.pending.push([ a, e, t, n ]), 
                    this.$$state.status > 0 && u(this.$$state), a.promise;
                },
                catch: function(e) {
                    return this.then(null, e);
                },
                finally: function(e, t) {
                    return this.then(function(t) {
                        return g(t, !0, e);
                    }, function(t) {
                        return g(t, !1, e);
                    }, t);
                }
            }, c.prototype = {
                resolve: function(e) {
                    this.promise.$$state.status || (e === this.promise ? this.$$reject(m("qcycle", "Expected promise to be resolved with value other than itself '{0}'", e)) : this.$$resolve(e));
                },
                $$resolve: function(e) {
                    var n, a;
                    a = r(this, this.$$resolve, this.$$reject);
                    try {
                        (b(e) || k(e)) && (n = e && e.then), k(n) ? (this.promise.$$state.status = -1, n.call(e, a[0], a[1], this.notify)) : (this.promise.$$state.value = e, 
                        this.promise.$$state.status = 1, u(this.promise.$$state));
                    } catch (e) {
                        a[1](e), t(e);
                    }
                },
                reject: function(e) {
                    this.promise.$$state.status || this.$$reject(e);
                },
                $$reject: function(e) {
                    this.promise.$$state.value = e, this.promise.$$state.status = 2, u(this.promise.$$state);
                },
                notify: function(n) {
                    var a = this.promise.$$state.pending;
                    this.promise.$$state.status <= 0 && a && a.length && e(function() {
                        for (var e, r, i = 0, s = a.length; i < s; i++) {
                            r = a[i][0], e = a[i][3];
                            try {
                                r.notify(k(e) ? e(n) : n);
                            } catch (e) {
                                t(e);
                            }
                        }
                    });
                }
            };
            var p = function(e) {
                var t = new c();
                return t.reject(e), t.promise;
            }, h = function(e, t) {
                var n = new c();
                return t ? n.resolve(e) : n.reject(e), n.promise;
            }, g = function(e, t, n) {
                var a = null;
                try {
                    k(n) && (a = n());
                } catch (e) {
                    return h(e, !1);
                }
                return C(a) ? a.then(function() {
                    return h(e, t);
                }, function(e) {
                    return h(e, !1);
                }) : h(e, t);
            }, _ = function(e, t, n, a) {
                var r = new c();
                return r.resolve(e), r.promise.then(t, n, a);
            }, v = function e(t) {
                function n(e) {
                    r.resolve(e);
                }
                function a(e) {
                    r.reject(e);
                }
                if (!k(t)) throw m("norslvr", "Expected resolverFn, got '{0}'", t);
                if (!(this instanceof e)) return new e(t);
                var r = new c();
                return t(n, a), r.promise;
            };
            return v.defer = f, v.reject = p, v.when = _, v.all = d, v;
        }
        function Bt() {
            this.$get = [ "$window", "$timeout", function(e, t) {
                function n() {
                    for (var e = 0; e < c.length; e++) {
                        var t = c[e];
                        t && (c[e] = null, t());
                    }
                    u = c.length = 0;
                }
                function a(e) {
                    var t = c.length;
                    return u++, c.push(e), 0 === t && (l = o(n)), function() {
                        t >= 0 && (c[t] = null, t = null, 0 === --u && l && (l(), l = null, c.length = 0));
                    };
                }
                var r = e.requestAnimationFrame || e.webkitRequestAnimationFrame, i = e.cancelAnimationFrame || e.webkitCancelAnimationFrame || e.webkitCancelRequestAnimationFrame, s = !!r, o = s ? function(e) {
                    var t = r(e);
                    return function() {
                        i(t);
                    };
                } : function(e) {
                    var n = t(e, 16.66, !1);
                    return function() {
                        t.cancel(n);
                    };
                };
                a.supported = s;
                var l, u = 0, c = [];
                return a;
            } ];
        }
        function Gt() {
            function e(e) {
                function t() {
                    this.$$watchers = this.$$nextSibling = this.$$childHead = this.$$childTail = null, 
                    this.$$listeners = {}, this.$$listenerCount = {}, this.$id = u(), this.$$ChildScope = null;
                }
                return t.prototype = e, t;
            }
            var t = 10, n = a("$rootScope"), s = null, o = null;
            this.digestTtl = function(e) {
                return arguments.length && (t = e), t;
            }, this.$get = [ "$injector", "$exceptionHandler", "$parse", "$browser", function(a, l, c, d) {
                function m(e) {
                    e.currentScope.$$destroyed = !0;
                }
                function f() {
                    this.$id = u(), this.$$phase = this.$parent = this.$$watchers = this.$$nextSibling = this.$$prevSibling = this.$$childHead = this.$$childTail = null, 
                    this.$root = this, this.$$destroyed = !1, this.$$listeners = {}, this.$$listenerCount = {}, 
                    this.$$isolateBindings = null;
                }
                function h(e) {
                    if (w.$$phase) throw n("inprog", "{0} already in progress", w.$$phase);
                    w.$$phase = e;
                }
                function g() {
                    w.$$phase = null;
                }
                function v(e, t, n) {
                    do e.$$listenerCount[n] -= t, 0 === e.$$listenerCount[n] && delete e.$$listenerCount[n]; while (e = e.$parent);
                }
                function y() {}
                function M() {
                    for (;Y.length; ) try {
                        Y.shift()();
                    } catch (e) {
                        l(e);
                    }
                    o = null;
                }
                function $() {
                    null === o && (o = d.defer(function() {
                        w.$apply(M);
                    }));
                }
                f.prototype = {
                    constructor: f,
                    $new: function(t, n) {
                        var a;
                        return n = n || this, t ? (a = new f(), a.$root = this.$root) : (this.$$ChildScope || (this.$$ChildScope = e(this)), 
                        a = new this.$$ChildScope()), a.$parent = n, a.$$prevSibling = n.$$childTail, n.$$childHead ? (n.$$childTail.$$nextSibling = a, 
                        n.$$childTail = a) : n.$$childHead = n.$$childTail = a, (t || n != this) && a.$on("$destroy", m), 
                        a;
                    },
                    $watch: function(e, t, n) {
                        var a = c(e);
                        if (a.$$watchDelegate) return a.$$watchDelegate(this, t, n, a);
                        var r = this, i = r.$$watchers, o = {
                            fn: t,
                            last: y,
                            get: a,
                            exp: e,
                            eq: !!n
                        };
                        return s = null, k(t) || (o.fn = p), i || (i = r.$$watchers = []), i.unshift(o), 
                        function() {
                            j(i, o), s = null;
                        };
                    },
                    $watchGroup: function(e, t) {
                        function n() {
                            l = !1, u ? (u = !1, t(r, r, o)) : t(r, a, o);
                        }
                        var a = new Array(e.length), r = new Array(e.length), s = [], o = this, l = !1, u = !0;
                        if (!e.length) {
                            var c = !0;
                            return o.$evalAsync(function() {
                                c && t(r, r, o);
                            }), function() {
                                c = !1;
                            };
                        }
                        return 1 === e.length ? this.$watch(e[0], function(e, n, i) {
                            r[0] = e, a[0] = n, t(r, e === n ? r : a, i);
                        }) : (i(e, function(e, t) {
                            var i = o.$watch(e, function(e, i) {
                                r[t] = e, a[t] = i, l || (l = !0, o.$evalAsync(n));
                            });
                            s.push(i);
                        }), function() {
                            for (;s.length; ) s.shift()();
                        });
                    },
                    $watchCollection: function(e, t) {
                        function n(e) {
                            i = e;
                            var t, n, a, o, l;
                            if (!_(i)) {
                                if (b(i)) if (r(i)) {
                                    s !== f && (s = f, g = s.length = 0, d++), t = i.length, g !== t && (d++, s.length = g = t);
                                    for (var u = 0; u < t; u++) l = s[u], o = i[u], a = l !== l && o !== o, a || l === o || (d++, 
                                    s[u] = o);
                                } else {
                                    s !== p && (s = p = {}, g = 0, d++), t = 0;
                                    for (n in i) i.hasOwnProperty(n) && (t++, o = i[n], l = s[n], n in s ? (a = l !== l && o !== o, 
                                    a || l === o || (d++, s[n] = o)) : (g++, s[n] = o, d++));
                                    if (g > t) {
                                        d++;
                                        for (n in s) i.hasOwnProperty(n) || (g--, delete s[n]);
                                    }
                                } else s !== i && (s = i, d++);
                                return d;
                            }
                        }
                        function a() {
                            if (h ? (h = !1, t(i, i, l)) : t(i, o, l), u) if (b(i)) if (r(i)) {
                                o = new Array(i.length);
                                for (var e = 0; e < i.length; e++) o[e] = i[e];
                            } else {
                                o = {};
                                for (var n in i) Qn.call(i, n) && (o[n] = i[n]);
                            } else o = i;
                        }
                        n.$stateful = !0;
                        var i, s, o, l = this, u = t.length > 1, d = 0, m = c(e, n), f = [], p = {}, h = !0, g = 0;
                        return this.$watch(m, a);
                    },
                    $digest: function() {
                        var e, a, r, i, u, c, m, f, p, _, v = t, b = this, $ = [];
                        h("$digest"), d.$$checkUrlChange(), this === w && null !== o && (d.defer.cancel(o), 
                        M()), s = null;
                        do {
                            for (c = !1, f = b; L.length; ) {
                                try {
                                    _ = L.shift(), _.scope.$eval(_.expression, _.locals);
                                } catch (e) {
                                    l(e);
                                }
                                s = null;
                            }
                            e: do {
                                if (i = f.$$watchers) for (u = i.length; u--; ) try {
                                    if (e = i[u]) if ((a = e.get(f)) === (r = e.last) || (e.eq ? P(a, r) : "number" == typeof a && "number" == typeof r && isNaN(a) && isNaN(r))) {
                                        if (e === s) {
                                            c = !1;
                                            break e;
                                        }
                                    } else c = !0, s = e, e.last = e.eq ? O(a, null) : a, e.fn(a, r === y ? a : r, f), 
                                    v < 5 && (p = 4 - v, $[p] || ($[p] = []), $[p].push({
                                        msg: k(e.exp) ? "fn: " + (e.exp.name || e.exp.toString()) : e.exp,
                                        newVal: a,
                                        oldVal: r
                                    }));
                                } catch (e) {
                                    l(e);
                                }
                                if (!(m = f.$$childHead || f !== b && f.$$nextSibling)) for (;f !== b && !(m = f.$$nextSibling); ) f = f.$parent;
                            } while (f = m);
                            if ((c || L.length) && !v--) throw g(), n("infdig", "{0} $digest() iterations reached. Aborting!\nWatchers fired in the last 5 iterations: {1}", t, $);
                        } while (c || L.length);
                        for (g(); D.length; ) try {
                            D.shift()();
                        } catch (e) {
                            l(e);
                        }
                    },
                    $destroy: function() {
                        if (!this.$$destroyed) {
                            var e = this.$parent;
                            if (this.$broadcast("$destroy"), this.$$destroyed = !0, this !== w) {
                                for (var t in this.$$listenerCount) v(this, this.$$listenerCount[t], t);
                                e.$$childHead == this && (e.$$childHead = this.$$nextSibling), e.$$childTail == this && (e.$$childTail = this.$$prevSibling), 
                                this.$$prevSibling && (this.$$prevSibling.$$nextSibling = this.$$nextSibling), this.$$nextSibling && (this.$$nextSibling.$$prevSibling = this.$$prevSibling), 
                                this.$destroy = this.$digest = this.$apply = this.$evalAsync = this.$applyAsync = p, 
                                this.$on = this.$watch = this.$watchGroup = function() {
                                    return p;
                                }, this.$$listeners = {}, this.$parent = this.$$nextSibling = this.$$prevSibling = this.$$childHead = this.$$childTail = this.$root = this.$$watchers = null;
                            }
                        }
                    },
                    $eval: function(e, t) {
                        return c(e)(this, t);
                    },
                    $evalAsync: function(e, t) {
                        w.$$phase || L.length || d.defer(function() {
                            L.length && w.$digest();
                        }), L.push({
                            scope: this,
                            expression: e,
                            locals: t
                        });
                    },
                    $$postDigest: function(e) {
                        D.push(e);
                    },
                    $apply: function(e) {
                        try {
                            return h("$apply"), this.$eval(e);
                        } catch (e) {
                            l(e);
                        } finally {
                            g();
                            try {
                                w.$digest();
                            } catch (e) {
                                throw l(e), e;
                            }
                        }
                    },
                    $applyAsync: function(e) {
                        function t() {
                            n.$eval(e);
                        }
                        var n = this;
                        e && Y.push(t), $();
                    },
                    $on: function(e, t) {
                        var n = this.$$listeners[e];
                        n || (this.$$listeners[e] = n = []), n.push(t);
                        var a = this;
                        do a.$$listenerCount[e] || (a.$$listenerCount[e] = 0), a.$$listenerCount[e]++; while (a = a.$parent);
                        var r = this;
                        return function() {
                            var a = n.indexOf(t);
                            a !== -1 && (n[a] = null, v(r, 1, e));
                        };
                    },
                    $emit: function(e, t) {
                        var n, a, r, i = [], s = this, o = !1, u = {
                            name: e,
                            targetScope: s,
                            stopPropagation: function() {
                                o = !0;
                            },
                            preventDefault: function() {
                                u.defaultPrevented = !0;
                            },
                            defaultPrevented: !1
                        }, c = F([ u ], arguments, 1);
                        do {
                            for (n = s.$$listeners[e] || i, u.currentScope = s, a = 0, r = n.length; a < r; a++) if (n[a]) try {
                                n[a].apply(null, c);
                            } catch (e) {
                                l(e);
                            } else n.splice(a, 1), a--, r--;
                            if (o) return u.currentScope = null, u;
                            s = s.$parent;
                        } while (s);
                        return u.currentScope = null, u;
                    },
                    $broadcast: function(e, t) {
                        var n = this, a = n, r = n, i = {
                            name: e,
                            targetScope: n,
                            preventDefault: function() {
                                i.defaultPrevented = !0;
                            },
                            defaultPrevented: !1
                        };
                        if (!n.$$listenerCount[e]) return i;
                        for (var s, o, u, c = F([ i ], arguments, 1); a = r; ) {
                            for (i.currentScope = a, s = a.$$listeners[e] || [], o = 0, u = s.length; o < u; o++) if (s[o]) try {
                                s[o].apply(null, c);
                            } catch (e) {
                                l(e);
                            } else s.splice(o, 1), o--, u--;
                            if (!(r = a.$$listenerCount[e] && a.$$childHead || a !== n && a.$$nextSibling)) for (;a !== n && !(r = a.$$nextSibling); ) a = a.$parent;
                        }
                        return i.currentScope = null, i;
                    }
                };
                var w = new f(), L = w.$$asyncQueue = [], D = w.$$postDigestQueue = [], Y = w.$$applyAsyncQueue = [];
                return w;
            } ];
        }
        function Jt() {
            var e = /^\s*(https?|ftp|mailto|tel|file):/, t = /^\s*((https?|ftp|file|blob):|data:image\/)/;
            this.aHrefSanitizationWhitelist = function(t) {
                return v(t) ? (e = t, this) : e;
            }, this.imgSrcSanitizationWhitelist = function(e) {
                return v(e) ? (t = e, this) : t;
            }, this.$get = function() {
                return function(n, a) {
                    var r, i = a ? t : e;
                    return r = rn(n).href, "" === r || r.match(i) ? n : "unsafe:" + r;
                };
            };
        }
        function Kt(e) {
            if ("self" === e) return e;
            if (y(e)) {
                if (e.indexOf("***") > -1) throw $r("iwcard", "Illegal sequence *** in string matcher.  String: {0}", e);
                return e = ha(e).replace("\\*\\*", ".*").replace("\\*", "[^:/.?&;]*"), new RegExp("^" + e + "$");
            }
            if (w(e)) return new RegExp("^" + e.source + "$");
            throw $r("imatcher", 'Matchers may only be "self", string patterns or RegExp objects');
        }
        function Qt(e) {
            var t = [];
            return v(e) && i(e, function(e) {
                t.push(Kt(e));
            }), t;
        }
        function Zt() {
            this.SCE_CONTEXTS = kr;
            var e = [ "self" ], t = [];
            this.resourceUrlWhitelist = function(t) {
                return arguments.length && (e = Qt(t)), e;
            }, this.resourceUrlBlacklist = function(e) {
                return arguments.length && (t = Qt(e)), t;
            }, this.$get = [ "$injector", function(a) {
                function r(e, t) {
                    return "self" === e ? sn(t) : !!e.exec(t.href);
                }
                function i(n) {
                    var a, i, s = rn(n.toString()), o = !1;
                    for (a = 0, i = e.length; a < i; a++) if (r(e[a], s)) {
                        o = !0;
                        break;
                    }
                    if (o) for (a = 0, i = t.length; a < i; a++) if (r(t[a], s)) {
                        o = !1;
                        break;
                    }
                    return o;
                }
                function s(e) {
                    var t = function(e) {
                        this.$$unwrapTrustedValue = function() {
                            return e;
                        };
                    };
                    return e && (t.prototype = new e()), t.prototype.valueOf = function() {
                        return this.$$unwrapTrustedValue();
                    }, t.prototype.toString = function() {
                        return this.$$unwrapTrustedValue().toString();
                    }, t;
                }
                function o(e, t) {
                    var a = m.hasOwnProperty(e) ? m[e] : null;
                    if (!a) throw $r("icontext", "Attempted to trust a value in invalid context. Context: {0}; Value: {1}", e, t);
                    if (null === t || t === n || "" === t) return t;
                    if ("string" != typeof t) throw $r("itype", "Attempted to trust a non-string value in a content requiring a string: Context: {0}", e);
                    return new a(t);
                }
                function l(e) {
                    return e instanceof d ? e.$$unwrapTrustedValue() : e;
                }
                function u(e, t) {
                    if (null === t || t === n || "" === t) return t;
                    var a = m.hasOwnProperty(e) ? m[e] : null;
                    if (a && t instanceof a) return t.$$unwrapTrustedValue();
                    if (e === kr.RESOURCE_URL) {
                        if (i(t)) return t;
                        throw $r("insecurl", "Blocked loading resource from url not allowed by $sceDelegate policy.  URL: {0}", t.toString());
                    }
                    if (e === kr.HTML) return c(t);
                    throw $r("unsafe", "Attempting to use an unsafe value in a safe context.");
                }
                var c = function(e) {
                    throw $r("unsafe", "Attempting to use an unsafe value in a safe context.");
                };
                a.has("$sanitize") && (c = a.get("$sanitize"));
                var d = s(), m = {};
                return m[kr.HTML] = s(d), m[kr.CSS] = s(d), m[kr.URL] = s(d), m[kr.JS] = s(d), m[kr.RESOURCE_URL] = s(m[kr.URL]), 
                {
                    trustAs: o,
                    getTrusted: u,
                    valueOf: l
                };
            } ];
        }
        function Xt() {
            var e = !0;
            this.enabled = function(t) {
                return arguments.length && (e = !!t), e;
            }, this.$get = [ "$parse", "$sceDelegate", function(t, n) {
                if (e && ta < 8) throw $r("iequirks", "Strict Contextual Escaping does not support Internet Explorer version < 11 in quirks mode.  You can fix this by adding the text <!doctype html> to the top of your HTML document.  See http://docs.angularjs.org/api/ng.$sce for more information.");
                var a = I(kr);
                a.isEnabled = function() {
                    return e;
                }, a.trustAs = n.trustAs, a.getTrusted = n.getTrusted, a.valueOf = n.valueOf, e || (a.trustAs = a.getTrusted = function(e, t) {
                    return t;
                }, a.valueOf = h), a.parseAs = function(e, n) {
                    var r = t(n);
                    return r.literal && r.constant ? r : t(n, function(t) {
                        return a.getTrusted(e, t);
                    });
                };
                var r = a.parseAs, s = a.getTrusted, o = a.trustAs;
                return i(kr, function(e, t) {
                    var n = Kn(t);
                    a[he("parse_as_" + n)] = function(t) {
                        return r(e, t);
                    }, a[he("get_trusted_" + n)] = function(t) {
                        return s(e, t);
                    }, a[he("trust_as_" + n)] = function(t) {
                        return o(e, t);
                    };
                }), a;
            } ];
        }
        function en() {
            this.$get = [ "$window", "$document", function(e, t) {
                var n, a, r = {}, i = m((/android (\d+)/.exec(Kn((e.navigator || {}).userAgent)) || [])[1]), s = /Boxee/i.test((e.navigator || {}).userAgent), o = t[0] || {}, l = /^(Moz|webkit|ms)(?=[A-Z])/, u = o.body && o.body.style, c = !1, d = !1;
                if (u) {
                    for (var f in u) if (a = l.exec(f)) {
                        n = a[0], n = n.substr(0, 1).toUpperCase() + n.substr(1);
                        break;
                    }
                    n || (n = "WebkitOpacity" in u && "webkit"), c = !!("transition" in u || n + "Transition" in u), 
                    d = !!("animation" in u || n + "Animation" in u), !i || c && d || (c = y(o.body.style.webkitTransition), 
                    d = y(o.body.style.webkitAnimation));
                }
                return {
                    history: !(!e.history || !e.history.pushState || i < 4 || s),
                    hasEvent: function(e) {
                        if ("input" === e && ta <= 11) return !1;
                        if (_(r[e])) {
                            var t = o.createElement("div");
                            r[e] = "on" + e in t;
                        }
                        return r[e];
                    },
                    csp: ga(),
                    vendorPrefix: n,
                    transitions: c,
                    animations: d,
                    android: i
                };
            } ];
        }
        function tn() {
            this.$get = [ "$templateCache", "$http", "$q", "$sce", function(e, t, n, a) {
                function r(i, s) {
                    function o(e) {
                        if (!s) throw Qa("tpload", "Failed to load template: {0}", i);
                        return n.reject(e);
                    }
                    r.totalPendingRequests++, y(i) && e.get(i) || (i = a.getTrustedResourceUrl(i));
                    var l = t.defaults && t.defaults.transformResponse;
                    fa(l) ? l = l.filter(function(e) {
                        return e !== rt;
                    }) : l === rt && (l = null);
                    var u = {
                        cache: e,
                        transformResponse: l
                    };
                    return t.get(i, u).finally(function() {
                        r.totalPendingRequests--;
                    }).then(function(e) {
                        return e.data;
                    }, o);
                }
                return r.totalPendingRequests = 0, r;
            } ];
        }
        function nn() {
            this.$get = [ "$rootScope", "$browser", "$location", function(e, t, n) {
                var a = {};
                return a.findBindings = function(e, t, n) {
                    var a = e.getElementsByClassName("ng-binding"), r = [];
                    return i(a, function(e) {
                        var a = ca.element(e).data("$binding");
                        a && i(a, function(a) {
                            if (n) {
                                var i = new RegExp("(^|\\s)" + ha(t) + "(\\s|\\||$)");
                                i.test(a) && r.push(e);
                            } else a.indexOf(t) != -1 && r.push(e);
                        });
                    }), r;
                }, a.findModels = function(e, t, n) {
                    for (var a = [ "ng-", "data-ng-", "ng\\:" ], r = 0; r < a.length; ++r) {
                        var i = n ? "=" : "*=", s = "[" + a[r] + "model" + i + '"' + t + '"]', o = e.querySelectorAll(s);
                        if (o.length) return o;
                    }
                }, a.getLocation = function() {
                    return n.url();
                }, a.setLocation = function(t) {
                    t !== n.url() && (n.url(t), e.$digest());
                }, a.whenStable = function(e) {
                    t.notifyWhenNoOutstandingRequests(e);
                }, a;
            } ];
        }
        function an() {
            this.$get = [ "$rootScope", "$browser", "$q", "$$q", "$exceptionHandler", function(e, t, n, a, r) {
                function i(i, o, l) {
                    var u, c = v(l) && !l, d = (c ? a : n).defer(), m = d.promise;
                    return u = t.defer(function() {
                        try {
                            d.resolve(i());
                        } catch (e) {
                            d.reject(e), r(e);
                        } finally {
                            delete s[m.$$timeoutId];
                        }
                        c || e.$apply();
                    }, o), m.$$timeoutId = u, s[u] = d, m;
                }
                var s = {};
                return i.cancel = function(e) {
                    return !!(e && e.$$timeoutId in s) && (s[e.$$timeoutId].reject("canceled"), delete s[e.$$timeoutId], 
                    t.defer.cancel(e.$$timeoutId));
                }, i;
            } ];
        }
        function rn(e) {
            var t = e;
            return ta && (wr.setAttribute("href", t), t = wr.href), wr.setAttribute("href", t), 
            {
                href: wr.href,
                protocol: wr.protocol ? wr.protocol.replace(/:$/, "") : "",
                host: wr.host,
                search: wr.search ? wr.search.replace(/^\?/, "") : "",
                hash: wr.hash ? wr.hash.replace(/^#/, "") : "",
                hostname: wr.hostname,
                port: wr.port,
                pathname: "/" === wr.pathname.charAt(0) ? wr.pathname : "/" + wr.pathname
            };
        }
        function sn(e) {
            var t = y(e) ? rn(e) : e;
            return t.protocol === Lr.protocol && t.host === Lr.host;
        }
        function on() {
            this.$get = g(e);
        }
        function ln(e) {
            function t(a, r) {
                if (b(a)) {
                    var s = {};
                    return i(a, function(e, n) {
                        s[n] = t(n, e);
                    }), s;
                }
                return e.factory(a + n, r);
            }
            var n = "Filter";
            this.register = t, this.$get = [ "$injector", function(e) {
                return function(t) {
                    return e.get(t + n);
                };
            } ], t("currency", mn), t("date", Ln), t("filter", un), t("json", Dn), t("limitTo", Yn), 
            t("lowercase", xr), t("number", fn), t("orderBy", Tn), t("uppercase", Cr);
        }
        function un() {
            return function(e, t, n) {
                if (!fa(e)) return e;
                var a, r, i = null !== t ? typeof t : "null";
                switch (i) {
                  case "function":
                    a = t;
                    break;

                  case "boolean":
                  case "null":
                  case "number":
                  case "string":
                    r = !0;

                  case "object":
                    a = cn(t, n, r);
                    break;

                  default:
                    return e;
                }
                return e.filter(a);
            };
        }
        function cn(e, t, n) {
            var a, r = b(e) && "$" in e;
            return t === !0 ? t = P : k(t) || (t = function(e, t) {
                return !_(e) && (null === e || null === t ? e === t : !b(e) && !b(t) && (e = Kn("" + e), 
                t = Kn("" + t), e.indexOf(t) !== -1));
            }), a = function(a) {
                return r && !b(a) ? dn(a, e.$, t, !1) : dn(a, e, t, n);
            };
        }
        function dn(e, t, n, a, r) {
            var i = null !== e ? typeof e : "null", s = null !== t ? typeof t : "null";
            if ("string" === s && "!" === t.charAt(0)) return !dn(e, t.substring(1), n, a);
            if (fa(e)) return e.some(function(e) {
                return dn(e, t, n, a);
            });
            switch (i) {
              case "object":
                var o;
                if (a) {
                    for (o in e) if ("$" !== o.charAt(0) && dn(e[o], t, n, !0)) return !0;
                    return !r && dn(e, t, n, !1);
                }
                if ("object" === s) {
                    for (o in t) {
                        var l = t[o];
                        if (!k(l) && !_(l)) {
                            var u = "$" === o, c = u ? e : e[o];
                            if (!dn(c, l, n, u, u)) return !1;
                        }
                    }
                    return !0;
                }
                return n(e, t);

              case "function":
                return !1;

              default:
                return n(e, t);
            }
        }
        function mn(e) {
            var t = e.NUMBER_FORMATS;
            return function(e, n, a) {
                return _(n) && (n = t.CURRENCY_SYM), _(a) && (a = t.PATTERNS[1].maxFrac), null == e ? e : pn(e, t.PATTERNS[1], t.GROUP_SEP, t.DECIMAL_SEP, a).replace(/\u00A4/g, n);
            };
        }
        function fn(e) {
            var t = e.NUMBER_FORMATS;
            return function(e, n) {
                return null == e ? e : pn(e, t.PATTERNS[0], t.GROUP_SEP, t.DECIMAL_SEP, n);
            };
        }
        function pn(e, t, n, a, r) {
            if (!isFinite(e) || b(e)) return "";
            var i = e < 0;
            e = Math.abs(e);
            var s = e + "", o = "", l = [], u = !1;
            if (s.indexOf("e") !== -1) {
                var c = s.match(/([\d\.]+)e(-?)(\d+)/);
                c && "-" == c[2] && c[3] > r + 1 ? e = 0 : (o = s, u = !0);
            }
            if (u) r > 0 && e < 1 && (o = e.toFixed(r), e = parseFloat(o)); else {
                var d = (s.split(Dr)[1] || "").length;
                _(r) && (r = Math.min(Math.max(t.minFrac, d), t.maxFrac)), e = +(Math.round(+(e.toString() + "e" + r)).toString() + "e" + -r);
                var m = ("" + e).split(Dr), f = m[0];
                m = m[1] || "";
                var p, h = 0, g = t.lgSize, v = t.gSize;
                if (f.length >= g + v) for (h = f.length - g, p = 0; p < h; p++) (h - p) % v === 0 && 0 !== p && (o += n), 
                o += f.charAt(p);
                for (p = h; p < f.length; p++) (f.length - p) % g === 0 && 0 !== p && (o += n), 
                o += f.charAt(p);
                for (;m.length < r; ) m += "0";
                r && "0" !== r && (o += a + m.substr(0, r));
            }
            return 0 === e && (i = !1), l.push(i ? t.negPre : t.posPre, o, i ? t.negSuf : t.posSuf), 
            l.join("");
        }
        function hn(e, t, n) {
            var a = "";
            for (e < 0 && (a = "-", e = -e), e = "" + e; e.length < t; ) e = "0" + e;
            return n && (e = e.substr(e.length - t)), a + e;
        }
        function gn(e, t, n, a) {
            return n = n || 0, function(r) {
                var i = r["get" + e]();
                return (n > 0 || i > -n) && (i += n), 0 === i && n == -12 && (i = 12), hn(i, t, a);
            };
        }
        function _n(e, t) {
            return function(n, a) {
                var r = n["get" + e](), i = Zn(t ? "SHORT" + e : e);
                return a[i][r];
            };
        }
        function vn(e) {
            var t = -1 * e.getTimezoneOffset(), n = t >= 0 ? "+" : "";
            return n += hn(Math[t > 0 ? "floor" : "ceil"](t / 60), 2) + hn(Math.abs(t % 60), 2);
        }
        function bn(e) {
            var t = new Date(e, 0, 1).getDay();
            return new Date(e, 0, (t <= 4 ? 5 : 12) - t);
        }
        function yn(e) {
            return new Date(e.getFullYear(), e.getMonth(), e.getDate() + (4 - e.getDay()));
        }
        function Mn(e) {
            return function(t) {
                var n = bn(t.getFullYear()), a = yn(t), r = +a - +n, i = 1 + Math.round(r / 6048e5);
                return hn(i, e);
            };
        }
        function $n(e, t) {
            return e.getHours() < 12 ? t.AMPMS[0] : t.AMPMS[1];
        }
        function kn(e, t) {
            return e.getFullYear() <= 0 ? t.ERAS[0] : t.ERAS[1];
        }
        function wn(e, t) {
            return e.getFullYear() <= 0 ? t.ERANAMES[0] : t.ERANAMES[1];
        }
        function Ln(e) {
            function t(e) {
                var t;
                if (t = e.match(n)) {
                    var a = new Date(0), r = 0, i = 0, s = t[8] ? a.setUTCFullYear : a.setFullYear, o = t[8] ? a.setUTCHours : a.setHours;
                    t[9] && (r = m(t[9] + t[10]), i = m(t[9] + t[11])), s.call(a, m(t[1]), m(t[2]) - 1, m(t[3]));
                    var l = m(t[4] || 0) - r, u = m(t[5] || 0) - i, c = m(t[6] || 0), d = Math.round(1e3 * parseFloat("0." + (t[7] || 0)));
                    return o.call(a, l, u, c, d), a;
                }
                return e;
            }
            var n = /^(\d{4})-?(\d\d)-?(\d\d)(?:T(\d\d)(?::?(\d\d)(?::?(\d\d)(?:\.(\d+))?)?)?(Z|([+-])(\d\d):?(\d\d))?)?$/;
            return function(n, a, r) {
                var s, o, l = "", u = [];
                if (a = a || "mediumDate", a = e.DATETIME_FORMATS[a] || a, y(n) && (n = Sr.test(n) ? m(n) : t(n)), 
                M(n) && (n = new Date(n)), !$(n)) return n;
                for (;a; ) o = Tr.exec(a), o ? (u = F(u, o, 1), a = u.pop()) : (u.push(a), a = null);
                return r && "UTC" === r && (n = new Date(n.getTime()), n.setMinutes(n.getMinutes() + n.getTimezoneOffset())), 
                i(u, function(t) {
                    s = Yr[t], l += s ? s(n, e.DATETIME_FORMATS) : t.replace(/(^'|'$)/g, "").replace(/''/g, "'");
                }), l;
            };
        }
        function Dn() {
            return function(e, t) {
                return _(t) && (t = 2), W(e, t);
            };
        }
        function Yn() {
            return function(e, t) {
                return M(e) && (e = e.toString()), fa(e) || y(e) ? (t = Math.abs(Number(t)) === 1 / 0 ? Number(t) : m(t), 
                t ? t > 0 ? e.slice(0, t) : e.slice(t) : y(e) ? "" : []) : e;
            };
        }
        function Tn(e) {
            return function(t, n, a) {
                function i(e, t) {
                    for (var a = 0; a < n.length; a++) {
                        var r = n[a](e, t);
                        if (0 !== r) return r;
                    }
                    return 0;
                }
                function s(e, t) {
                    return t ? function(t, n) {
                        return e(n, t);
                    } : e;
                }
                function o(e) {
                    switch (typeof e) {
                      case "number":
                      case "boolean":
                      case "string":
                        return !0;

                      default:
                        return !1;
                    }
                }
                function l(e) {
                    return null === e ? "null" : "function" == typeof e.valueOf && (e = e.valueOf(), 
                    o(e)) ? e : "function" == typeof e.toString && (e = e.toString(), o(e)) ? e : "";
                }
                function u(e, t) {
                    var n = typeof e, a = typeof t;
                    return n === a && "object" === n && (e = l(e), t = l(t)), n === a ? ("string" === n && (e = e.toLowerCase(), 
                    t = t.toLowerCase()), e === t ? 0 : e < t ? -1 : 1) : n < a ? -1 : 1;
                }
                return r(t) ? (n = fa(n) ? n : [ n ], 0 === n.length && (n = [ "+" ]), n = n.map(function(t) {
                    var n = !1, a = t || h;
                    if (y(t)) {
                        if ("+" != t.charAt(0) && "-" != t.charAt(0) || (n = "-" == t.charAt(0), t = t.substring(1)), 
                        "" === t) return s(u, n);
                        if (a = e(t), a.constant) {
                            var r = a();
                            return s(function(e, t) {
                                return u(e[r], t[r]);
                            }, n);
                        }
                    }
                    return s(function(e, t) {
                        return u(a(e), a(t));
                    }, n);
                }), ia.call(t).sort(s(i, a))) : t;
            };
        }
        function Sn(e) {
            return k(e) && (e = {
                link: e
            }), e.restrict = e.restrict || "AC", g(e);
        }
        function xn(e, t) {
            e.$name = t;
        }
        function Cn(e, t, a, r, s) {
            var o = this, l = [], u = o.$$parentForm = e.parent().controller("form") || Ar;
            o.$error = {}, o.$$success = {}, o.$pending = n, o.$name = s(t.name || t.ngForm || "")(a), 
            o.$dirty = !1, o.$pristine = !0, o.$valid = !0, o.$invalid = !1, o.$submitted = !1, 
            u.$addControl(o), o.$rollbackViewValue = function() {
                i(l, function(e) {
                    e.$rollbackViewValue();
                });
            }, o.$commitViewValue = function() {
                i(l, function(e) {
                    e.$commitViewValue();
                });
            }, o.$addControl = function(e) {
                se(e.$name, "input"), l.push(e), e.$name && (o[e.$name] = e);
            }, o.$$renameControl = function(e, t) {
                var n = e.$name;
                o[n] === e && delete o[n], o[t] = e, e.$name = t;
            }, o.$removeControl = function(e) {
                e.$name && o[e.$name] === e && delete o[e.$name], i(o.$pending, function(t, n) {
                    o.$setValidity(n, null, e);
                }), i(o.$error, function(t, n) {
                    o.$setValidity(n, null, e);
                }), i(o.$$success, function(t, n) {
                    o.$setValidity(n, null, e);
                }), j(l, e);
            }, zn({
                ctrl: this,
                $element: e,
                set: function(e, t, n) {
                    var a = e[t];
                    if (a) {
                        var r = a.indexOf(n);
                        r === -1 && a.push(n);
                    } else e[t] = [ n ];
                },
                unset: function(e, t, n) {
                    var a = e[t];
                    a && (j(a, n), 0 === a.length && delete e[t]);
                },
                parentForm: u,
                $animate: r
            }), o.$setDirty = function() {
                r.removeClass(e, gi), r.addClass(e, _i), o.$dirty = !0, o.$pristine = !1, u.$setDirty();
            }, o.$setPristine = function() {
                r.setClass(e, gi, _i + " " + jr), o.$dirty = !1, o.$pristine = !0, o.$submitted = !1, 
                i(l, function(e) {
                    e.$setPristine();
                });
            }, o.$setUntouched = function() {
                i(l, function(e) {
                    e.$setUntouched();
                });
            }, o.$setSubmitted = function() {
                r.addClass(e, jr), o.$submitted = !0, u.$setSubmitted();
            };
        }
        function En(e) {
            e.$formatters.push(function(t) {
                return e.$isEmpty(t) ? t : t.toString();
            });
        }
        function Hn(e, t, n, a, r, i) {
            An(e, t, n, a, r, i), En(a);
        }
        function An(e, t, n, a, r, i) {
            var s = Kn(t[0].type);
            if (!r.android) {
                var o = !1;
                t.on("compositionstart", function(e) {
                    o = !0;
                }), t.on("compositionend", function() {
                    o = !1, l();
                });
            }
            var l = function(e) {
                if (u && (i.defer.cancel(u), u = null), !o) {
                    var r = t.val(), l = e && e.type;
                    "password" === s || n.ngTrim && "false" === n.ngTrim || (r = pa(r)), (a.$viewValue !== r || "" === r && a.$$hasNativeValidators) && a.$setViewValue(r, l);
                }
            };
            if (r.hasEvent("input")) t.on("input", l); else {
                var u, c = function(e, t, n) {
                    u || (u = i.defer(function() {
                        u = null, t && t.value === n || l(e);
                    }));
                };
                t.on("keydown", function(e) {
                    var t = e.keyCode;
                    91 === t || 15 < t && t < 19 || 37 <= t && t <= 40 || c(e, this, this.value);
                }), r.hasEvent("paste") && t.on("paste cut", c);
            }
            t.on("change", l), a.$render = function() {
                t.val(a.$isEmpty(a.$viewValue) ? "" : a.$viewValue);
            };
        }
        function jn(e, t) {
            if ($(e)) return e;
            if (y(e)) {
                Rr.lastIndex = 0;
                var n = Rr.exec(e);
                if (n) {
                    var a = +n[1], r = +n[2], i = 0, s = 0, o = 0, l = 0, u = bn(a), c = 7 * (r - 1);
                    return t && (i = t.getHours(), s = t.getMinutes(), o = t.getSeconds(), l = t.getMilliseconds()), 
                    new Date(a, 0, u.getDate() + c, i, s, o, l);
                }
            }
            return NaN;
        }
        function On(e, t) {
            return function(n, a) {
                var r, s;
                if ($(n)) return n;
                if (y(n)) {
                    if ('"' == n.charAt(0) && '"' == n.charAt(n.length - 1) && (n = n.substring(1, n.length - 1)), 
                    Fr.test(n)) return new Date(n);
                    if (e.lastIndex = 0, r = e.exec(n)) return r.shift(), s = a ? {
                        yyyy: a.getFullYear(),
                        MM: a.getMonth() + 1,
                        dd: a.getDate(),
                        HH: a.getHours(),
                        mm: a.getMinutes(),
                        ss: a.getSeconds(),
                        sss: a.getMilliseconds() / 1e3
                    } : {
                        yyyy: 1970,
                        MM: 1,
                        dd: 1,
                        HH: 0,
                        mm: 0,
                        ss: 0,
                        sss: 0
                    }, i(r, function(e, n) {
                        n < t.length && (s[t[n]] = +e);
                    }), new Date(s.yyyy, s.MM - 1, s.dd, s.HH, s.mm, s.ss || 0, 1e3 * s.sss || 0);
                }
                return NaN;
            };
        }
        function In(e, t, a, r) {
            return function(i, s, o, l, u, c, d) {
                function m(e) {
                    return e && !(e.getTime && e.getTime() !== e.getTime());
                }
                function f(e) {
                    return v(e) ? $(e) ? e : a(e) : n;
                }
                Pn(i, s, o, l), An(i, s, o, l, u, c);
                var p, h = l && l.$options && l.$options.timezone;
                if (l.$$parserName = e, l.$parsers.push(function(e) {
                    if (l.$isEmpty(e)) return null;
                    if (t.test(e)) {
                        var r = a(e, p);
                        return "UTC" === h && r.setMinutes(r.getMinutes() - r.getTimezoneOffset()), r;
                    }
                    return n;
                }), l.$formatters.push(function(e) {
                    if (e && !$(e)) throw Mi("datefmt", "Expected `{0}` to be a date", e);
                    if (m(e)) {
                        if (p = e, p && "UTC" === h) {
                            var t = 6e4 * p.getTimezoneOffset();
                            p = new Date(p.getTime() + t);
                        }
                        return d("date")(e, r, h);
                    }
                    return p = null, "";
                }), v(o.min) || o.ngMin) {
                    var g;
                    l.$validators.min = function(e) {
                        return !m(e) || _(g) || a(e) >= g;
                    }, o.$observe("min", function(e) {
                        g = f(e), l.$validate();
                    });
                }
                if (v(o.max) || o.ngMax) {
                    var b;
                    l.$validators.max = function(e) {
                        return !m(e) || _(b) || a(e) <= b;
                    }, o.$observe("max", function(e) {
                        b = f(e), l.$validate();
                    });
                }
            };
        }
        function Pn(e, t, a, r) {
            var i = t[0], s = r.$$hasNativeValidators = b(i.validity);
            s && r.$parsers.push(function(e) {
                var a = t.prop(Jn) || {};
                return a.badInput && !a.typeMismatch ? n : e;
            });
        }
        function Fn(e, t, a, r, i, s) {
            if (Pn(e, t, a, r), An(e, t, a, r, i, s), r.$$parserName = "number", r.$parsers.push(function(e) {
                return r.$isEmpty(e) ? null : Vr.test(e) ? parseFloat(e) : n;
            }), r.$formatters.push(function(e) {
                if (!r.$isEmpty(e)) {
                    if (!M(e)) throw Mi("numfmt", "Expected `{0}` to be a number", e);
                    e = e.toString();
                }
                return e;
            }), v(a.min) || a.ngMin) {
                var o;
                r.$validators.min = function(e) {
                    return r.$isEmpty(e) || _(o) || e >= o;
                }, a.$observe("min", function(e) {
                    v(e) && !M(e) && (e = parseFloat(e, 10)), o = M(e) && !isNaN(e) ? e : n, r.$validate();
                });
            }
            if (v(a.max) || a.ngMax) {
                var l;
                r.$validators.max = function(e) {
                    return r.$isEmpty(e) || _(l) || e <= l;
                }, a.$observe("max", function(e) {
                    v(e) && !M(e) && (e = parseFloat(e, 10)), l = M(e) && !isNaN(e) ? e : n, r.$validate();
                });
            }
        }
        function Un(e, t, n, a, r, i) {
            An(e, t, n, a, r, i), En(a), a.$$parserName = "url", a.$validators.url = function(e, t) {
                var n = e || t;
                return a.$isEmpty(n) || Ur.test(n);
            };
        }
        function Nn(e, t, n, a, r, i) {
            An(e, t, n, a, r, i), En(a), a.$$parserName = "email", a.$validators.email = function(e, t) {
                var n = e || t;
                return a.$isEmpty(n) || Nr.test(n);
            };
        }
        function Vn(e, t, n, a) {
            _(n.name) && t.attr("name", u());
            var r = function(e) {
                t[0].checked && a.$setViewValue(n.value, e && e.type);
            };
            t.on("click", r), a.$render = function() {
                var e = n.value;
                t[0].checked = e == a.$viewValue;
            }, n.$observe("value", a.$render);
        }
        function Wn(e, t, n, a, r) {
            var i;
            if (v(a)) {
                if (i = e(a), !i.constant) throw Mi("constexpr", "Expected constant expression for `{0}`, but saw `{1}`.", n, a);
                return i(t);
            }
            return r;
        }
        function qn(e, t, n, a, r, i, s, o) {
            var l = Wn(o, e, "ngTrueValue", n.ngTrueValue, !0), u = Wn(o, e, "ngFalseValue", n.ngFalseValue, !1), c = function(e) {
                a.$setViewValue(t[0].checked, e && e.type);
            };
            t.on("click", c), a.$render = function() {
                t[0].checked = a.$viewValue;
            }, a.$isEmpty = function(e) {
                return e === !1;
            }, a.$formatters.push(function(e) {
                return P(e, l);
            }), a.$parsers.push(function(e) {
                return e ? l : u;
            });
        }
        function Rn(e, t) {
            return e = "ngClass" + e, [ "$animate", function(n) {
                function a(e, t) {
                    var n = [];
                    e: for (var a = 0; a < e.length; a++) {
                        for (var r = e[a], i = 0; i < t.length; i++) if (r == t[i]) continue e;
                        n.push(r);
                    }
                    return n;
                }
                function r(e) {
                    if (fa(e)) return e;
                    if (y(e)) return e.split(" ");
                    if (b(e)) {
                        var t = [];
                        return i(e, function(e, n) {
                            e && (t = t.concat(n.split(" ")));
                        }), t;
                    }
                    return e;
                }
                return {
                    restrict: "AC",
                    link: function(s, o, l) {
                        function u(e) {
                            var t = d(e, 1);
                            l.$addClass(t);
                        }
                        function c(e) {
                            var t = d(e, -1);
                            l.$removeClass(t);
                        }
                        function d(e, t) {
                            var n = o.data("$classCounts") || {}, a = [];
                            return i(e, function(e) {
                                (t > 0 || n[e]) && (n[e] = (n[e] || 0) + t, n[e] === +(t > 0) && a.push(e));
                            }), o.data("$classCounts", n), a.join(" ");
                        }
                        function m(e, t) {
                            var r = a(t, e), i = a(e, t);
                            r = d(r, 1), i = d(i, -1), r && r.length && n.addClass(o, r), i && i.length && n.removeClass(o, i);
                        }
                        function f(e) {
                            if (t === !0 || s.$index % 2 === t) {
                                var n = r(e || []);
                                if (p) {
                                    if (!P(e, p)) {
                                        var a = r(p);
                                        m(a, n);
                                    }
                                } else u(n);
                            }
                            p = I(e);
                        }
                        var p;
                        s.$watch(l[e], f, !0), l.$observe("class", function(t) {
                            f(s.$eval(l[e]));
                        }), "ngClass" !== e && s.$watch("$index", function(n, a) {
                            var i = 1 & n;
                            if (i !== (1 & a)) {
                                var o = r(s.$eval(l[e]));
                                i === t ? u(o) : c(o);
                            }
                        });
                    }
                };
            } ];
        }
        function zn(e) {
            function t(e, t, l) {
                t === n ? a("$pending", e, l) : r("$pending", e, l), x(t) ? t ? (d(o.$error, e, l), 
                c(o.$$success, e, l)) : (c(o.$error, e, l), d(o.$$success, e, l)) : (d(o.$error, e, l), 
                d(o.$$success, e, l)), o.$pending ? (i(yi, !0), o.$valid = o.$invalid = n, s("", null)) : (i(yi, !1), 
                o.$valid = Bn(o.$error), o.$invalid = !o.$valid, s("", o.$valid));
                var u;
                u = o.$pending && o.$pending[e] ? n : !o.$error[e] && (!!o.$$success[e] || null), 
                s(e, u), m.$setValidity(e, u, o);
            }
            function a(e, t, n) {
                o[e] || (o[e] = {}), c(o[e], t, n);
            }
            function r(e, t, a) {
                o[e] && d(o[e], t, a), Bn(o[e]) && (o[e] = n);
            }
            function i(e, t) {
                t && !u[e] ? (f.addClass(l, e), u[e] = !0) : !t && u[e] && (f.removeClass(l, e), 
                u[e] = !1);
            }
            function s(e, t) {
                e = e ? "-" + ne(e, "-") : "", i(pi + e, t === !0), i(hi + e, t === !1);
            }
            var o = e.ctrl, l = e.$element, u = {}, c = e.set, d = e.unset, m = e.parentForm, f = e.$animate;
            u[hi] = !(u[pi] = l.hasClass(pi)), o.$setValidity = t;
        }
        function Bn(e) {
            if (e) for (var t in e) return !1;
            return !0;
        }
        var Gn = /^\/(.+)\/([a-z]*)$/, Jn = "validity", Kn = function(e) {
            return y(e) ? e.toLowerCase() : e;
        }, Qn = Object.prototype.hasOwnProperty, Zn = function(e) {
            return y(e) ? e.toUpperCase() : e;
        }, Xn = function(e) {
            return y(e) ? e.replace(/[A-Z]/g, function(e) {
                return String.fromCharCode(32 | e.charCodeAt(0));
            }) : e;
        }, ea = function(e) {
            return y(e) ? e.replace(/[a-z]/g, function(e) {
                return String.fromCharCode(e.charCodeAt(0) & -33);
            }) : e;
        };
        "i" !== "I".toLowerCase() && (Kn = Xn, Zn = ea);
        var ta, na, aa, ra, ia = [].slice, sa = [].splice, oa = [].push, la = Object.prototype.toString, ua = a("ng"), ca = e.angular || (e.angular = {}), da = 0;
        ta = t.documentMode, p.$inject = [], h.$inject = [];
        var ma, fa = Array.isArray, pa = function(e) {
            return y(e) ? e.trim() : e;
        }, ha = function(e) {
            return e.replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08");
        }, ga = function() {
            if (v(ga.isActive_)) return ga.isActive_;
            var e = !(!t.querySelector("[ng-csp]") && !t.querySelector("[data-ng-csp]"));
            if (!e) try {
                new Function("");
            } catch (t) {
                e = !0;
            }
            return ga.isActive_ = e;
        }, _a = [ "ng-", "data-ng-", "ng:", "x-ng-" ], va = /[A-Z]/g, ba = !1, ya = 1, Ma = 2, $a = 3, ka = 8, wa = 9, La = 11, Da = {
            full: "1.3.20",
            major: 1,
            minor: 3,
            dot: 20,
            codeName: "shallow-translucence"
        };
        ye.expando = "ng339";
        var Ya = ye.cache = {}, Ta = 1, Sa = function(e, t, n) {
            e.addEventListener(t, n, !1);
        }, xa = function(e, t, n) {
            e.removeEventListener(t, n, !1);
        };
        ye._data = function(e) {
            return this.cache[e[this.expando]] || {};
        };
        var Ca = /([\:\-\_]+(.))/g, Ea = /^moz([A-Z])/, Ha = {
            mouseleave: "mouseout",
            mouseenter: "mouseover"
        }, Aa = a("jqLite"), ja = /^<(\w+)\s*\/?>(?:<\/\1>|)$/, Oa = /<|&#?\w+;/, Ia = /<([\w:]+)/, Pa = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi, Fa = {
            option: [ 1, '<select multiple="multiple">', "</select>" ],
            thead: [ 1, "<table>", "</table>" ],
            col: [ 2, "<table><colgroup>", "</colgroup></table>" ],
            tr: [ 2, "<table><tbody>", "</tbody></table>" ],
            td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],
            _default: [ 0, "", "" ]
        };
        Fa.optgroup = Fa.option, Fa.tbody = Fa.tfoot = Fa.colgroup = Fa.caption = Fa.thead, 
        Fa.th = Fa.td;
        var Ua = ye.prototype = {
            ready: function(n) {
                function a() {
                    r || (r = !0, n());
                }
                var r = !1;
                "complete" === t.readyState ? setTimeout(a) : (this.on("DOMContentLoaded", a), ye(e).on("load", a));
            },
            toString: function() {
                var e = [];
                return i(this, function(t) {
                    e.push("" + t);
                }), "[" + e.join(", ") + "]";
            },
            eq: function(e) {
                return na(e >= 0 ? this[e] : this[this.length + e]);
            },
            length: 0,
            push: oa,
            sort: [].sort,
            splice: [].splice
        }, Na = {};
        i("multiple,selected,checked,disabled,readOnly,required,open".split(","), function(e) {
            Na[Kn(e)] = e;
        });
        var Va = {};
        i("input,select,option,textarea,button,form,details".split(","), function(e) {
            Va[e] = !0;
        });
        var Wa = {
            ngMinlength: "minlength",
            ngMaxlength: "maxlength",
            ngMin: "min",
            ngMax: "max",
            ngPattern: "pattern"
        };
        i({
            data: De,
            removeData: we
        }, function(e, t) {
            ye[t] = e;
        }), i({
            data: De,
            inheritedData: Ee,
            scope: function(e) {
                return na.data(e, "$scope") || Ee(e.parentNode || e, [ "$isolateScope", "$scope" ]);
            },
            isolateScope: function(e) {
                return na.data(e, "$isolateScope") || na.data(e, "$isolateScopeNoTemplate");
            },
            controller: Ce,
            injector: function(e) {
                return Ee(e, "$injector");
            },
            removeAttr: function(e, t) {
                e.removeAttribute(t);
            },
            hasClass: Ye,
            css: function(e, t, n) {
                return t = he(t), v(n) ? void (e.style[t] = n) : e.style[t];
            },
            attr: function(e, t, a) {
                var r = e.nodeType;
                if (r !== $a && r !== Ma && r !== ka) {
                    var i = Kn(t);
                    if (Na[i]) {
                        if (!v(a)) return e[t] || (e.attributes.getNamedItem(t) || p).specified ? i : n;
                        a ? (e[t] = !0, e.setAttribute(t, i)) : (e[t] = !1, e.removeAttribute(i));
                    } else if (v(a)) e.setAttribute(t, a); else if (e.getAttribute) {
                        var s = e.getAttribute(t, 2);
                        return null === s ? n : s;
                    }
                }
            },
            prop: function(e, t, n) {
                return v(n) ? void (e[t] = n) : e[t];
            },
            text: function() {
                function e(e, t) {
                    if (_(t)) {
                        var n = e.nodeType;
                        return n === ya || n === $a ? e.textContent : "";
                    }
                    e.textContent = t;
                }
                return e.$dv = "", e;
            }(),
            val: function(e, t) {
                if (_(t)) {
                    if (e.multiple && "select" === A(e)) {
                        var n = [];
                        return i(e.options, function(e) {
                            e.selected && n.push(e.value || e.text);
                        }), 0 === n.length ? null : n;
                    }
                    return e.value;
                }
                e.value = t;
            },
            html: function(e, t) {
                return _(t) ? e.innerHTML : ($e(e, !0), void (e.innerHTML = t));
            },
            empty: He
        }, function(e, t) {
            ye.prototype[t] = function(t, a) {
                var r, i, s = this.length;
                if (e !== He && (2 == e.length && e !== Ye && e !== Ce ? t : a) === n) {
                    if (b(t)) {
                        for (r = 0; r < s; r++) if (e === De) e(this[r], t); else for (i in t) e(this[r], i, t[i]);
                        return this;
                    }
                    for (var o = e.$dv, l = o === n ? Math.min(s, 1) : s, u = 0; u < l; u++) {
                        var c = e(this[u], t, a);
                        o = o ? o + c : c;
                    }
                    return o;
                }
                for (r = 0; r < s; r++) e(this[r], t, a);
                return this;
            };
        }), i({
            removeData: we,
            on: function e(t, n, a, r) {
                if (v(r)) throw Aa("onargs", "jqLite#on() does not support the `selector` or `eventData` parameters");
                if (_e(t)) {
                    var i = Le(t, !0), s = i.events, o = i.handle;
                    o || (o = i.handle = Pe(t, s));
                    for (var l = n.indexOf(" ") >= 0 ? n.split(" ") : [ n ], u = l.length; u--; ) {
                        n = l[u];
                        var c = s[n];
                        c || (s[n] = [], "mouseenter" === n || "mouseleave" === n ? e(t, Ha[n], function(e) {
                            var t = this, a = e.relatedTarget;
                            a && (a === t || t.contains(a)) || o(e, n);
                        }) : "$destroy" !== n && Sa(t, n, o), c = s[n]), c.push(a);
                    }
                }
            },
            off: ke,
            one: function(e, t, n) {
                e = na(e), e.on(t, function a() {
                    e.off(t, n), e.off(t, a);
                }), e.on(t, n);
            },
            replaceWith: function(e, t) {
                var n, a = e.parentNode;
                $e(e), i(new ye(t), function(t) {
                    n ? a.insertBefore(t, n.nextSibling) : a.replaceChild(t, e), n = t;
                });
            },
            children: function(e) {
                var t = [];
                return i(e.childNodes, function(e) {
                    e.nodeType === ya && t.push(e);
                }), t;
            },
            contents: function(e) {
                return e.contentDocument || e.childNodes || [];
            },
            append: function(e, t) {
                var n = e.nodeType;
                if (n === ya || n === La) {
                    t = new ye(t);
                    for (var a = 0, r = t.length; a < r; a++) {
                        var i = t[a];
                        e.appendChild(i);
                    }
                }
            },
            prepend: function(e, t) {
                if (e.nodeType === ya) {
                    var n = e.firstChild;
                    i(new ye(t), function(t) {
                        e.insertBefore(t, n);
                    });
                }
            },
            wrap: function(e, t) {
                t = na(t).eq(0).clone()[0];
                var n = e.parentNode;
                n && n.replaceChild(t, e), t.appendChild(e);
            },
            remove: Ae,
            detach: function(e) {
                Ae(e, !0);
            },
            after: function(e, t) {
                var n = e, a = e.parentNode;
                t = new ye(t);
                for (var r = 0, i = t.length; r < i; r++) {
                    var s = t[r];
                    a.insertBefore(s, n.nextSibling), n = s;
                }
            },
            addClass: Se,
            removeClass: Te,
            toggleClass: function(e, t, n) {
                t && i(t.split(" "), function(t) {
                    var a = n;
                    _(a) && (a = !Ye(e, t)), (a ? Se : Te)(e, t);
                });
            },
            parent: function(e) {
                var t = e.parentNode;
                return t && t.nodeType !== La ? t : null;
            },
            next: function(e) {
                return e.nextElementSibling;
            },
            find: function(e, t) {
                return e.getElementsByTagName ? e.getElementsByTagName(t) : [];
            },
            clone: Me,
            triggerHandler: function(e, t, n) {
                var a, r, s, o = t.type || t, l = Le(e), u = l && l.events, c = u && u[o];
                c && (a = {
                    preventDefault: function() {
                        this.defaultPrevented = !0;
                    },
                    isDefaultPrevented: function() {
                        return this.defaultPrevented === !0;
                    },
                    stopImmediatePropagation: function() {
                        this.immediatePropagationStopped = !0;
                    },
                    isImmediatePropagationStopped: function() {
                        return this.immediatePropagationStopped === !0;
                    },
                    stopPropagation: p,
                    type: o,
                    target: e
                }, t.type && (a = d(a, t)), r = I(c), s = n ? [ a ].concat(n) : [ a ], i(r, function(t) {
                    a.isImmediatePropagationStopped() || t.apply(e, s);
                }));
            }
        }, function(e, t) {
            ye.prototype[t] = function(t, n, a) {
                for (var r, i = 0, s = this.length; i < s; i++) _(r) ? (r = e(this[i], t, n, a), 
                v(r) && (r = na(r))) : xe(r, e(this[i], t, n, a));
                return v(r) ? r : this;
            }, ye.prototype.bind = ye.prototype.on, ye.prototype.unbind = ye.prototype.off;
        }), Ne.prototype = {
            put: function(e, t) {
                this[Ue(e, this.nextUid)] = t;
            },
            get: function(e) {
                return this[Ue(e, this.nextUid)];
            },
            remove: function(e) {
                var t = this[e = Ue(e, this.nextUid)];
                return delete this[e], t;
            }
        };
        var qa = /^function\s*[^\(]*\(\s*([^\)]*)\)/m, Ra = /,/, za = /^\s*(_?)(\S+?)\1\s*$/, Ba = /((\/\/.*$)|(\/\*[\s\S]*?\*\/))/gm, Ga = a("$injector");
        qe.$$annotate = We;
        var Ja = a("$animate"), Ka = [ "$provide", function(e) {
            this.$$selectors = {}, this.register = function(t, n) {
                var a = t + "-animation";
                if (t && "." != t.charAt(0)) throw Ja("notcsel", "Expecting class selector starting with '.' got '{0}'.", t);
                this.$$selectors[t.substr(1)] = a, e.factory(a, n);
            }, this.classNameFilter = function(e) {
                return 1 === arguments.length && (this.$$classNameFilter = e instanceof RegExp ? e : null), 
                this.$$classNameFilter;
            }, this.$get = [ "$$q", "$$asyncCallback", "$rootScope", function(e, t, n) {
                function a(t) {
                    var a, r = e.defer();
                    return r.promise.$$cancelFn = function() {
                        a && a();
                    }, n.$$postDigest(function() {
                        a = t(function() {
                            r.resolve();
                        });
                    }), r.promise;
                }
                function r(e, t) {
                    var n = [], a = [], r = ue();
                    return i((e.attr("class") || "").split(/\s+/), function(e) {
                        r[e] = !0;
                    }), i(t, function(e, t) {
                        var i = r[t];
                        e === !1 && i ? a.push(t) : e !== !0 || i || n.push(t);
                    }), n.length + a.length > 0 && [ n.length ? n : null, a.length ? a : null ];
                }
                function s(e, t, n) {
                    for (var a = 0, r = t.length; a < r; ++a) {
                        var i = t[a];
                        e[i] = n;
                    }
                }
                function o() {
                    return u || (u = e.defer(), t(function() {
                        u.resolve(), u = null;
                    })), u.promise;
                }
                function l(e, t) {
                    if (ca.isObject(t)) {
                        var n = d(t.from || {}, t.to || {});
                        e.css(n);
                    }
                }
                var u;
                return {
                    animate: function(e, t, n) {
                        return l(e, {
                            from: t,
                            to: n
                        }), o();
                    },
                    enter: function(e, t, n, a) {
                        return l(e, a), n ? n.after(e) : t.prepend(e), o();
                    },
                    leave: function(e, t) {
                        return l(e, t), e.remove(), o();
                    },
                    move: function(e, t, n, a) {
                        return this.enter(e, t, n, a);
                    },
                    addClass: function(e, t, n) {
                        return this.setClass(e, t, [], n);
                    },
                    $$addClassImmediately: function(e, t, n) {
                        return e = na(e), t = y(t) ? t : fa(t) ? t.join(" ") : "", i(e, function(e) {
                            Se(e, t);
                        }), l(e, n), o();
                    },
                    removeClass: function(e, t, n) {
                        return this.setClass(e, [], t, n);
                    },
                    $$removeClassImmediately: function(e, t, n) {
                        return e = na(e), t = y(t) ? t : fa(t) ? t.join(" ") : "", i(e, function(e) {
                            Te(e, t);
                        }), l(e, n), o();
                    },
                    setClass: function(e, t, n, i) {
                        var o = this, l = "$$animateClasses", u = !1;
                        e = na(e);
                        var c = e.data(l);
                        c ? i && c.options && (c.options = ca.extend(c.options || {}, i)) : (c = {
                            classes: {},
                            options: i
                        }, u = !0);
                        var d = c.classes;
                        return t = fa(t) ? t : t.split(" "), n = fa(n) ? n : n.split(" "), s(d, t, !0), 
                        s(d, n, !1), u && (c.promise = a(function(t) {
                            var n = e.data(l);
                            if (e.removeData(l), n) {
                                var a = r(e, n.classes);
                                a && o.$$setClassImmediately(e, a[0], a[1], n.options);
                            }
                            t();
                        }), e.data(l, c)), c.promise;
                    },
                    $$setClassImmediately: function(e, t, n, a) {
                        return t && this.$$addClassImmediately(e, t), n && this.$$removeClassImmediately(e, n), 
                        l(e, a), o();
                    },
                    enabled: p,
                    cancel: p
                };
            } ];
        } ], Qa = a("$compile");
        Qe.$inject = [ "$provide", "$$sanitizeUriProvider" ];
        var Za = /^((?:x|data)[\:\-_])/i, Xa = a("$controller"), er = "application/json", tr = {
            "Content-Type": er + ";charset=utf-8"
        }, nr = /^\[|^\{(?!\{)/, ar = {
            "[": /]$/,
            "{": /}$/
        }, rr = /^\)\]\}',?\n/, ir = a("$interpolate"), sr = /^([^\?#]*)(\?([^#]*))?(#(.*))?$/, or = {
            http: 80,
            https: 443,
            ftp: 21
        }, lr = a("$location"), ur = {
            $$html5: !1,
            $$replace: !1,
            absUrl: Tt("$$absUrl"),
            url: function(e) {
                if (_(e)) return this.$$url;
                var t = sr.exec(e);
                return (t[1] || "" === e) && this.path(decodeURIComponent(t[1])), (t[2] || t[1] || "" === e) && this.search(t[3] || ""), 
                this.hash(t[5] || ""), this;
            },
            protocol: Tt("$$protocol"),
            host: Tt("$$host"),
            port: Tt("$$port"),
            path: St("$$path", function(e) {
                return e = null !== e ? e.toString() : "", "/" == e.charAt(0) ? e : "/" + e;
            }),
            search: function(e, t) {
                switch (arguments.length) {
                  case 0:
                    return this.$$search;

                  case 1:
                    if (y(e) || M(e)) e = e.toString(), this.$$search = B(e); else {
                        if (!b(e)) throw lr("isrcharg", "The first argument of the `$location#search()` call must be a string or an object.");
                        e = O(e, {}), i(e, function(t, n) {
                            null == t && delete e[n];
                        }), this.$$search = e;
                    }
                    break;

                  default:
                    _(t) || null === t ? delete this.$$search[e] : this.$$search[e] = t;
                }
                return this.$$compose(), this;
            },
            hash: St("$$hash", function(e) {
                return null !== e ? e.toString() : "";
            }),
            replace: function() {
                return this.$$replace = !0, this;
            }
        };
        i([ Yt, Dt, Lt ], function(e) {
            e.prototype = Object.create(ur), e.prototype.state = function(t) {
                if (!arguments.length) return this.$$state;
                if (e !== Lt || !this.$$html5) throw lr("nostate", "History API state support is available only in HTML5 mode and only in browsers supporting HTML5 History API");
                return this.$$state = _(t) ? null : t, this;
            };
        });
        var cr = a("$parse"), dr = Function.prototype.call, mr = Function.prototype.apply, fr = Function.prototype.bind, pr = ue();
        i({
            null: function() {
                return null;
            },
            true: function() {
                return !0;
            },
            false: function() {
                return !1;
            },
            undefined: function() {}
        }, function(e, t) {
            e.constant = e.literal = e.sharedGetter = !0, pr[t] = e;
        }), pr.this = function(e) {
            return e;
        }, pr.this.sharedGetter = !0;
        var hr = d(ue(), {
            "+": function(e, t, a, r) {
                return a = a(e, t), r = r(e, t), v(a) ? v(r) ? a + r : a : v(r) ? r : n;
            },
            "-": function(e, t, n, a) {
                return n = n(e, t), a = a(e, t), (v(n) ? n : 0) - (v(a) ? a : 0);
            },
            "*": function(e, t, n, a) {
                return n(e, t) * a(e, t);
            },
            "/": function(e, t, n, a) {
                return n(e, t) / a(e, t);
            },
            "%": function(e, t, n, a) {
                return n(e, t) % a(e, t);
            },
            "===": function(e, t, n, a) {
                return n(e, t) === a(e, t);
            },
            "!==": function(e, t, n, a) {
                return n(e, t) !== a(e, t);
            },
            "==": function(e, t, n, a) {
                return n(e, t) == a(e, t);
            },
            "!=": function(e, t, n, a) {
                return n(e, t) != a(e, t);
            },
            "<": function(e, t, n, a) {
                return n(e, t) < a(e, t);
            },
            ">": function(e, t, n, a) {
                return n(e, t) > a(e, t);
            },
            "<=": function(e, t, n, a) {
                return n(e, t) <= a(e, t);
            },
            ">=": function(e, t, n, a) {
                return n(e, t) >= a(e, t);
            },
            "&&": function(e, t, n, a) {
                return n(e, t) && a(e, t);
            },
            "||": function(e, t, n, a) {
                return n(e, t) || a(e, t);
            },
            "!": function(e, t, n) {
                return !n(e, t);
            },
            "=": !0,
            "|": !0
        }), gr = {
            n: "\n",
            f: "\f",
            r: "\r",
            t: "\t",
            v: "\v",
            "'": "'",
            '"': '"'
        }, _r = function(e) {
            this.options = e;
        };
        _r.prototype = {
            constructor: _r,
            lex: function(e) {
                for (this.text = e, this.index = 0, this.tokens = []; this.index < this.text.length; ) {
                    var t = this.text.charAt(this.index);
                    if ('"' === t || "'" === t) this.readString(t); else if (this.isNumber(t) || "." === t && this.isNumber(this.peek())) this.readNumber(); else if (this.isIdent(t)) this.readIdent(); else if (this.is(t, "(){}[].,;:?")) this.tokens.push({
                        index: this.index,
                        text: t
                    }), this.index++; else if (this.isWhitespace(t)) this.index++; else {
                        var n = t + this.peek(), a = n + this.peek(2), r = hr[t], i = hr[n], s = hr[a];
                        if (r || i || s) {
                            var o = s ? a : i ? n : t;
                            this.tokens.push({
                                index: this.index,
                                text: o,
                                operator: !0
                            }), this.index += o.length;
                        } else this.throwError("Unexpected next character ", this.index, this.index + 1);
                    }
                }
                return this.tokens;
            },
            is: function(e, t) {
                return t.indexOf(e) !== -1;
            },
            peek: function(e) {
                var t = e || 1;
                return this.index + t < this.text.length && this.text.charAt(this.index + t);
            },
            isNumber: function(e) {
                return "0" <= e && e <= "9" && "string" == typeof e;
            },
            isWhitespace: function(e) {
                return " " === e || "\r" === e || "\t" === e || "\n" === e || "\v" === e || " " === e;
            },
            isIdent: function(e) {
                return "a" <= e && e <= "z" || "A" <= e && e <= "Z" || "_" === e || "$" === e;
            },
            isExpOperator: function(e) {
                return "-" === e || "+" === e || this.isNumber(e);
            },
            throwError: function(e, t, n) {
                n = n || this.index;
                var a = v(t) ? "s " + t + "-" + this.index + " [" + this.text.substring(t, n) + "]" : " " + n;
                throw cr("lexerr", "Lexer Error: {0} at column{1} in expression [{2}].", e, a, this.text);
            },
            readNumber: function() {
                for (var e = "", t = this.index; this.index < this.text.length; ) {
                    var n = Kn(this.text.charAt(this.index));
                    if ("." == n || this.isNumber(n)) e += n; else {
                        var a = this.peek();
                        if ("e" == n && this.isExpOperator(a)) e += n; else if (this.isExpOperator(n) && a && this.isNumber(a) && "e" == e.charAt(e.length - 1)) e += n; else {
                            if (!this.isExpOperator(n) || a && this.isNumber(a) || "e" != e.charAt(e.length - 1)) break;
                            this.throwError("Invalid exponent");
                        }
                    }
                    this.index++;
                }
                this.tokens.push({
                    index: t,
                    text: e,
                    constant: !0,
                    value: Number(e)
                });
            },
            readIdent: function() {
                for (var e = this.index; this.index < this.text.length; ) {
                    var t = this.text.charAt(this.index);
                    if (!this.isIdent(t) && !this.isNumber(t)) break;
                    this.index++;
                }
                this.tokens.push({
                    index: e,
                    text: this.text.slice(e, this.index),
                    identifier: !0
                });
            },
            readString: function(e) {
                var t = this.index;
                this.index++;
                for (var n = "", a = e, r = !1; this.index < this.text.length; ) {
                    var i = this.text.charAt(this.index);
                    if (a += i, r) {
                        if ("u" === i) {
                            var s = this.text.substring(this.index + 1, this.index + 5);
                            s.match(/[\da-f]{4}/i) || this.throwError("Invalid unicode escape [\\u" + s + "]"), 
                            this.index += 4, n += String.fromCharCode(parseInt(s, 16));
                        } else {
                            var o = gr[i];
                            n += o || i;
                        }
                        r = !1;
                    } else if ("\\" === i) r = !0; else {
                        if (i === e) return this.index++, void this.tokens.push({
                            index: t,
                            text: a,
                            constant: !0,
                            value: n
                        });
                        n += i;
                    }
                    this.index++;
                }
                this.throwError("Unterminated quote", t);
            }
        };
        var vr = function(e, t, n) {
            this.lexer = e, this.$filter = t, this.options = n;
        };
        vr.ZERO = d(function() {
            return 0;
        }, {
            sharedGetter: !0,
            constant: !0
        }), vr.prototype = {
            constructor: vr,
            parse: function(e) {
                this.text = e, this.tokens = this.lexer.lex(e);
                var t = this.statements();
                return 0 !== this.tokens.length && this.throwError("is an unexpected token", this.tokens[0]), 
                t.literal = !!t.literal, t.constant = !!t.constant, t;
            },
            primary: function() {
                var e;
                this.expect("(") ? (e = this.filterChain(), this.consume(")")) : this.expect("[") ? e = this.arrayDeclaration() : this.expect("{") ? e = this.object() : this.peek().identifier && this.peek().text in pr ? e = pr[this.consume().text] : this.peek().identifier ? e = this.identifier() : this.peek().constant ? e = this.constant() : this.throwError("not a primary expression", this.peek());
                for (var t, n; t = this.expect("(", "[", "."); ) "(" === t.text ? (e = this.functionCall(e, n), 
                n = null) : "[" === t.text ? (n = e, e = this.objectIndex(e)) : "." === t.text ? (n = e, 
                e = this.fieldAccess(e)) : this.throwError("IMPOSSIBLE");
                return e;
            },
            throwError: function(e, t) {
                throw cr("syntax", "Syntax Error: Token '{0}' {1} at column {2} of the expression [{3}] starting at [{4}].", t.text, e, t.index + 1, this.text, this.text.substring(t.index));
            },
            peekToken: function() {
                if (0 === this.tokens.length) throw cr("ueoe", "Unexpected end of expression: {0}", this.text);
                return this.tokens[0];
            },
            peek: function(e, t, n, a) {
                return this.peekAhead(0, e, t, n, a);
            },
            peekAhead: function(e, t, n, a, r) {
                if (this.tokens.length > e) {
                    var i = this.tokens[e], s = i.text;
                    if (s === t || s === n || s === a || s === r || !t && !n && !a && !r) return i;
                }
                return !1;
            },
            expect: function(e, t, n, a) {
                var r = this.peek(e, t, n, a);
                return !!r && (this.tokens.shift(), r);
            },
            consume: function(e) {
                if (0 === this.tokens.length) throw cr("ueoe", "Unexpected end of expression: {0}", this.text);
                var t = this.expect(e);
                return t || this.throwError("is unexpected, expecting [" + e + "]", this.peek()), 
                t;
            },
            unaryFn: function(e, t) {
                var n = hr[e];
                return d(function(e, a) {
                    return n(e, a, t);
                }, {
                    constant: t.constant,
                    inputs: [ t ]
                });
            },
            binaryFn: function(e, t, n, a) {
                var r = hr[t];
                return d(function(t, a) {
                    return r(t, a, e, n);
                }, {
                    constant: e.constant && n.constant,
                    inputs: !a && [ e, n ]
                });
            },
            identifier: function() {
                for (var e = this.consume().text; this.peek(".") && this.peekAhead(1).identifier && !this.peekAhead(2, "("); ) e += this.consume().text + this.consume().text;
                return Nt(e, this.options, this.text);
            },
            constant: function() {
                var e = this.consume().value;
                return d(function() {
                    return e;
                }, {
                    constant: !0,
                    literal: !0
                });
            },
            statements: function() {
                for (var e = []; ;) if (this.tokens.length > 0 && !this.peek("}", ")", ";", "]") && e.push(this.filterChain()), 
                !this.expect(";")) return 1 === e.length ? e[0] : function(t, n) {
                    for (var a, r = 0, i = e.length; r < i; r++) a = e[r](t, n);
                    return a;
                };
            },
            filterChain: function() {
                for (var e, t = this.expression(); e = this.expect("|"); ) t = this.filter(t);
                return t;
            },
            filter: function(e) {
                var t, a, r = this.$filter(this.consume().text);
                if (this.peek(":")) for (t = [], a = []; this.expect(":"); ) t.push(this.expression());
                var i = [ e ].concat(t || []);
                return d(function(i, s) {
                    var o = e(i, s);
                    if (a) {
                        a[0] = o;
                        for (var l = t.length; l--; ) a[l + 1] = t[l](i, s);
                        return r.apply(n, a);
                    }
                    return r(o);
                }, {
                    constant: !r.$stateful && i.every(Ot),
                    inputs: !r.$stateful && i
                });
            },
            expression: function() {
                return this.assignment();
            },
            assignment: function() {
                var e, t, n = this.ternary();
                return (t = this.expect("=")) ? (n.assign || this.throwError("implies assignment but [" + this.text.substring(0, t.index) + "] can not be assigned to", t), 
                e = this.ternary(), d(function(t, a) {
                    return n.assign(t, e(t, a), a);
                }, {
                    inputs: [ n, e ]
                })) : n;
            },
            ternary: function() {
                var e, t, n = this.logicalOR();
                if ((t = this.expect("?")) && (e = this.assignment(), this.consume(":"))) {
                    var a = this.assignment();
                    return d(function(t, r) {
                        return n(t, r) ? e(t, r) : a(t, r);
                    }, {
                        constant: n.constant && e.constant && a.constant
                    });
                }
                return n;
            },
            logicalOR: function() {
                for (var e, t = this.logicalAND(); e = this.expect("||"); ) t = this.binaryFn(t, e.text, this.logicalAND(), !0);
                return t;
            },
            logicalAND: function() {
                for (var e, t = this.equality(); e = this.expect("&&"); ) t = this.binaryFn(t, e.text, this.equality(), !0);
                return t;
            },
            equality: function() {
                for (var e, t = this.relational(); e = this.expect("==", "!=", "===", "!=="); ) t = this.binaryFn(t, e.text, this.relational());
                return t;
            },
            relational: function() {
                for (var e, t = this.additive(); e = this.expect("<", ">", "<=", ">="); ) t = this.binaryFn(t, e.text, this.additive());
                return t;
            },
            additive: function() {
                for (var e, t = this.multiplicative(); e = this.expect("+", "-"); ) t = this.binaryFn(t, e.text, this.multiplicative());
                return t;
            },
            multiplicative: function() {
                for (var e, t = this.unary(); e = this.expect("*", "/", "%"); ) t = this.binaryFn(t, e.text, this.unary());
                return t;
            },
            unary: function() {
                var e;
                return this.expect("+") ? this.primary() : (e = this.expect("-")) ? this.binaryFn(vr.ZERO, e.text, this.unary()) : (e = this.expect("!")) ? this.unaryFn(e.text, this.unary()) : this.primary();
            },
            fieldAccess: function(e) {
                var t = this.identifier();
                return d(function(a, r, i) {
                    var s = i || e(a, r);
                    return null == s ? n : t(s);
                }, {
                    assign: function(n, a, r) {
                        var i = e(n, r);
                        return i || e.assign(n, i = {}, r), t.assign(i, a);
                    }
                });
            },
            objectIndex: function(e) {
                var t = this.text, a = this.expression();
                return this.consume("]"), d(function(r, i) {
                    var s, o = e(r, i), l = Ht(a(r, i), t);
                    return Et(l, t), o ? s = At(o[l], t) : n;
                }, {
                    assign: function(n, r, i) {
                        var s = Et(Ht(a(n, i), t), t), o = At(e(n, i), t);
                        return o || e.assign(n, o = {}, i), o[s] = r;
                    }
                });
            },
            functionCall: function(e, t) {
                var a = [];
                if (")" !== this.peekToken().text) do a.push(this.expression()); while (this.expect(","));
                this.consume(")");
                var r = this.text, i = a.length ? [] : null;
                return function(s, o) {
                    var l = t ? t(s, o) : v(t) ? n : s, u = e(s, o, l) || p;
                    if (i) for (var c = a.length; c--; ) i[c] = At(a[c](s, o), r);
                    At(l, r), jt(u, r);
                    var d = u.apply ? u.apply(l, i) : u(i[0], i[1], i[2], i[3], i[4]);
                    return i && (i.length = 0), At(d, r);
                };
            },
            arrayDeclaration: function() {
                var e = [];
                if ("]" !== this.peekToken().text) do {
                    if (this.peek("]")) break;
                    e.push(this.expression());
                } while (this.expect(","));
                return this.consume("]"), d(function(t, n) {
                    for (var a = [], r = 0, i = e.length; r < i; r++) a.push(e[r](t, n));
                    return a;
                }, {
                    literal: !0,
                    constant: e.every(Ot),
                    inputs: e
                });
            },
            object: function() {
                var e = [], t = [];
                if ("}" !== this.peekToken().text) do {
                    if (this.peek("}")) break;
                    var n = this.consume();
                    n.constant ? e.push(n.value) : n.identifier ? e.push(n.text) : this.throwError("invalid key", n), 
                    this.consume(":"), t.push(this.expression());
                } while (this.expect(","));
                return this.consume("}"), d(function(n, a) {
                    for (var r = {}, i = 0, s = t.length; i < s; i++) r[e[i]] = t[i](n, a);
                    return r;
                }, {
                    literal: !0,
                    constant: t.every(Ot),
                    inputs: t
                });
            }
        };
        var br = ue(), yr = ue(), Mr = Object.prototype.valueOf, $r = a("$sce"), kr = {
            HTML: "html",
            CSS: "css",
            URL: "url",
            RESOURCE_URL: "resourceUrl",
            JS: "js"
        }, Qa = a("$compile"), wr = t.createElement("a"), Lr = rn(e.location.href);
        ln.$inject = [ "$provide" ], mn.$inject = [ "$locale" ], fn.$inject = [ "$locale" ];
        var Dr = ".", Yr = {
            yyyy: gn("FullYear", 4),
            yy: gn("FullYear", 2, 0, !0),
            y: gn("FullYear", 1),
            MMMM: _n("Month"),
            MMM: _n("Month", !0),
            MM: gn("Month", 2, 1),
            M: gn("Month", 1, 1),
            dd: gn("Date", 2),
            d: gn("Date", 1),
            HH: gn("Hours", 2),
            H: gn("Hours", 1),
            hh: gn("Hours", 2, -12),
            h: gn("Hours", 1, -12),
            mm: gn("Minutes", 2),
            m: gn("Minutes", 1),
            ss: gn("Seconds", 2),
            s: gn("Seconds", 1),
            sss: gn("Milliseconds", 3),
            EEEE: _n("Day"),
            EEE: _n("Day", !0),
            a: $n,
            Z: vn,
            ww: Mn(2),
            w: Mn(1),
            G: kn,
            GG: kn,
            GGG: kn,
            GGGG: wn
        }, Tr = /((?:[^yMdHhmsaZEwG']+)|(?:'(?:[^']|'')*')|(?:E+|y+|M+|d+|H+|h+|m+|s+|a|Z|G+|w+))(.*)/, Sr = /^\-?\d+$/;
        Ln.$inject = [ "$locale" ];
        var xr = g(Kn), Cr = g(Zn);
        Tn.$inject = [ "$parse" ];
        var Er = g({
            restrict: "E",
            compile: function(e, t) {
                if (!t.href && !t.xlinkHref && !t.name) return function(e, t) {
                    if ("a" === t[0].nodeName.toLowerCase()) {
                        var n = "[object SVGAnimatedString]" === la.call(t.prop("href")) ? "xlink:href" : "href";
                        t.on("click", function(e) {
                            t.attr(n) || e.preventDefault();
                        });
                    }
                };
            }
        }), Hr = {};
        i(Na, function(e, t) {
            if ("multiple" != e) {
                var n = Ze("ng-" + t);
                Hr[n] = function() {
                    return {
                        restrict: "A",
                        priority: 100,
                        link: function(e, a, r) {
                            e.$watch(r[n], function(e) {
                                r.$set(t, !!e);
                            });
                        }
                    };
                };
            }
        }), i(Wa, function(e, t) {
            Hr[t] = function() {
                return {
                    priority: 100,
                    link: function(e, n, a) {
                        if ("ngPattern" === t && "/" == a.ngPattern.charAt(0)) {
                            var r = a.ngPattern.match(Gn);
                            if (r) return void a.$set("ngPattern", new RegExp(r[1], r[2]));
                        }
                        e.$watch(a[t], function(e) {
                            a.$set(t, e);
                        });
                    }
                };
            };
        }), i([ "src", "srcset", "href" ], function(e) {
            var t = Ze("ng-" + e);
            Hr[t] = function() {
                return {
                    priority: 99,
                    link: function(n, a, r) {
                        var i = e, s = e;
                        "href" === e && "[object SVGAnimatedString]" === la.call(a.prop("href")) && (s = "xlinkHref", 
                        r.$attr[s] = "xlink:href", i = null), r.$observe(t, function(t) {
                            return t ? (r.$set(s, t), void (ta && i && a.prop(i, r[s]))) : void ("href" === e && r.$set(s, null));
                        });
                    }
                };
            };
        });
        var Ar = {
            $addControl: p,
            $$renameControl: xn,
            $removeControl: p,
            $setValidity: p,
            $setDirty: p,
            $setPristine: p,
            $setSubmitted: p
        }, jr = "ng-submitted";
        Cn.$inject = [ "$element", "$attrs", "$scope", "$animate", "$interpolate" ];
        var Or = function(e) {
            return [ "$timeout", function(t) {
                var a = {
                    name: "form",
                    restrict: e ? "EAC" : "E",
                    controller: Cn,
                    compile: function(a, r) {
                        a.addClass(gi).addClass(pi);
                        var i = r.name ? "name" : !(!e || !r.ngForm) && "ngForm";
                        return {
                            pre: function(e, a, r, s) {
                                if (!("action" in r)) {
                                    var o = function(t) {
                                        e.$apply(function() {
                                            s.$commitViewValue(), s.$setSubmitted();
                                        }), t.preventDefault();
                                    };
                                    Sa(a[0], "submit", o), a.on("$destroy", function() {
                                        t(function() {
                                            xa(a[0], "submit", o);
                                        }, 0, !1);
                                    });
                                }
                                var l = s.$$parentForm;
                                i && (It(e, null, s.$name, s, s.$name), r.$observe(i, function(t) {
                                    s.$name !== t && (It(e, null, s.$name, n, s.$name), l.$$renameControl(s, t), It(e, null, s.$name, s, s.$name));
                                })), a.on("$destroy", function() {
                                    l.$removeControl(s), i && It(e, null, r[i], n, s.$name), d(s, Ar);
                                });
                            }
                        };
                    }
                };
                return a;
            } ];
        }, Ir = Or(), Pr = Or(!0), Fr = /\d{4}-[01]\d-[0-3]\dT[0-2]\d:[0-5]\d:[0-5]\d\.\d+([+-][0-2]\d:[0-5]\d|Z)/, Ur = /^(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?$/, Nr = /^[a-z0-9!#$%&'*+\/=?^_`{|}~.-]+@[a-z0-9]([a-z0-9-]*[a-z0-9])?(\.[a-z0-9]([a-z0-9-]*[a-z0-9])?)*$/i, Vr = /^\s*(\-|\+)?(\d+|(\d*(\.\d*)))\s*$/, Wr = /^(\d{4})-(\d{2})-(\d{2})$/, qr = /^(\d{4})-(\d\d)-(\d\d)T(\d\d):(\d\d)(?::(\d\d)(\.\d{1,3})?)?$/, Rr = /^(\d{4})-W(\d\d)$/, zr = /^(\d{4})-(\d\d)$/, Br = /^(\d\d):(\d\d)(?::(\d\d)(\.\d{1,3})?)?$/, Gr = {
            text: Hn,
            date: In("date", Wr, On(Wr, [ "yyyy", "MM", "dd" ]), "yyyy-MM-dd"),
            "datetime-local": In("datetimelocal", qr, On(qr, [ "yyyy", "MM", "dd", "HH", "mm", "ss", "sss" ]), "yyyy-MM-ddTHH:mm:ss.sss"),
            time: In("time", Br, On(Br, [ "HH", "mm", "ss", "sss" ]), "HH:mm:ss.sss"),
            week: In("week", Rr, jn, "yyyy-Www"),
            month: In("month", zr, On(zr, [ "yyyy", "MM" ]), "yyyy-MM"),
            number: Fn,
            url: Un,
            email: Nn,
            radio: Vn,
            checkbox: qn,
            hidden: p,
            button: p,
            submit: p,
            reset: p,
            file: p
        }, Jr = [ "$browser", "$sniffer", "$filter", "$parse", function(e, t, n, a) {
            return {
                restrict: "E",
                require: [ "?ngModel" ],
                link: {
                    pre: function(r, i, s, o) {
                        o[0] && (Gr[Kn(s.type)] || Gr.text)(r, i, s, o[0], t, e, n, a);
                    }
                }
            };
        } ], Kr = /^(true|false|\d+)$/, Qr = function() {
            return {
                restrict: "A",
                priority: 100,
                compile: function(e, t) {
                    return Kr.test(t.ngValue) ? function(e, t, n) {
                        n.$set("value", e.$eval(n.ngValue));
                    } : function(e, t, n) {
                        e.$watch(n.ngValue, function(e) {
                            n.$set("value", e);
                        });
                    };
                }
            };
        }, Zr = [ "$compile", function(e) {
            return {
                restrict: "AC",
                compile: function(t) {
                    return e.$$addBindingClass(t), function(t, a, r) {
                        e.$$addBindingInfo(a, r.ngBind), a = a[0], t.$watch(r.ngBind, function(e) {
                            a.textContent = e === n ? "" : e;
                        });
                    };
                }
            };
        } ], Xr = [ "$interpolate", "$compile", function(e, t) {
            return {
                compile: function(a) {
                    return t.$$addBindingClass(a), function(a, r, i) {
                        var s = e(r.attr(i.$attr.ngBindTemplate));
                        t.$$addBindingInfo(r, s.expressions), r = r[0], i.$observe("ngBindTemplate", function(e) {
                            r.textContent = e === n ? "" : e;
                        });
                    };
                }
            };
        } ], ei = [ "$sce", "$parse", "$compile", function(e, t, n) {
            return {
                restrict: "A",
                compile: function(a, r) {
                    var i = t(r.ngBindHtml), s = t(r.ngBindHtml, function(e) {
                        return (e || "").toString();
                    });
                    return n.$$addBindingClass(a), function(t, a, r) {
                        n.$$addBindingInfo(a, r.ngBindHtml), t.$watch(s, function() {
                            a.html(e.getTrustedHtml(i(t)) || "");
                        });
                    };
                }
            };
        } ], ti = g({
            restrict: "A",
            require: "ngModel",
            link: function(e, t, n, a) {
                a.$viewChangeListeners.push(function() {
                    e.$eval(n.ngChange);
                });
            }
        }), ni = Rn("", !0), ai = Rn("Odd", 0), ri = Rn("Even", 1), ii = Sn({
            compile: function(e, t) {
                t.$set("ngCloak", n), e.removeClass("ng-cloak");
            }
        }), si = [ function() {
            return {
                restrict: "A",
                scope: !0,
                controller: "@",
                priority: 500
            };
        } ], oi = {}, li = {
            blur: !0,
            focus: !0
        };
        i("click dblclick mousedown mouseup mouseover mouseout mousemove mouseenter mouseleave keydown keyup keypress submit focus blur copy cut paste".split(" "), function(e) {
            var t = Ze("ng-" + e);
            oi[t] = [ "$parse", "$rootScope", function(n, a) {
                return {
                    restrict: "A",
                    compile: function(r, i) {
                        var s = n(i[t], null, !0);
                        return function(t, n) {
                            n.on(e, function(n) {
                                var r = function() {
                                    s(t, {
                                        $event: n
                                    });
                                };
                                li[e] && a.$$phase ? t.$evalAsync(r) : t.$apply(r);
                            });
                        };
                    }
                };
            } ];
        });
        var ui = [ "$animate", function(e) {
            return {
                multiElement: !0,
                transclude: "element",
                priority: 600,
                terminal: !0,
                restrict: "A",
                $$tlb: !0,
                link: function(n, a, r, i, s) {
                    var o, l, u;
                    n.$watch(r.ngIf, function(n) {
                        n ? l || s(function(n, i) {
                            l = i, n[n.length++] = t.createComment(" end ngIf: " + r.ngIf + " "), o = {
                                clone: n
                            }, e.enter(n, a.parent(), a);
                        }) : (u && (u.remove(), u = null), l && (l.$destroy(), l = null), o && (u = le(o.clone), 
                        e.leave(u).then(function() {
                            u = null;
                        }), o = null));
                    });
                }
            };
        } ], ci = [ "$templateRequest", "$anchorScroll", "$animate", function(e, t, n) {
            return {
                restrict: "ECA",
                priority: 400,
                terminal: !0,
                transclude: "element",
                controller: ca.noop,
                compile: function(a, r) {
                    var i = r.ngInclude || r.src, s = r.onload || "", o = r.autoscroll;
                    return function(a, r, l, u, c) {
                        var d, m, f, p = 0, h = function() {
                            m && (m.remove(), m = null), d && (d.$destroy(), d = null), f && (n.leave(f).then(function() {
                                m = null;
                            }), m = f, f = null);
                        };
                        a.$watch(i, function(i) {
                            var l = function() {
                                !v(o) || o && !a.$eval(o) || t();
                            }, m = ++p;
                            i ? (e(i, !0).then(function(e) {
                                if (m === p) {
                                    var t = a.$new();
                                    u.template = e;
                                    var o = c(t, function(e) {
                                        h(), n.enter(e, null, r).then(l);
                                    });
                                    d = t, f = o, d.$emit("$includeContentLoaded", i), a.$eval(s);
                                }
                            }, function() {
                                m === p && (h(), a.$emit("$includeContentError", i));
                            }), a.$emit("$includeContentRequested", i)) : (h(), u.template = null);
                        });
                    };
                }
            };
        } ], di = [ "$compile", function(e) {
            return {
                restrict: "ECA",
                priority: -400,
                require: "ngInclude",
                link: function(n, a, r, i) {
                    return /SVG/.test(a[0].toString()) ? (a.empty(), void e(ve(i.template, t).childNodes)(n, function(e) {
                        a.append(e);
                    }, {
                        futureParentElement: a
                    })) : (a.html(i.template), void e(a.contents())(n));
                }
            };
        } ], mi = Sn({
            priority: 450,
            compile: function() {
                return {
                    pre: function(e, t, n) {
                        e.$eval(n.ngInit);
                    }
                };
            }
        }), fi = function() {
            return {
                restrict: "A",
                priority: 100,
                require: "ngModel",
                link: function(e, t, a, r) {
                    var s = t.attr(a.$attr.ngList) || ", ", o = "false" !== a.ngTrim, l = o ? pa(s) : s, u = function(e) {
                        if (!_(e)) {
                            var t = [];
                            return e && i(e.split(l), function(e) {
                                e && t.push(o ? pa(e) : e);
                            }), t;
                        }
                    };
                    r.$parsers.push(u), r.$formatters.push(function(e) {
                        return fa(e) ? e.join(s) : n;
                    }), r.$isEmpty = function(e) {
                        return !e || !e.length;
                    };
                }
            };
        }, pi = "ng-valid", hi = "ng-invalid", gi = "ng-pristine", _i = "ng-dirty", vi = "ng-untouched", bi = "ng-touched", yi = "ng-pending", Mi = a("ngModel"), $i = [ "$scope", "$exceptionHandler", "$attrs", "$element", "$parse", "$animate", "$timeout", "$rootScope", "$q", "$interpolate", function(e, t, a, r, s, o, l, u, c, d) {
            this.$viewValue = Number.NaN, this.$modelValue = Number.NaN, this.$$rawModelValue = n, 
            this.$validators = {}, this.$asyncValidators = {}, this.$parsers = [], this.$formatters = [], 
            this.$viewChangeListeners = [], this.$untouched = !0, this.$touched = !1, this.$pristine = !0, 
            this.$dirty = !1, this.$valid = !0, this.$invalid = !1, this.$error = {}, this.$$success = {}, 
            this.$pending = n, this.$name = d(a.name || "", !1)(e);
            var m, f = s(a.ngModel), h = f.assign, g = f, b = h, y = null, $ = this;
            this.$$setOptions = function(e) {
                if ($.$options = e, e && e.getterSetter) {
                    var t = s(a.ngModel + "()"), n = s(a.ngModel + "($$$p)");
                    g = function(e) {
                        var n = f(e);
                        return k(n) && (n = t(e)), n;
                    }, b = function(e, t) {
                        k(f(e)) ? n(e, {
                            $$$p: $.$modelValue
                        }) : h(e, $.$modelValue);
                    };
                } else if (!f.assign) throw Mi("nonassign", "Expression '{0}' is non-assignable. Element: {1}", a.ngModel, R(r));
            }, this.$render = p, this.$isEmpty = function(e) {
                return _(e) || "" === e || null === e || e !== e;
            };
            var w = r.inheritedData("$formController") || Ar, L = 0;
            zn({
                ctrl: this,
                $element: r,
                set: function(e, t) {
                    e[t] = !0;
                },
                unset: function(e, t) {
                    delete e[t];
                },
                parentForm: w,
                $animate: o
            }), this.$setPristine = function() {
                $.$dirty = !1, $.$pristine = !0, o.removeClass(r, _i), o.addClass(r, gi);
            }, this.$setDirty = function() {
                $.$dirty = !0, $.$pristine = !1, o.removeClass(r, gi), o.addClass(r, _i), w.$setDirty();
            }, this.$setUntouched = function() {
                $.$touched = !1, $.$untouched = !0, o.setClass(r, vi, bi);
            }, this.$setTouched = function() {
                $.$touched = !0, $.$untouched = !1, o.setClass(r, bi, vi);
            }, this.$rollbackViewValue = function() {
                l.cancel(y), $.$viewValue = $.$$lastCommittedViewValue, $.$render();
            }, this.$validate = function() {
                if (!M($.$modelValue) || !isNaN($.$modelValue)) {
                    var e = $.$$lastCommittedViewValue, t = $.$$rawModelValue, a = $.$valid, r = $.$modelValue, i = $.$options && $.$options.allowInvalid;
                    $.$$runValidators(t, e, function(e) {
                        i || a === e || ($.$modelValue = e ? t : n, $.$modelValue !== r && $.$$writeModelToScope());
                    });
                }
            }, this.$$runValidators = function(e, t, a) {
                function r() {
                    var e = $.$$parserName || "parse";
                    return m !== n ? (m || (i($.$validators, function(e, t) {
                        l(t, null);
                    }), i($.$asyncValidators, function(e, t) {
                        l(t, null);
                    })), l(e, m), m) : (l(e, null), !0);
                }
                function s() {
                    var n = !0;
                    return i($.$validators, function(a, r) {
                        var i = a(e, t);
                        n = n && i, l(r, i);
                    }), !!n || (i($.$asyncValidators, function(e, t) {
                        l(t, null);
                    }), !1);
                }
                function o() {
                    var a = [], r = !0;
                    i($.$asyncValidators, function(i, s) {
                        var o = i(e, t);
                        if (!C(o)) throw Mi("$asyncValidators", "Expected asynchronous validator to return a promise but got '{0}' instead.", o);
                        l(s, n), a.push(o.then(function() {
                            l(s, !0);
                        }, function(e) {
                            r = !1, l(s, !1);
                        }));
                    }), a.length ? c.all(a).then(function() {
                        u(r);
                    }, p) : u(!0);
                }
                function l(e, t) {
                    d === L && $.$setValidity(e, t);
                }
                function u(e) {
                    d === L && a(e);
                }
                L++;
                var d = L;
                return r() && s() ? void o() : void u(!1);
            }, this.$commitViewValue = function() {
                var e = $.$viewValue;
                l.cancel(y), ($.$$lastCommittedViewValue !== e || "" === e && $.$$hasNativeValidators) && ($.$$lastCommittedViewValue = e, 
                $.$pristine && this.$setDirty(), this.$$parseAndValidate());
            }, this.$$parseAndValidate = function() {
                function t() {
                    $.$modelValue !== s && $.$$writeModelToScope();
                }
                var a = $.$$lastCommittedViewValue, r = a;
                if (m = !_(r) || n) for (var i = 0; i < $.$parsers.length; i++) if (r = $.$parsers[i](r), 
                _(r)) {
                    m = !1;
                    break;
                }
                M($.$modelValue) && isNaN($.$modelValue) && ($.$modelValue = g(e));
                var s = $.$modelValue, o = $.$options && $.$options.allowInvalid;
                $.$$rawModelValue = r, o && ($.$modelValue = r, t()), $.$$runValidators(r, $.$$lastCommittedViewValue, function(e) {
                    o || ($.$modelValue = e ? r : n, t());
                });
            }, this.$$writeModelToScope = function() {
                b(e, $.$modelValue), i($.$viewChangeListeners, function(e) {
                    try {
                        e();
                    } catch (e) {
                        t(e);
                    }
                });
            }, this.$setViewValue = function(e, t) {
                $.$viewValue = e, $.$options && !$.$options.updateOnDefault || $.$$debounceViewValueCommit(t);
            }, this.$$debounceViewValueCommit = function(t) {
                var n, a = 0, r = $.$options;
                r && v(r.debounce) && (n = r.debounce, M(n) ? a = n : M(n[t]) ? a = n[t] : M(n.default) && (a = n.default)), 
                l.cancel(y), a ? y = l(function() {
                    $.$commitViewValue();
                }, a) : u.$$phase ? $.$commitViewValue() : e.$apply(function() {
                    $.$commitViewValue();
                });
            }, e.$watch(function() {
                var t = g(e);
                if (t !== $.$modelValue && ($.$modelValue === $.$modelValue || t === t)) {
                    $.$modelValue = $.$$rawModelValue = t, m = n;
                    for (var a = $.$formatters, r = a.length, i = t; r--; ) i = a[r](i);
                    $.$viewValue !== i && ($.$viewValue = $.$$lastCommittedViewValue = i, $.$render(), 
                    $.$$runValidators(t, i, p));
                }
                return t;
            });
        } ], ki = [ "$rootScope", function(e) {
            return {
                restrict: "A",
                require: [ "ngModel", "^?form", "^?ngModelOptions" ],
                controller: $i,
                priority: 1,
                compile: function(t) {
                    return t.addClass(gi).addClass(vi).addClass(pi), {
                        pre: function(e, t, n, a) {
                            var r = a[0], i = a[1] || Ar;
                            r.$$setOptions(a[2] && a[2].$options), i.$addControl(r), n.$observe("name", function(e) {
                                r.$name !== e && i.$$renameControl(r, e);
                            }), e.$on("$destroy", function() {
                                i.$removeControl(r);
                            });
                        },
                        post: function(t, n, a, r) {
                            var i = r[0];
                            i.$options && i.$options.updateOn && n.on(i.$options.updateOn, function(e) {
                                i.$$debounceViewValueCommit(e && e.type);
                            }), n.on("blur", function(n) {
                                i.$touched || (e.$$phase ? t.$evalAsync(i.$setTouched) : t.$apply(i.$setTouched));
                            });
                        }
                    };
                }
            };
        } ], wi = /(\s+|^)default(\s+|$)/, Li = function() {
            return {
                restrict: "A",
                controller: [ "$scope", "$attrs", function(e, t) {
                    var a = this;
                    this.$options = e.$eval(t.ngModelOptions), this.$options.updateOn !== n ? (this.$options.updateOnDefault = !1, 
                    this.$options.updateOn = pa(this.$options.updateOn.replace(wi, function() {
                        return a.$options.updateOnDefault = !0, " ";
                    }))) : this.$options.updateOnDefault = !0;
                } ]
            };
        }, Di = Sn({
            terminal: !0,
            priority: 1e3
        }), Yi = [ "$locale", "$interpolate", function(e, t) {
            var n = /{}/g, a = /^when(Minus)?(.+)$/;
            return {
                restrict: "EA",
                link: function(r, s, o) {
                    function l(e) {
                        s.text(e || "");
                    }
                    var u, c = o.count, d = o.$attr.when && s.attr(o.$attr.when), m = o.offset || 0, f = r.$eval(d) || {}, p = {}, h = t.startSymbol(), g = t.endSymbol(), _ = h + c + "-" + m + g, v = ca.noop;
                    i(o, function(e, t) {
                        var n = a.exec(t);
                        if (n) {
                            var r = (n[1] ? "-" : "") + Kn(n[2]);
                            f[r] = s.attr(o.$attr[t]);
                        }
                    }), i(f, function(e, a) {
                        p[a] = t(e.replace(n, _));
                    }), r.$watch(c, function(t) {
                        var n = parseFloat(t), a = isNaN(n);
                        a || n in f || (n = e.pluralCat(n - m)), n === u || a && isNaN(u) || (v(), v = r.$watch(p[n], l), 
                        u = n);
                    });
                }
            };
        } ], Ti = [ "$parse", "$animate", function(e, s) {
            var o = "$$NG_REMOVED", l = a("ngRepeat"), u = function(e, t, n, a, r, i, s) {
                e[n] = a, r && (e[r] = i), e.$index = t, e.$first = 0 === t, e.$last = t === s - 1, 
                e.$middle = !(e.$first || e.$last), e.$odd = !(e.$even = 0 === (1 & t));
            }, c = function(e) {
                return e.clone[0];
            }, d = function(e) {
                return e.clone[e.clone.length - 1];
            };
            return {
                restrict: "A",
                multiElement: !0,
                transclude: "element",
                priority: 1e3,
                terminal: !0,
                $$tlb: !0,
                compile: function(a, m) {
                    var f = m.ngRepeat, p = t.createComment(" end ngRepeat: " + f + " "), h = f.match(/^\s*([\s\S]+?)\s+in\s+([\s\S]+?)(?:\s+as\s+([\s\S]+?))?(?:\s+track\s+by\s+([\s\S]+?))?\s*$/);
                    if (!h) throw l("iexp", "Expected expression in form of '_item_ in _collection_[ track by _id_]' but got '{0}'.", f);
                    var g = h[1], _ = h[2], v = h[3], b = h[4];
                    if (h = g.match(/^(?:(\s*[\$\w]+)|\(\s*([\$\w]+)\s*,\s*([\$\w]+)\s*\))$/), !h) throw l("iidexp", "'_item_' in '_item_ in _collection_' should be an identifier or '(_key_, _value_)' expression, but got '{0}'.", g);
                    var y = h[3] || h[1], M = h[2];
                    if (v && (!/^[$a-zA-Z_][$a-zA-Z0-9_]*$/.test(v) || /^(null|undefined|this|\$index|\$first|\$middle|\$last|\$even|\$odd|\$parent|\$root|\$id)$/.test(v))) throw l("badident", "alias '{0}' is invalid --- must be a valid JS identifier which is not a reserved name.", v);
                    var $, k, w, L, D = {
                        $id: Ue
                    };
                    return b ? $ = e(b) : (w = function(e, t) {
                        return Ue(t);
                    }, L = function(e) {
                        return e;
                    }), function(e, t, a, m, h) {
                        $ && (k = function(t, n, a) {
                            return M && (D[M] = t), D[y] = n, D.$index = a, $(e, D);
                        });
                        var g = ue();
                        e.$watchCollection(_, function(a) {
                            var m, _, b, $, D, Y, T, S, x, C, E, H, A = t[0], j = ue();
                            if (v && (e[v] = a), r(a)) x = a, S = k || w; else {
                                S = k || L, x = [];
                                for (var O in a) a.hasOwnProperty(O) && "$" != O.charAt(0) && x.push(O);
                                x.sort();
                            }
                            for ($ = x.length, E = new Array($), m = 0; m < $; m++) if (D = a === x ? m : x[m], 
                            Y = a[D], T = S(D, Y, m), g[T]) C = g[T], delete g[T], j[T] = C, E[m] = C; else {
                                if (j[T]) throw i(E, function(e) {
                                    e && e.scope && (g[e.id] = e);
                                }), l("dupes", "Duplicates in a repeater are not allowed. Use 'track by' expression to specify unique keys. Repeater: {0}, Duplicate key: {1}, Duplicate value: {2}", f, T, Y);
                                E[m] = {
                                    id: T,
                                    scope: n,
                                    clone: n
                                }, j[T] = !0;
                            }
                            for (var I in g) {
                                if (C = g[I], H = le(C.clone), s.leave(H), H[0].parentNode) for (m = 0, _ = H.length; m < _; m++) H[m][o] = !0;
                                C.scope.$destroy();
                            }
                            for (m = 0; m < $; m++) if (D = a === x ? m : x[m], Y = a[D], C = E[m], C.scope) {
                                b = A;
                                do b = b.nextSibling; while (b && b[o]);
                                c(C) != b && s.move(le(C.clone), null, na(A)), A = d(C), u(C.scope, m, y, Y, M, D, $);
                            } else h(function(e, t) {
                                C.scope = t;
                                var n = p.cloneNode(!1);
                                e[e.length++] = n, s.enter(e, null, na(A)), A = n, C.clone = e, j[C.id] = C, u(C.scope, m, y, Y, M, D, $);
                            });
                            g = j;
                        });
                    };
                }
            };
        } ], Si = "ng-hide", xi = "ng-hide-animate", Ci = [ "$animate", function(e) {
            return {
                restrict: "A",
                multiElement: !0,
                link: function(t, n, a) {
                    t.$watch(a.ngShow, function(t) {
                        e[t ? "removeClass" : "addClass"](n, Si, {
                            tempClasses: xi
                        });
                    });
                }
            };
        } ], Ei = [ "$animate", function(e) {
            return {
                restrict: "A",
                multiElement: !0,
                link: function(t, n, a) {
                    t.$watch(a.ngHide, function(t) {
                        e[t ? "addClass" : "removeClass"](n, Si, {
                            tempClasses: xi
                        });
                    });
                }
            };
        } ], Hi = Sn(function(e, t, n) {
            e.$watch(n.ngStyle, function(e, n) {
                n && e !== n && i(n, function(e, n) {
                    t.css(n, "");
                }), e && t.css(e);
            }, !0);
        }), Ai = [ "$animate", function(e) {
            return {
                restrict: "EA",
                require: "ngSwitch",
                controller: [ "$scope", function() {
                    this.cases = {};
                } ],
                link: function(n, a, r, s) {
                    var o = r.ngSwitch || r.on, l = [], u = [], c = [], d = [], m = function(e, t) {
                        return function() {
                            e.splice(t, 1);
                        };
                    };
                    n.$watch(o, function(n) {
                        var a, r;
                        for (a = 0, r = c.length; a < r; ++a) e.cancel(c[a]);
                        for (c.length = 0, a = 0, r = d.length; a < r; ++a) {
                            var o = le(u[a].clone);
                            d[a].$destroy();
                            var f = c[a] = e.leave(o);
                            f.then(m(c, a));
                        }
                        u.length = 0, d.length = 0, (l = s.cases["!" + n] || s.cases["?"]) && i(l, function(n) {
                            n.transclude(function(a, r) {
                                d.push(r);
                                var i = n.element;
                                a[a.length++] = t.createComment(" end ngSwitchWhen: ");
                                var s = {
                                    clone: a
                                };
                                u.push(s), e.enter(a, i.parent(), i);
                            });
                        });
                    });
                }
            };
        } ], ji = Sn({
            transclude: "element",
            priority: 1200,
            require: "^ngSwitch",
            multiElement: !0,
            link: function(e, t, n, a, r) {
                a.cases["!" + n.ngSwitchWhen] = a.cases["!" + n.ngSwitchWhen] || [], a.cases["!" + n.ngSwitchWhen].push({
                    transclude: r,
                    element: t
                });
            }
        }), Oi = Sn({
            transclude: "element",
            priority: 1200,
            require: "^ngSwitch",
            multiElement: !0,
            link: function(e, t, n, a, r) {
                a.cases["?"] = a.cases["?"] || [], a.cases["?"].push({
                    transclude: r,
                    element: t
                });
            }
        }), Ii = Sn({
            restrict: "EAC",
            link: function(e, t, n, r, i) {
                if (!i) throw a("ngTransclude")("orphan", "Illegal use of ngTransclude directive in the template! No parent directive that requires a transclusion found. Element: {0}", R(t));
                i(function(e) {
                    t.empty(), t.append(e);
                });
            }
        }), Pi = [ "$templateCache", function(e) {
            return {
                restrict: "E",
                terminal: !0,
                compile: function(t, n) {
                    if ("text/ng-template" == n.type) {
                        var a = n.id, r = t[0].text;
                        e.put(a, r);
                    }
                }
            };
        } ], Fi = a("ngOptions"), Ui = g({
            restrict: "A",
            terminal: !0
        }), Ni = [ "$compile", "$parse", function(e, a) {
            var r = /^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?(?:\s+group\s+by\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w]*)|(?:\(\s*([\$\w][\$\w]*)\s*,\s*([\$\w][\$\w]*)\s*\)))\s+in\s+([\s\S]+?)(?:\s+track\s+by\s+([\s\S]+?))?$/, o = {
                $setViewValue: p
            };
            return {
                restrict: "E",
                require: [ "select", "?ngModel" ],
                controller: [ "$element", "$scope", "$attrs", function(e, t, n) {
                    var a, r, i = this, s = {}, l = o;
                    i.databound = n.ngModel, i.init = function(e, t, n) {
                        l = e, a = t, r = n;
                    }, i.addOption = function(t, n) {
                        se(t, '"option value"'), s[t] = !0, l.$viewValue == t && (e.val(t), r.parent() && r.remove()), 
                        n && n[0].hasAttribute("selected") && (n[0].selected = !0);
                    }, i.removeOption = function(e) {
                        this.hasOption(e) && (delete s[e], l.$viewValue === e && this.renderUnknownOption(e));
                    }, i.renderUnknownOption = function(t) {
                        var n = "? " + Ue(t) + " ?";
                        r.val(n), e.prepend(r), e.val(n), r.prop("selected", !0);
                    }, i.hasOption = function(e) {
                        return s.hasOwnProperty(e);
                    }, t.$on("$destroy", function() {
                        i.renderUnknownOption = p;
                    });
                } ],
                link: function(o, l, u, c) {
                    function d(e, t, n, a) {
                        n.$render = function() {
                            var e = n.$viewValue;
                            a.hasOption(e) ? (w.parent() && w.remove(), t.val(e), "" === e && p.prop("selected", !0)) : null == e && p ? t.val("") : a.renderUnknownOption(e);
                        }, t.on("change", function() {
                            e.$apply(function() {
                                w.parent() && w.remove(), n.$setViewValue(t.val());
                            });
                        });
                    }
                    function m(e, t, n) {
                        var a;
                        n.$render = function() {
                            var e = new Ne(n.$viewValue);
                            i(t.find("option"), function(t) {
                                t.selected = v(e.get(t.value));
                            });
                        }, e.$watch(function() {
                            P(a, n.$viewValue) || (a = I(n.$viewValue), n.$render());
                        }), t.on("change", function() {
                            e.$apply(function() {
                                var e = [];
                                i(t.find("option"), function(t) {
                                    t.selected && e.push(t.value);
                                }), n.$setViewValue(e);
                            });
                        });
                    }
                    function f(t, o, l) {
                        function u(e, n, a) {
                            return P[Y] = a, x && (P[x] = n), e(t, P);
                        }
                        function c() {
                            t.$apply(function() {
                                var e, n = H(t) || [];
                                if (_) e = [], i(o.val(), function(t) {
                                    t = j ? O[t] : t, e.push(d(t, n[t]));
                                }); else {
                                    var a = j ? O[o.val()] : o.val();
                                    e = d(a, n[a]);
                                }
                                l.$setViewValue(e), w();
                            });
                        }
                        function d(e, t) {
                            if ("?" === e) return n;
                            if ("" === e) return null;
                            var a = S ? S : E;
                            return u(a, e, t);
                        }
                        function m() {
                            var e, n = H(t);
                            if (n && fa(n)) {
                                e = new Array(n.length);
                                for (var a = 0, r = n.length; a < r; a++) e[a] = u(D, a, n[a]);
                                return e;
                            }
                            if (n) {
                                e = {};
                                for (var i in n) n.hasOwnProperty(i) && (e[i] = u(D, i, n[i]));
                            }
                            return e;
                        }
                        function f(e) {
                            var t;
                            if (_) if (j && fa(e)) {
                                t = new Ne([]);
                                for (var n = 0; n < e.length; n++) t.put(u(j, null, e[n]), !0);
                            } else t = new Ne(e); else j && (e = u(j, null, e));
                            return function(n, a) {
                                var r;
                                return r = j ? j : S ? S : E, _ ? v(t.remove(u(r, n, a))) : e === u(r, n, a);
                            };
                        }
                        function p() {
                            M || (t.$$postDigest(w), M = !0);
                        }
                        function g(e, t, n) {
                            e[t] = e[t] || 0, e[t] += n ? 1 : -1;
                        }
                        function w() {
                            M = !1;
                            var e, n, a, r, c, d, m, p, b, w, L, Y, T, S, E, A, F, U = {
                                "": []
                            }, N = [ "" ], V = l.$viewValue, W = H(t) || [], q = x ? s(W) : W, R = {}, z = f(V), B = !1;
                            for (O = {}, Y = 0; w = q.length, Y < w; Y++) m = Y, x && (m = q[Y], "$" === m.charAt(0)) || (p = W[m], 
                            e = u(C, m, p) || "", (n = U[e]) || (n = U[e] = [], N.push(e)), T = z(m, p), B = B || T, 
                            A = u(D, m, p), A = v(A) ? A : "", F = j ? j(t, P) : x ? q[Y] : Y, j && (O[F] = m), 
                            n.push({
                                id: F,
                                label: A,
                                selected: T
                            }));
                            for (_ || (y || null === V ? U[""].unshift({
                                id: "",
                                label: "",
                                selected: !B
                            }) : B || U[""].unshift({
                                id: "?",
                                label: "",
                                selected: !0
                            })), L = 0, b = N.length; L < b; L++) {
                                for (e = N[L], n = U[e], I.length <= L ? (r = {
                                    element: k.clone().attr("label", e),
                                    label: n.label
                                }, c = [ r ], I.push(c), o.append(r.element)) : (c = I[L], r = c[0], r.label != e && r.element.attr("label", r.label = e)), 
                                S = null, Y = 0, w = n.length; Y < w; Y++) a = n[Y], (d = c[Y + 1]) ? (S = d.element, 
                                d.label !== a.label && (g(R, d.label, !1), g(R, a.label, !0), S.text(d.label = a.label), 
                                S.prop("label", d.label)), d.id !== a.id && S.val(d.id = a.id), S[0].selected !== a.selected && (S.prop("selected", d.selected = a.selected), 
                                ta && S.prop("selected", d.selected))) : ("" === a.id && y ? E = y : (E = $.clone()).val(a.id).prop("selected", a.selected).attr("selected", a.selected).prop("label", a.label).text(a.label), 
                                c.push(d = {
                                    element: E,
                                    label: a.label,
                                    id: a.id,
                                    selected: a.selected
                                }), g(R, a.label, !0), S ? S.after(E) : r.element.append(E), S = E);
                                for (Y++; c.length > Y; ) a = c.pop(), g(R, a.label, !1), a.element.remove();
                            }
                            for (;I.length > L; ) {
                                for (n = I.pop(), Y = 1; Y < n.length; ++Y) g(R, n[Y].label, !1);
                                n[0].element.remove();
                            }
                            i(R, function(e, t) {
                                e > 0 ? h.addOption(t) : e < 0 && h.removeOption(t);
                            });
                        }
                        var L;
                        if (!(L = b.match(r))) throw Fi("iexp", "Expected expression in form of '_select_ (as _label_)? for (_key_,)?_value_ in _collection_' but got '{0}'. Element: {1}", b, R(o));
                        var D = a(L[2] || L[1]), Y = L[4] || L[6], T = / as /.test(L[0]) && L[1], S = T ? a(T) : null, x = L[5], C = a(L[3] || ""), E = a(L[2] ? L[1] : Y), H = a(L[7]), A = L[8], j = A ? a(L[8]) : null, O = {}, I = [ [ {
                            element: o,
                            label: ""
                        } ] ], P = {};
                        y && (e(y)(t), y.removeClass("ng-scope"), y.remove()), o.empty(), o.on("change", c), 
                        l.$render = w, t.$watchCollection(H, p), t.$watchCollection(m, p), _ && t.$watchCollection(function() {
                            return l.$modelValue;
                        }, p);
                    }
                    if (c[1]) {
                        for (var p, h = c[0], g = c[1], _ = u.multiple, b = u.ngOptions, y = !1, M = !1, $ = na(t.createElement("option")), k = na(t.createElement("optgroup")), w = $.clone(), L = 0, D = l.children(), Y = D.length; L < Y; L++) if ("" === D[L].value) {
                            p = y = D.eq(L);
                            break;
                        }
                        h.init(g, y, w), _ && (g.$isEmpty = function(e) {
                            return !e || 0 === e.length;
                        }), b ? f(o, l, g) : _ ? m(o, l, g) : d(o, l, g, h);
                    }
                }
            };
        } ], Vi = [ "$interpolate", function(e) {
            var t = {
                addOption: p,
                removeOption: p
            };
            return {
                restrict: "E",
                priority: 100,
                compile: function(n, a) {
                    if (_(a.value)) {
                        var r = e(n.text(), !0);
                        r || a.$set("value", n.text());
                    }
                    return function(e, n, a) {
                        var i = "$selectController", s = n.parent(), o = s.data(i) || s.parent().data(i);
                        o && o.databound || (o = t), r ? e.$watch(r, function(e, t) {
                            a.$set("value", e), t !== e && o.removeOption(t), o.addOption(e, n);
                        }) : o.addOption(a.value, n), n.on("$destroy", function() {
                            o.removeOption(a.value);
                        });
                    };
                }
            };
        } ], Wi = g({
            restrict: "E",
            terminal: !1
        }), qi = function() {
            return {
                restrict: "A",
                require: "?ngModel",
                link: function(e, t, n, a) {
                    a && (n.required = !0, a.$validators.required = function(e, t) {
                        return !n.required || !a.$isEmpty(t);
                    }, n.$observe("required", function() {
                        a.$validate();
                    }));
                }
            };
        }, Ri = function() {
            return {
                restrict: "A",
                require: "?ngModel",
                link: function(e, t, r, i) {
                    if (i) {
                        var s, o = r.ngPattern || r.pattern;
                        r.$observe("pattern", function(e) {
                            if (y(e) && e.length > 0 && (e = new RegExp("^" + e + "$")), e && !e.test) throw a("ngPattern")("noregexp", "Expected {0} to be a RegExp but was {1}. Element: {2}", o, e, R(t));
                            s = e || n, i.$validate();
                        }), i.$validators.pattern = function(e, t) {
                            return i.$isEmpty(t) || _(s) || s.test(t);
                        };
                    }
                }
            };
        }, zi = function() {
            return {
                restrict: "A",
                require: "?ngModel",
                link: function(e, t, n, a) {
                    if (a) {
                        var r = -1;
                        n.$observe("maxlength", function(e) {
                            var t = m(e);
                            r = isNaN(t) ? -1 : t, a.$validate();
                        }), a.$validators.maxlength = function(e, t) {
                            return r < 0 || a.$isEmpty(t) || t.length <= r;
                        };
                    }
                }
            };
        }, Bi = function() {
            return {
                restrict: "A",
                require: "?ngModel",
                link: function(e, t, n, a) {
                    if (a) {
                        var r = 0;
                        n.$observe("minlength", function(e) {
                            r = m(e) || 0, a.$validate();
                        }), a.$validators.minlength = function(e, t) {
                            return a.$isEmpty(t) || t.length >= r;
                        };
                    }
                }
            };
        };
        return e.angular.bootstrap ? void console.log("WARNING: Tried to load angular more than once.") : (ae(), 
        fe(ca), void na(t).ready(function() {
            Z(t, X);
        }));
    }(window, document), !window.angular.$$csp() && window.angular.element(document.head).prepend('<style type="text/css">@charset "UTF-8";[ng\\:cloak],[ng-cloak],[data-ng-cloak],[x-ng-cloak],.ng-cloak,.x-ng-cloak,.ng-hide:not(.ng-hide-animate){display:none !important;}ng\\:form{display:block;}</style>'), 
    e.exports = angular;
}, function(e, t) {
    /**
	 * @license AngularJS v1.3.20
	 * (c) 2010-2014 Google, Inc. http://angularjs.org
	 * License: MIT
	 */
    !function(e, t, n) {
        "use strict";
        function a() {
            function e(e, n) {
                return t.extend(Object.create(e), n);
            }
            function n(e, t) {
                var n = t.caseInsensitiveMatch, a = {
                    originalPath: e,
                    regexp: e
                }, r = a.keys = [];
                return e = e.replace(/([().])/g, "\\$1").replace(/(\/)?:(\w+)([\?\*])?/g, function(e, t, n, a) {
                    var i = "?" === a ? a : null, s = "*" === a ? a : null;
                    return r.push({
                        name: n,
                        optional: !!i
                    }), t = t || "", "" + (i ? "" : t) + "(?:" + (i ? t : "") + (s && "(.+?)" || "([^/]+)") + (i || "") + ")" + (i || "");
                }).replace(/([\/$\*])/g, "\\$1"), a.regexp = new RegExp("^" + e + "$", n ? "i" : ""), 
                a;
            }
            var a = {};
            this.when = function(e, r) {
                var i = t.copy(r);
                if (t.isUndefined(i.reloadOnSearch) && (i.reloadOnSearch = !0), t.isUndefined(i.caseInsensitiveMatch) && (i.caseInsensitiveMatch = this.caseInsensitiveMatch), 
                a[e] = t.extend(i, e && n(e, i)), e) {
                    var s = "/" == e[e.length - 1] ? e.substr(0, e.length - 1) : e + "/";
                    a[s] = t.extend({
                        redirectTo: e
                    }, n(s, i));
                }
                return this;
            }, this.caseInsensitiveMatch = !1, this.otherwise = function(e) {
                return "string" == typeof e && (e = {
                    redirectTo: e
                }), this.when(null, e), this;
            }, this.$get = [ "$rootScope", "$location", "$routeParams", "$q", "$injector", "$templateRequest", "$sce", function(n, r, i, s, o, u, c) {
                function d(e, t) {
                    var n = t.keys, a = {};
                    if (!t.regexp) return null;
                    var r = t.regexp.exec(e);
                    if (!r) return null;
                    for (var i = 1, s = r.length; i < s; ++i) {
                        var o = n[i - 1], l = r[i];
                        o && l && (a[o.name] = l);
                    }
                    return a;
                }
                function m(e) {
                    var a = b.current;
                    g = p(), _ = g && a && g.$$route === a.$$route && t.equals(g.pathParams, a.pathParams) && !g.reloadOnSearch && !v, 
                    _ || !a && !g || n.$broadcast("$routeChangeStart", g, a).defaultPrevented && e && e.preventDefault();
                }
                function f() {
                    var e = b.current, a = g;
                    _ ? (e.params = a.params, t.copy(e.params, i), n.$broadcast("$routeUpdate", e)) : (a || e) && (v = !1, 
                    b.current = a, a && a.redirectTo && (t.isString(a.redirectTo) ? r.path(h(a.redirectTo, a.params)).search(a.params).replace() : r.url(a.redirectTo(a.pathParams, r.path(), r.search())).replace()), 
                    s.when(a).then(function() {
                        if (a) {
                            var e, n, r = t.extend({}, a.resolve);
                            return t.forEach(r, function(e, n) {
                                r[n] = t.isString(e) ? o.get(e) : o.invoke(e, null, null, n);
                            }), t.isDefined(e = a.template) ? t.isFunction(e) && (e = e(a.params)) : t.isDefined(n = a.templateUrl) && (t.isFunction(n) && (n = n(a.params)), 
                            t.isDefined(n) && (a.loadedTemplateUrl = c.valueOf(n), e = u(n))), t.isDefined(e) && (r.$template = e), 
                            s.all(r);
                        }
                    }).then(function(r) {
                        a == b.current && (a && (a.locals = r, t.copy(a.params, i)), n.$broadcast("$routeChangeSuccess", a, e));
                    }, function(t) {
                        a == b.current && n.$broadcast("$routeChangeError", a, e, t);
                    }));
                }
                function p() {
                    var n, i;
                    return t.forEach(a, function(a, s) {
                        !i && (n = d(r.path(), a)) && (i = e(a, {
                            params: t.extend({}, r.search(), n),
                            pathParams: n
                        }), i.$$route = a);
                    }), i || a[null] && e(a[null], {
                        params: {},
                        pathParams: {}
                    });
                }
                function h(e, n) {
                    var a = [];
                    return t.forEach((e || "").split(":"), function(e, t) {
                        if (0 === t) a.push(e); else {
                            var r = e.match(/(\w+)(?:[?*])?(.*)/), i = r[1];
                            a.push(n[i]), a.push(r[2] || ""), delete n[i];
                        }
                    }), a.join("");
                }
                var g, _, v = !1, b = {
                    routes: a,
                    reload: function() {
                        v = !0, n.$evalAsync(function() {
                            m(), f();
                        });
                    },
                    updateParams: function(e) {
                        if (!this.current || !this.current.$$route) throw l("norout", "Tried updating route when with no current route");
                        e = t.extend({}, this.current.params, e), r.path(h(this.current.$$route.originalPath, e)), 
                        r.search(e);
                    }
                };
                return n.$on("$locationChangeStart", m), n.$on("$locationChangeSuccess", f), b;
            } ];
        }
        function r() {
            this.$get = function() {
                return {};
            };
        }
        function i(e, n, a) {
            return {
                restrict: "ECA",
                terminal: !0,
                priority: 400,
                transclude: "element",
                link: function(r, i, s, o, l) {
                    function u() {
                        f && (a.cancel(f), f = null), d && (d.$destroy(), d = null), m && (f = a.leave(m), 
                        f.then(function() {
                            f = null;
                        }), m = null);
                    }
                    function c() {
                        var s = e.current && e.current.locals, o = s && s.$template;
                        if (t.isDefined(o)) {
                            var c = r.$new(), f = e.current, g = l(c, function(e) {
                                a.enter(e, null, m || i).then(function() {
                                    !t.isDefined(p) || p && !r.$eval(p) || n();
                                }), u();
                            });
                            m = g, d = f.scope = c, d.$emit("$viewContentLoaded"), d.$eval(h);
                        } else u();
                    }
                    var d, m, f, p = s.autoscroll, h = s.onload || "";
                    r.$on("$routeChangeSuccess", c), c();
                }
            };
        }
        function s(e, t, n) {
            return {
                restrict: "ECA",
                priority: -400,
                link: function(a, r) {
                    var i = n.current, s = i.locals;
                    r.html(s.$template);
                    var o = e(r.contents());
                    if (i.controller) {
                        s.$scope = a;
                        var l = t(i.controller, s);
                        i.controllerAs && (a[i.controllerAs] = l), r.data("$ngControllerController", l), 
                        r.children().data("$ngControllerController", l);
                    }
                    o(a);
                }
            };
        }
        var o = t.module("ngRoute", [ "ng" ]).provider("$route", a), l = t.$$minErr("ngRoute");
        o.provider("$routeParams", r), o.directive("ngView", i), o.directive("ngView", s), 
        i.$inject = [ "$route", "$anchorScroll", "$animate" ], s.$inject = [ "$compile", "$controller", "$route" ];
    }(window, window.angular);
}, function(e, t) {
    angular.module("gettext", []), angular.module("gettext").constant("gettext", function(e) {
        return e;
    }), angular.module("gettext").factory("gettextCatalog", [ "gettextPlurals", "gettextFallbackLanguage", "$http", "$cacheFactory", "$interpolate", "$rootScope", function(e, t, n, a, r, i) {
        function s() {
            i.$broadcast("gettextLanguageChanged");
        }
        var o, l = "$$noContext", u = '<span id="test" title="test" class="tested">test</span>', c = angular.element("<span>" + u + "</span>").html() !== u, d = function(e) {
            return o.debug && o.currentLanguage !== o.baseLanguage ? o.debugPrefix + e : e;
        }, m = function(e) {
            return o.showTranslatedMarkers ? o.translatedMarkerPrefix + e + o.translatedMarkerSuffix : e;
        };
        return o = {
            debug: !1,
            debugPrefix: "[MISSING]: ",
            showTranslatedMarkers: !1,
            translatedMarkerPrefix: "[",
            translatedMarkerSuffix: "]",
            strings: {},
            baseLanguage: "en",
            currentLanguage: "en",
            cache: a("strings"),
            setCurrentLanguage: function(e) {
                this.currentLanguage = e, s();
            },
            getCurrentLanguage: function() {
                return this.currentLanguage;
            },
            setStrings: function(t, n) {
                this.strings[t] || (this.strings[t] = {});
                var a = e(t, 1);
                for (var r in n) {
                    var i = n[r];
                    if (c && (r = angular.element("<span>" + r + "</span>").html()), angular.isString(i) || angular.isArray(i)) {
                        var o = {};
                        o[l] = i, i = o;
                    }
                    this.strings[t][r] || (this.strings[t][r] = {});
                    for (var u in i) {
                        var d = i[u];
                        angular.isArray(d) ? this.strings[t][r][u] = d : (this.strings[t][r][u] = [], this.strings[t][r][u][a] = d);
                    }
                }
                s();
            },
            getStringFormFor: function(t, n, a, r) {
                if (!t) return null;
                var i = this.strings[t] || {}, s = i[n] || {}, o = s[r || l] || [];
                return o[e(t, a)];
            },
            getString: function(e, n, a) {
                var i = t(this.currentLanguage);
                return e = this.getStringFormFor(this.currentLanguage, e, 1, a) || this.getStringFormFor(i, e, 1, a) || d(e), 
                e = n ? r(e)(n) : e, m(e);
            },
            getPlural: function(e, n, a, i, s) {
                var o = t(this.currentLanguage);
                return n = this.getStringFormFor(this.currentLanguage, n, e, s) || this.getStringFormFor(o, n, e, s) || d(1 === e ? n : a), 
                i && (i.$count = e, n = r(n)(i)), m(n);
            },
            loadRemote: function(e) {
                return n({
                    method: "GET",
                    url: e,
                    cache: o.cache
                }).then(function(e) {
                    var t = e.data;
                    for (var n in t) o.setStrings(n, t[n]);
                    return e;
                });
            }
        };
    } ]), angular.module("gettext").directive("translate", [ "gettextCatalog", "$parse", "$animate", "$compile", "$window", "gettextUtil", function(e, t, n, a, r, i) {
        function s(e) {
            return i.lcFirst(e.replace(u, ""));
        }
        function o(e, t, n) {
            var a = Object.keys(t).filter(function(e) {
                return i.startsWith(e, u) && e !== u;
            });
            if (!a.length) return null;
            var r = angular.extend({}, e), o = [];
            return a.forEach(function(a) {
                var i = e.$watch(t[a], function(e) {
                    var t = s(a);
                    r[t] = e, n(r);
                });
                o.push(i);
            }), e.$on("$destroy", function() {
                o.forEach(function(e) {
                    e();
                });
            }), r;
        }
        var l = parseInt((/msie (\d+)/.exec(angular.lowercase(r.navigator.userAgent)) || [])[1], 10), u = "translateParams";
        return {
            restrict: "AE",
            terminal: !0,
            compile: function(r, s) {
                i.assert(!s.translatePlural || s.translateN, "translate-n", "translate-plural"), 
                i.assert(!s.translateN || s.translatePlural, "translate-plural", "translate-n");
                var u = i.trim(r.html()), c = s.translatePlural, d = s.translateContext;
                return l <= 8 && "<!--IE fix-->" === u.slice(-13) && (u = u.slice(0, -13)), {
                    post: function(r, s, l) {
                        function m(t) {
                            t = t || null;
                            var o;
                            c ? (r = p || (p = r.$new()), r.$count = f(r), o = e.getPlural(r.$count, u, c, t, d)) : o = e.getString(u, t, d);
                            var l = s.contents();
                            if (l || o) {
                                if (o === i.trim(l.html())) return void (h && a(l)(r));
                                var m = angular.element("<span>" + o + "</span>");
                                a(m.contents())(r);
                                var g = m.contents();
                                n.enter(g, s), n.leave(l);
                            }
                        }
                        var f = t(l.translateN), p = null, h = !0, g = o(r, l, m);
                        m(g), h = !1, l.translateN && r.$watch(l.translateN, function() {
                            m(g);
                        }), r.$on("gettextLanguageChanged", function() {
                            m(g);
                        });
                    }
                };
            }
        };
    } ]), angular.module("gettext").factory("gettextFallbackLanguage", function() {
        var e = {}, t = /([^_]+)_[^_]+$/;
        return function(n) {
            if (e[n]) return e[n];
            var a = t.exec(n);
            return a ? (e[n] = a[1], a[1]) : null;
        };
    }), angular.module("gettext").filter("translate", [ "gettextCatalog", function(e) {
        function t(t, n) {
            return e.getString(t, null, n);
        }
        return t.$stateful = !0, t;
    } ]), angular.module("gettext").factory("gettextPlurals", function() {
        function e(e) {
            return t[e] || (t[e] = e.split(/\-|_/).shift()), t[e];
        }
        var t = {
            pt_BR: "pt_BR",
            "pt-BR": "pt_BR"
        };
        return function(t, n) {
            switch (e(t)) {
              case "ay":
              case "bo":
              case "cgg":
              case "dz":
              case "fa":
              case "id":
              case "ja":
              case "jbo":
              case "ka":
              case "kk":
              case "km":
              case "ko":
              case "ky":
              case "lo":
              case "ms":
              case "my":
              case "sah":
              case "su":
              case "th":
              case "tt":
              case "ug":
              case "vi":
              case "wo":
              case "zh":
                return 0;

              case "is":
                return n % 10 != 1 || n % 100 == 11 ? 1 : 0;

              case "jv":
                return 0 != n ? 1 : 0;

              case "mk":
                return 1 == n || n % 10 == 1 ? 0 : 1;

              case "ach":
              case "ak":
              case "am":
              case "arn":
              case "br":
              case "fil":
              case "fr":
              case "gun":
              case "ln":
              case "mfe":
              case "mg":
              case "mi":
              case "oc":
              case "pt_BR":
              case "tg":
              case "ti":
              case "tr":
              case "uz":
              case "wa":
              case "zh":
                return n > 1 ? 1 : 0;

              case "lv":
                return n % 10 == 1 && n % 100 != 11 ? 0 : 0 != n ? 1 : 2;

              case "lt":
                return n % 10 == 1 && n % 100 != 11 ? 0 : n % 10 >= 2 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2;

              case "be":
              case "bs":
              case "hr":
              case "ru":
              case "sr":
              case "uk":
                return n % 10 == 1 && n % 100 != 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2;

              case "mnk":
                return 0 == n ? 0 : 1 == n ? 1 : 2;

              case "ro":
                return 1 == n ? 0 : 0 == n || n % 100 > 0 && n % 100 < 20 ? 1 : 2;

              case "pl":
                return 1 == n ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2;

              case "cs":
              case "sk":
                return 1 == n ? 0 : n >= 2 && n <= 4 ? 1 : 2;

              case "sl":
                return n % 100 == 1 ? 1 : n % 100 == 2 ? 2 : n % 100 == 3 || n % 100 == 4 ? 3 : 0;

              case "mt":
                return 1 == n ? 0 : 0 == n || n % 100 > 1 && n % 100 < 11 ? 1 : n % 100 > 10 && n % 100 < 20 ? 2 : 3;

              case "gd":
                return 1 == n || 11 == n ? 0 : 2 == n || 12 == n ? 1 : n > 2 && n < 20 ? 2 : 3;

              case "cy":
                return 1 == n ? 0 : 2 == n ? 1 : 8 != n && 11 != n ? 2 : 3;

              case "kw":
                return 1 == n ? 0 : 2 == n ? 1 : 3 == n ? 2 : 3;

              case "ga":
                return 1 == n ? 0 : 2 == n ? 1 : n < 7 ? 2 : n < 11 ? 3 : 4;

              case "ar":
                return 0 == n ? 0 : 1 == n ? 1 : 2 == n ? 2 : n % 100 >= 3 && n % 100 <= 10 ? 3 : n % 100 >= 11 ? 4 : 5;

              default:
                return 1 != n ? 1 : 0;
            }
        };
    }), angular.module("gettext").factory("gettextUtil", function() {
        function e(e, t, n) {
            if (!e) throw new Error("You should add a " + t + " attribute whenever you add a " + n + " attribute.");
        }
        function t(e, t) {
            return 0 === e.indexOf(t);
        }
        function n(e) {
            var t = e.charAt(0).toLowerCase();
            return t + e.substr(1);
        }
        var a = function() {
            return String.prototype.trim ? function(e) {
                return "string" == typeof e ? e.trim() : e;
            } : function(e) {
                return "string" == typeof e ? e.replace(/^\s*/, "").replace(/\s*$/, "") : e;
            };
        }();
        return {
            trim: a,
            assert: e,
            startsWith: t,
            lcFirst: n
        };
    });
}, function(e, t, n) {
    angular.module("ui.bootstrap", [ "ui.bootstrap.tpls", "ui.bootstrap.collapse", "ui.bootstrap.accordion", "ui.bootstrap.alert", "ui.bootstrap.bindHtml", "ui.bootstrap.buttons", "ui.bootstrap.carousel", "ui.bootstrap.dateparser", "ui.bootstrap.position", "ui.bootstrap.datepicker", "ui.bootstrap.dropdown", "ui.bootstrap.modal", "ui.bootstrap.pagination", "ui.bootstrap.tooltip", "ui.bootstrap.popover", "ui.bootstrap.progressbar", "ui.bootstrap.rating", "ui.bootstrap.tabs", "ui.bootstrap.timepicker", "ui.bootstrap.transition", "ui.bootstrap.typeahead" ]), 
    angular.module("ui.bootstrap.tpls", [ "template/accordion/accordion-group.html", "template/accordion/accordion.html", "template/alert/alert.html", "template/carousel/carousel.html", "template/carousel/slide.html", "template/datepicker/datepicker.html", "template/datepicker/day.html", "template/datepicker/month.html", "template/datepicker/popup.html", "template/datepicker/year.html", "template/modal/backdrop.html", "template/modal/window.html", "template/pagination/pager.html", "template/pagination/pagination.html", "template/tooltip/tooltip-html-popup.html", "template/tooltip/tooltip-html-unsafe-popup.html", "template/tooltip/tooltip-popup.html", "template/tooltip/tooltip-template-popup.html", "template/popover/popover-html.html", "template/popover/popover-template.html", "template/popover/popover.html", "template/progressbar/bar.html", "template/progressbar/progress.html", "template/progressbar/progressbar.html", "template/rating/rating.html", "template/tabs/tab.html", "template/tabs/tabset.html", "template/timepicker/timepicker.html", "template/typeahead/typeahead-match.html", "template/typeahead/typeahead-popup.html" ]), 
    angular.module("ui.bootstrap.collapse", []).directive("collapse", [ "$animate", function(e) {
        return {
            link: function(t, n, a) {
                function r() {
                    n.removeClass("collapse").addClass("collapsing").attr("aria-expanded", !0).attr("aria-hidden", !1), 
                    e.addClass(n, "in", {
                        to: {
                            height: n[0].scrollHeight + "px"
                        }
                    }).then(i);
                }
                function i() {
                    n.removeClass("collapsing"), n.css({
                        height: "auto"
                    });
                }
                function s() {
                    return n.hasClass("collapse") || n.hasClass("in") ? (n.css({
                        height: n[0].scrollHeight + "px"
                    }).removeClass("collapse").addClass("collapsing").attr("aria-expanded", !1).attr("aria-hidden", !0), 
                    void e.removeClass(n, "in", {
                        to: {
                            height: "0"
                        }
                    }).then(o)) : o();
                }
                function o() {
                    n.css({
                        height: "0"
                    }), n.removeClass("collapsing"), n.addClass("collapse");
                }
                t.$watch(a.collapse, function(e) {
                    e ? s() : r();
                });
            }
        };
    } ]), angular.module("ui.bootstrap.accordion", [ "ui.bootstrap.collapse" ]).constant("accordionConfig", {
        closeOthers: !0
    }).controller("AccordionController", [ "$scope", "$attrs", "accordionConfig", function(e, t, n) {
        this.groups = [], this.closeOthers = function(a) {
            var r = angular.isDefined(t.closeOthers) ? e.$eval(t.closeOthers) : n.closeOthers;
            r && angular.forEach(this.groups, function(e) {
                e !== a && (e.isOpen = !1);
            });
        }, this.addGroup = function(e) {
            var t = this;
            this.groups.push(e), e.$on("$destroy", function(n) {
                t.removeGroup(e);
            });
        }, this.removeGroup = function(e) {
            var t = this.groups.indexOf(e);
            t !== -1 && this.groups.splice(t, 1);
        };
    } ]).directive("accordion", function() {
        return {
            restrict: "EA",
            controller: "AccordionController",
            controllerAs: "accordion",
            transclude: !0,
            replace: !1,
            templateUrl: function(e, t) {
                return t.templateUrl || "template/accordion/accordion.html";
            }
        };
    }).directive("accordionGroup", function() {
        return {
            require: "^accordion",
            restrict: "EA",
            transclude: !0,
            replace: !0,
            templateUrl: function(e, t) {
                return t.templateUrl || "template/accordion/accordion-group.html";
            },
            scope: {
                heading: "@",
                isOpen: "=?",
                isDisabled: "=?"
            },
            controller: function() {
                this.setHeading = function(e) {
                    this.heading = e;
                };
            },
            link: function(e, t, n, a) {
                a.addGroup(e), e.openClass = n.openClass || "panel-open", e.panelClass = n.panelClass, 
                e.$watch("isOpen", function(n) {
                    t.toggleClass(e.openClass, n), n && a.closeOthers(e);
                }), e.toggleOpen = function(t) {
                    e.isDisabled || t && 32 !== t.which || (e.isOpen = !e.isOpen);
                };
            }
        };
    }).directive("accordionHeading", function() {
        return {
            restrict: "EA",
            transclude: !0,
            template: "",
            replace: !0,
            require: "^accordionGroup",
            link: function(e, t, n, a, r) {
                a.setHeading(r(e, angular.noop));
            }
        };
    }).directive("accordionTransclude", function() {
        return {
            require: "^accordionGroup",
            link: function(e, t, n, a) {
                e.$watch(function() {
                    return a[n.accordionTransclude];
                }, function(e) {
                    e && (t.find("span").html(""), t.find("span").append(e));
                });
            }
        };
    }), angular.module("ui.bootstrap.alert", []).controller("AlertController", [ "$scope", "$attrs", function(e, t) {
        e.closeable = !!t.close, this.close = e.close;
    } ]).directive("alert", function() {
        return {
            controller: "AlertController",
            controllerAs: "alert",
            templateUrl: function(e, t) {
                return t.templateUrl || "template/alert/alert.html";
            },
            transclude: !0,
            replace: !0,
            scope: {
                type: "@",
                close: "&"
            }
        };
    }).directive("dismissOnTimeout", [ "$timeout", function(e) {
        return {
            require: "alert",
            link: function(t, n, a, r) {
                e(function() {
                    r.close();
                }, parseInt(a.dismissOnTimeout, 10));
            }
        };
    } ]), angular.module("ui.bootstrap.bindHtml", []).value("$bindHtmlUnsafeSuppressDeprecated", !1).directive("bindHtmlUnsafe", [ "$log", "$bindHtmlUnsafeSuppressDeprecated", function(e, t) {
        return function(n, a, r) {
            t || e.warn("bindHtmlUnsafe is now deprecated. Use ngBindHtml instead"), a.addClass("ng-binding").data("$binding", r.bindHtmlUnsafe), 
            n.$watch(r.bindHtmlUnsafe, function(e) {
                a.html(e || "");
            });
        };
    } ]), angular.module("ui.bootstrap.buttons", []).constant("buttonConfig", {
        activeClass: "active",
        toggleEvent: "click"
    }).controller("ButtonsController", [ "buttonConfig", function(e) {
        this.activeClass = e.activeClass || "active", this.toggleEvent = e.toggleEvent || "click";
    } ]).directive("btnRadio", function() {
        return {
            require: [ "btnRadio", "ngModel" ],
            controller: "ButtonsController",
            controllerAs: "buttons",
            link: function(e, t, n, a) {
                var r = a[0], i = a[1];
                t.find("input").css({
                    display: "none"
                }), i.$render = function() {
                    t.toggleClass(r.activeClass, angular.equals(i.$modelValue, e.$eval(n.btnRadio)));
                }, t.bind(r.toggleEvent, function() {
                    if (!n.disabled) {
                        var a = t.hasClass(r.activeClass);
                        a && !angular.isDefined(n.uncheckable) || e.$apply(function() {
                            i.$setViewValue(a ? null : e.$eval(n.btnRadio)), i.$render();
                        });
                    }
                });
            }
        };
    }).directive("btnCheckbox", [ "$document", function(e) {
        return {
            require: [ "btnCheckbox", "ngModel" ],
            controller: "ButtonsController",
            controllerAs: "button",
            link: function(t, n, a, r) {
                function i() {
                    return o(a.btnCheckboxTrue, !0);
                }
                function s() {
                    return o(a.btnCheckboxFalse, !1);
                }
                function o(e, n) {
                    var a = t.$eval(e);
                    return angular.isDefined(a) ? a : n;
                }
                var l = r[0], u = r[1];
                n.find("input").css({
                    display: "none"
                }), u.$render = function() {
                    n.toggleClass(l.activeClass, angular.equals(u.$modelValue, i()));
                }, n.bind(l.toggleEvent, function() {
                    a.disabled || t.$apply(function() {
                        u.$setViewValue(n.hasClass(l.activeClass) ? s() : i()), u.$render();
                    });
                }), n.on("keypress", function(r) {
                    a.disabled || 32 !== r.which || e[0].activeElement !== n[0] || t.$apply(function() {
                        u.$setViewValue(n.hasClass(l.activeClass) ? s() : i()), u.$render();
                    });
                });
            }
        };
    } ]), angular.module("ui.bootstrap.carousel", []).controller("CarouselController", [ "$scope", "$element", "$interval", "$animate", function(e, t, n, a) {
        function r(t, n, r) {
            _ || (angular.extend(t, {
                direction: r,
                active: !0
            }), angular.extend(d.currentSlide || {}, {
                direction: r,
                active: !1
            }), a.enabled() && !e.noTransition && !e.$currentTransition && t.$element && d.slides.length > 1 && (t.$element.data(h, t.direction), 
            d.currentSlide && d.currentSlide.$element && d.currentSlide.$element.data(h, t.direction), 
            e.$currentTransition = !0, f ? a.on("addClass", t.$element, function(t, n) {
                "close" === n && (e.$currentTransition = null, a.off("addClass", t));
            }) : t.$element.one("$animate:close", function() {
                e.$currentTransition = null;
            })), d.currentSlide = t, g = n, s());
        }
        function i(e) {
            if (angular.isUndefined(m[e].index)) return m[e];
            var t;
            m.length;
            for (t = 0; t < m.length; ++t) if (m[t].index == e) return m[t];
        }
        function s() {
            o();
            var t = +e.interval;
            !isNaN(t) && t > 0 && (u = n(l, t));
        }
        function o() {
            u && (n.cancel(u), u = null);
        }
        function l() {
            var t = +e.interval;
            c && !isNaN(t) && t > 0 && m.length ? e.next() : e.pause();
        }
        var u, c, d = this, m = d.slides = e.slides = [], f = angular.version.minor >= 4, p = "uib-noTransition", h = "uib-slideDirection", g = -1;
        d.currentSlide = null;
        var _ = !1;
        d.select = e.select = function(t, n) {
            var a = e.indexOfSlide(t);
            void 0 === n && (n = a > d.getCurrentIndex() ? "next" : "prev"), t && t !== d.currentSlide && !e.$currentTransition && r(t, a, n);
        }, e.$on("$destroy", function() {
            _ = !0;
        }), d.getCurrentIndex = function() {
            return d.currentSlide && angular.isDefined(d.currentSlide.index) ? +d.currentSlide.index : g;
        }, e.indexOfSlide = function(e) {
            return angular.isDefined(e.index) ? +e.index : m.indexOf(e);
        }, e.next = function() {
            var t = (d.getCurrentIndex() + 1) % m.length;
            return 0 === t && e.noWrap() ? void e.pause() : d.select(i(t), "next");
        }, e.prev = function() {
            var t = d.getCurrentIndex() - 1 < 0 ? m.length - 1 : d.getCurrentIndex() - 1;
            return e.noWrap() && t === m.length - 1 ? void e.pause() : d.select(i(t), "prev");
        }, e.isActive = function(e) {
            return d.currentSlide === e;
        }, e.$watch("interval", s), e.$on("$destroy", o), e.play = function() {
            c || (c = !0, s());
        }, e.pause = function() {
            e.noPause || (c = !1, o());
        }, d.addSlide = function(t, n) {
            t.$element = n, m.push(t), 1 === m.length || t.active ? (d.select(m[m.length - 1]), 
            1 == m.length && e.play()) : t.active = !1;
        }, d.removeSlide = function(e) {
            angular.isDefined(e.index) && m.sort(function(e, t) {
                return +e.index > +t.index;
            });
            var t = m.indexOf(e);
            m.splice(t, 1), m.length > 0 && e.active ? t >= m.length ? d.select(m[t - 1]) : d.select(m[t]) : g > t && g--, 
            0 === m.length && (d.currentSlide = null);
        }, e.$watch("noTransition", function(e) {
            t.data(p, e);
        });
    } ]).directive("carousel", [ function() {
        return {
            restrict: "EA",
            transclude: !0,
            replace: !0,
            controller: "CarouselController",
            controllerAs: "carousel",
            require: "carousel",
            templateUrl: function(e, t) {
                return t.templateUrl || "template/carousel/carousel.html";
            },
            scope: {
                interval: "=",
                noTransition: "=",
                noPause: "=",
                noWrap: "&"
            }
        };
    } ]).directive("slide", function() {
        return {
            require: "^carousel",
            restrict: "EA",
            transclude: !0,
            replace: !0,
            templateUrl: function(e, t) {
                return t.templateUrl || "template/carousel/slide.html";
            },
            scope: {
                active: "=?",
                actual: "=?",
                index: "=?"
            },
            link: function(e, t, n, a) {
                a.addSlide(e, t), e.$on("$destroy", function() {
                    a.removeSlide(e);
                }), e.$watch("active", function(t) {
                    t && a.select(e);
                });
            }
        };
    }).animation(".item", [ "$injector", "$animate", function(e, t) {
        function n(e, t, n) {
            e.removeClass(t), n && n();
        }
        var a = "uib-noTransition", r = "uib-slideDirection", i = null;
        return e.has("$animateCss") && (i = e.get("$animateCss")), {
            beforeAddClass: function(e, s, o) {
                if ("active" == s && e.parent() && !e.parent().data(a)) {
                    var l = !1, u = e.data(r), c = "next" == u ? "left" : "right", d = n.bind(this, e, c + " " + u, o);
                    return e.addClass(u), i ? i(e, {
                        addClass: c
                    }).start().done(d) : t.addClass(e, c).then(function() {
                        l || d(), o();
                    }), function() {
                        l = !0;
                    };
                }
                o();
            },
            beforeRemoveClass: function(e, s, o) {
                if ("active" === s && e.parent() && !e.parent().data(a)) {
                    var l = !1, u = e.data(r), c = "next" == u ? "left" : "right", d = n.bind(this, e, c, o);
                    return i ? i(e, {
                        addClass: c
                    }).start().done(d) : t.addClass(e, c).then(function() {
                        l || d(), o();
                    }), function() {
                        l = !0;
                    };
                }
                o();
            }
        };
    } ]), angular.module("ui.bootstrap.dateparser", []).service("dateParser", [ "$log", "$locale", "orderByFilter", function(e, t, n) {
        function a(e) {
            var t = [], a = e.split("");
            return angular.forEach(s, function(n, r) {
                var i = e.indexOf(r);
                if (i > -1) {
                    e = e.split(""), a[i] = "(" + n.regex + ")", e[i] = "$";
                    for (var s = i + 1, o = i + r.length; s < o; s++) a[s] = "", e[s] = "$";
                    e = e.join(""), t.push({
                        index: i,
                        apply: n.apply
                    });
                }
            }), {
                regex: new RegExp("^" + a.join("") + "$"),
                map: n(t, "index")
            };
        }
        function r(e, t, n) {
            return !(n < 1) && (1 === t && n > 28 ? 29 === n && (e % 4 === 0 && e % 100 !== 0 || e % 400 === 0) : 3 !== t && 5 !== t && 8 !== t && 10 !== t || n < 31);
        }
        var i = /[\\\^\$\*\+\?\|\[\]\(\)\.\{\}]/g;
        this.parsers = {};
        var s = {
            yyyy: {
                regex: "\\d{4}",
                apply: function(e) {
                    this.year = +e;
                }
            },
            yy: {
                regex: "\\d{2}",
                apply: function(e) {
                    this.year = +e + 2e3;
                }
            },
            y: {
                regex: "\\d{1,4}",
                apply: function(e) {
                    this.year = +e;
                }
            },
            MMMM: {
                regex: t.DATETIME_FORMATS.MONTH.join("|"),
                apply: function(e) {
                    this.month = t.DATETIME_FORMATS.MONTH.indexOf(e);
                }
            },
            MMM: {
                regex: t.DATETIME_FORMATS.SHORTMONTH.join("|"),
                apply: function(e) {
                    this.month = t.DATETIME_FORMATS.SHORTMONTH.indexOf(e);
                }
            },
            MM: {
                regex: "0[1-9]|1[0-2]",
                apply: function(e) {
                    this.month = e - 1;
                }
            },
            M: {
                regex: "[1-9]|1[0-2]",
                apply: function(e) {
                    this.month = e - 1;
                }
            },
            dd: {
                regex: "[0-2][0-9]{1}|3[0-1]{1}",
                apply: function(e) {
                    this.date = +e;
                }
            },
            d: {
                regex: "[1-2]?[0-9]{1}|3[0-1]{1}",
                apply: function(e) {
                    this.date = +e;
                }
            },
            EEEE: {
                regex: t.DATETIME_FORMATS.DAY.join("|")
            },
            EEE: {
                regex: t.DATETIME_FORMATS.SHORTDAY.join("|")
            },
            HH: {
                regex: "(?:0|1)[0-9]|2[0-3]",
                apply: function(e) {
                    this.hours = +e;
                }
            },
            hh: {
                regex: "0[0-9]|1[0-2]",
                apply: function(e) {
                    this.hours = +e;
                }
            },
            H: {
                regex: "1?[0-9]|2[0-3]",
                apply: function(e) {
                    this.hours = +e;
                }
            },
            h: {
                regex: "[0-9]|1[0-2]",
                apply: function(e) {
                    this.hours = +e;
                }
            },
            mm: {
                regex: "[0-5][0-9]",
                apply: function(e) {
                    this.minutes = +e;
                }
            },
            m: {
                regex: "[0-9]|[1-5][0-9]",
                apply: function(e) {
                    this.minutes = +e;
                }
            },
            sss: {
                regex: "[0-9][0-9][0-9]",
                apply: function(e) {
                    this.milliseconds = +e;
                }
            },
            ss: {
                regex: "[0-5][0-9]",
                apply: function(e) {
                    this.seconds = +e;
                }
            },
            s: {
                regex: "[0-9]|[1-5][0-9]",
                apply: function(e) {
                    this.seconds = +e;
                }
            },
            a: {
                regex: t.DATETIME_FORMATS.AMPMS.join("|"),
                apply: function(e) {
                    12 === this.hours && (this.hours = 0), "PM" === e && (this.hours += 12);
                }
            }
        };
        this.parse = function(n, s, o) {
            if (!angular.isString(n) || !s) return n;
            s = t.DATETIME_FORMATS[s] || s, s = s.replace(i, "\\$&"), this.parsers[s] || (this.parsers[s] = a(s));
            var l = this.parsers[s], u = l.regex, c = l.map, d = n.match(u);
            if (d && d.length) {
                var m, f;
                angular.isDate(o) && !isNaN(o.getTime()) ? m = {
                    year: o.getFullYear(),
                    month: o.getMonth(),
                    date: o.getDate(),
                    hours: o.getHours(),
                    minutes: o.getMinutes(),
                    seconds: o.getSeconds(),
                    milliseconds: o.getMilliseconds()
                } : (o && e.warn("dateparser:", "baseDate is not a valid date"), m = {
                    year: 1900,
                    month: 0,
                    date: 1,
                    hours: 0,
                    minutes: 0,
                    seconds: 0,
                    milliseconds: 0
                });
                for (var p = 1, h = d.length; p < h; p++) {
                    var g = c[p - 1];
                    g.apply && g.apply.call(m, d[p]);
                }
                return r(m.year, m.month, m.date) && (f = new Date(m.year, m.month, m.date, m.hours, m.minutes, m.seconds, m.milliseconds || 0)), 
                f;
            }
        };
    } ]), angular.module("ui.bootstrap.position", []).factory("$position", [ "$document", "$window", function(e, t) {
        function n(e, n) {
            return e.currentStyle ? e.currentStyle[n] : t.getComputedStyle ? t.getComputedStyle(e)[n] : e.style[n];
        }
        function a(e) {
            return "static" === (n(e, "position") || "static");
        }
        var r = function(t) {
            for (var n = e[0], r = t.offsetParent || n; r && r !== n && a(r); ) r = r.offsetParent;
            return r || n;
        };
        return {
            position: function(t) {
                var n = this.offset(t), a = {
                    top: 0,
                    left: 0
                }, i = r(t[0]);
                i != e[0] && (a = this.offset(angular.element(i)), a.top += i.clientTop - i.scrollTop, 
                a.left += i.clientLeft - i.scrollLeft);
                var s = t[0].getBoundingClientRect();
                return {
                    width: s.width || t.prop("offsetWidth"),
                    height: s.height || t.prop("offsetHeight"),
                    top: n.top - a.top,
                    left: n.left - a.left
                };
            },
            offset: function(n) {
                var a = n[0].getBoundingClientRect();
                return {
                    width: a.width || n.prop("offsetWidth"),
                    height: a.height || n.prop("offsetHeight"),
                    top: a.top + (t.pageYOffset || e[0].documentElement.scrollTop),
                    left: a.left + (t.pageXOffset || e[0].documentElement.scrollLeft)
                };
            },
            positionElements: function(e, t, n, a) {
                var r, i, s, o, l = n.split("-"), u = l[0], c = l[1] || "center";
                r = a ? this.offset(e) : this.position(e), i = t.prop("offsetWidth"), s = t.prop("offsetHeight");
                var d = {
                    center: function() {
                        return r.left + r.width / 2 - i / 2;
                    },
                    left: function() {
                        return r.left;
                    },
                    right: function() {
                        return r.left + r.width;
                    }
                }, m = {
                    center: function() {
                        return r.top + r.height / 2 - s / 2;
                    },
                    top: function() {
                        return r.top;
                    },
                    bottom: function() {
                        return r.top + r.height;
                    }
                };
                switch (u) {
                  case "right":
                    o = {
                        top: m[c](),
                        left: d[u]()
                    };
                    break;

                  case "left":
                    o = {
                        top: m[c](),
                        left: r.left - i
                    };
                    break;

                  case "bottom":
                    o = {
                        top: m[u](),
                        left: d[c]()
                    };
                    break;

                  default:
                    o = {
                        top: r.top - s,
                        left: d[c]()
                    };
                }
                return o;
            }
        };
    } ]), angular.module("ui.bootstrap.datepicker", [ "ui.bootstrap.dateparser", "ui.bootstrap.position" ]).value("$datepickerSuppressError", !1).constant("datepickerConfig", {
        formatDay: "dd",
        formatMonth: "MMMM",
        formatYear: "yyyy",
        formatDayHeader: "EEE",
        formatDayTitle: "MMMM yyyy",
        formatMonthTitle: "yyyy",
        datepickerMode: "day",
        minMode: "day",
        maxMode: "year",
        showWeeks: !0,
        startingDay: 0,
        yearRange: 20,
        minDate: null,
        maxDate: null,
        shortcutPropagation: !1
    }).controller("DatepickerController", [ "$scope", "$attrs", "$parse", "$interpolate", "$log", "dateFilter", "datepickerConfig", "$datepickerSuppressError", function(e, t, n, a, r, i, s, o) {
        var l = this, u = {
            $setViewValue: angular.noop
        };
        this.modes = [ "day", "month", "year" ], angular.forEach([ "formatDay", "formatMonth", "formatYear", "formatDayHeader", "formatDayTitle", "formatMonthTitle", "showWeeks", "startingDay", "yearRange", "shortcutPropagation" ], function(n, r) {
            l[n] = angular.isDefined(t[n]) ? r < 6 ? a(t[n])(e.$parent) : e.$parent.$eval(t[n]) : s[n];
        }), angular.forEach([ "minDate", "maxDate" ], function(a) {
            t[a] ? e.$parent.$watch(n(t[a]), function(e) {
                l[a] = e ? new Date(e) : null, l.refreshView();
            }) : l[a] = s[a] ? new Date(s[a]) : null;
        }), angular.forEach([ "minMode", "maxMode" ], function(a) {
            t[a] ? e.$parent.$watch(n(t[a]), function(n) {
                l[a] = angular.isDefined(n) ? n : t[a], e[a] = l[a], ("minMode" == a && l.modes.indexOf(e.datepickerMode) < l.modes.indexOf(l[a]) || "maxMode" == a && l.modes.indexOf(e.datepickerMode) > l.modes.indexOf(l[a])) && (e.datepickerMode = l[a]);
            }) : (l[a] = s[a] || null, e[a] = l[a]);
        }), e.datepickerMode = e.datepickerMode || s.datepickerMode, e.uniqueId = "datepicker-" + e.$id + "-" + Math.floor(1e4 * Math.random()), 
        angular.isDefined(t.initDate) ? (this.activeDate = e.$parent.$eval(t.initDate) || new Date(), 
        e.$parent.$watch(t.initDate, function(e) {
            e && (u.$isEmpty(u.$modelValue) || u.$invalid) && (l.activeDate = e, l.refreshView());
        })) : this.activeDate = new Date(), e.isActive = function(t) {
            return 0 === l.compare(t.date, l.activeDate) && (e.activeDateId = t.uid, !0);
        }, this.init = function(e) {
            u = e, u.$render = function() {
                l.render();
            };
        }, this.render = function() {
            if (u.$viewValue) {
                var e = new Date(u.$viewValue), t = !isNaN(e);
                t ? this.activeDate = e : o || r.error('Datepicker directive: "ng-model" value must be a Date object, a number of milliseconds since 01.01.1970 or a string representing an RFC2822 or ISO 8601 date.');
            }
            this.refreshView();
        }, this.refreshView = function() {
            if (this.element) {
                this._refreshView();
                var e = u.$viewValue ? new Date(u.$viewValue) : null;
                u.$setValidity("dateDisabled", !e || this.element && !this.isDisabled(e));
            }
        }, this.createDateObject = function(e, t) {
            var n = u.$viewValue ? new Date(u.$viewValue) : null;
            return {
                date: e,
                label: i(e, t),
                selected: n && 0 === this.compare(e, n),
                disabled: this.isDisabled(e),
                current: 0 === this.compare(e, new Date()),
                customClass: this.customClass(e)
            };
        }, this.isDisabled = function(n) {
            return this.minDate && this.compare(n, this.minDate) < 0 || this.maxDate && this.compare(n, this.maxDate) > 0 || t.dateDisabled && e.dateDisabled({
                date: n,
                mode: e.datepickerMode
            });
        }, this.customClass = function(t) {
            return e.customClass({
                date: t,
                mode: e.datepickerMode
            });
        }, this.split = function(e, t) {
            for (var n = []; e.length > 0; ) n.push(e.splice(0, t));
            return n;
        }, this.fixTimeZone = function(e) {
            var t = e.getHours();
            e.setHours(23 === t ? t + 2 : 0);
        }, e.select = function(t) {
            if (e.datepickerMode === l.minMode) {
                var n = u.$viewValue ? new Date(u.$viewValue) : new Date(0, 0, 0, 0, 0, 0, 0);
                n.setFullYear(t.getFullYear(), t.getMonth(), t.getDate()), u.$setViewValue(n), u.$render();
            } else l.activeDate = t, e.datepickerMode = l.modes[l.modes.indexOf(e.datepickerMode) - 1];
        }, e.move = function(e) {
            var t = l.activeDate.getFullYear() + e * (l.step.years || 0), n = l.activeDate.getMonth() + e * (l.step.months || 0);
            l.activeDate.setFullYear(t, n, 1), l.refreshView();
        }, e.toggleMode = function(t) {
            t = t || 1, e.datepickerMode === l.maxMode && 1 === t || e.datepickerMode === l.minMode && t === -1 || (e.datepickerMode = l.modes[l.modes.indexOf(e.datepickerMode) + t]);
        }, e.keys = {
            13: "enter",
            32: "space",
            33: "pageup",
            34: "pagedown",
            35: "end",
            36: "home",
            37: "left",
            38: "up",
            39: "right",
            40: "down"
        };
        var c = function() {
            l.element[0].focus();
        };
        e.$on("datepicker.focus", c), e.keydown = function(t) {
            var n = e.keys[t.which];
            if (n && !t.shiftKey && !t.altKey) if (t.preventDefault(), l.shortcutPropagation || t.stopPropagation(), 
            "enter" === n || "space" === n) {
                if (l.isDisabled(l.activeDate)) return;
                e.select(l.activeDate), c();
            } else !t.ctrlKey || "up" !== n && "down" !== n ? (l.handleKeyDown(n, t), l.refreshView()) : (e.toggleMode("up" === n ? 1 : -1), 
            c());
        };
    } ]).directive("datepicker", function() {
        return {
            restrict: "EA",
            replace: !0,
            templateUrl: function(e, t) {
                return t.templateUrl || "template/datepicker/datepicker.html";
            },
            scope: {
                datepickerMode: "=?",
                dateDisabled: "&",
                customClass: "&",
                shortcutPropagation: "&?"
            },
            require: [ "datepicker", "^ngModel" ],
            controller: "DatepickerController",
            controllerAs: "datepicker",
            link: function(e, t, n, a) {
                var r = a[0], i = a[1];
                r.init(i);
            }
        };
    }).directive("daypicker", [ "dateFilter", function(e) {
        return {
            restrict: "EA",
            replace: !0,
            templateUrl: "template/datepicker/day.html",
            require: "^datepicker",
            link: function(t, n, a, r) {
                function i(e, t) {
                    return 1 !== t || e % 4 !== 0 || e % 100 === 0 && e % 400 !== 0 ? l[t] : 29;
                }
                function s(e, t) {
                    for (var n, a = new Array(t), i = new Date(e), s = 0; s < t; ) n = new Date(i), 
                    r.fixTimeZone(n), a[s++] = n, i.setDate(i.getDate() + 1);
                    return a;
                }
                function o(e) {
                    var t = new Date(e);
                    t.setDate(t.getDate() + 4 - (t.getDay() || 7));
                    var n = t.getTime();
                    return t.setMonth(0), t.setDate(1), Math.floor(Math.round((n - t) / 864e5) / 7) + 1;
                }
                t.showWeeks = r.showWeeks, r.step = {
                    months: 1
                }, r.element = n;
                var l = [ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 ];
                r._refreshView = function() {
                    var n = r.activeDate.getFullYear(), a = r.activeDate.getMonth(), i = new Date(n, a, 1), l = r.startingDay - i.getDay(), u = l > 0 ? 7 - l : -l, c = new Date(i);
                    u > 0 && c.setDate(-u + 1);
                    for (var d = s(c, 42), m = 0; m < 42; m++) d[m] = angular.extend(r.createDateObject(d[m], r.formatDay), {
                        secondary: d[m].getMonth() !== a,
                        uid: t.uniqueId + "-" + m
                    });
                    t.labels = new Array(7);
                    for (var f = 0; f < 7; f++) t.labels[f] = {
                        abbr: e(d[f].date, r.formatDayHeader),
                        full: e(d[f].date, "EEEE")
                    };
                    if (t.title = e(r.activeDate, r.formatDayTitle), t.rows = r.split(d, 7), t.showWeeks) {
                        t.weekNumbers = [];
                        for (var p = (11 - r.startingDay) % 7, h = t.rows.length, g = 0; g < h; g++) t.weekNumbers.push(o(t.rows[g][p].date));
                    }
                }, r.compare = function(e, t) {
                    return new Date(e.getFullYear(), e.getMonth(), e.getDate()) - new Date(t.getFullYear(), t.getMonth(), t.getDate());
                }, r.handleKeyDown = function(e, t) {
                    var n = r.activeDate.getDate();
                    if ("left" === e) n -= 1; else if ("up" === e) n -= 7; else if ("right" === e) n += 1; else if ("down" === e) n += 7; else if ("pageup" === e || "pagedown" === e) {
                        var a = r.activeDate.getMonth() + ("pageup" === e ? -1 : 1);
                        r.activeDate.setMonth(a, 1), n = Math.min(i(r.activeDate.getFullYear(), r.activeDate.getMonth()), n);
                    } else "home" === e ? n = 1 : "end" === e && (n = i(r.activeDate.getFullYear(), r.activeDate.getMonth()));
                    r.activeDate.setDate(n);
                }, r.refreshView();
            }
        };
    } ]).directive("monthpicker", [ "dateFilter", function(e) {
        return {
            restrict: "EA",
            replace: !0,
            templateUrl: "template/datepicker/month.html",
            require: "^datepicker",
            link: function(t, n, a, r) {
                r.step = {
                    years: 1
                }, r.element = n, r._refreshView = function() {
                    for (var n, a = new Array(12), i = r.activeDate.getFullYear(), s = 0; s < 12; s++) n = new Date(i, s, 1), 
                    r.fixTimeZone(n), a[s] = angular.extend(r.createDateObject(n, r.formatMonth), {
                        uid: t.uniqueId + "-" + s
                    });
                    t.title = e(r.activeDate, r.formatMonthTitle), t.rows = r.split(a, 3);
                }, r.compare = function(e, t) {
                    return new Date(e.getFullYear(), e.getMonth()) - new Date(t.getFullYear(), t.getMonth());
                }, r.handleKeyDown = function(e, t) {
                    var n = r.activeDate.getMonth();
                    if ("left" === e) n -= 1; else if ("up" === e) n -= 3; else if ("right" === e) n += 1; else if ("down" === e) n += 3; else if ("pageup" === e || "pagedown" === e) {
                        var a = r.activeDate.getFullYear() + ("pageup" === e ? -1 : 1);
                        r.activeDate.setFullYear(a);
                    } else "home" === e ? n = 0 : "end" === e && (n = 11);
                    r.activeDate.setMonth(n);
                }, r.refreshView();
            }
        };
    } ]).directive("yearpicker", [ "dateFilter", function(e) {
        return {
            restrict: "EA",
            replace: !0,
            templateUrl: "template/datepicker/year.html",
            require: "^datepicker",
            link: function(e, t, n, a) {
                function r(e) {
                    return parseInt((e - 1) / i, 10) * i + 1;
                }
                var i = a.yearRange;
                a.step = {
                    years: i
                }, a.element = t, a._refreshView = function() {
                    for (var t, n = new Array(i), s = 0, o = r(a.activeDate.getFullYear()); s < i; s++) t = new Date(o + s, 0, 1), 
                    a.fixTimeZone(t), n[s] = angular.extend(a.createDateObject(t, a.formatYear), {
                        uid: e.uniqueId + "-" + s
                    });
                    e.title = [ n[0].label, n[i - 1].label ].join(" - "), e.rows = a.split(n, 5);
                }, a.compare = function(e, t) {
                    return e.getFullYear() - t.getFullYear();
                }, a.handleKeyDown = function(e, t) {
                    var n = a.activeDate.getFullYear();
                    "left" === e ? n -= 1 : "up" === e ? n -= 5 : "right" === e ? n += 1 : "down" === e ? n += 5 : "pageup" === e || "pagedown" === e ? n += ("pageup" === e ? -1 : 1) * a.step.years : "home" === e ? n = r(a.activeDate.getFullYear()) : "end" === e && (n = r(a.activeDate.getFullYear()) + i - 1), 
                    a.activeDate.setFullYear(n);
                }, a.refreshView();
            }
        };
    } ]).constant("datepickerPopupConfig", {
        datepickerPopup: "yyyy-MM-dd",
        datepickerPopupTemplateUrl: "template/datepicker/popup.html",
        datepickerTemplateUrl: "template/datepicker/datepicker.html",
        html5Types: {
            date: "yyyy-MM-dd",
            "datetime-local": "yyyy-MM-ddTHH:mm:ss.sss",
            month: "yyyy-MM"
        },
        currentText: "Today",
        clearText: "Clear",
        closeText: "Done",
        closeOnDateSelection: !0,
        appendToBody: !1,
        showButtonBar: !0,
        onOpenFocus: !0
    }).directive("datepickerPopup", [ "$compile", "$parse", "$document", "$rootScope", "$position", "dateFilter", "dateParser", "datepickerPopupConfig", "$timeout", function(e, t, n, a, r, i, s, o, l) {
        return {
            restrict: "EA",
            require: "ngModel",
            scope: {
                isOpen: "=?",
                currentText: "@",
                clearText: "@",
                closeText: "@",
                dateDisabled: "&",
                customClass: "&"
            },
            link: function(u, c, d, m) {
                function f(e) {
                    return e.replace(/([A-Z])/g, function(e) {
                        return "-" + e.toLowerCase();
                    });
                }
                function p(e) {
                    angular.isNumber(e) && (e = new Date(e));
                    {
                        if (!e) return null;
                        if (angular.isDate(e) && !isNaN(e)) return e;
                        if (angular.isString(e)) {
                            var t = s.parse(e, g, u.date);
                            return isNaN(t) ? void 0 : t;
                        }
                    }
                }
                function h(e, t) {
                    var n = e || t;
                    if (!d.ngRequired && !n) return !0;
                    if (angular.isNumber(n) && (n = new Date(n)), n) {
                        if (angular.isDate(n) && !isNaN(n)) return !0;
                        if (angular.isString(n)) {
                            var a = s.parse(n, g);
                            return !isNaN(a);
                        }
                        return !1;
                    }
                    return !0;
                }
                var g, _ = angular.isDefined(d.closeOnDateSelection) ? u.$parent.$eval(d.closeOnDateSelection) : o.closeOnDateSelection, v = angular.isDefined(d.datepickerAppendToBody) ? u.$parent.$eval(d.datepickerAppendToBody) : o.appendToBody, b = angular.isDefined(d.onOpenFocus) ? u.$parent.$eval(d.onOpenFocus) : o.onOpenFocus, y = angular.isDefined(d.datepickerPopupTemplateUrl) ? d.datepickerPopupTemplateUrl : o.datepickerPopupTemplateUrl, M = angular.isDefined(d.datepickerTemplateUrl) ? d.datepickerTemplateUrl : o.datepickerTemplateUrl, $ = {};
                u.showButtonBar = angular.isDefined(d.showButtonBar) ? u.$parent.$eval(d.showButtonBar) : o.showButtonBar, 
                u.getText = function(e) {
                    return u[e + "Text"] || o[e + "Text"];
                }, u.isDisabled = function(e) {
                    return "today" === e && (e = new Date()), u.watchData.minDate && u.compare(e, $.minDate) < 0 || u.watchData.maxDate && u.compare(e, $.maxDate) > 0;
                }, u.compare = function(e, t) {
                    return new Date(e.getFullYear(), e.getMonth(), e.getDate()) - new Date(t.getFullYear(), t.getMonth(), t.getDate());
                };
                var k = !1;
                if (o.html5Types[d.type] ? (g = o.html5Types[d.type], k = !0) : (g = d.datepickerPopup || o.datepickerPopup, 
                d.$observe("datepickerPopup", function(e, t) {
                    var n = e || o.datepickerPopup;
                    if (n !== g && (g = n, m.$modelValue = null, !g)) throw new Error("datepickerPopup must have a date format specified.");
                })), !g) throw new Error("datepickerPopup must have a date format specified.");
                if (k && d.datepickerPopup) throw new Error("HTML5 date input types do not support custom formats.");
                var w = angular.element("<div datepicker-popup-wrap><div datepicker></div></div>");
                w.attr({
                    "ng-model": "date",
                    "ng-change": "dateSelection(date)",
                    "template-url": y
                });
                var L = angular.element(w.children()[0]);
                if (L.attr("template-url", M), k && "month" === d.type && (L.attr("datepicker-mode", '"month"'), 
                L.attr("min-mode", "month")), d.datepickerOptions) {
                    var D = u.$parent.$eval(d.datepickerOptions);
                    D && D.initDate && (u.initDate = D.initDate, L.attr("init-date", "initDate"), delete D.initDate), 
                    angular.forEach(D, function(e, t) {
                        L.attr(f(t), e);
                    });
                }
                u.watchData = {}, angular.forEach([ "minMode", "maxMode", "minDate", "maxDate", "datepickerMode", "initDate", "shortcutPropagation" ], function(e) {
                    if (d[e]) {
                        var n = t(d[e]);
                        if (u.$parent.$watch(n, function(t) {
                            u.watchData[e] = t, "minDate" !== e && "maxDate" !== e || ($[e] = new Date(t));
                        }), L.attr(f(e), "watchData." + e), "datepickerMode" === e) {
                            var a = n.assign;
                            u.$watch("watchData." + e, function(e, t) {
                                angular.isFunction(a) && e !== t && a(u.$parent, e);
                            });
                        }
                    }
                }), d.dateDisabled && L.attr("date-disabled", "dateDisabled({ date: date, mode: mode })"), 
                d.showWeeks && L.attr("show-weeks", d.showWeeks), d.customClass && L.attr("custom-class", "customClass({ date: date, mode: mode })"), 
                k ? m.$formatters.push(function(e) {
                    return u.date = e, e;
                }) : (m.$$parserName = "date", m.$validators.date = h, m.$parsers.unshift(p), m.$formatters.push(function(e) {
                    return u.date = e, m.$isEmpty(e) ? e : i(e, g);
                })), u.dateSelection = function(e) {
                    angular.isDefined(e) && (u.date = e);
                    var t = u.date ? i(u.date, g) : null;
                    c.val(t), m.$setViewValue(t), _ && (u.isOpen = !1, c[0].focus());
                }, m.$viewChangeListeners.push(function() {
                    u.date = s.parse(m.$viewValue, g, u.date);
                });
                var Y = function(e) {
                    !u.isOpen || c[0].contains(e.target) || w[0].contains(e.target) || u.$apply(function() {
                        u.isOpen = !1;
                    });
                }, T = function(e) {
                    27 === e.which && u.isOpen ? (e.preventDefault(), e.stopPropagation(), u.$apply(function() {
                        u.isOpen = !1;
                    }), c[0].focus()) : 40 !== e.which || u.isOpen || (e.preventDefault(), e.stopPropagation(), 
                    u.$apply(function() {
                        u.isOpen = !0;
                    }));
                };
                c.bind("keydown", T), u.keydown = function(e) {
                    27 === e.which && (u.isOpen = !1, c[0].focus());
                }, u.$watch("isOpen", function(e) {
                    e ? (u.position = v ? r.offset(c) : r.position(c), u.position.top = u.position.top + c.prop("offsetHeight"), 
                    l(function() {
                        b && u.$broadcast("datepicker.focus"), n.bind("click", Y);
                    }, 0, !1)) : n.unbind("click", Y);
                }), u.select = function(e) {
                    if ("today" === e) {
                        var t = new Date();
                        angular.isDate(u.date) ? (e = new Date(u.date), e.setFullYear(t.getFullYear(), t.getMonth(), t.getDate())) : e = new Date(t.setHours(0, 0, 0, 0));
                    }
                    u.dateSelection(e);
                }, u.close = function() {
                    u.isOpen = !1, c[0].focus();
                };
                var S = e(w)(u);
                w.remove(), v ? n.find("body").append(S) : c.after(S), u.$on("$destroy", function() {
                    u.isOpen === !0 && (a.$$phase || u.$apply(function() {
                        u.isOpen = !1;
                    })), S.remove(), c.unbind("keydown", T), n.unbind("click", Y);
                });
            }
        };
    } ]).directive("datepickerPopupWrap", function() {
        return {
            restrict: "EA",
            replace: !0,
            transclude: !0,
            templateUrl: function(e, t) {
                return t.templateUrl || "template/datepicker/popup.html";
            }
        };
    }), angular.module("ui.bootstrap.dropdown", [ "ui.bootstrap.position" ]).constant("dropdownConfig", {
        openClass: "open"
    }).service("dropdownService", [ "$document", "$rootScope", function(e, t) {
        var n = null;
        this.open = function(t) {
            n || (e.bind("click", a), e.bind("keydown", r)), n && n !== t && (n.isOpen = !1), 
            n = t;
        }, this.close = function(t) {
            n === t && (n = null, e.unbind("click", a), e.unbind("keydown", r));
        };
        var a = function(e) {
            if (n && (!e || "disabled" !== n.getAutoClose())) {
                var a = n.getToggleElement();
                if (!(e && a && a[0].contains(e.target))) {
                    var r = n.getDropdownElement();
                    e && "outsideClick" === n.getAutoClose() && r && r[0].contains(e.target) || (n.isOpen = !1, 
                    t.$$phase || n.$apply());
                }
            }
        }, r = function(e) {
            27 === e.which ? (n.focusToggleElement(), a()) : n.isKeynavEnabled() && /(38|40)/.test(e.which) && n.isOpen && (e.preventDefault(), 
            e.stopPropagation(), n.focusDropdownEntry(e.which));
        };
    } ]).controller("DropdownController", [ "$scope", "$attrs", "$parse", "dropdownConfig", "dropdownService", "$animate", "$position", "$document", "$compile", "$templateRequest", function(e, t, n, a, r, i, s, o, l, u) {
        var c, d, m = this, f = e.$new(), p = a.openClass, h = angular.noop, g = t.onToggle ? n(t.onToggle) : angular.noop, _ = !1, v = !1, b = o.find("body");
        this.init = function(a) {
            m.$element = a, t.isOpen && (d = n(t.isOpen), h = d.assign, e.$watch(d, function(e) {
                f.isOpen = !!e;
            })), _ = angular.isDefined(t.dropdownAppendToBody), v = angular.isDefined(t.keyboardNav), 
            _ && m.dropdownMenu && (b.append(m.dropdownMenu), b.addClass("dropdown"), a.on("$destroy", function() {
                m.dropdownMenu.remove();
            }));
        }, this.toggle = function(e) {
            return f.isOpen = arguments.length ? !!e : !f.isOpen;
        }, this.isOpen = function() {
            return f.isOpen;
        }, f.getToggleElement = function() {
            return m.toggleElement;
        }, f.getAutoClose = function() {
            return t.autoClose || "always";
        }, f.getElement = function() {
            return m.$element;
        }, f.isKeynavEnabled = function() {
            return v;
        }, f.focusDropdownEntry = function(e) {
            var t = m.dropdownMenu ? angular.element(m.dropdownMenu).find("a") : angular.element(m.$element).find("ul").eq(0).find("a");
            switch (e) {
              case 40:
                angular.isNumber(m.selectedOption) ? m.selectedOption = m.selectedOption === t.length - 1 ? m.selectedOption : m.selectedOption + 1 : m.selectedOption = 0;
                break;

              case 38:
                angular.isNumber(m.selectedOption) ? m.selectedOption = 0 === m.selectedOption ? 0 : m.selectedOption - 1 : m.selectedOption = t.length - 1;
            }
            t[m.selectedOption].focus();
        }, f.getDropdownElement = function() {
            return m.dropdownMenu;
        }, f.focusToggleElement = function() {
            m.toggleElement && m.toggleElement[0].focus();
        }, f.$watch("isOpen", function(t, n) {
            if (_ && m.dropdownMenu) {
                var a = s.positionElements(m.$element, m.dropdownMenu, "bottom-left", !0), o = {
                    top: a.top + "px",
                    display: t ? "block" : "none"
                }, d = m.dropdownMenu.hasClass("dropdown-menu-right");
                d ? (o.left = "auto", o.right = window.innerWidth - (a.left + m.$element.prop("offsetWidth")) + "px") : (o.left = a.left + "px", 
                o.right = "auto"), m.dropdownMenu.css(o);
            }
            var v = _ ? b : m.$element;
            if (i[t ? "addClass" : "removeClass"](v, p).then(function() {
                angular.isDefined(t) && t !== n && g(e, {
                    open: !!t
                });
            }), t) m.dropdownMenuTemplateUrl && u(m.dropdownMenuTemplateUrl).then(function(e) {
                c = f.$new(), l(e.trim())(c, function(e) {
                    var t = e;
                    m.dropdownMenu.replaceWith(t), m.dropdownMenu = t;
                });
            }), f.focusToggleElement(), r.open(f); else {
                if (m.dropdownMenuTemplateUrl) {
                    c && c.$destroy();
                    var y = angular.element('<ul class="dropdown-menu"></ul>');
                    m.dropdownMenu.replaceWith(y), m.dropdownMenu = y;
                }
                r.close(f), m.selectedOption = null;
            }
            angular.isFunction(h) && h(e, t);
        }), e.$on("$locationChangeSuccess", function() {
            "disabled" !== f.getAutoClose() && (f.isOpen = !1);
        });
        var y = e.$on("$destroy", function() {
            f.$destroy();
        });
        f.$on("$destroy", y);
    } ]).directive("dropdown", function() {
        return {
            controller: "DropdownController",
            link: function(e, t, n, a) {
                a.init(t), t.addClass("dropdown");
            }
        };
    }).directive("dropdownMenu", function() {
        return {
            restrict: "AC",
            require: "?^dropdown",
            link: function(e, t, n, a) {
                if (a) {
                    var r = n.templateUrl;
                    r && (a.dropdownMenuTemplateUrl = r), a.dropdownMenu || (a.dropdownMenu = t);
                }
            }
        };
    }).directive("keyboardNav", function() {
        return {
            restrict: "A",
            require: "?^dropdown",
            link: function(e, t, n, a) {
                t.bind("keydown", function(e) {
                    if ([ 38, 40 ].indexOf(e.which) !== -1) {
                        e.preventDefault(), e.stopPropagation();
                        var t = a.dropdownMenu.find("a");
                        switch (e.which) {
                          case 40:
                            angular.isNumber(a.selectedOption) ? a.selectedOption = a.selectedOption === t.length - 1 ? a.selectedOption : a.selectedOption + 1 : a.selectedOption = 0;
                            break;

                          case 38:
                            angular.isNumber(a.selectedOption) ? a.selectedOption = 0 === a.selectedOption ? 0 : a.selectedOption - 1 : a.selectedOption = t.length - 1;
                        }
                        t[a.selectedOption].focus();
                    }
                });
            }
        };
    }).directive("dropdownToggle", function() {
        return {
            require: "?^dropdown",
            link: function(e, t, n, a) {
                if (a) {
                    t.addClass("dropdown-toggle"), a.toggleElement = t;
                    var r = function(r) {
                        r.preventDefault(), t.hasClass("disabled") || n.disabled || e.$apply(function() {
                            a.toggle();
                        });
                    };
                    t.bind("click", r), t.attr({
                        "aria-haspopup": !0,
                        "aria-expanded": !1
                    }), e.$watch(a.isOpen, function(e) {
                        t.attr("aria-expanded", !!e);
                    }), e.$on("$destroy", function() {
                        t.unbind("click", r);
                    });
                }
            }
        };
    }), angular.module("ui.bootstrap.modal", []).factory("$$stackedMap", function() {
        return {
            createNew: function() {
                var e = [];
                return {
                    add: function(t, n) {
                        e.push({
                            key: t,
                            value: n
                        });
                    },
                    get: function(t) {
                        for (var n = 0; n < e.length; n++) if (t == e[n].key) return e[n];
                    },
                    keys: function() {
                        for (var t = [], n = 0; n < e.length; n++) t.push(e[n].key);
                        return t;
                    },
                    top: function() {
                        return e[e.length - 1];
                    },
                    remove: function(t) {
                        for (var n = -1, a = 0; a < e.length; a++) if (t == e[a].key) {
                            n = a;
                            break;
                        }
                        return e.splice(n, 1)[0];
                    },
                    removeTop: function() {
                        return e.splice(e.length - 1, 1)[0];
                    },
                    length: function() {
                        return e.length;
                    }
                };
            }
        };
    }).factory("$$multiMap", function() {
        return {
            createNew: function() {
                var e = {};
                return {
                    entries: function() {
                        return Object.keys(e).map(function(t) {
                            return {
                                key: t,
                                value: e[t]
                            };
                        });
                    },
                    get: function(t) {
                        return e[t];
                    },
                    hasKey: function(t) {
                        return !!e[t];
                    },
                    keys: function() {
                        return Object.keys(e);
                    },
                    put: function(t, n) {
                        e[t] || (e[t] = []), e[t].push(n);
                    },
                    remove: function(t, n) {
                        var a = e[t];
                        if (a) {
                            var r = a.indexOf(n);
                            r !== -1 && a.splice(r, 1), a.length || delete e[t];
                        }
                    }
                };
            }
        };
    }).directive("modalBackdrop", [ "$animate", "$injector", "$modalStack", function(e, t, n) {
        function a(t, a, i) {
            i.modalInClass && (r ? r(a, {
                addClass: i.modalInClass
            }).start() : e.addClass(a, i.modalInClass), t.$on(n.NOW_CLOSING_EVENT, function(t, n) {
                var s = n();
                r ? r(a, {
                    removeClass: i.modalInClass
                }).start().then(s) : e.removeClass(a, i.modalInClass).then(s);
            }));
        }
        var r = null;
        return t.has("$animateCss") && (r = t.get("$animateCss")), {
            restrict: "EA",
            replace: !0,
            templateUrl: "template/modal/backdrop.html",
            compile: function(e, t) {
                return e.addClass(t.backdropClass), a;
            }
        };
    } ]).directive("modalWindow", [ "$modalStack", "$q", "$animate", "$injector", function(e, t, n, a) {
        var r = null;
        return a.has("$animateCss") && (r = a.get("$animateCss")), {
            restrict: "EA",
            scope: {
                index: "@"
            },
            replace: !0,
            transclude: !0,
            templateUrl: function(e, t) {
                return t.templateUrl || "template/modal/window.html";
            },
            link: function(a, i, s) {
                i.addClass(s.windowClass || ""), a.size = s.size, a.close = function(t) {
                    var n = e.getTop();
                    n && n.value.backdrop && "static" !== n.value.backdrop && t.target === t.currentTarget && (t.preventDefault(), 
                    t.stopPropagation(), e.dismiss(n.key, "backdrop click"));
                }, a.$isRendered = !0;
                var o = t.defer();
                s.$observe("modalRender", function(e) {
                    "true" == e && o.resolve();
                }), o.promise.then(function() {
                    var o = null;
                    s.modalInClass && (o = r ? r(i, {
                        addClass: s.modalInClass
                    }).start() : n.addClass(i, s.modalInClass), a.$on(e.NOW_CLOSING_EVENT, function(e, t) {
                        var a = t();
                        r ? r(i, {
                            removeClass: s.modalInClass
                        }).start().then(a) : n.removeClass(i, s.modalInClass).then(a);
                    })), t.when(o).then(function() {
                        var e = i[0].querySelectorAll("[autofocus]");
                        e.length ? e[0].focus() : i[0].focus();
                    });
                    var l = e.getTop();
                    l && e.modalRendered(l.key);
                });
            }
        };
    } ]).directive("modalAnimationClass", [ function() {
        return {
            compile: function(e, t) {
                t.modalAnimation && e.addClass(t.modalAnimationClass);
            }
        };
    } ]).directive("modalTransclude", function() {
        return {
            link: function(e, t, n, a, r) {
                r(e.$parent, function(e) {
                    t.empty(), t.append(e);
                });
            }
        };
    }).factory("$modalStack", [ "$animate", "$timeout", "$document", "$compile", "$rootScope", "$q", "$injector", "$$multiMap", "$$stackedMap", function(e, t, n, a, r, i, s, o, l) {
        function u() {
            for (var e = -1, t = b.keys(), n = 0; n < t.length; n++) b.get(t[n]).value.backdrop && (e = n);
            return e;
        }
        function c(e, t) {
            var a = n.find("body").eq(0), r = b.get(e).value;
            b.remove(e), m(r.modalDomEl, r.modalScope, function() {
                var t = r.openedClass || v;
                y.remove(t, e), a.toggleClass(t, y.hasKey(t));
            }), d(), t && t.focus ? t.focus() : a.focus();
        }
        function d() {
            if (h && u() == -1) {
                var e = g;
                m(h, g, function() {
                    e = null;
                }), h = void 0, g = void 0;
            }
        }
        function m(t, n, a) {
            function r() {
                r.done || (r.done = !0, p ? p(t, {
                    event: "leave"
                }).start().then(function() {
                    t.remove();
                }) : e.leave(t), n.$destroy(), a && a());
            }
            var s, o = null, l = function() {
                return s || (s = i.defer(), o = s.promise), function() {
                    s.resolve();
                };
            };
            return n.$broadcast(M.NOW_CLOSING_EVENT, l), i.when(o).then(r);
        }
        function f(e, t, n) {
            return !e.value.modalScope.$broadcast("modal.closing", t, n).defaultPrevented;
        }
        var p = null;
        s.has("$animateCss") && (p = s.get("$animateCss"));
        var h, g, _, v = "modal-open", b = l.createNew(), y = o.createNew(), M = {
            NOW_CLOSING_EVENT: "modal.stack.now-closing"
        }, $ = 0, k = "a[href], area[href], input:not([disabled]), button:not([disabled]),select:not([disabled]), textarea:not([disabled]), iframe, object, embed, *[tabindex], *[contenteditable=true]";
        return r.$watch(u, function(e) {
            g && (g.index = e);
        }), n.bind("keydown", function(e) {
            if (e.isDefaultPrevented()) return e;
            var t = b.top();
            if (t && t.value.keyboard) switch (e.which) {
              case 27:
                e.preventDefault(), r.$apply(function() {
                    M.dismiss(t.key, "escape key press");
                });
                break;

              case 9:
                M.loadFocusElementList(t);
                var n = !1;
                e.shiftKey ? M.isFocusInFirstItem(e) && (n = M.focusLastFocusableElement()) : M.isFocusInLastItem(e) && (n = M.focusFirstFocusableElement()), 
                n && (e.preventDefault(), e.stopPropagation());
            }
        }), M.open = function(e, t) {
            var i = n[0].activeElement, s = t.openedClass || v;
            b.add(e, {
                deferred: t.deferred,
                renderDeferred: t.renderDeferred,
                modalScope: t.scope,
                backdrop: t.backdrop,
                keyboard: t.keyboard,
                openedClass: t.openedClass
            }), y.put(s, e);
            var o = n.find("body").eq(0), l = u();
            if (l >= 0 && !h) {
                g = r.$new(!0), g.index = l;
                var c = angular.element('<div modal-backdrop="modal-backdrop"></div>');
                c.attr("backdrop-class", t.backdropClass), t.animation && c.attr("modal-animation", "true"), 
                h = a(c)(g), o.append(h);
            }
            var d = angular.element('<div modal-window="modal-window"></div>');
            d.attr({
                "template-url": t.windowTemplateUrl,
                "window-class": t.windowClass,
                size: t.size,
                index: b.length() - 1,
                animate: "animate"
            }).html(t.content), t.animation && d.attr("modal-animation", "true");
            var m = a(d)(t.scope);
            b.top().value.modalDomEl = m, b.top().value.modalOpener = i, o.append(m), o.addClass(s), 
            M.clearFocusListCache();
        }, M.close = function(e, t) {
            var n = b.get(e);
            return n && f(n, t, !0) ? (n.value.modalScope.$$uibDestructionScheduled = !0, n.value.deferred.resolve(t), 
            c(e, n.value.modalOpener), !0) : !n;
        }, M.dismiss = function(e, t) {
            var n = b.get(e);
            return n && f(n, t, !1) ? (n.value.modalScope.$$uibDestructionScheduled = !0, n.value.deferred.reject(t), 
            c(e, n.value.modalOpener), !0) : !n;
        }, M.dismissAll = function(e) {
            for (var t = this.getTop(); t && this.dismiss(t.key, e); ) t = this.getTop();
        }, M.getTop = function() {
            return b.top();
        }, M.modalRendered = function(e) {
            var t = b.get(e);
            t && t.value.renderDeferred.resolve();
        }, M.focusFirstFocusableElement = function() {
            return _.length > 0 && (_[0].focus(), !0);
        }, M.focusLastFocusableElement = function() {
            return _.length > 0 && (_[_.length - 1].focus(), !0);
        }, M.isFocusInFirstItem = function(e) {
            return _.length > 0 && (e.target || e.srcElement) == _[0];
        }, M.isFocusInLastItem = function(e) {
            return _.length > 0 && (e.target || e.srcElement) == _[_.length - 1];
        }, M.clearFocusListCache = function() {
            _ = [], $ = 0;
        }, M.loadFocusElementList = function(e) {
            if ((void 0 === _ || !_.length0) && e) {
                var t = e.value.modalDomEl;
                t && t.length && (_ = t[0].querySelectorAll(k));
            }
        }, M;
    } ]).provider("$modal", function() {
        var e = {
            options: {
                animation: !0,
                backdrop: !0,
                keyboard: !0
            },
            $get: [ "$injector", "$rootScope", "$q", "$templateRequest", "$controller", "$modalStack", function(t, n, a, r, i, s) {
                function o(e) {
                    return e.template ? a.when(e.template) : r(angular.isFunction(e.templateUrl) ? e.templateUrl() : e.templateUrl);
                }
                function l(e) {
                    var n = [];
                    return angular.forEach(e, function(e) {
                        angular.isFunction(e) || angular.isArray(e) ? n.push(a.when(t.invoke(e))) : angular.isString(e) ? n.push(a.when(t.get(e))) : n.push(a.when(e));
                    }), n;
                }
                var u = {}, c = null;
                return u.getPromiseChain = function() {
                    return c;
                }, u.open = function(t) {
                    var r = a.defer(), u = a.defer(), d = a.defer(), m = {
                        result: r.promise,
                        opened: u.promise,
                        rendered: d.promise,
                        close: function(e) {
                            return s.close(m, e);
                        },
                        dismiss: function(e) {
                            return s.dismiss(m, e);
                        }
                    };
                    if (t = angular.extend({}, e.options, t), t.resolve = t.resolve || {}, !t.template && !t.templateUrl) throw new Error("One of template or templateUrl options is required.");
                    var f, p = a.all([ o(t) ].concat(l(t.resolve)));
                    return f = c = a.all([ c ]).then(function() {
                        return p;
                    }, function() {
                        return p;
                    }).then(function(e) {
                        var a = (t.scope || n).$new();
                        a.$close = m.close, a.$dismiss = m.dismiss, a.$on("$destroy", function() {
                            a.$$uibDestructionScheduled || a.$dismiss("$uibUnscheduledDestruction");
                        });
                        var o, l = {}, c = 1;
                        t.controller && (l.$scope = a, l.$modalInstance = m, angular.forEach(t.resolve, function(t, n) {
                            l[n] = e[c++];
                        }), o = i(t.controller, l), t.controllerAs && (t.bindToController && angular.extend(o, a), 
                        a[t.controllerAs] = o)), s.open(m, {
                            scope: a,
                            deferred: r,
                            renderDeferred: d,
                            content: e[0],
                            animation: t.animation,
                            backdrop: t.backdrop,
                            keyboard: t.keyboard,
                            backdropClass: t.backdropClass,
                            windowClass: t.windowClass,
                            windowTemplateUrl: t.windowTemplateUrl,
                            size: t.size,
                            openedClass: t.openedClass
                        }), u.resolve(!0);
                    }, function(e) {
                        u.reject(e), r.reject(e);
                    }).finally(function() {
                        c === f && (c = null);
                    }), m;
                }, u;
            } ]
        };
        return e;
    }), angular.module("ui.bootstrap.pagination", []).controller("PaginationController", [ "$scope", "$attrs", "$parse", function(e, t, n) {
        var a = this, r = {
            $setViewValue: angular.noop
        }, i = t.numPages ? n(t.numPages).assign : angular.noop;
        this.init = function(s, o) {
            r = s, this.config = o, r.$render = function() {
                a.render();
            }, t.itemsPerPage ? e.$parent.$watch(n(t.itemsPerPage), function(t) {
                a.itemsPerPage = parseInt(t, 10), e.totalPages = a.calculateTotalPages();
            }) : this.itemsPerPage = o.itemsPerPage, e.$watch("totalItems", function() {
                e.totalPages = a.calculateTotalPages();
            }), e.$watch("totalPages", function(t) {
                i(e.$parent, t), e.page > t ? e.selectPage(t) : r.$render();
            });
        }, this.calculateTotalPages = function() {
            var t = this.itemsPerPage < 1 ? 1 : Math.ceil(e.totalItems / this.itemsPerPage);
            return Math.max(t || 0, 1);
        }, this.render = function() {
            e.page = parseInt(r.$viewValue, 10) || 1;
        }, e.selectPage = function(t, n) {
            n && n.preventDefault();
            var a = !e.ngDisabled || !n;
            a && e.page !== t && t > 0 && t <= e.totalPages && (n && n.target && n.target.blur(), 
            r.$setViewValue(t), r.$render());
        }, e.getText = function(t) {
            return e[t + "Text"] || a.config[t + "Text"];
        }, e.noPrevious = function() {
            return 1 === e.page;
        }, e.noNext = function() {
            return e.page === e.totalPages;
        };
    } ]).constant("paginationConfig", {
        itemsPerPage: 10,
        boundaryLinks: !1,
        directionLinks: !0,
        firstText: "First",
        previousText: "Previous",
        nextText: "Next",
        lastText: "Last",
        rotate: !0
    }).directive("pagination", [ "$parse", "paginationConfig", function(e, t) {
        return {
            restrict: "EA",
            scope: {
                totalItems: "=",
                firstText: "@",
                previousText: "@",
                nextText: "@",
                lastText: "@",
                ngDisabled: "="
            },
            require: [ "pagination", "?ngModel" ],
            controller: "PaginationController",
            controllerAs: "pagination",
            templateUrl: function(e, t) {
                return t.templateUrl || "template/pagination/pagination.html";
            },
            replace: !0,
            link: function(n, a, r, i) {
                function s(e, t, n) {
                    return {
                        number: e,
                        text: t,
                        active: n
                    };
                }
                function o(e, t) {
                    var n = [], a = 1, r = t, i = angular.isDefined(c) && c < t;
                    i && (d ? (a = Math.max(e - Math.floor(c / 2), 1), r = a + c - 1, r > t && (r = t, 
                    a = r - c + 1)) : (a = (Math.ceil(e / c) - 1) * c + 1, r = Math.min(a + c - 1, t)));
                    for (var o = a; o <= r; o++) {
                        var l = s(o, o, o === e);
                        n.push(l);
                    }
                    if (i && !d) {
                        if (a > 1) {
                            var u = s(a - 1, "...", !1);
                            n.unshift(u);
                        }
                        if (r < t) {
                            var m = s(r + 1, "...", !1);
                            n.push(m);
                        }
                    }
                    return n;
                }
                var l = i[0], u = i[1];
                if (u) {
                    var c = angular.isDefined(r.maxSize) ? n.$parent.$eval(r.maxSize) : t.maxSize, d = angular.isDefined(r.rotate) ? n.$parent.$eval(r.rotate) : t.rotate;
                    n.boundaryLinks = angular.isDefined(r.boundaryLinks) ? n.$parent.$eval(r.boundaryLinks) : t.boundaryLinks, 
                    n.directionLinks = angular.isDefined(r.directionLinks) ? n.$parent.$eval(r.directionLinks) : t.directionLinks, 
                    l.init(u, t), r.maxSize && n.$parent.$watch(e(r.maxSize), function(e) {
                        c = parseInt(e, 10), l.render();
                    });
                    var m = l.render;
                    l.render = function() {
                        m(), n.page > 0 && n.page <= n.totalPages && (n.pages = o(n.page, n.totalPages));
                    };
                }
            }
        };
    } ]).constant("pagerConfig", {
        itemsPerPage: 10,
        previousText: "« Previous",
        nextText: "Next »",
        align: !0
    }).directive("pager", [ "pagerConfig", function(e) {
        return {
            restrict: "EA",
            scope: {
                totalItems: "=",
                previousText: "@",
                nextText: "@",
                ngDisabled: "="
            },
            require: [ "pager", "?ngModel" ],
            controller: "PaginationController",
            controllerAs: "pagination",
            templateUrl: function(e, t) {
                return t.templateUrl || "template/pagination/pager.html";
            },
            replace: !0,
            link: function(t, n, a, r) {
                var i = r[0], s = r[1];
                s && (t.align = angular.isDefined(a.align) ? t.$parent.$eval(a.align) : e.align, 
                i.init(s, e));
            }
        };
    } ]), angular.module("ui.bootstrap.tooltip", [ "ui.bootstrap.position", "ui.bootstrap.bindHtml" ]).provider("$tooltip", function() {
        function e(e) {
            var t = /[A-Z]/g, n = "-";
            return e.replace(t, function(e, t) {
                return (t ? n : "") + e.toLowerCase();
            });
        }
        var t = {
            placement: "top",
            animation: !0,
            popupDelay: 0,
            useContentExp: !1
        }, n = {
            mouseenter: "mouseleave",
            click: "click",
            focus: "blur",
            none: ""
        }, a = {};
        this.options = function(e) {
            angular.extend(a, e);
        }, this.setTriggers = function(e) {
            angular.extend(n, e);
        }, this.$get = [ "$window", "$compile", "$timeout", "$document", "$position", "$interpolate", "$rootScope", "$parse", function(r, i, s, o, l, u, c, d) {
            return function(r, m, f, p) {
                function h(e) {
                    var t = (e || p.trigger || f).split(" "), a = t.map(function(e) {
                        return n[e] || e;
                    });
                    return {
                        show: t,
                        hide: a
                    };
                }
                p = angular.extend({}, t, a, p);
                var g = e(r), _ = u.startSymbol(), v = u.endSymbol(), b = "<div " + g + '-popup title="' + _ + "title" + v + '" ' + (p.useContentExp ? 'content-exp="contentExp()" ' : 'content="' + _ + "content" + v + '" ') + 'placement="' + _ + "placement" + v + '" popup-class="' + _ + "popupClass" + v + '" animation="animation" is-open="isOpen"origin-scope="origScope" ></div>';
                return {
                    restrict: "EA",
                    compile: function(e, t) {
                        var n = i(b);
                        return function(e, t, a, i) {
                            function u() {
                                A.isOpen ? g() : f();
                            }
                            function f() {
                                H && !e.$eval(a[m + "Enable"]) || (M(), A.popupDelay ? S || (S = s(_, A.popupDelay, !1)) : _());
                            }
                            function g() {
                                v(), c.$$phase || c.$digest();
                            }
                            function _() {
                                return S = null, T && (s.cancel(T), T = null), (p.useContentExp ? A.contentExp() : A.content) ? (b(), 
                                A.isOpen = !0, O && O.assign(A.origScope, A.isOpen), c.$$phase || A.$apply(), D.css({
                                    display: "block"
                                }), void I()) : angular.noop;
                            }
                            function v() {
                                A.isOpen = !1, O && O.assign(A.origScope, A.isOpen), s.cancel(S), S = null, s.cancel(x), 
                                x = null, A.animation ? T || (T = s(y, 500)) : y();
                            }
                            function b() {
                                D && y(), Y = A.$new(), D = n(Y, function(e) {
                                    C ? o.find("body").append(e) : t.after(e);
                                }), p.useContentExp && (Y.$watch("contentExp()", function(e) {
                                    !e && A.isOpen && v();
                                }), Y.$watch(function() {
                                    j || (j = !0, Y.$$postDigest(function() {
                                        j = !1, A.isOpen && I();
                                    }));
                                }));
                            }
                            function y() {
                                T = null, D && (D.remove(), D = null), Y && (Y.$destroy(), Y = null);
                            }
                            function M() {
                                $(), k(), w();
                            }
                            function $() {
                                A.popupClass = a[m + "Class"];
                            }
                            function k() {
                                var e = a[m + "Placement"];
                                A.placement = angular.isDefined(e) ? e : p.placement;
                            }
                            function w() {
                                var e = a[m + "PopupDelay"], t = parseInt(e, 10);
                                A.popupDelay = isNaN(t) ? p.popupDelay : t;
                            }
                            function L() {
                                var e = a[m + "Trigger"];
                                P(), E = h(e), "none" !== E.show && E.show.forEach(function(e, n) {
                                    e === E.hide[n] ? t[0].addEventListener(e, u) : e && (t[0].addEventListener(e, f), 
                                    t[0].addEventListener(E.hide[n], g));
                                });
                            }
                            var D, Y, T, S, x, C = !!angular.isDefined(p.appendToBody) && p.appendToBody, E = h(void 0), H = angular.isDefined(a[m + "Enable"]), A = e.$new(!0), j = !1, O = !!angular.isDefined(a[m + "IsOpen"]) && d(a[m + "IsOpen"]), I = function() {
                                D && (x || (x = s(function() {
                                    D.css({
                                        top: 0,
                                        left: 0,
                                        width: "auto",
                                        height: "auto"
                                    });
                                    var e = l.position(D), n = l.positionElements(t, D, A.placement, C);
                                    n.top += "px", n.left += "px", n.width = e.width + "px", n.height = e.height + "px", 
                                    D.css(n), x = null;
                                }, 0, !1)));
                            };
                            A.origScope = e, A.isOpen = !1, A.contentExp = function() {
                                return e.$eval(a[r]);
                            }, p.useContentExp || a.$observe(r, function(e) {
                                A.content = e, !e && A.isOpen ? v() : I();
                            }), a.$observe("disabled", function(e) {
                                S && e && (s.cancel(S), S = null), e && A.isOpen && v();
                            }), a.$observe(m + "Title", function(e) {
                                A.title = e, I();
                            }), a.$observe(m + "Placement", function() {
                                A.isOpen && (k(), I());
                            }), O && e.$watch(O, function(e) {
                                e !== A.isOpen && u();
                            });
                            var P = function() {
                                E.show.forEach(function(e) {
                                    t.unbind(e, f);
                                }), E.hide.forEach(function(e) {
                                    t.unbind(e, g);
                                });
                            };
                            L();
                            var F = e.$eval(a[m + "Animation"]);
                            A.animation = angular.isDefined(F) ? !!F : p.animation;
                            var U = e.$eval(a[m + "AppendToBody"]);
                            C = angular.isDefined(U) ? U : C, C && e.$on("$locationChangeSuccess", function() {
                                A.isOpen && v();
                            }), e.$on("$destroy", function() {
                                s.cancel(T), s.cancel(S), s.cancel(x), P(), y(), A = null;
                            });
                        };
                    }
                };
            };
        } ];
    }).directive("tooltipTemplateTransclude", [ "$animate", "$sce", "$compile", "$templateRequest", function(e, t, n, a) {
        return {
            link: function(r, i, s) {
                var o, l, u, c = r.$eval(s.tooltipTemplateTranscludeScope), d = 0, m = function() {
                    l && (l.remove(), l = null), o && (o.$destroy(), o = null), u && (e.leave(u).then(function() {
                        l = null;
                    }), l = u, u = null);
                };
                r.$watch(t.parseAsResourceUrl(s.tooltipTemplateTransclude), function(t) {
                    var s = ++d;
                    t ? (a(t, !0).then(function(a) {
                        if (s === d) {
                            var r = c.$new(), l = a, f = n(l)(r, function(t) {
                                m(), e.enter(t, i);
                            });
                            o = r, u = f, o.$emit("$includeContentLoaded", t);
                        }
                    }, function() {
                        s === d && (m(), r.$emit("$includeContentError", t));
                    }), r.$emit("$includeContentRequested", t)) : m();
                }), r.$on("$destroy", m);
            }
        };
    } ]).directive("tooltipClasses", function() {
        return {
            restrict: "A",
            link: function(e, t, n) {
                e.placement && t.addClass(e.placement), e.popupClass && t.addClass(e.popupClass), 
                e.animation() && t.addClass(n.tooltipAnimationClass);
            }
        };
    }).directive("tooltipPopup", function() {
        return {
            restrict: "EA",
            replace: !0,
            scope: {
                content: "@",
                placement: "@",
                popupClass: "@",
                animation: "&",
                isOpen: "&"
            },
            templateUrl: "template/tooltip/tooltip-popup.html"
        };
    }).directive("tooltip", [ "$tooltip", function(e) {
        return e("tooltip", "tooltip", "mouseenter");
    } ]).directive("tooltipTemplatePopup", function() {
        return {
            restrict: "EA",
            replace: !0,
            scope: {
                contentExp: "&",
                placement: "@",
                popupClass: "@",
                animation: "&",
                isOpen: "&",
                originScope: "&"
            },
            templateUrl: "template/tooltip/tooltip-template-popup.html"
        };
    }).directive("tooltipTemplate", [ "$tooltip", function(e) {
        return e("tooltipTemplate", "tooltip", "mouseenter", {
            useContentExp: !0
        });
    } ]).directive("tooltipHtmlPopup", function() {
        return {
            restrict: "EA",
            replace: !0,
            scope: {
                contentExp: "&",
                placement: "@",
                popupClass: "@",
                animation: "&",
                isOpen: "&"
            },
            templateUrl: "template/tooltip/tooltip-html-popup.html"
        };
    }).directive("tooltipHtml", [ "$tooltip", function(e) {
        return e("tooltipHtml", "tooltip", "mouseenter", {
            useContentExp: !0
        });
    } ]).directive("tooltipHtmlUnsafePopup", function() {
        return {
            restrict: "EA",
            replace: !0,
            scope: {
                content: "@",
                placement: "@",
                popupClass: "@",
                animation: "&",
                isOpen: "&"
            },
            templateUrl: "template/tooltip/tooltip-html-unsafe-popup.html"
        };
    }).value("tooltipHtmlUnsafeSuppressDeprecated", !1).directive("tooltipHtmlUnsafe", [ "$tooltip", "tooltipHtmlUnsafeSuppressDeprecated", "$log", function(e, t, n) {
        return t || n.warn("tooltip-html-unsafe is now deprecated. Use tooltip-html or tooltip-template instead."), 
        e("tooltipHtmlUnsafe", "tooltip", "mouseenter");
    } ]), angular.module("ui.bootstrap.popover", [ "ui.bootstrap.tooltip" ]).directive("popoverTemplatePopup", function() {
        return {
            restrict: "EA",
            replace: !0,
            scope: {
                title: "@",
                contentExp: "&",
                placement: "@",
                popupClass: "@",
                animation: "&",
                isOpen: "&",
                originScope: "&"
            },
            templateUrl: "template/popover/popover-template.html"
        };
    }).directive("popoverTemplate", [ "$tooltip", function(e) {
        return e("popoverTemplate", "popover", "click", {
            useContentExp: !0
        });
    } ]).directive("popoverHtmlPopup", function() {
        return {
            restrict: "EA",
            replace: !0,
            scope: {
                contentExp: "&",
                title: "@",
                placement: "@",
                popupClass: "@",
                animation: "&",
                isOpen: "&"
            },
            templateUrl: "template/popover/popover-html.html"
        };
    }).directive("popoverHtml", [ "$tooltip", function(e) {
        return e("popoverHtml", "popover", "click", {
            useContentExp: !0
        });
    } ]).directive("popoverPopup", function() {
        return {
            restrict: "EA",
            replace: !0,
            scope: {
                title: "@",
                content: "@",
                placement: "@",
                popupClass: "@",
                animation: "&",
                isOpen: "&"
            },
            templateUrl: "template/popover/popover.html"
        };
    }).directive("popover", [ "$tooltip", function(e) {
        return e("popover", "popover", "click");
    } ]), angular.module("ui.bootstrap.progressbar", []).constant("progressConfig", {
        animate: !0,
        max: 100
    }).value("$progressSuppressWarning", !1).controller("ProgressController", [ "$scope", "$attrs", "progressConfig", function(e, t, n) {
        var a = this, r = angular.isDefined(t.animate) ? e.$parent.$eval(t.animate) : n.animate;
        this.bars = [], e.max = angular.isDefined(e.max) ? e.max : n.max, this.addBar = function(t, n) {
            r || n.css({
                transition: "none"
            }), this.bars.push(t), t.max = e.max, t.$watch("value", function(e) {
                t.recalculatePercentage();
            }), t.recalculatePercentage = function() {
                t.percent = +(100 * t.value / t.max).toFixed(2);
                var e = a.bars.reduce(function(e, t) {
                    return e + t.percent;
                }, 0);
                e > 100 && (t.percent -= e - 100);
            }, t.$on("$destroy", function() {
                n = null, a.removeBar(t);
            });
        }, this.removeBar = function(e) {
            this.bars.splice(this.bars.indexOf(e), 1);
        }, e.$watch("max", function(t) {
            a.bars.forEach(function(t) {
                t.max = e.max, t.recalculatePercentage();
            });
        });
    } ]).directive("uibProgress", function() {
        return {
            restrict: "EA",
            replace: !0,
            transclude: !0,
            controller: "ProgressController",
            require: "uibProgress",
            scope: {
                max: "=?"
            },
            templateUrl: "template/progressbar/progress.html"
        };
    }).directive("progress", [ "$log", "$progressSuppressWarning", function(e, t) {
        return {
            restrict: "EA",
            replace: !0,
            transclude: !0,
            controller: "ProgressController",
            require: "progress",
            scope: {
                max: "=?"
            },
            templateUrl: "template/progressbar/progress.html",
            link: function() {
                t && e.warn("progress is now deprecated. Use uib-progress instead");
            }
        };
    } ]).directive("uibBar", function() {
        return {
            restrict: "EA",
            replace: !0,
            transclude: !0,
            require: "^uibProgress",
            scope: {
                value: "=",
                type: "@"
            },
            templateUrl: "template/progressbar/bar.html",
            link: function(e, t, n, a) {
                a.addBar(e, t);
            }
        };
    }).directive("bar", [ "$log", "$progressSuppressWarning", function(e, t) {
        return {
            restrict: "EA",
            replace: !0,
            transclude: !0,
            require: "^progress",
            scope: {
                value: "=",
                type: "@"
            },
            templateUrl: "template/progressbar/bar.html",
            link: function(n, a, r, i) {
                t && e.warn("bar is now deprecated. Use uib-bar instead"), i.addBar(n, a);
            }
        };
    } ]).directive("progressbar", function() {
        return {
            restrict: "EA",
            replace: !0,
            transclude: !0,
            controller: "ProgressController",
            scope: {
                value: "=",
                max: "=?",
                type: "@"
            },
            templateUrl: "template/progressbar/progressbar.html",
            link: function(e, t, n, a) {
                a.addBar(e, angular.element(t.children()[0]));
            }
        };
    }), angular.module("ui.bootstrap.rating", []).constant("ratingConfig", {
        max: 5,
        stateOn: null,
        stateOff: null,
        titles: [ "one", "two", "three", "four", "five" ]
    }).controller("RatingController", [ "$scope", "$attrs", "ratingConfig", function(e, t, n) {
        var a = {
            $setViewValue: angular.noop
        };
        this.init = function(r) {
            a = r, a.$render = this.render, a.$formatters.push(function(e) {
                return angular.isNumber(e) && e << 0 !== e && (e = Math.round(e)), e;
            }), this.stateOn = angular.isDefined(t.stateOn) ? e.$parent.$eval(t.stateOn) : n.stateOn, 
            this.stateOff = angular.isDefined(t.stateOff) ? e.$parent.$eval(t.stateOff) : n.stateOff;
            var i = angular.isDefined(t.titles) ? e.$parent.$eval(t.titles) : n.titles;
            this.titles = angular.isArray(i) && i.length > 0 ? i : n.titles;
            var s = angular.isDefined(t.ratingStates) ? e.$parent.$eval(t.ratingStates) : new Array(angular.isDefined(t.max) ? e.$parent.$eval(t.max) : n.max);
            e.range = this.buildTemplateObjects(s);
        }, this.buildTemplateObjects = function(e) {
            for (var t = 0, n = e.length; t < n; t++) e[t] = angular.extend({
                index: t
            }, {
                stateOn: this.stateOn,
                stateOff: this.stateOff,
                title: this.getTitle(t)
            }, e[t]);
            return e;
        }, this.getTitle = function(e) {
            return e >= this.titles.length ? e + 1 : this.titles[e];
        }, e.rate = function(t) {
            !e.readonly && t >= 0 && t <= e.range.length && (a.$setViewValue(a.$viewValue === t ? 0 : t), 
            a.$render());
        }, e.enter = function(t) {
            e.readonly || (e.value = t), e.onHover({
                value: t
            });
        }, e.reset = function() {
            e.value = a.$viewValue, e.onLeave();
        }, e.onKeydown = function(t) {
            /(37|38|39|40)/.test(t.which) && (t.preventDefault(), t.stopPropagation(), e.rate(e.value + (38 === t.which || 39 === t.which ? 1 : -1)));
        }, this.render = function() {
            e.value = a.$viewValue;
        };
    } ]).directive("rating", function() {
        return {
            restrict: "EA",
            require: [ "rating", "ngModel" ],
            scope: {
                readonly: "=?",
                onHover: "&",
                onLeave: "&"
            },
            controller: "RatingController",
            templateUrl: "template/rating/rating.html",
            replace: !0,
            link: function(e, t, n, a) {
                var r = a[0], i = a[1];
                r.init(i);
            }
        };
    }), angular.module("ui.bootstrap.tabs", []).controller("TabsetController", [ "$scope", function(e) {
        var t = this, n = t.tabs = e.tabs = [];
        t.select = function(e) {
            angular.forEach(n, function(t) {
                t.active && t !== e && (t.active = !1, t.onDeselect(), e.selectCalled = !1);
            }), e.active = !0, e.selectCalled || (e.onSelect(), e.selectCalled = !0);
        }, t.addTab = function(e) {
            n.push(e), 1 === n.length && e.active !== !1 ? e.active = !0 : e.active ? t.select(e) : e.active = !1;
        }, t.removeTab = function(e) {
            var r = n.indexOf(e);
            if (e.active && n.length > 1 && !a) {
                var i = r == n.length - 1 ? r - 1 : r + 1;
                t.select(n[i]);
            }
            n.splice(r, 1);
        };
        var a;
        e.$on("$destroy", function() {
            a = !0;
        });
    } ]).directive("tabset", function() {
        return {
            restrict: "EA",
            transclude: !0,
            replace: !0,
            scope: {
                type: "@"
            },
            controller: "TabsetController",
            templateUrl: "template/tabs/tabset.html",
            link: function(e, t, n) {
                e.vertical = !!angular.isDefined(n.vertical) && e.$parent.$eval(n.vertical), e.justified = !!angular.isDefined(n.justified) && e.$parent.$eval(n.justified);
            }
        };
    }).directive("tab", [ "$parse", "$log", function(e, t) {
        return {
            require: "^tabset",
            restrict: "EA",
            replace: !0,
            templateUrl: "template/tabs/tab.html",
            transclude: !0,
            scope: {
                active: "=?",
                heading: "@",
                onSelect: "&select",
                onDeselect: "&deselect"
            },
            controller: function() {},
            link: function(n, a, r, i, s) {
                n.$watch("active", function(e) {
                    e && i.select(n);
                }), n.disabled = !1, r.disable && n.$parent.$watch(e(r.disable), function(e) {
                    n.disabled = !!e;
                }), r.disabled && (t.warn('Use of "disabled" attribute has been deprecated, please use "disable"'), 
                n.$parent.$watch(e(r.disabled), function(e) {
                    n.disabled = !!e;
                })), n.select = function() {
                    n.disabled || (n.active = !0);
                }, i.addTab(n), n.$on("$destroy", function() {
                    i.removeTab(n);
                }), n.$transcludeFn = s;
            }
        };
    } ]).directive("tabHeadingTransclude", function() {
        return {
            restrict: "A",
            require: "^tab",
            link: function(e, t, n, a) {
                e.$watch("headingElement", function(e) {
                    e && (t.html(""), t.append(e));
                });
            }
        };
    }).directive("tabContentTransclude", function() {
        function e(e) {
            return e.tagName && (e.hasAttribute("tab-heading") || e.hasAttribute("data-tab-heading") || e.hasAttribute("x-tab-heading") || "tab-heading" === e.tagName.toLowerCase() || "data-tab-heading" === e.tagName.toLowerCase() || "x-tab-heading" === e.tagName.toLowerCase());
        }
        return {
            restrict: "A",
            require: "^tabset",
            link: function(t, n, a) {
                var r = t.$eval(a.tabContentTransclude);
                r.$transcludeFn(r.$parent, function(t) {
                    angular.forEach(t, function(t) {
                        e(t) ? r.headingElement = t : n.append(t);
                    });
                });
            }
        };
    }), angular.module("ui.bootstrap.timepicker", []).constant("timepickerConfig", {
        hourStep: 1,
        minuteStep: 1,
        showMeridian: !0,
        meridians: null,
        readonlyInput: !1,
        mousewheel: !0,
        arrowkeys: !0,
        showSpinners: !0
    }).controller("TimepickerController", [ "$scope", "$attrs", "$parse", "$log", "$locale", "timepickerConfig", function(e, t, n, a, r, i) {
        function s() {
            var t = parseInt(e.hours, 10), n = e.showMeridian ? t > 0 && t < 13 : t >= 0 && t < 24;
            if (n) return e.showMeridian && (12 === t && (t = 0), e.meridian === g[1] && (t += 12)), 
            t;
        }
        function o() {
            var t = parseInt(e.minutes, 10);
            return t >= 0 && t < 60 ? t : void 0;
        }
        function l(e) {
            return angular.isDefined(e) && e.toString().length < 2 ? "0" + e : e.toString();
        }
        function u(e) {
            c(), h.$setViewValue(new Date(p)), d(e);
        }
        function c() {
            h.$setValidity("time", !0), e.invalidHours = !1, e.invalidMinutes = !1;
        }
        function d(t) {
            var n = p.getHours(), a = p.getMinutes();
            e.showMeridian && (n = 0 === n || 12 === n ? 12 : n % 12), e.hours = "h" === t ? n : l(n), 
            "m" !== t && (e.minutes = l(a)), e.meridian = p.getHours() < 12 ? g[0] : g[1];
        }
        function m(e, t) {
            var n = new Date(e.getTime() + 6e4 * t), a = new Date(e);
            return a.setHours(n.getHours(), n.getMinutes()), a;
        }
        function f(e) {
            p = m(p, e), u();
        }
        var p = new Date(), h = {
            $setViewValue: angular.noop
        }, g = angular.isDefined(t.meridians) ? e.$parent.$eval(t.meridians) : i.meridians || r.DATETIME_FORMATS.AMPMS;
        this.init = function(n, a) {
            h = n, h.$render = this.render, h.$formatters.unshift(function(e) {
                return e ? new Date(e) : null;
            });
            var r = a.eq(0), s = a.eq(1), o = angular.isDefined(t.mousewheel) ? e.$parent.$eval(t.mousewheel) : i.mousewheel;
            o && this.setupMousewheelEvents(r, s);
            var l = angular.isDefined(t.arrowkeys) ? e.$parent.$eval(t.arrowkeys) : i.arrowkeys;
            l && this.setupArrowkeyEvents(r, s), e.readonlyInput = angular.isDefined(t.readonlyInput) ? e.$parent.$eval(t.readonlyInput) : i.readonlyInput, 
            this.setupInputEvents(r, s);
        };
        var _ = i.hourStep;
        t.hourStep && e.$parent.$watch(n(t.hourStep), function(e) {
            _ = parseInt(e, 10);
        });
        var v = i.minuteStep;
        t.minuteStep && e.$parent.$watch(n(t.minuteStep), function(e) {
            v = parseInt(e, 10);
        });
        var b;
        e.$parent.$watch(n(t.min), function(e) {
            var t = new Date(e);
            b = isNaN(t) ? void 0 : t;
        });
        var y;
        e.$parent.$watch(n(t.max), function(e) {
            var t = new Date(e);
            y = isNaN(t) ? void 0 : t;
        }), e.noIncrementHours = function() {
            var e = m(p, 60 * _);
            return e > y || e < p && e < b;
        }, e.noDecrementHours = function() {
            var e = m(p, 60 * -_);
            return e < b || e > p && e > y;
        }, e.noIncrementMinutes = function() {
            var e = m(p, v);
            return e > y || e < p && e < b;
        }, e.noDecrementMinutes = function() {
            var e = m(p, -v);
            return e < b || e > p && e > y;
        }, e.noToggleMeridian = function() {
            return p.getHours() < 13 ? m(p, 720) > y : m(p, -720) < b;
        }, e.showMeridian = i.showMeridian, t.showMeridian && e.$parent.$watch(n(t.showMeridian), function(t) {
            if (e.showMeridian = !!t, h.$error.time) {
                var n = s(), a = o();
                angular.isDefined(n) && angular.isDefined(a) && (p.setHours(n), u());
            } else d();
        }), this.setupMousewheelEvents = function(t, n) {
            var a = function(e) {
                e.originalEvent && (e = e.originalEvent);
                var t = e.wheelDelta ? e.wheelDelta : -e.deltaY;
                return e.detail || t > 0;
            };
            t.bind("mousewheel wheel", function(t) {
                e.$apply(a(t) ? e.incrementHours() : e.decrementHours()), t.preventDefault();
            }), n.bind("mousewheel wheel", function(t) {
                e.$apply(a(t) ? e.incrementMinutes() : e.decrementMinutes()), t.preventDefault();
            });
        }, this.setupArrowkeyEvents = function(t, n) {
            t.bind("keydown", function(t) {
                38 === t.which ? (t.preventDefault(), e.incrementHours(), e.$apply()) : 40 === t.which && (t.preventDefault(), 
                e.decrementHours(), e.$apply());
            }), n.bind("keydown", function(t) {
                38 === t.which ? (t.preventDefault(), e.incrementMinutes(), e.$apply()) : 40 === t.which && (t.preventDefault(), 
                e.decrementMinutes(), e.$apply());
            });
        }, this.setupInputEvents = function(t, n) {
            if (e.readonlyInput) return e.updateHours = angular.noop, void (e.updateMinutes = angular.noop);
            var a = function(t, n) {
                h.$setViewValue(null), h.$setValidity("time", !1), angular.isDefined(t) && (e.invalidHours = t), 
                angular.isDefined(n) && (e.invalidMinutes = n);
            };
            e.updateHours = function() {
                var e = s(), t = o();
                angular.isDefined(e) && angular.isDefined(t) ? (p.setHours(e), p < b || p > y ? a(!0) : u("h")) : a(!0);
            }, t.bind("blur", function(t) {
                !e.invalidHours && e.hours < 10 && e.$apply(function() {
                    e.hours = l(e.hours);
                });
            }), e.updateMinutes = function() {
                var e = o(), t = s();
                angular.isDefined(e) && angular.isDefined(t) ? (p.setMinutes(e), p < b || p > y ? a(void 0, !0) : u("m")) : a(void 0, !0);
            }, n.bind("blur", function(t) {
                !e.invalidMinutes && e.minutes < 10 && e.$apply(function() {
                    e.minutes = l(e.minutes);
                });
            });
        }, this.render = function() {
            var t = h.$viewValue;
            isNaN(t) ? (h.$setValidity("time", !1), a.error('Timepicker directive: "ng-model" value must be a Date object, a number of milliseconds since 01.01.1970 or a string representing an RFC2822 or ISO 8601 date.')) : (t && (p = t), 
            p < b || p > y ? (h.$setValidity("time", !1), e.invalidHours = !0, e.invalidMinutes = !0) : c(), 
            d());
        }, e.showSpinners = angular.isDefined(t.showSpinners) ? e.$parent.$eval(t.showSpinners) : i.showSpinners, 
        e.incrementHours = function() {
            e.noIncrementHours() || f(60 * _);
        }, e.decrementHours = function() {
            e.noDecrementHours() || f(60 * -_);
        }, e.incrementMinutes = function() {
            e.noIncrementMinutes() || f(v);
        }, e.decrementMinutes = function() {
            e.noDecrementMinutes() || f(-v);
        }, e.toggleMeridian = function() {
            e.noToggleMeridian() || f(720 * (p.getHours() < 12 ? 1 : -1));
        };
    } ]).directive("timepicker", function() {
        return {
            restrict: "EA",
            require: [ "timepicker", "?^ngModel" ],
            controller: "TimepickerController",
            controllerAs: "timepicker",
            replace: !0,
            scope: {},
            templateUrl: function(e, t) {
                return t.templateUrl || "template/timepicker/timepicker.html";
            },
            link: function(e, t, n, a) {
                var r = a[0], i = a[1];
                i && r.init(i, t.find("input"));
            }
        };
    }), angular.module("ui.bootstrap.transition", []).value("$transitionSuppressDeprecated", !1).factory("$transition", [ "$q", "$timeout", "$rootScope", "$log", "$transitionSuppressDeprecated", function(e, t, n, a, r) {
        function i(e) {
            for (var t in e) if (void 0 !== o.style[t]) return e[t];
        }
        r || a.warn("$transition is now deprecated. Use $animate from ngAnimate instead.");
        var s = function(a, r, i) {
            i = i || {};
            var o = e.defer(), l = s[i.animation ? "animationEndEventName" : "transitionEndEventName"], u = function(e) {
                n.$apply(function() {
                    a.unbind(l, u), o.resolve(a);
                });
            };
            return l && a.bind(l, u), t(function() {
                angular.isString(r) ? a.addClass(r) : angular.isFunction(r) ? r(a) : angular.isObject(r) && a.css(r), 
                l || o.resolve(a);
            }), o.promise.cancel = function() {
                l && a.unbind(l, u), o.reject("Transition cancelled");
            }, o.promise;
        }, o = document.createElement("trans"), l = {
            WebkitTransition: "webkitTransitionEnd",
            MozTransition: "transitionend",
            OTransition: "oTransitionEnd",
            transition: "transitionend"
        }, u = {
            WebkitTransition: "webkitAnimationEnd",
            MozTransition: "animationend",
            OTransition: "oAnimationEnd",
            transition: "animationend"
        };
        return s.transitionEndEventName = i(l), s.animationEndEventName = i(u), s;
    } ]), angular.module("ui.bootstrap.typeahead", [ "ui.bootstrap.position" ]).factory("typeaheadParser", [ "$parse", function(e) {
        var t = /^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w\d]*))\s+in\s+([\s\S]+?)$/;
        return {
            parse: function(n) {
                var a = n.match(t);
                if (!a) throw new Error('Expected typeahead specification in form of "_modelValue_ (as _label_)? for _item_ in _collection_" but got "' + n + '".');
                return {
                    itemName: a[3],
                    source: e(a[4]),
                    viewMapper: e(a[2] || a[1]),
                    modelMapper: e(a[1])
                };
            }
        };
    } ]).directive("typeahead", [ "$compile", "$parse", "$q", "$timeout", "$document", "$window", "$rootScope", "$position", "typeaheadParser", function(e, t, n, a, r, i, s, o, l) {
        var u = [ 9, 13, 27, 38, 40 ], c = 200;
        return {
            require: [ "ngModel", "^?ngModelOptions" ],
            link: function(d, m, f, p) {
                function h() {
                    O.moveInProgress || (O.moveInProgress = !0, O.$digest()), q && a.cancel(q), q = a(function() {
                        O.matches.length && g(), O.moveInProgress = !1, O.$digest();
                    }, c);
                }
                function g() {
                    O.position = S ? o.offset(m) : o.position(m), O.position.top += m.prop("offsetHeight");
                }
                var _ = p[0], v = p[1], b = d.$eval(f.typeaheadMinLength);
                b || 0 === b || (b = 1);
                var y, M, $ = d.$eval(f.typeaheadWaitMs) || 0, k = d.$eval(f.typeaheadEditable) !== !1, w = t(f.typeaheadLoading).assign || angular.noop, L = t(f.typeaheadOnSelect), D = !!angular.isDefined(f.typeaheadSelectOnBlur) && d.$eval(f.typeaheadSelectOnBlur), Y = t(f.typeaheadNoResults).assign || angular.noop, T = f.typeaheadInputFormatter ? t(f.typeaheadInputFormatter) : void 0, S = !!f.typeaheadAppendToBody && d.$eval(f.typeaheadAppendToBody), x = d.$eval(f.typeaheadFocusFirst) !== !1, C = !!f.typeaheadSelectOnExact && d.$eval(f.typeaheadSelectOnExact), E = t(f.ngModel), H = t(f.ngModel + "($$$p)"), A = function(e, t) {
                    return angular.isFunction(E(d)) && v && v.$options && v.$options.getterSetter ? H(e, {
                        $$$p: t
                    }) : E.assign(e, t);
                }, j = l.parse(f.typeahead), O = d.$new(), I = d.$on("$destroy", function() {
                    O.$destroy();
                });
                O.$on("$destroy", I);
                var P = "typeahead-" + O.$id + "-" + Math.floor(1e4 * Math.random());
                m.attr({
                    "aria-autocomplete": "list",
                    "aria-expanded": !1,
                    "aria-owns": P
                });
                var F = angular.element("<div typeahead-popup></div>");
                F.attr({
                    id: P,
                    matches: "matches",
                    active: "activeIdx",
                    select: "select(activeIdx)",
                    "move-in-progress": "moveInProgress",
                    query: "query",
                    position: "position"
                }), angular.isDefined(f.typeaheadTemplateUrl) && F.attr("template-url", f.typeaheadTemplateUrl), 
                angular.isDefined(f.typeaheadPopupTemplateUrl) && F.attr("popup-template-url", f.typeaheadPopupTemplateUrl);
                var U = function() {
                    O.matches = [], O.activeIdx = -1, m.attr("aria-expanded", !1);
                }, N = function(e) {
                    return P + "-option-" + e;
                };
                O.$watch("activeIdx", function(e) {
                    e < 0 ? m.removeAttr("aria-activedescendant") : m.attr("aria-activedescendant", N(e));
                });
                var V = function(e, t) {
                    return !!(O.matches.length > t && e) && e.toUpperCase() === O.matches[t].label.toUpperCase();
                }, W = function(e) {
                    var t = {
                        $viewValue: e
                    };
                    w(d, !0), Y(d, !1), n.when(j.source(d, t)).then(function(n) {
                        var a = e === _.$viewValue;
                        if (a && y) if (n && n.length > 0) {
                            O.activeIdx = x ? 0 : -1, Y(d, !1), O.matches.length = 0;
                            for (var r = 0; r < n.length; r++) t[j.itemName] = n[r], O.matches.push({
                                id: N(r),
                                label: j.viewMapper(O, t),
                                model: n[r]
                            });
                            O.query = e, g(), m.attr("aria-expanded", !0), C && 1 === O.matches.length && V(e, 0) && O.select(0);
                        } else U(), Y(d, !0);
                        a && w(d, !1);
                    }, function() {
                        U(), w(d, !1), Y(d, !0);
                    });
                };
                S && (angular.element(i).bind("resize", h), r.find("body").bind("scroll", h));
                var q;
                O.moveInProgress = !1, U(), O.query = void 0;
                var R, z = function(e) {
                    R = a(function() {
                        W(e);
                    }, $);
                }, B = function() {
                    R && a.cancel(R);
                };
                _.$parsers.unshift(function(e) {
                    return y = !0, 0 === b || e && e.length >= b ? $ > 0 ? (B(), z(e)) : W(e) : (w(d, !1), 
                    B(), U()), k ? e : e ? void _.$setValidity("editable", !1) : (_.$setValidity("editable", !0), 
                    null);
                }), _.$formatters.push(function(e) {
                    var t, n, a = {};
                    return k || _.$setValidity("editable", !0), T ? (a.$model = e, T(d, a)) : (a[j.itemName] = e, 
                    t = j.viewMapper(d, a), a[j.itemName] = void 0, n = j.viewMapper(d, a), t !== n ? t : e);
                }), O.select = function(e) {
                    var t, n, r = {};
                    M = !0, r[j.itemName] = n = O.matches[e].model, t = j.modelMapper(d, r), A(d, t), 
                    _.$setValidity("editable", !0), _.$setValidity("parse", !0), L(d, {
                        $item: n,
                        $model: t,
                        $label: j.viewMapper(d, r)
                    }), U(), O.$eval(f.typeaheadFocusOnSelect) !== !1 && a(function() {
                        m[0].focus();
                    }, 0, !1);
                }, m.bind("keydown", function(e) {
                    if (0 !== O.matches.length && u.indexOf(e.which) !== -1) {
                        if (O.activeIdx === -1 && (9 === e.which || 13 === e.which)) return U(), void O.$digest();
                        e.preventDefault(), 40 === e.which ? (O.activeIdx = (O.activeIdx + 1) % O.matches.length, 
                        O.$digest()) : 38 === e.which ? (O.activeIdx = (O.activeIdx > 0 ? O.activeIdx : O.matches.length) - 1, 
                        O.$digest()) : 13 === e.which || 9 === e.which ? O.$apply(function() {
                            O.select(O.activeIdx);
                        }) : 27 === e.which && (e.stopPropagation(), U(), O.$digest());
                    }
                }), m.bind("blur", function() {
                    D && O.matches.length && O.activeIdx !== -1 && !M && (M = !0, O.$apply(function() {
                        O.select(O.activeIdx);
                    })), y = !1, M = !1;
                });
                var G = function(e) {
                    m[0] !== e.target && 3 !== e.which && 0 !== O.matches.length && (U(), s.$$phase || O.$digest());
                };
                r.bind("click", G), d.$on("$destroy", function() {
                    r.unbind("click", G), S && J.remove(), F.remove();
                });
                var J = e(F)(O);
                S ? r.find("body").append(J) : m.after(J);
            }
        };
    } ]).directive("typeaheadPopup", function() {
        return {
            restrict: "EA",
            scope: {
                matches: "=",
                query: "=",
                active: "=",
                position: "&",
                moveInProgress: "=",
                select: "&"
            },
            replace: !0,
            templateUrl: function(e, t) {
                return t.popupTemplateUrl || "template/typeahead/typeahead-popup.html";
            },
            link: function(e, t, n) {
                e.templateUrl = n.templateUrl, e.isOpen = function() {
                    return e.matches.length > 0;
                }, e.isActive = function(t) {
                    return e.active == t;
                }, e.selectActive = function(t) {
                    e.active = t;
                }, e.selectMatch = function(t) {
                    e.select({
                        activeIdx: t
                    });
                };
            }
        };
    }).directive("typeaheadMatch", [ "$templateRequest", "$compile", "$parse", function(e, t, n) {
        return {
            restrict: "EA",
            scope: {
                index: "=",
                match: "=",
                query: "="
            },
            link: function(a, r, i) {
                var s = n(i.templateUrl)(a.$parent) || "template/typeahead/typeahead-match.html";
                e(s).then(function(e) {
                    t(e.trim())(a, function(e) {
                        r.replaceWith(e);
                    });
                });
            }
        };
    } ]).filter("typeaheadHighlight", [ "$sce", "$injector", "$log", function(e, t, n) {
        function a(e) {
            return e.replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1");
        }
        function r(e) {
            return /<.*>/g.test(e);
        }
        var i;
        return i = t.has("$sanitize"), function(t, s) {
            return !i && r(t) && n.warn("Unsafe use of typeahead please use ngSanitize"), t = s ? ("" + t).replace(new RegExp(a(s), "gi"), "<strong>$&</strong>") : t, 
            i || (t = e.trustAsHtml(t)), t;
        };
    } ]), angular.module("template/accordion/accordion-group.html", []).run([ "$templateCache", function(e) {
        e.put("template/accordion/accordion-group.html", '<div class="panel {{panelClass || \'panel-default\'}}">\n  <div class="panel-heading" ng-keypress="toggleOpen($event)">\n    <h4 class="panel-title">\n      <a href tabindex="0" class="accordion-toggle" ng-click="toggleOpen()" accordion-transclude="heading"><span ng-class="{\'text-muted\': isDisabled}">{{heading}}</span></a>\n    </h4>\n  </div>\n  <div class="panel-collapse collapse" collapse="!isOpen">\n\t  <div class="panel-body" ng-transclude></div>\n  </div>\n</div>\n');
    } ]), angular.module("template/accordion/accordion.html", []).run([ "$templateCache", function(e) {
        e.put("template/accordion/accordion.html", '<div class="panel-group" ng-transclude></div>');
    } ]), angular.module("template/alert/alert.html", []).run([ "$templateCache", function(e) {
        e.put("template/alert/alert.html", '<div class="alert" ng-class="[\'alert-\' + (type || \'warning\'), closeable ? \'alert-dismissible\' : null]" role="alert">\n    <button ng-show="closeable" type="button" class="close" ng-click="close($event)">\n        <span aria-hidden="true">&times;</span>\n        <span class="sr-only">Close</span>\n    </button>\n    <div ng-transclude></div>\n</div>\n');
    } ]), angular.module("template/carousel/carousel.html", []).run([ "$templateCache", function(e) {
        e.put("template/carousel/carousel.html", '<div ng-mouseenter="pause()" ng-mouseleave="play()" class="carousel" ng-swipe-right="prev()" ng-swipe-left="next()">\n    <ol class="carousel-indicators" ng-show="slides.length > 1">\n        <li ng-repeat="slide in slides | orderBy:indexOfSlide track by $index" ng-class="{active: isActive(slide)}" ng-click="select(slide)"></li>\n    </ol>\n    <div class="carousel-inner" ng-transclude></div>\n    <a class="left carousel-control" ng-click="prev()" ng-show="slides.length > 1"><span class="glyphicon glyphicon-chevron-left"></span></a>\n    <a class="right carousel-control" ng-click="next()" ng-show="slides.length > 1"><span class="glyphicon glyphicon-chevron-right"></span></a>\n</div>\n');
    } ]), angular.module("template/carousel/slide.html", []).run([ "$templateCache", function(e) {
        e.put("template/carousel/slide.html", '<div ng-class="{\n    \'active\': active\n  }" class="item text-center" ng-transclude></div>\n');
    } ]), angular.module("template/datepicker/datepicker.html", []).run([ "$templateCache", function(e) {
        e.put("template/datepicker/datepicker.html", '<div ng-switch="datepickerMode" role="application" ng-keydown="keydown($event)">\n  <daypicker ng-switch-when="day" tabindex="0"></daypicker>\n  <monthpicker ng-switch-when="month" tabindex="0"></monthpicker>\n  <yearpicker ng-switch-when="year" tabindex="0"></yearpicker>\n</div>');
    } ]), angular.module("template/datepicker/day.html", []).run([ "$templateCache", function(e) {
        e.put("template/datepicker/day.html", '<table role="grid" aria-labelledby="{{::uniqueId}}-title" aria-activedescendant="{{activeDateId}}">\n  <thead>\n    <tr>\n      <th><button type="button" class="btn btn-default btn-sm pull-left" ng-click="move(-1)" tabindex="-1"><i class="glyphicon glyphicon-chevron-left"></i></button></th>\n      <th colspan="{{::5 + showWeeks}}"><button id="{{::uniqueId}}-title" role="heading" aria-live="assertive" aria-atomic="true" type="button" class="btn btn-default btn-sm" ng-click="toggleMode()" ng-disabled="datepickerMode === maxMode" tabindex="-1" style="width:100%;"><strong>{{title}}</strong></button></th>\n      <th><button type="button" class="btn btn-default btn-sm pull-right" ng-click="move(1)" tabindex="-1"><i class="glyphicon glyphicon-chevron-right"></i></button></th>\n    </tr>\n    <tr>\n      <th ng-if="showWeeks" class="text-center"></th>\n      <th ng-repeat="label in ::labels track by $index" class="text-center"><small aria-label="{{::label.full}}">{{::label.abbr}}</small></th>\n    </tr>\n  </thead>\n  <tbody>\n    <tr ng-repeat="row in rows track by $index">\n      <td ng-if="showWeeks" class="text-center h6"><em>{{ weekNumbers[$index] }}</em></td>\n      <td ng-repeat="dt in row track by dt.date" class="text-center" role="gridcell" id="{{::dt.uid}}" ng-class="::dt.customClass">\n        <button type="button" style="min-width:100%;" class="btn btn-default btn-sm" ng-class="{\'btn-info\': dt.selected, active: isActive(dt)}" ng-click="select(dt.date)" ng-disabled="dt.disabled" tabindex="-1"><span ng-class="::{\'text-muted\': dt.secondary, \'text-info\': dt.current}">{{::dt.label}}</span></button>\n      </td>\n    </tr>\n  </tbody>\n</table>\n');
    } ]), angular.module("template/datepicker/month.html", []).run([ "$templateCache", function(e) {
        e.put("template/datepicker/month.html", '<table role="grid" aria-labelledby="{{::uniqueId}}-title" aria-activedescendant="{{activeDateId}}">\n  <thead>\n    <tr>\n      <th><button type="button" class="btn btn-default btn-sm pull-left" ng-click="move(-1)" tabindex="-1"><i class="glyphicon glyphicon-chevron-left"></i></button></th>\n      <th><button id="{{::uniqueId}}-title" role="heading" aria-live="assertive" aria-atomic="true" type="button" class="btn btn-default btn-sm" ng-click="toggleMode()" ng-disabled="datepickerMode === maxMode" tabindex="-1" style="width:100%;"><strong>{{title}}</strong></button></th>\n      <th><button type="button" class="btn btn-default btn-sm pull-right" ng-click="move(1)" tabindex="-1"><i class="glyphicon glyphicon-chevron-right"></i></button></th>\n    </tr>\n  </thead>\n  <tbody>\n    <tr ng-repeat="row in rows track by $index">\n      <td ng-repeat="dt in row track by dt.date" class="text-center" role="gridcell" id="{{::dt.uid}}" ng-class="::dt.customClass">\n        <button type="button" style="min-width:100%;" class="btn btn-default" ng-class="{\'btn-info\': dt.selected, active: isActive(dt)}" ng-click="select(dt.date)" ng-disabled="dt.disabled" tabindex="-1"><span ng-class="::{\'text-info\': dt.current}">{{::dt.label}}</span></button>\n      </td>\n    </tr>\n  </tbody>\n</table>\n');
    } ]), angular.module("template/datepicker/popup.html", []).run([ "$templateCache", function(e) {
        e.put("template/datepicker/popup.html", '<ul class="dropdown-menu" ng-if="isOpen" style="display: block" ng-style="{top: position.top+\'px\', left: position.left+\'px\'}" ng-keydown="keydown($event)" ng-click="$event.stopPropagation()">\n\t<li ng-transclude></li>\n\t<li ng-if="showButtonBar" style="padding:10px 9px 2px">\n\t\t<span class="btn-group pull-left">\n\t\t\t<button type="button" class="btn btn-sm btn-info" ng-click="select(\'today\')" ng-disabled="isDisabled(\'today\')">{{ getText(\'current\') }}</button>\n\t\t\t<button type="button" class="btn btn-sm btn-danger" ng-click="select(null)">{{ getText(\'clear\') }}</button>\n\t\t</span>\n\t\t<button type="button" class="btn btn-sm btn-success pull-right" ng-click="close()">{{ getText(\'close\') }}</button>\n\t</li>\n</ul>\n');
    } ]), angular.module("template/datepicker/year.html", []).run([ "$templateCache", function(e) {
        e.put("template/datepicker/year.html", '<table role="grid" aria-labelledby="{{::uniqueId}}-title" aria-activedescendant="{{activeDateId}}">\n  <thead>\n    <tr>\n      <th><button type="button" class="btn btn-default btn-sm pull-left" ng-click="move(-1)" tabindex="-1"><i class="glyphicon glyphicon-chevron-left"></i></button></th>\n      <th colspan="3"><button id="{{::uniqueId}}-title" role="heading" aria-live="assertive" aria-atomic="true" type="button" class="btn btn-default btn-sm" ng-click="toggleMode()" ng-disabled="datepickerMode === maxMode" tabindex="-1" style="width:100%;"><strong>{{title}}</strong></button></th>\n      <th><button type="button" class="btn btn-default btn-sm pull-right" ng-click="move(1)" tabindex="-1"><i class="glyphicon glyphicon-chevron-right"></i></button></th>\n    </tr>\n  </thead>\n  <tbody>\n    <tr ng-repeat="row in rows track by $index">\n      <td ng-repeat="dt in row track by dt.date" class="text-center" role="gridcell" id="{{::dt.uid}}">\n        <button type="button" style="min-width:100%;" class="btn btn-default" ng-class="{\'btn-info\': dt.selected, active: isActive(dt)}" ng-click="select(dt.date)" ng-disabled="dt.disabled" tabindex="-1"><span ng-class="::{\'text-info\': dt.current}">{{::dt.label}}</span></button>\n      </td>\n    </tr>\n  </tbody>\n</table>\n');
    } ]), angular.module("template/modal/backdrop.html", []).run([ "$templateCache", function(e) {
        e.put("template/modal/backdrop.html", '<div class="modal-backdrop"\n     modal-animation-class="fade"\n     modal-in-class="in"\n     ng-style="{\'z-index\': 1040 + (index && 1 || 0) + index*10}"\n></div>\n');
    } ]), angular.module("template/modal/window.html", []).run([ "$templateCache", function(e) {
        e.put("template/modal/window.html", '<div modal-render="{{$isRendered}}" tabindex="-1" role="dialog" class="modal"\n    modal-animation-class="fade"\n    modal-in-class="in"\n\tng-style="{\'z-index\': 1050 + index*10, display: \'block\'}" ng-click="close($event)">\n    <div class="modal-dialog" ng-class="size ? \'modal-\' + size : \'\'"><div class="modal-content" modal-transclude></div></div>\n</div>\n');
    } ]), angular.module("template/pagination/pager.html", []).run([ "$templateCache", function(e) {
        e.put("template/pagination/pager.html", '<ul class="pager">\n  <li ng-class="{disabled: noPrevious()||ngDisabled, previous: align}"><a href ng-click="selectPage(page - 1, $event)">{{::getText(\'previous\')}}</a></li>\n  <li ng-class="{disabled: noNext()||ngDisabled, next: align}"><a href ng-click="selectPage(page + 1, $event)">{{::getText(\'next\')}}</a></li>\n</ul>\n');
    } ]), angular.module("template/pagination/pagination.html", []).run([ "$templateCache", function(e) {
        e.put("template/pagination/pagination.html", '<ul class="pagination">\n  <li ng-if="::boundaryLinks" ng-class="{disabled: noPrevious()||ngDisabled}" class="pagination-first"><a href ng-click="selectPage(1, $event)">{{::getText(\'first\')}}</a></li>\n  <li ng-if="::directionLinks" ng-class="{disabled: noPrevious()||ngDisabled}" class="pagination-prev"><a href ng-click="selectPage(page - 1, $event)">{{::getText(\'previous\')}}</a></li>\n  <li ng-repeat="page in pages track by $index" ng-class="{active: page.active,disabled: ngDisabled&&!page.active}" class="pagination-page"><a href ng-click="selectPage(page.number, $event)">{{page.text}}</a></li>\n  <li ng-if="::directionLinks" ng-class="{disabled: noNext()||ngDisabled}" class="pagination-next"><a href ng-click="selectPage(page + 1, $event)">{{::getText(\'next\')}}</a></li>\n  <li ng-if="::boundaryLinks" ng-class="{disabled: noNext()||ngDisabled}" class="pagination-last"><a href ng-click="selectPage(totalPages, $event)">{{::getText(\'last\')}}</a></li>\n</ul>\n');
    } ]), angular.module("template/tooltip/tooltip-html-popup.html", []).run([ "$templateCache", function(e) {
        e.put("template/tooltip/tooltip-html-popup.html", '<div class="tooltip"\n  tooltip-animation-class="fade"\n  tooltip-classes\n  ng-class="{ in: isOpen() }">\n  <div class="tooltip-arrow"></div>\n  <div class="tooltip-inner" ng-bind-html="contentExp()"></div>\n</div>\n');
    } ]), angular.module("template/tooltip/tooltip-html-unsafe-popup.html", []).run([ "$templateCache", function(e) {
        e.put("template/tooltip/tooltip-html-unsafe-popup.html", '<div class="tooltip"\n  tooltip-animation-class="fade"\n  tooltip-classes\n  ng-class="{ in: isOpen() }">\n  <div class="tooltip-arrow"></div>\n  <div class="tooltip-inner" bind-html-unsafe="content"></div>\n</div>\n');
    } ]), angular.module("template/tooltip/tooltip-popup.html", []).run([ "$templateCache", function(e) {
        e.put("template/tooltip/tooltip-popup.html", '<div class="tooltip"\n  tooltip-animation-class="fade"\n  tooltip-classes\n  ng-class="{ in: isOpen() }">\n  <div class="tooltip-arrow"></div>\n  <div class="tooltip-inner" ng-bind="content"></div>\n</div>\n');
    } ]), angular.module("template/tooltip/tooltip-template-popup.html", []).run([ "$templateCache", function(e) {
        e.put("template/tooltip/tooltip-template-popup.html", '<div class="tooltip"\n  tooltip-animation-class="fade"\n  tooltip-classes\n  ng-class="{ in: isOpen() }">\n  <div class="tooltip-arrow"></div>\n  <div class="tooltip-inner"\n    tooltip-template-transclude="contentExp()"\n    tooltip-template-transclude-scope="originScope()"></div>\n</div>\n');
    } ]), angular.module("template/popover/popover-html.html", []).run([ "$templateCache", function(e) {
        e.put("template/popover/popover-html.html", '<div class="popover"\n  tooltip-animation-class="fade"\n  tooltip-classes\n  ng-class="{ in: isOpen() }">\n  <div class="arrow"></div>\n\n  <div class="popover-inner">\n      <h3 class="popover-title" ng-bind="title" ng-if="title"></h3>\n      <div class="popover-content" ng-bind-html="contentExp()"></div>\n  </div>\n</div>\n');
    } ]), angular.module("template/popover/popover-template.html", []).run([ "$templateCache", function(e) {
        e.put("template/popover/popover-template.html", '<div class="popover"\n  tooltip-animation-class="fade"\n  tooltip-classes\n  ng-class="{ in: isOpen() }">\n  <div class="arrow"></div>\n\n  <div class="popover-inner">\n      <h3 class="popover-title" ng-bind="title" ng-if="title"></h3>\n      <div class="popover-content"\n        tooltip-template-transclude="contentExp()"\n        tooltip-template-transclude-scope="originScope()"></div>\n  </div>\n</div>\n');
    } ]), angular.module("template/popover/popover.html", []).run([ "$templateCache", function(e) {
        e.put("template/popover/popover.html", '<div class="popover"\n  tooltip-animation-class="fade"\n  tooltip-classes\n  ng-class="{ in: isOpen() }">\n  <div class="arrow"></div>\n\n  <div class="popover-inner">\n      <h3 class="popover-title" ng-bind="title" ng-if="title"></h3>\n      <div class="popover-content" ng-bind="content"></div>\n  </div>\n</div>\n');
    } ]), angular.module("template/progressbar/bar.html", []).run([ "$templateCache", function(e) {
        e.put("template/progressbar/bar.html", '<div class="progress-bar" ng-class="type && \'progress-bar-\' + type" role="progressbar" aria-valuenow="{{value}}" aria-valuemin="0" aria-valuemax="{{max}}" ng-style="{width: (percent < 100 ? percent : 100) + \'%\'}" aria-valuetext="{{percent | number:0}}%" style="min-width: 0;" ng-transclude></div>\n');
    } ]), angular.module("template/progressbar/progress.html", []).run([ "$templateCache", function(e) {
        e.put("template/progressbar/progress.html", '<div class="progress" ng-transclude></div>');
    } ]), angular.module("template/progressbar/progressbar.html", []).run([ "$templateCache", function(e) {
        e.put("template/progressbar/progressbar.html", '<div class="progress">\n  <div class="progress-bar" ng-class="type && \'progress-bar-\' + type" role="progressbar" aria-valuenow="{{value}}" aria-valuemin="0" aria-valuemax="{{max}}" ng-style="{width: (percent < 100 ? percent : 100) + \'%\'}" aria-valuetext="{{percent | number:0}}%" style="min-width: 0;" ng-transclude></div>\n</div>\n');
    } ]), angular.module("template/rating/rating.html", []).run([ "$templateCache", function(e) {
        e.put("template/rating/rating.html", '<span ng-mouseleave="reset()" ng-keydown="onKeydown($event)" tabindex="0" role="slider" aria-valuemin="0" aria-valuemax="{{range.length}}" aria-valuenow="{{value}}">\n    <span ng-repeat-start="r in range track by $index" class="sr-only">({{ $index < value ? \'*\' : \' \' }})</span>\n    <i ng-repeat-end ng-mouseenter="enter($index + 1)" ng-click="rate($index + 1)" class="glyphicon" ng-class="$index < value && (r.stateOn || \'glyphicon-star\') || (r.stateOff || \'glyphicon-star-empty\')" ng-attr-title="{{r.title}}" ></i>\n</span>\n');
    } ]), angular.module("template/tabs/tab.html", []).run([ "$templateCache", function(e) {
        e.put("template/tabs/tab.html", '<li ng-class="{active: active, disabled: disabled}">\n  <a href ng-click="select()" tab-heading-transclude>{{heading}}</a>\n</li>\n');
    } ]), angular.module("template/tabs/tabset.html", []).run([ "$templateCache", function(e) {
        e.put("template/tabs/tabset.html", '<div>\n  <ul class="nav nav-{{type || \'tabs\'}}" ng-class="{\'nav-stacked\': vertical, \'nav-justified\': justified}" ng-transclude></ul>\n  <div class="tab-content">\n    <div class="tab-pane" \n         ng-repeat="tab in tabs" \n         ng-class="{active: tab.active}"\n         tab-content-transclude="tab">\n    </div>\n  </div>\n</div>\n');
    } ]), angular.module("template/timepicker/timepicker.html", []).run([ "$templateCache", function(e) {
        e.put("template/timepicker/timepicker.html", '<table>\n  <tbody>\n    <tr class="text-center" ng-show="::showSpinners">\n      <td><a ng-click="incrementHours()" ng-class="{disabled: noIncrementHours()}" class="btn btn-link"><span class="glyphicon glyphicon-chevron-up"></span></a></td>\n      <td>&nbsp;</td>\n      <td><a ng-click="incrementMinutes()" ng-class="{disabled: noIncrementMinutes()}" class="btn btn-link"><span class="glyphicon glyphicon-chevron-up"></span></a></td>\n      <td ng-show="showMeridian"></td>\n    </tr>\n    <tr>\n      <td class="form-group" ng-class="{\'has-error\': invalidHours}">\n        <input style="width:50px;" type="text" ng-model="hours" ng-change="updateHours()" class="form-control text-center" ng-readonly="::readonlyInput" maxlength="2">\n      </td>\n      <td>:</td>\n      <td class="form-group" ng-class="{\'has-error\': invalidMinutes}">\n        <input style="width:50px;" type="text" ng-model="minutes" ng-change="updateMinutes()" class="form-control text-center" ng-readonly="::readonlyInput" maxlength="2">\n      </td>\n      <td ng-show="showMeridian"><button type="button" ng-class="{disabled: noToggleMeridian()}" class="btn btn-default text-center" ng-click="toggleMeridian()">{{meridian}}</button></td>\n    </tr>\n    <tr class="text-center" ng-show="::showSpinners">\n      <td><a ng-click="decrementHours()" ng-class="{disabled: noDecrementHours()}" class="btn btn-link"><span class="glyphicon glyphicon-chevron-down"></span></a></td>\n      <td>&nbsp;</td>\n      <td><a ng-click="decrementMinutes()" ng-class="{disabled: noDecrementMinutes()}" class="btn btn-link"><span class="glyphicon glyphicon-chevron-down"></span></a></td>\n      <td ng-show="showMeridian"></td>\n    </tr>\n  </tbody>\n</table>\n');
    } ]), angular.module("template/typeahead/typeahead-match.html", []).run([ "$templateCache", function(e) {
        e.put("template/typeahead/typeahead-match.html", '<a href tabindex="-1" ng-bind-html="match.label | typeaheadHighlight:query"></a>\n');
    } ]), angular.module("template/typeahead/typeahead-popup.html", []).run([ "$templateCache", function(e) {
        e.put("template/typeahead/typeahead-popup.html", '<ul class="dropdown-menu" ng-show="isOpen() && !moveInProgress" ng-style="{top: position().top+\'px\', left: position().left+\'px\'}" style="display: block;" role="listbox" aria-hidden="{{!isOpen()}}">\n    <li ng-repeat="match in matches track by $index" ng-class="{active: isActive($index) }" ng-mouseenter="selectActive($index)" ng-click="selectMatch($index)" role="option" id="{{::match.id}}">\n        <div typeahead-match index="$index" match="match" query="query" template-url="templateUrl"></div>\n    </li>\n</ul>\n');
    } ]), !angular.$$csp() && angular.element(document).find("head").prepend('<style type="text/css">.ng-animate.item:not(.left):not(.right){-webkit-transition:0s ease-in-out left;transition:0s ease-in-out left}</style>'), 
    e.exports = "ui.bootstrap";
}, , , , function(e, t, n) {
    "use strict";
    !function() {
        function e() {
            "all" != window.debugging && "kube" != window.debugging || console.debug.apply(console, arguments);
        }
        function t(e) {
            var t, n, a, r;
            if (0 === e.length) return 0;
            for (t = 0, n = 0, r = e.length; n < r; n++) a = e.charCodeAt(n), t = (t << 5) - t + a, 
            t |= 0;
            return Math.abs(t);
        }
        function a(e, t) {
            for (var n, a, r = 0, i = e.length - 1; r <= i; ) if (n = (r + i) / 2 | 0, a = e[n], 
            a < t) r = n + 1; else {
                if (!(a > t)) return n;
                i = n - 1;
            }
            return r;
        }
        function r(e) {
            var n = this, r = [];
            n.add = function(n, i) {
                var s, o, l, u, c = n.length;
                for (o = 0; o < c; o++) s = t("" + n[o]) % e, l = r[s], void 0 === l && (l = r[s] = []), 
                u = a(l, i), l[u] != i && l.splice(u, 0, i);
            }, n.get = function(n) {
                var a = r[t("" + n) % e];
                return a ? a.slice() : [];
            }, n.all = function(n) {
                var a, i, s, o, l, u, c, d, m, f;
                for (i = 0, l = n.length; i < l; i++) {
                    if (a = t("" + n[i]) % e, s = r[a], !s) {
                        o = [];
                        break;
                    }
                    if (o) for (m = 0, f = 0, u = o.length; m < u; ) c = o[m], d = s[m + f], d < c ? f += 1 : c !== d ? (o.splice(m, 1), 
                    u -= 1) : m += 1; else o = s.slice();
                }
                return o || [];
            };
        }
        function i() {
            var e = "weakmap" + _;
            _ += 1;
            var t = this;
            t.delete = function(t) {
                var n = t[g];
                n && delete n[e];
            }, t.has = function(t) {
                var n = t[g];
                return n && e in n;
            }, t.get = function(t) {
                var n = t[g];
                if (n) return n[e];
            }, t.set = function(t, n) {
                var a = t[g];
                a || (a = function() {}, Object.defineProperty(t, g, {
                    enumerable: !1,
                    configurable: !1,
                    writable: !1,
                    value: a
                })), a[e] = n;
            };
        }
        function s(e) {
            var t, n, a = {
                "": d
            };
            for (t = 0, n = e.length; t < n; t++) a[e[t].type] = e[t], a[e[t].kind] = e[t];
            return a;
        }
        function o(e) {
            var t = e[0];
            if (t && "object" == typeof t) if (t.metadata) {
                if (t.metadata.selfLink) return t.metadata.selfLink;
                e = [ t.kind, t.metadata.name, t.metadata.namespace ];
            } else t.name && t.kind && (e = [ t.kind, t.name, t.namespace ]); else if (t && "/" == t[0]) return t;
            var n = m[e[0]] || m[""], a = n.api;
            return !n.global && e[2] && (a += "/namespaces/" + e[2]), a += "/" + n.type, e[1] && (a += "/" + encodeURIComponent(e[1])), 
            a;
        }
        var l = n(32), u = "/api/v1", c = "/oapi/v1", d = {
            api: u,
            create: 0
        }, m = s([ {
            kind: "DeploymentConfig",
            type: "deploymentconfigs",
            api: c
        }, {
            kind: "Endpoints",
            type: "endpoints",
            api: u
        }, {
            kind: "Group",
            type: "groups",
            api: c,
            global: !0
        }, {
            kind: "Image",
            type: "images",
            api: c,
            global: !0
        }, {
            kind: "ImageStream",
            type: "imagestreams",
            api: c
        }, {
            kind: "ImageStreamImage",
            type: "imagestreamimages",
            api: c
        }, {
            kind: "ImageStreamTag",
            type: "imagestreamtags",
            api: c
        }, {
            kind: "LocalResourceAccessReview",
            type: "localresourceaccessreviews",
            api: c
        }, {
            kind: "Namespace",
            type: "namespaces",
            api: u,
            global: !0,
            create: -100
        }, {
            kind: "Node",
            type: "nodes",
            api: u,
            global: !0
        }, {
            kind: "Pod",
            type: "pods",
            api: u,
            create: -20
        }, {
            kind: "PolicyBinding",
            type: "policybindings",
            api: c
        }, {
            kind: "RoleBinding",
            type: "rolebindings",
            api: c
        }, {
            kind: "Route",
            type: "routes",
            api: c
        }, {
            kind: "PersistentVolume",
            type: "persistentvolumes",
            api: u,
            global: !0,
            create: -100
        }, {
            kind: "PersistentVolumeClaim",
            type: "persistentvolumeclaims",
            api: u,
            create: -50
        }, {
            kind: "Project",
            type: "projects",
            api: c,
            global: !0,
            create: -90
        }, {
            kind: "ProjectRequest",
            type: "projectrequests",
            api: c,
            global: !0,
            create: -90
        }, {
            kind: "ReplicationController",
            type: "replicationcontrollers",
            api: u,
            create: -60
        }, {
            kind: "Service",
            type: "services",
            api: u,
            create: -80
        }, {
            kind: "SubjectAccessReview",
            type: "subjectaccessreviews",
            api: c
        }, {
            kind: "User",
            type: "users",
            api: c,
            global: !0
        } ]), f = /^[a-z0-9]([-a-z0-9]*[a-z0-9])?$/, p = /^[a-zA-Z0-9_.]([-a-zA-Z0-9 ,=@._]*[a-zA-Z0-9._])?$/, h = "120s", g = Math.random().toString(36).slice(2), _ = 1;
        l.module("kubeClient", []).value("KUBE_SCHEMA", m).value("KUBE_NAME_RE", f).factory("kubeLoader", [ "$q", "$timeout", "KubeWatch", "KubeRequest", "KUBE_SCHEMA", function(e, t, n, a, r) {
            function i(e, t, a) {
                var r, i = m[e] || m[""], s = i.api;
                return !i.global && t && (s += "/namespaces/" + t), s += "/" + i.type, s in k || (r = new n(s, u), 
                r.what = e, r.global = i.global, r.namespace = t, r.cancelWatch = r.cancel, r.cancel = function() {
                    var e = k[s];
                    e && (e.references -= 1, e.references <= 0 && (e.cancelWatch(), delete k[s]));
                }, k[s] = r), k[s].references += a, k[s];
            }
            function s(t, n) {
                var a = $.namespace;
                if (!l.isArray(a)) return i(t, a, n);
                var r = [];
                l.forEach(a, function(e) {
                    r.push(i(t, e, n));
                });
                var s = e.all(r);
                return s.cancel = function() {
                    l.forEach(r, function(e) {
                        e.cancel();
                    });
                }, s;
            }
            function u(e) {
                if (null === L ? L = e : L.push.apply(L, e), e.length > 0) {
                    if (null !== D) return;
                    D = window.setTimeout(p, 150);
                }
                d(f);
            }
            function c(e) {
                var t;
                if (e && e.metadata && (t = parseInt(e.metadata.resourceVersion, 10)), !isNaN(t)) return t;
            }
            function d(e) {
                var t = L;
                if (L = null, t) {
                    var n, a, r, i, s, l, u = {}, d = {};
                    for (n = 0, a = t.length; n < a; n++) i = t[n].object, i && (r = decodeURIComponent(o([ i ])), 
                    "DELETED" == t[n].type ? (delete w[r], delete u[r], d[r] = i) : t[n].checkResourceVersion ? (s = c(i), 
                    l = c(w[r]), (!s || !l || s >= l) && (u[r] = i, w[r] = i)) : (u[r] = i, w[r] = i));
                    e(u, d);
                }
            }
            function f() {
                var e, t, n;
                for (e = 0, t = M.length; e < t; e++) n = M[e], n && n.apply(y, arguments);
            }
            function p() {
                D = null, d(f);
            }
            function h() {
                var e;
                window.clearTimeout(D), D = null, L = null;
                var t = k;
                k = {}, l.forEach(t, function(e) {
                    e.cancelWatch();
                });
                for (e in w) delete w[e];
                for (e in $) delete $[e];
                $.namespace = null, f();
            }
            function g(e, t, n) {
                u(e.map(function(e) {
                    return n && (e.kind = n), {
                        type: t ? "DELETED" : "ADDED",
                        object: e,
                        checkResourceVersion: !0
                    };
                })), d(f);
            }
            function _() {
                var t = o(arguments), n = new a("GET", t), r = n.then(function(e) {
                    n = null;
                    var t = e.data;
                    return t && t.kind ? t.kind.indexOf("List") === t.kind.length - 4 ? (g(t.items, !1, t.kind.slice(0, -4)), 
                    t.items) : (g([ t ]), t) : null;
                }, function(t) {
                    n = null;
                    var a = t.data;
                    return e.reject(a || t);
                });
                return r.cancel = function(e) {
                    n.cancel(e);
                }, r;
            }
            function v(e) {
                window.clearTimeout(D), D = null;
                var t = {};
                null === e ? t = null : l.isArray(e) ? l.forEach(e, function(e) {
                    t[e] = !0;
                }) : t[e] = !0, $.namespace = e;
                var n = {}, a = {};
                d(function(e, t) {
                    n = e, a = t;
                });
                var r, i;
                for (i in w) r = w[i].metadata, !t || !r.namespace || r.namespace in t || (a[i] = w[i], 
                delete w[i], delete n[i]);
                var o, u, c = [];
                for (o in k) u = k[o], (!t && u.namespace || t && !u.global && !(u.namespace in t)) && (u.cancelWatch(), 
                delete k[o], c.push(u));
                f(n, a), l.forEach(c, function(e) {
                    s(e.what, e.references);
                });
            }
            function b(e, t) {
                t && (t.$on ? t.$on("destroy", function() {
                    e.cancel();
                }) : console.warn("invalid until passed to watch", t));
            }
            var y, M = [], $ = {
                namespace: null
            }, k = {}, w = {}, L = null, D = null;
            return y = {
                watch: function(e, t) {
                    var n = s(e, 1);
                    return b(n, t), n;
                },
                load: function() {
                    return _.apply(this, arguments);
                },
                limit: function(e) {
                    "namespace" in e && v(e.namespace);
                },
                reset: h,
                listen: function(e, n) {
                    e.early ? M.unshift(e) : M.push(e);
                    var a = t(function() {
                        a = null, e.call(y, w);
                    }, 0), r = {
                        cancel: function() {
                            var n, r;
                            for (t.cancel(a), a = null, n = 0, r = M.length; n < r; n++) M[n] === e && (M[n] = null);
                        }
                    };
                    return b(r, n), r;
                },
                handle: function(e, t, n) {
                    l.isArray(e) || (e = [ e ]), g(e, t, n);
                },
                resolve: function() {
                    return o(arguments);
                },
                objects: w,
                limits: $
            };
        } ]).factory("kubeSelect", [ "kubeLoader", function(e) {
            function t(e, t) {
                v += 1, e ? h && a(e) : h = null;
            }
            function n() {
                h = new r(262139), a(e.objects);
            }
            function a(e) {
                var t, n, a, r, i, s;
                for (t in e) {
                    n = e[t];
                    for (a in p) s = p[a], s.digest ? (r = s.digest.call(null, n), r && h.add([ r ], t)) : s.digests && (i = s.digests.call(null, n), 
                    i.length && h.add(i, t));
                }
            }
            function s(e) {
                var t = _.get(e);
                return t && t.version === v || (t = {
                    version: v,
                    length: t ? t.length : void 0
                }, _.set(e, t)), t;
            }
            function o(e) {
                return function() {
                    var t = s(this), r = Array.prototype.slice.call(arguments), i = e.name + ": " + JSON.stringify(r);
                    if (i in t) return t[i];
                    var o;
                    return e.filter ? o = e.filter.apply(this, r) : (h || n(), t.indexed || (a(this), 
                    t.indexed = !0), e.digests ? o = d(e, this, r) : e.digest ? o = c(e, this, r) : (console.warn("invalid filter: " + e.name), 
                    o = {})), t[i] = o, o;
                };
            }
            function l() {
                var e, t = {
                    length: {
                        enumerable: !1,
                        configurable: !0,
                        get: function() {
                            return s(this).length;
                        }
                    }
                };
                for (e in p) t[e] = {
                    enumerable: !1,
                    configurable: !0,
                    value: o(p[e])
                };
                return t;
            }
            function u(e, t, n) {
                var a, r;
                if (void 0 === t) {
                    t = 0;
                    for (a in e) t += 1;
                }
                return g = g || l(), Object.defineProperties(e, g), r = s(e), r.length = t, r.selection = e, 
                r.indexed = n, e;
            }
            function c(e, t, n) {
                var a, r, i, s, o, l, c = {}, d = 0;
                for (i = e.digest.apply(null, n), s = null !== i && void 0 !== i ? h.get(i) : [], 
                a = 0, r = s.length; a < r; a++) o = s[a], l = t[o], l && i === e.digest.call(null, l) && (c[o] = l, 
                d += 1);
                return u(c, d, !0);
            }
            function d(e, t, n) {
                var a, r, i, s, o, l, c, d, m, f, p, g, _ = {}, v = 0;
                for (a = e.digests.apply(null, n), r = a.length, r > 0 ? (d = h.all(a), a.sort()) : d = [], 
                m = 0, f = d.length; m < f; m++) if (o = d[m], c = t[o]) {
                    for (i = e.digests.call(null, c), i.sort(), l = !1, p = 0, g = i.length; !l && p < g; p++) if (a[0] === i[p]) for (l = !0, 
                    s = 0; l && s < r; s++) a[s] !== i[p + s] && (l = !1);
                    l && (_[o] = c, v += 1);
                }
                return u(_, v, !0);
            }
            function m(e, t) {
                "function" == typeof t && (e = {
                    name: e,
                    filter: t
                }), p[e.name] = e, h = null, g = null, v += 1;
            }
            function f(t) {
                var n, a = !1;
                if (void 0 === t ? (t = e.objects, a = !0) : t || (t = b), "object" != typeof t && (console.warn("Pass resources or resource dicts or null to kubeSelect()"), 
                t = b), n = s(t), n.selection) return n.selection;
                var r, i;
                return "string" == typeof t.kind ? (n.single || (r = t.meta || {}, i = {}, i[r.selfLink || 1] = t, 
                n.single = u(i, void 0, !1)), n.single) : u(t, void 0, a);
            }
            var p = {}, h = null, g = null, _ = new i(), v = 1;
            t.early = !0, e.listen(t), m("one", function() {
                var e;
                for (e in this) return this[e];
                return null;
            }), m("extend", function(e) {
                var t;
                for (t in this) e[t] = this[t];
                return e;
            }), m({
                name: "label",
                digests: function(e) {
                    var t = [];
                    if (!e) return t;
                    var n, a = e.metadata, r = a ? a.labels : e;
                    for (n in r || []) t.push(n + "=" + r[n]);
                    return t;
                }
            }), m({
                name: "namespace",
                digest: function(e) {
                    if (!e) return null;
                    if ("string" == typeof e) return e;
                    var t = e.metadata;
                    return t ? t.namespace : null;
                }
            }), m({
                name: "name",
                digest: function(e) {
                    if (!e) return null;
                    if ("string" == typeof e) return e;
                    var t = e.metadata;
                    return t ? t.name : null;
                }
            }), m({
                name: "kind",
                digest: function(e) {
                    return e ? "string" == typeof e ? e : e.kind : null;
                }
            }), m({
                name: "host",
                digest: function(e) {
                    if (!e) return null;
                    if ("string" == typeof e) return e;
                    var t = e.spec;
                    return t ? t.nodeName : null;
                }
            }), m({
                name: "uid",
                digest: function(e) {
                    if (!e) return null;
                    if ("string" == typeof e) return e;
                    var t = e.metadata;
                    return t ? t.uid : null;
                }
            }), m({
                name: "statusPhase",
                digest: function(e) {
                    var t;
                    return "string" == typeof e ? e : (t = e.status || {}, t.phase ? t.phase : null);
                }
            });
            var b = {};
            return f.register = m, f;
        } ]).factory("kubeMethods", [ "$q", "KUBE_SCHEMA", "KubeRequest", "kubeLoader", function(t, n, a, r) {
            function i(e, t) {
                var a = n[e.kind].create || 0, r = n[t.kind].create || 0;
                return a - r;
            }
            function s(n, s) {
                function u() {
                    var t = n.shift();
                    if (!t) return void c.resolve();
                    var i = o([ t.kind, null, s || "default" ]);
                    i += "?timeout=" + h, f = new a("POST", i, JSON.stringify(t)).then(function(t) {
                        var n;
                        e("created resource:", i, t.data), t.data.kind && ("Project" == t.data.kind && (n = t.data.metadata || {}, 
                        delete n.selfLink), r.handle(t.data)), u();
                    }, function(n) {
                        var a = n.data;
                        "Namespace" != t.kind || !a || 409 !== a.code && 403 !== a.code ? (e("create failed:", i, a || n), 
                        c.reject(a || n)) : (e("skipping namespace creation"), u());
                    });
                }
                var c = t.defer(), d = c.promise, f = null;
                l.isArray(n) || (n = "List" == n.kind ? n.items : [ n ]);
                var p = !1, g = !1;
                return n.forEach(function(e) {
                    var t = e.metadata || {};
                    "Namespace" != e.kind && "Project" != e.kind || t.name !== s || (p = !0);
                    var n = m[e.kind] || m[""];
                    n.global || (g = !0);
                }), n = n.slice(), s && g && !p && n.unshift({
                    apiVersion: "v1",
                    kind: "Namespace",
                    metadata: {
                        name: s
                    }
                }), n.sort(i), u(), d.cancel = function() {
                    f && f.cancel();
                }, d;
            }
            function u() {
                var n = o(arguments), i = r.objects[n];
                n += "?timeout=" + h;
                var s = new a("DELETE", n);
                return s.then(function() {
                    e("deleted resource:", n, i), i && r.handle(i, !0);
                }, function(e) {
                    var n = e.data;
                    return t.reject(n || e);
                });
            }
            function c(n, i) {
                var s = o([ n ]);
                s += "?timeout=" + h;
                var l = JSON.stringify(i), u = {
                    headers: {
                        "Content-Type": "application/strategic-merge-patch+json"
                    }
                }, c = new a("PATCH", s, l, u);
                return c.then(function(t) {
                    e("patched resource:", s, t.data), t.data.kind && r.handle(t.data);
                }, function(e) {
                    var n = e.data;
                    return t.reject(n || e);
                });
            }
            function d(e, n, r, i) {
                var s = o([ n ]);
                "GET" != e && (s += "?timeout=" + h);
                var l = new a(e, s, JSON.stringify(r), i);
                return l.then(function(e) {
                    var t = e.data;
                    return t || e;
                }, function(e) {
                    var n = e.data;
                    return t.reject(n || e);
                });
            }
            function g(e, t, n) {
                return d("PUT", e, t, n);
            }
            function _(e, t, n) {
                return d("POST", e, t, n);
            }
            function v(e, n) {
                var a, r = t.defer(), i = [];
                n || (n = {});
                var s = e.metadata;
                if (s) {
                    if (a = null, void 0 !== s.name) {
                        var o = "User" == e.kind ? p : f;
                        s.name ? o.test(s.name) || (a = o == f ? new Error("The name contains invalid characters. Only letters, numbers and dashes are allowed") : new Error("The name contains invalid characters. Only letters, numbers, spaces and the following symbols are allowed: , = @  . _")) : a = new Error("The name cannot be empty");
                    }
                    a && (a.target = n["metadata.name"], i.push(a)), a = null, void 0 !== s.namespace && (s.namespace ? f.test(s.namespace) || (a = new Error("The name contains invalid characters. Only letters, numbers and dashes are allowed")) : a = new Error("The namespace cannot be empty")), 
                    a && (a.target = n["metadata.namespace"], i.push(a));
                }
                return i.length ? r.reject(i) : r.resolve(), r.promise;
            }
            return {
                create: s,
                delete: u,
                check: v,
                patch: c,
                post: _,
                put: g
            };
        } ]).provider("KubeRequest", [ function() {
            function e(e, t) {
                return l.isString(t) ? e.get(t, "KubeRequest") : e.invoke(t);
            }
            var t = this;
            t.KubeRequestFactory = "MissingKubeRequest", t.$get = [ "$injector", function(n) {
                return e(n, t.KubeRequestFactory);
            } ];
        } ]).factory("MissingKubeRequest", [ function() {
            return function(e, t) {
                throw new Error("no KubeRequestFactory set");
            };
        } ]).provider("KubeSocket", [ function() {
            function e(e, t) {
                return l.isString(t) ? e.get(t, "KubeSocket") : e.invoke(t);
            }
            var t = this;
            t.KubeSocketFactory = "MissingKubeSocket", t.$get = [ "$injector", function(n) {
                return e(n, t.KubeSocketFactory);
            } ];
        } ]).factory("MissingKubeSocket", [ function() {
            return function(e, t) {
                throw Error("no KubeSocketFactory set");
            };
        } ]).provider("KubeWatch", [ function() {
            function e(e, t) {
                return l.isString(t) ? e.get(t, "KubeWatch") : e.invoke(t);
            }
            var t = this;
            t.KubeWatchFactory = "MissingKubeWatch", t.$get = [ "$injector", function(n) {
                return e(n, t.KubeWatchFactory);
            } ];
        } ]).factory("MissingKubeWatch", [ function() {
            return function(e, t) {
                throw Error("no KubeWatchFactory set");
            };
        } ]).provider("KubeDiscoverSettings", [ function() {
            function e(e, t) {
                return l.isString(t) ? e.get(t, "KubeDiscoverSettings") : e.invoke(t);
            }
            var t = this;
            t.KubeDiscoverSettingsFactory = "MissingKubeDiscoverSettings", t.$get = [ "$injector", function(n) {
                return e(n, t.KubeDiscoverSettingsFactory);
            } ];
        } ]).factory("MissingKubeDiscoverSettings", [ function() {
            return function(e, t) {
                throw Error("no KubeDiscoverSettingsFactory set");
            };
        } ]);
    }();
}, , , , function(e, t, n) {
    "use strict";
    !function() {
        function e(e, t) {
            var n, a, i, s, o = [], l = e.length;
            for (i = 0; i < l; i++) if (n = e[i].querySelectorAll(t)) for (a = 0, s = n.length; a < s; a++) o.push(n[a]);
            return r.element(o);
        }
        function t(e, t) {
            var n, a = null, i = e.length;
            for (n = 0; !a && n < i; n++) a = e[n].querySelector(t);
            return r.element(a);
        }
        function a(n, a, i, s, o) {
            function l(e) {
                if (!k) return y = e, $ ? void o.cancel() : void (null === y ? (h(), b()) : y === !0 ? (h(), 
                v(), o.result(!0, M)) : y === !1 ? (v(), c(M), o.result(!1, M)) : console.warn("invalid dialog state", y));
            }
            function u() {
                o = null, s = null, h(), v();
            }
            function c(e) {
                h(), r.isArray(e) || (e = [ e ]), e.forEach(function(e) {
                    var a = null;
                    e.target && (a = t(n, e.target)), a && a[0] ? m(a, e) : d(e);
                });
            }
            function d(e) {
                var s = r.element("<div class='alert alert-danger dialog-error'>"), o = e.message || e.toString();
                console.warn(o), s.text(o), s.prepend(r.element("<span class='fa fa-exclamation-triangle'>"));
                var l = t(n, a);
                l.length ? i ? l.append(s) : l.prepend(s) : n.append(s);
            }
            function m(e, t) {
                var n = r.element("<div class='dialog-error help-block'>");
                n.text(t.message || t.toString());
                var a = e.parent();
                a.addClass("has-error"), e.after(n), a.on("keypress change", f);
            }
            function f(e) {
                for (var t = e.target; t !== this; ) p(r.element(t)), t = t.parentNode;
            }
            function p(t) {
                var n = t.parent();
                e(n, ".dialog-error").remove(), n.removeClass("has-error"), n.off("keypress change", f);
            }
            function h() {
                var t = e(n, ".dialog-error");
                r.forEach(t, function(e) {
                    p(r.element(e));
                });
            }
            function g(e) {
                return s.cancel && s.cancel(), $ = !0, e.stopPropagation(), e.preventDefault(), 
                !1;
            }
            function _(e) {
                var t = e.message || e;
                "string" == typeof t || "number" == typeof t ? D.text(t) : t || D.text("");
            }
            function v() {
                for (var e; ;) {
                    if (e = w.pop(), !e) break;
                    e.removeAttr("disabled");
                }
                L.remove(), t(n, ".btn-cancel").off("click", g);
            }
            function b() {
                function i(e) {
                    var t = r.element(e);
                    t.attr("disabled") || s.cancel && t.hasClass("btn-cancel") || (w.push(t), t.attr("disabled", "disabled"));
                }
                v(), t(n, a).prepend(L), r.forEach(e(n, ".form-control"), i), r.forEach(e(n, ".form-checkbox"), i), 
                r.forEach(e(n, ".btn"), i), t(n, ".btn-cancel").on("click", g);
            }
            var y = null, M = null, $ = !1, k = !1, w = [], L = r.element("<div class='dialog-wait-ct pull-left'>");
            L.append(r.element("<div class='spinner spinner-sm'>"));
            var D = r.element("<span>");
            return L.append(D), this.detach = u, s ? (s.then(function(e) {
                M = e, s && l(!0);
            }, function(e) {
                M = e, s && l(!1);
            }, function(e) {
                s && _(e);
            }), void window.setTimeout(function() {
                s && o && null === y && (l(null), o.$digest());
            }, 0)) : void u();
        }
        var r = n(32);
        n(35), r.module("ui.cockpit", [ "ui.bootstrap" ]).directive("modalDialog", [ "$q", function(e) {
            return {
                restrict: "E",
                transclude: !0,
                template: "<modal-group><ng-transclude></ng-transclude></modal-group>",
                link: function(e, t, n) {
                    e.cancel = function() {
                        e.$dismiss();
                    }, e.result = function(t, n) {
                        t && e.$close(n);
                    };
                }
            };
        } ]).directive("modalGroup", [ "$q", function(e) {
            return {
                restrict: "E",
                transclude: !0,
                template: "<ng-transclude></ng-transclude>",
                link: function(n, r, i) {
                    function s() {
                        l && l.detach(), l = null;
                    }
                    function o() {
                        n.cancel();
                    }
                    var l = null;
                    n.complete = function(t) {
                        var i = n.modalGroupButtonSel || ".modal-footer", o = n.modalGroupErrorAfter || !1;
                        s(), t && t.then || (t = e(t)), l = new a(r, i, o, t, n);
                    }, n.failure = function() {
                        var t, a = arguments.length;
                        if (0 === a ? t = null : 1 === a ? t = arguments[0] : (t = [], t.push.apply(t, arguments)), 
                        !t) return void s();
                        var r = e.defer();
                        r.reject(t), n.complete(r.promise);
                    };
                    var u = t(r, ".btn-cancel");
                    u.on("click", o), n.$on("$routeChangeStart", o), n.$on("$destroy", function() {
                        u.off("click", o), s();
                    });
                }
            };
        } ]);
    }();
}, function(e, t, n) {
    "use strict";
    !function() {
        function e(t, n, a) {
            return t && t.classList && t.classList.contains(n) || t && t.tagName === a || t && e(t.parentNode, n, a);
        }
        var t = n(32);
        n(45), n(46), n(47), n(48), n(49), n(50), n(51), n(52), n(53), n(54), n(55), n(56), 
        n(57), n(58), t.module("kubernetes.listing", []).directive("listingTable", [ function() {
            return {
                restrict: "A",
                link: function(e, t, n) {}
            };
        } ]).factory("ListingState", [ function() {
            return function(n) {
                function a(t) {
                    return !(t && e(t.target, "btn", "li"));
                }
                var r = this, i = {};
                r.selected = {}, r.enableActions = !1, r.hasSelected = function(e) {
                    return !t.equals({}, r.selected);
                }, r.expanded = function(e) {
                    if (t.isUndefined(e)) {
                        for (e in i) return !0;
                        return !1;
                    }
                    return e in i;
                }, r.toggle = function(e, t) {
                    var n;
                    return r.enableActions ? void t.stopPropagation() : void (e && (n = !(e in i), n ? r.expand(e, t) : r.collapse(e, t)));
                }, r.expand = function(e, t) {
                    i[e] = !0, t && t.stopPropagation();
                }, r.activate = function(e, t) {
                    a(t) && (r.expanded(e) ? r.collapse(e) : n.$emit("activate", e));
                }, r.collapse = function(e, t) {
                    e ? delete i[e] : Object.keys(i).forEach(function(e) {
                        delete i[e];
                    }), t && t.stopPropagation();
                };
            };
        } ]).directive("listingPanel", [ function() {
            return {
                restrict: "A",
                scope: !0,
                link: function(e, t, n) {
                    var a = "main";
                    e.tab = function(e, t) {
                        return t && (a = e, t.stopPropagation()), a === e;
                    };
                },
                templateUrl: function(e, t) {
                    var n = t.kind;
                    return "views/" + n.toLowerCase() + "-panel.html";
                }
            };
        } ]);
    }();
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div> <div class="listing-ct-head" ng-click="listing.collapse(id, $event)"> <div class="listing-ct-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteTag(stream, tag)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"> <a ng-click="tab(\'main\', $event)" translate>Image</a> </li> <li ng-class="{active: tab(\'config\')}"> <a ng-click="tab(\'config\', $event)" translate>Container</a> </li> <li ng-class="{active: tab(\'meta\')}"> <a ng-click="tab(\'meta\', $event)" translate>Metadata</a> </li> </ul> </div> <div class="listing-ct-body" ng-show="tab(\'main\')"> <registry-image-body image="image" names="names"> </registry-image-body> <registry-image-pull settings="settings" names="names"> </registry-image-pull> </div> <div class="listing-ct-body" ng-show="tab(\'config\')"> <registry-image-config image="image"> </registry-image-config> </div> <div class="listing-ct-body" ng-if="tab(\'meta\')"> <registry-image-meta image="image"> </registry-image-meta> <registry-image-layers image="image" layers="layers"> </registry-image-layers> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/image-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="listing-ct-actions project-panel-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="removeUser(projects(), groups(), user())"></button>\n<button class="btn btn-default pficon pficon-edit" ng-click="modifyUser(user())"></button> </div> <div class="listing-ct-head"> <h3><i class="pficon pficon-user"></i>{{ user().metadata.name }}</h3> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"> <a ng-click="tab(\'main\', $event)" translate>User</a></li> <li ng-class="{active: tab(\'membership\')}"> <a ng-click="tab(\'membership\', $event); tabbed = true" translate>Membership</a></li> </ul> </div> <div class="listing-ct-body project-panel"> <div ng-show="tab(\'main\')"> <div class="user-body"> <dl> <dt translate>Identities</dt> <dd>{{ user().identities }}</dd> </dl> </div> </div> <div class="project-panel" ng-show="tab(\'membership\')"> <table listing-table class="listing-ct project-body"> <thead> <tr> <th translate>Membership</th> <th translate></th> <th translate></th> </tr> </thead> <tbody colspan="3" ng-repeat="member in getProjectsWithMember(projects(), user().metadata.name) track by member.metadata.name"> <tr class="listing-ct-item inner-project-listing"> <td>{{ member.metadata.name }}</td> <td> <div ng-if="member.kind == &quot;Project&quot;" class="btn-group bootstrap-select namespace-filter" dropdown> <button class="btn btn-default dropdown-toggle" type="button" dropdown-toggle> <span class="pull-left"> <span ng-if="isRoles(user(), member)"> {{ getRegistryRoles(user(), member).join() }} </span> </span>\n<span class="caret"></span> </button> <ul class="dropdown-menu"> <li ng-repeat="roleMp in getRegistryRolesMap() track by roleMp.displayRole" ng-class="{ checked: isRegistryRole(user(), roleMp.displayRole, member) }"> <a ng-click="changeRole(user(), roleMp, getRegistryRoles(user(), member), member)"> {{ roleMp.displayRole }} </a> </li> </ul> </div> </td> <td><a class="pull-right close-icon"> <i translate class="pficon-close" ng-click="removeMemberFromParent(user(), member)"></i> </a> </td> </tr> </tbody> <tbody colspan="3" ng-repeat="member in getGroupsWithMember(groups(), user().metadata.name) track by member.metadata.name"> <tr class="listing-ct-item inner-project-listing"> <td>{{ member.metadata.name }}</td> <td></td> <td><a class="pull-right close-icon" ng-click="removeMemberFromParent(user(), member)"> <i translate class="pficon-close"></i> </a> </td> </tr> </tbody> <thead> <tr> <td colspan="3"> <a class="pull-left" ng-click="addMemberToParent(user())"> <i translate class="pficon pficon-add-circle-o"></i>\n<span translate>Add Membership</span> </a> </td> </tr> </thead> </table> </div></div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/user-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div> <div class="listing-ct-head"> <div class="listing-ct-actions"> <button title="Delete" class="btn btn-danger btn-delete pficon pficon-delete delete-entity" ng-click="deleteItem(item)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"><a ng-click="tab(\'main\', $event)" translate>Service</a></li> <li ng-class="{active: tab(\'endpoints\')}"><a ng-click="tab(\'endpoints\', $event)" translate>Endpoints</a></li> </ul> </div> <div class="listing-ct-body" service-body ng-show="tab(\'main\')"> </div> <div class="listing-ct-body" service-endpoint ng-show="tab(\'endpoints\')"> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/service-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div> <div class="listing-ct-head"> <div class="listing-ct-actions"> <button title="Delete" class="delete-pod btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteItem(item)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"><a ng-click="tab(\'main\', $event)">Pod</a></li> <li ng-class="{active: tab(\'containers\')}"><a ng-click="tab(\'containers\', $event)">Containers</a></li> <li ng-class="{active: tab(\'logs\')}"> <a ng-click="tab(\'logs\', $event); tabbed = true">Logs</a></li> <li ng-class="{active: tab(\'shell\')}"> <a ng-click="tab(\'shell\', $event); tabbed = true">Shell</a></li> <li ng-class="{active: tab(\'volumes\')}"> <a ng-click="tab(\'volumes\', $event); tabbed = true">Volumes</a></li> </ul> </div> <div class="listing-ct-body" ng-show="tab(\'main\')"> <kube-pod-body ng-init="pod = item"> </kube-pod-body> </div> <div class="listing-ct-body" ng-show="tab(\'containers\')"> <kube-container-body ng-repeat="container in containers(item)"> </kube-container-body> </div> <div class="listing-ct-body" ng-show="tab(\'logs\')"> <div class="container-fluid" ng-repeat="container in containers(item)" ng-class="{\'container-more\': !$first}"> <p ng-if="!($first && $last)">{{ container.spec.name }}</p> <kube-console pod="item" container="container.spec.name" prevent="!tabbed"> </kube-console> </div> </div> <div class="listing-ct-body" ng-show="tab(\'shell\')"> <div class="container-fluid" ng-repeat="container in containers(item)" ng-if="item.status.phase == \'Running\' && container.status.state.running" ng-class="{\'container-more\': !$first}"> <p ng-if="!($first && $last)">{{ container.spec.name }}</p> <kubernetes-container-terminal pod="item" container="container.spec.name" prevent="!tabbed"> </kubernetes-container-terminal> </div> </div> <div class="listing-ct-body" ng-show="tab(\'volumes\')"> <div class="container-fluid well" ng-repeat="podVolume in volumesForPod(item)" data-id="{{ podVolume.name }}"> <dl ng-if="!podVolume.persistentVolumeClaim" volume-body volume="podVolume"></dl> <dl ng-if="podVolume.persistentVolumeClaim" pvc-body settings="settings" item="claimFromVolumeSource(podVolume.persistentVolumeClaim, item.metadata.namespace)"></dl> <dl> <dt translate>Mount Location</dt> <dd> <span ng-if="!podVolume.mounts" translate>None</span> <dl class="full-width" ng-if="podVolume.mounts"> <dt ng-repeat-start="(name, data) in podVolume.mounts">{{ name }}</dt> <dd ng-repeat-end>{{ data.mountPath }}</dd> </dl> </dd> </dl> </div> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/pod-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="listing-ct-head"> <div class="listing-ct-actions"> <button title="Adjust" class="btn btn-default pficon pficon-edit" ng-click="modifyRoute(item)"></button>\n<button title="Delete" class="route-delete btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteItem(item)"> </button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"><a ng-click="tab(\'main\', $event)" translate>Route</a></li> </ul> </div> <div class="listing-ct-body" route-body ng-show="tab(\'main\')"> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/route-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div> <div class="listing-ct-head"> <div class="listing-ct-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="deletePV(item)"></button>\n<button class="btn btn-default pficon pficon-edit" ng-if="canEdit(item)" ng-click="modifyPV(item)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"> <a ng-click="tab(\'main\', $event)" translate>Volume</a> </li> <li ng-class="{active: tab(\'claim\')}"> <a ng-click="tab(\'claim\', $event)" translate>Claim</a> </li> </ul> </div> <div pv-body class="listing-ct-body" ng-show="tab(\'main\')"> </div> <div class="listing-ct-body" ng-show="tab(\'claim\')" pv-claim></div> </div> ';
    n.run([ "$templateCache", function(e) {
        e.put("views/pv-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div> <div class="listing-ct-head" ng-click="listing.collapse(id, $event)"> <div class="listing-ct-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteImageStream(stream)"></button>\n<button class="btn btn-default pficon pficon-edit" ng-click="modifyImageStream(stream)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"><a ng-click="tab(\'main\', $event)">Image stream</a></li> <li ng-class="{active: tab(\'meta\')}" ng-if="stream.metadata.annotations"> <a ng-click="tab(\'meta\', $event)">Metadata</a></li> </ul> </div> <div class="listing-ct-body" ng-show="tab(\'main\')"> <registry-imagestream-body imagestream="stream" imagestream-modify="modifyImageStream" project-modify="modifyProject" project-sharing="sharedImages"> </registry-imagestream-body> <registry-imagestream-push imagestream="stream" settings="settings"> </registry-imagestream-push> </div> <div class="listing-ct-body" ng-if="tab(\'meta\')" ng-if="stream.metadata.annotations"> <registry-imagestream-meta imagestream="stream"> </registry-imagestream-meta> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/imagestream-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="listing-ct-body"> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/default-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="listing-ct-head"> <div class="listing-ct-actions"> <button title="Delete" class="delete-pod btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteNode(item)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"><a ng-click="tab(\'main\', $event)" translate>Node</a></li> <li ng-class="{active: tab(\'capacity\')}"><a ng-click="tab(\'capacity\', $event)">Capacity</a></li> </ul> </div> <div node-alerts></div> <div class="listing-ct-body" ng-show="tab(\'main\')"> <div class="row" node-body></div> </div> <div class="listing-ct-body" ng-show="tab(\'capacity\')"> <div class="row" node-capacity></div> <div class="row" node-stats></div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/node-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="listing-ct-actions project-panel-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="removeProject(project())"></button>\n<button class="btn btn-default pficon pficon-edit" ng-click="modifyProject(project())"></button> </div> <div class="listing-ct-body project-panel"> <p class="project-description" ng-if="project().metadata.annotations[\'openshift.io/description\']"> {{ project().metadata.annotations[\'openshift.io/description\'] }} </p> <div project-body> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/project-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="listing-ct-head"> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"> <a ng-click="tab(\'main\', $event)" translate>Container</a></li> <li ng-class="{active: tab(\'logs\')}"> <a class="logs" ng-click="tab(\'logs\', $event); tabbed = true" translate>Logs</a></li> <li ng-class="{active: tab(\'shell\')}" ng-if="item.status.phase == \'Running\' && container.status.state.running"> <a class="shell" ng-click="tab(\'shell\', $event); tabbed = true" translate>Shell</a></li> </ul> </div> <div class="listing-ct-body" ng-show="tab(\'main\')"> <kube-container-body></kube-container-body> </div> <div class="listing-ct-body" ng-show="tab(\'logs\')"> <kube-console pod="item" container="container.spec.name" prevent="!tabbed"> </kube-console> </div> <div class="listing-ct-body" ng-show="tab(\'shell\')" ng-if="item.status.phase == \'Running\' && container.status.state.running"> <kubernetes-container-terminal pod="item" container="container.spec.name" prevent="!tabbed"> </kubernetes-container-terminal> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/container-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="listing-ct-head"> <div class="listing-ct-actions"> <button title="Delete" class="deployment-delete btn btn-danger btn-delete pficon pficon-delete delete-entity" ng-click="deleteItem(item)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"> <a ng-click="tab(\'main\', $event)" translate>Deployment Config</a></li> <li ng-class="{active: tab(\'template\')}" ng-if="item.spec.template"> <a ng-click="tab(\'template\', $event)" translate>Template</a></li> </ul> </div> <div class="listing-ct-body" deploymentconfig-body ng-show="tab(\'main\')"></div> <div class="listing-ct-body" ng-show="tab(\'template\')" ng-if="item.spec.template"> <kube-pod-body ng-init="pod = item.spec.template"> </kube-pod-body> <kube-container-body ng-repeat="container in containers(item.spec.template)"> </kube-container-body> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/deploymentconfig-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="listing-ct-head" ng-click="listing.collapse(id, $event)"> <div class="listing-ct-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="removeGroup(projects(), group())"></button> </div> <h3><i class="pficon pficon-users"></i>{{ group().metadata.name }}</h3> </div> <div class="listing-ct-body project-panel" ng-show="tab(\'main\')"> <div> <table listing-table class="listing-ct project-body"> <thead> <tr> <th translate>Group Members</th> <th translate></th> </tr> </thead> <tbody colspan="3" ng-repeat="user in group().users"> <tr class="listing-ct-item inner-project-listing"> <td><i class="pficon-user"></i> {{ user }}</td> <td><a class="pull-right close-icon"> <i translate class="pficon-close" ng-click="removeUserFromGroup(user, group())"></i> </a></td> </tr> </tbody> <thead> <tr> <td colspan="3"> <a class="pull-left" disabled="disabled"> <i translate class="pficon pficon-add-circle-o"></i>\n<span translate ng-click="addUserToGroup(group())">Add Member</span> </a> </td> </tr> </thead> </table> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/group-panel.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="listing-ct-head"> <div class="listing-ct-actions"> <button title="Delete" class="delete-entity btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteItem(item)"></button>\n<button title="Adjust" class="adjust-entity btn btn-default pficon pficon-edit" ng-click="modifyRC(item)"></button> </div> <ul class="nav nav-tabs nav-tabs-pf"> <li ng-class="{active: tab(\'main\')}"> <a ng-click="tab(\'main\', $event)" translate>Replication Controller</a></li> <li ng-class="{active: tab(\'pods\')}"> <a ng-click="tab(\'pods\', $event)" translate>Pods</a></li> <li ng-class="{active: tab(\'template\')}"> <a ng-click="tab(\'template\', $event)" translate>Template</a></li> </ul> </div> <div class="listing-ct-body" replicationcontroller-body ng-show="tab(\'main\')"> </div> <div class="listing-ct-body" replicationcontroller-pods ng-show="tab(\'pods\')"> </div> <div class="listing-ct-body" ng-show="tab(\'template\')"> <kube-pod-body ng-init="pod = item.spec.template"> </kube-pod-body> <kube-container-body ng-repeat="container in containers(item.spec.template)"> </kube-container-body> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/replicationcontroller-panel.html", r);
    } ]), e.exports = r;
}, , , function(e, t, n) {
    "use strict";
    !function() {
        var e = n(32), t = n(62);
        n(39), e.module("kubernetes.date", [ "kubeClient" ]).factory("refreshEveryMin", [ "$rootScope", "$window", "kubeLoader", function(e, t, n) {
            var a = 0, r = 6e4, i = 500;
            return n.listen(function() {
                a = new Date().getTime();
            }), t.setInterval(function() {
                var t = new Date().getTime();
                t - a + i >= r && e.$applyAsync(), a = t;
            }, r), {};
        } ]).filter("dateRelative", [ "refreshEveryMin", function() {
            function e(e) {
                return e ? t(e).fromNow() : e;
            }
            return e.$stateful = !0, e;
        } ]);
    }();
}, function(e, t, n) {
    (function(e) {
        //! moment.js
        //! version : 2.10.6
        //! authors : Tim Wood, Iskren Chernev, Moment.js contributors
        //! license : MIT
        //! momentjs.com
        !function(t, n) {
            e.exports = n();
        }(this, function() {
            "use strict";
            function t() {
                return On.apply(null, arguments);
            }
            function a(e) {
                On = e;
            }
            function r(e) {
                return "[object Array]" === Object.prototype.toString.call(e);
            }
            function i(e) {
                return e instanceof Date || "[object Date]" === Object.prototype.toString.call(e);
            }
            function s(e, t) {
                var n, a = [];
                for (n = 0; n < e.length; ++n) a.push(t(e[n], n));
                return a;
            }
            function o(e, t) {
                return Object.prototype.hasOwnProperty.call(e, t);
            }
            function l(e, t) {
                for (var n in t) o(t, n) && (e[n] = t[n]);
                return o(t, "toString") && (e.toString = t.toString), o(t, "valueOf") && (e.valueOf = t.valueOf), 
                e;
            }
            function u(e, t, n, a) {
                return xe(e, t, n, a, !0).utc();
            }
            function c() {
                return {
                    empty: !1,
                    unusedTokens: [],
                    unusedInput: [],
                    overflow: -2,
                    charsLeftOver: 0,
                    nullInput: !1,
                    invalidMonth: null,
                    invalidFormat: !1,
                    userInvalidated: !1,
                    iso: !1
                };
            }
            function d(e) {
                return null == e._pf && (e._pf = c()), e._pf;
            }
            function m(e) {
                if (null == e._isValid) {
                    var t = d(e);
                    e._isValid = !(isNaN(e._d.getTime()) || !(t.overflow < 0) || t.empty || t.invalidMonth || t.invalidWeekday || t.nullInput || t.invalidFormat || t.userInvalidated), 
                    e._strict && (e._isValid = e._isValid && 0 === t.charsLeftOver && 0 === t.unusedTokens.length && void 0 === t.bigHour);
                }
                return e._isValid;
            }
            function f(e) {
                var t = u(NaN);
                return null != e ? l(d(t), e) : d(t).userInvalidated = !0, t;
            }
            function p(e, t) {
                var n, a, r;
                if ("undefined" != typeof t._isAMomentObject && (e._isAMomentObject = t._isAMomentObject), 
                "undefined" != typeof t._i && (e._i = t._i), "undefined" != typeof t._f && (e._f = t._f), 
                "undefined" != typeof t._l && (e._l = t._l), "undefined" != typeof t._strict && (e._strict = t._strict), 
                "undefined" != typeof t._tzm && (e._tzm = t._tzm), "undefined" != typeof t._isUTC && (e._isUTC = t._isUTC), 
                "undefined" != typeof t._offset && (e._offset = t._offset), "undefined" != typeof t._pf && (e._pf = d(t)), 
                "undefined" != typeof t._locale && (e._locale = t._locale), Pn.length > 0) for (n in Pn) a = Pn[n], 
                r = t[a], "undefined" != typeof r && (e[a] = r);
                return e;
            }
            function h(e) {
                p(this, e), this._d = new Date(null != e._d ? e._d.getTime() : NaN), Fn === !1 && (Fn = !0, 
                t.updateOffset(this), Fn = !1);
            }
            function g(e) {
                return e instanceof h || null != e && null != e._isAMomentObject;
            }
            function _(e) {
                return e < 0 ? Math.ceil(e) : Math.floor(e);
            }
            function v(e) {
                var t = +e, n = 0;
                return 0 !== t && isFinite(t) && (n = _(t)), n;
            }
            function b(e, t, n) {
                var a, r = Math.min(e.length, t.length), i = Math.abs(e.length - t.length), s = 0;
                for (a = 0; a < r; a++) (n && e[a] !== t[a] || !n && v(e[a]) !== v(t[a])) && s++;
                return s + i;
            }
            function y() {}
            function M(e) {
                return e ? e.toLowerCase().replace("_", "-") : e;
            }
            function $(e) {
                for (var t, n, a, r, i = 0; i < e.length; ) {
                    for (r = M(e[i]).split("-"), t = r.length, n = M(e[i + 1]), n = n ? n.split("-") : null; t > 0; ) {
                        if (a = k(r.slice(0, t).join("-"))) return a;
                        if (n && n.length >= t && b(r, n, !0) >= t - 1) break;
                        t--;
                    }
                    i++;
                }
                return null;
            }
            function k(t) {
                var a = null;
                if (!Un[t] && "undefined" != typeof e && e && e.exports) try {
                    a = In._abbr, n(64)("./" + t), w(a);
                } catch (e) {}
                return Un[t];
            }
            function w(e, t) {
                var n;
                return e && (n = "undefined" == typeof t ? D(e) : L(e, t), n && (In = n)), In._abbr;
            }
            function L(e, t) {
                return null !== t ? (t.abbr = e, Un[e] = Un[e] || new y(), Un[e].set(t), w(e), Un[e]) : (delete Un[e], 
                null);
            }
            function D(e) {
                var t;
                if (e && e._locale && e._locale._abbr && (e = e._locale._abbr), !e) return In;
                if (!r(e)) {
                    if (t = k(e)) return t;
                    e = [ e ];
                }
                return $(e);
            }
            function Y(e, t) {
                var n = e.toLowerCase();
                Nn[n] = Nn[n + "s"] = Nn[t] = e;
            }
            function T(e) {
                return "string" == typeof e ? Nn[e] || Nn[e.toLowerCase()] : void 0;
            }
            function S(e) {
                var t, n, a = {};
                for (n in e) o(e, n) && (t = T(n), t && (a[t] = e[n]));
                return a;
            }
            function x(e, n) {
                return function(a) {
                    return null != a ? (E(this, e, a), t.updateOffset(this, n), this) : C(this, e);
                };
            }
            function C(e, t) {
                return e._d["get" + (e._isUTC ? "UTC" : "") + t]();
            }
            function E(e, t, n) {
                return e._d["set" + (e._isUTC ? "UTC" : "") + t](n);
            }
            function H(e, t) {
                var n;
                if ("object" == typeof e) for (n in e) this.set(n, e[n]); else if (e = T(e), "function" == typeof this[e]) return this[e](t);
                return this;
            }
            function A(e, t, n) {
                var a = "" + Math.abs(e), r = t - a.length, i = e >= 0;
                return (i ? n ? "+" : "" : "-") + Math.pow(10, Math.max(0, r)).toString().substr(1) + a;
            }
            function j(e, t, n, a) {
                var r = a;
                "string" == typeof a && (r = function() {
                    return this[a]();
                }), e && (Rn[e] = r), t && (Rn[t[0]] = function() {
                    return A(r.apply(this, arguments), t[1], t[2]);
                }), n && (Rn[n] = function() {
                    return this.localeData().ordinal(r.apply(this, arguments), e);
                });
            }
            function O(e) {
                return e.match(/\[[\s\S]/) ? e.replace(/^\[|\]$/g, "") : e.replace(/\\/g, "");
            }
            function I(e) {
                var t, n, a = e.match(Vn);
                for (t = 0, n = a.length; t < n; t++) Rn[a[t]] ? a[t] = Rn[a[t]] : a[t] = O(a[t]);
                return function(r) {
                    var i = "";
                    for (t = 0; t < n; t++) i += a[t] instanceof Function ? a[t].call(r, e) : a[t];
                    return i;
                };
            }
            function P(e, t) {
                return e.isValid() ? (t = F(t, e.localeData()), qn[t] = qn[t] || I(t), qn[t](e)) : e.localeData().invalidDate();
            }
            function F(e, t) {
                function n(e) {
                    return t.longDateFormat(e) || e;
                }
                var a = 5;
                for (Wn.lastIndex = 0; a >= 0 && Wn.test(e); ) e = e.replace(Wn, n), Wn.lastIndex = 0, 
                a -= 1;
                return e;
            }
            function U(e) {
                return "function" == typeof e && "[object Function]" === Object.prototype.toString.call(e);
            }
            function N(e, t, n) {
                sa[e] = U(t) ? t : function(e) {
                    return e && n ? n : t;
                };
            }
            function V(e, t) {
                return o(sa, e) ? sa[e](t._strict, t._locale) : new RegExp(W(e));
            }
            function W(e) {
                return e.replace("\\", "").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g, function(e, t, n, a, r) {
                    return t || n || a || r;
                }).replace(/[-\/\\^$*+?.()|[\]{}]/g, "\\$&");
            }
            function q(e, t) {
                var n, a = t;
                for ("string" == typeof e && (e = [ e ]), "number" == typeof t && (a = function(e, n) {
                    n[t] = v(e);
                }), n = 0; n < e.length; n++) oa[e[n]] = a;
            }
            function R(e, t) {
                q(e, function(e, n, a, r) {
                    a._w = a._w || {}, t(e, a._w, a, r);
                });
            }
            function z(e, t, n) {
                null != t && o(oa, e) && oa[e](t, n._a, n, e);
            }
            function B(e, t) {
                return new Date(Date.UTC(e, t + 1, 0)).getUTCDate();
            }
            function G(e) {
                return this._months[e.month()];
            }
            function J(e) {
                return this._monthsShort[e.month()];
            }
            function K(e, t, n) {
                var a, r, i;
                for (this._monthsParse || (this._monthsParse = [], this._longMonthsParse = [], this._shortMonthsParse = []), 
                a = 0; a < 12; a++) {
                    if (r = u([ 2e3, a ]), n && !this._longMonthsParse[a] && (this._longMonthsParse[a] = new RegExp("^" + this.months(r, "").replace(".", "") + "$", "i"), 
                    this._shortMonthsParse[a] = new RegExp("^" + this.monthsShort(r, "").replace(".", "") + "$", "i")), 
                    n || this._monthsParse[a] || (i = "^" + this.months(r, "") + "|^" + this.monthsShort(r, ""), 
                    this._monthsParse[a] = new RegExp(i.replace(".", ""), "i")), n && "MMMM" === t && this._longMonthsParse[a].test(e)) return a;
                    if (n && "MMM" === t && this._shortMonthsParse[a].test(e)) return a;
                    if (!n && this._monthsParse[a].test(e)) return a;
                }
            }
            function Q(e, t) {
                var n;
                return "string" == typeof t && (t = e.localeData().monthsParse(t), "number" != typeof t) ? e : (n = Math.min(e.date(), B(e.year(), t)), 
                e._d["set" + (e._isUTC ? "UTC" : "") + "Month"](t, n), e);
            }
            function Z(e) {
                return null != e ? (Q(this, e), t.updateOffset(this, !0), this) : C(this, "Month");
            }
            function X() {
                return B(this.year(), this.month());
            }
            function ee(e) {
                var t, n = e._a;
                return n && d(e).overflow === -2 && (t = n[ua] < 0 || n[ua] > 11 ? ua : n[ca] < 1 || n[ca] > B(n[la], n[ua]) ? ca : n[da] < 0 || n[da] > 24 || 24 === n[da] && (0 !== n[ma] || 0 !== n[fa] || 0 !== n[pa]) ? da : n[ma] < 0 || n[ma] > 59 ? ma : n[fa] < 0 || n[fa] > 59 ? fa : n[pa] < 0 || n[pa] > 999 ? pa : -1, 
                d(e)._overflowDayOfYear && (t < la || t > ca) && (t = ca), d(e).overflow = t), e;
            }
            function te(e) {
                t.suppressDeprecationWarnings === !1 && "undefined" != typeof console && console.warn && console.warn("Deprecation warning: " + e);
            }
            function ne(e, t) {
                var n = !0;
                return l(function() {
                    return n && (te(e + "\n" + new Error().stack), n = !1), t.apply(this, arguments);
                }, t);
            }
            function ae(e, t) {
                _a[e] || (te(t), _a[e] = !0);
            }
            function re(e) {
                var t, n, a = e._i, r = va.exec(a);
                if (r) {
                    for (d(e).iso = !0, t = 0, n = ba.length; t < n; t++) if (ba[t][1].exec(a)) {
                        e._f = ba[t][0];
                        break;
                    }
                    for (t = 0, n = ya.length; t < n; t++) if (ya[t][1].exec(a)) {
                        e._f += (r[6] || " ") + ya[t][0];
                        break;
                    }
                    a.match(aa) && (e._f += "Z"), ke(e);
                } else e._isValid = !1;
            }
            function ie(e) {
                var n = Ma.exec(e._i);
                return null !== n ? void (e._d = new Date(+n[1])) : (re(e), void (e._isValid === !1 && (delete e._isValid, 
                t.createFromInputFallback(e))));
            }
            function se(e, t, n, a, r, i, s) {
                var o = new Date(e, t, n, a, r, i, s);
                return e < 1970 && o.setFullYear(e), o;
            }
            function oe(e) {
                var t = new Date(Date.UTC.apply(null, arguments));
                return e < 1970 && t.setUTCFullYear(e), t;
            }
            function le(e) {
                return ue(e) ? 366 : 365;
            }
            function ue(e) {
                return e % 4 === 0 && e % 100 !== 0 || e % 400 === 0;
            }
            function ce() {
                return ue(this.year());
            }
            function de(e, t, n) {
                var a, r = n - t, i = n - e.day();
                return i > r && (i -= 7), i < r - 7 && (i += 7), a = Ce(e).add(i, "d"), {
                    week: Math.ceil(a.dayOfYear() / 7),
                    year: a.year()
                };
            }
            function me(e) {
                return de(e, this._week.dow, this._week.doy).week;
            }
            function fe() {
                return this._week.dow;
            }
            function pe() {
                return this._week.doy;
            }
            function he(e) {
                var t = this.localeData().week(this);
                return null == e ? t : this.add(7 * (e - t), "d");
            }
            function ge(e) {
                var t = de(this, 1, 4).week;
                return null == e ? t : this.add(7 * (e - t), "d");
            }
            function _e(e, t, n, a, r) {
                var i, s = 6 + r - a, o = oe(e, 0, 1 + s), l = o.getUTCDay();
                return l < r && (l += 7), n = null != n ? 1 * n : r, i = 1 + s + 7 * (t - 1) - l + n, 
                {
                    year: i > 0 ? e : e - 1,
                    dayOfYear: i > 0 ? i : le(e - 1) + i
                };
            }
            function ve(e) {
                var t = Math.round((this.clone().startOf("day") - this.clone().startOf("year")) / 864e5) + 1;
                return null == e ? t : this.add(e - t, "d");
            }
            function be(e, t, n) {
                return null != e ? e : null != t ? t : n;
            }
            function ye(e) {
                var t = new Date();
                return e._useUTC ? [ t.getUTCFullYear(), t.getUTCMonth(), t.getUTCDate() ] : [ t.getFullYear(), t.getMonth(), t.getDate() ];
            }
            function Me(e) {
                var t, n, a, r, i = [];
                if (!e._d) {
                    for (a = ye(e), e._w && null == e._a[ca] && null == e._a[ua] && $e(e), e._dayOfYear && (r = be(e._a[la], a[la]), 
                    e._dayOfYear > le(r) && (d(e)._overflowDayOfYear = !0), n = oe(r, 0, e._dayOfYear), 
                    e._a[ua] = n.getUTCMonth(), e._a[ca] = n.getUTCDate()), t = 0; t < 3 && null == e._a[t]; ++t) e._a[t] = i[t] = a[t];
                    for (;t < 7; t++) e._a[t] = i[t] = null == e._a[t] ? 2 === t ? 1 : 0 : e._a[t];
                    24 === e._a[da] && 0 === e._a[ma] && 0 === e._a[fa] && 0 === e._a[pa] && (e._nextDay = !0, 
                    e._a[da] = 0), e._d = (e._useUTC ? oe : se).apply(null, i), null != e._tzm && e._d.setUTCMinutes(e._d.getUTCMinutes() - e._tzm), 
                    e._nextDay && (e._a[da] = 24);
                }
            }
            function $e(e) {
                var t, n, a, r, i, s, o;
                t = e._w, null != t.GG || null != t.W || null != t.E ? (i = 1, s = 4, n = be(t.GG, e._a[la], de(Ce(), 1, 4).year), 
                a = be(t.W, 1), r = be(t.E, 1)) : (i = e._locale._week.dow, s = e._locale._week.doy, 
                n = be(t.gg, e._a[la], de(Ce(), i, s).year), a = be(t.w, 1), null != t.d ? (r = t.d, 
                r < i && ++a) : r = null != t.e ? t.e + i : i), o = _e(n, a, r, s, i), e._a[la] = o.year, 
                e._dayOfYear = o.dayOfYear;
            }
            function ke(e) {
                if (e._f === t.ISO_8601) return void re(e);
                e._a = [], d(e).empty = !0;
                var n, a, r, i, s, o = "" + e._i, l = o.length, u = 0;
                for (r = F(e._f, e._locale).match(Vn) || [], n = 0; n < r.length; n++) i = r[n], 
                a = (o.match(V(i, e)) || [])[0], a && (s = o.substr(0, o.indexOf(a)), s.length > 0 && d(e).unusedInput.push(s), 
                o = o.slice(o.indexOf(a) + a.length), u += a.length), Rn[i] ? (a ? d(e).empty = !1 : d(e).unusedTokens.push(i), 
                z(i, a, e)) : e._strict && !a && d(e).unusedTokens.push(i);
                d(e).charsLeftOver = l - u, o.length > 0 && d(e).unusedInput.push(o), d(e).bigHour === !0 && e._a[da] <= 12 && e._a[da] > 0 && (d(e).bigHour = void 0), 
                e._a[da] = we(e._locale, e._a[da], e._meridiem), Me(e), ee(e);
            }
            function we(e, t, n) {
                var a;
                return null == n ? t : null != e.meridiemHour ? e.meridiemHour(t, n) : null != e.isPM ? (a = e.isPM(n), 
                a && t < 12 && (t += 12), a || 12 !== t || (t = 0), t) : t;
            }
            function Le(e) {
                var t, n, a, r, i;
                if (0 === e._f.length) return d(e).invalidFormat = !0, void (e._d = new Date(NaN));
                for (r = 0; r < e._f.length; r++) i = 0, t = p({}, e), null != e._useUTC && (t._useUTC = e._useUTC), 
                t._f = e._f[r], ke(t), m(t) && (i += d(t).charsLeftOver, i += 10 * d(t).unusedTokens.length, 
                d(t).score = i, (null == a || i < a) && (a = i, n = t));
                l(e, n || t);
            }
            function De(e) {
                if (!e._d) {
                    var t = S(e._i);
                    e._a = [ t.year, t.month, t.day || t.date, t.hour, t.minute, t.second, t.millisecond ], 
                    Me(e);
                }
            }
            function Ye(e) {
                var t = new h(ee(Te(e)));
                return t._nextDay && (t.add(1, "d"), t._nextDay = void 0), t;
            }
            function Te(e) {
                var t = e._i, n = e._f;
                return e._locale = e._locale || D(e._l), null === t || void 0 === n && "" === t ? f({
                    nullInput: !0
                }) : ("string" == typeof t && (e._i = t = e._locale.preparse(t)), g(t) ? new h(ee(t)) : (r(n) ? Le(e) : n ? ke(e) : i(t) ? e._d = t : Se(e), 
                e));
            }
            function Se(e) {
                var n = e._i;
                void 0 === n ? e._d = new Date() : i(n) ? e._d = new Date(+n) : "string" == typeof n ? ie(e) : r(n) ? (e._a = s(n.slice(0), function(e) {
                    return parseInt(e, 10);
                }), Me(e)) : "object" == typeof n ? De(e) : "number" == typeof n ? e._d = new Date(n) : t.createFromInputFallback(e);
            }
            function xe(e, t, n, a, r) {
                var i = {};
                return "boolean" == typeof n && (a = n, n = void 0), i._isAMomentObject = !0, i._useUTC = i._isUTC = r, 
                i._l = n, i._i = e, i._f = t, i._strict = a, Ye(i);
            }
            function Ce(e, t, n, a) {
                return xe(e, t, n, a, !1);
            }
            function Ee(e, t) {
                var n, a;
                if (1 === t.length && r(t[0]) && (t = t[0]), !t.length) return Ce();
                for (n = t[0], a = 1; a < t.length; ++a) t[a].isValid() && !t[a][e](n) || (n = t[a]);
                return n;
            }
            function He() {
                var e = [].slice.call(arguments, 0);
                return Ee("isBefore", e);
            }
            function Ae() {
                var e = [].slice.call(arguments, 0);
                return Ee("isAfter", e);
            }
            function je(e) {
                var t = S(e), n = t.year || 0, a = t.quarter || 0, r = t.month || 0, i = t.week || 0, s = t.day || 0, o = t.hour || 0, l = t.minute || 0, u = t.second || 0, c = t.millisecond || 0;
                this._milliseconds = +c + 1e3 * u + 6e4 * l + 36e5 * o, this._days = +s + 7 * i, 
                this._months = +r + 3 * a + 12 * n, this._data = {}, this._locale = D(), this._bubble();
            }
            function Oe(e) {
                return e instanceof je;
            }
            function Ie(e, t) {
                j(e, 0, 0, function() {
                    var e = this.utcOffset(), n = "+";
                    return e < 0 && (e = -e, n = "-"), n + A(~~(e / 60), 2) + t + A(~~e % 60, 2);
                });
            }
            function Pe(e) {
                var t = (e || "").match(aa) || [], n = t[t.length - 1] || [], a = (n + "").match(Da) || [ "-", 0, 0 ], r = +(60 * a[1]) + v(a[2]);
                return "+" === a[0] ? r : -r;
            }
            function Fe(e, n) {
                var a, r;
                return n._isUTC ? (a = n.clone(), r = (g(e) || i(e) ? +e : +Ce(e)) - +a, a._d.setTime(+a._d + r), 
                t.updateOffset(a, !1), a) : Ce(e).local();
            }
            function Ue(e) {
                return 15 * -Math.round(e._d.getTimezoneOffset() / 15);
            }
            function Ne(e, n) {
                var a, r = this._offset || 0;
                return null != e ? ("string" == typeof e && (e = Pe(e)), Math.abs(e) < 16 && (e *= 60), 
                !this._isUTC && n && (a = Ue(this)), this._offset = e, this._isUTC = !0, null != a && this.add(a, "m"), 
                r !== e && (!n || this._changeInProgress ? at(this, Ze(e - r, "m"), 1, !1) : this._changeInProgress || (this._changeInProgress = !0, 
                t.updateOffset(this, !0), this._changeInProgress = null)), this) : this._isUTC ? r : Ue(this);
            }
            function Ve(e, t) {
                return null != e ? ("string" != typeof e && (e = -e), this.utcOffset(e, t), this) : -this.utcOffset();
            }
            function We(e) {
                return this.utcOffset(0, e);
            }
            function qe(e) {
                return this._isUTC && (this.utcOffset(0, e), this._isUTC = !1, e && this.subtract(Ue(this), "m")), 
                this;
            }
            function Re() {
                return this._tzm ? this.utcOffset(this._tzm) : "string" == typeof this._i && this.utcOffset(Pe(this._i)), 
                this;
            }
            function ze(e) {
                return e = e ? Ce(e).utcOffset() : 0, (this.utcOffset() - e) % 60 === 0;
            }
            function Be() {
                return this.utcOffset() > this.clone().month(0).utcOffset() || this.utcOffset() > this.clone().month(5).utcOffset();
            }
            function Ge() {
                if ("undefined" != typeof this._isDSTShifted) return this._isDSTShifted;
                var e = {};
                if (p(e, this), e = Te(e), e._a) {
                    var t = e._isUTC ? u(e._a) : Ce(e._a);
                    this._isDSTShifted = this.isValid() && b(e._a, t.toArray()) > 0;
                } else this._isDSTShifted = !1;
                return this._isDSTShifted;
            }
            function Je() {
                return !this._isUTC;
            }
            function Ke() {
                return this._isUTC;
            }
            function Qe() {
                return this._isUTC && 0 === this._offset;
            }
            function Ze(e, t) {
                var n, a, r, i = e, s = null;
                return Oe(e) ? i = {
                    ms: e._milliseconds,
                    d: e._days,
                    M: e._months
                } : "number" == typeof e ? (i = {}, t ? i[t] = e : i.milliseconds = e) : (s = Ya.exec(e)) ? (n = "-" === s[1] ? -1 : 1, 
                i = {
                    y: 0,
                    d: v(s[ca]) * n,
                    h: v(s[da]) * n,
                    m: v(s[ma]) * n,
                    s: v(s[fa]) * n,
                    ms: v(s[pa]) * n
                }) : (s = Ta.exec(e)) ? (n = "-" === s[1] ? -1 : 1, i = {
                    y: Xe(s[2], n),
                    M: Xe(s[3], n),
                    d: Xe(s[4], n),
                    h: Xe(s[5], n),
                    m: Xe(s[6], n),
                    s: Xe(s[7], n),
                    w: Xe(s[8], n)
                }) : null == i ? i = {} : "object" == typeof i && ("from" in i || "to" in i) && (r = tt(Ce(i.from), Ce(i.to)), 
                i = {}, i.ms = r.milliseconds, i.M = r.months), a = new je(i), Oe(e) && o(e, "_locale") && (a._locale = e._locale), 
                a;
            }
            function Xe(e, t) {
                var n = e && parseFloat(e.replace(",", "."));
                return (isNaN(n) ? 0 : n) * t;
            }
            function et(e, t) {
                var n = {
                    milliseconds: 0,
                    months: 0
                };
                return n.months = t.month() - e.month() + 12 * (t.year() - e.year()), e.clone().add(n.months, "M").isAfter(t) && --n.months, 
                n.milliseconds = +t - +e.clone().add(n.months, "M"), n;
            }
            function tt(e, t) {
                var n;
                return t = Fe(t, e), e.isBefore(t) ? n = et(e, t) : (n = et(t, e), n.milliseconds = -n.milliseconds, 
                n.months = -n.months), n;
            }
            function nt(e, t) {
                return function(n, a) {
                    var r, i;
                    return null === a || isNaN(+a) || (ae(t, "moment()." + t + "(period, number) is deprecated. Please use moment()." + t + "(number, period)."), 
                    i = n, n = a, a = i), n = "string" == typeof n ? +n : n, r = Ze(n, a), at(this, r, e), 
                    this;
                };
            }
            function at(e, n, a, r) {
                var i = n._milliseconds, s = n._days, o = n._months;
                r = null == r || r, i && e._d.setTime(+e._d + i * a), s && E(e, "Date", C(e, "Date") + s * a), 
                o && Q(e, C(e, "Month") + o * a), r && t.updateOffset(e, s || o);
            }
            function rt(e, t) {
                var n = e || Ce(), a = Fe(n, this).startOf("day"), r = this.diff(a, "days", !0), i = r < -6 ? "sameElse" : r < -1 ? "lastWeek" : r < 0 ? "lastDay" : r < 1 ? "sameDay" : r < 2 ? "nextDay" : r < 7 ? "nextWeek" : "sameElse";
                return this.format(t && t[i] || this.localeData().calendar(i, this, Ce(n)));
            }
            function it() {
                return new h(this);
            }
            function st(e, t) {
                var n;
                return t = T("undefined" != typeof t ? t : "millisecond"), "millisecond" === t ? (e = g(e) ? e : Ce(e), 
                +this > +e) : (n = g(e) ? +e : +Ce(e), n < +this.clone().startOf(t));
            }
            function ot(e, t) {
                var n;
                return t = T("undefined" != typeof t ? t : "millisecond"), "millisecond" === t ? (e = g(e) ? e : Ce(e), 
                +this < +e) : (n = g(e) ? +e : +Ce(e), +this.clone().endOf(t) < n);
            }
            function lt(e, t, n) {
                return this.isAfter(e, n) && this.isBefore(t, n);
            }
            function ut(e, t) {
                var n;
                return t = T(t || "millisecond"), "millisecond" === t ? (e = g(e) ? e : Ce(e), +this === +e) : (n = +Ce(e), 
                +this.clone().startOf(t) <= n && n <= +this.clone().endOf(t));
            }
            function ct(e, t, n) {
                var a, r, i = Fe(e, this), s = 6e4 * (i.utcOffset() - this.utcOffset());
                return t = T(t), "year" === t || "month" === t || "quarter" === t ? (r = dt(this, i), 
                "quarter" === t ? r /= 3 : "year" === t && (r /= 12)) : (a = this - i, r = "second" === t ? a / 1e3 : "minute" === t ? a / 6e4 : "hour" === t ? a / 36e5 : "day" === t ? (a - s) / 864e5 : "week" === t ? (a - s) / 6048e5 : a), 
                n ? r : _(r);
            }
            function dt(e, t) {
                var n, a, r = 12 * (t.year() - e.year()) + (t.month() - e.month()), i = e.clone().add(r, "months");
                return t - i < 0 ? (n = e.clone().add(r - 1, "months"), a = (t - i) / (i - n)) : (n = e.clone().add(r + 1, "months"), 
                a = (t - i) / (n - i)), -(r + a);
            }
            function mt() {
                return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ");
            }
            function ft() {
                var e = this.clone().utc();
                return 0 < e.year() && e.year() <= 9999 ? "function" == typeof Date.prototype.toISOString ? this.toDate().toISOString() : P(e, "YYYY-MM-DD[T]HH:mm:ss.SSS[Z]") : P(e, "YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]");
            }
            function pt(e) {
                var n = P(this, e || t.defaultFormat);
                return this.localeData().postformat(n);
            }
            function ht(e, t) {
                return this.isValid() ? Ze({
                    to: this,
                    from: e
                }).locale(this.locale()).humanize(!t) : this.localeData().invalidDate();
            }
            function gt(e) {
                return this.from(Ce(), e);
            }
            function _t(e, t) {
                return this.isValid() ? Ze({
                    from: this,
                    to: e
                }).locale(this.locale()).humanize(!t) : this.localeData().invalidDate();
            }
            function vt(e) {
                return this.to(Ce(), e);
            }
            function bt(e) {
                var t;
                return void 0 === e ? this._locale._abbr : (t = D(e), null != t && (this._locale = t), 
                this);
            }
            function yt() {
                return this._locale;
            }
            function Mt(e) {
                switch (e = T(e)) {
                  case "year":
                    this.month(0);

                  case "quarter":
                  case "month":
                    this.date(1);

                  case "week":
                  case "isoWeek":
                  case "day":
                    this.hours(0);

                  case "hour":
                    this.minutes(0);

                  case "minute":
                    this.seconds(0);

                  case "second":
                    this.milliseconds(0);
                }
                return "week" === e && this.weekday(0), "isoWeek" === e && this.isoWeekday(1), "quarter" === e && this.month(3 * Math.floor(this.month() / 3)), 
                this;
            }
            function $t(e) {
                return e = T(e), void 0 === e || "millisecond" === e ? this : this.startOf(e).add(1, "isoWeek" === e ? "week" : e).subtract(1, "ms");
            }
            function kt() {
                return +this._d - 6e4 * (this._offset || 0);
            }
            function wt() {
                return Math.floor(+this / 1e3);
            }
            function Lt() {
                return this._offset ? new Date(+this) : this._d;
            }
            function Dt() {
                var e = this;
                return [ e.year(), e.month(), e.date(), e.hour(), e.minute(), e.second(), e.millisecond() ];
            }
            function Yt() {
                var e = this;
                return {
                    years: e.year(),
                    months: e.month(),
                    date: e.date(),
                    hours: e.hours(),
                    minutes: e.minutes(),
                    seconds: e.seconds(),
                    milliseconds: e.milliseconds()
                };
            }
            function Tt() {
                return m(this);
            }
            function St() {
                return l({}, d(this));
            }
            function xt() {
                return d(this).overflow;
            }
            function Ct(e, t) {
                j(0, [ e, e.length ], 0, t);
            }
            function Et(e, t, n) {
                return de(Ce([ e, 11, 31 + t - n ]), t, n).week;
            }
            function Ht(e) {
                var t = de(this, this.localeData()._week.dow, this.localeData()._week.doy).year;
                return null == e ? t : this.add(e - t, "y");
            }
            function At(e) {
                var t = de(this, 1, 4).year;
                return null == e ? t : this.add(e - t, "y");
            }
            function jt() {
                return Et(this.year(), 1, 4);
            }
            function Ot() {
                var e = this.localeData()._week;
                return Et(this.year(), e.dow, e.doy);
            }
            function It(e) {
                return null == e ? Math.ceil((this.month() + 1) / 3) : this.month(3 * (e - 1) + this.month() % 3);
            }
            function Pt(e, t) {
                return "string" != typeof e ? e : isNaN(e) ? (e = t.weekdaysParse(e), "number" == typeof e ? e : null) : parseInt(e, 10);
            }
            function Ft(e) {
                return this._weekdays[e.day()];
            }
            function Ut(e) {
                return this._weekdaysShort[e.day()];
            }
            function Nt(e) {
                return this._weekdaysMin[e.day()];
            }
            function Vt(e) {
                var t, n, a;
                for (this._weekdaysParse = this._weekdaysParse || [], t = 0; t < 7; t++) if (this._weekdaysParse[t] || (n = Ce([ 2e3, 1 ]).day(t), 
                a = "^" + this.weekdays(n, "") + "|^" + this.weekdaysShort(n, "") + "|^" + this.weekdaysMin(n, ""), 
                this._weekdaysParse[t] = new RegExp(a.replace(".", ""), "i")), this._weekdaysParse[t].test(e)) return t;
            }
            function Wt(e) {
                var t = this._isUTC ? this._d.getUTCDay() : this._d.getDay();
                return null != e ? (e = Pt(e, this.localeData()), this.add(e - t, "d")) : t;
            }
            function qt(e) {
                var t = (this.day() + 7 - this.localeData()._week.dow) % 7;
                return null == e ? t : this.add(e - t, "d");
            }
            function Rt(e) {
                return null == e ? this.day() || 7 : this.day(this.day() % 7 ? e : e - 7);
            }
            function zt(e, t) {
                j(e, 0, 0, function() {
                    return this.localeData().meridiem(this.hours(), this.minutes(), t);
                });
            }
            function Bt(e, t) {
                return t._meridiemParse;
            }
            function Gt(e) {
                return "p" === (e + "").toLowerCase().charAt(0);
            }
            function Jt(e, t, n) {
                return e > 11 ? n ? "pm" : "PM" : n ? "am" : "AM";
            }
            function Kt(e, t) {
                t[pa] = v(1e3 * ("0." + e));
            }
            function Qt() {
                return this._isUTC ? "UTC" : "";
            }
            function Zt() {
                return this._isUTC ? "Coordinated Universal Time" : "";
            }
            function Xt(e) {
                return Ce(1e3 * e);
            }
            function en() {
                return Ce.apply(null, arguments).parseZone();
            }
            function tn(e, t, n) {
                var a = this._calendar[e];
                return "function" == typeof a ? a.call(t, n) : a;
            }
            function nn(e) {
                var t = this._longDateFormat[e], n = this._longDateFormat[e.toUpperCase()];
                return t || !n ? t : (this._longDateFormat[e] = n.replace(/MMMM|MM|DD|dddd/g, function(e) {
                    return e.slice(1);
                }), this._longDateFormat[e]);
            }
            function an() {
                return this._invalidDate;
            }
            function rn(e) {
                return this._ordinal.replace("%d", e);
            }
            function sn(e) {
                return e;
            }
            function on(e, t, n, a) {
                var r = this._relativeTime[n];
                return "function" == typeof r ? r(e, t, n, a) : r.replace(/%d/i, e);
            }
            function ln(e, t) {
                var n = this._relativeTime[e > 0 ? "future" : "past"];
                return "function" == typeof n ? n(t) : n.replace(/%s/i, t);
            }
            function un(e) {
                var t, n;
                for (n in e) t = e[n], "function" == typeof t ? this[n] = t : this["_" + n] = t;
                this._ordinalParseLenient = new RegExp(this._ordinalParse.source + "|" + /\d{1,2}/.source);
            }
            function cn(e, t, n, a) {
                var r = D(), i = u().set(a, t);
                return r[n](i, e);
            }
            function dn(e, t, n, a, r) {
                if ("number" == typeof e && (t = e, e = void 0), e = e || "", null != t) return cn(e, t, n, r);
                var i, s = [];
                for (i = 0; i < a; i++) s[i] = cn(e, i, n, r);
                return s;
            }
            function mn(e, t) {
                return dn(e, t, "months", 12, "month");
            }
            function fn(e, t) {
                return dn(e, t, "monthsShort", 12, "month");
            }
            function pn(e, t) {
                return dn(e, t, "weekdays", 7, "day");
            }
            function hn(e, t) {
                return dn(e, t, "weekdaysShort", 7, "day");
            }
            function gn(e, t) {
                return dn(e, t, "weekdaysMin", 7, "day");
            }
            function _n() {
                var e = this._data;
                return this._milliseconds = Qa(this._milliseconds), this._days = Qa(this._days), 
                this._months = Qa(this._months), e.milliseconds = Qa(e.milliseconds), e.seconds = Qa(e.seconds), 
                e.minutes = Qa(e.minutes), e.hours = Qa(e.hours), e.months = Qa(e.months), e.years = Qa(e.years), 
                this;
            }
            function vn(e, t, n, a) {
                var r = Ze(t, n);
                return e._milliseconds += a * r._milliseconds, e._days += a * r._days, e._months += a * r._months, 
                e._bubble();
            }
            function bn(e, t) {
                return vn(this, e, t, 1);
            }
            function yn(e, t) {
                return vn(this, e, t, -1);
            }
            function Mn(e) {
                return e < 0 ? Math.floor(e) : Math.ceil(e);
            }
            function $n() {
                var e, t, n, a, r, i = this._milliseconds, s = this._days, o = this._months, l = this._data;
                return i >= 0 && s >= 0 && o >= 0 || i <= 0 && s <= 0 && o <= 0 || (i += 864e5 * Mn(wn(o) + s), 
                s = 0, o = 0), l.milliseconds = i % 1e3, e = _(i / 1e3), l.seconds = e % 60, t = _(e / 60), 
                l.minutes = t % 60, n = _(t / 60), l.hours = n % 24, s += _(n / 24), r = _(kn(s)), 
                o += r, s -= Mn(wn(r)), a = _(o / 12), o %= 12, l.days = s, l.months = o, l.years = a, 
                this;
            }
            function kn(e) {
                return 4800 * e / 146097;
            }
            function wn(e) {
                return 146097 * e / 4800;
            }
            function Ln(e) {
                var t, n, a = this._milliseconds;
                if (e = T(e), "month" === e || "year" === e) return t = this._days + a / 864e5, 
                n = this._months + kn(t), "month" === e ? n : n / 12;
                switch (t = this._days + Math.round(wn(this._months)), e) {
                  case "week":
                    return t / 7 + a / 6048e5;

                  case "day":
                    return t + a / 864e5;

                  case "hour":
                    return 24 * t + a / 36e5;

                  case "minute":
                    return 1440 * t + a / 6e4;

                  case "second":
                    return 86400 * t + a / 1e3;

                  case "millisecond":
                    return Math.floor(864e5 * t) + a;

                  default:
                    throw new Error("Unknown unit " + e);
                }
            }
            function Dn() {
                return this._milliseconds + 864e5 * this._days + this._months % 12 * 2592e6 + 31536e6 * v(this._months / 12);
            }
            function Yn(e) {
                return function() {
                    return this.as(e);
                };
            }
            function Tn(e) {
                return e = T(e), this[e + "s"]();
            }
            function Sn(e) {
                return function() {
                    return this._data[e];
                };
            }
            function xn() {
                return _(this.days() / 7);
            }
            function Cn(e, t, n, a, r) {
                return r.relativeTime(t || 1, !!n, e, a);
            }
            function En(e, t, n) {
                var a = Ze(e).abs(), r = fr(a.as("s")), i = fr(a.as("m")), s = fr(a.as("h")), o = fr(a.as("d")), l = fr(a.as("M")), u = fr(a.as("y")), c = r < pr.s && [ "s", r ] || 1 === i && [ "m" ] || i < pr.m && [ "mm", i ] || 1 === s && [ "h" ] || s < pr.h && [ "hh", s ] || 1 === o && [ "d" ] || o < pr.d && [ "dd", o ] || 1 === l && [ "M" ] || l < pr.M && [ "MM", l ] || 1 === u && [ "y" ] || [ "yy", u ];
                return c[2] = t, c[3] = +e > 0, c[4] = n, Cn.apply(null, c);
            }
            function Hn(e, t) {
                return void 0 !== pr[e] && (void 0 === t ? pr[e] : (pr[e] = t, !0));
            }
            function An(e) {
                var t = this.localeData(), n = En(this, !e, t);
                return e && (n = t.pastFuture(+this, n)), t.postformat(n);
            }
            function jn() {
                var e, t, n, a = hr(this._milliseconds) / 1e3, r = hr(this._days), i = hr(this._months);
                e = _(a / 60), t = _(e / 60), a %= 60, e %= 60, n = _(i / 12), i %= 12;
                var s = n, o = i, l = r, u = t, c = e, d = a, m = this.asSeconds();
                return m ? (m < 0 ? "-" : "") + "P" + (s ? s + "Y" : "") + (o ? o + "M" : "") + (l ? l + "D" : "") + (u || c || d ? "T" : "") + (u ? u + "H" : "") + (c ? c + "M" : "") + (d ? d + "S" : "") : "P0D";
            }
            var On, In, Pn = t.momentProperties = [], Fn = !1, Un = {}, Nn = {}, Vn = /(\[[^\[]*\])|(\\)?(Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Q|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g, Wn = /(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g, qn = {}, Rn = {}, zn = /\d/, Bn = /\d\d/, Gn = /\d{3}/, Jn = /\d{4}/, Kn = /[+-]?\d{6}/, Qn = /\d\d?/, Zn = /\d{1,3}/, Xn = /\d{1,4}/, ea = /[+-]?\d{1,6}/, ta = /\d+/, na = /[+-]?\d+/, aa = /Z|[+-]\d\d:?\d\d/gi, ra = /[+-]?\d+(\.\d{1,3})?/, ia = /[0-9]*['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+|[\u0600-\u06FF\/]+(\s*?[\u0600-\u06FF]+){1,2}/i, sa = {}, oa = {}, la = 0, ua = 1, ca = 2, da = 3, ma = 4, fa = 5, pa = 6;
            j("M", [ "MM", 2 ], "Mo", function() {
                return this.month() + 1;
            }), j("MMM", 0, 0, function(e) {
                return this.localeData().monthsShort(this, e);
            }), j("MMMM", 0, 0, function(e) {
                return this.localeData().months(this, e);
            }), Y("month", "M"), N("M", Qn), N("MM", Qn, Bn), N("MMM", ia), N("MMMM", ia), q([ "M", "MM" ], function(e, t) {
                t[ua] = v(e) - 1;
            }), q([ "MMM", "MMMM" ], function(e, t, n, a) {
                var r = n._locale.monthsParse(e, a, n._strict);
                null != r ? t[ua] = r : d(n).invalidMonth = e;
            });
            var ha = "January_February_March_April_May_June_July_August_September_October_November_December".split("_"), ga = "Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"), _a = {};
            t.suppressDeprecationWarnings = !1;
            var va = /^\s*(?:[+-]\d{6}|\d{4})-(?:(\d\d-\d\d)|(W\d\d$)|(W\d\d-\d)|(\d\d\d))((T| )(\d\d(:\d\d(:\d\d(\.\d+)?)?)?)?([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/, ba = [ [ "YYYYYY-MM-DD", /[+-]\d{6}-\d{2}-\d{2}/ ], [ "YYYY-MM-DD", /\d{4}-\d{2}-\d{2}/ ], [ "GGGG-[W]WW-E", /\d{4}-W\d{2}-\d/ ], [ "GGGG-[W]WW", /\d{4}-W\d{2}/ ], [ "YYYY-DDD", /\d{4}-\d{3}/ ] ], ya = [ [ "HH:mm:ss.SSSS", /(T| )\d\d:\d\d:\d\d\.\d+/ ], [ "HH:mm:ss", /(T| )\d\d:\d\d:\d\d/ ], [ "HH:mm", /(T| )\d\d:\d\d/ ], [ "HH", /(T| )\d\d/ ] ], Ma = /^\/?Date\((\-?\d+)/i;
            t.createFromInputFallback = ne("moment construction falls back to js Date. This is discouraged and will be removed in upcoming major release. Please refer to https://github.com/moment/moment/issues/1407 for more info.", function(e) {
                e._d = new Date(e._i + (e._useUTC ? " UTC" : ""));
            }), j(0, [ "YY", 2 ], 0, function() {
                return this.year() % 100;
            }), j(0, [ "YYYY", 4 ], 0, "year"), j(0, [ "YYYYY", 5 ], 0, "year"), j(0, [ "YYYYYY", 6, !0 ], 0, "year"), 
            Y("year", "y"), N("Y", na), N("YY", Qn, Bn), N("YYYY", Xn, Jn), N("YYYYY", ea, Kn), 
            N("YYYYYY", ea, Kn), q([ "YYYYY", "YYYYYY" ], la), q("YYYY", function(e, n) {
                n[la] = 2 === e.length ? t.parseTwoDigitYear(e) : v(e);
            }), q("YY", function(e, n) {
                n[la] = t.parseTwoDigitYear(e);
            }), t.parseTwoDigitYear = function(e) {
                return v(e) + (v(e) > 68 ? 1900 : 2e3);
            };
            var $a = x("FullYear", !1);
            j("w", [ "ww", 2 ], "wo", "week"), j("W", [ "WW", 2 ], "Wo", "isoWeek"), Y("week", "w"), 
            Y("isoWeek", "W"), N("w", Qn), N("ww", Qn, Bn), N("W", Qn), N("WW", Qn, Bn), R([ "w", "ww", "W", "WW" ], function(e, t, n, a) {
                t[a.substr(0, 1)] = v(e);
            });
            var ka = {
                dow: 0,
                doy: 6
            };
            j("DDD", [ "DDDD", 3 ], "DDDo", "dayOfYear"), Y("dayOfYear", "DDD"), N("DDD", Zn), 
            N("DDDD", Gn), q([ "DDD", "DDDD" ], function(e, t, n) {
                n._dayOfYear = v(e);
            }), t.ISO_8601 = function() {};
            var wa = ne("moment().min is deprecated, use moment.min instead. https://github.com/moment/moment/issues/1548", function() {
                var e = Ce.apply(null, arguments);
                return e < this ? this : e;
            }), La = ne("moment().max is deprecated, use moment.max instead. https://github.com/moment/moment/issues/1548", function() {
                var e = Ce.apply(null, arguments);
                return e > this ? this : e;
            });
            Ie("Z", ":"), Ie("ZZ", ""), N("Z", aa), N("ZZ", aa), q([ "Z", "ZZ" ], function(e, t, n) {
                n._useUTC = !0, n._tzm = Pe(e);
            });
            var Da = /([\+\-]|\d\d)/gi;
            t.updateOffset = function() {};
            var Ya = /(\-)?(?:(\d*)\.)?(\d+)\:(\d+)(?:\:(\d+)\.?(\d{3})?)?/, Ta = /^(-)?P(?:(?:([0-9,.]*)Y)?(?:([0-9,.]*)M)?(?:([0-9,.]*)D)?(?:T(?:([0-9,.]*)H)?(?:([0-9,.]*)M)?(?:([0-9,.]*)S)?)?|([0-9,.]*)W)$/;
            Ze.fn = je.prototype;
            var Sa = nt(1, "add"), xa = nt(-1, "subtract");
            t.defaultFormat = "YYYY-MM-DDTHH:mm:ssZ";
            var Ca = ne("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.", function(e) {
                return void 0 === e ? this.localeData() : this.locale(e);
            });
            j(0, [ "gg", 2 ], 0, function() {
                return this.weekYear() % 100;
            }), j(0, [ "GG", 2 ], 0, function() {
                return this.isoWeekYear() % 100;
            }), Ct("gggg", "weekYear"), Ct("ggggg", "weekYear"), Ct("GGGG", "isoWeekYear"), 
            Ct("GGGGG", "isoWeekYear"), Y("weekYear", "gg"), Y("isoWeekYear", "GG"), N("G", na), 
            N("g", na), N("GG", Qn, Bn), N("gg", Qn, Bn), N("GGGG", Xn, Jn), N("gggg", Xn, Jn), 
            N("GGGGG", ea, Kn), N("ggggg", ea, Kn), R([ "gggg", "ggggg", "GGGG", "GGGGG" ], function(e, t, n, a) {
                t[a.substr(0, 2)] = v(e);
            }), R([ "gg", "GG" ], function(e, n, a, r) {
                n[r] = t.parseTwoDigitYear(e);
            }), j("Q", 0, 0, "quarter"), Y("quarter", "Q"), N("Q", zn), q("Q", function(e, t) {
                t[ua] = 3 * (v(e) - 1);
            }), j("D", [ "DD", 2 ], "Do", "date"), Y("date", "D"), N("D", Qn), N("DD", Qn, Bn), 
            N("Do", function(e, t) {
                return e ? t._ordinalParse : t._ordinalParseLenient;
            }), q([ "D", "DD" ], ca), q("Do", function(e, t) {
                t[ca] = v(e.match(Qn)[0], 10);
            });
            var Ea = x("Date", !0);
            j("d", 0, "do", "day"), j("dd", 0, 0, function(e) {
                return this.localeData().weekdaysMin(this, e);
            }), j("ddd", 0, 0, function(e) {
                return this.localeData().weekdaysShort(this, e);
            }), j("dddd", 0, 0, function(e) {
                return this.localeData().weekdays(this, e);
            }), j("e", 0, 0, "weekday"), j("E", 0, 0, "isoWeekday"), Y("day", "d"), Y("weekday", "e"), 
            Y("isoWeekday", "E"), N("d", Qn), N("e", Qn), N("E", Qn), N("dd", ia), N("ddd", ia), 
            N("dddd", ia), R([ "dd", "ddd", "dddd" ], function(e, t, n) {
                var a = n._locale.weekdaysParse(e);
                null != a ? t.d = a : d(n).invalidWeekday = e;
            }), R([ "d", "e", "E" ], function(e, t, n, a) {
                t[a] = v(e);
            });
            var Ha = "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"), Aa = "Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"), ja = "Su_Mo_Tu_We_Th_Fr_Sa".split("_");
            j("H", [ "HH", 2 ], 0, "hour"), j("h", [ "hh", 2 ], 0, function() {
                return this.hours() % 12 || 12;
            }), zt("a", !0), zt("A", !1), Y("hour", "h"), N("a", Bt), N("A", Bt), N("H", Qn), 
            N("h", Qn), N("HH", Qn, Bn), N("hh", Qn, Bn), q([ "H", "HH" ], da), q([ "a", "A" ], function(e, t, n) {
                n._isPm = n._locale.isPM(e), n._meridiem = e;
            }), q([ "h", "hh" ], function(e, t, n) {
                t[da] = v(e), d(n).bigHour = !0;
            });
            var Oa = /[ap]\.?m?\.?/i, Ia = x("Hours", !0);
            j("m", [ "mm", 2 ], 0, "minute"), Y("minute", "m"), N("m", Qn), N("mm", Qn, Bn), 
            q([ "m", "mm" ], ma);
            var Pa = x("Minutes", !1);
            j("s", [ "ss", 2 ], 0, "second"), Y("second", "s"), N("s", Qn), N("ss", Qn, Bn), 
            q([ "s", "ss" ], fa);
            var Fa = x("Seconds", !1);
            j("S", 0, 0, function() {
                return ~~(this.millisecond() / 100);
            }), j(0, [ "SS", 2 ], 0, function() {
                return ~~(this.millisecond() / 10);
            }), j(0, [ "SSS", 3 ], 0, "millisecond"), j(0, [ "SSSS", 4 ], 0, function() {
                return 10 * this.millisecond();
            }), j(0, [ "SSSSS", 5 ], 0, function() {
                return 100 * this.millisecond();
            }), j(0, [ "SSSSSS", 6 ], 0, function() {
                return 1e3 * this.millisecond();
            }), j(0, [ "SSSSSSS", 7 ], 0, function() {
                return 1e4 * this.millisecond();
            }), j(0, [ "SSSSSSSS", 8 ], 0, function() {
                return 1e5 * this.millisecond();
            }), j(0, [ "SSSSSSSSS", 9 ], 0, function() {
                return 1e6 * this.millisecond();
            }), Y("millisecond", "ms"), N("S", Zn, zn), N("SS", Zn, Bn), N("SSS", Zn, Gn);
            var Ua;
            for (Ua = "SSSS"; Ua.length <= 9; Ua += "S") N(Ua, ta);
            for (Ua = "S"; Ua.length <= 9; Ua += "S") q(Ua, Kt);
            var Na = x("Milliseconds", !1);
            j("z", 0, 0, "zoneAbbr"), j("zz", 0, 0, "zoneName");
            var Va = h.prototype;
            Va.add = Sa, Va.calendar = rt, Va.clone = it, Va.diff = ct, Va.endOf = $t, Va.format = pt, 
            Va.from = ht, Va.fromNow = gt, Va.to = _t, Va.toNow = vt, Va.get = H, Va.invalidAt = xt, 
            Va.isAfter = st, Va.isBefore = ot, Va.isBetween = lt, Va.isSame = ut, Va.isValid = Tt, 
            Va.lang = Ca, Va.locale = bt, Va.localeData = yt, Va.max = La, Va.min = wa, Va.parsingFlags = St, 
            Va.set = H, Va.startOf = Mt, Va.subtract = xa, Va.toArray = Dt, Va.toObject = Yt, 
            Va.toDate = Lt, Va.toISOString = ft, Va.toJSON = ft, Va.toString = mt, Va.unix = wt, 
            Va.valueOf = kt, Va.year = $a, Va.isLeapYear = ce, Va.weekYear = Ht, Va.isoWeekYear = At, 
            Va.quarter = Va.quarters = It, Va.month = Z, Va.daysInMonth = X, Va.week = Va.weeks = he, 
            Va.isoWeek = Va.isoWeeks = ge, Va.weeksInYear = Ot, Va.isoWeeksInYear = jt, Va.date = Ea, 
            Va.day = Va.days = Wt, Va.weekday = qt, Va.isoWeekday = Rt, Va.dayOfYear = ve, Va.hour = Va.hours = Ia, 
            Va.minute = Va.minutes = Pa, Va.second = Va.seconds = Fa, Va.millisecond = Va.milliseconds = Na, 
            Va.utcOffset = Ne, Va.utc = We, Va.local = qe, Va.parseZone = Re, Va.hasAlignedHourOffset = ze, 
            Va.isDST = Be, Va.isDSTShifted = Ge, Va.isLocal = Je, Va.isUtcOffset = Ke, Va.isUtc = Qe, 
            Va.isUTC = Qe, Va.zoneAbbr = Qt, Va.zoneName = Zt, Va.dates = ne("dates accessor is deprecated. Use date instead.", Ea), 
            Va.months = ne("months accessor is deprecated. Use month instead", Z), Va.years = ne("years accessor is deprecated. Use year instead", $a), 
            Va.zone = ne("moment().zone is deprecated, use moment().utcOffset instead. https://github.com/moment/moment/issues/1779", Ve);
            var Wa = Va, qa = {
                sameDay: "[Today at] LT",
                nextDay: "[Tomorrow at] LT",
                nextWeek: "dddd [at] LT",
                lastDay: "[Yesterday at] LT",
                lastWeek: "[Last] dddd [at] LT",
                sameElse: "L"
            }, Ra = {
                LTS: "h:mm:ss A",
                LT: "h:mm A",
                L: "MM/DD/YYYY",
                LL: "MMMM D, YYYY",
                LLL: "MMMM D, YYYY h:mm A",
                LLLL: "dddd, MMMM D, YYYY h:mm A"
            }, za = "Invalid date", Ba = "%d", Ga = /\d{1,2}/, Ja = {
                future: "in %s",
                past: "%s ago",
                s: "a few seconds",
                m: "a minute",
                mm: "%d minutes",
                h: "an hour",
                hh: "%d hours",
                d: "a day",
                dd: "%d days",
                M: "a month",
                MM: "%d months",
                y: "a year",
                yy: "%d years"
            }, Ka = y.prototype;
            Ka._calendar = qa, Ka.calendar = tn, Ka._longDateFormat = Ra, Ka.longDateFormat = nn, 
            Ka._invalidDate = za, Ka.invalidDate = an, Ka._ordinal = Ba, Ka.ordinal = rn, Ka._ordinalParse = Ga, 
            Ka.preparse = sn, Ka.postformat = sn, Ka._relativeTime = Ja, Ka.relativeTime = on, 
            Ka.pastFuture = ln, Ka.set = un, Ka.months = G, Ka._months = ha, Ka.monthsShort = J, 
            Ka._monthsShort = ga, Ka.monthsParse = K, Ka.week = me, Ka._week = ka, Ka.firstDayOfYear = pe, 
            Ka.firstDayOfWeek = fe, Ka.weekdays = Ft, Ka._weekdays = Ha, Ka.weekdaysMin = Nt, 
            Ka._weekdaysMin = ja, Ka.weekdaysShort = Ut, Ka._weekdaysShort = Aa, Ka.weekdaysParse = Vt, 
            Ka.isPM = Gt, Ka._meridiemParse = Oa, Ka.meridiem = Jt, w("en", {
                ordinalParse: /\d{1,2}(th|st|nd|rd)/,
                ordinal: function(e) {
                    var t = e % 10, n = 1 === v(e % 100 / 10) ? "th" : 1 === t ? "st" : 2 === t ? "nd" : 3 === t ? "rd" : "th";
                    return e + n;
                }
            }), t.lang = ne("moment.lang is deprecated. Use moment.locale instead.", w), t.langData = ne("moment.langData is deprecated. Use moment.localeData instead.", D);
            var Qa = Math.abs, Za = Yn("ms"), Xa = Yn("s"), er = Yn("m"), tr = Yn("h"), nr = Yn("d"), ar = Yn("w"), rr = Yn("M"), ir = Yn("y"), sr = Sn("milliseconds"), or = Sn("seconds"), lr = Sn("minutes"), ur = Sn("hours"), cr = Sn("days"), dr = Sn("months"), mr = Sn("years"), fr = Math.round, pr = {
                s: 45,
                m: 45,
                h: 22,
                d: 26,
                M: 11
            }, hr = Math.abs, gr = je.prototype;
            gr.abs = _n, gr.add = bn, gr.subtract = yn, gr.as = Ln, gr.asMilliseconds = Za, 
            gr.asSeconds = Xa, gr.asMinutes = er, gr.asHours = tr, gr.asDays = nr, gr.asWeeks = ar, 
            gr.asMonths = rr, gr.asYears = ir, gr.valueOf = Dn, gr._bubble = $n, gr.get = Tn, 
            gr.milliseconds = sr, gr.seconds = or, gr.minutes = lr, gr.hours = ur, gr.days = cr, 
            gr.weeks = xn, gr.months = dr, gr.years = mr, gr.humanize = An, gr.toISOString = jn, 
            gr.toString = jn, gr.toJSON = jn, gr.locale = bt, gr.localeData = yt, gr.toIsoString = ne("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)", jn), 
            gr.lang = Ca, j("X", 0, 0, "unix"), j("x", 0, 0, "valueOf"), N("x", na), N("X", ra), 
            q("X", function(e, t, n) {
                n._d = new Date(1e3 * parseFloat(e, 10));
            }), q("x", function(e, t, n) {
                n._d = new Date(v(e));
            }), t.version = "2.10.6", a(Ce), t.fn = Wa, t.min = He, t.max = Ae, t.utc = u, t.unix = Xt, 
            t.months = mn, t.isDate = i, t.locale = w, t.invalid = f, t.duration = Ze, t.isMoment = g, 
            t.weekdays = pn, t.parseZone = en, t.localeData = D, t.isDuration = Oe, t.monthsShort = fn, 
            t.weekdaysMin = gn, t.defineLocale = L, t.weekdaysShort = hn, t.normalizeUnits = T, 
            t.relativeTimeThreshold = Hn;
            var _r = t;
            return _r;
        });
    }).call(t, n(63)(e));
}, function(e, t) {
    e.exports = function(e) {
        return e.webpackPolyfill || (e.deprecate = function() {}, e.paths = [], e.children = [], 
        e.webpackPolyfill = 1), e;
    };
}, function(e, t, n) {
    function a(e) {
        return n(r(e));
    }
    function r(e) {
        return i[e] || function() {
            throw new Error("Cannot find module '" + e + "'.");
        }();
    }
    var i = {
        "./af": 65,
        "./af.js": 65,
        "./ar": 66,
        "./ar-ma": 67,
        "./ar-ma.js": 67,
        "./ar-sa": 68,
        "./ar-sa.js": 68,
        "./ar-tn": 69,
        "./ar-tn.js": 69,
        "./ar.js": 66,
        "./az": 70,
        "./az.js": 70,
        "./be": 71,
        "./be.js": 71,
        "./bg": 72,
        "./bg.js": 72,
        "./bn": 73,
        "./bn.js": 73,
        "./bo": 74,
        "./bo.js": 74,
        "./br": 75,
        "./br.js": 75,
        "./bs": 76,
        "./bs.js": 76,
        "./ca": 77,
        "./ca.js": 77,
        "./cs": 78,
        "./cs.js": 78,
        "./cv": 79,
        "./cv.js": 79,
        "./cy": 80,
        "./cy.js": 80,
        "./da": 81,
        "./da.js": 81,
        "./de": 82,
        "./de-at": 83,
        "./de-at.js": 83,
        "./de.js": 82,
        "./el": 84,
        "./el.js": 84,
        "./en-au": 85,
        "./en-au.js": 85,
        "./en-ca": 86,
        "./en-ca.js": 86,
        "./en-gb": 87,
        "./en-gb.js": 87,
        "./eo": 88,
        "./eo.js": 88,
        "./es": 89,
        "./es.js": 89,
        "./et": 90,
        "./et.js": 90,
        "./eu": 91,
        "./eu.js": 91,
        "./fa": 92,
        "./fa.js": 92,
        "./fi": 93,
        "./fi.js": 93,
        "./fo": 94,
        "./fo.js": 94,
        "./fr": 95,
        "./fr-ca": 96,
        "./fr-ca.js": 96,
        "./fr.js": 95,
        "./fy": 97,
        "./fy.js": 97,
        "./gl": 98,
        "./gl.js": 98,
        "./he": 99,
        "./he.js": 99,
        "./hi": 100,
        "./hi.js": 100,
        "./hr": 101,
        "./hr.js": 101,
        "./hu": 102,
        "./hu.js": 102,
        "./hy-am": 103,
        "./hy-am.js": 103,
        "./id": 104,
        "./id.js": 104,
        "./is": 105,
        "./is.js": 105,
        "./it": 106,
        "./it.js": 106,
        "./ja": 107,
        "./ja.js": 107,
        "./jv": 108,
        "./jv.js": 108,
        "./ka": 109,
        "./ka.js": 109,
        "./km": 110,
        "./km.js": 110,
        "./ko": 111,
        "./ko.js": 111,
        "./lb": 112,
        "./lb.js": 112,
        "./lt": 113,
        "./lt.js": 113,
        "./lv": 114,
        "./lv.js": 114,
        "./me": 115,
        "./me.js": 115,
        "./mk": 116,
        "./mk.js": 116,
        "./ml": 117,
        "./ml.js": 117,
        "./mr": 118,
        "./mr.js": 118,
        "./ms": 119,
        "./ms-my": 120,
        "./ms-my.js": 120,
        "./ms.js": 119,
        "./my": 121,
        "./my.js": 121,
        "./nb": 122,
        "./nb.js": 122,
        "./ne": 123,
        "./ne.js": 123,
        "./nl": 124,
        "./nl.js": 124,
        "./nn": 125,
        "./nn.js": 125,
        "./pl": 126,
        "./pl.js": 126,
        "./pt": 127,
        "./pt-br": 128,
        "./pt-br.js": 128,
        "./pt.js": 127,
        "./ro": 129,
        "./ro.js": 129,
        "./ru": 130,
        "./ru.js": 130,
        "./si": 131,
        "./si.js": 131,
        "./sk": 132,
        "./sk.js": 132,
        "./sl": 133,
        "./sl.js": 133,
        "./sq": 134,
        "./sq.js": 134,
        "./sr": 135,
        "./sr-cyrl": 136,
        "./sr-cyrl.js": 136,
        "./sr.js": 135,
        "./sv": 137,
        "./sv.js": 137,
        "./ta": 138,
        "./ta.js": 138,
        "./th": 139,
        "./th.js": 139,
        "./tl-ph": 140,
        "./tl-ph.js": 140,
        "./tr": 141,
        "./tr.js": 141,
        "./tzl": 142,
        "./tzl.js": 142,
        "./tzm": 143,
        "./tzm-latn": 144,
        "./tzm-latn.js": 144,
        "./tzm.js": 143,
        "./uk": 145,
        "./uk.js": 145,
        "./uz": 146,
        "./uz.js": 146,
        "./vi": 147,
        "./vi.js": 147,
        "./zh-cn": 148,
        "./zh-cn.js": 148,
        "./zh-tw": 149,
        "./zh-tw.js": 149
    };
    a.keys = function() {
        return Object.keys(i);
    }, a.resolve = r, e.exports = a, a.id = 64;
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : afrikaans (af)
    //! author : Werner Mollentze : https://github.com/wernerm
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("af", {
            months: "Januarie_Februarie_Maart_April_Mei_Junie_Julie_Augustus_September_Oktober_November_Desember".split("_"),
            monthsShort: "Jan_Feb_Mar_Apr_Mei_Jun_Jul_Aug_Sep_Okt_Nov_Des".split("_"),
            weekdays: "Sondag_Maandag_Dinsdag_Woensdag_Donderdag_Vrydag_Saterdag".split("_"),
            weekdaysShort: "Son_Maa_Din_Woe_Don_Vry_Sat".split("_"),
            weekdaysMin: "So_Ma_Di_Wo_Do_Vr_Sa".split("_"),
            meridiemParse: /vm|nm/i,
            isPM: function(e) {
                return /^nm$/i.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 12 ? n ? "vm" : "VM" : n ? "nm" : "NM";
            },
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Vandag om] LT",
                nextDay: "[Môre om] LT",
                nextWeek: "dddd [om] LT",
                lastDay: "[Gister om] LT",
                lastWeek: "[Laas] dddd [om] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "oor %s",
                past: "%s gelede",
                s: "'n paar sekondes",
                m: "'n minuut",
                mm: "%d minute",
                h: "'n uur",
                hh: "%d ure",
                d: "'n dag",
                dd: "%d dae",
                M: "'n maand",
                MM: "%d maande",
                y: "'n jaar",
                yy: "%d jaar"
            },
            ordinalParse: /\d{1,2}(ste|de)/,
            ordinal: function(e) {
                return e + (1 === e || 8 === e || e >= 20 ? "ste" : "de");
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! Locale: Arabic (ar)
    //! Author: Abdel Said: https://github.com/abdelsaid
    //! Changes in months, weekdays: Ahmed Elkhatib
    //! Native plural forms: forabi https://github.com/forabi
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "١",
            "2": "٢",
            "3": "٣",
            "4": "٤",
            "5": "٥",
            "6": "٦",
            "7": "٧",
            "8": "٨",
            "9": "٩",
            "0": "٠"
        }, n = {
            "١": "1",
            "٢": "2",
            "٣": "3",
            "٤": "4",
            "٥": "5",
            "٦": "6",
            "٧": "7",
            "٨": "8",
            "٩": "9",
            "٠": "0"
        }, a = function(e) {
            return 0 === e ? 0 : 1 === e ? 1 : 2 === e ? 2 : e % 100 >= 3 && e % 100 <= 10 ? 3 : e % 100 >= 11 ? 4 : 5;
        }, r = {
            s: [ "أقل من ثانية", "ثانية واحدة", [ "ثانيتان", "ثانيتين" ], "%d ثوان", "%d ثانية", "%d ثانية" ],
            m: [ "أقل من دقيقة", "دقيقة واحدة", [ "دقيقتان", "دقيقتين" ], "%d دقائق", "%d دقيقة", "%d دقيقة" ],
            h: [ "أقل من ساعة", "ساعة واحدة", [ "ساعتان", "ساعتين" ], "%d ساعات", "%d ساعة", "%d ساعة" ],
            d: [ "أقل من يوم", "يوم واحد", [ "يومان", "يومين" ], "%d أيام", "%d يومًا", "%d يوم" ],
            M: [ "أقل من شهر", "شهر واحد", [ "شهران", "شهرين" ], "%d أشهر", "%d شهرا", "%d شهر" ],
            y: [ "أقل من عام", "عام واحد", [ "عامان", "عامين" ], "%d أعوام", "%d عامًا", "%d عام" ]
        }, i = function(e) {
            return function(t, n, i, s) {
                var o = a(t), l = r[e][a(t)];
                return 2 === o && (l = l[n ? 0 : 1]), l.replace(/%d/i, t);
            };
        }, s = [ "كانون الثاني يناير", "شباط فبراير", "آذار مارس", "نيسان أبريل", "أيار مايو", "حزيران يونيو", "تموز يوليو", "آب أغسطس", "أيلول سبتمبر", "تشرين الأول أكتوبر", "تشرين الثاني نوفمبر", "كانون الأول ديسمبر" ], o = e.defineLocale("ar", {
            months: s,
            monthsShort: s,
            weekdays: "الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),
            weekdaysShort: "أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت".split("_"),
            weekdaysMin: "ح_ن_ث_ر_خ_ج_س".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "D/‏M/‏YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            meridiemParse: /ص|م/,
            isPM: function(e) {
                return "م" === e;
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "ص" : "م";
            },
            calendar: {
                sameDay: "[اليوم عند الساعة] LT",
                nextDay: "[غدًا عند الساعة] LT",
                nextWeek: "dddd [عند الساعة] LT",
                lastDay: "[أمس عند الساعة] LT",
                lastWeek: "dddd [عند الساعة] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "بعد %s",
                past: "منذ %s",
                s: i("s"),
                m: i("m"),
                mm: i("m"),
                h: i("h"),
                hh: i("h"),
                d: i("d"),
                dd: i("d"),
                M: i("M"),
                MM: i("M"),
                y: i("y"),
                yy: i("y")
            },
            preparse: function(e) {
                return e.replace(/\u200f/g, "").replace(/[١٢٣٤٥٦٧٨٩٠]/g, function(e) {
                    return n[e];
                }).replace(/،/g, ",");
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                }).replace(/,/g, "،");
            },
            week: {
                dow: 6,
                doy: 12
            }
        });
        return o;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Moroccan Arabic (ar-ma)
    //! author : ElFadili Yassine : https://github.com/ElFadiliY
    //! author : Abdel Said : https://github.com/abdelsaid
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ar-ma", {
            months: "يناير_فبراير_مارس_أبريل_ماي_يونيو_يوليوز_غشت_شتنبر_أكتوبر_نونبر_دجنبر".split("_"),
            monthsShort: "يناير_فبراير_مارس_أبريل_ماي_يونيو_يوليوز_غشت_شتنبر_أكتوبر_نونبر_دجنبر".split("_"),
            weekdays: "الأحد_الإتنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),
            weekdaysShort: "احد_اتنين_ثلاثاء_اربعاء_خميس_جمعة_سبت".split("_"),
            weekdaysMin: "ح_ن_ث_ر_خ_ج_س".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[اليوم على الساعة] LT",
                nextDay: "[غدا على الساعة] LT",
                nextWeek: "dddd [على الساعة] LT",
                lastDay: "[أمس على الساعة] LT",
                lastWeek: "dddd [على الساعة] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "في %s",
                past: "منذ %s",
                s: "ثوان",
                m: "دقيقة",
                mm: "%d دقائق",
                h: "ساعة",
                hh: "%d ساعات",
                d: "يوم",
                dd: "%d أيام",
                M: "شهر",
                MM: "%d أشهر",
                y: "سنة",
                yy: "%d سنوات"
            },
            week: {
                dow: 6,
                doy: 12
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Arabic Saudi Arabia (ar-sa)
    //! author : Suhail Alkowaileet : https://github.com/xsoh
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "١",
            "2": "٢",
            "3": "٣",
            "4": "٤",
            "5": "٥",
            "6": "٦",
            "7": "٧",
            "8": "٨",
            "9": "٩",
            "0": "٠"
        }, n = {
            "١": "1",
            "٢": "2",
            "٣": "3",
            "٤": "4",
            "٥": "5",
            "٦": "6",
            "٧": "7",
            "٨": "8",
            "٩": "9",
            "٠": "0"
        }, a = e.defineLocale("ar-sa", {
            months: "يناير_فبراير_مارس_أبريل_مايو_يونيو_يوليو_أغسطس_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),
            monthsShort: "يناير_فبراير_مارس_أبريل_مايو_يونيو_يوليو_أغسطس_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),
            weekdays: "الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),
            weekdaysShort: "أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت".split("_"),
            weekdaysMin: "ح_ن_ث_ر_خ_ج_س".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            meridiemParse: /ص|م/,
            isPM: function(e) {
                return "م" === e;
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "ص" : "م";
            },
            calendar: {
                sameDay: "[اليوم على الساعة] LT",
                nextDay: "[غدا على الساعة] LT",
                nextWeek: "dddd [على الساعة] LT",
                lastDay: "[أمس على الساعة] LT",
                lastWeek: "dddd [على الساعة] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "في %s",
                past: "منذ %s",
                s: "ثوان",
                m: "دقيقة",
                mm: "%d دقائق",
                h: "ساعة",
                hh: "%d ساعات",
                d: "يوم",
                dd: "%d أيام",
                M: "شهر",
                MM: "%d أشهر",
                y: "سنة",
                yy: "%d سنوات"
            },
            preparse: function(e) {
                return e.replace(/[١٢٣٤٥٦٧٨٩٠]/g, function(e) {
                    return n[e];
                }).replace(/،/g, ",");
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                }).replace(/,/g, "،");
            },
            week: {
                dow: 6,
                doy: 12
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale  : Tunisian Arabic (ar-tn)
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ar-tn", {
            months: "جانفي_فيفري_مارس_أفريل_ماي_جوان_جويلية_أوت_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),
            monthsShort: "جانفي_فيفري_مارس_أفريل_ماي_جوان_جويلية_أوت_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),
            weekdays: "الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),
            weekdaysShort: "أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت".split("_"),
            weekdaysMin: "ح_ن_ث_ر_خ_ج_س".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[اليوم على الساعة] LT",
                nextDay: "[غدا على الساعة] LT",
                nextWeek: "dddd [على الساعة] LT",
                lastDay: "[أمس على الساعة] LT",
                lastWeek: "dddd [على الساعة] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "في %s",
                past: "منذ %s",
                s: "ثوان",
                m: "دقيقة",
                mm: "%d دقائق",
                h: "ساعة",
                hh: "%d ساعات",
                d: "يوم",
                dd: "%d أيام",
                M: "شهر",
                MM: "%d أشهر",
                y: "سنة",
                yy: "%d سنوات"
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : azerbaijani (az)
    //! author : topchiyev : https://github.com/topchiyev
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            1: "-inci",
            5: "-inci",
            8: "-inci",
            70: "-inci",
            80: "-inci",
            2: "-nci",
            7: "-nci",
            20: "-nci",
            50: "-nci",
            3: "-üncü",
            4: "-üncü",
            100: "-üncü",
            6: "-ncı",
            9: "-uncu",
            10: "-uncu",
            30: "-uncu",
            60: "-ıncı",
            90: "-ıncı"
        }, n = e.defineLocale("az", {
            months: "yanvar_fevral_mart_aprel_may_iyun_iyul_avqust_sentyabr_oktyabr_noyabr_dekabr".split("_"),
            monthsShort: "yan_fev_mar_apr_may_iyn_iyl_avq_sen_okt_noy_dek".split("_"),
            weekdays: "Bazar_Bazar ertəsi_Çərşənbə axşamı_Çərşənbə_Cümə axşamı_Cümə_Şənbə".split("_"),
            weekdaysShort: "Baz_BzE_ÇAx_Çər_CAx_Cüm_Şən".split("_"),
            weekdaysMin: "Bz_BE_ÇA_Çə_CA_Cü_Şə".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[bugün saat] LT",
                nextDay: "[sabah saat] LT",
                nextWeek: "[gələn həftə] dddd [saat] LT",
                lastDay: "[dünən] LT",
                lastWeek: "[keçən həftə] dddd [saat] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s sonra",
                past: "%s əvvəl",
                s: "birneçə saniyyə",
                m: "bir dəqiqə",
                mm: "%d dəqiqə",
                h: "bir saat",
                hh: "%d saat",
                d: "bir gün",
                dd: "%d gün",
                M: "bir ay",
                MM: "%d ay",
                y: "bir il",
                yy: "%d il"
            },
            meridiemParse: /gecə|səhər|gündüz|axşam/,
            isPM: function(e) {
                return /^(gündüz|axşam)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "gecə" : e < 12 ? "səhər" : e < 17 ? "gündüz" : "axşam";
            },
            ordinalParse: /\d{1,2}-(ıncı|inci|nci|üncü|ncı|uncu)/,
            ordinal: function(e) {
                if (0 === e) return e + "-ıncı";
                var n = e % 10, a = e % 100 - n, r = e >= 100 ? 100 : null;
                return e + (t[n] || t[a] || t[r]);
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : belarusian (be)
    //! author : Dmitry Demidov : https://github.com/demidov91
    //! author: Praleska: http://praleska.pro/
    //! Author : Menelion Elensúle : https://github.com/Oire
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t) {
            var n = e.split("_");
            return t % 10 === 1 && t % 100 !== 11 ? n[0] : t % 10 >= 2 && t % 10 <= 4 && (t % 100 < 10 || t % 100 >= 20) ? n[1] : n[2];
        }
        function n(e, n, a) {
            var r = {
                mm: n ? "хвіліна_хвіліны_хвілін" : "хвіліну_хвіліны_хвілін",
                hh: n ? "гадзіна_гадзіны_гадзін" : "гадзіну_гадзіны_гадзін",
                dd: "дзень_дні_дзён",
                MM: "месяц_месяцы_месяцаў",
                yy: "год_гады_гадоў"
            };
            return "m" === a ? n ? "хвіліна" : "хвіліну" : "h" === a ? n ? "гадзіна" : "гадзіну" : e + " " + t(r[a], +e);
        }
        function a(e, t) {
            var n = {
                nominative: "студзень_люты_сакавік_красавік_травень_чэрвень_ліпень_жнівень_верасень_кастрычнік_лістапад_снежань".split("_"),
                accusative: "студзеня_лютага_сакавіка_красавіка_траўня_чэрвеня_ліпеня_жніўня_верасня_кастрычніка_лістапада_снежня".split("_")
            }, a = /D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function r(e, t) {
            var n = {
                nominative: "нядзеля_панядзелак_аўторак_серада_чацвер_пятніца_субота".split("_"),
                accusative: "нядзелю_панядзелак_аўторак_сераду_чацвер_пятніцу_суботу".split("_")
            }, a = /\[ ?[Вв] ?(?:мінулую|наступную)? ?\] ?dddd/.test(t) ? "accusative" : "nominative";
            return n[a][e.day()];
        }
        var i = e.defineLocale("be", {
            months: a,
            monthsShort: "студ_лют_сак_крас_трав_чэрв_ліп_жнів_вер_каст_ліст_снеж".split("_"),
            weekdays: r,
            weekdaysShort: "нд_пн_ат_ср_чц_пт_сб".split("_"),
            weekdaysMin: "нд_пн_ат_ср_чц_пт_сб".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY г.",
                LLL: "D MMMM YYYY г., HH:mm",
                LLLL: "dddd, D MMMM YYYY г., HH:mm"
            },
            calendar: {
                sameDay: "[Сёння ў] LT",
                nextDay: "[Заўтра ў] LT",
                lastDay: "[Учора ў] LT",
                nextWeek: function() {
                    return "[У] dddd [ў] LT";
                },
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                      case 3:
                      case 5:
                      case 6:
                        return "[У мінулую] dddd [ў] LT";

                      case 1:
                      case 2:
                      case 4:
                        return "[У мінулы] dddd [ў] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "праз %s",
                past: "%s таму",
                s: "некалькі секунд",
                m: n,
                mm: n,
                h: n,
                hh: n,
                d: "дзень",
                dd: n,
                M: "месяц",
                MM: n,
                y: "год",
                yy: n
            },
            meridiemParse: /ночы|раніцы|дня|вечара/,
            isPM: function(e) {
                return /^(дня|вечара)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "ночы" : e < 12 ? "раніцы" : e < 17 ? "дня" : "вечара";
            },
            ordinalParse: /\d{1,2}-(і|ы|га)/,
            ordinal: function(e, t) {
                switch (t) {
                  case "M":
                  case "d":
                  case "DDD":
                  case "w":
                  case "W":
                    return e % 10 !== 2 && e % 10 !== 3 || e % 100 === 12 || e % 100 === 13 ? e + "-ы" : e + "-і";

                  case "D":
                    return e + "-га";

                  default:
                    return e;
                }
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return i;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : bulgarian (bg)
    //! author : Krasen Borisov : https://github.com/kraz
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("bg", {
            months: "януари_февруари_март_април_май_юни_юли_август_септември_октомври_ноември_декември".split("_"),
            monthsShort: "янр_фев_мар_апр_май_юни_юли_авг_сеп_окт_ное_дек".split("_"),
            weekdays: "неделя_понеделник_вторник_сряда_четвъртък_петък_събота".split("_"),
            weekdaysShort: "нед_пон_вто_сря_чет_пет_съб".split("_"),
            weekdaysMin: "нд_пн_вт_ср_чт_пт_сб".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "D.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY H:mm",
                LLLL: "dddd, D MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[Днес в] LT",
                nextDay: "[Утре в] LT",
                nextWeek: "dddd [в] LT",
                lastDay: "[Вчера в] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                      case 3:
                      case 6:
                        return "[В изминалата] dddd [в] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[В изминалия] dddd [в] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "след %s",
                past: "преди %s",
                s: "няколко секунди",
                m: "минута",
                mm: "%d минути",
                h: "час",
                hh: "%d часа",
                d: "ден",
                dd: "%d дни",
                M: "месец",
                MM: "%d месеца",
                y: "година",
                yy: "%d години"
            },
            ordinalParse: /\d{1,2}-(ев|ен|ти|ви|ри|ми)/,
            ordinal: function(e) {
                var t = e % 10, n = e % 100;
                return 0 === e ? e + "-ев" : 0 === n ? e + "-ен" : n > 10 && n < 20 ? e + "-ти" : 1 === t ? e + "-ви" : 2 === t ? e + "-ри" : 7 === t || 8 === t ? e + "-ми" : e + "-ти";
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Bengali (bn)
    //! author : Kaushik Gandhi : https://github.com/kaushikgandhi
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "১",
            "2": "২",
            "3": "৩",
            "4": "৪",
            "5": "৫",
            "6": "৬",
            "7": "৭",
            "8": "৮",
            "9": "৯",
            "0": "০"
        }, n = {
            "১": "1",
            "২": "2",
            "৩": "3",
            "৪": "4",
            "৫": "5",
            "৬": "6",
            "৭": "7",
            "৮": "8",
            "৯": "9",
            "০": "0"
        }, a = e.defineLocale("bn", {
            months: "জানুয়ারী_ফেবুয়ারী_মার্চ_এপ্রিল_মে_জুন_জুলাই_অগাস্ট_সেপ্টেম্বর_অক্টোবর_নভেম্বর_ডিসেম্বর".split("_"),
            monthsShort: "জানু_ফেব_মার্চ_এপর_মে_জুন_জুল_অগ_সেপ্ট_অক্টো_নভ_ডিসেম্".split("_"),
            weekdays: "রবিবার_সোমবার_মঙ্গলবার_বুধবার_বৃহস্পত্তিবার_শুক্রুবার_শনিবার".split("_"),
            weekdaysShort: "রবি_সোম_মঙ্গল_বুধ_বৃহস্পত্তি_শুক্রু_শনি".split("_"),
            weekdaysMin: "রব_সম_মঙ্গ_বু_ব্রিহ_শু_শনি".split("_"),
            longDateFormat: {
                LT: "A h:mm সময়",
                LTS: "A h:mm:ss সময়",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, A h:mm সময়",
                LLLL: "dddd, D MMMM YYYY, A h:mm সময়"
            },
            calendar: {
                sameDay: "[আজ] LT",
                nextDay: "[আগামীকাল] LT",
                nextWeek: "dddd, LT",
                lastDay: "[গতকাল] LT",
                lastWeek: "[গত] dddd, LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s পরে",
                past: "%s আগে",
                s: "কএক সেকেন্ড",
                m: "এক মিনিট",
                mm: "%d মিনিট",
                h: "এক ঘন্টা",
                hh: "%d ঘন্টা",
                d: "এক দিন",
                dd: "%d দিন",
                M: "এক মাস",
                MM: "%d মাস",
                y: "এক বছর",
                yy: "%d বছর"
            },
            preparse: function(e) {
                return e.replace(/[১২৩৪৫৬৭৮৯০]/g, function(e) {
                    return n[e];
                });
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                });
            },
            meridiemParse: /রাত|সকাল|দুপুর|বিকেল|রাত/,
            isPM: function(e) {
                return /^(দুপুর|বিকেল|রাত)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "রাত" : e < 10 ? "সকাল" : e < 17 ? "দুপুর" : e < 20 ? "বিকেল" : "রাত";
            },
            week: {
                dow: 0,
                doy: 6
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : tibetan (bo)
    //! author : Thupten N. Chakrishar : https://github.com/vajradog
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "༡",
            "2": "༢",
            "3": "༣",
            "4": "༤",
            "5": "༥",
            "6": "༦",
            "7": "༧",
            "8": "༨",
            "9": "༩",
            "0": "༠"
        }, n = {
            "༡": "1",
            "༢": "2",
            "༣": "3",
            "༤": "4",
            "༥": "5",
            "༦": "6",
            "༧": "7",
            "༨": "8",
            "༩": "9",
            "༠": "0"
        }, a = e.defineLocale("bo", {
            months: "ཟླ་བ་དང་པོ_ཟླ་བ་གཉིས་པ_ཟླ་བ་གསུམ་པ_ཟླ་བ་བཞི་པ_ཟླ་བ་ལྔ་པ_ཟླ་བ་དྲུག་པ_ཟླ་བ་བདུན་པ_ཟླ་བ་བརྒྱད་པ_ཟླ་བ་དགུ་པ_ཟླ་བ་བཅུ་པ_ཟླ་བ་བཅུ་གཅིག་པ_ཟླ་བ་བཅུ་གཉིས་པ".split("_"),
            monthsShort: "ཟླ་བ་དང་པོ_ཟླ་བ་གཉིས་པ_ཟླ་བ་གསུམ་པ_ཟླ་བ་བཞི་པ_ཟླ་བ་ལྔ་པ_ཟླ་བ་དྲུག་པ_ཟླ་བ་བདུན་པ_ཟླ་བ་བརྒྱད་པ_ཟླ་བ་དགུ་པ_ཟླ་བ་བཅུ་པ_ཟླ་བ་བཅུ་གཅིག་པ_ཟླ་བ་བཅུ་གཉིས་པ".split("_"),
            weekdays: "གཟའ་ཉི་མ་_གཟའ་ཟླ་བ་_གཟའ་མིག་དམར་_གཟའ་ལྷག་པ་_གཟའ་ཕུར་བུ_གཟའ་པ་སངས་_གཟའ་སྤེན་པ་".split("_"),
            weekdaysShort: "ཉི་མ་_ཟླ་བ་_མིག་དམར་_ལྷག་པ་_ཕུར་བུ_པ་སངས་_སྤེན་པ་".split("_"),
            weekdaysMin: "ཉི་མ་_ཟླ་བ་_མིག་དམར་_ལྷག་པ་_ཕུར་བུ_པ་སངས་_སྤེན་པ་".split("_"),
            longDateFormat: {
                LT: "A h:mm",
                LTS: "A h:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, A h:mm",
                LLLL: "dddd, D MMMM YYYY, A h:mm"
            },
            calendar: {
                sameDay: "[དི་རིང] LT",
                nextDay: "[སང་ཉིན] LT",
                nextWeek: "[བདུན་ཕྲག་རྗེས་མ], LT",
                lastDay: "[ཁ་སང] LT",
                lastWeek: "[བདུན་ཕྲག་མཐའ་མ] dddd, LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s ལ་",
                past: "%s སྔན་ལ",
                s: "ལམ་སང",
                m: "སྐར་མ་གཅིག",
                mm: "%d སྐར་མ",
                h: "ཆུ་ཚོད་གཅིག",
                hh: "%d ཆུ་ཚོད",
                d: "ཉིན་གཅིག",
                dd: "%d ཉིན་",
                M: "ཟླ་བ་གཅིག",
                MM: "%d ཟླ་བ",
                y: "ལོ་གཅིག",
                yy: "%d ལོ"
            },
            preparse: function(e) {
                return e.replace(/[༡༢༣༤༥༦༧༨༩༠]/g, function(e) {
                    return n[e];
                });
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                });
            },
            meridiemParse: /མཚན་མོ|ཞོགས་ཀས|ཉིན་གུང|དགོང་དག|མཚན་མོ/,
            isPM: function(e) {
                return /^(ཉིན་གུང|དགོང་དག|མཚན་མོ)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "མཚན་མོ" : e < 10 ? "ཞོགས་ཀས" : e < 17 ? "ཉིན་གུང" : e < 20 ? "དགོང་དག" : "མཚན་མོ";
            },
            week: {
                dow: 0,
                doy: 6
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : breton (br)
    //! author : Jean-Baptiste Le Duigou : https://github.com/jbleduigou
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n) {
            var a = {
                mm: "munutenn",
                MM: "miz",
                dd: "devezh"
            };
            return e + " " + r(a[n], e);
        }
        function n(e) {
            switch (a(e)) {
              case 1:
              case 3:
              case 4:
              case 5:
              case 9:
                return e + " bloaz";

              default:
                return e + " vloaz";
            }
        }
        function a(e) {
            return e > 9 ? a(e % 10) : e;
        }
        function r(e, t) {
            return 2 === t ? i(e) : e;
        }
        function i(e) {
            var t = {
                m: "v",
                b: "v",
                d: "z"
            };
            return void 0 === t[e.charAt(0)] ? e : t[e.charAt(0)] + e.substring(1);
        }
        var s = e.defineLocale("br", {
            months: "Genver_C'hwevrer_Meurzh_Ebrel_Mae_Mezheven_Gouere_Eost_Gwengolo_Here_Du_Kerzu".split("_"),
            monthsShort: "Gen_C'hwe_Meu_Ebr_Mae_Eve_Gou_Eos_Gwe_Her_Du_Ker".split("_"),
            weekdays: "Sul_Lun_Meurzh_Merc'her_Yaou_Gwener_Sadorn".split("_"),
            weekdaysShort: "Sul_Lun_Meu_Mer_Yao_Gwe_Sad".split("_"),
            weekdaysMin: "Su_Lu_Me_Mer_Ya_Gw_Sa".split("_"),
            longDateFormat: {
                LT: "h[e]mm A",
                LTS: "h[e]mm:ss A",
                L: "DD/MM/YYYY",
                LL: "D [a viz] MMMM YYYY",
                LLL: "D [a viz] MMMM YYYY h[e]mm A",
                LLLL: "dddd, D [a viz] MMMM YYYY h[e]mm A"
            },
            calendar: {
                sameDay: "[Hiziv da] LT",
                nextDay: "[Warc'hoazh da] LT",
                nextWeek: "dddd [da] LT",
                lastDay: "[Dec'h da] LT",
                lastWeek: "dddd [paset da] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "a-benn %s",
                past: "%s 'zo",
                s: "un nebeud segondennoù",
                m: "ur vunutenn",
                mm: t,
                h: "un eur",
                hh: "%d eur",
                d: "un devezh",
                dd: t,
                M: "ur miz",
                MM: t,
                y: "ur bloaz",
                yy: n
            },
            ordinalParse: /\d{1,2}(añ|vet)/,
            ordinal: function(e) {
                var t = 1 === e ? "añ" : "vet";
                return e + t;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return s;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : bosnian (bs)
    //! author : Nedim Cholich : https://github.com/frontyard
    //! based on (hr) translation by Bojan Marković
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n) {
            var a = e + " ";
            switch (n) {
              case "m":
                return t ? "jedna minuta" : "jedne minute";

              case "mm":
                return a += 1 === e ? "minuta" : 2 === e || 3 === e || 4 === e ? "minute" : "minuta";

              case "h":
                return t ? "jedan sat" : "jednog sata";

              case "hh":
                return a += 1 === e ? "sat" : 2 === e || 3 === e || 4 === e ? "sata" : "sati";

              case "dd":
                return a += 1 === e ? "dan" : "dana";

              case "MM":
                return a += 1 === e ? "mjesec" : 2 === e || 3 === e || 4 === e ? "mjeseca" : "mjeseci";

              case "yy":
                return a += 1 === e ? "godina" : 2 === e || 3 === e || 4 === e ? "godine" : "godina";
            }
        }
        var n = e.defineLocale("bs", {
            months: "januar_februar_mart_april_maj_juni_juli_august_septembar_oktobar_novembar_decembar".split("_"),
            monthsShort: "jan._feb._mar._apr._maj._jun._jul._aug._sep._okt._nov._dec.".split("_"),
            weekdays: "nedjelja_ponedjeljak_utorak_srijeda_četvrtak_petak_subota".split("_"),
            weekdaysShort: "ned._pon._uto._sri._čet._pet._sub.".split("_"),
            weekdaysMin: "ne_po_ut_sr_če_pe_su".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD. MM. YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[danas u] LT",
                nextDay: "[sutra u] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[u] [nedjelju] [u] LT";

                      case 3:
                        return "[u] [srijedu] [u] LT";

                      case 6:
                        return "[u] [subotu] [u] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[u] dddd [u] LT";
                    }
                },
                lastDay: "[jučer u] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                      case 3:
                        return "[prošlu] dddd [u] LT";

                      case 6:
                        return "[prošle] [subote] [u] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[prošli] dddd [u] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "prije %s",
                s: "par sekundi",
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: "dan",
                dd: t,
                M: "mjesec",
                MM: t,
                y: "godinu",
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : catalan (ca)
    //! author : Juan G. Hurtado : https://github.com/juanghurtado
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ca", {
            months: "gener_febrer_març_abril_maig_juny_juliol_agost_setembre_octubre_novembre_desembre".split("_"),
            monthsShort: "gen._febr._mar._abr._mai._jun._jul._ag._set._oct._nov._des.".split("_"),
            weekdays: "diumenge_dilluns_dimarts_dimecres_dijous_divendres_dissabte".split("_"),
            weekdaysShort: "dg._dl._dt._dc._dj._dv._ds.".split("_"),
            weekdaysMin: "Dg_Dl_Dt_Dc_Dj_Dv_Ds".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "LT:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY H:mm",
                LLLL: "dddd D MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: function() {
                    return "[avui a " + (1 !== this.hours() ? "les" : "la") + "] LT";
                },
                nextDay: function() {
                    return "[demà a " + (1 !== this.hours() ? "les" : "la") + "] LT";
                },
                nextWeek: function() {
                    return "dddd [a " + (1 !== this.hours() ? "les" : "la") + "] LT";
                },
                lastDay: function() {
                    return "[ahir a " + (1 !== this.hours() ? "les" : "la") + "] LT";
                },
                lastWeek: function() {
                    return "[el] dddd [passat a " + (1 !== this.hours() ? "les" : "la") + "] LT";
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "en %s",
                past: "fa %s",
                s: "uns segons",
                m: "un minut",
                mm: "%d minuts",
                h: "una hora",
                hh: "%d hores",
                d: "un dia",
                dd: "%d dies",
                M: "un mes",
                MM: "%d mesos",
                y: "un any",
                yy: "%d anys"
            },
            ordinalParse: /\d{1,2}(r|n|t|è|a)/,
            ordinal: function(e, t) {
                var n = 1 === e ? "r" : 2 === e ? "n" : 3 === e ? "r" : 4 === e ? "t" : "è";
                return "w" !== t && "W" !== t || (n = "a"), e + n;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : czech (cs)
    //! author : petrbela : https://github.com/petrbela
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e) {
            return e > 1 && e < 5 && 1 !== ~~(e / 10);
        }
        function n(e, n, a, r) {
            var i = e + " ";
            switch (a) {
              case "s":
                return n || r ? "pár sekund" : "pár sekundami";

              case "m":
                return n ? "minuta" : r ? "minutu" : "minutou";

              case "mm":
                return n || r ? i + (t(e) ? "minuty" : "minut") : i + "minutami";

              case "h":
                return n ? "hodina" : r ? "hodinu" : "hodinou";

              case "hh":
                return n || r ? i + (t(e) ? "hodiny" : "hodin") : i + "hodinami";

              case "d":
                return n || r ? "den" : "dnem";

              case "dd":
                return n || r ? i + (t(e) ? "dny" : "dní") : i + "dny";

              case "M":
                return n || r ? "měsíc" : "měsícem";

              case "MM":
                return n || r ? i + (t(e) ? "měsíce" : "měsíců") : i + "měsíci";

              case "y":
                return n || r ? "rok" : "rokem";

              case "yy":
                return n || r ? i + (t(e) ? "roky" : "let") : i + "lety";
            }
        }
        var a = "leden_únor_březen_duben_květen_červen_červenec_srpen_září_říjen_listopad_prosinec".split("_"), r = "led_úno_bře_dub_kvě_čvn_čvc_srp_zář_říj_lis_pro".split("_"), i = e.defineLocale("cs", {
            months: a,
            monthsShort: r,
            monthsParse: function(e, t) {
                var n, a = [];
                for (n = 0; n < 12; n++) a[n] = new RegExp("^" + e[n] + "$|^" + t[n] + "$", "i");
                return a;
            }(a, r),
            weekdays: "neděle_pondělí_úterý_středa_čtvrtek_pátek_sobota".split("_"),
            weekdaysShort: "ne_po_út_st_čt_pá_so".split("_"),
            weekdaysMin: "ne_po_út_st_čt_pá_so".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[dnes v] LT",
                nextDay: "[zítra v] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[v neděli v] LT";

                      case 1:
                      case 2:
                        return "[v] dddd [v] LT";

                      case 3:
                        return "[ve středu v] LT";

                      case 4:
                        return "[ve čtvrtek v] LT";

                      case 5:
                        return "[v pátek v] LT";

                      case 6:
                        return "[v sobotu v] LT";
                    }
                },
                lastDay: "[včera v] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[minulou neděli v] LT";

                      case 1:
                      case 2:
                        return "[minulé] dddd [v] LT";

                      case 3:
                        return "[minulou středu v] LT";

                      case 4:
                      case 5:
                        return "[minulý] dddd [v] LT";

                      case 6:
                        return "[minulou sobotu v] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "před %s",
                s: n,
                m: n,
                mm: n,
                h: n,
                hh: n,
                d: n,
                dd: n,
                M: n,
                MM: n,
                y: n,
                yy: n
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return i;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : chuvash (cv)
    //! author : Anatoly Mironov : https://github.com/mirontoli
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("cv", {
            months: "кӑрлач_нарӑс_пуш_ака_май_ҫӗртме_утӑ_ҫурла_авӑн_юпа_чӳк_раштав".split("_"),
            monthsShort: "кӑр_нар_пуш_ака_май_ҫӗр_утӑ_ҫур_авн_юпа_чӳк_раш".split("_"),
            weekdays: "вырсарникун_тунтикун_ытларикун_юнкун_кӗҫнерникун_эрнекун_шӑматкун".split("_"),
            weekdaysShort: "выр_тун_ытл_юн_кӗҫ_эрн_шӑм".split("_"),
            weekdaysMin: "вр_тн_ыт_юн_кҫ_эр_шм".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD-MM-YYYY",
                LL: "YYYY [ҫулхи] MMMM [уйӑхӗн] D[-мӗшӗ]",
                LLL: "YYYY [ҫулхи] MMMM [уйӑхӗн] D[-мӗшӗ], HH:mm",
                LLLL: "dddd, YYYY [ҫулхи] MMMM [уйӑхӗн] D[-мӗшӗ], HH:mm"
            },
            calendar: {
                sameDay: "[Паян] LT [сехетре]",
                nextDay: "[Ыран] LT [сехетре]",
                lastDay: "[Ӗнер] LT [сехетре]",
                nextWeek: "[Ҫитес] dddd LT [сехетре]",
                lastWeek: "[Иртнӗ] dddd LT [сехетре]",
                sameElse: "L"
            },
            relativeTime: {
                future: function(e) {
                    var t = /сехет$/i.exec(e) ? "рен" : /ҫул$/i.exec(e) ? "тан" : "ран";
                    return e + t;
                },
                past: "%s каялла",
                s: "пӗр-ик ҫеккунт",
                m: "пӗр минут",
                mm: "%d минут",
                h: "пӗр сехет",
                hh: "%d сехет",
                d: "пӗр кун",
                dd: "%d кун",
                M: "пӗр уйӑх",
                MM: "%d уйӑх",
                y: "пӗр ҫул",
                yy: "%d ҫул"
            },
            ordinalParse: /\d{1,2}-мӗш/,
            ordinal: "%d-мӗш",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Welsh (cy)
    //! author : Robert Allen
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("cy", {
            months: "Ionawr_Chwefror_Mawrth_Ebrill_Mai_Mehefin_Gorffennaf_Awst_Medi_Hydref_Tachwedd_Rhagfyr".split("_"),
            monthsShort: "Ion_Chwe_Maw_Ebr_Mai_Meh_Gor_Aws_Med_Hyd_Tach_Rhag".split("_"),
            weekdays: "Dydd Sul_Dydd Llun_Dydd Mawrth_Dydd Mercher_Dydd Iau_Dydd Gwener_Dydd Sadwrn".split("_"),
            weekdaysShort: "Sul_Llun_Maw_Mer_Iau_Gwe_Sad".split("_"),
            weekdaysMin: "Su_Ll_Ma_Me_Ia_Gw_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Heddiw am] LT",
                nextDay: "[Yfory am] LT",
                nextWeek: "dddd [am] LT",
                lastDay: "[Ddoe am] LT",
                lastWeek: "dddd [diwethaf am] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "mewn %s",
                past: "%s yn ôl",
                s: "ychydig eiliadau",
                m: "munud",
                mm: "%d munud",
                h: "awr",
                hh: "%d awr",
                d: "diwrnod",
                dd: "%d diwrnod",
                M: "mis",
                MM: "%d mis",
                y: "blwyddyn",
                yy: "%d flynedd"
            },
            ordinalParse: /\d{1,2}(fed|ain|af|il|ydd|ed|eg)/,
            ordinal: function(e) {
                var t = e, n = "", a = [ "", "af", "il", "ydd", "ydd", "ed", "ed", "ed", "fed", "fed", "fed", "eg", "fed", "eg", "eg", "fed", "eg", "eg", "fed", "eg", "fed" ];
                return t > 20 ? n = 40 === t || 50 === t || 60 === t || 80 === t || 100 === t ? "fed" : "ain" : t > 0 && (n = a[t]), 
                e + n;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : danish (da)
    //! author : Ulrik Nielsen : https://github.com/mrbase
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("da", {
            months: "januar_februar_marts_april_maj_juni_juli_august_september_oktober_november_december".split("_"),
            monthsShort: "jan_feb_mar_apr_maj_jun_jul_aug_sep_okt_nov_dec".split("_"),
            weekdays: "søndag_mandag_tirsdag_onsdag_torsdag_fredag_lørdag".split("_"),
            weekdaysShort: "søn_man_tir_ons_tor_fre_lør".split("_"),
            weekdaysMin: "sø_ma_ti_on_to_fr_lø".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY HH:mm",
                LLLL: "dddd [d.] D. MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[I dag kl.] LT",
                nextDay: "[I morgen kl.] LT",
                nextWeek: "dddd [kl.] LT",
                lastDay: "[I går kl.] LT",
                lastWeek: "[sidste] dddd [kl] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "om %s",
                past: "%s siden",
                s: "få sekunder",
                m: "et minut",
                mm: "%d minutter",
                h: "en time",
                hh: "%d timer",
                d: "en dag",
                dd: "%d dage",
                M: "en måned",
                MM: "%d måneder",
                y: "et år",
                yy: "%d år"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : german (de)
    //! author : lluchs : https://github.com/lluchs
    //! author: Menelion Elensúle: https://github.com/Oire
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var r = {
                m: [ "eine Minute", "einer Minute" ],
                h: [ "eine Stunde", "einer Stunde" ],
                d: [ "ein Tag", "einem Tag" ],
                dd: [ e + " Tage", e + " Tagen" ],
                M: [ "ein Monat", "einem Monat" ],
                MM: [ e + " Monate", e + " Monaten" ],
                y: [ "ein Jahr", "einem Jahr" ],
                yy: [ e + " Jahre", e + " Jahren" ]
            };
            return t ? r[n][0] : r[n][1];
        }
        var n = e.defineLocale("de", {
            months: "Januar_Februar_März_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),
            monthsShort: "Jan._Febr._Mrz._Apr._Mai_Jun._Jul._Aug._Sept._Okt._Nov._Dez.".split("_"),
            weekdays: "Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag".split("_"),
            weekdaysShort: "So._Mo._Di._Mi._Do._Fr._Sa.".split("_"),
            weekdaysMin: "So_Mo_Di_Mi_Do_Fr_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY HH:mm",
                LLLL: "dddd, D. MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Heute um] LT [Uhr]",
                sameElse: "L",
                nextDay: "[Morgen um] LT [Uhr]",
                nextWeek: "dddd [um] LT [Uhr]",
                lastDay: "[Gestern um] LT [Uhr]",
                lastWeek: "[letzten] dddd [um] LT [Uhr]"
            },
            relativeTime: {
                future: "in %s",
                past: "vor %s",
                s: "ein paar Sekunden",
                m: t,
                mm: "%d Minuten",
                h: t,
                hh: "%d Stunden",
                d: t,
                dd: t,
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : austrian german (de-at)
    //! author : lluchs : https://github.com/lluchs
    //! author: Menelion Elensúle: https://github.com/Oire
    //! author : Martin Groller : https://github.com/MadMG
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var r = {
                m: [ "eine Minute", "einer Minute" ],
                h: [ "eine Stunde", "einer Stunde" ],
                d: [ "ein Tag", "einem Tag" ],
                dd: [ e + " Tage", e + " Tagen" ],
                M: [ "ein Monat", "einem Monat" ],
                MM: [ e + " Monate", e + " Monaten" ],
                y: [ "ein Jahr", "einem Jahr" ],
                yy: [ e + " Jahre", e + " Jahren" ]
            };
            return t ? r[n][0] : r[n][1];
        }
        var n = e.defineLocale("de-at", {
            months: "Jänner_Februar_März_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),
            monthsShort: "Jän._Febr._Mrz._Apr._Mai_Jun._Jul._Aug._Sept._Okt._Nov._Dez.".split("_"),
            weekdays: "Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag".split("_"),
            weekdaysShort: "So._Mo._Di._Mi._Do._Fr._Sa.".split("_"),
            weekdaysMin: "So_Mo_Di_Mi_Do_Fr_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY HH:mm",
                LLLL: "dddd, D. MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Heute um] LT [Uhr]",
                sameElse: "L",
                nextDay: "[Morgen um] LT [Uhr]",
                nextWeek: "dddd [um] LT [Uhr]",
                lastDay: "[Gestern um] LT [Uhr]",
                lastWeek: "[letzten] dddd [um] LT [Uhr]"
            },
            relativeTime: {
                future: "in %s",
                past: "vor %s",
                s: "ein paar Sekunden",
                m: t,
                mm: "%d Minuten",
                h: t,
                hh: "%d Stunden",
                d: t,
                dd: t,
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : modern greek (el)
    //! author : Aggelos Karalias : https://github.com/mehiel
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("el", {
            monthsNominativeEl: "Ιανουάριος_Φεβρουάριος_Μάρτιος_Απρίλιος_Μάιος_Ιούνιος_Ιούλιος_Αύγουστος_Σεπτέμβριος_Οκτώβριος_Νοέμβριος_Δεκέμβριος".split("_"),
            monthsGenitiveEl: "Ιανουαρίου_Φεβρουαρίου_Μαρτίου_Απριλίου_Μαΐου_Ιουνίου_Ιουλίου_Αυγούστου_Σεπτεμβρίου_Οκτωβρίου_Νοεμβρίου_Δεκεμβρίου".split("_"),
            months: function(e, t) {
                return /D/.test(t.substring(0, t.indexOf("MMMM"))) ? this._monthsGenitiveEl[e.month()] : this._monthsNominativeEl[e.month()];
            },
            monthsShort: "Ιαν_Φεβ_Μαρ_Απρ_Μαϊ_Ιουν_Ιουλ_Αυγ_Σεπ_Οκτ_Νοε_Δεκ".split("_"),
            weekdays: "Κυριακή_Δευτέρα_Τρίτη_Τετάρτη_Πέμπτη_Παρασκευή_Σάββατο".split("_"),
            weekdaysShort: "Κυρ_Δευ_Τρι_Τετ_Πεμ_Παρ_Σαβ".split("_"),
            weekdaysMin: "Κυ_Δε_Τρ_Τε_Πε_Πα_Σα".split("_"),
            meridiem: function(e, t, n) {
                return e > 11 ? n ? "μμ" : "ΜΜ" : n ? "πμ" : "ΠΜ";
            },
            isPM: function(e) {
                return "μ" === (e + "").toLowerCase()[0];
            },
            meridiemParse: /[ΠΜ]\.?Μ?\.?/i,
            longDateFormat: {
                LT: "h:mm A",
                LTS: "h:mm:ss A",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY h:mm A",
                LLLL: "dddd, D MMMM YYYY h:mm A"
            },
            calendarEl: {
                sameDay: "[Σήμερα {}] LT",
                nextDay: "[Αύριο {}] LT",
                nextWeek: "dddd [{}] LT",
                lastDay: "[Χθες {}] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 6:
                        return "[το προηγούμενο] dddd [{}] LT";

                      default:
                        return "[την προηγούμενη] dddd [{}] LT";
                    }
                },
                sameElse: "L"
            },
            calendar: function(e, t) {
                var n = this._calendarEl[e], a = t && t.hours();
                return "function" == typeof n && (n = n.apply(t)), n.replace("{}", a % 12 === 1 ? "στη" : "στις");
            },
            relativeTime: {
                future: "σε %s",
                past: "%s πριν",
                s: "λίγα δευτερόλεπτα",
                m: "ένα λεπτό",
                mm: "%d λεπτά",
                h: "μία ώρα",
                hh: "%d ώρες",
                d: "μία μέρα",
                dd: "%d μέρες",
                M: "ένας μήνας",
                MM: "%d μήνες",
                y: "ένας χρόνος",
                yy: "%d χρόνια"
            },
            ordinalParse: /\d{1,2}η/,
            ordinal: "%dη",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : australian english (en-au)
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("en-au", {
            months: "January_February_March_April_May_June_July_August_September_October_November_December".split("_"),
            monthsShort: "Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),
            weekdays: "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),
            weekdaysShort: "Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),
            weekdaysMin: "Su_Mo_Tu_We_Th_Fr_Sa".split("_"),
            longDateFormat: {
                LT: "h:mm A",
                LTS: "h:mm:ss A",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY h:mm A",
                LLLL: "dddd, D MMMM YYYY h:mm A"
            },
            calendar: {
                sameDay: "[Today at] LT",
                nextDay: "[Tomorrow at] LT",
                nextWeek: "dddd [at] LT",
                lastDay: "[Yesterday at] LT",
                lastWeek: "[Last] dddd [at] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "in %s",
                past: "%s ago",
                s: "a few seconds",
                m: "a minute",
                mm: "%d minutes",
                h: "an hour",
                hh: "%d hours",
                d: "a day",
                dd: "%d days",
                M: "a month",
                MM: "%d months",
                y: "a year",
                yy: "%d years"
            },
            ordinalParse: /\d{1,2}(st|nd|rd|th)/,
            ordinal: function(e) {
                var t = e % 10, n = 1 === ~~(e % 100 / 10) ? "th" : 1 === t ? "st" : 2 === t ? "nd" : 3 === t ? "rd" : "th";
                return e + n;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : canadian english (en-ca)
    //! author : Jonathan Abourbih : https://github.com/jonbca
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("en-ca", {
            months: "January_February_March_April_May_June_July_August_September_October_November_December".split("_"),
            monthsShort: "Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),
            weekdays: "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),
            weekdaysShort: "Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),
            weekdaysMin: "Su_Mo_Tu_We_Th_Fr_Sa".split("_"),
            longDateFormat: {
                LT: "h:mm A",
                LTS: "h:mm:ss A",
                L: "YYYY-MM-DD",
                LL: "D MMMM, YYYY",
                LLL: "D MMMM, YYYY h:mm A",
                LLLL: "dddd, D MMMM, YYYY h:mm A"
            },
            calendar: {
                sameDay: "[Today at] LT",
                nextDay: "[Tomorrow at] LT",
                nextWeek: "dddd [at] LT",
                lastDay: "[Yesterday at] LT",
                lastWeek: "[Last] dddd [at] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "in %s",
                past: "%s ago",
                s: "a few seconds",
                m: "a minute",
                mm: "%d minutes",
                h: "an hour",
                hh: "%d hours",
                d: "a day",
                dd: "%d days",
                M: "a month",
                MM: "%d months",
                y: "a year",
                yy: "%d years"
            },
            ordinalParse: /\d{1,2}(st|nd|rd|th)/,
            ordinal: function(e) {
                var t = e % 10, n = 1 === ~~(e % 100 / 10) ? "th" : 1 === t ? "st" : 2 === t ? "nd" : 3 === t ? "rd" : "th";
                return e + n;
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : great britain english (en-gb)
    //! author : Chris Gedrim : https://github.com/chrisgedrim
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("en-gb", {
            months: "January_February_March_April_May_June_July_August_September_October_November_December".split("_"),
            monthsShort: "Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),
            weekdays: "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),
            weekdaysShort: "Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),
            weekdaysMin: "Su_Mo_Tu_We_Th_Fr_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Today at] LT",
                nextDay: "[Tomorrow at] LT",
                nextWeek: "dddd [at] LT",
                lastDay: "[Yesterday at] LT",
                lastWeek: "[Last] dddd [at] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "in %s",
                past: "%s ago",
                s: "a few seconds",
                m: "a minute",
                mm: "%d minutes",
                h: "an hour",
                hh: "%d hours",
                d: "a day",
                dd: "%d days",
                M: "a month",
                MM: "%d months",
                y: "a year",
                yy: "%d years"
            },
            ordinalParse: /\d{1,2}(st|nd|rd|th)/,
            ordinal: function(e) {
                var t = e % 10, n = 1 === ~~(e % 100 / 10) ? "th" : 1 === t ? "st" : 2 === t ? "nd" : 3 === t ? "rd" : "th";
                return e + n;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : esperanto (eo)
    //! author : Colin Dean : https://github.com/colindean
    //! komento: Mi estas malcerta se mi korekte traktis akuzativojn en tiu traduko.
    //!          Se ne, bonvolu korekti kaj avizi min por ke mi povas lerni!
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("eo", {
            months: "januaro_februaro_marto_aprilo_majo_junio_julio_aŭgusto_septembro_oktobro_novembro_decembro".split("_"),
            monthsShort: "jan_feb_mar_apr_maj_jun_jul_aŭg_sep_okt_nov_dec".split("_"),
            weekdays: "Dimanĉo_Lundo_Mardo_Merkredo_Ĵaŭdo_Vendredo_Sabato".split("_"),
            weekdaysShort: "Dim_Lun_Mard_Merk_Ĵaŭ_Ven_Sab".split("_"),
            weekdaysMin: "Di_Lu_Ma_Me_Ĵa_Ve_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "YYYY-MM-DD",
                LL: "D[-an de] MMMM, YYYY",
                LLL: "D[-an de] MMMM, YYYY HH:mm",
                LLLL: "dddd, [la] D[-an de] MMMM, YYYY HH:mm"
            },
            meridiemParse: /[ap]\.t\.m/i,
            isPM: function(e) {
                return "p" === e.charAt(0).toLowerCase();
            },
            meridiem: function(e, t, n) {
                return e > 11 ? n ? "p.t.m." : "P.T.M." : n ? "a.t.m." : "A.T.M.";
            },
            calendar: {
                sameDay: "[Hodiaŭ je] LT",
                nextDay: "[Morgaŭ je] LT",
                nextWeek: "dddd [je] LT",
                lastDay: "[Hieraŭ je] LT",
                lastWeek: "[pasinta] dddd [je] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "je %s",
                past: "antaŭ %s",
                s: "sekundoj",
                m: "minuto",
                mm: "%d minutoj",
                h: "horo",
                hh: "%d horoj",
                d: "tago",
                dd: "%d tagoj",
                M: "monato",
                MM: "%d monatoj",
                y: "jaro",
                yy: "%d jaroj"
            },
            ordinalParse: /\d{1,2}a/,
            ordinal: "%da",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : spanish (es)
    //! author : Julio Napurí : https://github.com/julionc
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = "Ene._Feb._Mar._Abr._May._Jun._Jul._Ago._Sep._Oct._Nov._Dic.".split("_"), n = "Ene_Feb_Mar_Abr_May_Jun_Jul_Ago_Sep_Oct_Nov_Dic".split("_"), a = e.defineLocale("es", {
            months: "Enero_Febrero_Marzo_Abril_Mayo_Junio_Julio_Agosto_Septiembre_Octubre_Noviembre_Diciembre".split("_"),
            monthsShort: function(e, a) {
                return /-MMM-/.test(a) ? n[e.month()] : t[e.month()];
            },
            weekdays: "Domingo_Lunes_Martes_Miércoles_Jueves_Viernes_Sábado".split("_"),
            weekdaysShort: "Dom._Lun._Mar._Mié._Jue._Vie._Sáb.".split("_"),
            weekdaysMin: "Do_Lu_Ma_Mi_Ju_Vi_Sá".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D [de] MMMM [de] YYYY",
                LLL: "D [de] MMMM [de] YYYY H:mm",
                LLLL: "dddd, D [de] MMMM [de] YYYY H:mm"
            },
            calendar: {
                sameDay: function() {
                    return "[hoy a la" + (1 !== this.hours() ? "s" : "") + "] LT";
                },
                nextDay: function() {
                    return "[mañana a la" + (1 !== this.hours() ? "s" : "") + "] LT";
                },
                nextWeek: function() {
                    return "dddd [a la" + (1 !== this.hours() ? "s" : "") + "] LT";
                },
                lastDay: function() {
                    return "[ayer a la" + (1 !== this.hours() ? "s" : "") + "] LT";
                },
                lastWeek: function() {
                    return "[el] dddd [pasado a la" + (1 !== this.hours() ? "s" : "") + "] LT";
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "en %s",
                past: "hace %s",
                s: "unos segundos",
                m: "un minuto",
                mm: "%d minutos",
                h: "una hora",
                hh: "%d horas",
                d: "un día",
                dd: "%d días",
                M: "un mes",
                MM: "%d meses",
                y: "un año",
                yy: "%d años"
            },
            ordinalParse: /\d{1,2}º/,
            ordinal: "%dº",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : estonian (et)
    //! author : Henry Kehlmann : https://github.com/madhenry
    //! improvements : Illimar Tambek : https://github.com/ragulka
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var r = {
                s: [ "mõne sekundi", "mõni sekund", "paar sekundit" ],
                m: [ "ühe minuti", "üks minut" ],
                mm: [ e + " minuti", e + " minutit" ],
                h: [ "ühe tunni", "tund aega", "üks tund" ],
                hh: [ e + " tunni", e + " tundi" ],
                d: [ "ühe päeva", "üks päev" ],
                M: [ "kuu aja", "kuu aega", "üks kuu" ],
                MM: [ e + " kuu", e + " kuud" ],
                y: [ "ühe aasta", "aasta", "üks aasta" ],
                yy: [ e + " aasta", e + " aastat" ]
            };
            return t ? r[n][2] ? r[n][2] : r[n][1] : a ? r[n][0] : r[n][1];
        }
        var n = e.defineLocale("et", {
            months: "jaanuar_veebruar_märts_aprill_mai_juuni_juuli_august_september_oktoober_november_detsember".split("_"),
            monthsShort: "jaan_veebr_märts_apr_mai_juuni_juuli_aug_sept_okt_nov_dets".split("_"),
            weekdays: "pühapäev_esmaspäev_teisipäev_kolmapäev_neljapäev_reede_laupäev".split("_"),
            weekdaysShort: "P_E_T_K_N_R_L".split("_"),
            weekdaysMin: "P_E_T_K_N_R_L".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[Täna,] LT",
                nextDay: "[Homme,] LT",
                nextWeek: "[Järgmine] dddd LT",
                lastDay: "[Eile,] LT",
                lastWeek: "[Eelmine] dddd LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s pärast",
                past: "%s tagasi",
                s: t,
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: t,
                dd: "%d päeva",
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : euskara (eu)
    //! author : Eneko Illarramendi : https://github.com/eillarra
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("eu", {
            months: "urtarrila_otsaila_martxoa_apirila_maiatza_ekaina_uztaila_abuztua_iraila_urria_azaroa_abendua".split("_"),
            monthsShort: "urt._ots._mar._api._mai._eka._uzt._abu._ira._urr._aza._abe.".split("_"),
            weekdays: "igandea_astelehena_asteartea_asteazkena_osteguna_ostirala_larunbata".split("_"),
            weekdaysShort: "ig._al._ar._az._og._ol._lr.".split("_"),
            weekdaysMin: "ig_al_ar_az_og_ol_lr".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "YYYY-MM-DD",
                LL: "YYYY[ko] MMMM[ren] D[a]",
                LLL: "YYYY[ko] MMMM[ren] D[a] HH:mm",
                LLLL: "dddd, YYYY[ko] MMMM[ren] D[a] HH:mm",
                l: "YYYY-M-D",
                ll: "YYYY[ko] MMM D[a]",
                lll: "YYYY[ko] MMM D[a] HH:mm",
                llll: "ddd, YYYY[ko] MMM D[a] HH:mm"
            },
            calendar: {
                sameDay: "[gaur] LT[etan]",
                nextDay: "[bihar] LT[etan]",
                nextWeek: "dddd LT[etan]",
                lastDay: "[atzo] LT[etan]",
                lastWeek: "[aurreko] dddd LT[etan]",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s barru",
                past: "duela %s",
                s: "segundo batzuk",
                m: "minutu bat",
                mm: "%d minutu",
                h: "ordu bat",
                hh: "%d ordu",
                d: "egun bat",
                dd: "%d egun",
                M: "hilabete bat",
                MM: "%d hilabete",
                y: "urte bat",
                yy: "%d urte"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Persian (fa)
    //! author : Ebrahim Byagowi : https://github.com/ebraminio
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "۱",
            "2": "۲",
            "3": "۳",
            "4": "۴",
            "5": "۵",
            "6": "۶",
            "7": "۷",
            "8": "۸",
            "9": "۹",
            "0": "۰"
        }, n = {
            "۱": "1",
            "۲": "2",
            "۳": "3",
            "۴": "4",
            "۵": "5",
            "۶": "6",
            "۷": "7",
            "۸": "8",
            "۹": "9",
            "۰": "0"
        }, a = e.defineLocale("fa", {
            months: "ژانویه_فوریه_مارس_آوریل_مه_ژوئن_ژوئیه_اوت_سپتامبر_اکتبر_نوامبر_دسامبر".split("_"),
            monthsShort: "ژانویه_فوریه_مارس_آوریل_مه_ژوئن_ژوئیه_اوت_سپتامبر_اکتبر_نوامبر_دسامبر".split("_"),
            weekdays: "یک‌شنبه_دوشنبه_سه‌شنبه_چهارشنبه_پنج‌شنبه_جمعه_شنبه".split("_"),
            weekdaysShort: "یک‌شنبه_دوشنبه_سه‌شنبه_چهارشنبه_پنج‌شنبه_جمعه_شنبه".split("_"),
            weekdaysMin: "ی_د_س_چ_پ_ج_ش".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            meridiemParse: /قبل از ظهر|بعد از ظهر/,
            isPM: function(e) {
                return /بعد از ظهر/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "قبل از ظهر" : "بعد از ظهر";
            },
            calendar: {
                sameDay: "[امروز ساعت] LT",
                nextDay: "[فردا ساعت] LT",
                nextWeek: "dddd [ساعت] LT",
                lastDay: "[دیروز ساعت] LT",
                lastWeek: "dddd [پیش] [ساعت] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "در %s",
                past: "%s پیش",
                s: "چندین ثانیه",
                m: "یک دقیقه",
                mm: "%d دقیقه",
                h: "یک ساعت",
                hh: "%d ساعت",
                d: "یک روز",
                dd: "%d روز",
                M: "یک ماه",
                MM: "%d ماه",
                y: "یک سال",
                yy: "%d سال"
            },
            preparse: function(e) {
                return e.replace(/[۰-۹]/g, function(e) {
                    return n[e];
                }).replace(/،/g, ",");
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                }).replace(/,/g, "،");
            },
            ordinalParse: /\d{1,2}م/,
            ordinal: "%dم",
            week: {
                dow: 6,
                doy: 12
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : finnish (fi)
    //! author : Tarmo Aidantausta : https://github.com/bleadof
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, a, r) {
            var i = "";
            switch (a) {
              case "s":
                return r ? "muutaman sekunnin" : "muutama sekunti";

              case "m":
                return r ? "minuutin" : "minuutti";

              case "mm":
                i = r ? "minuutin" : "minuuttia";
                break;

              case "h":
                return r ? "tunnin" : "tunti";

              case "hh":
                i = r ? "tunnin" : "tuntia";
                break;

              case "d":
                return r ? "päivän" : "päivä";

              case "dd":
                i = r ? "päivän" : "päivää";
                break;

              case "M":
                return r ? "kuukauden" : "kuukausi";

              case "MM":
                i = r ? "kuukauden" : "kuukautta";
                break;

              case "y":
                return r ? "vuoden" : "vuosi";

              case "yy":
                i = r ? "vuoden" : "vuotta";
            }
            return i = n(e, r) + " " + i;
        }
        function n(e, t) {
            return e < 10 ? t ? r[e] : a[e] : e;
        }
        var a = "nolla yksi kaksi kolme neljä viisi kuusi seitsemän kahdeksan yhdeksän".split(" "), r = [ "nolla", "yhden", "kahden", "kolmen", "neljän", "viiden", "kuuden", a[7], a[8], a[9] ], i = e.defineLocale("fi", {
            months: "tammikuu_helmikuu_maaliskuu_huhtikuu_toukokuu_kesäkuu_heinäkuu_elokuu_syyskuu_lokakuu_marraskuu_joulukuu".split("_"),
            monthsShort: "tammi_helmi_maalis_huhti_touko_kesä_heinä_elo_syys_loka_marras_joulu".split("_"),
            weekdays: "sunnuntai_maanantai_tiistai_keskiviikko_torstai_perjantai_lauantai".split("_"),
            weekdaysShort: "su_ma_ti_ke_to_pe_la".split("_"),
            weekdaysMin: "su_ma_ti_ke_to_pe_la".split("_"),
            longDateFormat: {
                LT: "HH.mm",
                LTS: "HH.mm.ss",
                L: "DD.MM.YYYY",
                LL: "Do MMMM[ta] YYYY",
                LLL: "Do MMMM[ta] YYYY, [klo] HH.mm",
                LLLL: "dddd, Do MMMM[ta] YYYY, [klo] HH.mm",
                l: "D.M.YYYY",
                ll: "Do MMM YYYY",
                lll: "Do MMM YYYY, [klo] HH.mm",
                llll: "ddd, Do MMM YYYY, [klo] HH.mm"
            },
            calendar: {
                sameDay: "[tänään] [klo] LT",
                nextDay: "[huomenna] [klo] LT",
                nextWeek: "dddd [klo] LT",
                lastDay: "[eilen] [klo] LT",
                lastWeek: "[viime] dddd[na] [klo] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s päästä",
                past: "%s sitten",
                s: t,
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: t,
                dd: t,
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return i;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : faroese (fo)
    //! author : Ragnar Johannesen : https://github.com/ragnar123
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("fo", {
            months: "januar_februar_mars_apríl_mai_juni_juli_august_september_oktober_november_desember".split("_"),
            monthsShort: "jan_feb_mar_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_"),
            weekdays: "sunnudagur_mánadagur_týsdagur_mikudagur_hósdagur_fríggjadagur_leygardagur".split("_"),
            weekdaysShort: "sun_mán_týs_mik_hós_frí_ley".split("_"),
            weekdaysMin: "su_má_tý_mi_hó_fr_le".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D. MMMM, YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Í dag kl.] LT",
                nextDay: "[Í morgin kl.] LT",
                nextWeek: "dddd [kl.] LT",
                lastDay: "[Í gjár kl.] LT",
                lastWeek: "[síðstu] dddd [kl] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "um %s",
                past: "%s síðani",
                s: "fá sekund",
                m: "ein minutt",
                mm: "%d minuttir",
                h: "ein tími",
                hh: "%d tímar",
                d: "ein dagur",
                dd: "%d dagar",
                M: "ein mánaði",
                MM: "%d mánaðir",
                y: "eitt ár",
                yy: "%d ár"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : french (fr)
    //! author : John Fischer : https://github.com/jfroffice
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("fr", {
            months: "janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre".split("_"),
            monthsShort: "janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.".split("_"),
            weekdays: "dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi".split("_"),
            weekdaysShort: "dim._lun._mar._mer._jeu._ven._sam.".split("_"),
            weekdaysMin: "Di_Lu_Ma_Me_Je_Ve_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Aujourd'hui à] LT",
                nextDay: "[Demain à] LT",
                nextWeek: "dddd [à] LT",
                lastDay: "[Hier à] LT",
                lastWeek: "dddd [dernier à] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "dans %s",
                past: "il y a %s",
                s: "quelques secondes",
                m: "une minute",
                mm: "%d minutes",
                h: "une heure",
                hh: "%d heures",
                d: "un jour",
                dd: "%d jours",
                M: "un mois",
                MM: "%d mois",
                y: "un an",
                yy: "%d ans"
            },
            ordinalParse: /\d{1,2}(er|)/,
            ordinal: function(e) {
                return e + (1 === e ? "er" : "");
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : canadian french (fr-ca)
    //! author : Jonathan Abourbih : https://github.com/jonbca
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("fr-ca", {
            months: "janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre".split("_"),
            monthsShort: "janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.".split("_"),
            weekdays: "dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi".split("_"),
            weekdaysShort: "dim._lun._mar._mer._jeu._ven._sam.".split("_"),
            weekdaysMin: "Di_Lu_Ma_Me_Je_Ve_Sa".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "YYYY-MM-DD",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Aujourd'hui à] LT",
                nextDay: "[Demain à] LT",
                nextWeek: "dddd [à] LT",
                lastDay: "[Hier à] LT",
                lastWeek: "dddd [dernier à] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "dans %s",
                past: "il y a %s",
                s: "quelques secondes",
                m: "une minute",
                mm: "%d minutes",
                h: "une heure",
                hh: "%d heures",
                d: "un jour",
                dd: "%d jours",
                M: "un mois",
                MM: "%d mois",
                y: "un an",
                yy: "%d ans"
            },
            ordinalParse: /\d{1,2}(er|e)/,
            ordinal: function(e) {
                return e + (1 === e ? "er" : "e");
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : frisian (fy)
    //! author : Robin van der Vliet : https://github.com/robin0van0der0v
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = "jan._feb._mrt._apr._mai_jun._jul._aug._sep._okt._nov._des.".split("_"), n = "jan_feb_mrt_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_"), a = e.defineLocale("fy", {
            months: "jannewaris_febrewaris_maart_april_maaie_juny_july_augustus_septimber_oktober_novimber_desimber".split("_"),
            monthsShort: function(e, a) {
                return /-MMM-/.test(a) ? n[e.month()] : t[e.month()];
            },
            weekdays: "snein_moandei_tiisdei_woansdei_tongersdei_freed_sneon".split("_"),
            weekdaysShort: "si._mo._ti._wo._to._fr._so.".split("_"),
            weekdaysMin: "Si_Mo_Ti_Wo_To_Fr_So".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD-MM-YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[hjoed om] LT",
                nextDay: "[moarn om] LT",
                nextWeek: "dddd [om] LT",
                lastDay: "[juster om] LT",
                lastWeek: "[ôfrûne] dddd [om] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "oer %s",
                past: "%s lyn",
                s: "in pear sekonden",
                m: "ien minút",
                mm: "%d minuten",
                h: "ien oere",
                hh: "%d oeren",
                d: "ien dei",
                dd: "%d dagen",
                M: "ien moanne",
                MM: "%d moannen",
                y: "ien jier",
                yy: "%d jierren"
            },
            ordinalParse: /\d{1,2}(ste|de)/,
            ordinal: function(e) {
                return e + (1 === e || 8 === e || e >= 20 ? "ste" : "de");
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : galician (gl)
    //! author : Juan G. Hurtado : https://github.com/juanghurtado
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("gl", {
            months: "Xaneiro_Febreiro_Marzo_Abril_Maio_Xuño_Xullo_Agosto_Setembro_Outubro_Novembro_Decembro".split("_"),
            monthsShort: "Xan._Feb._Mar._Abr._Mai._Xuñ._Xul._Ago._Set._Out._Nov._Dec.".split("_"),
            weekdays: "Domingo_Luns_Martes_Mércores_Xoves_Venres_Sábado".split("_"),
            weekdaysShort: "Dom._Lun._Mar._Mér._Xov._Ven._Sáb.".split("_"),
            weekdaysMin: "Do_Lu_Ma_Mé_Xo_Ve_Sá".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY H:mm",
                LLLL: "dddd D MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: function() {
                    return "[hoxe " + (1 !== this.hours() ? "ás" : "á") + "] LT";
                },
                nextDay: function() {
                    return "[mañá " + (1 !== this.hours() ? "ás" : "á") + "] LT";
                },
                nextWeek: function() {
                    return "dddd [" + (1 !== this.hours() ? "ás" : "a") + "] LT";
                },
                lastDay: function() {
                    return "[onte " + (1 !== this.hours() ? "á" : "a") + "] LT";
                },
                lastWeek: function() {
                    return "[o] dddd [pasado " + (1 !== this.hours() ? "ás" : "a") + "] LT";
                },
                sameElse: "L"
            },
            relativeTime: {
                future: function(e) {
                    return "uns segundos" === e ? "nuns segundos" : "en " + e;
                },
                past: "hai %s",
                s: "uns segundos",
                m: "un minuto",
                mm: "%d minutos",
                h: "unha hora",
                hh: "%d horas",
                d: "un día",
                dd: "%d días",
                M: "un mes",
                MM: "%d meses",
                y: "un ano",
                yy: "%d anos"
            },
            ordinalParse: /\d{1,2}º/,
            ordinal: "%dº",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Hebrew (he)
    //! author : Tomer Cohen : https://github.com/tomer
    //! author : Moshe Simantov : https://github.com/DevelopmentIL
    //! author : Tal Ater : https://github.com/TalAter
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("he", {
            months: "ינואר_פברואר_מרץ_אפריל_מאי_יוני_יולי_אוגוסט_ספטמבר_אוקטובר_נובמבר_דצמבר".split("_"),
            monthsShort: "ינו׳_פבר׳_מרץ_אפר׳_מאי_יוני_יולי_אוג׳_ספט׳_אוק׳_נוב׳_דצמ׳".split("_"),
            weekdays: "ראשון_שני_שלישי_רביעי_חמישי_שישי_שבת".split("_"),
            weekdaysShort: "א׳_ב׳_ג׳_ד׳_ה׳_ו׳_ש׳".split("_"),
            weekdaysMin: "א_ב_ג_ד_ה_ו_ש".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D [ב]MMMM YYYY",
                LLL: "D [ב]MMMM YYYY HH:mm",
                LLLL: "dddd, D [ב]MMMM YYYY HH:mm",
                l: "D/M/YYYY",
                ll: "D MMM YYYY",
                lll: "D MMM YYYY HH:mm",
                llll: "ddd, D MMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[היום ב־]LT",
                nextDay: "[מחר ב־]LT",
                nextWeek: "dddd [בשעה] LT",
                lastDay: "[אתמול ב־]LT",
                lastWeek: "[ביום] dddd [האחרון בשעה] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "בעוד %s",
                past: "לפני %s",
                s: "מספר שניות",
                m: "דקה",
                mm: "%d דקות",
                h: "שעה",
                hh: function(e) {
                    return 2 === e ? "שעתיים" : e + " שעות";
                },
                d: "יום",
                dd: function(e) {
                    return 2 === e ? "יומיים" : e + " ימים";
                },
                M: "חודש",
                MM: function(e) {
                    return 2 === e ? "חודשיים" : e + " חודשים";
                },
                y: "שנה",
                yy: function(e) {
                    return 2 === e ? "שנתיים" : e % 10 === 0 && 10 !== e ? e + " שנה" : e + " שנים";
                }
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : hindi (hi)
    //! author : Mayank Singhal : https://github.com/mayanksinghal
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "१",
            "2": "२",
            "3": "३",
            "4": "४",
            "5": "५",
            "6": "६",
            "7": "७",
            "8": "८",
            "9": "९",
            "0": "०"
        }, n = {
            "१": "1",
            "२": "2",
            "३": "3",
            "४": "4",
            "५": "5",
            "६": "6",
            "७": "7",
            "८": "8",
            "९": "9",
            "०": "0"
        }, a = e.defineLocale("hi", {
            months: "जनवरी_फ़रवरी_मार्च_अप्रैल_मई_जून_जुलाई_अगस्त_सितम्बर_अक्टूबर_नवम्बर_दिसम्बर".split("_"),
            monthsShort: "जन._फ़र._मार्च_अप्रै._मई_जून_जुल._अग._सित._अक्टू._नव._दिस.".split("_"),
            weekdays: "रविवार_सोमवार_मंगलवार_बुधवार_गुरूवार_शुक्रवार_शनिवार".split("_"),
            weekdaysShort: "रवि_सोम_मंगल_बुध_गुरू_शुक्र_शनि".split("_"),
            weekdaysMin: "र_सो_मं_बु_गु_शु_श".split("_"),
            longDateFormat: {
                LT: "A h:mm बजे",
                LTS: "A h:mm:ss बजे",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, A h:mm बजे",
                LLLL: "dddd, D MMMM YYYY, A h:mm बजे"
            },
            calendar: {
                sameDay: "[आज] LT",
                nextDay: "[कल] LT",
                nextWeek: "dddd, LT",
                lastDay: "[कल] LT",
                lastWeek: "[पिछले] dddd, LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s में",
                past: "%s पहले",
                s: "कुछ ही क्षण",
                m: "एक मिनट",
                mm: "%d मिनट",
                h: "एक घंटा",
                hh: "%d घंटे",
                d: "एक दिन",
                dd: "%d दिन",
                M: "एक महीने",
                MM: "%d महीने",
                y: "एक वर्ष",
                yy: "%d वर्ष"
            },
            preparse: function(e) {
                return e.replace(/[१२३४५६७८९०]/g, function(e) {
                    return n[e];
                });
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                });
            },
            meridiemParse: /रात|सुबह|दोपहर|शाम/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "रात" === t ? e < 4 ? e : e + 12 : "सुबह" === t ? e : "दोपहर" === t ? e >= 10 ? e : e + 12 : "शाम" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "रात" : e < 10 ? "सुबह" : e < 17 ? "दोपहर" : e < 20 ? "शाम" : "रात";
            },
            week: {
                dow: 0,
                doy: 6
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : hrvatski (hr)
    //! author : Bojan Marković : https://github.com/bmarkovic
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n) {
            var a = e + " ";
            switch (n) {
              case "m":
                return t ? "jedna minuta" : "jedne minute";

              case "mm":
                return a += 1 === e ? "minuta" : 2 === e || 3 === e || 4 === e ? "minute" : "minuta";

              case "h":
                return t ? "jedan sat" : "jednog sata";

              case "hh":
                return a += 1 === e ? "sat" : 2 === e || 3 === e || 4 === e ? "sata" : "sati";

              case "dd":
                return a += 1 === e ? "dan" : "dana";

              case "MM":
                return a += 1 === e ? "mjesec" : 2 === e || 3 === e || 4 === e ? "mjeseca" : "mjeseci";

              case "yy":
                return a += 1 === e ? "godina" : 2 === e || 3 === e || 4 === e ? "godine" : "godina";
            }
        }
        var n = e.defineLocale("hr", {
            months: "siječanj_veljača_ožujak_travanj_svibanj_lipanj_srpanj_kolovoz_rujan_listopad_studeni_prosinac".split("_"),
            monthsShort: "sij._velj._ožu._tra._svi._lip._srp._kol._ruj._lis._stu._pro.".split("_"),
            weekdays: "nedjelja_ponedjeljak_utorak_srijeda_četvrtak_petak_subota".split("_"),
            weekdaysShort: "ned._pon._uto._sri._čet._pet._sub.".split("_"),
            weekdaysMin: "ne_po_ut_sr_če_pe_su".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD. MM. YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[danas u] LT",
                nextDay: "[sutra u] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[u] [nedjelju] [u] LT";

                      case 3:
                        return "[u] [srijedu] [u] LT";

                      case 6:
                        return "[u] [subotu] [u] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[u] dddd [u] LT";
                    }
                },
                lastDay: "[jučer u] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                      case 3:
                        return "[prošlu] dddd [u] LT";

                      case 6:
                        return "[prošle] [subote] [u] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[prošli] dddd [u] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "prije %s",
                s: "par sekundi",
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: "dan",
                dd: t,
                M: "mjesec",
                MM: t,
                y: "godinu",
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : hungarian (hu)
    //! author : Adam Brunner : https://github.com/adambrunner
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var r = e;
            switch (n) {
              case "s":
                return a || t ? "néhány másodperc" : "néhány másodperce";

              case "m":
                return "egy" + (a || t ? " perc" : " perce");

              case "mm":
                return r + (a || t ? " perc" : " perce");

              case "h":
                return "egy" + (a || t ? " óra" : " órája");

              case "hh":
                return r + (a || t ? " óra" : " órája");

              case "d":
                return "egy" + (a || t ? " nap" : " napja");

              case "dd":
                return r + (a || t ? " nap" : " napja");

              case "M":
                return "egy" + (a || t ? " hónap" : " hónapja");

              case "MM":
                return r + (a || t ? " hónap" : " hónapja");

              case "y":
                return "egy" + (a || t ? " év" : " éve");

              case "yy":
                return r + (a || t ? " év" : " éve");
            }
            return "";
        }
        function n(e) {
            return (e ? "" : "[múlt] ") + "[" + a[this.day()] + "] LT[-kor]";
        }
        var a = "vasárnap hétfőn kedden szerdán csütörtökön pénteken szombaton".split(" "), r = e.defineLocale("hu", {
            months: "január_február_március_április_május_június_július_augusztus_szeptember_október_november_december".split("_"),
            monthsShort: "jan_feb_márc_ápr_máj_jún_júl_aug_szept_okt_nov_dec".split("_"),
            weekdays: "vasárnap_hétfő_kedd_szerda_csütörtök_péntek_szombat".split("_"),
            weekdaysShort: "vas_hét_kedd_sze_csüt_pén_szo".split("_"),
            weekdaysMin: "v_h_k_sze_cs_p_szo".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "YYYY.MM.DD.",
                LL: "YYYY. MMMM D.",
                LLL: "YYYY. MMMM D. H:mm",
                LLLL: "YYYY. MMMM D., dddd H:mm"
            },
            meridiemParse: /de|du/i,
            isPM: function(e) {
                return "u" === e.charAt(1).toLowerCase();
            },
            meridiem: function(e, t, n) {
                return e < 12 ? n === !0 ? "de" : "DE" : n === !0 ? "du" : "DU";
            },
            calendar: {
                sameDay: "[ma] LT[-kor]",
                nextDay: "[holnap] LT[-kor]",
                nextWeek: function() {
                    return n.call(this, !0);
                },
                lastDay: "[tegnap] LT[-kor]",
                lastWeek: function() {
                    return n.call(this, !1);
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "%s múlva",
                past: "%s",
                s: t,
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: t,
                dd: t,
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return r;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Armenian (hy-am)
    //! author : Armendarabyan : https://github.com/armendarabyan
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t) {
            var n = {
                nominative: "հունվար_փետրվար_մարտ_ապրիլ_մայիս_հունիս_հուլիս_օգոստոս_սեպտեմբեր_հոկտեմբեր_նոյեմբեր_դեկտեմբեր".split("_"),
                accusative: "հունվարի_փետրվարի_մարտի_ապրիլի_մայիսի_հունիսի_հուլիսի_օգոստոսի_սեպտեմբերի_հոկտեմբերի_նոյեմբերի_դեկտեմբերի".split("_")
            }, a = /D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function n(e, t) {
            var n = "հնվ_փտր_մրտ_ապր_մյս_հնս_հլս_օգս_սպտ_հկտ_նմբ_դկտ".split("_");
            return n[e.month()];
        }
        function a(e, t) {
            var n = "կիրակի_երկուշաբթի_երեքշաբթի_չորեքշաբթի_հինգշաբթի_ուրբաթ_շաբաթ".split("_");
            return n[e.day()];
        }
        var r = e.defineLocale("hy-am", {
            months: t,
            monthsShort: n,
            weekdays: a,
            weekdaysShort: "կրկ_երկ_երք_չրք_հնգ_ուրբ_շբթ".split("_"),
            weekdaysMin: "կրկ_երկ_երք_չրք_հնգ_ուրբ_շբթ".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY թ.",
                LLL: "D MMMM YYYY թ., HH:mm",
                LLLL: "dddd, D MMMM YYYY թ., HH:mm"
            },
            calendar: {
                sameDay: "[այսօր] LT",
                nextDay: "[վաղը] LT",
                lastDay: "[երեկ] LT",
                nextWeek: function() {
                    return "dddd [օրը ժամը] LT";
                },
                lastWeek: function() {
                    return "[անցած] dddd [օրը ժամը] LT";
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "%s հետո",
                past: "%s առաջ",
                s: "մի քանի վայրկյան",
                m: "րոպե",
                mm: "%d րոպե",
                h: "ժամ",
                hh: "%d ժամ",
                d: "օր",
                dd: "%d օր",
                M: "ամիս",
                MM: "%d ամիս",
                y: "տարի",
                yy: "%d տարի"
            },
            meridiemParse: /գիշերվա|առավոտվա|ցերեկվա|երեկոյան/,
            isPM: function(e) {
                return /^(ցերեկվա|երեկոյան)$/.test(e);
            },
            meridiem: function(e) {
                return e < 4 ? "գիշերվա" : e < 12 ? "առավոտվա" : e < 17 ? "ցերեկվա" : "երեկոյան";
            },
            ordinalParse: /\d{1,2}|\d{1,2}-(ին|րդ)/,
            ordinal: function(e, t) {
                switch (t) {
                  case "DDD":
                  case "w":
                  case "W":
                  case "DDDo":
                    return 1 === e ? e + "-ին" : e + "-րդ";

                  default:
                    return e;
                }
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return r;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Bahasa Indonesia (id)
    //! author : Mohammad Satrio Utomo : https://github.com/tyok
    //! reference: http://id.wikisource.org/wiki/Pedoman_Umum_Ejaan_Bahasa_Indonesia_yang_Disempurnakan
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("id", {
            months: "Januari_Februari_Maret_April_Mei_Juni_Juli_Agustus_September_Oktober_November_Desember".split("_"),
            monthsShort: "Jan_Feb_Mar_Apr_Mei_Jun_Jul_Ags_Sep_Okt_Nov_Des".split("_"),
            weekdays: "Minggu_Senin_Selasa_Rabu_Kamis_Jumat_Sabtu".split("_"),
            weekdaysShort: "Min_Sen_Sel_Rab_Kam_Jum_Sab".split("_"),
            weekdaysMin: "Mg_Sn_Sl_Rb_Km_Jm_Sb".split("_"),
            longDateFormat: {
                LT: "HH.mm",
                LTS: "HH.mm.ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY [pukul] HH.mm",
                LLLL: "dddd, D MMMM YYYY [pukul] HH.mm"
            },
            meridiemParse: /pagi|siang|sore|malam/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "pagi" === t ? e : "siang" === t ? e >= 11 ? e : e + 12 : "sore" === t || "malam" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 11 ? "pagi" : e < 15 ? "siang" : e < 19 ? "sore" : "malam";
            },
            calendar: {
                sameDay: "[Hari ini pukul] LT",
                nextDay: "[Besok pukul] LT",
                nextWeek: "dddd [pukul] LT",
                lastDay: "[Kemarin pukul] LT",
                lastWeek: "dddd [lalu pukul] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "dalam %s",
                past: "%s yang lalu",
                s: "beberapa detik",
                m: "semenit",
                mm: "%d menit",
                h: "sejam",
                hh: "%d jam",
                d: "sehari",
                dd: "%d hari",
                M: "sebulan",
                MM: "%d bulan",
                y: "setahun",
                yy: "%d tahun"
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : icelandic (is)
    //! author : Hinrik Örn Sigurðsson : https://github.com/hinrik
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e) {
            return e % 100 === 11 || e % 10 !== 1;
        }
        function n(e, n, a, r) {
            var i = e + " ";
            switch (a) {
              case "s":
                return n || r ? "nokkrar sekúndur" : "nokkrum sekúndum";

              case "m":
                return n ? "mínúta" : "mínútu";

              case "mm":
                return t(e) ? i + (n || r ? "mínútur" : "mínútum") : n ? i + "mínúta" : i + "mínútu";

              case "hh":
                return t(e) ? i + (n || r ? "klukkustundir" : "klukkustundum") : i + "klukkustund";

              case "d":
                return n ? "dagur" : r ? "dag" : "degi";

              case "dd":
                return t(e) ? n ? i + "dagar" : i + (r ? "daga" : "dögum") : n ? i + "dagur" : i + (r ? "dag" : "degi");

              case "M":
                return n ? "mánuður" : r ? "mánuð" : "mánuði";

              case "MM":
                return t(e) ? n ? i + "mánuðir" : i + (r ? "mánuði" : "mánuðum") : n ? i + "mánuður" : i + (r ? "mánuð" : "mánuði");

              case "y":
                return n || r ? "ár" : "ári";

              case "yy":
                return t(e) ? i + (n || r ? "ár" : "árum") : i + (n || r ? "ár" : "ári");
            }
        }
        var a = e.defineLocale("is", {
            months: "janúar_febrúar_mars_apríl_maí_júní_júlí_ágúst_september_október_nóvember_desember".split("_"),
            monthsShort: "jan_feb_mar_apr_maí_jún_júl_ágú_sep_okt_nóv_des".split("_"),
            weekdays: "sunnudagur_mánudagur_þriðjudagur_miðvikudagur_fimmtudagur_föstudagur_laugardagur".split("_"),
            weekdaysShort: "sun_mán_þri_mið_fim_fös_lau".split("_"),
            weekdaysMin: "Su_Má_Þr_Mi_Fi_Fö_La".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY [kl.] H:mm",
                LLLL: "dddd, D. MMMM YYYY [kl.] H:mm"
            },
            calendar: {
                sameDay: "[í dag kl.] LT",
                nextDay: "[á morgun kl.] LT",
                nextWeek: "dddd [kl.] LT",
                lastDay: "[í gær kl.] LT",
                lastWeek: "[síðasta] dddd [kl.] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "eftir %s",
                past: "fyrir %s síðan",
                s: n,
                m: n,
                mm: n,
                h: "klukkustund",
                hh: n,
                d: n,
                dd: n,
                M: n,
                MM: n,
                y: n,
                yy: n
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : italian (it)
    //! author : Lorenzo : https://github.com/aliem
    //! author: Mattia Larentis: https://github.com/nostalgiaz
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("it", {
            months: "gennaio_febbraio_marzo_aprile_maggio_giugno_luglio_agosto_settembre_ottobre_novembre_dicembre".split("_"),
            monthsShort: "gen_feb_mar_apr_mag_giu_lug_ago_set_ott_nov_dic".split("_"),
            weekdays: "Domenica_Lunedì_Martedì_Mercoledì_Giovedì_Venerdì_Sabato".split("_"),
            weekdaysShort: "Dom_Lun_Mar_Mer_Gio_Ven_Sab".split("_"),
            weekdaysMin: "D_L_Ma_Me_G_V_S".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Oggi alle] LT",
                nextDay: "[Domani alle] LT",
                nextWeek: "dddd [alle] LT",
                lastDay: "[Ieri alle] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[la scorsa] dddd [alle] LT";

                      default:
                        return "[lo scorso] dddd [alle] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: function(e) {
                    return (/^[0-9].+$/.test(e) ? "tra" : "in") + " " + e;
                },
                past: "%s fa",
                s: "alcuni secondi",
                m: "un minuto",
                mm: "%d minuti",
                h: "un'ora",
                hh: "%d ore",
                d: "un giorno",
                dd: "%d giorni",
                M: "un mese",
                MM: "%d mesi",
                y: "un anno",
                yy: "%d anni"
            },
            ordinalParse: /\d{1,2}º/,
            ordinal: "%dº",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : japanese (ja)
    //! author : LI Long : https://github.com/baryon
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ja", {
            months: "1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),
            monthsShort: "1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),
            weekdays: "日曜日_月曜日_火曜日_水曜日_木曜日_金曜日_土曜日".split("_"),
            weekdaysShort: "日_月_火_水_木_金_土".split("_"),
            weekdaysMin: "日_月_火_水_木_金_土".split("_"),
            longDateFormat: {
                LT: "Ah時m分",
                LTS: "Ah時m分s秒",
                L: "YYYY/MM/DD",
                LL: "YYYY年M月D日",
                LLL: "YYYY年M月D日Ah時m分",
                LLLL: "YYYY年M月D日Ah時m分 dddd"
            },
            meridiemParse: /午前|午後/i,
            isPM: function(e) {
                return "午後" === e;
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "午前" : "午後";
            },
            calendar: {
                sameDay: "[今日] LT",
                nextDay: "[明日] LT",
                nextWeek: "[来週]dddd LT",
                lastDay: "[昨日] LT",
                lastWeek: "[前週]dddd LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s後",
                past: "%s前",
                s: "数秒",
                m: "1分",
                mm: "%d分",
                h: "1時間",
                hh: "%d時間",
                d: "1日",
                dd: "%d日",
                M: "1ヶ月",
                MM: "%dヶ月",
                y: "1年",
                yy: "%d年"
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Boso Jowo (jv)
    //! author : Rony Lantip : https://github.com/lantip
    //! reference: http://jv.wikipedia.org/wiki/Basa_Jawa
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("jv", {
            months: "Januari_Februari_Maret_April_Mei_Juni_Juli_Agustus_September_Oktober_Nopember_Desember".split("_"),
            monthsShort: "Jan_Feb_Mar_Apr_Mei_Jun_Jul_Ags_Sep_Okt_Nop_Des".split("_"),
            weekdays: "Minggu_Senen_Seloso_Rebu_Kemis_Jemuwah_Septu".split("_"),
            weekdaysShort: "Min_Sen_Sel_Reb_Kem_Jem_Sep".split("_"),
            weekdaysMin: "Mg_Sn_Sl_Rb_Km_Jm_Sp".split("_"),
            longDateFormat: {
                LT: "HH.mm",
                LTS: "HH.mm.ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY [pukul] HH.mm",
                LLLL: "dddd, D MMMM YYYY [pukul] HH.mm"
            },
            meridiemParse: /enjing|siyang|sonten|ndalu/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "enjing" === t ? e : "siyang" === t ? e >= 11 ? e : e + 12 : "sonten" === t || "ndalu" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 11 ? "enjing" : e < 15 ? "siyang" : e < 19 ? "sonten" : "ndalu";
            },
            calendar: {
                sameDay: "[Dinten puniko pukul] LT",
                nextDay: "[Mbenjang pukul] LT",
                nextWeek: "dddd [pukul] LT",
                lastDay: "[Kala wingi pukul] LT",
                lastWeek: "dddd [kepengker pukul] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "wonten ing %s",
                past: "%s ingkang kepengker",
                s: "sawetawis detik",
                m: "setunggal menit",
                mm: "%d menit",
                h: "setunggal jam",
                hh: "%d jam",
                d: "sedinten",
                dd: "%d dinten",
                M: "sewulan",
                MM: "%d wulan",
                y: "setaun",
                yy: "%d taun"
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Georgian (ka)
    //! author : Irakli Janiashvili : https://github.com/irakli-janiashvili
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t) {
            var n = {
                nominative: "იანვარი_თებერვალი_მარტი_აპრილი_მაისი_ივნისი_ივლისი_აგვისტო_სექტემბერი_ოქტომბერი_ნოემბერი_დეკემბერი".split("_"),
                accusative: "იანვარს_თებერვალს_მარტს_აპრილის_მაისს_ივნისს_ივლისს_აგვისტს_სექტემბერს_ოქტომბერს_ნოემბერს_დეკემბერს".split("_")
            }, a = /D[oD] *MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function n(e, t) {
            var n = {
                nominative: "კვირა_ორშაბათი_სამშაბათი_ოთხშაბათი_ხუთშაბათი_პარასკევი_შაბათი".split("_"),
                accusative: "კვირას_ორშაბათს_სამშაბათს_ოთხშაბათს_ხუთშაბათს_პარასკევს_შაბათს".split("_")
            }, a = /(წინა|შემდეგ)/.test(t) ? "accusative" : "nominative";
            return n[a][e.day()];
        }
        var a = e.defineLocale("ka", {
            months: t,
            monthsShort: "იან_თებ_მარ_აპრ_მაი_ივნ_ივლ_აგვ_სექ_ოქტ_ნოე_დეკ".split("_"),
            weekdays: n,
            weekdaysShort: "კვი_ორშ_სამ_ოთხ_ხუთ_პარ_შაბ".split("_"),
            weekdaysMin: "კვ_ორ_სა_ოთ_ხუ_პა_შა".split("_"),
            longDateFormat: {
                LT: "h:mm A",
                LTS: "h:mm:ss A",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY h:mm A",
                LLLL: "dddd, D MMMM YYYY h:mm A"
            },
            calendar: {
                sameDay: "[დღეს] LT[-ზე]",
                nextDay: "[ხვალ] LT[-ზე]",
                lastDay: "[გუშინ] LT[-ზე]",
                nextWeek: "[შემდეგ] dddd LT[-ზე]",
                lastWeek: "[წინა] dddd LT-ზე",
                sameElse: "L"
            },
            relativeTime: {
                future: function(e) {
                    return /(წამი|წუთი|საათი|წელი)/.test(e) ? e.replace(/ი$/, "ში") : e + "ში";
                },
                past: function(e) {
                    return /(წამი|წუთი|საათი|დღე|თვე)/.test(e) ? e.replace(/(ი|ე)$/, "ის წინ") : /წელი/.test(e) ? e.replace(/წელი$/, "წლის წინ") : void 0;
                },
                s: "რამდენიმე წამი",
                m: "წუთი",
                mm: "%d წუთი",
                h: "საათი",
                hh: "%d საათი",
                d: "დღე",
                dd: "%d დღე",
                M: "თვე",
                MM: "%d თვე",
                y: "წელი",
                yy: "%d წელი"
            },
            ordinalParse: /0|1-ლი|მე-\d{1,2}|\d{1,2}-ე/,
            ordinal: function(e) {
                return 0 === e ? e : 1 === e ? e + "-ლი" : e < 20 || e <= 100 && e % 20 === 0 || e % 100 === 0 ? "მე-" + e : e + "-ე";
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : khmer (km)
    //! author : Kruy Vanna : https://github.com/kruyvanna
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("km", {
            months: "មករា_កុម្ភៈ_មិនា_មេសា_ឧសភា_មិថុនា_កក្កដា_សីហា_កញ្ញា_តុលា_វិច្ឆិកា_ធ្នូ".split("_"),
            monthsShort: "មករា_កុម្ភៈ_មិនា_មេសា_ឧសភា_មិថុនា_កក្កដា_សីហា_កញ្ញា_តុលា_វិច្ឆិកា_ធ្នូ".split("_"),
            weekdays: "អាទិត្យ_ច័ន្ទ_អង្គារ_ពុធ_ព្រហស្បតិ៍_សុក្រ_សៅរ៍".split("_"),
            weekdaysShort: "អាទិត្យ_ច័ន្ទ_អង្គារ_ពុធ_ព្រហស្បតិ៍_សុក្រ_សៅរ៍".split("_"),
            weekdaysMin: "អាទិត្យ_ច័ន្ទ_អង្គារ_ពុធ_ព្រហស្បតិ៍_សុក្រ_សៅរ៍".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[ថ្ងៃនៈ ម៉ោង] LT",
                nextDay: "[ស្អែក ម៉ោង] LT",
                nextWeek: "dddd [ម៉ោង] LT",
                lastDay: "[ម្សិលមិញ ម៉ោង] LT",
                lastWeek: "dddd [សប្តាហ៍មុន] [ម៉ោង] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%sទៀត",
                past: "%sមុន",
                s: "ប៉ុន្មានវិនាទី",
                m: "មួយនាទី",
                mm: "%d នាទី",
                h: "មួយម៉ោង",
                hh: "%d ម៉ោង",
                d: "មួយថ្ងៃ",
                dd: "%d ថ្ងៃ",
                M: "មួយខែ",
                MM: "%d ខែ",
                y: "មួយឆ្នាំ",
                yy: "%d ឆ្នាំ"
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : korean (ko)
    //!
    //! authors
    //!
    //! - Kyungwook, Park : https://github.com/kyungw00k
    //! - Jeeeyul Lee <jeeeyul@gmail.com>
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ko", {
            months: "1월_2월_3월_4월_5월_6월_7월_8월_9월_10월_11월_12월".split("_"),
            monthsShort: "1월_2월_3월_4월_5월_6월_7월_8월_9월_10월_11월_12월".split("_"),
            weekdays: "일요일_월요일_화요일_수요일_목요일_금요일_토요일".split("_"),
            weekdaysShort: "일_월_화_수_목_금_토".split("_"),
            weekdaysMin: "일_월_화_수_목_금_토".split("_"),
            longDateFormat: {
                LT: "A h시 m분",
                LTS: "A h시 m분 s초",
                L: "YYYY.MM.DD",
                LL: "YYYY년 MMMM D일",
                LLL: "YYYY년 MMMM D일 A h시 m분",
                LLLL: "YYYY년 MMMM D일 dddd A h시 m분"
            },
            calendar: {
                sameDay: "오늘 LT",
                nextDay: "내일 LT",
                nextWeek: "dddd LT",
                lastDay: "어제 LT",
                lastWeek: "지난주 dddd LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s 후",
                past: "%s 전",
                s: "몇초",
                ss: "%d초",
                m: "일분",
                mm: "%d분",
                h: "한시간",
                hh: "%d시간",
                d: "하루",
                dd: "%d일",
                M: "한달",
                MM: "%d달",
                y: "일년",
                yy: "%d년"
            },
            ordinalParse: /\d{1,2}일/,
            ordinal: "%d일",
            meridiemParse: /오전|오후/,
            isPM: function(e) {
                return "오후" === e;
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "오전" : "오후";
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Luxembourgish (lb)
    //! author : mweimerskirch : https://github.com/mweimerskirch, David Raison : https://github.com/kwisatz
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var r = {
                m: [ "eng Minutt", "enger Minutt" ],
                h: [ "eng Stonn", "enger Stonn" ],
                d: [ "een Dag", "engem Dag" ],
                M: [ "ee Mount", "engem Mount" ],
                y: [ "ee Joer", "engem Joer" ]
            };
            return t ? r[n][0] : r[n][1];
        }
        function n(e) {
            var t = e.substr(0, e.indexOf(" "));
            return r(t) ? "a " + e : "an " + e;
        }
        function a(e) {
            var t = e.substr(0, e.indexOf(" "));
            return r(t) ? "viru " + e : "virun " + e;
        }
        function r(e) {
            if (e = parseInt(e, 10), isNaN(e)) return !1;
            if (e < 0) return !0;
            if (e < 10) return 4 <= e && e <= 7;
            if (e < 100) {
                var t = e % 10, n = e / 10;
                return r(0 === t ? n : t);
            }
            if (e < 1e4) {
                for (;e >= 10; ) e /= 10;
                return r(e);
            }
            return e /= 1e3, r(e);
        }
        var i = e.defineLocale("lb", {
            months: "Januar_Februar_Mäerz_Abrëll_Mee_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),
            monthsShort: "Jan._Febr._Mrz._Abr._Mee_Jun._Jul._Aug._Sept._Okt._Nov._Dez.".split("_"),
            weekdays: "Sonndeg_Méindeg_Dënschdeg_Mëttwoch_Donneschdeg_Freideg_Samschdeg".split("_"),
            weekdaysShort: "So._Mé._Dë._Më._Do._Fr._Sa.".split("_"),
            weekdaysMin: "So_Mé_Dë_Më_Do_Fr_Sa".split("_"),
            longDateFormat: {
                LT: "H:mm [Auer]",
                LTS: "H:mm:ss [Auer]",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm [Auer]",
                LLLL: "dddd, D. MMMM YYYY H:mm [Auer]"
            },
            calendar: {
                sameDay: "[Haut um] LT",
                sameElse: "L",
                nextDay: "[Muer um] LT",
                nextWeek: "dddd [um] LT",
                lastDay: "[Gëschter um] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 2:
                      case 4:
                        return "[Leschten] dddd [um] LT";

                      default:
                        return "[Leschte] dddd [um] LT";
                    }
                }
            },
            relativeTime: {
                future: n,
                past: a,
                s: "e puer Sekonnen",
                m: t,
                mm: "%d Minutten",
                h: t,
                hh: "%d Stonnen",
                d: t,
                dd: "%d Deeg",
                M: t,
                MM: "%d Méint",
                y: t,
                yy: "%d Joer"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return i;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Lithuanian (lt)
    //! author : Mindaugas Mozūras : https://github.com/mmozuras
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            return t ? "kelios sekundės" : a ? "kelių sekundžių" : "kelias sekundes";
        }
        function n(e, t) {
            var n = {
                nominative: "sausis_vasaris_kovas_balandis_gegužė_birželis_liepa_rugpjūtis_rugsėjis_spalis_lapkritis_gruodis".split("_"),
                accusative: "sausio_vasario_kovo_balandžio_gegužės_birželio_liepos_rugpjūčio_rugsėjo_spalio_lapkričio_gruodžio".split("_")
            }, a = /D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function a(e, t, n, a) {
            return t ? i(n)[0] : a ? i(n)[1] : i(n)[2];
        }
        function r(e) {
            return e % 10 === 0 || e > 10 && e < 20;
        }
        function i(e) {
            return l[e].split("_");
        }
        function s(e, t, n, s) {
            var o = e + " ";
            return 1 === e ? o + a(e, t, n[0], s) : t ? o + (r(e) ? i(n)[1] : i(n)[0]) : s ? o + i(n)[1] : o + (r(e) ? i(n)[1] : i(n)[2]);
        }
        function o(e, t) {
            var n = t.indexOf("dddd HH:mm") === -1, a = u[e.day()];
            return n ? a : a.substring(0, a.length - 2) + "į";
        }
        var l = {
            m: "minutė_minutės_minutę",
            mm: "minutės_minučių_minutes",
            h: "valanda_valandos_valandą",
            hh: "valandos_valandų_valandas",
            d: "diena_dienos_dieną",
            dd: "dienos_dienų_dienas",
            M: "mėnuo_mėnesio_mėnesį",
            MM: "mėnesiai_mėnesių_mėnesius",
            y: "metai_metų_metus",
            yy: "metai_metų_metus"
        }, u = "sekmadienis_pirmadienis_antradienis_trečiadienis_ketvirtadienis_penktadienis_šeštadienis".split("_"), c = e.defineLocale("lt", {
            months: n,
            monthsShort: "sau_vas_kov_bal_geg_bir_lie_rgp_rgs_spa_lap_grd".split("_"),
            weekdays: o,
            weekdaysShort: "Sek_Pir_Ant_Tre_Ket_Pen_Šeš".split("_"),
            weekdaysMin: "S_P_A_T_K_Pn_Š".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "YYYY-MM-DD",
                LL: "YYYY [m.] MMMM D [d.]",
                LLL: "YYYY [m.] MMMM D [d.], HH:mm [val.]",
                LLLL: "YYYY [m.] MMMM D [d.], dddd, HH:mm [val.]",
                l: "YYYY-MM-DD",
                ll: "YYYY [m.] MMMM D [d.]",
                lll: "YYYY [m.] MMMM D [d.], HH:mm [val.]",
                llll: "YYYY [m.] MMMM D [d.], ddd, HH:mm [val.]"
            },
            calendar: {
                sameDay: "[Šiandien] LT",
                nextDay: "[Rytoj] LT",
                nextWeek: "dddd LT",
                lastDay: "[Vakar] LT",
                lastWeek: "[Praėjusį] dddd LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "po %s",
                past: "prieš %s",
                s: t,
                m: a,
                mm: s,
                h: a,
                hh: s,
                d: a,
                dd: s,
                M: a,
                MM: s,
                y: a,
                yy: s
            },
            ordinalParse: /\d{1,2}-oji/,
            ordinal: function(e) {
                return e + "-oji";
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return c;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : latvian (lv)
    //! author : Kristaps Karlsons : https://github.com/skakri
    //! author : Jānis Elmeris : https://github.com/JanisE
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n) {
            return n ? t % 10 === 1 && 11 !== t ? e[2] : e[3] : t % 10 === 1 && 11 !== t ? e[0] : e[1];
        }
        function n(e, n, a) {
            return e + " " + t(i[a], e, n);
        }
        function a(e, n, a) {
            return t(i[a], e, n);
        }
        function r(e, t) {
            return t ? "dažas sekundes" : "dažām sekundēm";
        }
        var i = {
            m: "minūtes_minūtēm_minūte_minūtes".split("_"),
            mm: "minūtes_minūtēm_minūte_minūtes".split("_"),
            h: "stundas_stundām_stunda_stundas".split("_"),
            hh: "stundas_stundām_stunda_stundas".split("_"),
            d: "dienas_dienām_diena_dienas".split("_"),
            dd: "dienas_dienām_diena_dienas".split("_"),
            M: "mēneša_mēnešiem_mēnesis_mēneši".split("_"),
            MM: "mēneša_mēnešiem_mēnesis_mēneši".split("_"),
            y: "gada_gadiem_gads_gadi".split("_"),
            yy: "gada_gadiem_gads_gadi".split("_")
        }, s = e.defineLocale("lv", {
            months: "janvāris_februāris_marts_aprīlis_maijs_jūnijs_jūlijs_augusts_septembris_oktobris_novembris_decembris".split("_"),
            monthsShort: "jan_feb_mar_apr_mai_jūn_jūl_aug_sep_okt_nov_dec".split("_"),
            weekdays: "svētdiena_pirmdiena_otrdiena_trešdiena_ceturtdiena_piektdiena_sestdiena".split("_"),
            weekdaysShort: "Sv_P_O_T_C_Pk_S".split("_"),
            weekdaysMin: "Sv_P_O_T_C_Pk_S".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY.",
                LL: "YYYY. [gada] D. MMMM",
                LLL: "YYYY. [gada] D. MMMM, HH:mm",
                LLLL: "YYYY. [gada] D. MMMM, dddd, HH:mm"
            },
            calendar: {
                sameDay: "[Šodien pulksten] LT",
                nextDay: "[Rīt pulksten] LT",
                nextWeek: "dddd [pulksten] LT",
                lastDay: "[Vakar pulksten] LT",
                lastWeek: "[Pagājušā] dddd [pulksten] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "pēc %s",
                past: "pirms %s",
                s: r,
                m: a,
                mm: n,
                h: a,
                hh: n,
                d: a,
                dd: n,
                M: a,
                MM: n,
                y: a,
                yy: n
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return s;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Montenegrin (me)
    //! author : Miodrag Nikač <miodrag@restartit.me> : https://github.com/miodragnikac
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            words: {
                m: [ "jedan minut", "jednog minuta" ],
                mm: [ "minut", "minuta", "minuta" ],
                h: [ "jedan sat", "jednog sata" ],
                hh: [ "sat", "sata", "sati" ],
                dd: [ "dan", "dana", "dana" ],
                MM: [ "mjesec", "mjeseca", "mjeseci" ],
                yy: [ "godina", "godine", "godina" ]
            },
            correctGrammaticalCase: function(e, t) {
                return 1 === e ? t[0] : e >= 2 && e <= 4 ? t[1] : t[2];
            },
            translate: function(e, n, a) {
                var r = t.words[a];
                return 1 === a.length ? n ? r[0] : r[1] : e + " " + t.correctGrammaticalCase(e, r);
            }
        }, n = e.defineLocale("me", {
            months: [ "januar", "februar", "mart", "april", "maj", "jun", "jul", "avgust", "septembar", "oktobar", "novembar", "decembar" ],
            monthsShort: [ "jan.", "feb.", "mar.", "apr.", "maj", "jun", "jul", "avg.", "sep.", "okt.", "nov.", "dec." ],
            weekdays: [ "nedjelja", "ponedjeljak", "utorak", "srijeda", "četvrtak", "petak", "subota" ],
            weekdaysShort: [ "ned.", "pon.", "uto.", "sri.", "čet.", "pet.", "sub." ],
            weekdaysMin: [ "ne", "po", "ut", "sr", "če", "pe", "su" ],
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD. MM. YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[danas u] LT",
                nextDay: "[sjutra u] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[u] [nedjelju] [u] LT";

                      case 3:
                        return "[u] [srijedu] [u] LT";

                      case 6:
                        return "[u] [subotu] [u] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[u] dddd [u] LT";
                    }
                },
                lastDay: "[juče u] LT",
                lastWeek: function() {
                    var e = [ "[prošle] [nedjelje] [u] LT", "[prošlog] [ponedjeljka] [u] LT", "[prošlog] [utorka] [u] LT", "[prošle] [srijede] [u] LT", "[prošlog] [četvrtka] [u] LT", "[prošlog] [petka] [u] LT", "[prošle] [subote] [u] LT" ];
                    return e[this.day()];
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "prije %s",
                s: "nekoliko sekundi",
                m: t.translate,
                mm: t.translate,
                h: t.translate,
                hh: t.translate,
                d: "dan",
                dd: t.translate,
                M: "mjesec",
                MM: t.translate,
                y: "godinu",
                yy: t.translate
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : macedonian (mk)
    //! author : Borislav Mickov : https://github.com/B0k0
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("mk", {
            months: "јануари_февруари_март_април_мај_јуни_јули_август_септември_октомври_ноември_декември".split("_"),
            monthsShort: "јан_фев_мар_апр_мај_јун_јул_авг_сеп_окт_ное_дек".split("_"),
            weekdays: "недела_понеделник_вторник_среда_четврток_петок_сабота".split("_"),
            weekdaysShort: "нед_пон_вто_сре_чет_пет_саб".split("_"),
            weekdaysMin: "нe_пo_вт_ср_че_пе_сa".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "D.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY H:mm",
                LLLL: "dddd, D MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[Денес во] LT",
                nextDay: "[Утре во] LT",
                nextWeek: "dddd [во] LT",
                lastDay: "[Вчера во] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                      case 3:
                      case 6:
                        return "[Во изминатата] dddd [во] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[Во изминатиот] dddd [во] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "после %s",
                past: "пред %s",
                s: "неколку секунди",
                m: "минута",
                mm: "%d минути",
                h: "час",
                hh: "%d часа",
                d: "ден",
                dd: "%d дена",
                M: "месец",
                MM: "%d месеци",
                y: "година",
                yy: "%d години"
            },
            ordinalParse: /\d{1,2}-(ев|ен|ти|ви|ри|ми)/,
            ordinal: function(e) {
                var t = e % 10, n = e % 100;
                return 0 === e ? e + "-ев" : 0 === n ? e + "-ен" : n > 10 && n < 20 ? e + "-ти" : 1 === t ? e + "-ви" : 2 === t ? e + "-ри" : 7 === t || 8 === t ? e + "-ми" : e + "-ти";
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : malayalam (ml)
    //! author : Floyd Pink : https://github.com/floydpink
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ml", {
            months: "ജനുവരി_ഫെബ്രുവരി_മാർച്ച്_ഏപ്രിൽ_മേയ്_ജൂൺ_ജൂലൈ_ഓഗസ്റ്റ്_സെപ്റ്റംബർ_ഒക്ടോബർ_നവംബർ_ഡിസംബർ".split("_"),
            monthsShort: "ജനു._ഫെബ്രു._മാർ._ഏപ്രി._മേയ്_ജൂൺ_ജൂലൈ._ഓഗ._സെപ്റ്റ._ഒക്ടോ._നവം._ഡിസം.".split("_"),
            weekdays: "ഞായറാഴ്ച_തിങ്കളാഴ്ച_ചൊവ്വാഴ്ച_ബുധനാഴ്ച_വ്യാഴാഴ്ച_വെള്ളിയാഴ്ച_ശനിയാഴ്ച".split("_"),
            weekdaysShort: "ഞായർ_തിങ്കൾ_ചൊവ്വ_ബുധൻ_വ്യാഴം_വെള്ളി_ശനി".split("_"),
            weekdaysMin: "ഞാ_തി_ചൊ_ബു_വ്യാ_വെ_ശ".split("_"),
            longDateFormat: {
                LT: "A h:mm -നു",
                LTS: "A h:mm:ss -നു",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, A h:mm -നു",
                LLLL: "dddd, D MMMM YYYY, A h:mm -നു"
            },
            calendar: {
                sameDay: "[ഇന്ന്] LT",
                nextDay: "[നാളെ] LT",
                nextWeek: "dddd, LT",
                lastDay: "[ഇന്നലെ] LT",
                lastWeek: "[കഴിഞ്ഞ] dddd, LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s കഴിഞ്ഞ്",
                past: "%s മുൻപ്",
                s: "അൽപ നിമിഷങ്ങൾ",
                m: "ഒരു മിനിറ്റ്",
                mm: "%d മിനിറ്റ്",
                h: "ഒരു മണിക്കൂർ",
                hh: "%d മണിക്കൂർ",
                d: "ഒരു ദിവസം",
                dd: "%d ദിവസം",
                M: "ഒരു മാസം",
                MM: "%d മാസം",
                y: "ഒരു വർഷം",
                yy: "%d വർഷം"
            },
            meridiemParse: /രാത്രി|രാവിലെ|ഉച്ച കഴിഞ്ഞ്|വൈകുന്നേരം|രാത്രി/i,
            isPM: function(e) {
                return /^(ഉച്ച കഴിഞ്ഞ്|വൈകുന്നേരം|രാത്രി)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "രാത്രി" : e < 12 ? "രാവിലെ" : e < 17 ? "ഉച്ച കഴിഞ്ഞ്" : e < 20 ? "വൈകുന്നേരം" : "രാത്രി";
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Marathi (mr)
    //! author : Harshad Kale : https://github.com/kalehv
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "१",
            "2": "२",
            "3": "३",
            "4": "४",
            "5": "५",
            "6": "६",
            "7": "७",
            "8": "८",
            "9": "९",
            "0": "०"
        }, n = {
            "१": "1",
            "२": "2",
            "३": "3",
            "४": "4",
            "५": "5",
            "६": "6",
            "७": "7",
            "८": "8",
            "९": "9",
            "०": "0"
        }, a = e.defineLocale("mr", {
            months: "जानेवारी_फेब्रुवारी_मार्च_एप्रिल_मे_जून_जुलै_ऑगस्ट_सप्टेंबर_ऑक्टोबर_नोव्हेंबर_डिसेंबर".split("_"),
            monthsShort: "जाने._फेब्रु._मार्च._एप्रि._मे._जून._जुलै._ऑग._सप्टें._ऑक्टो._नोव्हें._डिसें.".split("_"),
            weekdays: "रविवार_सोमवार_मंगळवार_बुधवार_गुरूवार_शुक्रवार_शनिवार".split("_"),
            weekdaysShort: "रवि_सोम_मंगळ_बुध_गुरू_शुक्र_शनि".split("_"),
            weekdaysMin: "र_सो_मं_बु_गु_शु_श".split("_"),
            longDateFormat: {
                LT: "A h:mm वाजता",
                LTS: "A h:mm:ss वाजता",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, A h:mm वाजता",
                LLLL: "dddd, D MMMM YYYY, A h:mm वाजता"
            },
            calendar: {
                sameDay: "[आज] LT",
                nextDay: "[उद्या] LT",
                nextWeek: "dddd, LT",
                lastDay: "[काल] LT",
                lastWeek: "[मागील] dddd, LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s नंतर",
                past: "%s पूर्वी",
                s: "सेकंद",
                m: "एक मिनिट",
                mm: "%d मिनिटे",
                h: "एक तास",
                hh: "%d तास",
                d: "एक दिवस",
                dd: "%d दिवस",
                M: "एक महिना",
                MM: "%d महिने",
                y: "एक वर्ष",
                yy: "%d वर्षे"
            },
            preparse: function(e) {
                return e.replace(/[१२३४५६७८९०]/g, function(e) {
                    return n[e];
                });
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                });
            },
            meridiemParse: /रात्री|सकाळी|दुपारी|सायंकाळी/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "रात्री" === t ? e < 4 ? e : e + 12 : "सकाळी" === t ? e : "दुपारी" === t ? e >= 10 ? e : e + 12 : "सायंकाळी" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "रात्री" : e < 10 ? "सकाळी" : e < 17 ? "दुपारी" : e < 20 ? "सायंकाळी" : "रात्री";
            },
            week: {
                dow: 0,
                doy: 6
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Bahasa Malaysia (ms-MY)
    //! author : Weldan Jamili : https://github.com/weldan
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ms", {
            months: "Januari_Februari_Mac_April_Mei_Jun_Julai_Ogos_September_Oktober_November_Disember".split("_"),
            monthsShort: "Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ogs_Sep_Okt_Nov_Dis".split("_"),
            weekdays: "Ahad_Isnin_Selasa_Rabu_Khamis_Jumaat_Sabtu".split("_"),
            weekdaysShort: "Ahd_Isn_Sel_Rab_Kha_Jum_Sab".split("_"),
            weekdaysMin: "Ah_Is_Sl_Rb_Km_Jm_Sb".split("_"),
            longDateFormat: {
                LT: "HH.mm",
                LTS: "HH.mm.ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY [pukul] HH.mm",
                LLLL: "dddd, D MMMM YYYY [pukul] HH.mm"
            },
            meridiemParse: /pagi|tengahari|petang|malam/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "pagi" === t ? e : "tengahari" === t ? e >= 11 ? e : e + 12 : "petang" === t || "malam" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 11 ? "pagi" : e < 15 ? "tengahari" : e < 19 ? "petang" : "malam";
            },
            calendar: {
                sameDay: "[Hari ini pukul] LT",
                nextDay: "[Esok pukul] LT",
                nextWeek: "dddd [pukul] LT",
                lastDay: "[Kelmarin pukul] LT",
                lastWeek: "dddd [lepas pukul] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "dalam %s",
                past: "%s yang lepas",
                s: "beberapa saat",
                m: "seminit",
                mm: "%d minit",
                h: "sejam",
                hh: "%d jam",
                d: "sehari",
                dd: "%d hari",
                M: "sebulan",
                MM: "%d bulan",
                y: "setahun",
                yy: "%d tahun"
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Bahasa Malaysia (ms-MY)
    //! author : Weldan Jamili : https://github.com/weldan
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ms-my", {
            months: "Januari_Februari_Mac_April_Mei_Jun_Julai_Ogos_September_Oktober_November_Disember".split("_"),
            monthsShort: "Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ogs_Sep_Okt_Nov_Dis".split("_"),
            weekdays: "Ahad_Isnin_Selasa_Rabu_Khamis_Jumaat_Sabtu".split("_"),
            weekdaysShort: "Ahd_Isn_Sel_Rab_Kha_Jum_Sab".split("_"),
            weekdaysMin: "Ah_Is_Sl_Rb_Km_Jm_Sb".split("_"),
            longDateFormat: {
                LT: "HH.mm",
                LTS: "HH.mm.ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY [pukul] HH.mm",
                LLLL: "dddd, D MMMM YYYY [pukul] HH.mm"
            },
            meridiemParse: /pagi|tengahari|petang|malam/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "pagi" === t ? e : "tengahari" === t ? e >= 11 ? e : e + 12 : "petang" === t || "malam" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 11 ? "pagi" : e < 15 ? "tengahari" : e < 19 ? "petang" : "malam";
            },
            calendar: {
                sameDay: "[Hari ini pukul] LT",
                nextDay: "[Esok pukul] LT",
                nextWeek: "dddd [pukul] LT",
                lastDay: "[Kelmarin pukul] LT",
                lastWeek: "dddd [lepas pukul] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "dalam %s",
                past: "%s yang lepas",
                s: "beberapa saat",
                m: "seminit",
                mm: "%d minit",
                h: "sejam",
                hh: "%d jam",
                d: "sehari",
                dd: "%d hari",
                M: "sebulan",
                MM: "%d bulan",
                y: "setahun",
                yy: "%d tahun"
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Burmese (my)
    //! author : Squar team, mysquar.com
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "၁",
            "2": "၂",
            "3": "၃",
            "4": "၄",
            "5": "၅",
            "6": "၆",
            "7": "၇",
            "8": "၈",
            "9": "၉",
            "0": "၀"
        }, n = {
            "၁": "1",
            "၂": "2",
            "၃": "3",
            "၄": "4",
            "၅": "5",
            "၆": "6",
            "၇": "7",
            "၈": "8",
            "၉": "9",
            "၀": "0"
        }, a = e.defineLocale("my", {
            months: "ဇန်နဝါရီ_ဖေဖော်ဝါရီ_မတ်_ဧပြီ_မေ_ဇွန်_ဇူလိုင်_သြဂုတ်_စက်တင်ဘာ_အောက်တိုဘာ_နိုဝင်ဘာ_ဒီဇင်ဘာ".split("_"),
            monthsShort: "ဇန်_ဖေ_မတ်_ပြီ_မေ_ဇွန်_လိုင်_သြ_စက်_အောက်_နို_ဒီ".split("_"),
            weekdays: "တနင်္ဂနွေ_တနင်္လာ_အင်္ဂါ_ဗုဒ္ဓဟူး_ကြာသပတေး_သောကြာ_စနေ".split("_"),
            weekdaysShort: "နွေ_လာ_ဂါ_ဟူး_ကြာ_သော_နေ".split("_"),
            weekdaysMin: "နွေ_လာ_ဂါ_ဟူး_ကြာ_သော_နေ".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[ယနေ.] LT [မှာ]",
                nextDay: "[မနက်ဖြန်] LT [မှာ]",
                nextWeek: "dddd LT [မှာ]",
                lastDay: "[မနေ.က] LT [မှာ]",
                lastWeek: "[ပြီးခဲ့သော] dddd LT [မှာ]",
                sameElse: "L"
            },
            relativeTime: {
                future: "လာမည့် %s မှာ",
                past: "လွန်ခဲ့သော %s က",
                s: "စက္ကန်.အနည်းငယ်",
                m: "တစ်မိနစ်",
                mm: "%d မိနစ်",
                h: "တစ်နာရီ",
                hh: "%d နာရီ",
                d: "တစ်ရက်",
                dd: "%d ရက်",
                M: "တစ်လ",
                MM: "%d လ",
                y: "တစ်နှစ်",
                yy: "%d နှစ်"
            },
            preparse: function(e) {
                return e.replace(/[၁၂၃၄၅၆၇၈၉၀]/g, function(e) {
                    return n[e];
                });
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                });
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : norwegian bokmål (nb)
    //! authors : Espen Hovlandsdal : https://github.com/rexxars
    //!           Sigurd Gartmann : https://github.com/sigurdga
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("nb", {
            months: "januar_februar_mars_april_mai_juni_juli_august_september_oktober_november_desember".split("_"),
            monthsShort: "jan_feb_mar_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_"),
            weekdays: "søndag_mandag_tirsdag_onsdag_torsdag_fredag_lørdag".split("_"),
            weekdaysShort: "søn_man_tirs_ons_tors_fre_lør".split("_"),
            weekdaysMin: "sø_ma_ti_on_to_fr_lø".split("_"),
            longDateFormat: {
                LT: "H.mm",
                LTS: "H.mm.ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY [kl.] H.mm",
                LLLL: "dddd D. MMMM YYYY [kl.] H.mm"
            },
            calendar: {
                sameDay: "[i dag kl.] LT",
                nextDay: "[i morgen kl.] LT",
                nextWeek: "dddd [kl.] LT",
                lastDay: "[i går kl.] LT",
                lastWeek: "[forrige] dddd [kl.] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "om %s",
                past: "for %s siden",
                s: "noen sekunder",
                m: "ett minutt",
                mm: "%d minutter",
                h: "en time",
                hh: "%d timer",
                d: "en dag",
                dd: "%d dager",
                M: "en måned",
                MM: "%d måneder",
                y: "ett år",
                yy: "%d år"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : nepali/nepalese
    //! author : suvash : https://github.com/suvash
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            "1": "१",
            "2": "२",
            "3": "३",
            "4": "४",
            "5": "५",
            "6": "६",
            "7": "७",
            "8": "८",
            "9": "९",
            "0": "०"
        }, n = {
            "१": "1",
            "२": "2",
            "३": "3",
            "४": "4",
            "५": "5",
            "६": "6",
            "७": "7",
            "८": "8",
            "९": "9",
            "०": "0"
        }, a = e.defineLocale("ne", {
            months: "जनवरी_फेब्रुवरी_मार्च_अप्रिल_मई_जुन_जुलाई_अगष्ट_सेप्टेम्बर_अक्टोबर_नोभेम्बर_डिसेम्बर".split("_"),
            monthsShort: "जन._फेब्रु._मार्च_अप्रि._मई_जुन_जुलाई._अग._सेप्ट._अक्टो._नोभे._डिसे.".split("_"),
            weekdays: "आइतबार_सोमबार_मङ्गलबार_बुधबार_बिहिबार_शुक्रबार_शनिबार".split("_"),
            weekdaysShort: "आइत._सोम._मङ्गल._बुध._बिहि._शुक्र._शनि.".split("_"),
            weekdaysMin: "आइ._सो._मङ्_बु._बि._शु._श.".split("_"),
            longDateFormat: {
                LT: "Aको h:mm बजे",
                LTS: "Aको h:mm:ss बजे",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, Aको h:mm बजे",
                LLLL: "dddd, D MMMM YYYY, Aको h:mm बजे"
            },
            preparse: function(e) {
                return e.replace(/[१२३४५६७८९०]/g, function(e) {
                    return n[e];
                });
            },
            postformat: function(e) {
                return e.replace(/\d/g, function(e) {
                    return t[e];
                });
            },
            meridiemParse: /राती|बिहान|दिउँसो|बेलुका|साँझ|राती/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "राती" === t ? e < 3 ? e : e + 12 : "बिहान" === t ? e : "दिउँसो" === t ? e >= 10 ? e : e + 12 : "बेलुका" === t || "साँझ" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                return e < 3 ? "राती" : e < 10 ? "बिहान" : e < 15 ? "दिउँसो" : e < 18 ? "बेलुका" : e < 20 ? "साँझ" : "राती";
            },
            calendar: {
                sameDay: "[आज] LT",
                nextDay: "[भोली] LT",
                nextWeek: "[आउँदो] dddd[,] LT",
                lastDay: "[हिजो] LT",
                lastWeek: "[गएको] dddd[,] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%sमा",
                past: "%s अगाडी",
                s: "केही समय",
                m: "एक मिनेट",
                mm: "%d मिनेट",
                h: "एक घण्टा",
                hh: "%d घण्टा",
                d: "एक दिन",
                dd: "%d दिन",
                M: "एक महिना",
                MM: "%d महिना",
                y: "एक बर्ष",
                yy: "%d बर्ष"
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : dutch (nl)
    //! author : Joris Röling : https://github.com/jjupiter
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = "jan._feb._mrt._apr._mei_jun._jul._aug._sep._okt._nov._dec.".split("_"), n = "jan_feb_mrt_apr_mei_jun_jul_aug_sep_okt_nov_dec".split("_"), a = e.defineLocale("nl", {
            months: "januari_februari_maart_april_mei_juni_juli_augustus_september_oktober_november_december".split("_"),
            monthsShort: function(e, a) {
                return /-MMM-/.test(a) ? n[e.month()] : t[e.month()];
            },
            weekdays: "zondag_maandag_dinsdag_woensdag_donderdag_vrijdag_zaterdag".split("_"),
            weekdaysShort: "zo._ma._di._wo._do._vr._za.".split("_"),
            weekdaysMin: "Zo_Ma_Di_Wo_Do_Vr_Za".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD-MM-YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[vandaag om] LT",
                nextDay: "[morgen om] LT",
                nextWeek: "dddd [om] LT",
                lastDay: "[gisteren om] LT",
                lastWeek: "[afgelopen] dddd [om] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "over %s",
                past: "%s geleden",
                s: "een paar seconden",
                m: "één minuut",
                mm: "%d minuten",
                h: "één uur",
                hh: "%d uur",
                d: "één dag",
                dd: "%d dagen",
                M: "één maand",
                MM: "%d maanden",
                y: "één jaar",
                yy: "%d jaar"
            },
            ordinalParse: /\d{1,2}(ste|de)/,
            ordinal: function(e) {
                return e + (1 === e || 8 === e || e >= 20 ? "ste" : "de");
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return a;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : norwegian nynorsk (nn)
    //! author : https://github.com/mechuwind
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("nn", {
            months: "januar_februar_mars_april_mai_juni_juli_august_september_oktober_november_desember".split("_"),
            monthsShort: "jan_feb_mar_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_"),
            weekdays: "sundag_måndag_tysdag_onsdag_torsdag_fredag_laurdag".split("_"),
            weekdaysShort: "sun_mån_tys_ons_tor_fre_lau".split("_"),
            weekdaysMin: "su_må_ty_on_to_fr_lø".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[I dag klokka] LT",
                nextDay: "[I morgon klokka] LT",
                nextWeek: "dddd [klokka] LT",
                lastDay: "[I går klokka] LT",
                lastWeek: "[Føregåande] dddd [klokka] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "om %s",
                past: "for %s sidan",
                s: "nokre sekund",
                m: "eit minutt",
                mm: "%d minutt",
                h: "ein time",
                hh: "%d timar",
                d: "ein dag",
                dd: "%d dagar",
                M: "ein månad",
                MM: "%d månader",
                y: "eit år",
                yy: "%d år"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : polish (pl)
    //! author : Rafal Hirsz : https://github.com/evoL
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e) {
            return e % 10 < 5 && e % 10 > 1 && ~~(e / 10) % 10 !== 1;
        }
        function n(e, n, a) {
            var r = e + " ";
            switch (a) {
              case "m":
                return n ? "minuta" : "minutę";

              case "mm":
                return r + (t(e) ? "minuty" : "minut");

              case "h":
                return n ? "godzina" : "godzinę";

              case "hh":
                return r + (t(e) ? "godziny" : "godzin");

              case "MM":
                return r + (t(e) ? "miesiące" : "miesięcy");

              case "yy":
                return r + (t(e) ? "lata" : "lat");
            }
        }
        var a = "styczeń_luty_marzec_kwiecień_maj_czerwiec_lipiec_sierpień_wrzesień_październik_listopad_grudzień".split("_"), r = "stycznia_lutego_marca_kwietnia_maja_czerwca_lipca_sierpnia_września_października_listopada_grudnia".split("_"), i = e.defineLocale("pl", {
            months: function(e, t) {
                return "" === t ? "(" + r[e.month()] + "|" + a[e.month()] + ")" : /D MMMM/.test(t) ? r[e.month()] : a[e.month()];
            },
            monthsShort: "sty_lut_mar_kwi_maj_cze_lip_sie_wrz_paź_lis_gru".split("_"),
            weekdays: "niedziela_poniedziałek_wtorek_środa_czwartek_piątek_sobota".split("_"),
            weekdaysShort: "nie_pon_wt_śr_czw_pt_sb".split("_"),
            weekdaysMin: "N_Pn_Wt_Śr_Cz_Pt_So".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Dziś o] LT",
                nextDay: "[Jutro o] LT",
                nextWeek: "[W] dddd [o] LT",
                lastDay: "[Wczoraj o] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[W zeszłą niedzielę o] LT";

                      case 3:
                        return "[W zeszłą środę o] LT";

                      case 6:
                        return "[W zeszłą sobotę o] LT";

                      default:
                        return "[W zeszły] dddd [o] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "%s temu",
                s: "kilka sekund",
                m: n,
                mm: n,
                h: n,
                hh: n,
                d: "1 dzień",
                dd: "%d dni",
                M: "miesiąc",
                MM: n,
                y: "rok",
                yy: n
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return i;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : portuguese (pt)
    //! author : Jefferson : https://github.com/jalex79
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("pt", {
            months: "Janeiro_Fevereiro_Março_Abril_Maio_Junho_Julho_Agosto_Setembro_Outubro_Novembro_Dezembro".split("_"),
            monthsShort: "Jan_Fev_Mar_Abr_Mai_Jun_Jul_Ago_Set_Out_Nov_Dez".split("_"),
            weekdays: "Domingo_Segunda-Feira_Terça-Feira_Quarta-Feira_Quinta-Feira_Sexta-Feira_Sábado".split("_"),
            weekdaysShort: "Dom_Seg_Ter_Qua_Qui_Sex_Sáb".split("_"),
            weekdaysMin: "Dom_2ª_3ª_4ª_5ª_6ª_Sáb".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D [de] MMMM [de] YYYY",
                LLL: "D [de] MMMM [de] YYYY HH:mm",
                LLLL: "dddd, D [de] MMMM [de] YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Hoje às] LT",
                nextDay: "[Amanhã às] LT",
                nextWeek: "dddd [às] LT",
                lastDay: "[Ontem às] LT",
                lastWeek: function() {
                    return 0 === this.day() || 6 === this.day() ? "[Último] dddd [às] LT" : "[Última] dddd [às] LT";
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "em %s",
                past: "há %s",
                s: "segundos",
                m: "um minuto",
                mm: "%d minutos",
                h: "uma hora",
                hh: "%d horas",
                d: "um dia",
                dd: "%d dias",
                M: "um mês",
                MM: "%d meses",
                y: "um ano",
                yy: "%d anos"
            },
            ordinalParse: /\d{1,2}º/,
            ordinal: "%dº",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : brazilian portuguese (pt-br)
    //! author : Caio Ribeiro Pereira : https://github.com/caio-ribeiro-pereira
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("pt-br", {
            months: "Janeiro_Fevereiro_Março_Abril_Maio_Junho_Julho_Agosto_Setembro_Outubro_Novembro_Dezembro".split("_"),
            monthsShort: "Jan_Fev_Mar_Abr_Mai_Jun_Jul_Ago_Set_Out_Nov_Dez".split("_"),
            weekdays: "Domingo_Segunda-Feira_Terça-Feira_Quarta-Feira_Quinta-Feira_Sexta-Feira_Sábado".split("_"),
            weekdaysShort: "Dom_Seg_Ter_Qua_Qui_Sex_Sáb".split("_"),
            weekdaysMin: "Dom_2ª_3ª_4ª_5ª_6ª_Sáb".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D [de] MMMM [de] YYYY",
                LLL: "D [de] MMMM [de] YYYY [às] HH:mm",
                LLLL: "dddd, D [de] MMMM [de] YYYY [às] HH:mm"
            },
            calendar: {
                sameDay: "[Hoje às] LT",
                nextDay: "[Amanhã às] LT",
                nextWeek: "dddd [às] LT",
                lastDay: "[Ontem às] LT",
                lastWeek: function() {
                    return 0 === this.day() || 6 === this.day() ? "[Último] dddd [às] LT" : "[Última] dddd [às] LT";
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "em %s",
                past: "%s atrás",
                s: "poucos segundos",
                m: "um minuto",
                mm: "%d minutos",
                h: "uma hora",
                hh: "%d horas",
                d: "um dia",
                dd: "%d dias",
                M: "um mês",
                MM: "%d meses",
                y: "um ano",
                yy: "%d anos"
            },
            ordinalParse: /\d{1,2}º/,
            ordinal: "%dº"
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : romanian (ro)
    //! author : Vlad Gurdiga : https://github.com/gurdiga
    //! author : Valentin Agachi : https://github.com/avaly
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n) {
            var a = {
                mm: "minute",
                hh: "ore",
                dd: "zile",
                MM: "luni",
                yy: "ani"
            }, r = " ";
            return (e % 100 >= 20 || e >= 100 && e % 100 === 0) && (r = " de "), e + r + a[n];
        }
        var n = e.defineLocale("ro", {
            months: "ianuarie_februarie_martie_aprilie_mai_iunie_iulie_august_septembrie_octombrie_noiembrie_decembrie".split("_"),
            monthsShort: "ian._febr._mart._apr._mai_iun._iul._aug._sept._oct._nov._dec.".split("_"),
            weekdays: "duminică_luni_marți_miercuri_joi_vineri_sâmbătă".split("_"),
            weekdaysShort: "Dum_Lun_Mar_Mie_Joi_Vin_Sâm".split("_"),
            weekdaysMin: "Du_Lu_Ma_Mi_Jo_Vi_Sâ".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY H:mm",
                LLLL: "dddd, D MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[azi la] LT",
                nextDay: "[mâine la] LT",
                nextWeek: "dddd [la] LT",
                lastDay: "[ieri la] LT",
                lastWeek: "[fosta] dddd [la] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "peste %s",
                past: "%s în urmă",
                s: "câteva secunde",
                m: "un minut",
                mm: t,
                h: "o oră",
                hh: t,
                d: "o zi",
                dd: t,
                M: "o lună",
                MM: t,
                y: "un an",
                yy: t
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : russian (ru)
    //! author : Viktorminator : https://github.com/Viktorminator
    //! Author : Menelion Elensúle : https://github.com/Oire
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t) {
            var n = e.split("_");
            return t % 10 === 1 && t % 100 !== 11 ? n[0] : t % 10 >= 2 && t % 10 <= 4 && (t % 100 < 10 || t % 100 >= 20) ? n[1] : n[2];
        }
        function n(e, n, a) {
            var r = {
                mm: n ? "минута_минуты_минут" : "минуту_минуты_минут",
                hh: "час_часа_часов",
                dd: "день_дня_дней",
                MM: "месяц_месяца_месяцев",
                yy: "год_года_лет"
            };
            return "m" === a ? n ? "минута" : "минуту" : e + " " + t(r[a], +e);
        }
        function a(e, t) {
            var n = {
                nominative: "январь_февраль_март_апрель_май_июнь_июль_август_сентябрь_октябрь_ноябрь_декабрь".split("_"),
                accusative: "января_февраля_марта_апреля_мая_июня_июля_августа_сентября_октября_ноября_декабря".split("_")
            }, a = /D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function r(e, t) {
            var n = {
                nominative: "янв_фев_март_апр_май_июнь_июль_авг_сен_окт_ноя_дек".split("_"),
                accusative: "янв_фев_мар_апр_мая_июня_июля_авг_сен_окт_ноя_дек".split("_")
            }, a = /D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function i(e, t) {
            var n = {
                nominative: "воскресенье_понедельник_вторник_среда_четверг_пятница_суббота".split("_"),
                accusative: "воскресенье_понедельник_вторник_среду_четверг_пятницу_субботу".split("_")
            }, a = /\[ ?[Вв] ?(?:прошлую|следующую|эту)? ?\] ?dddd/.test(t) ? "accusative" : "nominative";
            return n[a][e.day()];
        }
        var s = e.defineLocale("ru", {
            months: a,
            monthsShort: r,
            weekdays: i,
            weekdaysShort: "вс_пн_вт_ср_чт_пт_сб".split("_"),
            weekdaysMin: "вс_пн_вт_ср_чт_пт_сб".split("_"),
            monthsParse: [ /^янв/i, /^фев/i, /^мар/i, /^апр/i, /^ма[й|я]/i, /^июн/i, /^июл/i, /^авг/i, /^сен/i, /^окт/i, /^ноя/i, /^дек/i ],
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY г.",
                LLL: "D MMMM YYYY г., HH:mm",
                LLLL: "dddd, D MMMM YYYY г., HH:mm"
            },
            calendar: {
                sameDay: "[Сегодня в] LT",
                nextDay: "[Завтра в] LT",
                lastDay: "[Вчера в] LT",
                nextWeek: function() {
                    return 2 === this.day() ? "[Во] dddd [в] LT" : "[В] dddd [в] LT";
                },
                lastWeek: function(e) {
                    if (e.week() === this.week()) return 2 === this.day() ? "[Во] dddd [в] LT" : "[В] dddd [в] LT";
                    switch (this.day()) {
                      case 0:
                        return "[В прошлое] dddd [в] LT";

                      case 1:
                      case 2:
                      case 4:
                        return "[В прошлый] dddd [в] LT";

                      case 3:
                      case 5:
                      case 6:
                        return "[В прошлую] dddd [в] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "через %s",
                past: "%s назад",
                s: "несколько секунд",
                m: n,
                mm: n,
                h: "час",
                hh: n,
                d: "день",
                dd: n,
                M: "месяц",
                MM: n,
                y: "год",
                yy: n
            },
            meridiemParse: /ночи|утра|дня|вечера/i,
            isPM: function(e) {
                return /^(дня|вечера)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "ночи" : e < 12 ? "утра" : e < 17 ? "дня" : "вечера";
            },
            ordinalParse: /\d{1,2}-(й|го|я)/,
            ordinal: function(e, t) {
                switch (t) {
                  case "M":
                  case "d":
                  case "DDD":
                    return e + "-й";

                  case "D":
                    return e + "-го";

                  case "w":
                  case "W":
                    return e + "-я";

                  default:
                    return e;
                }
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return s;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Sinhalese (si)
    //! author : Sampath Sitinamaluwa : https://github.com/sampathsris
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("si", {
            months: "ජනවාරි_පෙබරවාරි_මාර්තු_අප්‍රේල්_මැයි_ජූනි_ජූලි_අගෝස්තු_සැප්තැම්බර්_ඔක්තෝබර්_නොවැම්බර්_දෙසැම්බර්".split("_"),
            monthsShort: "ජන_පෙබ_මාර්_අප්_මැයි_ජූනි_ජූලි_අගෝ_සැප්_ඔක්_නොවැ_දෙසැ".split("_"),
            weekdays: "ඉරිදා_සඳුදා_අඟහරුවාදා_බදාදා_බ්‍රහස්පතින්දා_සිකුරාදා_සෙනසුරාදා".split("_"),
            weekdaysShort: "ඉරි_සඳු_අඟ_බදා_බ්‍රහ_සිකු_සෙන".split("_"),
            weekdaysMin: "ඉ_ස_අ_බ_බ්‍ර_සි_සෙ".split("_"),
            longDateFormat: {
                LT: "a h:mm",
                LTS: "a h:mm:ss",
                L: "YYYY/MM/DD",
                LL: "YYYY MMMM D",
                LLL: "YYYY MMMM D, a h:mm",
                LLLL: "YYYY MMMM D [වැනි] dddd, a h:mm:ss"
            },
            calendar: {
                sameDay: "[අද] LT[ට]",
                nextDay: "[හෙට] LT[ට]",
                nextWeek: "dddd LT[ට]",
                lastDay: "[ඊයේ] LT[ට]",
                lastWeek: "[පසුගිය] dddd LT[ට]",
                sameElse: "L"
            },
            relativeTime: {
                future: "%sකින්",
                past: "%sකට පෙර",
                s: "තත්පර කිහිපය",
                m: "මිනිත්තුව",
                mm: "මිනිත්තු %d",
                h: "පැය",
                hh: "පැය %d",
                d: "දිනය",
                dd: "දින %d",
                M: "මාසය",
                MM: "මාස %d",
                y: "වසර",
                yy: "වසර %d"
            },
            ordinalParse: /\d{1,2} වැනි/,
            ordinal: function(e) {
                return e + " වැනි";
            },
            meridiem: function(e, t, n) {
                return e > 11 ? n ? "ප.ව." : "පස් වරු" : n ? "පෙ.ව." : "පෙර වරු";
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : slovak (sk)
    //! author : Martin Minka : https://github.com/k2s
    //! based on work of petrbela : https://github.com/petrbela
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e) {
            return e > 1 && e < 5;
        }
        function n(e, n, a, r) {
            var i = e + " ";
            switch (a) {
              case "s":
                return n || r ? "pár sekúnd" : "pár sekundami";

              case "m":
                return n ? "minúta" : r ? "minútu" : "minútou";

              case "mm":
                return n || r ? i + (t(e) ? "minúty" : "minút") : i + "minútami";

              case "h":
                return n ? "hodina" : r ? "hodinu" : "hodinou";

              case "hh":
                return n || r ? i + (t(e) ? "hodiny" : "hodín") : i + "hodinami";

              case "d":
                return n || r ? "deň" : "dňom";

              case "dd":
                return n || r ? i + (t(e) ? "dni" : "dní") : i + "dňami";

              case "M":
                return n || r ? "mesiac" : "mesiacom";

              case "MM":
                return n || r ? i + (t(e) ? "mesiace" : "mesiacov") : i + "mesiacmi";

              case "y":
                return n || r ? "rok" : "rokom";

              case "yy":
                return n || r ? i + (t(e) ? "roky" : "rokov") : i + "rokmi";
            }
        }
        var a = "január_február_marec_apríl_máj_jún_júl_august_september_október_november_december".split("_"), r = "jan_feb_mar_apr_máj_jún_júl_aug_sep_okt_nov_dec".split("_"), i = e.defineLocale("sk", {
            months: a,
            monthsShort: r,
            monthsParse: function(e, t) {
                var n, a = [];
                for (n = 0; n < 12; n++) a[n] = new RegExp("^" + e[n] + "$|^" + t[n] + "$", "i");
                return a;
            }(a, r),
            weekdays: "nedeľa_pondelok_utorok_streda_štvrtok_piatok_sobota".split("_"),
            weekdaysShort: "ne_po_ut_st_št_pi_so".split("_"),
            weekdaysMin: "ne_po_ut_st_št_pi_so".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[dnes o] LT",
                nextDay: "[zajtra o] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[v nedeľu o] LT";

                      case 1:
                      case 2:
                        return "[v] dddd [o] LT";

                      case 3:
                        return "[v stredu o] LT";

                      case 4:
                        return "[vo štvrtok o] LT";

                      case 5:
                        return "[v piatok o] LT";

                      case 6:
                        return "[v sobotu o] LT";
                    }
                },
                lastDay: "[včera o] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[minulú nedeľu o] LT";

                      case 1:
                      case 2:
                        return "[minulý] dddd [o] LT";

                      case 3:
                        return "[minulú stredu o] LT";

                      case 4:
                      case 5:
                        return "[minulý] dddd [o] LT";

                      case 6:
                        return "[minulú sobotu o] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "pred %s",
                s: n,
                m: n,
                mm: n,
                h: n,
                hh: n,
                d: n,
                dd: n,
                M: n,
                MM: n,
                y: n,
                yy: n
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return i;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : slovenian (sl)
    //! author : Robert Sedovšek : https://github.com/sedovsek
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var r = e + " ";
            switch (n) {
              case "s":
                return t || a ? "nekaj sekund" : "nekaj sekundami";

              case "m":
                return t ? "ena minuta" : "eno minuto";

              case "mm":
                return r += 1 === e ? t ? "minuta" : "minuto" : 2 === e ? t || a ? "minuti" : "minutama" : e < 5 ? t || a ? "minute" : "minutami" : t || a ? "minut" : "minutami";

              case "h":
                return t ? "ena ura" : "eno uro";

              case "hh":
                return r += 1 === e ? t ? "ura" : "uro" : 2 === e ? t || a ? "uri" : "urama" : e < 5 ? t || a ? "ure" : "urami" : t || a ? "ur" : "urami";

              case "d":
                return t || a ? "en dan" : "enim dnem";

              case "dd":
                return r += 1 === e ? t || a ? "dan" : "dnem" : 2 === e ? t || a ? "dni" : "dnevoma" : t || a ? "dni" : "dnevi";

              case "M":
                return t || a ? "en mesec" : "enim mesecem";

              case "MM":
                return r += 1 === e ? t || a ? "mesec" : "mesecem" : 2 === e ? t || a ? "meseca" : "mesecema" : e < 5 ? t || a ? "mesece" : "meseci" : t || a ? "mesecev" : "meseci";

              case "y":
                return t || a ? "eno leto" : "enim letom";

              case "yy":
                return r += 1 === e ? t || a ? "leto" : "letom" : 2 === e ? t || a ? "leti" : "letoma" : e < 5 ? t || a ? "leta" : "leti" : t || a ? "let" : "leti";
            }
        }
        var n = e.defineLocale("sl", {
            months: "januar_februar_marec_april_maj_junij_julij_avgust_september_oktober_november_december".split("_"),
            monthsShort: "jan._feb._mar._apr._maj._jun._jul._avg._sep._okt._nov._dec.".split("_"),
            weekdays: "nedelja_ponedeljek_torek_sreda_četrtek_petek_sobota".split("_"),
            weekdaysShort: "ned._pon._tor._sre._čet._pet._sob.".split("_"),
            weekdaysMin: "ne_po_to_sr_če_pe_so".split("_"),
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD. MM. YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[danes ob] LT",
                nextDay: "[jutri ob] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[v] [nedeljo] [ob] LT";

                      case 3:
                        return "[v] [sredo] [ob] LT";

                      case 6:
                        return "[v] [soboto] [ob] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[v] dddd [ob] LT";
                    }
                },
                lastDay: "[včeraj ob] LT",
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[prejšnjo] [nedeljo] [ob] LT";

                      case 3:
                        return "[prejšnjo] [sredo] [ob] LT";

                      case 6:
                        return "[prejšnjo] [soboto] [ob] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[prejšnji] dddd [ob] LT";
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "čez %s",
                past: "pred %s",
                s: t,
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: t,
                dd: t,
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Albanian (sq)
    //! author : Flakërim Ismani : https://github.com/flakerimi
    //! author: Menelion Elensúle: https://github.com/Oire (tests)
    //! author : Oerd Cukalla : https://github.com/oerd (fixes)
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("sq", {
            months: "Janar_Shkurt_Mars_Prill_Maj_Qershor_Korrik_Gusht_Shtator_Tetor_Nëntor_Dhjetor".split("_"),
            monthsShort: "Jan_Shk_Mar_Pri_Maj_Qer_Kor_Gus_Sht_Tet_Nën_Dhj".split("_"),
            weekdays: "E Diel_E Hënë_E Martë_E Mërkurë_E Enjte_E Premte_E Shtunë".split("_"),
            weekdaysShort: "Die_Hën_Mar_Mër_Enj_Pre_Sht".split("_"),
            weekdaysMin: "D_H_Ma_Më_E_P_Sh".split("_"),
            meridiemParse: /PD|MD/,
            isPM: function(e) {
                return "M" === e.charAt(0);
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "PD" : "MD";
            },
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Sot në] LT",
                nextDay: "[Nesër në] LT",
                nextWeek: "dddd [në] LT",
                lastDay: "[Dje në] LT",
                lastWeek: "dddd [e kaluar në] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "në %s",
                past: "%s më parë",
                s: "disa sekonda",
                m: "një minutë",
                mm: "%d minuta",
                h: "një orë",
                hh: "%d orë",
                d: "një ditë",
                dd: "%d ditë",
                M: "një muaj",
                MM: "%d muaj",
                y: "një vit",
                yy: "%d vite"
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Serbian-latin (sr)
    //! author : Milan Janačković<milanjanackovic@gmail.com> : https://github.com/milan-j
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            words: {
                m: [ "jedan minut", "jedne minute" ],
                mm: [ "minut", "minute", "minuta" ],
                h: [ "jedan sat", "jednog sata" ],
                hh: [ "sat", "sata", "sati" ],
                dd: [ "dan", "dana", "dana" ],
                MM: [ "mesec", "meseca", "meseci" ],
                yy: [ "godina", "godine", "godina" ]
            },
            correctGrammaticalCase: function(e, t) {
                return 1 === e ? t[0] : e >= 2 && e <= 4 ? t[1] : t[2];
            },
            translate: function(e, n, a) {
                var r = t.words[a];
                return 1 === a.length ? n ? r[0] : r[1] : e + " " + t.correctGrammaticalCase(e, r);
            }
        }, n = e.defineLocale("sr", {
            months: [ "januar", "februar", "mart", "april", "maj", "jun", "jul", "avgust", "septembar", "oktobar", "novembar", "decembar" ],
            monthsShort: [ "jan.", "feb.", "mar.", "apr.", "maj", "jun", "jul", "avg.", "sep.", "okt.", "nov.", "dec." ],
            weekdays: [ "nedelja", "ponedeljak", "utorak", "sreda", "četvrtak", "petak", "subota" ],
            weekdaysShort: [ "ned.", "pon.", "uto.", "sre.", "čet.", "pet.", "sub." ],
            weekdaysMin: [ "ne", "po", "ut", "sr", "če", "pe", "su" ],
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD. MM. YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[danas u] LT",
                nextDay: "[sutra u] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[u] [nedelju] [u] LT";

                      case 3:
                        return "[u] [sredu] [u] LT";

                      case 6:
                        return "[u] [subotu] [u] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[u] dddd [u] LT";
                    }
                },
                lastDay: "[juče u] LT",
                lastWeek: function() {
                    var e = [ "[prošle] [nedelje] [u] LT", "[prošlog] [ponedeljka] [u] LT", "[prošlog] [utorka] [u] LT", "[prošle] [srede] [u] LT", "[prošlog] [četvrtka] [u] LT", "[prošlog] [petka] [u] LT", "[prošle] [subote] [u] LT" ];
                    return e[this.day()];
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "za %s",
                past: "pre %s",
                s: "nekoliko sekundi",
                m: t.translate,
                mm: t.translate,
                h: t.translate,
                hh: t.translate,
                d: "dan",
                dd: t.translate,
                M: "mesec",
                MM: t.translate,
                y: "godinu",
                yy: t.translate
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Serbian-cyrillic (sr-cyrl)
    //! author : Milan Janačković<milanjanackovic@gmail.com> : https://github.com/milan-j
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            words: {
                m: [ "један минут", "једне минуте" ],
                mm: [ "минут", "минуте", "минута" ],
                h: [ "један сат", "једног сата" ],
                hh: [ "сат", "сата", "сати" ],
                dd: [ "дан", "дана", "дана" ],
                MM: [ "месец", "месеца", "месеци" ],
                yy: [ "година", "године", "година" ]
            },
            correctGrammaticalCase: function(e, t) {
                return 1 === e ? t[0] : e >= 2 && e <= 4 ? t[1] : t[2];
            },
            translate: function(e, n, a) {
                var r = t.words[a];
                return 1 === a.length ? n ? r[0] : r[1] : e + " " + t.correctGrammaticalCase(e, r);
            }
        }, n = e.defineLocale("sr-cyrl", {
            months: [ "јануар", "фебруар", "март", "април", "мај", "јун", "јул", "август", "септембар", "октобар", "новембар", "децембар" ],
            monthsShort: [ "јан.", "феб.", "мар.", "апр.", "мај", "јун", "јул", "авг.", "сеп.", "окт.", "нов.", "дец." ],
            weekdays: [ "недеља", "понедељак", "уторак", "среда", "четвртак", "петак", "субота" ],
            weekdaysShort: [ "нед.", "пон.", "уто.", "сре.", "чет.", "пет.", "суб." ],
            weekdaysMin: [ "не", "по", "ут", "ср", "че", "пе", "су" ],
            longDateFormat: {
                LT: "H:mm",
                LTS: "H:mm:ss",
                L: "DD. MM. YYYY",
                LL: "D. MMMM YYYY",
                LLL: "D. MMMM YYYY H:mm",
                LLLL: "dddd, D. MMMM YYYY H:mm"
            },
            calendar: {
                sameDay: "[данас у] LT",
                nextDay: "[сутра у] LT",
                nextWeek: function() {
                    switch (this.day()) {
                      case 0:
                        return "[у] [недељу] [у] LT";

                      case 3:
                        return "[у] [среду] [у] LT";

                      case 6:
                        return "[у] [суботу] [у] LT";

                      case 1:
                      case 2:
                      case 4:
                      case 5:
                        return "[у] dddd [у] LT";
                    }
                },
                lastDay: "[јуче у] LT",
                lastWeek: function() {
                    var e = [ "[прошле] [недеље] [у] LT", "[прошлог] [понедељка] [у] LT", "[прошлог] [уторка] [у] LT", "[прошле] [среде] [у] LT", "[прошлог] [четвртка] [у] LT", "[прошлог] [петка] [у] LT", "[прошле] [суботе] [у] LT" ];
                    return e[this.day()];
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "за %s",
                past: "пре %s",
                s: "неколико секунди",
                m: t.translate,
                mm: t.translate,
                h: t.translate,
                hh: t.translate,
                d: "дан",
                dd: t.translate,
                M: "месец",
                MM: t.translate,
                y: "годину",
                yy: t.translate
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : swedish (sv)
    //! author : Jens Alm : https://github.com/ulmus
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("sv", {
            months: "januari_februari_mars_april_maj_juni_juli_augusti_september_oktober_november_december".split("_"),
            monthsShort: "jan_feb_mar_apr_maj_jun_jul_aug_sep_okt_nov_dec".split("_"),
            weekdays: "söndag_måndag_tisdag_onsdag_torsdag_fredag_lördag".split("_"),
            weekdaysShort: "sön_mån_tis_ons_tor_fre_lör".split("_"),
            weekdaysMin: "sö_må_ti_on_to_fr_lö".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "YYYY-MM-DD",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Idag] LT",
                nextDay: "[Imorgon] LT",
                lastDay: "[Igår] LT",
                nextWeek: "[På] dddd LT",
                lastWeek: "[I] dddd[s] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "om %s",
                past: "för %s sedan",
                s: "några sekunder",
                m: "en minut",
                mm: "%d minuter",
                h: "en timme",
                hh: "%d timmar",
                d: "en dag",
                dd: "%d dagar",
                M: "en månad",
                MM: "%d månader",
                y: "ett år",
                yy: "%d år"
            },
            ordinalParse: /\d{1,2}(e|a)/,
            ordinal: function(e) {
                var t = e % 10, n = 1 === ~~(e % 100 / 10) ? "e" : 1 === t ? "a" : 2 === t ? "a" : "e";
                return e + n;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : tamil (ta)
    //! author : Arjunkumar Krishnamoorthy : https://github.com/tk120404
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("ta", {
            months: "ஜனவரி_பிப்ரவரி_மார்ச்_ஏப்ரல்_மே_ஜூன்_ஜூலை_ஆகஸ்ட்_செப்டெம்பர்_அக்டோபர்_நவம்பர்_டிசம்பர்".split("_"),
            monthsShort: "ஜனவரி_பிப்ரவரி_மார்ச்_ஏப்ரல்_மே_ஜூன்_ஜூலை_ஆகஸ்ட்_செப்டெம்பர்_அக்டோபர்_நவம்பர்_டிசம்பர்".split("_"),
            weekdays: "ஞாயிற்றுக்கிழமை_திங்கட்கிழமை_செவ்வாய்கிழமை_புதன்கிழமை_வியாழக்கிழமை_வெள்ளிக்கிழமை_சனிக்கிழமை".split("_"),
            weekdaysShort: "ஞாயிறு_திங்கள்_செவ்வாய்_புதன்_வியாழன்_வெள்ளி_சனி".split("_"),
            weekdaysMin: "ஞா_தி_செ_பு_வி_வெ_ச".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY, HH:mm",
                LLLL: "dddd, D MMMM YYYY, HH:mm"
            },
            calendar: {
                sameDay: "[இன்று] LT",
                nextDay: "[நாளை] LT",
                nextWeek: "dddd, LT",
                lastDay: "[நேற்று] LT",
                lastWeek: "[கடந்த வாரம்] dddd, LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s இல்",
                past: "%s முன்",
                s: "ஒரு சில விநாடிகள்",
                m: "ஒரு நிமிடம்",
                mm: "%d நிமிடங்கள்",
                h: "ஒரு மணி நேரம்",
                hh: "%d மணி நேரம்",
                d: "ஒரு நாள்",
                dd: "%d நாட்கள்",
                M: "ஒரு மாதம்",
                MM: "%d மாதங்கள்",
                y: "ஒரு வருடம்",
                yy: "%d ஆண்டுகள்"
            },
            ordinalParse: /\d{1,2}வது/,
            ordinal: function(e) {
                return e + "வது";
            },
            meridiemParse: /யாமம்|வைகறை|காலை|நண்பகல்|எற்பாடு|மாலை/,
            meridiem: function(e, t, n) {
                return e < 2 ? " யாமம்" : e < 6 ? " வைகறை" : e < 10 ? " காலை" : e < 14 ? " நண்பகல்" : e < 18 ? " எற்பாடு" : e < 22 ? " மாலை" : " யாமம்";
            },
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "யாமம்" === t ? e < 2 ? e : e + 12 : "வைகறை" === t || "காலை" === t ? e : "நண்பகல்" === t && e >= 10 ? e : e + 12;
            },
            week: {
                dow: 0,
                doy: 6
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : thai (th)
    //! author : Kridsada Thanabulpong : https://github.com/sirn
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("th", {
            months: "มกราคม_กุมภาพันธ์_มีนาคม_เมษายน_พฤษภาคม_มิถุนายน_กรกฎาคม_สิงหาคม_กันยายน_ตุลาคม_พฤศจิกายน_ธันวาคม".split("_"),
            monthsShort: "มกรา_กุมภา_มีนา_เมษา_พฤษภา_มิถุนา_กรกฎา_สิงหา_กันยา_ตุลา_พฤศจิกา_ธันวา".split("_"),
            weekdays: "อาทิตย์_จันทร์_อังคาร_พุธ_พฤหัสบดี_ศุกร์_เสาร์".split("_"),
            weekdaysShort: "อาทิตย์_จันทร์_อังคาร_พุธ_พฤหัส_ศุกร์_เสาร์".split("_"),
            weekdaysMin: "อา._จ._อ._พ._พฤ._ศ._ส.".split("_"),
            longDateFormat: {
                LT: "H นาฬิกา m นาที",
                LTS: "H นาฬิกา m นาที s วินาที",
                L: "YYYY/MM/DD",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY เวลา H นาฬิกา m นาที",
                LLLL: "วันddddที่ D MMMM YYYY เวลา H นาฬิกา m นาที"
            },
            meridiemParse: /ก่อนเที่ยง|หลังเที่ยง/,
            isPM: function(e) {
                return "หลังเที่ยง" === e;
            },
            meridiem: function(e, t, n) {
                return e < 12 ? "ก่อนเที่ยง" : "หลังเที่ยง";
            },
            calendar: {
                sameDay: "[วันนี้ เวลา] LT",
                nextDay: "[พรุ่งนี้ เวลา] LT",
                nextWeek: "dddd[หน้า เวลา] LT",
                lastDay: "[เมื่อวานนี้ เวลา] LT",
                lastWeek: "[วัน]dddd[ที่แล้ว เวลา] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "อีก %s",
                past: "%sที่แล้ว",
                s: "ไม่กี่วินาที",
                m: "1 นาที",
                mm: "%d นาที",
                h: "1 ชั่วโมง",
                hh: "%d ชั่วโมง",
                d: "1 วัน",
                dd: "%d วัน",
                M: "1 เดือน",
                MM: "%d เดือน",
                y: "1 ปี",
                yy: "%d ปี"
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Tagalog/Filipino (tl-ph)
    //! author : Dan Hagman
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("tl-ph", {
            months: "Enero_Pebrero_Marso_Abril_Mayo_Hunyo_Hulyo_Agosto_Setyembre_Oktubre_Nobyembre_Disyembre".split("_"),
            monthsShort: "Ene_Peb_Mar_Abr_May_Hun_Hul_Ago_Set_Okt_Nob_Dis".split("_"),
            weekdays: "Linggo_Lunes_Martes_Miyerkules_Huwebes_Biyernes_Sabado".split("_"),
            weekdaysShort: "Lin_Lun_Mar_Miy_Huw_Biy_Sab".split("_"),
            weekdaysMin: "Li_Lu_Ma_Mi_Hu_Bi_Sab".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "MM/D/YYYY",
                LL: "MMMM D, YYYY",
                LLL: "MMMM D, YYYY HH:mm",
                LLLL: "dddd, MMMM DD, YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Ngayon sa] LT",
                nextDay: "[Bukas sa] LT",
                nextWeek: "dddd [sa] LT",
                lastDay: "[Kahapon sa] LT",
                lastWeek: "dddd [huling linggo] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "sa loob ng %s",
                past: "%s ang nakalipas",
                s: "ilang segundo",
                m: "isang minuto",
                mm: "%d minuto",
                h: "isang oras",
                hh: "%d oras",
                d: "isang araw",
                dd: "%d araw",
                M: "isang buwan",
                MM: "%d buwan",
                y: "isang taon",
                yy: "%d taon"
            },
            ordinalParse: /\d{1,2}/,
            ordinal: function(e) {
                return e;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : turkish (tr)
    //! authors : Erhan Gundogan : https://github.com/erhangundogan,
    //!           Burak Yiğit Kaya: https://github.com/BYK
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = {
            1: "'inci",
            5: "'inci",
            8: "'inci",
            70: "'inci",
            80: "'inci",
            2: "'nci",
            7: "'nci",
            20: "'nci",
            50: "'nci",
            3: "'üncü",
            4: "'üncü",
            100: "'üncü",
            6: "'ncı",
            9: "'uncu",
            10: "'uncu",
            30: "'uncu",
            60: "'ıncı",
            90: "'ıncı"
        }, n = e.defineLocale("tr", {
            months: "Ocak_Şubat_Mart_Nisan_Mayıs_Haziran_Temmuz_Ağustos_Eylül_Ekim_Kasım_Aralık".split("_"),
            monthsShort: "Oca_Şub_Mar_Nis_May_Haz_Tem_Ağu_Eyl_Eki_Kas_Ara".split("_"),
            weekdays: "Pazar_Pazartesi_Salı_Çarşamba_Perşembe_Cuma_Cumartesi".split("_"),
            weekdaysShort: "Paz_Pts_Sal_Çar_Per_Cum_Cts".split("_"),
            weekdaysMin: "Pz_Pt_Sa_Ça_Pe_Cu_Ct".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd, D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[bugün saat] LT",
                nextDay: "[yarın saat] LT",
                nextWeek: "[haftaya] dddd [saat] LT",
                lastDay: "[dün] LT",
                lastWeek: "[geçen hafta] dddd [saat] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s sonra",
                past: "%s önce",
                s: "birkaç saniye",
                m: "bir dakika",
                mm: "%d dakika",
                h: "bir saat",
                hh: "%d saat",
                d: "bir gün",
                dd: "%d gün",
                M: "bir ay",
                MM: "%d ay",
                y: "bir yıl",
                yy: "%d yıl"
            },
            ordinalParse: /\d{1,2}'(inci|nci|üncü|ncı|uncu|ıncı)/,
            ordinal: function(e) {
                if (0 === e) return e + "'ıncı";
                var n = e % 10, a = e % 100 - n, r = e >= 100 ? 100 : null;
                return e + (t[n] || t[a] || t[r]);
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : talossan (tzl)
    //! author : Robin van der Vliet : https://github.com/robin0van0der0v with the help of Iustì Canun
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t, n, a) {
            var r = {
                s: [ "viensas secunds", "'iensas secunds" ],
                m: [ "'n míut", "'iens míut" ],
                mm: [ e + " míuts", " " + e + " míuts" ],
                h: [ "'n þora", "'iensa þora" ],
                hh: [ e + " þoras", " " + e + " þoras" ],
                d: [ "'n ziua", "'iensa ziua" ],
                dd: [ e + " ziuas", " " + e + " ziuas" ],
                M: [ "'n mes", "'iens mes" ],
                MM: [ e + " mesen", " " + e + " mesen" ],
                y: [ "'n ar", "'iens ar" ],
                yy: [ e + " ars", " " + e + " ars" ]
            };
            return a ? r[n][0] : t ? r[n][0] : r[n][1].trim();
        }
        var n = e.defineLocale("tzl", {
            months: "Januar_Fevraglh_Març_Avrïu_Mai_Gün_Julia_Guscht_Setemvar_Listopäts_Noemvar_Zecemvar".split("_"),
            monthsShort: "Jan_Fev_Mar_Avr_Mai_Gün_Jul_Gus_Set_Lis_Noe_Zec".split("_"),
            weekdays: "Súladi_Lúneçi_Maitzi_Márcuri_Xhúadi_Viénerçi_Sáturi".split("_"),
            weekdaysShort: "Súl_Lún_Mai_Már_Xhú_Vié_Sát".split("_"),
            weekdaysMin: "Sú_Lú_Ma_Má_Xh_Vi_Sá".split("_"),
            longDateFormat: {
                LT: "HH.mm",
                LTS: "LT.ss",
                L: "DD.MM.YYYY",
                LL: "D. MMMM [dallas] YYYY",
                LLL: "D. MMMM [dallas] YYYY LT",
                LLLL: "dddd, [li] D. MMMM [dallas] YYYY LT"
            },
            meridiem: function(e, t, n) {
                return e > 11 ? n ? "d'o" : "D'O" : n ? "d'a" : "D'A";
            },
            calendar: {
                sameDay: "[oxhi à] LT",
                nextDay: "[demà à] LT",
                nextWeek: "dddd [à] LT",
                lastDay: "[ieiri à] LT",
                lastWeek: "[sür el] dddd [lasteu à] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "osprei %s",
                past: "ja%s",
                s: t,
                m: t,
                mm: t,
                h: t,
                hh: t,
                d: t,
                dd: t,
                M: t,
                MM: t,
                y: t,
                yy: t
            },
            ordinalParse: /\d{1,2}\./,
            ordinal: "%d.",
            week: {
                dow: 1,
                doy: 4
            }
        });
        return n;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Morocco Central Atlas Tamaziɣt (tzm)
    //! author : Abdel Said : https://github.com/abdelsaid
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("tzm", {
            months: "ⵉⵏⵏⴰⵢⵔ_ⴱⵕⴰⵢⵕ_ⵎⴰⵕⵚ_ⵉⴱⵔⵉⵔ_ⵎⴰⵢⵢⵓ_ⵢⵓⵏⵢⵓ_ⵢⵓⵍⵢⵓⵣ_ⵖⵓⵛⵜ_ⵛⵓⵜⴰⵏⴱⵉⵔ_ⴽⵟⵓⴱⵕ_ⵏⵓⵡⴰⵏⴱⵉⵔ_ⴷⵓⵊⵏⴱⵉⵔ".split("_"),
            monthsShort: "ⵉⵏⵏⴰⵢⵔ_ⴱⵕⴰⵢⵕ_ⵎⴰⵕⵚ_ⵉⴱⵔⵉⵔ_ⵎⴰⵢⵢⵓ_ⵢⵓⵏⵢⵓ_ⵢⵓⵍⵢⵓⵣ_ⵖⵓⵛⵜ_ⵛⵓⵜⴰⵏⴱⵉⵔ_ⴽⵟⵓⴱⵕ_ⵏⵓⵡⴰⵏⴱⵉⵔ_ⴷⵓⵊⵏⴱⵉⵔ".split("_"),
            weekdays: "ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ".split("_"),
            weekdaysShort: "ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ".split("_"),
            weekdaysMin: "ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[ⴰⵙⴷⵅ ⴴ] LT",
                nextDay: "[ⴰⵙⴽⴰ ⴴ] LT",
                nextWeek: "dddd [ⴴ] LT",
                lastDay: "[ⴰⵚⴰⵏⵜ ⴴ] LT",
                lastWeek: "dddd [ⴴ] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "ⴷⴰⴷⵅ ⵙ ⵢⴰⵏ %s",
                past: "ⵢⴰⵏ %s",
                s: "ⵉⵎⵉⴽ",
                m: "ⵎⵉⵏⵓⴺ",
                mm: "%d ⵎⵉⵏⵓⴺ",
                h: "ⵙⴰⵄⴰ",
                hh: "%d ⵜⴰⵙⵙⴰⵄⵉⵏ",
                d: "ⴰⵙⵙ",
                dd: "%d oⵙⵙⴰⵏ",
                M: "ⴰⵢoⵓⵔ",
                MM: "%d ⵉⵢⵢⵉⵔⵏ",
                y: "ⴰⵙⴳⴰⵙ",
                yy: "%d ⵉⵙⴳⴰⵙⵏ"
            },
            week: {
                dow: 6,
                doy: 12
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : Morocco Central Atlas Tamaziɣt in Latin (tzm-latn)
    //! author : Abdel Said : https://github.com/abdelsaid
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("tzm-latn", {
            months: "innayr_brˤayrˤ_marˤsˤ_ibrir_mayyw_ywnyw_ywlywz_ɣwšt_šwtanbir_ktˤwbrˤ_nwwanbir_dwjnbir".split("_"),
            monthsShort: "innayr_brˤayrˤ_marˤsˤ_ibrir_mayyw_ywnyw_ywlywz_ɣwšt_šwtanbir_ktˤwbrˤ_nwwanbir_dwjnbir".split("_"),
            weekdays: "asamas_aynas_asinas_akras_akwas_asimwas_asiḍyas".split("_"),
            weekdaysShort: "asamas_aynas_asinas_akras_akwas_asimwas_asiḍyas".split("_"),
            weekdaysMin: "asamas_aynas_asinas_akras_akwas_asimwas_asiḍyas".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "dddd D MMMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[asdkh g] LT",
                nextDay: "[aska g] LT",
                nextWeek: "dddd [g] LT",
                lastDay: "[assant g] LT",
                lastWeek: "dddd [g] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "dadkh s yan %s",
                past: "yan %s",
                s: "imik",
                m: "minuḍ",
                mm: "%d minuḍ",
                h: "saɛa",
                hh: "%d tassaɛin",
                d: "ass",
                dd: "%d ossan",
                M: "ayowr",
                MM: "%d iyyirn",
                y: "asgas",
                yy: "%d isgasn"
            },
            week: {
                dow: 6,
                doy: 12
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : ukrainian (uk)
    //! author : zemlanin : https://github.com/zemlanin
    //! Author : Menelion Elensúle : https://github.com/Oire
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        function t(e, t) {
            var n = e.split("_");
            return t % 10 === 1 && t % 100 !== 11 ? n[0] : t % 10 >= 2 && t % 10 <= 4 && (t % 100 < 10 || t % 100 >= 20) ? n[1] : n[2];
        }
        function n(e, n, a) {
            var r = {
                mm: "хвилина_хвилини_хвилин",
                hh: "година_години_годин",
                dd: "день_дні_днів",
                MM: "місяць_місяці_місяців",
                yy: "рік_роки_років"
            };
            return "m" === a ? n ? "хвилина" : "хвилину" : "h" === a ? n ? "година" : "годину" : e + " " + t(r[a], +e);
        }
        function a(e, t) {
            var n = {
                nominative: "січень_лютий_березень_квітень_травень_червень_липень_серпень_вересень_жовтень_листопад_грудень".split("_"),
                accusative: "січня_лютого_березня_квітня_травня_червня_липня_серпня_вересня_жовтня_листопада_грудня".split("_")
            }, a = /D[oD]? *MMMM?/.test(t) ? "accusative" : "nominative";
            return n[a][e.month()];
        }
        function r(e, t) {
            var n = {
                nominative: "неділя_понеділок_вівторок_середа_четвер_п’ятниця_субота".split("_"),
                accusative: "неділю_понеділок_вівторок_середу_четвер_п’ятницю_суботу".split("_"),
                genitive: "неділі_понеділка_вівторка_середи_четверга_п’ятниці_суботи".split("_")
            }, a = /(\[[ВвУу]\]) ?dddd/.test(t) ? "accusative" : /\[?(?:минулої|наступної)? ?\] ?dddd/.test(t) ? "genitive" : "nominative";
            return n[a][e.day()];
        }
        function i(e) {
            return function() {
                return e + "о" + (11 === this.hours() ? "б" : "") + "] LT";
            };
        }
        var s = e.defineLocale("uk", {
            months: a,
            monthsShort: "січ_лют_бер_квіт_трав_черв_лип_серп_вер_жовт_лист_груд".split("_"),
            weekdays: r,
            weekdaysShort: "нд_пн_вт_ср_чт_пт_сб".split("_"),
            weekdaysMin: "нд_пн_вт_ср_чт_пт_сб".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD.MM.YYYY",
                LL: "D MMMM YYYY р.",
                LLL: "D MMMM YYYY р., HH:mm",
                LLLL: "dddd, D MMMM YYYY р., HH:mm"
            },
            calendar: {
                sameDay: i("[Сьогодні "),
                nextDay: i("[Завтра "),
                lastDay: i("[Вчора "),
                nextWeek: i("[У] dddd ["),
                lastWeek: function() {
                    switch (this.day()) {
                      case 0:
                      case 3:
                      case 5:
                      case 6:
                        return i("[Минулої] dddd [").call(this);

                      case 1:
                      case 2:
                      case 4:
                        return i("[Минулого] dddd [").call(this);
                    }
                },
                sameElse: "L"
            },
            relativeTime: {
                future: "за %s",
                past: "%s тому",
                s: "декілька секунд",
                m: n,
                mm: n,
                h: "годину",
                hh: n,
                d: "день",
                dd: n,
                M: "місяць",
                MM: n,
                y: "рік",
                yy: n
            },
            meridiemParse: /ночі|ранку|дня|вечора/,
            isPM: function(e) {
                return /^(дня|вечора)$/.test(e);
            },
            meridiem: function(e, t, n) {
                return e < 4 ? "ночі" : e < 12 ? "ранку" : e < 17 ? "дня" : "вечора";
            },
            ordinalParse: /\d{1,2}-(й|го)/,
            ordinal: function(e, t) {
                switch (t) {
                  case "M":
                  case "d":
                  case "DDD":
                  case "w":
                  case "W":
                    return e + "-й";

                  case "D":
                    return e + "-го";

                  default:
                    return e;
                }
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return s;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : uzbek (uz)
    //! author : Sardor Muminov : https://github.com/muminoff
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("uz", {
            months: "январь_февраль_март_апрель_май_июнь_июль_август_сентябрь_октябрь_ноябрь_декабрь".split("_"),
            monthsShort: "янв_фев_мар_апр_май_июн_июл_авг_сен_окт_ноя_дек".split("_"),
            weekdays: "Якшанба_Душанба_Сешанба_Чоршанба_Пайшанба_Жума_Шанба".split("_"),
            weekdaysShort: "Якш_Душ_Сеш_Чор_Пай_Жум_Шан".split("_"),
            weekdaysMin: "Як_Ду_Се_Чо_Па_Жу_Ша".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM YYYY",
                LLL: "D MMMM YYYY HH:mm",
                LLLL: "D MMMM YYYY, dddd HH:mm"
            },
            calendar: {
                sameDay: "[Бугун соат] LT [да]",
                nextDay: "[Эртага] LT [да]",
                nextWeek: "dddd [куни соат] LT [да]",
                lastDay: "[Кеча соат] LT [да]",
                lastWeek: "[Утган] dddd [куни соат] LT [да]",
                sameElse: "L"
            },
            relativeTime: {
                future: "Якин %s ичида",
                past: "Бир неча %s олдин",
                s: "фурсат",
                m: "бир дакика",
                mm: "%d дакика",
                h: "бир соат",
                hh: "%d соат",
                d: "бир кун",
                dd: "%d кун",
                M: "бир ой",
                MM: "%d ой",
                y: "бир йил",
                yy: "%d йил"
            },
            week: {
                dow: 1,
                doy: 7
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : vietnamese (vi)
    //! author : Bang Nguyen : https://github.com/bangnk
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("vi", {
            months: "tháng 1_tháng 2_tháng 3_tháng 4_tháng 5_tháng 6_tháng 7_tháng 8_tháng 9_tháng 10_tháng 11_tháng 12".split("_"),
            monthsShort: "Th01_Th02_Th03_Th04_Th05_Th06_Th07_Th08_Th09_Th10_Th11_Th12".split("_"),
            weekdays: "chủ nhật_thứ hai_thứ ba_thứ tư_thứ năm_thứ sáu_thứ bảy".split("_"),
            weekdaysShort: "CN_T2_T3_T4_T5_T6_T7".split("_"),
            weekdaysMin: "CN_T2_T3_T4_T5_T6_T7".split("_"),
            longDateFormat: {
                LT: "HH:mm",
                LTS: "HH:mm:ss",
                L: "DD/MM/YYYY",
                LL: "D MMMM [năm] YYYY",
                LLL: "D MMMM [năm] YYYY HH:mm",
                LLLL: "dddd, D MMMM [năm] YYYY HH:mm",
                l: "DD/M/YYYY",
                ll: "D MMM YYYY",
                lll: "D MMM YYYY HH:mm",
                llll: "ddd, D MMM YYYY HH:mm"
            },
            calendar: {
                sameDay: "[Hôm nay lúc] LT",
                nextDay: "[Ngày mai lúc] LT",
                nextWeek: "dddd [tuần tới lúc] LT",
                lastDay: "[Hôm qua lúc] LT",
                lastWeek: "dddd [tuần rồi lúc] LT",
                sameElse: "L"
            },
            relativeTime: {
                future: "%s tới",
                past: "%s trước",
                s: "vài giây",
                m: "một phút",
                mm: "%d phút",
                h: "một giờ",
                hh: "%d giờ",
                d: "một ngày",
                dd: "%d ngày",
                M: "một tháng",
                MM: "%d tháng",
                y: "một năm",
                yy: "%d năm"
            },
            ordinalParse: /\d{1,2}/,
            ordinal: function(e) {
                return e;
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : chinese (zh-cn)
    //! author : suupic : https://github.com/suupic
    //! author : Zeno Zeng : https://github.com/zenozeng
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("zh-cn", {
            months: "一月_二月_三月_四月_五月_六月_七月_八月_九月_十月_十一月_十二月".split("_"),
            monthsShort: "1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),
            weekdays: "星期日_星期一_星期二_星期三_星期四_星期五_星期六".split("_"),
            weekdaysShort: "周日_周一_周二_周三_周四_周五_周六".split("_"),
            weekdaysMin: "日_一_二_三_四_五_六".split("_"),
            longDateFormat: {
                LT: "Ah点mm分",
                LTS: "Ah点m分s秒",
                L: "YYYY-MM-DD",
                LL: "YYYY年MMMD日",
                LLL: "YYYY年MMMD日Ah点mm分",
                LLLL: "YYYY年MMMD日ddddAh点mm分",
                l: "YYYY-MM-DD",
                ll: "YYYY年MMMD日",
                lll: "YYYY年MMMD日Ah点mm分",
                llll: "YYYY年MMMD日ddddAh点mm分"
            },
            meridiemParse: /凌晨|早上|上午|中午|下午|晚上/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "凌晨" === t || "早上" === t || "上午" === t ? e : "下午" === t || "晚上" === t ? e + 12 : e >= 11 ? e : e + 12;
            },
            meridiem: function(e, t, n) {
                var a = 100 * e + t;
                return a < 600 ? "凌晨" : a < 900 ? "早上" : a < 1130 ? "上午" : a < 1230 ? "中午" : a < 1800 ? "下午" : "晚上";
            },
            calendar: {
                sameDay: function() {
                    return 0 === this.minutes() ? "[今天]Ah[点整]" : "[今天]LT";
                },
                nextDay: function() {
                    return 0 === this.minutes() ? "[明天]Ah[点整]" : "[明天]LT";
                },
                lastDay: function() {
                    return 0 === this.minutes() ? "[昨天]Ah[点整]" : "[昨天]LT";
                },
                nextWeek: function() {
                    var t, n;
                    return t = e().startOf("week"), n = this.unix() - t.unix() >= 604800 ? "[下]" : "[本]", 
                    0 === this.minutes() ? n + "dddAh点整" : n + "dddAh点mm";
                },
                lastWeek: function() {
                    var t, n;
                    return t = e().startOf("week"), n = this.unix() < t.unix() ? "[上]" : "[本]", 0 === this.minutes() ? n + "dddAh点整" : n + "dddAh点mm";
                },
                sameElse: "LL"
            },
            ordinalParse: /\d{1,2}(日|月|周)/,
            ordinal: function(e, t) {
                switch (t) {
                  case "d":
                  case "D":
                  case "DDD":
                    return e + "日";

                  case "M":
                    return e + "月";

                  case "w":
                  case "W":
                    return e + "周";

                  default:
                    return e;
                }
            },
            relativeTime: {
                future: "%s内",
                past: "%s前",
                s: "几秒",
                m: "1 分钟",
                mm: "%d 分钟",
                h: "1 小时",
                hh: "%d 小时",
                d: "1 天",
                dd: "%d 天",
                M: "1 个月",
                MM: "%d 个月",
                y: "1 年",
                yy: "%d 年"
            },
            week: {
                dow: 1,
                doy: 4
            }
        });
        return t;
    });
}, function(e, t, n) {
    //! moment.js locale configuration
    //! locale : traditional chinese (zh-tw)
    //! author : Ben : https://github.com/ben-lin
    !function(e, t) {
        t(n(62));
    }(this, function(e) {
        "use strict";
        var t = e.defineLocale("zh-tw", {
            months: "一月_二月_三月_四月_五月_六月_七月_八月_九月_十月_十一月_十二月".split("_"),
            monthsShort: "1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),
            weekdays: "星期日_星期一_星期二_星期三_星期四_星期五_星期六".split("_"),
            weekdaysShort: "週日_週一_週二_週三_週四_週五_週六".split("_"),
            weekdaysMin: "日_一_二_三_四_五_六".split("_"),
            longDateFormat: {
                LT: "Ah點mm分",
                LTS: "Ah點m分s秒",
                L: "YYYY年MMMD日",
                LL: "YYYY年MMMD日",
                LLL: "YYYY年MMMD日Ah點mm分",
                LLLL: "YYYY年MMMD日ddddAh點mm分",
                l: "YYYY年MMMD日",
                ll: "YYYY年MMMD日",
                lll: "YYYY年MMMD日Ah點mm分",
                llll: "YYYY年MMMD日ddddAh點mm分"
            },
            meridiemParse: /早上|上午|中午|下午|晚上/,
            meridiemHour: function(e, t) {
                return 12 === e && (e = 0), "早上" === t || "上午" === t ? e : "中午" === t ? e >= 11 ? e : e + 12 : "下午" === t || "晚上" === t ? e + 12 : void 0;
            },
            meridiem: function(e, t, n) {
                var a = 100 * e + t;
                return a < 900 ? "早上" : a < 1130 ? "上午" : a < 1230 ? "中午" : a < 1800 ? "下午" : "晚上";
            },
            calendar: {
                sameDay: "[今天]LT",
                nextDay: "[明天]LT",
                nextWeek: "[下]ddddLT",
                lastDay: "[昨天]LT",
                lastWeek: "[上]ddddLT",
                sameElse: "L"
            },
            ordinalParse: /\d{1,2}(日|月|週)/,
            ordinal: function(e, t) {
                switch (t) {
                  case "d":
                  case "D":
                  case "DDD":
                    return e + "日";

                  case "M":
                    return e + "月";

                  case "w":
                  case "W":
                    return e + "週";

                  default:
                    return e;
                }
            },
            relativeTime: {
                future: "%s內",
                past: "%s前",
                s: "幾秒",
                m: "一分鐘",
                mm: "%d分鐘",
                h: "一小時",
                hh: "%d小時",
                d: "一天",
                dd: "%d天",
                M: "一個月",
                MM: "%d個月",
                y: "一年",
                yy: "%d年"
            }
        });
        return t;
    });
}, , , , , , , , , , , , , , , , , , , , , , , , , function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="content-filter"> <div class="listing-ct-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteTag(stream, tag)"></button> </div> <h3> <i class="pficon pficon-image"></i>\n<span ng-if="labels.name">{{ labels.name }}</span>\n<span ng-if="!labels.name">{{ names[0] }}</span> </h3> <a ng-href="#/images/{{ stream.metadata.namespace }}/{{ stream.metadata.name }}" translate class="hidden-xs">Show all images</a> </div> <div class="listing-ct-inline"> <h3 translate>Image</h3> <div class="listing-ct-body"> <registry-image-body image="image" names="names"> </registry-image-body> <registry-image-pull settings="settings" names="names"> </registry-image-pull> </div> <h3 translate>Container</h3> <div class="listing-ct-body"> <registry-image-config image="image"> </registry-image-config> </div> <h3 translate>Metadata</h3> <div class="listing-ct-body"> <registry-image-meta image="image"> </registry-image-meta> <registry-image-layers image="image" layers="layers"> </registry-image-layers> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/image-page.html", r);
    } ]), e.exports = r;
}, , , , , , , , , , , , , , function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<filter-bar class="content-filter"> </filter-bar> <div image-listing> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/images-page.html", r);
    } ]), e.exports = r;
}, , , function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<div class="content-filter"> <div class="listing-ct-actions"> <button class="btn btn-danger btn-delete pficon pficon-delete" ng-click="deleteImageStream(stream)"></button>\n<button class="btn btn-default pficon pficon-edit" ng-click="modifyImageStream(stream)"></button> </div> <h3> <i class="fa fa-folder"></i>\n{{ stream.metadata.namespace }}/{{ stream.metadata.name}} </h3> <a ng-href="#{{ viewUrl(\'images\') }}" translate>Show all image streams</a> </div> <div class="listing-ct-inline"> <h3 translate>Image Stream</h3> <div class="listing-ct-body"> <registry-imagestream-body imagestream="stream" imagestream-modify="modifyImageStream" project-modify="modifyProject" project-sharing="sharedImages"> </registry-imagestream-body> <registry-imagestream-push settings="settings" imagestream="stream" ng-show="showDockerPushCommands"> </registry-imagestream-push> </div> <h3 translate>Images</h3> <div image-listing> </div> <h3 translate ng-if="stream.metadata.annotations">Metadata</h3> <div class="listing-ct-body" ng-if="stream.metadata.annotations"> <registry-imagestream-meta imagestream="stream"> </registry-imagestream-meta> </div> </div>';
    n.run([ "$templateCache", function(e) {
        e.put("views/imagestream-page.html", r);
    } ]), e.exports = r;
}, , , , , , , , , , , , , , , , , , , , , , , , function(e, t, n) {
    "use strict";
    !function() {
        var e = n(32);
        n(39), e.module("registry.policy", [ "kubeClient" ]).factory("projectPolicy", [ "$q", "$rootScope", "kubeLoader", "kubeMethods", function(t, n, a, r) {
            function i(t, n) {
                e.forEach(t || [], function(e) {
                    a.handle(e.roleBinding, n, "RoleBinding");
                });
            }
            function s(t) {
                e.forEach(t, function(e) {
                    var t = a.resolve(e.kind, e.name, e.namespace);
                    if (!(t in a.objects)) {
                        var n = {
                            kind: e.kind,
                            apiVersion: "v1",
                            metadata: {
                                name: e.name
                            }
                        };
                        e.namespace && (n.metadata.namespace = e.namespace), a.handle(n);
                    }
                });
            }
            function o(e, t, a, r) {
                var i = t + ":" + a;
                e in $ || ($[e] = {}), $[e][i] = r, r && e in k && delete k[e][i], n.$applyAsync();
            }
            function l(t) {
                t ? (k[t] = e.extend({}, $[t]), delete $[t]) : (k = $, $ = {}), n.$applyAsync();
            }
            function u(e, t, n) {
                var i = t + ":" + n, s = !0, l = null, u = $[e];
                if (u && i in u && (l = u[i], s = !1), l || (u = k[e], u && i in u && (l = u[i])), 
                !s) return l;
                var c = {
                    kind: "LocalResourceAccessReview",
                    apiVersion: "v1",
                    namespace: "",
                    verb: t,
                    resource: n,
                    resourceName: "",
                    content: null
                };
                o(e, t, n, null);
                var d = a.resolve("localresourceaccessreviews", null, e);
                return r.post(d, c).then(function(a) {
                    o(e, t, n, a);
                }, function(a) {
                    console.warn("failed to lookup access:", e, t, n + ":", a.message || JSON.stringify(a));
                }), l;
            }
            function c(e, n, i, s) {
                var o = e + ":" + (n ? n.metadata.name : "") + ":" + i + ":" + s, l = t.defer();
                if (o in w) l.resolve(w[o]); else {
                    var u = {
                        kind: "SubjectAccessReview",
                        apiVersion: "v1",
                        namespace: e,
                        verb: i,
                        resource: s
                    };
                    r.post(a.resolve("subjectaccessreviews"), u).then(function(e) {
                        w[o] = e.allowed, l.resolve(e.allowed);
                    }, function(e) {
                        console.warn("failed to review subject access:", e.message || JSON.stringify(e)), 
                        l.reject(e.message || JSON.stringify(e));
                    });
                }
                return l.promise;
            }
            function d(e) {
                if (e) for (var t in w) 0 === t.lastIndexOf(e + ":", 0) && delete w[t]; else w = {};
                n.$applyAsync();
            }
            function m(e, t, n) {
                var i = a.resolve("RoleBinding", t, e);
                return a.load(i).then(function(e) {
                    return n(e), r.put(i, e);
                });
            }
            function f(e, t, n) {
                var a = M(t), i = {
                    kind: "RoleBinding",
                    apiVersion: "v1",
                    metadata: {
                        name: a,
                        namespace: e,
                        creationTimestamp: null
                    },
                    userNames: [],
                    groupNames: [],
                    subjects: [],
                    roleRef: {
                        name: t
                    }
                };
                return _(b(i, "subjects"), n), _(y(i, n.kind), n.name), r.create(i, e);
            }
            function p(e, n, a) {
                var r = M(e);
                return m(r, n, function(e) {
                    v(b(e, "subjects"), a), v(y(e, a.kind), a.name);
                }).then(function() {
                    l(r);
                }, function(e) {
                    if (404 !== e.code) return t.reject(e);
                });
            }
            function h(n, a, r, i) {
                var s, o = [ "registry-admin", "registry-editor", "registry-viewer" ], l = t.when(), u = [];
                return n && n.one() && (s = n.one(), u = s.roleBindings), e.forEach(r, function(t) {
                    e.forEach(u, function(e) {
                        g(o, e.name) !== -1 && e.name === t.metadata.name && (l = l.then(function() {
                            return p(a, e.name, i);
                        }));
                    });
                }), l;
            }
            function g(t, n) {
                var a, r;
                for (a = 0, r = t.length; a < r; a++) if (e.equals(t[a], n)) return a;
                return -1;
            }
            function _(e, t) {
                var n = g(e, t);
                n < 0 && e.push(t);
            }
            function v(e, t) {
                var n = g(e, t);
                n >= 0 && e.splice(n, 1);
            }
            function b(e, t) {
                var n = e[t] || [];
                return e[t] = n, n;
            }
            function y(e, t) {
                return "Group" == t || "SystemGroup" == t ? b(e, "groupNames") : b(e, "userNames");
            }
            function M(e) {
                return "object" == typeof e ? e.metadata.name : e;
            }
            a.listen(function(e, t) {
                var n, a = {};
                for (n in t) "PolicyBinding" == t[n].kind && (i(t[n].roleBindings, !0), a[t[n].metadata.namespace] = !0);
                for (n in e) "PolicyBinding" == e[n].kind ? (i(e[n].roleBindings, !1), a[e[n].metadata.namespace] = !0) : "RoleBinding" == e[n].kind && (s(e[n].subjects || []), 
                a[e[n].metadata.namespace] = !0);
                var r;
                for (r in a) l(r), d(r);
            });
            var $ = {}, k = {}, w = {};
            return {
                watch: function(e) {
                    a.watch("policybindings", e).then(function() {
                        l(null);
                    });
                },
                whoCan: function(e, t, n) {
                    return u(M(e), t, n);
                },
                addToRole: function(e, n, a) {
                    var r = M(e);
                    return m(r, n, function(e) {
                        _(b(e, "subjects"), a), _(y(e, a.kind), a.name);
                    }).then(function() {
                        l(r);
                    }, function(e) {
                        return 404 === e.code ? f(r, n, a) : t.reject(e);
                    });
                },
                removeFromRole: p,
                removeMemberFromPolicyBinding: h,
                subjectAccessReview: c
            };
        } ]);
    }();
}, , , , , , , , , , , , , , , , , , , function(e, t, n) {
    "use strict";
    !function() {
        function e(e, t, n) {
            var a, r, i, s, o, l = (e.status || {}).tags || [];
            for (s = 0, o = l.length; s < o; s++) for (i = l[s].items || [], a = 0, r = i.length; a < r; a++) t.call(n || null, l[s], i[a]);
        }
        var t = n(32);
        n(33), n(43), n(39), n(61), n(44), n(235), n(215), n(236), n(188), n(191), n(174), 
        n(45), n(237), n(238), n(239), n(239), n(240), t.module("registry.images", [ "ngRoute", "ui.cockpit", "kubeClient", "kubernetes.date", "kubernetes.listing", "registry.tags", "registryUI.images" ]).config([ "$routeProvider", function(e) {
            e.when("/images/:namespace?", {
                templateUrl: "views/images-page.html",
                controller: "ImagesCtrl"
            }).when("/images/:namespace/:target", {
                controller: "ImageCtrl",
                templateUrl: function(e) {
                    var t = e.target || "";
                    return t.indexOf(":") === -1 ? "views/imagestream-page.html" : "views/image-page.html";
                }
            });
        } ]).controller("ImagesCtrl", [ "$scope", "$location", "imageData", "imageActions", "ListingState", "projectData", "filterService", function(e, n, a, r, i, s) {
            e.imagestreams = a.allStreams, e.sharedImages = s.sharedImages, t.extend(e, a), 
            e.listing = new i(e), a.watchImages(), e.$on("activate", function(e, t) {
                e.preventDefault(), n.path("/images/" + t);
            }), t.extend(e, r);
        } ]).controller("ImageCtrl", [ "$scope", "$location", "$routeParams", "kubeSelect", "kubeLoader", "KubeDiscoverSettings", "imageData", "imageActions", "ListingState", "projectData", "projectPolicy", function(n, a, r, i, s, o, l, u, c, d, m) {
            function f() {
                o().then(function(e) {
                    m.subjectAccessReview(v, e.currentUser, "update", "imagestreamimages").then(function(e) {
                        e != n.showDockerPushCommands && (n.showDockerPushCommands = e, n.$applyAsync());
                    });
                });
            }
            var p, h, g = r.target || "", _ = g.indexOf(":"), v = r.namespace || "";
            _ === -1 ? (n.kind = "ImageStream", p = g, h = null) : (n.kind = "Image", p = g.substr(0, _), 
            h = g.substr(_ + 1)), l.watchImages(n), s.listen(function() {
                n.stream = i().kind("ImageStream").namespace(v).name(p).one(), n.image = n.config = n.layers = n.labels = n.tag = null, 
                e(n.stream || {}, function(e, t) {
                    e.tag === h && (n.tag = e);
                }), n.tag && (n.image = i().kind("Image").taggedFirst(n.tag).one()), n.image && (n.names = l.imageTagNames(n.image), 
                n.config = l.imageConfig(n.image), n.layers = l.imageLayers(n.image), n.labels = l.imageLabels(n.image));
            }, n), n.listing = new c(n), n.listing.inline = !0, n.imagestreams = function() {
                return n.stream ? {
                    "/": n.stream
                } : {};
            }, t.extend(n, l), t.extend(n, u), n.sharedImages = d.sharedImages, n.deleteImageStream = function(e) {
                var t = u.deleteImageStream(e);
                return t.then(function() {
                    a.path(n.viewUrl("images"));
                }), t;
            }, n.$on("activate", function(e, t) {
                e.preventDefault(), a.path("/images/" + t);
            }), n.deleteTag = function(e, t) {
                var n = u.deleteTag(e, t);
                return n.then(function() {
                    var t = [ "images", e.metadata.namespace, e.metadata.name ];
                    a.path("/" + t.map(encodeURIComponent).join("/"));
                }), n;
            }, n.$on("$routeUpdate", f), f();
        } ]).directive("imagePanel", [ "kubeLoader", "imageData", function(e, t) {
            return {
                restrict: "A",
                scope: !0,
                link: function(n, a, r) {
                    var i = "main";
                    n.tab = function(e, t) {
                        return t && (i = e, t.stopPropagation()), i === e;
                    }, e.listen(function() {
                        n.names = n.config = n.layers = n.labels = null, n.image && (n.names = t.imageTagNames(n.image), 
                        n.config = t.imageConfig(n.image), n.layers = t.imageLayers(n.image), n.labels = t.imageLabels(n.image));
                    }, n);
                },
                templateUrl: "views/image-panel.html"
            };
        } ]).directive("imageListing", function() {
            return {
                restrict: "A",
                templateUrl: "views/image-listing.html"
            };
        }).factory("imageData", [ "kubeSelect", "kubeLoader", function(n, a) {
            function r(e) {
                var n = e.metadata || {}, r = e.status || {};
                t.forEach(r.tags || [], function(e) {
                    t.forEach(e.items || [], function(e) {
                        var t = a.resolve("Image", e.image);
                        if (!(t in a.objects)) {
                            var r = {
                                kind: "Image",
                                apiVersion: "v1",
                                metadata: {
                                    name: e.image
                                }
                            };
                            if (a.handle(r), u) {
                                var s = n.name + "@" + e.image;
                                a.load("ImageStreamImage", s, n.namespace).then(function(e) {
                                    var t = e.image;
                                    t && (t.kind = "Image", a.handle(t), i(t));
                                }, function(e) {
                                    var t = e.statusText || e.message || String(e);
                                    console.warn("couldn't load image: " + t), r.metadata.resourceVersion = "invalid";
                                });
                            }
                        }
                    });
                });
            }
            function i(e) {
                var n, r = e.dockerImageManifest;
                r && (r = JSON.parse(r), t.forEach(r.history || [], function(e) {
                    "string" == typeof e.v1Compatibility && (e.v1Compatibility = JSON.parse(e.v1Compatibility));
                }), n = {
                    kind: "DockerImageManifest",
                    metadata: {
                        name: e.metadata.name,
                        selfLink: "/internal/manifests/" + e.metadata.name
                    },
                    manifest: r
                }, a.handle(n));
            }
            function s(e) {
                u = !0;
                var t = a.watch("images", e), n = a.watch("imagestreams", e);
                return {
                    cancel: function() {
                        t.cancel(), n.cancel();
                    }
                };
            }
            function o(e) {
                if (!e) return null;
                var t = n().kind("DockerImageManifest").name(e.metadata.name).one();
                return t && t.manifest && 1 === t.manifest.schemaVersion ? t.manifest.history : e.dockerImageLayers ? e.dockerImageLayers : null;
            }
            function l(e) {
                var t = [];
                if (!e) return "";
                e.Entrypoint && t.push.apply(t, e.Entrypoint), e.Cmd && t.push.apply(t, e.Cmd);
                var n = t.join(" ");
                return e.User && "root" != e.User.split(":")[0] ? "$ " + n : "# " + n;
            }
            var u = !1;
            return a.listen(function(e) {
                for (var t in e) "ImageStream" === e[t].kind && r(e[t]), "Image" === e[t].kind && i(e[t]);
            }), n.register("taggedBy", function(e) {
                var t, a, r = {};
                if (!e.items) return n(null);
                for (t = 0, a = e.items.length; t < a; t++) this.name(e.items[t].image).extend(r);
                return n(r);
            }), n.register("taggedFirst", function(e) {
                var t = {};
                return e.items ? (e.items.length && this.name(e.items[0].image).extend(t), n(t)) : n(null);
            }), n.register({
                name: "containsTagImage",
                digests: function(t) {
                    var n = [];
                    return "string" == typeof t ? n.push(t) : e(t, function(e, t) {
                        n.push(t.image + "");
                    }), n;
                }
            }), n.register("listTagNames", function(n) {
                var a = [];
                return t.forEach(this.containsTagImage(n), function(t) {
                    e(t, function(e, r) {
                        n && r.image != n || a.push(t.metadata.namespace + "/" + t.metadata.name + ":" + e.tag);
                    });
                }), a;
            }), n.register("dockerImageConfig", function() {
                var e = {};
                return t.forEach(this, function(t, n) {
                    var a, r = o(t) || {};
                    if (r[0] && (a = r[0].v1Compatibility, a && a.config)) return void (e[n] = a.config);
                    var i = t.dockerImageMetadata || {};
                    i.Config && (e[n] = i.Config);
                }), n(e);
            }), n.register("dockerConfigLabels", function() {
                var e = {};
                return t.forEach(this, function(t, n) {
                    var a;
                    t && (a = t.Labels), a && (e[n] = a);
                }), n(e);
            }), {
                watchImages: s,
                allStreams: function() {
                    return n().kind("ImageStream");
                },
                imageByTag: function(e) {
                    return n().kind("Image").taggedFirst(e);
                },
                imageLayers: o,
                imageConfig: function(e) {
                    return n(e).dockerImageConfig().one() || {};
                },
                imageTagNames: function(e) {
                    return n().kind("ImageStream").listTagNames(e.metadata.name);
                },
                imageLabels: function(e) {
                    var a = n(e).dockerImageConfig().dockerConfigLabels().one();
                    return a && t.equals({}, a) && (a = null), a;
                },
                configCommand: l
            };
        } ]).factory("imageActions", [ "$modal", "$location", function(e, t) {
            function n(t) {
                return e.open({
                    animation: !1,
                    controller: "ImageStreamDeleteCtrl",
                    templateUrl: "views/imagestream-delete.html",
                    resolve: {
                        dialogData: function() {
                            return {
                                stream: t
                            };
                        }
                    }
                }).result;
            }
            function a() {
                return e.open({
                    animation: !1,
                    controller: "ImageStreamModifyCtrl",
                    templateUrl: "views/imagestream-modify.html",
                    resolve: {
                        dialogData: function() {
                            return {};
                        }
                    }
                }).result;
            }
            function r(t) {
                return e.open({
                    animation: !1,
                    controller: "ImageStreamModifyCtrl",
                    templateUrl: "views/imagestream-modify.html",
                    resolve: {
                        dialogData: function() {
                            return {
                                stream: t
                            };
                        }
                    }
                }).result;
            }
            function i(t, n) {
                var a = e.open({
                    animation: !1,
                    controller: "ImageDeleteCtrl",
                    templateUrl: "views/image-delete.html",
                    resolve: {
                        dialogData: function() {
                            return {
                                stream: t,
                                tag: n
                            };
                        }
                    }
                });
                return a.result;
            }
            function s(e) {
                return t.path("/projects/" + e), !1;
            }
            return {
                createImageStream: a,
                modifyImageStream: r,
                deleteImageStream: n,
                deleteTag: i,
                modifyProject: s
            };
        } ]).controller("ImageStreamDeleteCtrl", [ "$scope", "$modalInstance", "dialogData", "kubeMethods", function(e, n, a, r) {
            t.extend(e, a), e.performDelete = function() {
                return r.delete(e.stream);
            };
        } ]).controller("ImageStreamModifyCtrl", [ "$scope", "$modalInstance", "dialogData", "imageTagData", "kubeMethods", "filterService", "gettextCatalog", function(e, n, a, r, i, s, o) {
            function l() {
                var e = {
                    spec: {
                        dockerImageRepository: null,
                        tags: null
                    }
                };
                return "none" != g.populate && (e.spec.dockerImageRepository = g.pull.trim()), "tags" == g.populate && r.buildSpec(g.tags, e.spec, g.insecure), 
                i.patch(d, e);
            }
            function u() {
                var e = {
                    kind: "ImageStream",
                    metadata: {
                        name: g.name.trim(),
                        namespace: g.project.trim()
                    }
                };
                return "none" != g.populate && (e.spec = {
                    dockerImageRepository: g.pull.trim()
                }), "tags" == g.populate && (e.spec = r.buildSpec(g.tags, e.spec, g.insecure)), 
                i.check(e, {
                    "metadata.name": "#imagestream-modify-name",
                    "metadata.namespace": "#imagestream-modify-project"
                }).then(function() {
                    return i.create(e, g.project);
                });
            }
            function c(e) {
                var t;
                if (e) for (var n in e.tags) if (e.tags[n].importPolicy.insecure) {
                    t = e.tags[n].importPolicy.insecure;
                    break;
                }
                return t;
            }
            var d = a.stream || {}, m = d.metadata || {}, f = d.spec || {}, p = o.getString.bind(o), h = "none";
            f.dockerImageRepository && (h = "pull"), f.tags && (h = "tags");
            var g = {
                name: m.name || "",
                project: m.namespace || s.namespace() || "",
                populate: h,
                pull: f.dockerImageRepository || "",
                tags: r.parseSpec(f),
                insecure: c(f)
            };
            e.fields = g, e.labels = {
                populate: {
                    none: p("Don't pull images automatically"),
                    pull: p("Sync all tags from a remote image repository"),
                    tags: p("Pull specific tags from another image repository")
                }
            }, e.placeholder = p("eg: my-image-stream"), a.stream || (e.labels.populate.none = p("Create empty image stream")), 
            e.performCreate = u, e.performModify = l, e.hasInsecureTag = c, e.projects = s.namespaces, 
            t.extend(e, a);
        } ]).controller("ImageDeleteCtrl", [ "$scope", "$modalInstance", "dialogData", "kubeMethods", function(e, n, a, r) {
            t.extend(e, a), e.performDelete = function() {
                var t = e.stream.metadata.name + ":" + e.tag.tag;
                return r.delete("ImageStreamTag", t, e.stream.metadata.namespace);
            };
        } ]);
    }();
}, function(e, t, n) {
    "use strict";
    !function() {
        function e(e) {
            function t(e) {
                e && r.push(e);
            }
            var n, a, r = [];
            for (n = e.firstChild; n; n = n.nextSibling) a = "", 3 == n.nodeType ? a = n.nodeValue.trim() : 1 == n.nodeType && n.hasAttribute("value") && (a = n.getAttribute("value")), 
            a.split(s).forEach(t);
            return r;
        }
        function t(e) {
            var t = [ document.createTextNode("​") ];
            return i.forEach(e, function(e) {
                var n = document.createElement("span");
                n.setAttribute("contenteditable", "false"), n.setAttribute("class", "image-tag"), 
                n.setAttribute("value", e), n.appendChild(document.createTextNode(e));
                var a = document.createElement("a");
                a.setAttribute("class", "pficon pficon-close"), n.appendChild(a), t.push(n), t.push(document.createTextNode(" "));
            }), t;
        }
        function a(e) {
            var t = [];
            return i.forEach(e.tags || [], function(e) {
                t.push(e.name);
            }), t;
        }
        function r(e, t, n) {
            var a = {};
            t || (t = {}), i.forEach(t.tags || [], function(e) {
                a[e.name] = e;
            });
            var r = [];
            return i.forEach(e, function(e) {
                e in a ? (a[e].importPolicy = {
                    insecure: n
                }, r.push(a[e])) : r.push({
                    name: e,
                    importPolicy: {
                        insecure: n
                    }
                });
            }), t.tags = r, t;
        }
        var i = n(32), s = /[\u200B\s,]+/;
        i.module("registry.tags", []).directive("imageTagEditor", [ function() {
            return {
                restrict: "A",
                transclude: !0,
                scope: {
                    tags: "="
                },
                link: function(n, a, r) {
                    a.addClass("image-tag-editor"), a.attr("tabindex", "0"), a.attr("contenteditable", "true");
                    var i = t(n.tags);
                    a.append(i);
                    var s = document.createRange();
                    s.selectNodeContents(i[i.length - 1]), s.collapse(!1);
                    var o = window.getSelection();
                    o.removeAllRanges(), o.addRange(s), a.on("click", function(e) {
                        var t = e.target, n = t.parentNode;
                        "a" == t.nodeName.toLowerCase() && "span" == n.nodeName.toLowerCase() && n.parentNode.removeChild(n);
                    }), a.on("blur keyup paste copy cut mouseup", function() {
                        for (var t = e(a[0]); n.tags.length > 0; ) n.tags.pop();
                        t.forEach(function(e) {
                            n.tags.push(e);
                        });
                    });
                }
            };
        } ]).factory("imageTagData", [ function() {
            return {
                parseSpec: a,
                buildSpec: r,
                buildNodes: t,
                parseNodes: e
            };
        } ]);
    }();
}, function(e, t) {
    !function(e) {
        function t(a) {
            if (n[a]) return n[a].exports;
            var r = n[a] = {
                exports: {},
                id: a,
                loaded: !1
            };
            return e[a].call(r.exports, r, r.exports, t), r.loaded = !0, r.exports;
        }
        var n = {};
        return t.m = e, t.c = n, t.p = "", t(0);
    }([ function(e, t, n) {
        n(4), n(5), n(6), n(7), n(8), n(10), n(11), n(12), n(13), n(14), n(15), n(16), n(17), 
        e.exports = n(18);
    }, , , , function(e, t) {
        !function() {
            "use strict";
            angular.module("registryUI.images", [ "registryUI.client", "registryUI.date" ]).factory("imageDockerManifest", [ "WeakMap", function(e) {
                var t = new e();
                return function(e) {
                    if (!e) return {};
                    var n = t.get(e);
                    return n || (n = JSON.parse(e.dockerImageManifest || "{ }"), angular.forEach(n.history || [], function(e) {
                        "string" == typeof e.v1Compatibility && (e.v1Compatibility = JSON.parse(e.v1Compatibility));
                    }), t.set(e, n)), n;
                };
            } ]).factory("imageDockerConfig", [ "WeakMap", "imageLayers", function(e, t) {
                var n = new e();
                return function(e) {
                    if (!e) return {};
                    var a, r, i, s = n.get(e);
                    return s || (r = t(e), r.length && (i = r[0].v1Compatibility), i && i.config ? s = i.config : (a = e.dockerImageMetadata || {}, 
                    a.Config && (s = a.Config)), n.set(e, s)), s || {};
                };
            } ]).factory("imageLayers", [ "WeakMap", "imageDockerManifest", function(e, t) {
                var n = new e();
                return function(e) {
                    if (!e) return [];
                    var a, r = n.get(e);
                    return r || (a = t(e), r = a.history ? a.history : e.dockerImageLayers ? e.dockerImageLayers : [], 
                    n.set(e, r)), r;
                };
            } ]).directive("registryImageBody", [ "imageLayers", "imageDockerConfig", function(e, t) {
                return {
                    restrict: "E",
                    scope: {
                        image: "=",
                        names: "="
                    },
                    templateUrl: "registry-image-widgets/views/image-body.html",
                    link: function(n, a, r) {
                        n.$watch("image", function(a) {
                            n.layers = e(a), n.config = t(a), n.labels = n.config.Labels, angular.equals({}, n.labels) && (n.labels = null);
                        });
                    }
                };
            } ]).directive("registryImagePull", [ function() {
                return {
                    restrict: "E",
                    scope: {
                        settings: "=",
                        names: "="
                    },
                    templateUrl: "registry-image-widgets/views/image-pull.html"
                };
            } ]).directive("registryImageConfig", [ "imageDockerConfig", function(e) {
                return {
                    restrict: "E",
                    scope: {
                        image: "="
                    },
                    templateUrl: "registry-image-widgets/views/image-config.html",
                    link: function(t, n, a) {
                        t.configCommand = function(e) {
                            var t = [];
                            if (!e) return "";
                            e.Entrypoint && t.push.apply(t, e.Entrypoint), e.Cmd && t.push.apply(t, e.Cmd);
                            var n = t.join(" ");
                            return e.User && "root" != e.User.split(":")[0] ? "$ " + n : "# " + n;
                        }, t.$watch("image", function(n) {
                            t.config = e(n);
                        });
                    }
                };
            } ]).directive("registryImageMeta", [ "imageDockerConfig", function(e) {
                return {
                    restrict: "E",
                    scope: {
                        image: "="
                    },
                    templateUrl: "registry-image-widgets/views/image-meta.html",
                    link: function(t, n, a) {
                        t.$watch("image", function(n) {
                            t.config = e(n), t.labels = t.config.Labels, angular.equals({}, t.labels) && (t.labels = null);
                        });
                    }
                };
            } ]).directive("registryImagestreamBody", [ function() {
                return {
                    restrict: "E",
                    scope: {
                        imagestream: "=",
                        imagestreamFunc: "&imagestreamModify",
                        projectFunc: "&projectModify",
                        sharingFunc: "&projectSharing"
                    },
                    templateUrl: "registry-image-widgets/views/imagestream-body.html",
                    link: function(e, t, n) {
                        e.projectModify = e.projectFunc(), e.projectSharing = e.sharingFunc(), e.imagestreamModify = e.imagestreamFunc();
                    }
                };
            } ]).directive("registryImagestreamPush", [ function(e) {
                return {
                    restrict: "E",
                    scope: {
                        imagestream: "=",
                        settings: "="
                    },
                    templateUrl: "registry-image-widgets/views/imagestream-push.html"
                };
            } ]).directive("registryImagestreamMeta", [ function(e) {
                return {
                    restrict: "E",
                    scope: {
                        imagestream: "="
                    },
                    templateUrl: "registry-image-widgets/views/imagestream-meta.html"
                };
            } ]);
        }();
    }, function(e, t) {
        angular.module("registryUI.client", []).factory("WeakMap", function() {
            function e() {
                var e = "weakmap" + n;
                n += 1, t || (t = Math.random().toString(36).slice(2));
                var a = this;
                a.delete = function(n) {
                    var a = n[t];
                    a && delete a[e];
                }, a.has = function(n) {
                    var a = n[t];
                    return a && e in a;
                }, a.get = function(n) {
                    var a = n[t];
                    if (a) return a[e];
                }, a.set = function(n, a) {
                    var r = n[t];
                    r || (r = function() {}, Object.defineProperty(n, t, {
                        enumerable: !1,
                        configurable: !1,
                        writable: !1,
                        value: r
                    })), r[e] = a;
                };
            }
            if ("function" == typeof window.WeakMap) return window.WeakMap;
            var t, n = 1;
            return e;
        });
    }, function(e, t) {
        !function() {
            angular.module("registryUI.date", []).factory("dateRefreshMinute", [ "$rootScope", function(e) {
                var t = null;
                return {
                    enable: function() {
                        null === t && (t = window.setInterval(function() {
                            e.$applyAsync();
                        }, 6e4));
                    },
                    disable: function() {
                        null !== t && (window.clearInterval(t), t = null);
                    }
                };
            } ]).filter("dateRelative", [ "dateRefreshMinute", function() {
                function e(e) {
                    return e ? moment(e).fromNow() : e;
                }
                function t(e) {
                    return e;
                }
                return e.$stateful = !0, "function" == typeof moment ? e : t;
            } ]);
        }();
    }, function(e, t) {
        !function() {
            "use strict";
            function e(e, t) {
                var n, a;
                return e.v1Compatibility.container_config && (n = e.v1Compatibility.container_config.Cmd) ? (a = n[n.length - 1], 
                0 === a.indexOf("#(nop)") ? a.substring(6).trim() : 1 == n.length && 0 === n[0].indexOf("/bin/sh -c #(nop)") ? n[0].substring(17).trim() : n.join(" ")) : e.v1Compatibility.id;
            }
            angular.module("registryUI.images").factory("prepareLayer", [ "gettextCatalog", function(t) {
                return function(n, a, r) {
                    var i;
                    return i = n.v1Compatibility ? {
                        id: n.v1Compatibility.id,
                        size: n.v1Compatibility.Size || 0,
                        label: e(n, r[a + 1])
                    } : n.name && n.size ? {
                        id: n.name,
                        size: n.size || 0,
                        label: n.name
                    } : {
                        size: 0,
                        id: a,
                        label: t.getString("Unknown layer")
                    }, 0 === i.label.indexOf("RUN ") ? i.hint = "run" : 0 === i.label.indexOf("ADD ") || i.size > 8192 ? i.hint = "add" : i.hint = "other", 
                    i;
                };
            } ]).directive("registryImageLayers", [ "imageLayers", "prepareLayer", "gettextCatalog", function(e, t, n) {
                return {
                    restrict: "E",
                    scope: {
                        image: "=",
                        data: "=?layers"
                    },
                    templateUrl: "registry-image-widgets/views/image-layers.html",
                    link: function(a, r, i) {
                        a.formatSize = function(e) {
                            var t;
                            return e ? e > 1024 && "undefined" != typeof cockpit ? cockpit.format_bytes(e) : e > 1048576 ? (t = (e / 1048576).toFixed(1), 
                            n.getPlural(t, a, "{0} MB", "{0} MB").replace("{0}", t)) : n.getPlural(t, a, "{0} byte", "{0} bytes").replace("{0}", e) : "";
                        }, a.$watch("data", function(e) {
                            e && e.length && (e = e.map(t).reverse()), a.layers = e;
                        }), a.$watch("image", function(t) {
                            angular.isUndefined(t) || (a.data = e(t));
                        });
                    }
                };
            } ]);
        }();
    }, function(e, t) {}, , function(e, t) {}, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var r = '<dl class="dl-horizontal left"> <dt ng-if="labels.name" translate>Name</dt> <dd ng-if="labels.name">{{ labels.name }}</dd> <dt ng-if="labels.summary" translate>Summary</dt> <dd ng-if="labels.summary">{{ labels.summary }}</dd> <dt ng-if="labels.description" translate>Description</dt> <dd ng-if="labels.description">{{ labels.description }}</dd> <dt ng-if="labels.url" translate>Source URL</dt> <dd ng-if="labels.url"> <a href="labels.url"><i class="fa fa-external-link"></i> {{ labels.url }}</a> </dd> <dt translate>Author</dt> <dd ng-if="config.author">{{config.author}}</dd> <dd ng-if="!config.author && image.dockerImageMetadata.Author">{{image.dockerImageMetadata.Author}}</dd> <dd ng-if="!config.author && !image.dockerImageMetadata.Author"><em translate>Unknown</em></dd> <dt ng-if="labels[\'build-date\'] || layers[0].v1Compatibility.created || image.dockerImageMetadata.Created" translate>Built</dt> <dd ng-if="labels[\'build-date\']" title="{{labels[\'build-date\']}}">{{ labels[\'build-date\'] | dateRelative}}</dd> <dd ng-if="!labels[\'build-date\'] && layers[0].v1Compatibility.created" title="{{layers[0].v1Compatibility.created}}">{{ layers[0].v1Compatibility.created | dateRelative}}</dd> <dd ng-if="!labels[\'build-date\'] && !layers[0].v1Compatibility.created && image.dockerImageMetadata.Created" title="{{image.dockerImageMetadata.Created}}">{{image.dockerImageMetadata.Created | dateRelative}}</dd> <dt translate>Digest</dt> <dd><tt>{{ image.metadata.name }}</tt></dd> <dt translate>Identifier</dt> <dd><tt>{{ config.Image }}</tt></dd> </dl> <dl class="registry-image-tags" ng-if="names"> <dt translate>Tags</dt> <dd><span class="registry-image-tag" ng-repeat="name in names">{{name}}</span></dd> </dl>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/image-body.html", r);
        } ]), e.exports = r;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var r = '<dl class="dl-horizontal"> <dt translate>Command:</dt> <dd><code>{{ configCommand(config) }}</code></dd> </dl> <div class="row"> <dl class="col-xs-12 col-sm-12 col-md-4 dl-horizontal"> <dt translate>Run as</dt> <dd ng-if="config.User">{{config.User}}</dd> <dd ng-if="!config.User"><em translate>Default</em></dd> <dt translate>Directory</dt> <dd ng-if="config.WorkingDir">{{config.WorkingDir}}</dd> <dd ng-if="!config.WorkingDir">/</dd> <dt ng-if="config.StopSignal" translate>Stop with</dt> <dd ng-if="config.StopSignal">{{config.StopSignal}}</dd> <dt translate>Architecture</dt> <dd ng-if="config.architecture">{{config.architecture}}</dd> <dd ng-if="!config.architecture">{{image.dockerImageMetadata.Architecture}}</dd> </dl> <dl class="col-xs-12 col-sm-12 col-md-8 dl-horizontal full-width"> <dt ng-if="config.Env.length" translate>Environment</dt> <dd ng-repeat="env in config.Env"><tt>{{env}}</tt></dd> </dl> </div> <div class="row"> <dl class="col-xs-12 col-sm-12 col-md-4 dl-horizontal"> <dt translate>Ports</dt> <dd ng-repeat="(port, data) in config.ExposedPorts">{{port}}</dd> <dd ng-if="!config.ExposedPorts"><em translate>None</em></dd> </dl> <dl class="col-xs-12 col-sm-12 col-md-8 dl-horizontal full-width"> <dt ng-if="config.Volumes" translate>Volumes</dt> <dd ng-repeat="(volume, data) in config.Volumes">{{volume}}</dd> </dl> </div>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/image-config.html", r);
        } ]), e.exports = r;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var r = '<div> <dl class="dl-horizontal left"> <dt ng-if="labels" translate>Labels</dt> <dd ng-repeat="(name, value) in labels" ng-show="name != \'description\' && name != \'name\'"> <tt>{{name}}={{value}}</tt> </dd> <dt ng-if="config.OnBuild.length" translate>On Build</dt> <dd ng-repeat="line in config.OnBuild"><tt>{{line}}</tt></dd> <dt ng-if="image.metadata.annotations" translate>Annotations</dt> <dd ng-repeat="(name, value) in image.metadata.annotations">{{name}}: {{value}}</dd> <dt translate>Docker Version</dt> <dd>{{image.dockerImageMetadata.DockerVersion}}</dd> </dl> </div>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/image-meta.html", r);
        } ]), e.exports = r;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var r = '<ul class="registry-image-layers"> <li ng-repeat="layer in layers" class="hint-{{ layer.hint }}"> <span title="{{ layer.size }}">{{ formatSize(layer.size) }}</span> <p>{{ layer.label}}</p> </li> </ul>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/image-layers.html", r);
        } ]), e.exports = r;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var r = '<div ng-if="names" class="registry-image-pull"> <p> <i class="fa fa-info-circle"></i>\n<span translate>To pull this image:</span> </p> <code ng-if="!settings.registry.host">$ sudo docker pull <span class="placeholder">registry</span>/{{names[0]}}</code>\n<code ng-if="settings.registry.host">$ sudo docker pull <span>{{settings.registry.host}}</span>/{{names[0]}}</code> </div>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/image-pull.html", r);
        } ]), e.exports = r;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var r = '<div ng-repeat="statustags in imagestream.status.tags"> <div ng-repeat="condition in statustags.conditions" ng-if="condition.type == \'ImportSuccess\' && condition.status == \'False\'" class="alert alert-danger"> <span class="pficon pficon-error-circle-o"></span>\n<span translate>{{ condition.message }}. Timestamp: {{ condition.lastTransitionTime }} Error count: {{ condition.generation }}</span>\n<a translate ng-if="imagestreamModify" ng-click="imagestreamModify(imagestream)" class="alert-link">Edit image stream</a> </div> </div> <dl class="dl-horizontal left"> <dt translate>Access Policy</dt> <dd ng-switch="projectSharing(imagestream.metadata.namespace)"> <div ng-switch-when="anonymous"> <a translate ng-click="projectModify(imagestream.metadata.namespace)">Images may be pulled by anonymous users</a>\n<i title="Images accessible to anonymous users" class="fa fa-unlock registry-imagestream-lock"></i> </div> <div ng-switch-when="shared"> <a translate ng-click="projectModify(imagestream.metadata.namespace)">Images may be pulled by any authenticated user or group</a>\n<i title="Images accessible to authenticated users" class="fa fa-lock registry-imagestream-lock"></i> </div> <div ng-switch-when="private"> <a translate ng-click="projectModify(imagestream.metadata.namespace)">Images may only be pulled by specific users or groups</a>\n<i title="Images only accessible to members" class="fa fa-lock registry-imagestream-lock"></i> </div> <div ng-switch-default> <a translate ng-click="projectModify(imagestream.metadata.namespace)">Unknown</a>\n<i title="Unknown or invalid image access policy" class="fa fa-lock registry-imagestream-lock"></i> </div> </dd> <dt translate>Pull repository</dt> <dd ng-if="imagestream.spec.dockerImageRepository"><tt>{{imagestream.spec.dockerImageRepository}}</tt></dd> <dd ng-if="!imagestream.spec.dockerImageRepository"><em translate>None</em></dd> <dt translate>Image count</dt> <dd>{{imagestream.status.tags.length}}</dd> </dl>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/imagestream-body.html", r);
        } ]), e.exports = r;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var r = '<dl class="dl-horizontal left"> <dt ng-if="imagestream.metadata.annotations" translate>Annotations</dt> <dd ng-repeat="(name, value) in imagestream.metadata.annotations">{{name}}: {{value}}</dd> </dl>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/imagestream-meta.html", r);
        } ]), e.exports = r;
    }, function(e, t) {
        var n, a = window.angular;
        try {
            n = a.module([ "ng" ]);
        } catch (e) {
            n = a.module("ng", []);
        }
        var r = '<div class="registry-imagestream-push"> <p> <i class="fa fa-info-circle"></i>\n<span translate>To push to an image to this image stream:</span> </p> <code ng-if="settings.registry.host">$ sudo docker tag <em>myimage</em> <span>{{settings.registry.host}}</span>/{{ imagestream.metadata.namespace }}/{{ imagestream.metadata.name}}:<em>tag</em>\n$ sudo docker push <span>{{settings.registry.host}}</span>/{{ imagestream.metadata.namespace }}/{{ imagestream.metadata.name}}</code>\n<code ng-if="!settings.registry.host">$ sudo docker tag <em>myimage</em> <span class="placeholder">registry</span>/{{ imagestream.metadata.namespace }}/{{ imagestream.metadata.name}}:<em>tag</em>\n$ sudo docker push <span class="placeholder">registry</span>/{{ imagestream.metadata.namespace }}/{{ imagestream.metadata.name}}</code> </div>';
        n.run([ "$templateCache", function(e) {
            e.put("registry-image-widgets/views/imagestream-push.html", r);
        } ]), e.exports = r;
    } ]);
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<table listing-table class="listing-ct images-listing"> <thead> <tr ng-if="!listing.inline"> <td colspan="4"> <a class="pull-right" ng-click="createImageStream()"> <i translate class="pficon pficon-add-circle-o"></i>\n<span translate>New image stream</span> </a> <h3 translate>Images</h3> </td> </tr> <tr> <th class="listing-ct-toggle"></th> <th translate>Tags</th> <th translate>Author</th> <th translate>Last Updated</th> </tr> </thead> <tbody ng-repeat-start="(link, stream) in imagestreams() track by link" ng-init="sid = stream.metadata.namespace + \'/\' + stream.metadata.name" data-id="{{ sid }}" class="active" ng-class="{open: listing.expanded(sid)}"> <tr ng-if="!listing.inline" ng-click="listing.activate(sid)" class="listing-ct-item imagestream-item"> <td ng-click="listing.toggle(sid, $event)" class="listing-ct-toggle"> <i class="fa fa-fw"></i> </td> <th colspan="4"> {{ sid }} <div class="listing-status" ng-repeat="statustags in stream.status.tags"> <span ng-repeat="condition in statustags.conditions" ng-if="condition.type == \'ImportSuccess\' && condition.status == \'False\'" class="pficon pficon-warning-triangle-o"></span> </div>  </th> </tr> <tr class="listing-ct-panel" ng-if="listing.expanded(sid)" ng-init="id = sid"> <td listing-panel kind="ImageStream" colspan="4"></td> </tr> </tbody> <tbody ng-repeat="tag in stream.status.tags track by tag.tag" ng-init="iid = sid + \':\' + tag.tag" data-id="{{ iid }}" ng-class="{open: listing.expanded(iid), last: $last, first: $first}"> <tr ng-click="listing.activate(iid)" class="listing-ct-item tag-item" ng-repeat-start="image in imageByTag(tag)"> <td ng-click="listing.toggle(iid, $event)" class="listing-ct-toggle"> <i class="fa fa-fw"></i> </td> <td class="tag-label"><span class="image-tag">:{{ tag.tag }}</span></td> <td colspan="3" class="container"> <div class="row"> <div class="col col-xs-12"><tt>{{ image.metadata.name }}</tt></div> </div> <div class="row"> <div class="col col-xs-6 text-left" ng-if="conf.author">{{ conf.author }}</div> <div class="col col-xs-6 text-left" ng-if="!conf.author">{{ image.dockerImageMetadata.Author }}</div> <div class="col col-xs-6" title="{{ tag.items[0].created }}">{{ tag.items[0].created | dateRelative }}</div> </div> </td> </tr> <tr class="listing-ct-panel" ng-if="listing.expanded(iid)" ng-init="id = iid" ng-repeat-end=""> <td image-panel colspan="4"></td> </tr> </tbody> <tbody data-ng-rubbish="" ng-if="0" ng-repeat-end> </tbody> <thead class="listing-ct-empty" ng-if="!quiet"> <tr> <td colspan="4" ng-if="!failure" translate>No image streams are present.</td> <td colspan="4" ng-if="failure">{{failure}}</td> </tr> </thead> </table>';
    n.run([ "$templateCache", function(e) {
        e.put("views/image-listing.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<modal-dialog> <div class="modal-header"> <h3 class="modal-title" translate>Delete image stream</h3> </div> <div class="modal-body" translate>Do you want to delete the \'{{stream.metadata.namespace}}/{{stream.metadata.name}}\' image stream?</div> <div class="modal-footer"> <button class="btn btn-default btn-cancel" translate>Cancel</button>\n<button class="btn btn-danger" translate ng-click="complete(performDelete())">Delete</button> </div> </modal-dialog>';
    n.run([ "$templateCache", function(e) {
        e.put("views/imagestream-delete.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<modal-dialog> <div class="modal-header"> <h3 class="modal-title" ng-if="!stream" translate>Create image stream</h3> <h3 class="modal-title" ng-if="stream" translate>Change image stream</h3> </div> <div class="modal-body"> <table class="form-table-ct"> <tr> <td> <label class="control-label" for="imagestream-modify-name" translate>Name</label> </td> <td> <input id="imagestream-modify-name" class="form-control" type="text" ng-if="!stream" ng-model="fields.name" placeholder="{{ placeholder }}" autofocus>\n<span id="imagestream-modify-name" ng-if="stream">{{ fields.name }}</span> </td> </tr> <tr> <td class="top"> <label class="control-label" for="imagestream-modify-project-text" translate>Project</label> </td> <td> <div ng-if="!stream" id="imagestream-modify-project" class="input-group input-combo"> <input class="form-control" id="imagestream-modify-project-text" type="text" ng-model="fields.project">\n<span class="input-group-btn" dropdown> <button class="btn btn-default dropdown-toggle" dropdown-toggle type="button"> <span class="caret"></span> </button> <ul dropdown-menu class="dropdown-menu" role="menu"> <li ng-repeat="name in projects() track by name" ng-class="{ checked: name == fields.project }"> <a ng-click="fields.project = name" value="{{name}}">{{ name }}</a> </li> </ul> </span> </div> <span id="imagestream-modify-project" ng-if="stream">{{ fields.project }}</span> </td> </tr> <tr> <td class="top"> <label class="control-label" for="imagestream-modify-populate" translate>Populate</label> </td> <td> <div class="btn-group bootstrap-select form-control" dropdown id="imagestream-modify-populate"> <button class="btn btn-default dropdown-toggle" dropdown-toggle> <span class="pull-left">{{ labels.populate[fields.populate] }}</span>\n<span class="caret"></span> </button> <ul class="dropdown-menu"> <li ng-repeat="(value, label) in labels.populate" ng-class="{checked: value == fields.populate}"> <a ng-click="fields.populate = value" value="{{value}}">{{ label }}</a> </li> </ul> </div> </td> </tr> <tr ng-show="fields.populate != \'none\'"> <td class="top"> <label class="control-label" for="imagestream-modify-pull" translate>Pull from</label> </td> <td> <input id="imagestream-modify-pull" class="form-control" type="text" ng-model="fields.pull" placeholder="eg: docker.io/library/fedora"> </td> </tr> <tr ng-show="fields.populate == \'tags\'"> <td class="top"> <label class="control-label" for="imagestream-modify-tags" translate>Tags</label> </td> <td> <div image-tag-editor id="imagestream-modify-tags" tags="fields.tags"> </div> </td> </tr> <tr ng-show="fields.populate == \'tags\'"> <td></td> <td> <label> <input type="checkbox" ng-checked="hasInsecureTag(stream.spec)" ng-model="fields.insecure">\n<span translate>Remote registry is insecure</span> </label> </td> </tr> </table> </div> <div class="modal-footer"> <button class="btn btn-default btn-cancel" translate>Cancel</button>\n<button class="btn btn-primary" ng-if="stream" ng-click="complete(performModify())">Change</button>\n<button class="btn btn-primary" ng-if="!stream" ng-click="complete(performCreate())">Create</button> </div> </modal-dialog>';
    n.run([ "$templateCache", function(e) {
        e.put("views/imagestream-modify.html", r);
    } ]), e.exports = r;
}, function(e, t) {
    var n, a = window.angular;
    try {
        n = a.module([ "ng" ]);
    } catch (e) {
        n = a.module("ng", []);
    }
    var r = '<modal-dialog> <div class="modal-header"> <h3 class="modal-title" translate>Remove image tag</h3> </div> <div class="modal-body" translate>Do you want to remove the image tagged as \'{{stream.metadata.namespace}}/{{stream.metadata.name}}:{{tag.tag}}\'?</div> <div class="modal-footer"> <button class="btn btn-default btn-cancel" translate>Cancel</button>\n<button class="btn btn-danger" translate ng-click="complete(performDelete())">Delete</button> </div> </modal-dialog>';
    n.run([ "$templateCache", function(e) {
        e.put("views/image-delete.html", r);
    } ]), e.exports = r;
}, , , , , function(e, t, n) {
    "use strict";
    !function() {
        window.QUnit = n(246), window.qunitTap = n(248), n(249), n(250), e.exports = window.QUnit;
    }();
}, function(e, t, n) {
    var a;
    (function(e, r) {
        /*!
	 * QUnit 1.23.1
	 * https://qunitjs.com/
	 *
	 * Copyright jQuery Foundation and other contributors
	 * Released under the MIT license
	 * https://jquery.org/license
	 *
	 * Date: 2016-04-12T17:29Z
	 */
        !function(e) {
            function i(e, t) {
                var n, a, r = e.slice();
                for (n = 0; n < r.length; n++) for (a = 0; a < t.length; a++) if (r[n] === t[a]) {
                    r.splice(n, 1), n--;
                    break;
                }
                return r;
            }
            function s(e, t) {
                if (t.indexOf) return t.indexOf(e);
                for (var n = 0, a = t.length; n < a; n++) if (t[n] === e) return n;
                return -1;
            }
            function o(e) {
                var t, n, a = A.is("array", e) ? [] : {};
                for (t in e) R.call(e, t) && (n = e[t], a[t] = n === Object(n) ? o(n) : n);
                return a;
            }
            function l(t, n, a) {
                for (var r in n) R.call(n, r) && ("constructor" === r && t === e || (void 0 === n[r] ? delete t[r] : a && "undefined" != typeof t[r] || (t[r] = n[r])));
                return t;
            }
            function u(e) {
                if ("undefined" == typeof e) return "undefined";
                if (null === e) return "null";
                var t = q.call(e).match(/^\[object\s(.*)\]$/), n = t && t[1];
                switch (n) {
                  case "Number":
                    return isNaN(e) ? "nan" : "number";

                  case "String":
                  case "Boolean":
                  case "Array":
                  case "Set":
                  case "Map":
                  case "Date":
                  case "RegExp":
                  case "Function":
                  case "Symbol":
                    return n.toLowerCase();
                }
                return "object" == typeof e ? "object" : void 0;
            }
            function c(e, t) {
                return A.objectType(t) === e;
            }
            function d(e, t) {
                t = void 0 === t ? 4 : t;
                var n, a, r;
                if (e.stack) {
                    if (n = e.stack.split("\n"), /^error$/i.test(n[0]) && n.shift(), N) {
                        for (a = [], r = t; r < n.length && n[r].indexOf(N) === -1; r++) a.push(n[r]);
                        if (a.length) return a.join("\n");
                    }
                    return n[t];
                }
                if (e.sourceURL) {
                    if (/qunit.js$/.test(e.sourceURL)) return;
                    return e.sourceURL + ":" + e.line;
                }
            }
            function m(e) {
                var t = new Error();
                if (!t.stack) try {
                    throw t;
                } catch (e) {
                    t = e;
                }
                return d(t, e);
            }
            function f(e) {
                function t(e) {
                    var t = function(t) {
                        if ("function" !== u(t)) throw new Error("QUnit logging methods require a callback function as their first parameters.");
                        z.callbacks[e].push(t);
                    };
                    return B[e] = t, t;
                }
                var n, a, r, i = [ "begin", "done", "log", "testStart", "testDone", "moduleStart", "moduleDone" ];
                for (n = 0, a = i.length; n < a; n++) r = i[n], "undefined" === u(z.callbacks[r]) && (z.callbacks[r] = []), 
                e[r] = t(r);
            }
            function p(e, t) {
                var n, a, r;
                for (r = z.callbacks[e], n = 0, a = r.length; n < a; n++) r[n](t);
            }
            function h() {
                var t, n;
                for (t in B) A[t] !== B[t] && (n = A[t], A[t] = B[t], A[t](n), e.console && e.console.warn && e.console.warn("QUnit." + t + " was replaced with a new value.\nPlease, check out the documentation on how to apply logging callbacks.\nReference: https://api.qunitjs.com/category/callbacks/"));
            }
            function g() {
                var e, t, n = [];
                if (!z.started) {
                    for (z.started = O(), h(), "" === z.modules[0].name && 0 === z.modules[0].tests.length && z.modules.shift(), 
                    e = 0, t = z.modules.length; e < t; e++) n.push({
                        name: z.modules[e].name,
                        tests: z.modules[e].tests
                    });
                    p("begin", {
                        totalTests: $.count,
                        modules: n
                    });
                }
                z.blocking = !1, _(!0);
            }
            function _(e) {
                function t() {
                    _(e);
                }
                var n = O();
                for (z.depth = (z.depth || 0) + 1; z.queue.length && !z.blocking; ) {
                    if (!(!U.setTimeout || z.updateRate <= 0 || O() - n < z.updateRate)) {
                        I(t, 13);
                        break;
                    }
                    z.current && (z.current.usedAsync = !1), z.queue.shift()();
                }
                z.depth--, !e || z.blocking || z.queue.length || 0 !== z.depth || y();
            }
            function v() {
                z.blocking = !0, z.testTimeout && U.setTimeout && (P(z.timeout), z.timeout = I(function() {
                    if (!z.current) throw new Error("Test timed out");
                    z.current.semaphore = 0, A.pushFailure("Test timed out", m(2)), b();
                }, z.testTimeout));
            }
            function b() {
                W = !0, U.setTimeout ? I(function() {
                    z.current && z.current.semaphore > 0 || (z.timeout && P(z.timeout), g());
                }, 13) : g();
            }
            function y() {
                var e, t;
                z.autorun = !0, z.previousModule && p("moduleDone", {
                    name: z.previousModule.name,
                    tests: z.previousModule.tests,
                    failed: z.moduleStats.bad,
                    passed: z.moduleStats.all - z.moduleStats.bad,
                    total: z.moduleStats.all,
                    runtime: O() - z.moduleStats.started
                }), delete z.previousModule, e = O() - z.started, t = z.stats.all - z.stats.bad, 
                p("done", {
                    failed: z.stats.bad,
                    passed: t,
                    total: z.stats.all,
                    runtime: e
                });
            }
            function M(e, t) {
                return void 0 === e.testEnvironment && (e.testEnvironment = {}), function(n) {
                    e.testEnvironment[t] = n;
                };
            }
            function $(e) {
                var t, n;
                for (++$.count, l(this, e), this.assertions = [], this.semaphore = 0, this.usedAsync = !1, 
                this.module = z.currentModule, this.stack = m(3), t = 0, n = this.module.tests; t < n.length; t++) this.module.tests[t].name === this.testName && (this.testName += " ");
                this.testId = k(this.module.name, this.testName), this.module.tests.push({
                    name: this.testName,
                    testId: this.testId
                }), e.skip ? (this.callback = function() {}, this.async = !1, this.expected = 0) : this.assert = new E(this);
            }
            function k(e, t) {
                for (var n, a = 0, r = 0, i = e + "" + t, s = i.length; a < s; a++) r = (r << 5) - r + i.charCodeAt(a), 
                r |= 0;
                return n = (4294967296 + r).toString(16), n.length < 8 && (n = "0000000" + n), n.slice(-8);
            }
            function w(e, t, n) {
                var a, r = !t;
                if ("array" !== A.objectType(e)) t ? z.queue.splice(K++, 0, e) : n ? (G || (G = L(n)), 
                a = Math.floor(G() * (z.queue.length - K + 1)), z.queue.splice(K + a, 0, e)) : z.queue.push(e), 
                z.autorun && !z.blocking && _(r); else for (;e.length; ) w(e.shift());
            }
            function L(e) {
                var t = parseInt(k(e), 16) || -1;
                return function() {
                    return t ^= t << 13, t ^= t >>> 17, t ^= t << 5, t < 0 && (t += 4294967296), t / 4294967296;
                };
            }
            function D() {
                if (z.pollution = [], z.noglobals) for (var t in e) if (R.call(e, t)) {
                    if (/^qunit-test-output/.test(t)) continue;
                    z.pollution.push(t);
                }
            }
            function Y() {
                var e, t, n = z.pollution;
                D(), e = i(z.pollution, n), e.length > 0 && A.pushFailure("Introduced global variable(s): " + e.join(", ")), 
                t = i(n, z.pollution), t.length > 0 && A.pushFailure("Deleted global variable(s): " + t.join(", "));
            }
            function T(e, t, n) {
                2 === arguments.length && (n = t, t = null), A.test(e, t, n, !0);
            }
            function S(e, t, n, a) {
                if (!J) {
                    var r;
                    2 === arguments.length && (n = t, t = null), r = new $({
                        testName: e,
                        expected: t,
                        async: a,
                        callback: n
                    }), r.queue();
                }
            }
            function x(e) {
                if (!J) {
                    var t = new $({
                        testName: e,
                        skip: !0
                    });
                    t.queue();
                }
            }
            function C(e, t, n, a) {
                var r;
                J || (A.config.queue.length = 0, J = !0, 2 === arguments.length && (n = t, t = null), 
                r = new $({
                    testName: e,
                    expected: t,
                    async: a,
                    callback: n
                }), r.queue());
            }
            function E(e) {
                this.test = e;
            }
            function H(e) {
                var t, n, a = e.toString();
                return "[object" === a.substring(0, 7) ? (t = e.name ? e.name.toString() : "Error", 
                n = e.message ? e.message.toString() : "", t && n ? t + ": " + n : t ? t : n ? n : "Error") : a;
            }
            var A = {}, j = e.Date, O = j.now || function() {
                return new j().getTime();
            }, I = e.setTimeout, P = e.clearTimeout, F = e.window, U = {
                document: F && void 0 !== F.document,
                setTimeout: void 0 !== I,
                sessionStorage: function() {
                    var e = "qunit-test-string";
                    try {
                        return sessionStorage.setItem(e, e), sessionStorage.removeItem(e), !0;
                    } catch (e) {
                        return !1;
                    }
                }()
            }, N = (m(0) || "").replace(/(:\d+)+\)?/, "").replace(/.+\//, ""), V = !1, W = !1, q = Object.prototype.toString, R = Object.prototype.hasOwnProperty, z = {
                queue: [],
                blocking: !0,
                reorder: !0,
                altertitle: !0,
                collapse: !0,
                scrolltop: !0,
                maxDepth: 5,
                requireExpects: !1,
                urlConfig: [],
                modules: [],
                moduleStack: [],
                currentModule: {
                    name: "",
                    tests: []
                },
                callbacks: {}
            };
            z.modules.push(z.currentModule);
            var B = {};
            !function() {
                if (U.document) {
                    var e = F.onerror;
                    F.onerror = function(t, n, a) {
                        var r = !1;
                        if (e && (r = e(t, n, a)), r !== !0) {
                            if (A.config.current) {
                                if (A.config.current.ignoreGlobalErrors) return !0;
                                A.pushFailure(t, n + ":" + a);
                            } else A.test("global failure", l(function() {
                                A.pushFailure(t, n + ":" + a);
                            }, {
                                validTest: !0
                            }));
                            return !1;
                        }
                        return r;
                    };
                }
            }(), A.isLocal = !(U.document && "file:" !== F.location.protocol), A.version = "1.23.1", 
            l(A, {
                module: function(e, t, n) {
                    function a() {
                        var n = z.moduleStack.length ? z.moduleStack.slice(-1)[0] : null, a = null !== n ? [ n.name, e ].join(" > ") : e, r = {
                            name: a,
                            parentModule: n,
                            tests: [],
                            moduleId: k(a)
                        }, i = {};
                        return n && (l(i, n.testEnvironment), delete i.beforeEach, delete i.afterEach), 
                        l(i, t), r.testEnvironment = i, z.modules.push(r), r;
                    }
                    function r(e) {
                        z.currentModule = e;
                    }
                    var i, s, o = z.currentModule;
                    2 === arguments.length && "function" === u(t) && (n = t, t = void 0), t && t.setup && (t.beforeEach = t.setup, 
                    delete t.setup), t && t.teardown && (t.afterEach = t.teardown, delete t.teardown), 
                    i = a(), s = {
                        beforeEach: M(i, "beforeEach"),
                        afterEach: M(i, "afterEach")
                    }, "function" === u(n) && (z.moduleStack.push(i), r(i), n.call(i.testEnvironment, s), 
                    z.moduleStack.pop(), i = i.parentModule || o), r(i);
                },
                asyncTest: T,
                test: S,
                skip: x,
                only: C,
                start: function(e) {
                    var t = V;
                    if (z.current) {
                        if (z.current.semaphore -= e || 1, isNaN(z.current.semaphore)) return z.current.semaphore = 0, 
                        void A.pushFailure("Called start() with a non-numeric decrement.", m(2));
                        if (z.current.semaphore > 0) return;
                        if (z.current.semaphore < 0) return z.current.semaphore = 0, void A.pushFailure("Called start() while already started (test's semaphore was 0 already)", m(2));
                    } else {
                        if (V = !0, W) throw new Error("Called start() outside of a test context while already started");
                        if (t || e > 1) throw new Error("Called start() outside of a test context too many times");
                        if (z.autostart) throw new Error("Called start() outside of a test context when QUnit.config.autostart was true");
                        if (!z.pageLoaded) return void (z.autostart = !0);
                    }
                    b();
                },
                stop: function(e) {
                    if (!z.current) throw new Error("Called stop() outside of a test context");
                    z.current.semaphore += e || 1, v();
                },
                config: z,
                is: c,
                objectType: u,
                extend: l,
                load: function() {
                    z.pageLoaded = !0, l(z, {
                        stats: {
                            all: 0,
                            bad: 0
                        },
                        moduleStats: {
                            all: 0,
                            bad: 0
                        },
                        started: 0,
                        updateRate: 1e3,
                        autostart: !0,
                        filter: ""
                    }, !0), z.blocking = !1, z.autostart && b();
                },
                stack: function(e) {
                    return e = (e || 0) + 2, m(e);
                }
            }), f(A);
            var G, J = !1, K = 0;
            $.count = 0, $.prototype = {
                before: function() {
                    this.module === z.previousModule && R.call(z, "previousModule") || (R.call(z, "previousModule") && p("moduleDone", {
                        name: z.previousModule.name,
                        tests: z.previousModule.tests,
                        failed: z.moduleStats.bad,
                        passed: z.moduleStats.all - z.moduleStats.bad,
                        total: z.moduleStats.all,
                        runtime: O() - z.moduleStats.started
                    }), z.previousModule = this.module, z.moduleStats = {
                        all: 0,
                        bad: 0,
                        started: O()
                    }, p("moduleStart", {
                        name: this.module.name,
                        tests: this.module.tests
                    })), z.current = this, this.module.testEnvironment && (delete this.module.testEnvironment.beforeEach, 
                    delete this.module.testEnvironment.afterEach), this.testEnvironment = l({}, this.module.testEnvironment), 
                    this.started = O(), p("testStart", {
                        name: this.testName,
                        module: this.module.name,
                        testId: this.testId
                    }), z.pollution || D();
                },
                run: function() {
                    function e(e) {
                        t = e.callback.call(e.testEnvironment, e.assert), e.resolvePromise(t);
                    }
                    var t;
                    if (z.current = this, this.async && A.stop(), this.callbackStarted = O(), z.notrycatch) return void e(this);
                    try {
                        e(this);
                    } catch (e) {
                        this.pushFailure("Died on test #" + (this.assertions.length + 1) + " " + this.stack + ": " + (e.message || e), d(e, 0)), 
                        D(), z.blocking && A.start();
                    }
                },
                after: function() {
                    Y();
                },
                queueHook: function(e, t) {
                    var n, a = this;
                    return function() {
                        function r() {
                            n = e.call(a.testEnvironment, a.assert), a.resolvePromise(n, t);
                        }
                        if (z.current = a, z.notrycatch) return void r();
                        try {
                            r();
                        } catch (e) {
                            a.pushFailure(t + " failed on " + a.testName + ": " + (e.message || e), d(e, 0));
                        }
                    };
                },
                hooks: function(e) {
                    function t(a, r) {
                        r.parentModule && t(a, r.parentModule), r.testEnvironment && "function" === A.objectType(r.testEnvironment[e]) && n.push(a.queueHook(r.testEnvironment[e], e));
                    }
                    var n = [];
                    return this.skip || t(this, this.module), n;
                },
                finish: function() {
                    z.current = this, z.requireExpects && null === this.expected ? this.pushFailure("Expected number of assertions to be defined, but expect() was not called.", this.stack) : null !== this.expected && this.expected !== this.assertions.length ? this.pushFailure("Expected " + this.expected + " assertions, but " + this.assertions.length + " were run", this.stack) : null !== this.expected || this.assertions.length || this.pushFailure("Expected at least one assertion, but none were run - call expect(0) to accept zero assertions.", this.stack);
                    var e, t = 0;
                    for (this.runtime = O() - this.started, z.stats.all += this.assertions.length, z.moduleStats.all += this.assertions.length, 
                    e = 0; e < this.assertions.length; e++) this.assertions[e].result || (t++, z.stats.bad++, 
                    z.moduleStats.bad++);
                    p("testDone", {
                        name: this.testName,
                        module: this.module.name,
                        skipped: !!this.skip,
                        failed: t,
                        passed: this.assertions.length - t,
                        total: this.assertions.length,
                        runtime: this.runtime,
                        assertions: this.assertions,
                        testId: this.testId,
                        source: this.stack,
                        duration: this.runtime
                    }), A.reset(), z.current = void 0;
                },
                queue: function() {
                    function e() {
                        w([ function() {
                            n.before();
                        }, n.hooks("beforeEach"), function() {
                            n.run();
                        }, n.hooks("afterEach").reverse(), function() {
                            n.after();
                        }, function() {
                            n.finish();
                        } ]);
                    }
                    var t, n = this;
                    if (this.valid()) return t = A.config.reorder && U.sessionStorage && +sessionStorage.getItem("qunit-test-" + this.module.name + "-" + this.testName), 
                    w(e, t, z.seed);
                },
                pushResult: function(e) {
                    var t, n = {
                        module: this.module.name,
                        name: this.testName,
                        result: e.result,
                        message: e.message,
                        actual: e.actual,
                        expected: e.expected,
                        testId: this.testId,
                        negative: e.negative || !1,
                        runtime: O() - this.started
                    };
                    e.result || (t = m(), t && (n.source = t)), p("log", n), this.assertions.push({
                        result: !!e.result,
                        message: e.message
                    });
                },
                pushFailure: function(e, t, n) {
                    if (!(this instanceof $)) throw new Error("pushFailure() assertion outside test context, was " + m(2));
                    var a = {
                        module: this.module.name,
                        name: this.testName,
                        result: !1,
                        message: e || "error",
                        actual: n || null,
                        testId: this.testId,
                        runtime: O() - this.started
                    };
                    t && (a.source = t), p("log", a), this.assertions.push({
                        result: !1,
                        message: e
                    });
                },
                resolvePromise: function(e, t) {
                    var n, a, r = this;
                    null != e && (n = e.then, "function" === A.objectType(n) && (A.stop(), n.call(e, function() {
                        A.start();
                    }, function(e) {
                        a = "Promise rejected " + (t ? t.replace(/Each$/, "") : "during") + " " + r.testName + ": " + (e.message || e), 
                        r.pushFailure(a, d(e, 0)), D(), A.start();
                    })));
                },
                valid: function() {
                    function e(t) {
                        var n = t.name ? t.name.toLowerCase() : null;
                        return n === r || !!t.parentModule && e(t.parentModule);
                    }
                    function t(e) {
                        return s(e.moduleId, z.moduleId) > -1 || e.parentModule && t(e.parentModule);
                    }
                    var n = z.filter, a = /^(!?)\/([\w\W]*)\/(i?$)/.exec(n), r = z.module && z.module.toLowerCase(), i = this.module.name + ": " + this.testName;
                    return !(!this.callback || !this.callback.validTest) || !(z.moduleId && z.moduleId.length > 0 && !t(this.module)) && (!(z.testId && z.testId.length > 0 && s(this.testId, z.testId) < 0) && (!(r && !e(this.module)) && (!n || (a ? this.regexFilter(!!a[1], a[2], a[3], i) : this.stringFilter(n, i)))));
                },
                regexFilter: function(e, t, n, a) {
                    var r = new RegExp(t, n), i = r.test(a);
                    return i !== e;
                },
                stringFilter: function(e, t) {
                    e = e.toLowerCase(), t = t.toLowerCase();
                    var n = "!" !== e.charAt(0);
                    return n || (e = e.slice(1)), t.indexOf(e) !== -1 ? n : !n;
                }
            }, A.reset = function() {
                if (U.document) {
                    var e = U.document && document.getElementById && document.getElementById("qunit-fixture");
                    e && (e.innerHTML = z.fixture);
                }
            }, A.pushFailure = function() {
                if (!A.config.current) throw new Error("pushFailure() assertion outside test context, in " + m(2));
                var e = A.config.current;
                return e.pushFailure.apply(e, arguments);
            }, A.assert = E.prototype = {
                expect: function(e) {
                    return 1 !== arguments.length ? this.test.expected : void (this.test.expected = e);
                },
                async: function(e) {
                    var t = this.test, n = !1, a = e;
                    return "undefined" == typeof a && (a = 1), t.semaphore += 1, t.usedAsync = !0, v(), 
                    function() {
                        return n ? void t.pushFailure("Too many calls to the `assert.async` callback", m(2)) : (a -= 1, 
                        void (a > 0 || (t.semaphore -= 1, n = !0, b())));
                    };
                },
                push: function(e, t, n, a, r) {
                    var i = this instanceof E ? this : A.config.current.assert;
                    return i.pushResult({
                        result: e,
                        actual: t,
                        expected: n,
                        message: a,
                        negative: r
                    });
                },
                pushResult: function(e) {
                    var t = this, n = t instanceof E && t.test || A.config.current;
                    if (!n) throw new Error("assertion outside test context, in " + m(2));
                    return n.usedAsync === !0 && 0 === n.semaphore && n.pushFailure("Assertion after the final `assert.async` was resolved", m(2)), 
                    t instanceof E || (t = n.assert), t.test.pushResult(e);
                },
                ok: function(e, t) {
                    t = t || (e ? "okay" : "failed, expected argument to be truthy, was: " + A.dump.parse(e)), 
                    this.pushResult({
                        result: !!e,
                        actual: e,
                        expected: !0,
                        message: t
                    });
                },
                notOk: function(e, t) {
                    t = t || (e ? "failed, expected argument to be falsy, was: " + A.dump.parse(e) : "okay"), 
                    this.pushResult({
                        result: !e,
                        actual: e,
                        expected: !1,
                        message: t
                    });
                },
                equal: function(e, t, n) {
                    this.pushResult({
                        result: t == e,
                        actual: e,
                        expected: t,
                        message: n
                    });
                },
                notEqual: function(e, t, n) {
                    this.pushResult({
                        result: t != e,
                        actual: e,
                        expected: t,
                        message: n,
                        negative: !0
                    });
                },
                propEqual: function(e, t, n) {
                    e = o(e), t = o(t), this.pushResult({
                        result: A.equiv(e, t),
                        actual: e,
                        expected: t,
                        message: n
                    });
                },
                notPropEqual: function(e, t, n) {
                    e = o(e), t = o(t), this.pushResult({
                        result: !A.equiv(e, t),
                        actual: e,
                        expected: t,
                        message: n,
                        negative: !0
                    });
                },
                deepEqual: function(e, t, n) {
                    this.pushResult({
                        result: A.equiv(e, t),
                        actual: e,
                        expected: t,
                        message: n
                    });
                },
                notDeepEqual: function(e, t, n) {
                    this.pushResult({
                        result: !A.equiv(e, t),
                        actual: e,
                        expected: t,
                        message: n,
                        negative: !0
                    });
                },
                strictEqual: function(e, t, n) {
                    this.pushResult({
                        result: t === e,
                        actual: e,
                        expected: t,
                        message: n
                    });
                },
                notStrictEqual: function(e, t, n) {
                    this.pushResult({
                        result: t !== e,
                        actual: e,
                        expected: t,
                        message: n,
                        negative: !0
                    });
                },
                throws: function(e, t, n) {
                    var a, r, i = t, s = !1, o = this instanceof E && this.test || A.config.current;
                    null == n && "string" == typeof t && (n = t, t = null), o.ignoreGlobalErrors = !0;
                    try {
                        e.call(o.testEnvironment);
                    } catch (e) {
                        a = e;
                    }
                    o.ignoreGlobalErrors = !1, a && (r = A.objectType(t), t ? "regexp" === r ? s = t.test(H(a)) : "string" === r ? s = t === H(a) : "function" === r && a instanceof t ? s = !0 : "object" === r ? s = a instanceof t.constructor && a.name === t.name && a.message === t.message : "function" === r && t.call({}, a) === !0 && (i = null, 
                    s = !0) : (s = !0, i = null)), o.assert.pushResult({
                        result: s,
                        actual: a,
                        expected: i,
                        message: n
                    });
                }
            }, function() {
                E.prototype.raises = E.prototype.throws;
            }(), A.equiv = function() {
                function e(e, t) {
                    return "object" == typeof t && (t = t.valueOf()), "object" == typeof e && (e = e.valueOf()), 
                    t === e;
                }
                function t(e, t) {
                    var n = l(e), a = l(t);
                    return e.constructor === t.constructor || (n && null === n.constructor && (n = null), 
                    a && null === a.constructor && (a = null), null === n && a === Object.prototype || null === a && n === Object.prototype);
                }
                function n(e) {
                    return "flags" in e ? e.flags : e.toString().match(/[gimuy]*$/)[0];
                }
                function a(e, t) {
                    var n = A.objectType(e);
                    return A.objectType(t) === n && u[n](t, e);
                }
                function r(e, t) {
                    return arguments.length < 2 || (e === t || a(e, t)) && (2 === arguments.length || r.apply(this, [].slice.call(arguments, 1)));
                }
                var i = [], s = [], o = [], l = Object.getPrototypeOf || function(e) {
                    return e.__proto__;
                }, u = {
                    string: e,
                    boolean: e,
                    number: e,
                    null: e,
                    undefined: e,
                    symbol: e,
                    date: e,
                    nan: function() {
                        return !0;
                    },
                    regexp: function(e, t) {
                        return t.source === e.source && n(t) === n(e);
                    },
                    function: function() {
                        var e = i[i.length - 1];
                        return e !== Object && "undefined" != typeof e;
                    },
                    array: function(e, t) {
                        var n, a, i, l, u, c;
                        if (i = t.length, i !== e.length) return !1;
                        for (s.push(t), o.push(e), n = 0; n < i; n++) {
                            for (l = !1, a = 0; a < s.length; a++) if (u = s[a] === t[n], c = o[a] === e[n], 
                            u || c) {
                                if (!(t[n] === e[n] || u && c)) return s.pop(), o.pop(), !1;
                                l = !0;
                            }
                            if (!l && !r(t[n], e[n])) return s.pop(), o.pop(), !1;
                        }
                        return s.pop(), o.pop(), !0;
                    },
                    set: function(e, t) {
                        var n, a = !0;
                        return t.size === e.size && (t.forEach(function(t) {
                            n = !1, e.forEach(function(e) {
                                r(e, t) && (n = !0);
                            }), n || (a = !1);
                        }), a);
                    },
                    map: function(e, t) {
                        var n, a = !0;
                        return t.size === e.size && (t.forEach(function(t, i) {
                            n = !1, e.forEach(function(e, a) {
                                r([ e, a ], [ t, i ]) && (n = !0);
                            }), n || (a = !1);
                        }), a);
                    },
                    object: function(e, n) {
                        var a, l, u, c, d, m = !0, f = [], p = [];
                        if (t(n, e) === !1) return !1;
                        i.push(n.constructor), s.push(n), o.push(e);
                        for (a in n) {
                            for (u = !1, l = 0; l < s.length; l++) if (c = s[l] === n[a], d = o[l] === e[a], 
                            c || d) {
                                if (!(n[a] === e[a] || c && d)) {
                                    m = !1;
                                    break;
                                }
                                u = !0;
                            }
                            if (f.push(a), !u && !r(n[a], e[a])) {
                                m = !1;
                                break;
                            }
                        }
                        s.pop(), o.pop(), i.pop();
                        for (a in e) p.push(a);
                        return m && r(f.sort(), p.sort());
                    }
                };
                return r;
            }(), A.dump = function() {
                function e(e) {
                    return '"' + e.toString().replace(/\\/g, "\\\\").replace(/"/g, '\\"') + '"';
                }
                function t(e) {
                    return e + "";
                }
                function n(e, t, n) {
                    var a = i.separator(), r = i.indent(), s = i.indent(1);
                    return t.join && (t = t.join("," + a + s)), t ? [ e, s + t, r + n ].join(a) : e + n;
                }
                function a(e, t) {
                    var a = e.length, r = new Array(a);
                    if (i.maxDepth && i.depth > i.maxDepth) return "[object Array]";
                    for (this.up(); a--; ) r[a] = this.parse(e[a], void 0, t);
                    return this.down(), n("[", r, "]");
                }
                var r = /^function (\w+)/, i = {
                    parse: function(e, t, n) {
                        n = n || [];
                        var a, r, i, o = s(e, n);
                        return o !== -1 ? "recursion(" + (o - n.length) + ")" : (t = t || this.typeOf(e), 
                        r = this.parsers[t], i = typeof r, "function" === i ? (n.push(e), a = r.call(this, e, n), 
                        n.pop(), a) : "string" === i ? r : this.parsers.error);
                    },
                    typeOf: function(e) {
                        var t;
                        return t = null === e ? "null" : "undefined" == typeof e ? "undefined" : A.is("regexp", e) ? "regexp" : A.is("date", e) ? "date" : A.is("function", e) ? "function" : void 0 !== e.setInterval && void 0 !== e.document && void 0 === e.nodeType ? "window" : 9 === e.nodeType ? "document" : e.nodeType ? "node" : "[object Array]" === q.call(e) || "number" == typeof e.length && void 0 !== e.item && (e.length ? e.item(0) === e[0] : null === e.item(0) && void 0 === e[0]) ? "array" : e.constructor === Error.prototype.constructor ? "error" : typeof e;
                    },
                    separator: function() {
                        return this.multiline ? this.HTML ? "<br />" : "\n" : this.HTML ? "&#160;" : " ";
                    },
                    indent: function(e) {
                        if (!this.multiline) return "";
                        var t = this.indentChar;
                        return this.HTML && (t = t.replace(/\t/g, "   ").replace(/ /g, "&#160;")), new Array(this.depth + (e || 0)).join(t);
                    },
                    up: function(e) {
                        this.depth += e || 1;
                    },
                    down: function(e) {
                        this.depth -= e || 1;
                    },
                    setParser: function(e, t) {
                        this.parsers[e] = t;
                    },
                    quote: e,
                    literal: t,
                    join: n,
                    depth: 1,
                    maxDepth: A.config.maxDepth,
                    parsers: {
                        window: "[Window]",
                        document: "[Document]",
                        error: function(e) {
                            return 'Error("' + e.message + '")';
                        },
                        unknown: "[Unknown]",
                        null: "null",
                        undefined: "undefined",
                        function: function(e) {
                            var t = "function", a = "name" in e ? e.name : (r.exec(e) || [])[1];
                            return a && (t += " " + a), t += "(", t = [ t, i.parse(e, "functionArgs"), "){" ].join(""), 
                            n(t, i.parse(e, "functionCode"), "}");
                        },
                        array: a,
                        nodelist: a,
                        arguments: a,
                        object: function(e, t) {
                            var a, r, o, l, u, c = [];
                            if (i.maxDepth && i.depth > i.maxDepth) return "[object Object]";
                            i.up(), a = [];
                            for (r in e) a.push(r);
                            u = [ "message", "name" ];
                            for (l in u) r = u[l], r in e && s(r, a) < 0 && a.push(r);
                            for (a.sort(), l = 0; l < a.length; l++) r = a[l], o = e[r], c.push(i.parse(r, "key") + ": " + i.parse(o, void 0, t));
                            return i.down(), n("{", c, "}");
                        },
                        node: function(e) {
                            var t, n, a, r = i.HTML ? "&lt;" : "<", s = i.HTML ? "&gt;" : ">", o = e.nodeName.toLowerCase(), l = r + o, u = e.attributes;
                            if (u) for (n = 0, t = u.length; n < t; n++) a = u[n].nodeValue, a && "inherit" !== a && (l += " " + u[n].nodeName + "=" + i.parse(a, "attribute"));
                            return l += s, 3 !== e.nodeType && 4 !== e.nodeType || (l += e.nodeValue), l + r + "/" + o + s;
                        },
                        functionArgs: function(e) {
                            var t, n = e.length;
                            if (!n) return "";
                            for (t = new Array(n); n--; ) t[n] = String.fromCharCode(97 + n);
                            return " " + t.join(", ") + " ";
                        },
                        key: e,
                        functionCode: "[code]",
                        attribute: e,
                        string: e,
                        date: e,
                        regexp: t,
                        number: t,
                        boolean: t
                    },
                    HTML: !1,
                    indentChar: "  ",
                    multiline: !0
                };
                return i;
            }(), A.jsDump = A.dump, function() {
                function e(e) {
                    return function() {
                        var t = new E(A.config.current);
                        e.apply(t, arguments);
                    };
                }
                var t, n = E.prototype;
                for (t in n) A[t] = e(n[t]);
            }(), U.document && (!function() {
                var e, t, n = [ "test", "module", "expect", "asyncTest", "start", "stop", "ok", "notOk", "equal", "notEqual", "propEqual", "notPropEqual", "deepEqual", "notDeepEqual", "strictEqual", "notStrictEqual", "throws", "raises" ];
                for (e = 0, t = n.length; e < t; e++) F[n[e]] = A[n[e]];
            }(), F.QUnit = A), "undefined" != typeof r && r && r.exports && (r.exports = A, 
            r.exports.QUnit = A), "undefined" != typeof t && t && (t.QUnit = A), a = function() {
                return A;
            }.call(t, n, t, r), !(void 0 !== a && (r.exports = a)), A.config.autostart = !1;
        }(function() {
            return this;
        }()), function() {
            function e() {
                var e, t, n, a, r = {}, i = S.search.slice(1).split("&"), s = i.length;
                for (e = 0; e < s; e++) i[e] && (t = i[e].split("="), n = decodeURIComponent(t[0]), 
                a = 1 === t.length || decodeURIComponent(t.slice(1).join("=")), r[n] ? r[n] = [].concat(r[n], a) : r[n] = a);
                return r;
            }
            function t(e) {
                return e ? (e += "", e.replace(/['"<>&]/g, function(e) {
                    switch (e) {
                      case "'":
                        return "&#039;";

                      case '"':
                        return "&quot;";

                      case "<":
                        return "&lt;";

                      case ">":
                        return "&gt;";

                      case "&":
                        return "&amp;";
                    }
                })) : "";
            }
            function n(e, t, n) {
                e.addEventListener ? e.addEventListener(t, n, !1) : e.attachEvent && e.attachEvent("on" + t, function() {
                    var t = window.event;
                    t.target || (t.target = t.srcElement || E), n.call(e, t);
                });
            }
            function a(e, t, a) {
                for (var r = e.length; r--; ) n(e[r], t, a);
            }
            function r(e, t) {
                return (" " + e.className + " ").indexOf(" " + t + " ") >= 0;
            }
            function i(e, t) {
                r(e, t) || (e.className += (e.className ? " " : "") + t);
            }
            function s(e, t, n) {
                n || "undefined" == typeof n && !r(e, t) ? i(e, t) : o(e, t);
            }
            function o(e, t) {
                for (var n = " " + e.className + " "; n.indexOf(" " + t + " ") >= 0; ) n = n.replace(" " + t + " ", " ");
                e.className = "function" == typeof n.trim ? n.trim() : n.replace(/^\s+|\s+$/g, "");
            }
            function l(e) {
                return E.getElementById && E.getElementById(e);
            }
            function u() {
                var e, n, a, r, i, s = !1, o = C.urlConfig, l = "";
                for (e = 0; e < o.length; e++) if (a = C.urlConfig[e], "string" == typeof a && (a = {
                    id: a,
                    label: a
                }), r = t(a.id), i = t(a.tooltip), a.value && "string" != typeof a.value) {
                    if (l += "<label for='qunit-urlconfig-" + r + "' title='" + i + "'>" + a.label + ": </label><select id='qunit-urlconfig-" + r + "' name='" + r + "' title='" + i + "'><option></option>", 
                    QUnit.is("array", a.value)) for (n = 0; n < a.value.length; n++) r = t(a.value[n]), 
                    l += "<option value='" + r + "'" + (C[a.id] === a.value[n] ? (s = !0) && " selected='selected'" : "") + ">" + r + "</option>"; else for (n in a.value) A.call(a.value, n) && (l += "<option value='" + t(n) + "'" + (C[a.id] === n ? (s = !0) && " selected='selected'" : "") + ">" + t(a.value[n]) + "</option>");
                    C[a.id] && !s && (r = t(C[a.id]), l += "<option value='" + r + "' selected='selected' disabled='disabled'>" + r + "</option>"), 
                    l += "</select>";
                } else l += "<input id='qunit-urlconfig-" + r + "' name='" + r + "' type='checkbox'" + (a.value ? " value='" + t(a.value) + "'" : "") + (C[a.id] ? " checked='checked'" : "") + " title='" + i + "' /><label for='qunit-urlconfig-" + r + "' title='" + i + "'>" + a.label + "</label>";
                return l;
            }
            function c() {
                var e, t, n, a = this, r = {};
                t = "selectedIndex" in a ? a.options[a.selectedIndex].value || void 0 : a.checked ? a.defaultValue || !0 : void 0, 
                r[a.name] = t, e = d(r), "hidepassed" === a.name && "replaceState" in window.history ? (QUnit.urlParams[a.name] = t, 
                C[a.name] = t || !1, n = l("qunit-tests"), n && s(n, "hidepass", t || !1), window.history.replaceState(null, "", e)) : window.location = e;
            }
            function d(e) {
                var t, n, a, r = "?", i = window.location;
                e = QUnit.extend(QUnit.extend({}, QUnit.urlParams), e);
                for (t in e) if (A.call(e, t) && void 0 !== e[t]) for (n = [].concat(e[t]), a = 0; a < n.length; a++) r += encodeURIComponent(t), 
                n[a] !== !0 && (r += "=" + encodeURIComponent(n[a])), r += "&";
                return i.protocol + "//" + i.host + i.pathname + r.slice(0, -1);
            }
            function m() {
                var e, t = l("qunit-modulefilter"), n = l("qunit-filter-input").value;
                e = t ? decodeURIComponent(t.options[t.selectedIndex].value) : void 0, window.location = d({
                    module: "" === e ? void 0 : e,
                    filter: "" === n ? void 0 : n,
                    moduleId: void 0,
                    testId: void 0
                });
            }
            function f() {
                var e = E.createElement("span");
                return e.innerHTML = u(), i(e, "qunit-url-config"), a(e.getElementsByTagName("input"), "click", c), 
                a(e.getElementsByTagName("select"), "change", c), e;
            }
            function p() {
                var e = E.createElement("form"), t = E.createElement("label"), a = E.createElement("input"), r = E.createElement("button");
                return i(e, "qunit-filter"), t.innerHTML = "Filter: ", a.type = "text", a.value = C.filter || "", 
                a.name = "filter", a.id = "qunit-filter-input", r.innerHTML = "Go", t.appendChild(a), 
                e.appendChild(t), e.appendChild(r), n(e, "submit", function(e) {
                    return m(), e && e.preventDefault && e.preventDefault(), !1;
                }), e;
            }
            function h() {
                var e, n = "";
                if (!I.length) return !1;
                for (n += "<label for='qunit-modulefilter'>Module: </label><select id='qunit-modulefilter' name='modulefilter'><option value='' " + (void 0 === QUnit.urlParams.module ? "selected='selected'" : "") + ">< All Modules ></option>", 
                e = 0; e < I.length; e++) n += "<option value='" + t(encodeURIComponent(I[e])) + "' " + (QUnit.urlParams.module === I[e] ? "selected='selected'" : "") + ">" + t(I[e]) + "</option>";
                return n += "</select>";
            }
            function g() {
                var e = l("qunit-testrunner-toolbar"), t = E.createElement("span"), a = h();
                return !(!e || !a) && (t.setAttribute("id", "qunit-modulefilter-container"), t.innerHTML = a, 
                n(t.lastChild, "change", m), void e.appendChild(t));
            }
            function _() {
                var e = l("qunit-testrunner-toolbar");
                e && (e.appendChild(f()), e.appendChild(p()), g());
            }
            function v() {
                var e = l("qunit-header");
                e && (e.innerHTML = "<a href='" + t(j) + "'>" + e.innerHTML + "</a> ");
            }
            function b() {
                var e = l("qunit-banner");
                e && (e.className = "");
            }
            function y() {
                var e = l("qunit-tests"), t = l("qunit-testresult");
                t && t.parentNode.removeChild(t), e && (e.innerHTML = "", t = E.createElement("p"), 
                t.id = "qunit-testresult", t.className = "result", e.parentNode.insertBefore(t, e), 
                t.innerHTML = "Running...<br />&#160;");
            }
            function M() {
                var e = l("qunit-fixture");
                e && (C.fixture = e.innerHTML);
            }
            function $() {
                var e = QUnit.config.testId;
                return !e || e.length <= 0 ? "" : "<div id='qunit-filteredTest'>Rerunning selected tests: " + t(e.join(", ")) + " <a id='qunit-clearFilter' href='" + t(j) + "'>Run all tests</a></div>";
            }
            function k() {
                var e = l("qunit-userAgent");
                e && (e.innerHTML = "", e.appendChild(E.createTextNode("QUnit " + QUnit.version + "; " + navigator.userAgent)));
            }
            function w() {
                var e = l("qunit");
                e && (e.innerHTML = "<h1 id='qunit-header'>" + t(E.title) + "</h1><h2 id='qunit-banner'></h2><div id='qunit-testrunner-toolbar'></div>" + $() + "<h2 id='qunit-userAgent'></h2><ol id='qunit-tests'></ol>"), 
                v(), b(), y(), k(), _();
            }
            function L(e) {
                var t, n, a, r, i, s;
                for (t = 0, n = e.length; t < n; t++) for (s = e[t], a = 0, r = s.tests.length; a < r; a++) i = s.tests[a], 
                D(i.name, i.testId, s.name);
            }
            function D(e, t, n) {
                var a, r, i, s, o = l("qunit-tests");
                o && (a = E.createElement("strong"), a.innerHTML = Y(e, n), r = E.createElement("a"), 
                r.innerHTML = "Rerun", r.href = d({
                    testId: t
                }), i = E.createElement("li"), i.appendChild(a), i.appendChild(r), i.id = "qunit-test-output-" + t, 
                s = E.createElement("ol"), s.className = "qunit-assert-list", i.appendChild(s), 
                o.appendChild(i));
            }
            function Y(e, n) {
                var a = "";
                return n && (a = "<span class='module-name'>" + t(n) + "</span>: "), a += "<span class='test-name'>" + t(e) + "</span>";
            }
            function T(e) {
                return e.replace(/<\/?[^>]+(>|$)/g, "").replace(/\&quot;/g, "").replace(/\s+/g, "");
            }
            var S = "undefined" != typeof window && window.location;
            if (S) {
                var x = e();
                if (QUnit.urlParams = x, QUnit.config.moduleId = [].concat(x.moduleId || []), QUnit.config.testId = [].concat(x.testId || []), 
                QUnit.config.module = x.module, QUnit.config.filter = x.filter, x.seed === !0 ? QUnit.config.seed = Math.random().toString(36).slice(2) : x.seed && (QUnit.config.seed = x.seed), 
                QUnit.config.urlConfig.push({
                    id: "hidepassed",
                    label: "Hide passed tests",
                    tooltip: "Only show tests and assertions that fail. Stored as query-strings."
                }, {
                    id: "noglobals",
                    label: "Check for Globals",
                    tooltip: "Enabling this will test if any test introduces new properties on the global object (`window` in Browsers). Stored as query-strings."
                }, {
                    id: "notrycatch",
                    label: "No try-catch",
                    tooltip: "Enabling this will run tests outside of a try-catch block. Makes debugging exceptions in IE reasonable. Stored as query-strings."
                }), QUnit.begin(function() {
                    var e, t, n = QUnit.config.urlConfig;
                    for (e = 0; e < n.length; e++) t = QUnit.config.urlConfig[e], "string" != typeof t && (t = t.id), 
                    void 0 === QUnit.config[t] && (QUnit.config[t] = x[t]);
                }), "undefined" != typeof window && window.document) {
                    QUnit.init = function() {
                        var e = QUnit.config;
                        e.stats = {
                            all: 0,
                            bad: 0
                        }, e.moduleStats = {
                            all: 0,
                            bad: 0
                        }, e.started = 0, e.updateRate = 1e3, e.blocking = !1, e.autostart = !0, e.autorun = !1, 
                        e.filter = "", e.queue = [], w();
                    };
                    var C = QUnit.config, E = window.document, H = !1, A = Object.prototype.hasOwnProperty, j = d({
                        filter: void 0,
                        module: void 0,
                        moduleId: void 0,
                        testId: void 0
                    }), O = {
                        sessionStorage: function() {
                            var e = "qunit-test-string";
                            try {
                                return sessionStorage.setItem(e, e), sessionStorage.removeItem(e), !0;
                            } catch (e) {
                                return !1;
                            }
                        }()
                    }, I = [];
                    QUnit.begin(function(e) {
                        var t, n, a;
                        for (t = 0; t < e.modules.length; t++) n = e.modules[t], n.name && I.push(n.name);
                        I.sort(function(e, t) {
                            return e.localeCompare(t);
                        }), M(), w(), L(e.modules), a = l("qunit-tests"), a && C.hidepassed && i(a, "hidepass");
                    }), QUnit.done(function(e) {
                        var t, n, a = l("qunit-banner"), r = l("qunit-tests"), i = [ "Tests completed in ", e.runtime, " milliseconds.<br />", "<span class='passed'>", e.passed, "</span> assertions of <span class='total'>", e.total, "</span> passed, <span class='failed'>", e.failed, "</span> failed." ].join("");
                        if (a && (a.className = e.failed ? "qunit-fail" : "qunit-pass"), r && (l("qunit-testresult").innerHTML = i), 
                        C.altertitle && E.title && (E.title = [ e.failed ? "✖" : "✔", E.title.replace(/^[\u2714\u2716] /i, "") ].join(" ")), 
                        C.reorder && O.sessionStorage && 0 === e.failed) for (t = 0; t < sessionStorage.length; t++) n = sessionStorage.key(t++), 
                        0 === n.indexOf("qunit-test-") && sessionStorage.removeItem(n);
                        C.scrolltop && window.scrollTo && window.scrollTo(0, 0);
                    }), QUnit.testStart(function(e) {
                        var t, n, a;
                        n = l("qunit-test-output-" + e.testId), n ? n.className = "running" : D(e.name, e.testId, e.module), 
                        t = l("qunit-testresult"), t && (a = QUnit.config.reorder && O.sessionStorage && +sessionStorage.getItem("qunit-test-" + e.module + "-" + e.name), 
                        t.innerHTML = (a ? "Rerunning previously failed test: <br />" : "Running: <br />") + Y(e.name, e.module));
                    }), QUnit.log(function(e) {
                        var n, a, r, i, s, o, u = !1, c = l("qunit-test-output-" + e.testId);
                        c && (r = t(e.message) || (e.result ? "okay" : "failed"), r = "<span class='test-message'>" + r + "</span>", 
                        r += "<span class='runtime'>@ " + e.runtime + " ms</span>", !e.result && A.call(e, "expected") ? (i = e.negative ? "NOT " + QUnit.dump.parse(e.expected) : QUnit.dump.parse(e.expected), 
                        s = QUnit.dump.parse(e.actual), r += "<table><tr class='test-expected'><th>Expected: </th><td><pre>" + t(i) + "</pre></td></tr>", 
                        s !== i ? (r += "<tr class='test-actual'><th>Result: </th><td><pre>" + t(s) + "</pre></td></tr>", 
                        /^(true|false)$/.test(s) || /^(true|false)$/.test(i) || (o = QUnit.diff(i, s), u = T(o).length !== T(i).length + T(s).length), 
                        u && (r += "<tr class='test-diff'><th>Diff: </th><td><pre>" + o + "</pre></td></tr>")) : r += i.indexOf("[object Array]") !== -1 || i.indexOf("[object Object]") !== -1 ? "<tr class='test-message'><th>Message: </th><td>Diff suppressed as the depth of object is more than current max depth (" + QUnit.config.maxDepth + ").<p>Hint: Use <code>QUnit.dump.maxDepth</code> to  run with a higher max depth or <a href='" + t(d({
                            maxDepth: -1
                        })) + "'>Rerun</a> without max depth.</p></td></tr>" : "<tr class='test-message'><th>Message: </th><td>Diff suppressed as the expected and actual results have an equivalent serialization</td></tr>", 
                        e.source && (r += "<tr class='test-source'><th>Source: </th><td><pre>" + t(e.source) + "</pre></td></tr>"), 
                        r += "</table>") : !e.result && e.source && (r += "<table><tr class='test-source'><th>Source: </th><td><pre>" + t(e.source) + "</pre></td></tr></table>"), 
                        n = c.getElementsByTagName("ol")[0], a = E.createElement("li"), a.className = e.result ? "pass" : "fail", 
                        a.innerHTML = r, n.appendChild(a));
                    }), QUnit.testDone(function(e) {
                        var t, a, r, o, u, c, d, m, f, p = l("qunit-tests");
                        p && (r = l("qunit-test-output-" + e.testId), o = r.getElementsByTagName("ol")[0], 
                        u = e.passed, c = e.failed, C.reorder && O.sessionStorage && (c ? sessionStorage.setItem("qunit-test-" + e.module + "-" + e.name, c) : sessionStorage.removeItem("qunit-test-" + e.module + "-" + e.name)), 
                        0 === c ? i(o, "qunit-collapsed") : c && C.collapse && !H ? H = !0 : i(o, "qunit-collapsed"), 
                        t = r.firstChild, d = c ? "<b class='failed'>" + c + "</b>, <b class='passed'>" + u + "</b>, " : "", 
                        t.innerHTML += " <b class='counts'>(" + d + e.assertions.length + ")</b>", e.skipped ? (r.className = "skipped", 
                        m = E.createElement("em"), m.className = "qunit-skipped-label", m.innerHTML = "skipped", 
                        r.insertBefore(m, t)) : (n(t, "click", function() {
                            s(o, "qunit-collapsed");
                        }), r.className = c ? "fail" : "pass", a = E.createElement("span"), a.className = "runtime", 
                        a.innerHTML = e.runtime + " ms", r.insertBefore(a, o)), e.source && (f = E.createElement("p"), 
                        f.innerHTML = "<strong>Source: </strong>" + e.source, i(f, "qunit-source"), 0 === c && i(f, "qunit-collapsed"), 
                        n(t, "click", function() {
                            s(f, "qunit-collapsed");
                        }), r.appendChild(f)));
                    });
                    var P = function(e) {
                        return !(e && e.version && e.version.major > 0);
                    }(window.phantom);
                    P && "complete" === E.readyState ? QUnit.load() : n(window, "load", QUnit.load), 
                    QUnit.diff = function() {
                        function e() {}
                        var n = -1, a = 1, r = 0;
                        return e.prototype.DiffMain = function(e, t, n) {
                            var a, i, s, o, l, u;
                            if (a = new Date().getTime() + 1e3, null === e || null === t) throw new Error("Null input. (DiffMain)");
                            return e === t ? e ? [ [ r, e ] ] : [] : ("undefined" == typeof n && (n = !0), i = n, 
                            s = this.diffCommonPrefix(e, t), o = e.substring(0, s), e = e.substring(s), t = t.substring(s), 
                            s = this.diffCommonSuffix(e, t), l = e.substring(e.length - s), e = e.substring(0, e.length - s), 
                            t = t.substring(0, t.length - s), u = this.diffCompute(e, t, i, a), o && u.unshift([ r, o ]), 
                            l && u.push([ r, l ]), this.diffCleanupMerge(u), u);
                        }, e.prototype.diffCleanupEfficiency = function(e) {
                            var t, i, s, o, l, u, c, d, m;
                            for (t = !1, i = [], s = 0, o = null, l = 0, u = !1, c = !1, d = !1, m = !1; l < e.length; ) e[l][0] === r ? (e[l][1].length < 4 && (d || m) ? (i[s++] = l, 
                            u = d, c = m, o = e[l][1]) : (s = 0, o = null), d = m = !1) : (e[l][0] === n ? m = !0 : d = !0, 
                            o && (u && c && d && m || o.length < 2 && u + c + d + m === 3) && (e.splice(i[s - 1], 0, [ n, o ]), 
                            e[i[s - 1] + 1][0] = a, s--, o = null, u && c ? (d = m = !0, s = 0) : (s--, l = s > 0 ? i[s - 1] : -1, 
                            d = m = !1), t = !0)), l++;
                            t && this.diffCleanupMerge(e);
                        }, e.prototype.diffPrettyHtml = function(e) {
                            var i, s, o, l = [];
                            for (o = 0; o < e.length; o++) switch (i = e[o][0], s = e[o][1], i) {
                              case a:
                                l[o] = "<ins>" + t(s) + "</ins>";
                                break;

                              case n:
                                l[o] = "<del>" + t(s) + "</del>";
                                break;

                              case r:
                                l[o] = "<span>" + t(s) + "</span>";
                            }
                            return l.join("");
                        }, e.prototype.diffCommonPrefix = function(e, t) {
                            var n, a, r, i;
                            if (!e || !t || e.charAt(0) !== t.charAt(0)) return 0;
                            for (r = 0, a = Math.min(e.length, t.length), n = a, i = 0; r < n; ) e.substring(i, n) === t.substring(i, n) ? (r = n, 
                            i = r) : a = n, n = Math.floor((a - r) / 2 + r);
                            return n;
                        }, e.prototype.diffCommonSuffix = function(e, t) {
                            var n, a, r, i;
                            if (!e || !t || e.charAt(e.length - 1) !== t.charAt(t.length - 1)) return 0;
                            for (r = 0, a = Math.min(e.length, t.length), n = a, i = 0; r < n; ) e.substring(e.length - n, e.length - i) === t.substring(t.length - n, t.length - i) ? (r = n, 
                            i = r) : a = n, n = Math.floor((a - r) / 2 + r);
                            return n;
                        }, e.prototype.diffCompute = function(e, t, i, s) {
                            var o, l, u, c, d, m, f, p, h, g, _, v;
                            return e ? t ? (l = e.length > t.length ? e : t, u = e.length > t.length ? t : e, 
                            c = l.indexOf(u), c !== -1 ? (o = [ [ a, l.substring(0, c) ], [ r, u ], [ a, l.substring(c + u.length) ] ], 
                            e.length > t.length && (o[0][0] = o[2][0] = n), o) : 1 === u.length ? [ [ n, e ], [ a, t ] ] : (d = this.diffHalfMatch(e, t), 
                            d ? (m = d[0], p = d[1], f = d[2], h = d[3], g = d[4], _ = this.DiffMain(m, f, i, s), 
                            v = this.DiffMain(p, h, i, s), _.concat([ [ r, g ] ], v)) : i && e.length > 100 && t.length > 100 ? this.diffLineMode(e, t, s) : this.diffBisect(e, t, s))) : [ [ n, e ] ] : [ [ a, t ] ];
                        }, e.prototype.diffHalfMatch = function(e, t) {
                            function n(e, t, n) {
                                var a, r, s, o, l, u, c, d, m;
                                for (a = e.substring(n, n + Math.floor(e.length / 4)), r = -1, s = ""; (r = t.indexOf(a, r + 1)) !== -1; ) o = i.diffCommonPrefix(e.substring(n), t.substring(r)), 
                                l = i.diffCommonSuffix(e.substring(0, n), t.substring(0, r)), s.length < l + o && (s = t.substring(r - l, r) + t.substring(r, r + o), 
                                u = e.substring(0, n - l), c = e.substring(n + o), d = t.substring(0, r - l), m = t.substring(r + o));
                                return 2 * s.length >= e.length ? [ u, c, d, m, s ] : null;
                            }
                            var a, r, i, s, o, l, u, c, d, m, f;
                            return a = e.length > t.length ? e : t, r = e.length > t.length ? t : e, a.length < 4 || 2 * r.length < a.length ? null : (i = this, 
                            d = n(a, r, Math.ceil(a.length / 4)), m = n(a, r, Math.ceil(a.length / 2)), d || m ? (f = m ? d && d[4].length > m[4].length ? d : m : d, 
                            e.length > t.length ? (s = f[0], u = f[1], l = f[2], o = f[3]) : (l = f[0], o = f[1], 
                            s = f[2], u = f[3]), c = f[4], [ s, u, l, o, c ]) : null);
                        }, e.prototype.diffLineMode = function(e, t, i) {
                            var s, o, l, u, c, d, m, f, p;
                            for (s = this.diffLinesToChars(e, t), e = s.chars1, t = s.chars2, l = s.lineArray, 
                            o = this.DiffMain(e, t, !1, i), this.diffCharsToLines(o, l), this.diffCleanupSemantic(o), 
                            o.push([ r, "" ]), u = 0, d = 0, c = 0, f = "", m = ""; u < o.length; ) {
                                switch (o[u][0]) {
                                  case a:
                                    c++, m += o[u][1];
                                    break;

                                  case n:
                                    d++, f += o[u][1];
                                    break;

                                  case r:
                                    if (d >= 1 && c >= 1) {
                                        for (o.splice(u - d - c, d + c), u = u - d - c, s = this.DiffMain(f, m, !1, i), 
                                        p = s.length - 1; p >= 0; p--) o.splice(u, 0, s[p]);
                                        u += s.length;
                                    }
                                    c = 0, d = 0, f = "", m = "";
                                }
                                u++;
                            }
                            return o.pop(), o;
                        }, e.prototype.diffBisect = function(e, t, r) {
                            var i, s, o, l, u, c, d, m, f, p, h, g, _, v, b, y, M, $, k, w, L, D, Y;
                            for (i = e.length, s = t.length, o = Math.ceil((i + s) / 2), l = o, u = 2 * o, c = new Array(u), 
                            d = new Array(u), m = 0; m < u; m++) c[m] = -1, d[m] = -1;
                            for (c[l + 1] = 0, d[l + 1] = 0, f = i - s, p = f % 2 !== 0, h = 0, g = 0, _ = 0, 
                            v = 0, L = 0; L < o && !(new Date().getTime() > r); L++) {
                                for (D = -L + h; D <= L - g; D += 2) {
                                    for (y = l + D, M = D === -L || D !== L && c[y - 1] < c[y + 1] ? c[y + 1] : c[y - 1] + 1, 
                                    k = M - D; M < i && k < s && e.charAt(M) === t.charAt(k); ) M++, k++;
                                    if (c[y] = M, M > i) g += 2; else if (k > s) h += 2; else if (p && (b = l + f - D, 
                                    b >= 0 && b < u && d[b] !== -1 && ($ = i - d[b], M >= $))) return this.diffBisectSplit(e, t, M, k, r);
                                }
                                for (Y = -L + _; Y <= L - v; Y += 2) {
                                    for (b = l + Y, $ = Y === -L || Y !== L && d[b - 1] < d[b + 1] ? d[b + 1] : d[b - 1] + 1, 
                                    w = $ - Y; $ < i && w < s && e.charAt(i - $ - 1) === t.charAt(s - w - 1); ) $++, 
                                    w++;
                                    if (d[b] = $, $ > i) v += 2; else if (w > s) _ += 2; else if (!p && (y = l + f - Y, 
                                    y >= 0 && y < u && c[y] !== -1 && (M = c[y], k = l + M - y, $ = i - $, M >= $))) return this.diffBisectSplit(e, t, M, k, r);
                                }
                            }
                            return [ [ n, e ], [ a, t ] ];
                        }, e.prototype.diffBisectSplit = function(e, t, n, a, r) {
                            var i, s, o, l, u, c;
                            return i = e.substring(0, n), o = t.substring(0, a), s = e.substring(n), l = t.substring(a), 
                            u = this.DiffMain(i, o, !1, r), c = this.DiffMain(s, l, !1, r), u.concat(c);
                        }, e.prototype.diffCleanupSemantic = function(e) {
                            var t, i, s, o, l, u, c, d, m, f, p, h, g;
                            for (t = !1, i = [], s = 0, o = null, l = 0, d = 0, m = 0, u = 0, c = 0; l < e.length; ) e[l][0] === r ? (i[s++] = l, 
                            d = u, m = c, u = 0, c = 0, o = e[l][1]) : (e[l][0] === a ? u += e[l][1].length : c += e[l][1].length, 
                            o && o.length <= Math.max(d, m) && o.length <= Math.max(u, c) && (e.splice(i[s - 1], 0, [ n, o ]), 
                            e[i[s - 1] + 1][0] = a, s--, s--, l = s > 0 ? i[s - 1] : -1, d = 0, m = 0, u = 0, 
                            c = 0, o = null, t = !0)), l++;
                            for (t && this.diffCleanupMerge(e), l = 1; l < e.length; ) e[l - 1][0] === n && e[l][0] === a && (f = e[l - 1][1], 
                            p = e[l][1], h = this.diffCommonOverlap(f, p), g = this.diffCommonOverlap(p, f), 
                            h >= g ? (h >= f.length / 2 || h >= p.length / 2) && (e.splice(l, 0, [ r, p.substring(0, h) ]), 
                            e[l - 1][1] = f.substring(0, f.length - h), e[l + 1][1] = p.substring(h), l++) : (g >= f.length / 2 || g >= p.length / 2) && (e.splice(l, 0, [ r, f.substring(0, g) ]), 
                            e[l - 1][0] = a, e[l - 1][1] = p.substring(0, p.length - g), e[l + 1][0] = n, e[l + 1][1] = f.substring(g), 
                            l++), l++), l++;
                        }, e.prototype.diffCommonOverlap = function(e, t) {
                            var n, a, r, i, s, o, l;
                            if (n = e.length, a = t.length, 0 === n || 0 === a) return 0;
                            if (n > a ? e = e.substring(n - a) : n < a && (t = t.substring(0, n)), r = Math.min(n, a), 
                            e === t) return r;
                            for (i = 0, s = 1; ;) {
                                if (o = e.substring(r - s), l = t.indexOf(o), l === -1) return i;
                                s += l, 0 !== l && e.substring(r - s) !== t.substring(0, s) || (i = s, s++);
                            }
                        }, e.prototype.diffLinesToChars = function(e, t) {
                            function n(e) {
                                var t, n, i, s, o;
                                for (t = "", n = 0, i = -1, s = a.length; i < e.length - 1; ) i = e.indexOf("\n", n), 
                                i === -1 && (i = e.length - 1), o = e.substring(n, i + 1), n = i + 1, (r.hasOwnProperty ? r.hasOwnProperty(o) : void 0 !== r[o]) ? t += String.fromCharCode(r[o]) : (t += String.fromCharCode(s), 
                                r[o] = s, a[s++] = o);
                                return t;
                            }
                            var a, r, i, s;
                            return a = [], r = {}, a[0] = "", i = n(e), s = n(t), {
                                chars1: i,
                                chars2: s,
                                lineArray: a
                            };
                        }, e.prototype.diffCharsToLines = function(e, t) {
                            var n, a, r, i;
                            for (n = 0; n < e.length; n++) {
                                for (a = e[n][1], r = [], i = 0; i < a.length; i++) r[i] = t[a.charCodeAt(i)];
                                e[n][1] = r.join("");
                            }
                        }, e.prototype.diffCleanupMerge = function(e) {
                            var t, i, s, o, l, u, c, d, m;
                            for (e.push([ r, "" ]), t = 0, i = 0, s = 0, l = "", o = ""; t < e.length; ) switch (e[t][0]) {
                              case a:
                                s++, o += e[t][1], t++;
                                break;

                              case n:
                                i++, l += e[t][1], t++;
                                break;

                              case r:
                                i + s > 1 ? (0 !== i && 0 !== s && (u = this.diffCommonPrefix(o, l), 0 !== u && (t - i - s > 0 && e[t - i - s - 1][0] === r ? e[t - i - s - 1][1] += o.substring(0, u) : (e.splice(0, 0, [ r, o.substring(0, u) ]), 
                                t++), o = o.substring(u), l = l.substring(u)), u = this.diffCommonSuffix(o, l), 
                                0 !== u && (e[t][1] = o.substring(o.length - u) + e[t][1], o = o.substring(0, o.length - u), 
                                l = l.substring(0, l.length - u))), 0 === i ? e.splice(t - s, i + s, [ a, o ]) : 0 === s ? e.splice(t - i, i + s, [ n, l ]) : e.splice(t - i - s, i + s, [ n, l ], [ a, o ]), 
                                t = t - i - s + (i ? 1 : 0) + (s ? 1 : 0) + 1) : 0 !== t && e[t - 1][0] === r ? (e[t - 1][1] += e[t][1], 
                                e.splice(t, 1)) : t++, s = 0, i = 0, l = "", o = "";
                            }
                            for ("" === e[e.length - 1][1] && e.pop(), c = !1, t = 1; t < e.length - 1; ) e[t - 1][0] === r && e[t + 1][0] === r && (d = e[t][1], 
                            m = d.substring(d.length - e[t - 1][1].length), m === e[t - 1][1] ? (e[t][1] = e[t - 1][1] + e[t][1].substring(0, e[t][1].length - e[t - 1][1].length), 
                            e[t + 1][1] = e[t - 1][1] + e[t + 1][1], e.splice(t - 1, 1), c = !0) : d.substring(0, e[t + 1][1].length) === e[t + 1][1] && (e[t - 1][1] += e[t + 1][1], 
                            e[t][1] = e[t][1].substring(e[t + 1][1].length) + e[t + 1][1], e.splice(t + 1, 1), 
                            c = !0)), t++;
                            c && this.diffCleanupMerge(e);
                        }, function(t, n) {
                            var a, r, i;
                            return a = new e(), r = a.DiffMain(t, n), a.diffCleanupEfficiency(r), i = a.diffPrettyHtml(r);
                        };
                    }();
                }
            }
        }();
    }).call(t, n(247), n(63)(e));
}, function(e, t) {
    function n() {
        throw new Error("setTimeout has not been defined");
    }
    function a() {
        throw new Error("clearTimeout has not been defined");
    }
    function r(e) {
        if (c === setTimeout) return setTimeout(e, 0);
        if ((c === n || !c) && setTimeout) return c = setTimeout, setTimeout(e, 0);
        try {
            return c(e, 0);
        } catch (t) {
            try {
                return c.call(null, e, 0);
            } catch (t) {
                return c.call(this, e, 0);
            }
        }
    }
    function i(e) {
        if (d === clearTimeout) return clearTimeout(e);
        if ((d === a || !d) && clearTimeout) return d = clearTimeout, clearTimeout(e);
        try {
            return d(e);
        } catch (t) {
            try {
                return d.call(null, e);
            } catch (t) {
                return d.call(this, e);
            }
        }
    }
    function s() {
        h && f && (h = !1, f.length ? p = f.concat(p) : g = -1, p.length && o());
    }
    function o() {
        if (!h) {
            var e = r(s);
            h = !0;
            for (var t = p.length; t; ) {
                for (f = p, p = []; ++g < t; ) f && f[g].run();
                g = -1, t = p.length;
            }
            f = null, h = !1, i(e);
        }
    }
    function l(e, t) {
        this.fun = e, this.array = t;
    }
    function u() {}
    var c, d, m = e.exports = {};
    !function() {
        try {
            c = "function" == typeof setTimeout ? setTimeout : n;
        } catch (e) {
            c = n;
        }
        try {
            d = "function" == typeof clearTimeout ? clearTimeout : a;
        } catch (e) {
            d = a;
        }
    }();
    var f, p = [], h = !1, g = -1;
    m.nextTick = function(e) {
        var t = new Array(arguments.length - 1);
        if (arguments.length > 1) for (var n = 1; n < arguments.length; n++) t[n - 1] = arguments[n];
        p.push(new l(e, t)), 1 !== p.length || h || r(o);
    }, l.prototype.run = function() {
        this.fun.apply(null, this.array);
    }, m.title = "browser", m.browser = !0, m.env = {}, m.argv = [], m.version = "", 
    m.versions = {}, m.on = u, m.addListener = u, m.once = u, m.off = u, m.removeListener = u, 
    m.removeAllListeners = u, m.emit = u, m.prependListener = u, m.prependOnceListener = u, 
    m.listeners = function(e) {
        return [];
    }, m.binding = function(e) {
        throw new Error("process.binding is not supported");
    }, m.cwd = function() {
        return "/";
    }, m.chdir = function(e) {
        throw new Error("process.chdir is not supported");
    }, m.umask = function() {
        return 0;
    };
}, function(e, t, n) {
    var a, r;
    !function(i, s) {
        "use strict";
        a = s, r = "function" == typeof a ? a.call(t, n, t, e) : a, !(void 0 !== r && (e.exports = r));
    }(this, function() {
        "use strict";
        function e(e, t) {
            var n;
            for (n in t) t.hasOwnProperty(n) && ("undefined" == typeof t[n] ? delete e[n] : e[n] = t[n]);
            return e;
        }
        function t(e, t) {
            var n;
            for (n = 0; n < e.length; n += 1) if (e[n] === t) return n;
            return -1;
        }
        function n(e, n) {
            var a = t(e, n);
            return a !== -1 ? e.splice(a, 1) : [];
        }
        function a(e) {
            return "undefined" != typeof e && "undefined" != typeof e.requireExpects && e.requireExpects;
        }
        function r(e) {
            return !!e.result;
        }
        function i(e) {
            return !r(e);
        }
        function s(e) {
            return i(e) && "undefined" == typeof e.expected && "undefined" == typeof e.actual;
        }
        function o(e) {
            return e.replace(/(\r?\n)/g, "$&# ");
        }
        function l(e) {
            return e.replace(/^\s+/, "");
        }
        function u(e) {
            return e;
        }
        function c(e, t, n, a) {
            e.push(t + ": " + a(n));
        }
        function d(e, t, n, a, r) {
            e && "undefined" != typeof a && c(t, n, a, r);
        }
        function m(e, t) {
            return t ? e + " - " + o(t) : e;
        }
        function f(f, _, v) {
            function b(e) {
                return L.config[e];
            }
            function y(e) {
                if (r(e)) return e.message;
                var t = [];
                return e.message && t.push(e.message), b("showExpectationOnFailure") && !s(e) && (c(t, "expected", e.expected, S), 
                c(t, "got", e.actual, S)), d(b("showTestNameOnFailure"), t, "test", e.name, u), 
                d(b("showModuleNameOnFailure"), t, "module", e.module, u), d(b("showSourceOnFailure"), t, "source", e.source, l), 
                t.join(", ");
            }
            function M(e) {
                L.puts(L.config.initialCount + ".." + e);
            }
            function $(e) {
                var a;
                t(Y, e) !== -1 && (a = w.config[e], "undefined" != typeof a && n(a, T[e]));
            }
            function k(e) {
                var t;
                for (t = 0; t < e.length; t += 1) $(e[t]);
            }
            if (!f) throw new Error('should pass QUnit object reference. Please check QUnit\'s "require" path if you are using Node.js (or any CommonJS env).');
            if ("function" != typeof _) throw new Error("should pass print-like function");
            var w = f, L = {}, D = function(e, t) {
                v && "object" == typeof v && "undefined" != typeof v[e] && (_('# WARNING: Option "' + e + '" is deprecated and will be removed in future version.'), 
                t(v[e]));
            }, Y = [ "moduleStart", "testStart", "log", "testDone", "done" ], T = {}, S = function() {
                return "undefined" != typeof w.dump && "function" == typeof w.dump.parse ? function(e) {
                    return w.dump.parse(e);
                } : "undefined" != typeof w.jsDump && "function" == typeof w.jsDump.parse ? function(e) {
                    return w.jsDump.parse(e);
                } : u;
            }();
            return L.config = e({
                initialCount: 1,
                showModuleNameOnFailure: !0,
                showTestNameOnFailure: !0,
                showExpectationOnFailure: !0,
                showSourceOnFailure: !0
            }, v), D("noPlan", function(e) {
                _('# Now QUnit-TAP works as with "noPlan: true" by default. If you want to delare plan explicitly, please use "QUnit.config.requireExpects" option instead.'), 
                L.config.noPlan = e;
            }), D("count", function(e) {
                L.config.initialCount = e + 1;
            }), D("showDetailsOnFailure", function(e) {
                L.config.showModuleNameOnFailure = e, L.config.showTestNameOnFailure = e, L.config.showExpectationOnFailure = e, 
                L.config.showSourceOnFailure = e;
            }), L.VERSION = p, L.puts = _, L.count = L.config.initialCount - 1, L.expectedCount = L.config.initialCount - 1, 
            L.explain = S, L.note = function(e) {
                L.puts(o("# " + e));
            }, L.diag = function(e) {
                return L.note(e), !1;
            }, L.moduleStart = function(e) {
                var t = "string" == typeof e ? e : e.name;
                L.note("module: " + t);
            }, L.testStart = function(e) {
                var t = "string" == typeof e ? e : e.name;
                L.note("test: " + t);
            }, L.log = function(e) {
                var t = "";
                L.count += 1, i(e) && (t += "not "), t += "ok " + L.count, L.puts(m(t, y(e)));
            }, L.testDone = function() {
                a(w.config) && (L.expectedCount += w.config.current.expected);
            }, L.done = function() {
                ("undefined" == typeof L.config.noPlan || L.config.noPlan) && M(a(w.config) ? L.expectedCount : L.count);
            }, L.unsubscribe = function() {
                "undefined" != typeof w.config && k(0 === arguments.length ? Y : h.apply(arguments));
            }, function() {
                var e, t, n, a = g(w);
                for (t = 0; t < Y.length; t += 1) e = Y[t], n = a(w, L, e), T[e] = n;
            }(), L;
        }
        var p = "1.5.1", h = Array.prototype.slice, g = function(e) {
            return function(e, t, n) {
                var a = e[n], r = function() {
                    t[n].apply(t, h.apply(arguments));
                };
                return a(r), r;
            };
        };
        return f.qunitTap = function() {
            throw new Error('[BC BREAK] Since 1.4.0, QUnit-TAP exports single qunitTap function as module.exports. Therefore, require("qunit-tap") returns qunitTap function itself. Please fix your code if you are using Node.js (or any CommonJS env).');
        }, f;
    });
}, function(e, t, n) {
    (function(e) {
        "use strict";
        var t = !1;
        QUnit.config.autostart = !1;
        var n = window.onerror;
        window.onerror = null, QUnit.begin(function() {
            window.onerror = function(e, t, a) {
                var r = !1;
                return n && (r = n(e, t, a)), QUnit.config.current && QUnit.config.current.async && QUnit.start(), 
                r;
            };
        }), QUnit.moduleStart(function() {
            t = !0;
        }), QUnit.done(function() {
            console.log("phantom-tap-done"), window.onerror = null;
        });
        var a = /^((not )?ok [0-9]+ (- )?)(.*)$/;
        qunitTap(QUnit, function() {
            if (1 == arguments.length && QUnit.config.current) {
                var e = a.exec(arguments[0]);
                if (e) return void console.log(e[1] + QUnit.config.current.testName + ": " + e[4]);
            }
            console.log.apply(console, arguments);
        }), window.setTimeout(function() {
            t || (console.log("QUnit not started by test"), console.log("phantom-tap-error"));
        }, 2e4), window.tests_included = !0, e && e.exports && (e.exports = QUnit);
    }).call(t, n(63)(e));
}, function(e, t) {} ]);
//# sourceMappingURL=test-images.min.js.map