var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import React from 'react';
import PropTypes from 'prop-types';
import times from 'lodash/times';
import { addMonths, addYears } from './helpers';
import { noop } from '../../../common/helpers';

var YearView = function (_React$Component) {
  _inherits(YearView, _React$Component);

  function YearView() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, YearView);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = YearView.__proto__ || Object.getPrototypeOf(YearView)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
      date: new Date(_this.props.date),
      selectedDate: new Date(_this.props.date)
    }, _this.getMonthArray = function () {
      var date = new Date('1/1/1');
      return times(12, function (i) {
        return Intl.DateTimeFormat(_this.props.locale, { month: 'short' }).format(addMonths(date, i));
      });
    }, _this.getPrevYear = function () {
      var date = _this.state.date;

      _this.setState({ date: addYears(date, -1) });
    }, _this.getNextYear = function () {
      var date = _this.state.date;

      _this.setState({ date: addYears(date, 1) });
    }, _this.setSelectedMonth = function (month) {
      var date = _this.state.date;

      date.setMonth(month);
      _this.props.setSelected(date);
      _this.props.toggleDateView('M');
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(YearView, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _state = this.state,
          date = _state.date,
          selectedDate = _state.selectedDate;
      var _ref2 = [date.getMonth(), date.getFullYear()],
          currMonth = _ref2[0],
          currYear = _ref2[1];

      var selectedYear = selectedDate.getFullYear();
      var monthArray = this.getMonthArray();
      return React.createElement(
        'div',
        { className: 'datepicker-months' },
        React.createElement(
          'table',
          { className: 'table-condensed' },
          React.createElement(
            'thead',
            null,
            React.createElement(
              'tr',
              null,
              React.createElement(
                'th',
                { className: 'prev', onClick: this.getPrevYear },
                React.createElement('span', { className: 'glyphicon glyphicon-chevron-left' })
              ),
              React.createElement(
                'th',
                { className: 'picker-switch', onClick: function onClick() {
                    return _this2.props.toggleDateView('D');
                  }, colSpan: '5' },
                currYear
              ),
              React.createElement(
                'th',
                { className: 'next', onClick: this.getNextYear },
                React.createElement('span', { className: 'glyphicon glyphicon-chevron-right' })
              )
            )
          ),
          React.createElement(
            'tbody',
            null,
            React.createElement(
              'tr',
              null,
              React.createElement(
                'td',
                { colSpan: '7' },
                monthArray.map(function (month, idx) {
                  return React.createElement(
                    'span',
                    {
                      onClick: function onClick() {
                        return _this2.setSelectedMonth(idx);
                      },
                      className: 'month ' + (idx === currMonth && selectedYear === currYear ? 'active' : ''),
                      key: idx
                    },
                    month
                  );
                })
              )
            )
          )
        )
      );
    }
  }]);

  return YearView;
}(React.Component);

YearView.propTypes = {
  date: PropTypes.oneOfType([PropTypes.instanceOf(Date), PropTypes.string]),
  setSelected: PropTypes.func,
  toggleDateView: PropTypes.func,
  locale: PropTypes.string
};

YearView.defaultProps = {
  setSelected: noop,
  toggleDateView: noop,
  date: new Date(),
  locale: 'en-US'
};
export default YearView;