/*!
 * 
 * NOTE: This file is generated by webpack from aboutwelcome.jsx
 * using the npm bundle task.
 *
 */
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ([
/* 0 */,
/* 1 */
/***/ ((module) => {

module.exports = React;

/***/ }),
/* 2 */
/***/ ((module) => {

module.exports = ReactDOM;

/***/ }),
/* 3 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AboutWelcomeUtils": () => (/* binding */ AboutWelcomeUtils),
/* harmony export */   "DEFAULT_RTAMO_CONTENT": () => (/* binding */ DEFAULT_RTAMO_CONTENT)
/* harmony export */ });
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */
// If we're in a subdialog, then this is a spotlight modal
const page = document.querySelector(":root[dialogroot=true]") ? "spotlight" : "about:welcome";
const AboutWelcomeUtils = {
  handleUserAction(action) {
    window.AWSendToParent("SPECIAL_ACTION", action);
  },

  sendImpressionTelemetry(messageId, context) {
    window.AWSendEventTelemetry({
      event: "IMPRESSION",
      event_context: { ...context,
        page
      },
      message_id: messageId
    });
  },

  sendActionTelemetry(messageId, elementId, eventName = "CLICK_BUTTON") {
    const ping = {
      event: eventName,
      event_context: {
        source: elementId,
        page
      },
      message_id: messageId
    };
    window.AWSendEventTelemetry(ping);
  },

  async fetchFlowParams(metricsFlowUri) {
    let flowParams;

    try {
      const response = await fetch(metricsFlowUri, {
        credentials: "omit"
      });

      if (response.status === 200) {
        const {
          deviceId,
          flowId,
          flowBeginTime
        } = await response.json();
        flowParams = {
          deviceId,
          flowId,
          flowBeginTime
        };
      } else {
        console.error("Non-200 response", response); // eslint-disable-line no-console
      }
    } catch (e) {
      flowParams = null;
    }

    return flowParams;
  },

  sendEvent(type, detail) {
    document.dispatchEvent(new CustomEvent(`AWPage:${type}`, {
      bubbles: true,
      detail
    }));
  }

};
const DEFAULT_RTAMO_CONTENT = {
  template: "return_to_amo",
  utm_term: "rtamo",
  content: {
    position: "corner",
    hero_text: {
      string_id: "mr1-welcome-screen-hero-text"
    },
    title: {
      string_id: "return-to-amo-subtitle"
    },
    has_noodles: true,
    subtitle: {
      string_id: "return-to-amo-addon-title"
    },
    help_text: {
      string_id: "mr1-onboarding-welcome-image-caption"
    },
    backdrop: "#212121 url(chrome://activity-stream/content/data/content/assets/proton-bkg.avif) center/cover no-repeat fixed",
    primary_button: {
      label: {
        string_id: "return-to-amo-add-extension-label"
      },
      source_id: "ADD_EXTENSION_BUTTON",
      action: {
        type: "INSTALL_ADDON_FROM_URL",
        data: {
          url: null,
          telemetrySource: "rtamo"
        }
      }
    },
    secondary_button: {
      label: {
        string_id: "onboarding-not-now-button-label"
      },
      source_id: "RTAMO_START_BROWSING_BUTTON",
      action: {
        type: "OPEN_AWESOME_BAR"
      }
    },
    secondary_button_top: {
      label: {
        string_id: "mr1-onboarding-sign-in-button-label"
      },
      source_id: "RTAMO_FXA_SIGNIN_BUTTON",
      action: {
        data: {
          entrypoint: "activity-stream-firstrun"
        },
        type: "SHOW_FIREFOX_ACCOUNTS",
        addFlowParams: true
      }
    }
  }
};

/***/ }),
/* 4 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MultiStageAboutWelcome": () => (/* binding */ MultiStageAboutWelcome),
/* harmony export */   "SecondaryCTA": () => (/* binding */ SecondaryCTA),
/* harmony export */   "StepsIndicator": () => (/* binding */ StepsIndicator),
/* harmony export */   "WelcomeScreen": () => (/* binding */ WelcomeScreen)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _MSLocalized__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5);
/* harmony import */ var _lib_aboutwelcome_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3);
/* harmony import */ var _MultiStageProtonScreen__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6);
/* harmony import */ var _LanguageSwitcher__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(10);
/* harmony import */ var _asrouter_templates_FirstRun_addUtmParams__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11);
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */





 // Amount of milliseconds for all transitions to complete (including delays).

const TRANSITION_OUT_TIME = 1000;
const MultiStageAboutWelcome = props => {
  let {
    screens
  } = props;
  const [index, setScreenIndex] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    // Send impression ping when respective screen first renders
    screens.forEach((screen, order) => {
      if (index === order) {
        _lib_aboutwelcome_utils__WEBPACK_IMPORTED_MODULE_2__.AboutWelcomeUtils.sendImpressionTelemetry(`${props.message_id}_${order}_${screen.id}`);
      }
    }); // Remember that a new screen has loaded for browser navigation

    if (props.updateHistory && index > window.history.state) {
      window.history.pushState(index, "");
    }
  }, [index]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (props.updateHistory) {
      // Switch to the screen tracked in state (null for initial state)
      // or last screen index if a user navigates by pressing back
      // button from about:home
      const handler = ({
        state
      }) => setScreenIndex(Math.min(state, screens.length - 1)); // Handle page load, e.g., going back to about:welcome from about:home


      handler(window.history); // Watch for browser back/forward button navigation events

      window.addEventListener("popstate", handler);
      return () => window.removeEventListener("popstate", handler);
    }

    return false;
  }, []);
  const [flowParams, setFlowParams] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
  const {
    metricsFlowUri
  } = props;
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    (async () => {
      if (metricsFlowUri) {
        setFlowParams(await _lib_aboutwelcome_utils__WEBPACK_IMPORTED_MODULE_2__.AboutWelcomeUtils.fetchFlowParams(metricsFlowUri));
      }
    })();
  }, [metricsFlowUri]); // Allow "in" style to render to actually transition towards regular state,
  // which also makes using browser back/forward navigation skip transitions.

  const [transition, setTransition] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(props.transitions ? "in" : "");
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (transition === "in") {
      requestAnimationFrame(() => requestAnimationFrame(() => setTransition("")));
    }
  }, [transition]); // Transition to next screen, opening about:home on last screen button CTA

  const handleTransition = () => {
    // Only handle transitioning out from a screen once.
    if (transition === "out") {
      return;
    } // Start transitioning things "out" immediately when moving forwards.


    setTransition(props.transitions ? "out" : ""); // Actually move forwards after all transitions finish.

    setTimeout(() => {
      if (index < screens.length - 1) {
        setTransition(props.transitions ? "in" : "");
        setScreenIndex(prevState => prevState + 1);
      } else {
        window.AWFinish();
      }
    }, props.transitions ? TRANSITION_OUT_TIME : 0);
  }; // Update top sites with default sites by region when region is available


  const [region, setRegion] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    (async () => {
      setRegion(await window.AWGetRegion());
    })();
  }, []); // Get the active theme so the rendering code can make it selected
  // by default.

  const [activeTheme, setActiveTheme] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
  const [initialTheme, setInitialTheme] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    (async () => {
      let theme = await window.AWGetSelectedTheme();
      setInitialTheme(theme);
      setActiveTheme(theme);
    })();
  }, []);
  const useImportable = props.message_id.includes("IMPORTABLE"); // Track whether we have already sent the importable sites impression telemetry

  const importTelemetrySent = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(false);
  const [topSites, setTopSites] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    (async () => {
      let DEFAULT_SITES = await window.AWGetDefaultSites();
      const importable = JSON.parse(await window.AWGetImportableSites());
      const showImportable = useImportable && importable.length >= 5;

      if (!importTelemetrySent.current) {
        _lib_aboutwelcome_utils__WEBPACK_IMPORTED_MODULE_2__.AboutWelcomeUtils.sendImpressionTelemetry(`${props.message_id}_SITES`, {
          display: showImportable ? "importable" : "static",
          importable: importable.length
        });
        importTelemetrySent.current = true;
      }

      setTopSites(showImportable ? {
        data: importable,
        showImportable
      } : {
        data: DEFAULT_SITES,
        showImportable
      });
    })();
  }, [useImportable, region]);
  const centeredScreens = props.screens.filter(s => s.content.position !== "corner");
  const {
    negotiatedLanguage,
    langPackInstallPhase,
    languageFilteredScreens
  } = (0,_LanguageSwitcher__WEBPACK_IMPORTED_MODULE_4__.useLanguageSwitcher)(props.appAndSystemLocaleInfo, screens, index, setScreenIndex);
  screens = languageFilteredScreens;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: `outer-wrapper onboardingContainer proton transition-${transition}`,
    style: props.backdrop ? {
      background: props.backdrop
    } : {}
  }, screens.map((screen, order) => {
    const isFirstCenteredScreen = screen.content.position !== "corner" && screen === centeredScreens[0];
    const isLastCenteredScreen = screen.content.position !== "corner" && screen === centeredScreens[centeredScreens.length - 1];
    /* If first screen is corner positioned, don't include it in the count for the steps indicator. This assumes corner positioning will only be used on the first screen. */

    const totalNumberOfScreens = screens[0].content.position === "corner" ? screens.length - 1 : screens.length;
    /* Don't include a starting corner screen when determining step indicator order */

    const stepOrder = screens[0].content.position === "corner" ? order - 1 : order;
    return index === order ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(WelcomeScreen, {
      key: screen.id + order,
      id: screen.id,
      totalNumberOfScreens: totalNumberOfScreens,
      isFirstCenteredScreen: isFirstCenteredScreen,
      isLastCenteredScreen: isLastCenteredScreen,
      stepOrder: stepOrder,
      order: order,
      content: screen.content,
      navigate: handleTransition,
      topSites: topSites,
      messageId: `${props.message_id}_${order}_${screen.id}`,
      UTMTerm: props.utm_term,
      flowParams: flowParams,
      activeTheme: activeTheme,
      initialTheme: initialTheme,
      setActiveTheme: setActiveTheme,
      autoAdvance: screen.auto_advance,
      negotiatedLanguage: negotiatedLanguage,
      langPackInstallPhase: langPackInstallPhase
    }) : null;
  })));
};
const SecondaryCTA = props => {
  let targetElement = props.position ? `secondary_button_${props.position}` : `secondary_button`;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: props.position ? `secondary-cta ${props.position}` : "secondary-cta"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
    text: props.content[targetElement].text
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
    text: props.content[targetElement].label
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", {
    className: "secondary text-link",
    value: targetElement,
    onClick: props.handleAction
  })));
};
const StepsIndicator = props => {
  let steps = [];

  for (let i = 0; i < props.totalNumberOfScreens; i++) {
    let className = `${i === props.order ? "current" : ""} ${i < props.order ? "complete" : ""}`;
    steps.push( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      key: i,
      className: `indicator ${className}`
    }));
  }

  return steps;
};
class WelcomeScreen extends (react__WEBPACK_IMPORTED_MODULE_0___default().PureComponent) {
  constructor(props) {
    super(props);
    this.handleAction = this.handleAction.bind(this);
  }

  handleOpenURL(action, flowParams, UTMTerm) {
    let {
      type,
      data
    } = action;

    if (type === "SHOW_FIREFOX_ACCOUNTS") {
      let params = { ..._asrouter_templates_FirstRun_addUtmParams__WEBPACK_IMPORTED_MODULE_5__.BASE_PARAMS,
        utm_term: `aboutwelcome-${UTMTerm}-screen`
      };

      if (action.addFlowParams && flowParams) {
        params = { ...params,
          ...flowParams
        };
      }

      data = { ...data,
        extraParams: params
      };
    } else if (type === "OPEN_URL") {
      let url = new URL(data.args);
      (0,_asrouter_templates_FirstRun_addUtmParams__WEBPACK_IMPORTED_MODULE_5__.addUtmParams)(url, `aboutwelcome-${UTMTerm}-screen`);

      if (action.addFlowParams && flowParams) {
        url.searchParams.append("device_id", flowParams.deviceId);
        url.searchParams.append("flow_id", flowParams.flowId);
        url.searchParams.append("flow_begin_time", flowParams.flowBeginTime);
      }

      data = { ...data,
        args: url.toString()
      };
    }

    _lib_aboutwelcome_utils__WEBPACK_IMPORTED_MODULE_2__.AboutWelcomeUtils.handleUserAction({
      type,
      data
    });
  }

  async handleAction(event) {
    let {
      props
    } = this;
    let {
      value
    } = event.currentTarget;
    let targetContent = props.content[value] || props.content.tiles || props.content.languageSwitcher;

    if (!(targetContent && targetContent.action)) {
      return;
    } // Send telemetry before waiting on actions


    _lib_aboutwelcome_utils__WEBPACK_IMPORTED_MODULE_2__.AboutWelcomeUtils.sendActionTelemetry(props.messageId, event.currentTarget.value, event.name);
    let {
      action
    } = targetContent;

    if (["OPEN_URL", "SHOW_FIREFOX_ACCOUNTS"].includes(action.type)) {
      this.handleOpenURL(action, props.flowParams, props.UTMTerm);
    } else if (action.type) {
      _lib_aboutwelcome_utils__WEBPACK_IMPORTED_MODULE_2__.AboutWelcomeUtils.handleUserAction(action); // Wait until migration closes to complete the action

      if (action.type === "SHOW_MIGRATION_WIZARD") {
        await window.AWWaitForMigrationClose();
        _lib_aboutwelcome_utils__WEBPACK_IMPORTED_MODULE_2__.AboutWelcomeUtils.sendActionTelemetry(props.messageId, "migrate_close");
      }
    } // A special tiles.action.theme value indicates we should use the event's value vs provided value.


    if (action.theme) {
      let themeToUse = action.theme === "<event>" ? event.currentTarget.value : this.props.initialTheme || action.theme;
      this.props.setActiveTheme(themeToUse);
      window.AWSelectTheme(themeToUse);
    }

    if (action.navigate) {
      props.navigate();
    }
  }

  render() {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MultiStageProtonScreen__WEBPACK_IMPORTED_MODULE_3__.MultiStageProtonScreen, {
      content: this.props.content,
      id: this.props.id,
      order: this.props.order,
      stepOrder: this.props.stepOrder,
      activeTheme: this.props.activeTheme,
      totalNumberOfScreens: this.props.totalNumberOfScreens,
      appAndSystemLocaleInfo: this.props.appAndSystemLocaleInfo,
      negotiatedLanguage: this.props.negotiatedLanguage,
      langPackInstallPhase: this.props.langPackInstallPhase,
      handleAction: this.handleAction,
      messageId: this.props.messageId,
      isFirstCenteredScreen: this.props.isFirstCenteredScreen,
      isLastCenteredScreen: this.props.isLastCenteredScreen,
      startsWithCorner: this.props.startsWithCorner,
      autoAdvance: this.props.autoAdvance
    });
  }

}

/***/ }),
/* 5 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Localized": () => (/* binding */ Localized)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

const CONFIGURABLE_STYLES = ["color", "fontSize", "fontWeight", "letterSpacing", "lineHeight", "marginBlock", "marginInline", "paddingBlock", "paddingInline"];
const ZAP_SIZE_THRESHOLD = 160;
/**
 * Based on the .text prop, localizes an inner element if a string_id
 * is provided, OR renders plain text, OR hides it if nothing is provided.
 * Allows configuring of some styles including zap underline and color.
 *
 * Examples:
 *
 * Localized text
 * ftl:
 *  title = Welcome
 * jsx:
 *   <Localized text={{string_id: "title"}}><h1 /></Localized>
 * output:
 *   <h1 data-l10n-id="title">Welcome</h1>
 *
 * Unlocalized text
 * jsx:
 *   <Localized text="Welcome"><h1 /></Localized>
 *   <Localized text={{raw: "Welcome"}}><h1 /></Localized>
 * output:
 *   <h1>Welcome</h1>
 */

const Localized = ({
  text,
  children
}) => {
  // Dynamically determine the size of the zap style.
  const zapRef = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createRef();
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const {
      current
    } = zapRef;
    if (current) requestAnimationFrame(() => current === null || current === void 0 ? void 0 : current.classList.replace("short", current.getBoundingClientRect().width > ZAP_SIZE_THRESHOLD ? "long" : "short"));
  }); // Skip rendering of children with no text.

  if (!text) {
    return null;
  } // Allow augmenting existing child container properties.


  const props = {
    children: [],
    className: "",
    style: {},
    ...(children === null || children === void 0 ? void 0 : children.props)
  }; // Support nested Localized by starting with their children.

  const textNodes = props.children; // Pick desired fluent or raw/plain text to render.

  if (text.string_id) {
    props["data-l10n-id"] = text.string_id;
    if (text.args) props["data-l10n-args"] = JSON.stringify(text.args);
  } else if (text.raw) {
    textNodes.push(text.raw);
  } else if (typeof text === "string") {
    textNodes.push(text);
  } // Add zap style and content in a way that allows fluent to insert too.


  if (text.zap) {
    props.className += " welcomeZap";
    textNodes.push( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
      className: "short zap",
      "data-l10n-name": "zap",
      ref: zapRef
    }, text.zap));
  } // Apply certain configurable styles.


  CONFIGURABLE_STYLES.forEach(style => {
    if (text[style] !== undefined) props.style[style] = text[style];
  });
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().cloneElement( // Provide a default container for the text if necessary.
  children ?? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null), props, // Conditionally pass in as void elements can't accept empty array.
  textNodes.length ? textNodes : null);
};

/***/ }),
/* 6 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MultiStageProtonScreen": () => (/* binding */ MultiStageProtonScreen),
/* harmony export */   "ProtonScreen": () => (/* binding */ ProtonScreen)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _MSLocalized__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5);
/* harmony import */ var _Colorways__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7);
/* harmony import */ var _MobileDownloads__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8);
/* harmony import */ var _Themes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9);
/* harmony import */ var _MultiStageAboutWelcome__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4);
/* harmony import */ var _LanguageSwitcher__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(10);
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */







const MultiStageProtonScreen = props => {
  const {
    autoAdvance,
    handleAction,
    order
  } = props;
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (autoAdvance) {
      const timer = setTimeout(() => {
        handleAction({
          currentTarget: {
            value: autoAdvance
          },
          name: "AUTO_ADVANCE"
        });
      }, 20000);
      return () => clearTimeout(timer);
    }

    return () => {};
  }, [autoAdvance, handleAction, order]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ProtonScreen, {
    content: props.content,
    id: props.id,
    order: props.order,
    activeTheme: props.activeTheme,
    totalNumberOfScreens: props.totalNumberOfScreens,
    handleAction: props.handleAction,
    isFirstCenteredScreen: props.isFirstCenteredScreen,
    isLastCenteredScreen: props.isLastCenteredScreen,
    stepOrder: props.stepOrder,
    autoAdvance: props.autoAdvance,
    isRtamo: props.isRtamo,
    addonName: props.addonName,
    isTheme: props.isTheme,
    iconURL: props.iconURL,
    messageId: props.messageId,
    negotiatedLanguage: props.negotiatedLanguage,
    langPackInstallPhase: props.langPackInstallPhase
  });
};
class ProtonScreen extends (react__WEBPACK_IMPORTED_MODULE_0___default().PureComponent) {
  componentDidMount() {
    this.mainContentHeader.focus();
  }

  getLogoStyle({
    imageURL,
    height
  }) {
    let style = {
      height
    };
    style.backgroundImage = imageURL ? `url(${imageURL})` : null;
    return style;
  }

  getScreenClassName(isFirstCenteredScreen, isLastCenteredScreen, includeNoodles) {
    const screenClass = `screen-${this.props.order % 2 !== 0 ? 1 : 2}`;
    return `${isFirstCenteredScreen ? `dialog-initial` : ``} ${isLastCenteredScreen ? `dialog-last` : ``} ${includeNoodles ? `with-noodles` : ``} ${screenClass}`;
  }

  renderContentTiles() {
    const {
      content
    } = this.props;
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, content.tiles && content.tiles.type === "colorway" && content.tiles.colorways ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Colorways__WEBPACK_IMPORTED_MODULE_2__.Colorways, {
      content: content,
      activeTheme: this.props.activeTheme,
      handleAction: this.props.handleAction
    }) : null, content.tiles && content.tiles.type === "theme" && content.tiles.data ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Themes__WEBPACK_IMPORTED_MODULE_4__.Themes, {
      content: content,
      activeTheme: this.props.activeTheme,
      handleAction: this.props.handleAction
    }) : null, content.tiles && content.tiles.type === "mobile_downloads" && content.tiles.data ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MobileDownloads__WEBPACK_IMPORTED_MODULE_3__.MobileDownloads, {
      data: content.tiles.data,
      handleAction: this.props.handleAction
    }) : null);
  }

  renderNoodles() {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: "noodle orange-L"
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: "noodle purple-C"
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: "noodle solid-L"
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: "noodle outline-L"
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: "noodle yellow-circle"
    }));
  }

  renderLanguageSwitcher() {
    return this.props.content.languageSwitcher ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_LanguageSwitcher__WEBPACK_IMPORTED_MODULE_6__.LanguageSwitcher, {
      content: this.props.content,
      handleAction: this.props.handleAction,
      negotiatedLanguage: this.props.negotiatedLanguage,
      langPackInstallPhase: this.props.langPackInstallPhase,
      messageId: this.props.messageId
    }) : null;
  }

  renderDismissButton() {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", {
      className: "dismiss-button",
      onClick: this.props.handleAction,
      value: "dismiss_button",
      "data-l10n-id": "spotlight-dialog-close-button"
    });
  }

  renderSecondarySection(content) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: "section-secondary",
      style: content.background ? {
        background: content.background
      } : {}
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: "message-text"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: "spacer-top"
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
      text: content.hero_text
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h1", null)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: "spacer-bottom"
    })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
      text: content.help_text
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
      className: "attrib-text"
    })));
  }

  render() {
    var _this$props$appAndSys, _content$primary_butt, _content$primary_butt2;

    const {
      autoAdvance,
      content,
      isRtamo,
      isTheme,
      isFirstCenteredScreen,
      isLastCenteredScreen,
      totalNumberOfScreens: total
    } = this.props;
    const includeNoodles = content.has_noodles; // The default screen position is "center"

    const isCenterPosition = content.position === "center" || !content.position;
    const hideStepsIndicator = autoAdvance || isFirstCenteredScreen && isLastCenteredScreen;
    const textColorClass = content.text_color ? `${content.text_color}-text` : ""; // Assign proton screen style 'screen-1' or 'screen-2' to centered screens
    // by checking if screen order is even or odd.

    const screenClassName = isCenterPosition ? this.getScreenClassName(isFirstCenteredScreen, isLastCenteredScreen, includeNoodles) : "";
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("main", {
      className: `screen ${this.props.id || ""} ${screenClassName} ${textColorClass}`,
      role: "dialog",
      pos: content.position || "center",
      tabIndex: "-1",
      "aria-labelledby": "mainContentHeader",
      ref: input => {
        this.mainContentHeader = input;
      }
    }, isCenterPosition ? null : this.renderSecondarySection(content), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: "section-main"
    }, content.secondary_button_top ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MultiStageAboutWelcome__WEBPACK_IMPORTED_MODULE_5__.SecondaryCTA, {
      content: content,
      handleAction: this.props.handleAction,
      position: "top"
    }) : null, includeNoodles ? this.renderNoodles() : null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: `main-content ${hideStepsIndicator ? "no-steps" : ""}`,
      style: content.background && isCenterPosition ? {
        background: content.background
      } : {}
    }, content.dismiss_button ? this.renderDismissButton() : null, content.logo ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: `brand-logo`,
      style: this.getLogoStyle(content.logo)
    }) : null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: `${isRtamo ? "rtamo-icon" : "hide-rtamo-icon"}`
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("img", {
      className: `${isTheme ? "rtamo-theme-icon" : ""}`,
      src: this.props.iconURL,
      role: "presentation",
      alt: ""
    })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: "main-content-inner"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: `welcome-text ${content.title_style || ""}`
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
      text: content.title
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h1", {
      id: "mainContentHeader"
    })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
      text: content.subtitle
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", {
      "data-l10n-args": JSON.stringify({
        "addon-name": this.props.addonName,
        ...((_this$props$appAndSys = this.props.appAndSystemLocaleInfo) === null || _this$props$appAndSys === void 0 ? void 0 : _this$props$appAndSys.displayNames)
      })
    }))), this.renderContentTiles(), this.renderLanguageSwitcher(), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: "action-buttons"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
      text: (_content$primary_butt = content.primary_button) === null || _content$primary_butt === void 0 ? void 0 : _content$primary_butt.label
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", {
      className: "primary",
      value: "primary_button",
      disabled: ((_content$primary_butt2 = content.primary_button) === null || _content$primary_butt2 === void 0 ? void 0 : _content$primary_butt2.disabled) === true,
      onClick: this.props.handleAction
    })), content.secondary_button ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MultiStageAboutWelcome__WEBPACK_IMPORTED_MODULE_5__.SecondaryCTA, {
      content: content,
      handleAction: this.props.handleAction
    }) : null)), hideStepsIndicator ? null : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("nav", {
      className: `steps ${content.progress_bar ? "progress-bar" : ""}`,
      "data-l10n-id": "onboarding-welcome-steps-indicator",
      "data-l10n-args": JSON.stringify({
        current: this.props.order,
        total
      })
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("br", null), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MultiStageAboutWelcome__WEBPACK_IMPORTED_MODULE_5__.StepsIndicator, {
      order: this.props.stepOrder,
      totalNumberOfScreens: total
    })))));
  }

}

/***/ }),
/* 7 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "VariationsCircle": () => (/* binding */ VariationsCircle),
/* harmony export */   "computeColorWay": () => (/* binding */ computeColorWay),
/* harmony export */   "Colorways": () => (/* binding */ Colorways)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _MSLocalized__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5);
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

 // Click of variation should call handle action
// passing 'colorway-variationId' theme name as event target value
// For default colorway , theme value passed to handle action
// includes just variation.id e.g. Light, Dark, Automatic

const VariationsCircle = props => {
  const {
    activeTheme,
    colorway,
    colorwayText,
    nextColor,
    setVariation,
    transition,
    variations
  } = props;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: `colorway-variations ${colorway} ${transition}`,
    next: nextColor
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "variations-disc"
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
    text: colorwayText
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "colorway-text"
  })), variations === null || variations === void 0 ? void 0 : variations.map(({
    id,
    label,
    tooltip,
    description
  }) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
    key: id,
    text: typeof tooltip === "object" ? tooltip : {}
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", {
    className: "theme colorway",
    title: label
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
    text: typeof description === "object" ? description : {}
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
    type: "radio",
    value: colorway === "default" ? id : `${colorway}-${id}`,
    checked: activeTheme === null || activeTheme === void 0 ? void 0 : activeTheme.includes(id),
    name: "variationSelect",
    className: "sr-only input",
    onClick: setVariation
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
    text: label
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: `text variation-button ${activeTheme !== null && activeTheme !== void 0 && activeTheme.includes(id) ? " selected" : ""}`
  }))))));
}; // Return colorway as "default" for default theme variations Automatic, Light, Dark
// and Alpenglow theme which is not supported in Colorway picker
// For themes other then default, theme names exist in
// format colorway-variationId inside LIGHT_WEIGHT_THEMES in AboutWelcomeParent

function computeColorWay(themeName, systemVariations) {
  return !themeName || themeName === "alpenglow" || systemVariations.find(variation => themeName === variation.id) ? "default" : themeName.split("-")[0];
}
function Colorways(props) {
  var _colorways$find;

  let {
    colorways,
    defaultVariationIndex,
    systemVariations,
    variations
  } = props.content.tiles; // This sets a default value

  const activeId = computeColorWay(props.activeTheme, systemVariations);
  const [colorwayId, setState] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(activeId); // Update state any time activeTheme changes.

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    setState(computeColorWay(props.activeTheme, systemVariations));
  }, [props.activeTheme]); // Allow "in" style to render to actually transition towards regular state.

  const [transition, setTransition] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)("");
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (transition === "in") {
      // Figure out the variation to activate based on the active theme. Check
      // if it's a system variant then colorway variant falling back to default.
      let variationIndex = systemVariations.findIndex(({
        id
      }) => id === props.activeTheme);

      if (variationIndex < 0) {
        variationIndex = variations.findIndex(({
          id
        }) => props.activeTheme.includes(id));
      }

      if (variationIndex < 0) {
        // This content config default assumes it's been selected correctly to
        // index into both `systemVariations` or `variations` (also configured).
        variationIndex = defaultVariationIndex;
      } // Simulate a color click event now that we're ready to transition in.


      props.handleAction({
        currentTarget: {
          value: colorwayId === "default" ? systemVariations[variationIndex].id : `${colorwayId}-${variations[variationIndex].id}`
        }
      }); // Trigger the transition from "in" to normal.

      requestAnimationFrame(() => requestAnimationFrame(() => setTransition("")));
    }
  }, [transition]); // Called on click of Colorway circle that sets the next colorway state and
  // starts transitions if not already started.

  function handleColorwayClick(event) {
    setState(event.currentTarget.dataset.colorway);

    if (transition !== "out") {
      setTransition("out");
      setTimeout(() => setTransition("in"), 500);
    }
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "tiles-theme-container colorway"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("fieldset", {
    className: "tiles-theme-section"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
    text: props.content.subtitle
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("legend", {
    className: "sr-only"
  })), colorways.map(({
    id,
    label,
    tooltip,
    description
  }) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
    key: id + label,
    text: typeof tooltip === "object" ? tooltip : {}
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", {
    className: "theme colorway",
    title: label,
    "data-l10n-args": JSON.stringify({
      colorwayName: label
    })
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
    text: typeof description === "object" ? description : {}
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: "sr-only colorway label",
    id: `${id}-label`,
    "data-l10n-args": JSON.stringify({
      colorwayName: label
    })
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
    text: typeof description === "object" ? description : {}
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
    type: "radio",
    "data-colorway": id,
    name: "theme",
    checked: colorwayId === id,
    className: "sr-only input",
    onClick: handleColorwayClick,
    "data-l10n-args": JSON.stringify({
      colorwayName: label
    }),
    "aria-labelledby": `${id}-label`
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: `icon colorway ${colorwayId === id ? "selected" : ""} ${id}`
  })))))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(VariationsCircle, {
    nextColor: colorwayId,
    transition: transition,
    variations: activeId === "default" ? systemVariations : variations,
    colorway: activeId,
    colorwayText: (_colorways$find = colorways.find(colorway => colorway.id === activeId)) === null || _colorways$find === void 0 ? void 0 : _colorways$find.label,
    setVariation: props.handleAction,
    activeTheme: props.activeTheme
  }));
}

/***/ }),
/* 8 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MarketplaceButtons": () => (/* binding */ MarketplaceButtons),
/* harmony export */   "MobileDownloads": () => (/* binding */ MobileDownloads)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _MSLocalized__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5);
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */


const MarketplaceButtons = props => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", {
    className: "mobile-download-buttons"
  }, props.buttons.includes("ios") ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", {
    className: "ios"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", {
    "data-l10n-id": "spotlight-ios-marketplace-button",
    value: "ios",
    onClick: props.handleAction
  })) : null, props.buttons.includes("android") ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", {
    className: "android"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", {
    "data-l10n-id": "spotlight-android-marketplace-button",
    value: "android",
    onClick: props.handleAction
  })) : null);
};
const MobileDownloads = props => {
  var _QRCode$image_overrid;

  const {
    QR_code: QRCode
  } = props.data;
  const showEmailLink = props.data.email && window.AWSendToDeviceEmailsSupported();
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "mobile-downloads"
  }, QRCode ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("img", {
    "data-l10n-id": QRCode.alt_text.string_id ? QRCode.alt_text.string_id : null,
    className: "qr-code-image",
    alt: typeof QRCode.alt_text === "string" ? QRCode.alt_text : "",
    src: ((_QRCode$image_overrid = QRCode.image_overrides) === null || _QRCode$image_overrid === void 0 ? void 0 : _QRCode$image_overrid[document.documentElement.lang]) ?? QRCode.image_url
  }) : null, showEmailLink ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
    text: props.data.email.link_text
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", {
    className: "email-link",
    value: "email_link",
    onClick: props.handleAction
  }))) : null, props.data.marketplace_buttons ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(MarketplaceButtons, {
    buttons: props.data.marketplace_buttons,
    handleAction: props.handleAction
  }) : null);
};

/***/ }),
/* 9 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Themes": () => (/* binding */ Themes)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _MSLocalized__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5);
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */


const Themes = props => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "tiles-theme-container"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("fieldset", {
    className: "tiles-theme-section"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
    text: props.content.subtitle
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("legend", {
    className: "sr-only"
  })), props.content.tiles.data.map(({
    theme,
    label,
    tooltip,
    description
  }) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
    key: theme + label,
    text: typeof tooltip === "object" ? tooltip : {}
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", {
    className: "theme",
    title: theme + label
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
    text: typeof description === "object" ? description : {}
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
    type: "radio",
    value: theme,
    name: "theme",
    checked: theme === props.activeTheme,
    className: "sr-only input",
    onClick: props.handleAction
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: `icon ${theme === props.activeTheme ? " selected" : ""} ${theme}`
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
    text: label
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "text"
  }))))))));
};

/***/ }),
/* 10 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useLanguageSwitcher": () => (/* binding */ useLanguageSwitcher),
/* harmony export */   "LanguageSwitcher": () => (/* binding */ LanguageSwitcher)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _MSLocalized__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5);
/* harmony import */ var _lib_aboutwelcome_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3);
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */



/**
 * The language switcher implements a hook that should be placed at a higher level
 * than the actual language switcher component, as it needs to preemptively fetch
 * and install langpacks for the user if there is a language mismatch screen.
 */

function useLanguageSwitcher(appAndSystemLocaleInfo, screens, screenIndex, setScreenIndex) {
  const languageMismatchScreenIndex = screens.findIndex(({
    id
  }) => id === "AW_LANGUAGE_MISMATCH");
  const screen = screens[languageMismatchScreenIndex]; // If there is a mismatch, then Firefox can negotiate a better langpack to offer
  // the user.

  const [negotiatedLanguage, setNegotiatedLanguage] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function getNegotiatedLanguage() {
    if (!appAndSystemLocaleInfo) {
      return;
    }

    if (appAndSystemLocaleInfo.matchType !== "language-mismatch") {
      // There is no language mismatch, so there is no need to negotiate a langpack.
      return;
    }

    (async () => {
      const {
        langPack,
        langPackDisplayName
      } = await window.AWNegotiateLangPackForLanguageMismatch(appAndSystemLocaleInfo);

      if (langPack) {
        setNegotiatedLanguage({
          langPackDisplayName,
          appDisplayName: appAndSystemLocaleInfo.displayNames.appLanguage,
          langPack,
          requestSystemLocales: [langPack.target_locale, appAndSystemLocaleInfo.appLocaleRaw],
          originalAppLocales: [appAndSystemLocaleInfo.appLocaleRaw]
        });
      } else {
        setNegotiatedLanguage({
          langPackDisplayName: null,
          appDisplayName: null,
          langPack: null,
          requestSystemLocales: null
        });
      }
    })();
  }, [appAndSystemLocaleInfo]);
  /**
   * @type {
   *  "before-installation"
   *  | "installing"
   *  | "installed"
   *  | "installation-error"
   *  | "none-available"
   * }
   */

  const [langPackInstallPhase, setLangPackInstallPhase] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)("before-installation");
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function ensureLangPackInstalled() {
    if (!negotiatedLanguage) {
      // There are no negotiated languages to download yet.
      return;
    }

    setLangPackInstallPhase("installing");
    window.AWEnsureLangPackInstalled(negotiatedLanguage.langPack).then(() => {
      setLangPackInstallPhase("installed");
    }, error => {
      console.error(error);
      setLangPackInstallPhase("installation-error");
    });
  }, [negotiatedLanguage]);
  const [languageFilteredScreens, setLanguageFilteredScreens] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(screens);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function filterScreen() {
    // Remove the language screen if it exists (already removed for no live
    // reload) and we either don't-need-to or can't switch.
    if (screen && ((appAndSystemLocaleInfo === null || appAndSystemLocaleInfo === void 0 ? void 0 : appAndSystemLocaleInfo.matchType) !== "language-mismatch" || (negotiatedLanguage === null || negotiatedLanguage === void 0 ? void 0 : negotiatedLanguage.langPack) === null)) {
      if (screenIndex > languageMismatchScreenIndex) {
        setScreenIndex(screenIndex - 1);
      }

      setLanguageFilteredScreens(screens.filter(s => s.id !== "AW_LANGUAGE_MISMATCH"));
    } else {
      setLanguageFilteredScreens(screens);
    }
  }, [screens, negotiatedLanguage]);
  return {
    negotiatedLanguage,
    langPackInstallPhase,
    languageFilteredScreens
  };
}
/**
 * The language switcher is a separate component as it needs to perform some asynchronous
 * network actions such as retrieving the list of langpacks available, and downloading
 * a new langpack. On a fast connection, this won't be noticeable, but on slow or unreliable
 * internet this may fail for a user.
 */

function LanguageSwitcher(props) {
  const {
    content,
    handleAction,
    negotiatedLanguage,
    langPackInstallPhase,
    messageId
  } = props;
  const [isAwaitingLangpack, setIsAwaitingLangpack] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false); // Determine the status of the langpack installation.

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (isAwaitingLangpack && langPackInstallPhase !== "installing") {
      window.AWSetRequestedLocales(negotiatedLanguage.requestSystemLocales);
      requestAnimationFrame(() => {
        handleAction( // Simulate the click event.
        {
          currentTarget: {
            value: "download_complete"
          }
        });
      });
    }
  }, [isAwaitingLangpack, langPackInstallPhase]); // The message args are the localized language names.

  const withMessageArgs = obj => {
    const langPackDisplayName = negotiatedLanguage === null || negotiatedLanguage === void 0 ? void 0 : negotiatedLanguage.langPackDisplayName;

    if (langPackDisplayName) {
      return { ...obj,
        args: { ...obj.args,
          negotiatedLanguage: langPackDisplayName
        }
      };
    }

    return obj;
  };

  let showWaitingScreen = false;
  let showPreloadingScreen = false;
  let showReadyScreen = false;

  if (isAwaitingLangpack && langPackInstallPhase !== "installed") {
    showWaitingScreen = true;
  } else if (langPackInstallPhase === "before-installation") {
    showPreloadingScreen = true;
  } else {
    showReadyScreen = true;
  } // Use {display: "none"} rather than if statements to prevent layout thrashing with
  // the localized text elements rendering as blank, then filling in the text.


  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    style: {
      display: showPreloadingScreen ? "block" : "none"
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", {
    className: "primary",
    value: "primary_button",
    disabled: true,
    type: "button"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("img", {
    className: "language-loader",
    src: "chrome://browser/skin/tabbrowser/tab-connecting.png",
    alt: ""
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
    text: content.languageSwitcher.waiting
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "secondary-cta"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
    text: content.languageSwitcher.skip
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", {
    value: "decline_waiting",
    type: "button",
    className: "secondary text-link",
    onClick: handleAction
  })))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    style: {
      display: showWaitingScreen ? "block" : "none"
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", {
    className: "primary",
    value: "primary_button",
    disabled: true,
    type: "button"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("img", {
    className: "language-loader",
    src: "chrome://browser/skin/tabbrowser/tab-connecting.png",
    alt: ""
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
    text: withMessageArgs(content.languageSwitcher.downloading)
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "secondary-cta"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MSLocalized__WEBPACK_IMPORTED_MODULE_1__.Localized, {
    text: content.languageSwitcher.cancel
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", {
    type: "button",
    className: "secondary text-link",
    onClick: () => {
      setIsAwaitingLangpack(false);
      handleAction({
        currentTarget: {
          value: "cancel_waiting"
        }
      });
    }
  })))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    style: {
      display: showReadyScreen ? "block" : "none"
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", {
    className: "primary",
    value: "primary_button",
    onClick: () => {
      _lib_aboutwelcome_utils__WEBPACK_IMPORTED_MODULE_2__.AboutWelcomeUtils.sendActionTelemetry(messageId, "download_langpack");
      setIsAwaitingLangpack(true);
    }
  }, // This is the localized name from the Intl.DisplayNames API.
  negotiatedLanguage === null || negotiatedLanguage === void 0 ? void 0 : negotiatedLanguage.langPackDisplayName)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", {
    type: "button",
    className: "secondary",
    value: "decline",
    onClick: event => {
      window.AWSetRequestedLocales(negotiatedLanguage.originalAppLocales);
      handleAction(event);
    }
  }, // This is the localized name from the Intl.DisplayNames API.
  negotiatedLanguage === null || negotiatedLanguage === void 0 ? void 0 : negotiatedLanguage.appDisplayName))));
}

/***/ }),
/* 11 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BASE_PARAMS": () => (/* binding */ BASE_PARAMS),
/* harmony export */   "addUtmParams": () => (/* binding */ addUtmParams)
/* harmony export */ });
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/**
 * BASE_PARAMS keys/values can be modified from outside this file
 */
const BASE_PARAMS = {
  utm_source: "activity-stream",
  utm_campaign: "firstrun",
  utm_medium: "referral"
};
/**
 * Takes in a url as a string or URL object and returns a URL object with the
 * utm_* parameters added to it. If a URL object is passed in, the paraemeters
 * are added to it (the return value can be ignored in that case as it's the
 * same object).
 */

function addUtmParams(url, utmTerm) {
  let returnUrl = url;

  if (typeof returnUrl === "string") {
    returnUrl = new URL(url);
  }

  Object.keys(BASE_PARAMS).forEach(key => {
    returnUrl.searchParams.append(key, BASE_PARAMS[key]);
  });
  returnUrl.searchParams.append("utm_term", utmTerm);
  return returnUrl;
}

/***/ }),
/* 12 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ReturnToAMO": () => (/* binding */ ReturnToAMO)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lib_aboutwelcome_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3);
/* harmony import */ var _MultiStageProtonScreen__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6);
/* harmony import */ var _asrouter_templates_FirstRun_addUtmParams__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11);
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */




class ReturnToAMO extends (react__WEBPACK_IMPORTED_MODULE_0___default().PureComponent) {
  constructor(props) {
    super(props);
    this.fetchFlowParams = this.fetchFlowParams.bind(this);
    this.handleAction = this.handleAction.bind(this);
  }

  async fetchFlowParams() {
    if (this.props.metricsFlowUri) {
      this.setState({
        flowParams: await _lib_aboutwelcome_utils__WEBPACK_IMPORTED_MODULE_1__.AboutWelcomeUtils.fetchFlowParams(this.props.metricsFlowUri)
      });
    }
  }

  componentDidUpdate() {
    this.fetchFlowParams();
  }

  handleAction(event) {
    const {
      content,
      message_id,
      url,
      utm_term
    } = this.props;
    let {
      action,
      source_id
    } = content[event.currentTarget.value];
    let {
      type,
      data
    } = action;

    if (type === "INSTALL_ADDON_FROM_URL") {
      if (!data) {
        return;
      } // Set add-on url in action.data.url property from JSON


      data = { ...data,
        url
      };
    } else if (type === "SHOW_FIREFOX_ACCOUNTS") {
      let params = { ..._asrouter_templates_FirstRun_addUtmParams__WEBPACK_IMPORTED_MODULE_3__.BASE_PARAMS,
        utm_term: `aboutwelcome-${utm_term}-screen`
      };

      if (action.addFlowParams && this.state.flowParams) {
        params = { ...params,
          ...this.state.flowParams
        };
      }

      data = { ...data,
        extraParams: params
      };
    }

    _lib_aboutwelcome_utils__WEBPACK_IMPORTED_MODULE_1__.AboutWelcomeUtils.handleUserAction({
      type,
      data
    });
    _lib_aboutwelcome_utils__WEBPACK_IMPORTED_MODULE_1__.AboutWelcomeUtils.sendActionTelemetry(message_id, source_id);
  }

  render() {
    var _this$props$themeScre;

    const {
      content,
      type
    } = this.props;

    if (!content) {
      return null;
    }

    if (content !== null && content !== void 0 && content.primary_button.label) {
      content.primary_button.label.string_id = type.includes("theme") ? "return-to-amo-add-theme-label" : "return-to-amo-add-extension-label";
    } // For experiments, when needed below rendered UI allows settings hard coded strings
    // directly inside JSON except for ReturnToAMOText which picks add-on name and icon from fluent string


    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
      className: "outer-wrapper onboardingContainer proton",
      style: content.backdrop ? {
        background: content.backdrop
      } : {}
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MultiStageProtonScreen__WEBPACK_IMPORTED_MODULE_2__.MultiStageProtonScreen, {
      content: content,
      isRtamo: true,
      isTheme: type.includes("theme"),
      id: this.props.messageId,
      order: this.props.order,
      totalNumberOfScreens: this.props.totalNumberOfScreens,
      autoAdvance: this.props.auto_advance,
      iconURL: type.includes("theme") ? (_this$props$themeScre = this.props.themeScreenshots[0]) === null || _this$props$themeScre === void 0 ? void 0 : _this$props$themeScre.url : this.props.iconURL,
      addonName: this.props.name,
      handleAction: this.handleAction,
      addExtension: this.onClickAddExtension
    }));
  }

}
ReturnToAMO.defaultProps = _lib_aboutwelcome_utils__WEBPACK_IMPORTED_MODULE_1__.DEFAULT_RTAMO_CONTENT;

/***/ })
/******/ 	]);
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lib_aboutwelcome_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3);
/* harmony import */ var _components_MultiStageAboutWelcome__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4);
/* harmony import */ var _components_ReturnToAMO__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(12);
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */






class AboutWelcome extends (react__WEBPACK_IMPORTED_MODULE_0___default().PureComponent) {
  constructor(props) {
    super(props);
    this.state = {
      metricsFlowUri: null
    };
    this.fetchFxAFlowUri = this.fetchFxAFlowUri.bind(this);
  }

  async fetchFxAFlowUri() {
    this.setState({
      metricsFlowUri: await window.AWGetFxAMetricsFlowURI()
    });
  }

  componentDidMount() {
    if (!this.props.skipFxA) {
      this.fetchFxAFlowUri();
    } // Record impression with performance data after allowing the page to load


    const recordImpression = domState => {
      const {
        domComplete,
        domInteractive
      } = performance.getEntriesByType("navigation").pop();
      _lib_aboutwelcome_utils__WEBPACK_IMPORTED_MODULE_2__.AboutWelcomeUtils.sendImpressionTelemetry(this.props.messageId, {
        domComplete,
        domInteractive,
        mountStart: performance.getEntriesByName("mount").pop().startTime,
        domState,
        source: this.props.UTMTerm
      });
    };

    if (document.readyState === "complete") {
      // Page might have already triggered a load event because it waited for async data,
      // e.g., attribution, so the dom load timing could be of a empty content
      // with domState in telemetry captured as 'complete'
      recordImpression(document.readyState);
    } else {
      window.addEventListener("load", () => recordImpression("load"), {
        once: true
      });
    } // Captures user has seen about:welcome by setting
    // firstrun.didSeeAboutWelcome pref to true and capturing welcome UI unique messageId


    window.AWSendToParent("SET_WELCOME_MESSAGE_SEEN", this.props.messageId);
  }

  render() {
    const {
      props
    } = this;

    if (props.template === "return_to_amo") {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_ReturnToAMO__WEBPACK_IMPORTED_MODULE_4__.ReturnToAMO, {
        message_id: props.messageId,
        type: props.type,
        name: props.name,
        url: props.url,
        iconURL: props.iconURL,
        themeScreenshots: props.screenshots,
        metricsFlowUri: this.state.metricsFlowUri
      });
    }

    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_components_MultiStageAboutWelcome__WEBPACK_IMPORTED_MODULE_3__.MultiStageAboutWelcome, {
      message_id: props.messageId,
      screens: props.screens,
      updateHistory: !props.disableHistoryUpdates,
      metricsFlowUri: this.state.metricsFlowUri,
      utm_term: props.UTMTerm,
      transitions: props.transitions,
      backdrop: props.backdrop,
      appAndSystemLocaleInfo: props.appAndSystemLocaleInfo
    });
  }

} // Computes messageId and UTMTerm info used in telemetry


function ComputeTelemetryInfo(welcomeContent, experimentId, branchId) {
  let messageId = welcomeContent.template === "return_to_amo" ? `RTAMO_DEFAULT_WELCOME_${welcomeContent.type.toUpperCase()}` : "DEFAULT_ID";
  let UTMTerm = "default";

  if (welcomeContent.id) {
    messageId = welcomeContent.id.toUpperCase();
  }

  if (experimentId && branchId) {
    UTMTerm = `${experimentId}-${branchId}`.toLowerCase();
  }

  return {
    messageId,
    UTMTerm
  };
}

async function retrieveRenderContent() {
  // Feature config includes RTAMO attribution data if exists
  // else below data in order specified
  // user prefs
  // experiment data
  // defaults
  let featureConfig = await window.AWGetFeatureConfig();
  let {
    messageId,
    UTMTerm
  } = ComputeTelemetryInfo(featureConfig, featureConfig.slug, featureConfig.branch && featureConfig.branch.slug);
  return {
    featureConfig,
    messageId,
    UTMTerm
  };
}

async function mount() {
  let {
    featureConfig: aboutWelcomeProps,
    messageId,
    UTMTerm
  } = await retrieveRenderContent();
  react_dom__WEBPACK_IMPORTED_MODULE_1___default().render( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(AboutWelcome, _extends({
    messageId: messageId,
    UTMTerm: UTMTerm
  }, aboutWelcomeProps)), document.getElementById("root"));
}

performance.mark("mount");
mount();
})();

/******/ })()
;