# to be included inside a popupset element

    <panel id="notification-popup"
           type="arrow"
           position="after_start"
           hidden="true"
           orient="vertical"
           noautofocus="true"
           role="alert"/>

    <popupnotification id="webRTC-shareDevices-notification" hidden="true"
                       descriptionid="webRTC-shareDevices-notification-description">
      <popupnotificationcontent id="webRTC-selectCamera" orient="vertical">
        <label id="webRTC-selectCamera-label"
               data-l10n-id="popup-select-camera-device"
               control="webRTC-selectCamera-menulist"/>
        <html:div class="webRTC-selectDevice-selector-container">
          <xul:image id="webRTC-selectCamera-icon" class="webRTC-selectDevice-icon" data-l10n-id="popup-select-camera-icon"/>
          <menulist id="webRTC-selectCamera-menulist" aria-labelledby="webRTC-selectCamera-icon" size="large">
            <menupopup id="webRTC-selectCamera-menupopup"/>
          </menulist>
          <label id="webRTC-selectCamera-single-device-label" class="webRTC-selectDevice-label"></label>
        </html:div>
      </popupnotificationcontent>

      <popupnotificationcontent id="webRTC-selectWindowOrScreen" orient="vertical">
        <label id="webRTC-selectWindow-label"
               data-l10n-id="popup-select-window-or-screen"
               control="webRTC-selectWindow-menulist"/>
        <menulist id="webRTC-selectWindow-menulist"
                  oncommand="webrtcUI.updateWarningLabel(this);"
                  size="large">
          <menupopup id="webRTC-selectWindow-menupopup"/>
        </menulist>
        <description id="webRTC-all-windows-shared" hidden="true" data-l10n-id="popup-all-windows-shared"></description>
      </popupnotificationcontent>

      <popupnotificationcontent id="webRTC-preview" hidden="true">
        <html:video id="webRTC-previewVideo" tabindex="-1"/>
        <vbox id="webRTC-previewWarningBox">
          <description id="webRTC-previewWarning"/>
          <hbox>
            <label id="webRTC-previewWarning-learnMore" is="text-link" class="popup-notification-learnmore-link"/>
          </hbox>
        </vbox>
      </popupnotificationcontent>

      <popupnotificationcontent id="webRTC-selectMicrophone" orient="vertical">
        <label id="webRTC-selectMicrophone-label"
               data-l10n-id="popup-select-microphone-device"
               control="webRTC-selectMicrophone-menulist"/>
        <html:div class="webRTC-selectDevice-selector-container">
          <xul:image id="webRTC-selectMicrophone-icon" data-l10n-id="popup-select-microphone-icon" class="webRTC-selectDevice-icon"/>
          <menulist id="webRTC-selectMicrophone-menulist" aria-labelledby="webRTC-selectMicrophone-icon" size="large">
            <menupopup id="webRTC-selectMicrophone-menupopup"/>
          </menulist>
          <label id="webRTC-selectMicrophone-single-device-label" class="webRTC-selectDevice-label"></label>
        </html:div>
      </popupnotificationcontent>

      <popupnotificationcontent id="webRTC-selectSpeaker" orient="vertical">
        <html:div class="webRTC-selectDevice-selector-container">
          <xul:image id="webRTC-selectSpeaker-icon" data-l10n-id="popup-select-speaker-icon" class="webRTC-selectDevice-icon"/>
          <menulist id="webRTC-selectSpeaker-menulist" aria-labelledby="webRTC-selectSpeaker-icon" size="large">
            <menupopup id="webRTC-selectSpeaker-menupopup"/>
          </menulist>
          <label id="webRTC-selectSpeaker-single-device-label" class="webRTC-selectDevice-label"></label>
        </html:div>
      </popupnotificationcontent>
    </popupnotification>

    <popupnotification id="servicesInstall-notification" hidden="true">
      <popupnotificationcontent orient="vertical" align="start">
        <!-- XXX bug 974146, tests are looking for this, can't remove yet. -->
      </popupnotificationcontent>
    </popupnotification>

    <popupnotification id="password-notification" hidden="true">
      <popupnotificationcontent orient="vertical">
        <label data-l10n-id="panel-save-update-username" control="password-notification-username" class="password-notification-label"></label>
        <stack>
          <html:input id="password-notification-username" 
                      type="text"
                      class="ac-has-end-icon"
                      autocompletesearch="login-doorhanger-username"
                      autocompletepopup="PopupAutoComplete"
                      is="autocomplete-input"
                      maxrows="10"
                      maxdropmarkerrows="10"/>
          <dropmarker id="password-notification-username-dropmarker"
                      class="ac-dropmarker"/>
        </stack>
        <label data-l10n-id="panel-save-update-password" control="password-notification-password" class="password-notification-label"></label>
        <stack>
          <html:input id="password-notification-password" type="password"/>
          <dropmarker id="password-notification-password-dropmarker"
                      class="ac-dropmarker"
                      hidden="true"/>
        </stack>
        <checkbox id="password-notification-visibilityToggle" hidden="true"/>
      </popupnotificationcontent>
    </popupnotification>

    <popupnotification id="addon-progress-notification" is="addon-progress-notification" hidden="true">
      <popupnotificationcontent orient="vertical">
        <html:progress id="addon-progress-notification-progressmeter" max="100"/>
        <label id="addon-progress-notification-progresstext" crop="end"/>
      </popupnotificationcontent>
    </popupnotification>

    <popupnotification id="addon-install-confirmation-notification" hidden="true">
      <popupnotificationcontent id="addon-install-confirmation-content" orient="vertical"/>
    </popupnotification>

    <popupnotification id="addon-webext-permissions-notification" hidden="true">
      <popupnotificationcontent class="addon-webext-perm-notification-content" orient="vertical">
        <description id="addon-webext-perm-text" class="addon-webext-perm-text"/>
        <label id="addon-webext-perm-intro" class="addon-webext-perm-text"/>
        <label id="addon-webext-perm-single-entry" class="addon-webext-perm-single-entry"/>
        <html:ul id="addon-webext-perm-list" class="addon-webext-perm-list"/>
        <hbox>
          <label id="addon-webext-perm-info" is="text-link" class="popup-notification-learnmore-link"/>
        </hbox>
      </popupnotificationcontent>
    </popupnotification>

    <popupnotification id="addon-install-blocked-notification" hidden="true">
      <popupnotificationcontent id="addon-install-blocked-content" orient="vertical">
        <description id="addon-install-blocked-message" class="popup-notification-description"></description>
        <hbox>
          <label id="addon-install-blocked-info" class="popup-notification-learnmore-link" is="text-link"/>
        </hbox>
      </popupnotificationcontent>
    </popupnotification>

    <popupnotification id="canvas-permissions-prompt-notification" hidden="true">
      <popupnotificationcontent orient="vertical">
        <description class="popup-notification-description"/>
        <label id="canvas-permissions-prompt-warning"/>
      </popupnotificationcontent>
    </popupnotification>

    <popupnotification id="contextual-feature-recommendation-notification"
                       buttonhighlight="true"
                       hidden="true">
      <popupnotificationheader id="cfr-notification-header">
        <stack id="cfr-notification-header-stack">
          <description id="cfr-notification-header-label"></description>
          <label id="cfr-notification-header-link" is="text-link">
            <xul:image id="cfr-notification-header-image"/>
          </label>
        </stack>
      </popupnotificationheader>
      <popupnotificationcontent>
        <description id="cfr-notification-author"></description>
      </popupnotificationcontent>
      <popupnotificationfooter id="cfr-notification-footer" orient="vertical">
        <vbox id="cfr-notification-footer-text-and-addon-info">
          <description id="cfr-notification-footer-text"/>
          <hbox id="cfr-notification-footer-addon-info">
            <hbox id="cfr-notification-footer-filled-stars"/>
            <hbox id="cfr-notification-footer-empty-stars"/>
            <label id="cfr-notification-footer-users"/>
            <spacer id="cfr-notification-footer-spacer" hidden="true"/>
            <label id="cfr-notification-footer-learn-more-link" is="text-link"/>
          </hbox>
        </vbox>
      </popupnotificationfooter>
    </popupnotification>

    <popupnotification id="identity-credential-notification" hidden="true">
      <popupnotificationcontent id="identity-credential-provider" orient="vertical">
        <html:div id="identity-credential-provider-selector-container">
        </html:div>
        <description class="popup-notification-description" id="credential-provider-explanation" data-l10n-id="identity-credential-description-provider-explanation"/>
        <html:template id="template-credential-provider-list-item">
          <toolbarbutton class="credential-provider-list-item subviewbutton-nav subviewbutton" align="center" wrap="true">
            <label flex="1" class="credential-provider-list-item-label"></label>
          </toolbarbutton>
        </html:template>
      </popupnotificationcontent>
      <popupnotificationcontent id="identity-credential-policy" orient="vertical">
        <description id="identity-credential-policy-explanation"/>
        <label class="text-link" is="text-link" data-l10n-id="identity-credential-privacy-policy" id="identity-credential-privacy-policy"></label>
        <label class="text-link" is="text-link" data-l10n-id="identity-credential-terms-of-service" id="identity-credential-terms-of-service"></label>
      </popupnotificationcontent>
      <popupnotificationcontent id="identity-credential-account" orient="vertical" hidden="true">
        <html:div id="identity-credential-account-selector-container">
        </html:div>
        <description class="popup-notification-description" id="credential-account-explanation"/>
        <html:template id="template-credential-account-list-item">
          <toolbarbutton class="credential-account-list-item subviewbutton-nav subviewbutton" align="center" wrap="true">
            <label flex="1" class="credential-account-list-item-label"></label>
          </toolbarbutton>
        </html:template>
      </popupnotificationcontent>
    </popupnotification>

    <popupnotification id="relay-integration-offer-notification" hidden="true">
      <popupnotificationcontent orient="vertical">
        <html:div>    
          <html:p data-l10n-id="firefox-relay-offer-why-relay"></html:p>
          <html:p data-l10n-id="firefox-relay-offer-how-we-integrate"></html:p>
          <html:p id="firefox-relay-offer-what-relay-does" data-l10n-id="firefox-relay-offer-what-relay-does" data-l10n-args='{"sitename": "", "useremail": ""}'></html:p>
        </html:div>
      </popupnotificationcontent>
    </popupnotification>

    <popupnotification id="relay-integration-reuse-masks-notification" hidden="true">
      <popupnotificationcontent orient="vertical">
        <html:div>
          <html:p class="error-message"></html:p>
          <html:div class="reusable-relay-masks" />
        </html:div>
      </popupnotificationcontent>
    </popupnotification>

    <template id="firefox-relay-header">
      <html:div class="relay-integration-header">
        <html:div />
        <html:span>Firefox</html:span>
        <html:span> Relay</html:span>
      </html:div>
    </template>
