/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */

"use strict";

loadTestSubscript("head_unified_extensions.js");

add_task(async function test_no_addons_themes_widget() {
  if (!gUnifiedExtensions.isEnabled) {
    ok(true, "Skip task because Unified Extensions UI is disabled");
    return;
  }

  const addonsAndThemesWidgetId = "add-ons-button";

  // Add the button to the navbar, which should not do anything because the
  // add-ons and themes button should not exist when the unified extensions
  // pref is enabled.
  CustomizableUI.addWidgetToArea(
    addonsAndThemesWidgetId,
    CustomizableUI.AREA_NAVBAR
  );

  let addonsButton = document.getElementById(addonsAndThemesWidgetId);
  is(addonsButton, null, "expected no add-ons and themes button");
});

/**
 * Tests that if the addons panel is somehow open when customization mode is
 * invoked, that the panel is hidden.
 */
add_task(async function test_hide_panel_when_customizing() {
  let win = await promiseEnableUnifiedExtensions();
  await openExtensionsPanel(win);

  let panel = win.gUnifiedExtensions.panel;
  Assert.equal(panel.state, "open");

  let panelHidden = BrowserTestUtils.waitForPopupEvent(panel, "hidden");
  CustomizableUI.dispatchToolboxEvent("customizationstarting", {}, win);
  await panelHidden;
  Assert.equal(panel.state, "closed");

  await BrowserTestUtils.closeWindow(win);
});
