/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/**
 * This file is generated by browser/components/newtab/bin/import-rollouts.js
 * Run the following from the repository root to regenerate it:
 * ./mach npm run import-rollouts --prefix=browser/components/newtab
 */

export const NimbusRolloutMessageProvider = {
  getMessages() {
    return [
      {
        // Nimbus slug: device-migration-existing-users-sumo-switch-device-cfr-rollout:control
        // Version range: 114+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/device-migration-existing-users-sumo-switch-device-cfr-rollout/summary#control
        id: "CFR_WINDOWS_DEVICE_MIGRATION_SUMO_SWITCH_DEVICE",
        groups: ["cfr"],
        content: {
          text: {
            string_id: "fxa-sync-cfr-body",
          },
          layout: "icon_and_message",
          buttons: {
            primary: {
              label: {
                string_id: "fxa-sync-cfr-primary",
              },
              action: {
                data: {
                  args: "https://support.mozilla.org/1/firefox/%VERSION%/%OS%/%LOCALE%/switching-devices?utm_source=panel-default&utm_medium=firefox-desktop&utm_campaign=migration&utm_content=migrate-learn-more",
                  where: "tabshifted",
                },
                type: "OPEN_URL",
              },
            },
            secondary: [
              {
                label: {
                  string_id: "fxa-sync-cfr-secondary",
                },
                action: {
                  type: "CANCEL",
                },
              },
            ],
          },
          anchor_id: "PanelUI-menu-button",
          bucket_id: "CFR_WINDOWS_DEVICE_MIGRATION_SUMO_SWITCH_DEVICE",
          heading_text: {
            string_id: "fxa-sync-cfr-header",
          },
          skip_address_bar_notifier: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "cfr_doorhanger",
        frequency: {
          custom: [
            {
              cap: 1,
              period: 604800000,
            },
          ],
          lifetime: 3,
        },
        targeting: "isFxASignedIn && !usesFirefoxSync && source == 'newtab'",
      },
      {
        // Nimbus slug: device-migration-existing-user-messaging-tour-spotlight-rollout:control
        // Version range: 114+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/device-migration-existing-user-messaging-tour-spotlight-rollout/summary#control
        id: "WINDOWS_DEVICE_MIGRATION_SUMO_SWITCH_DEVICE",
        groups: ["eco"],
        content: {
          id: "WINDOWS_DEVICE_MIGRATION_SUMO_SWITCH_DEVICE",
          modal: "tab",
          screens: [
            {
              id: "WINDOWS_DEVICE_MIGRATION_SUMO_SWITCH_DEVICE:CONTROL_ROLLOUT",
              content: {
                logo: {
                  height: "211px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/f0f51715-7f5e-48de-839a-f26cc76cbb8b.svg",
                },
                title: {
                  fontSize: "24px",
                  string_id: "device-migration-fxa-spotlight-header",
                  paddingBlock: "20px 0",
                  letterSpacing: 0,
                  paddingInline: "82px",
                },
                subtitle: {
                  fontSize: "15px",
                  string_id: "device-migration-fxa-spotlight-body",
                  lineHeight: "1.4",
                  marginBlock: "8px 20px",
                  letterSpacing: 0,
                  paddingInline: "30px",
                },
                dismiss_button: {
                  action: {
                    data: {
                      id: "WINDOWS_DEVICE_MIGRATION_SUMO_SWITCH_DEVICE",
                    },
                    type: "BLOCK_MESSAGE",
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id: "device-migration-fxa-spotlight-primary-button",
                    paddingBlock: "0",
                  },
                  action: {
                    data: {
                      args: "https://support.mozilla.org/1/firefox/%VERSION%/%OS%/%LOCALE%/switching-devices?utm_source=spotlight-default&utm_medium=firefox-desktop&utm_campaign=migration&utm_content=how-to-backup-data",
                      where: "tabshifted",
                    },
                    type: "OPEN_URL",
                    navigate: true,
                  },
                },
                secondary_button: {
                  label: {
                    string_id: "device-migration-fxa-spotlight-link",
                    marginBlock: "1px -20px",
                  },
                  action: {
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "spotlight",
        frequency: {
          custom: [
            {
              cap: 1,
              period: 4838400000,
            },
          ],
          lifetime: 3,
        },
        targeting:
          "!isFxASignedIn && !willShowDefaultPrompt && !isMajorUpgrade && !activeNotifications",
      },
      {
        // Nimbus slug: updated-import-infrequent-rollout-make-yourself-at-home-copy:control
        // Version range: 107+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/updated-import-infrequent-rollout-make-yourself-at-home-copy/summary#control
        id: "import-infreq-make-self-at-home:treatment-c",
        groups: ["import-spotlights"],
        content: {
          id: "import-infreq-make-self-at-home:treatment-c",
          screens: [
            {
              id: "IMPORT",
              content: {
                logo: {
                  height: "186px",
                  imageURL:
                    "chrome://activity-stream/content/data/content/assets/person-typing.svg",
                },
                title: {
                  fontSize: "26px",
                  string_id: "onboarding-infrequent-import-title",
                  fontWeight: "400",
                  lineHeight: "36px",
                  marginBlock: "6px 0",
                  letterSpacing: "-.01em",
                },
                subtitle: {
                  fontSize: "13px",
                  string_id: "onboarding-infrequent-import-subtitle",
                  lineHeight: "16px",
                  marginBlock: "4px 12px",
                  letterSpacing: ".05px",
                  paddingInline: "48px",
                },
                title_style: "slim",
                primary_button: {
                  label: {
                    string_id: "onboarding-infrequent-import-primary-button",
                    paddingBlock: "6px",
                    paddingInline: "14px",
                  },
                  action: {
                    type: "SHOW_MIGRATION_WIZARD",
                    navigate: true,
                  },
                },
                secondary_button: {
                  label: {
                    fontSize: "13px",
                    string_id: "onboarding-not-now-button-label",
                    lineHeight: "15px",
                    marginBlock: "-4px -28px",
                  },
                  action: {
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        priority: 1,
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "!willShowDefaultPrompt  && !('browser.migrate.content-modal.enabled'|preferenceValue) && source == 'startup' && !isMajorUpgrade && !activeNotifications && totalBookmarksCount == 5",
      },
    ];
  },
};
